// -*-c++-*-
/* This file was automatically generated by rpcc. */

#ifndef __RPCC_NFS3_PROT_H_INCLUDED__
#define __RPCC_NFS3_PROT_H_INCLUDED__ 1

#include "xdrmisc.h"

typedef u_int64_t uint64;
void *uint64_alloc ();
bool_t xdr_uint64 (XDR *, void *);
RPC_TYPEDEF_DECL (uint64)

typedef int64_t int64;
void *int64_alloc ();
bool_t xdr_int64 (XDR *, void *);
RPC_TYPEDEF_DECL (int64)

typedef u_int32_t uint32;
void *uint32_alloc ();
bool_t xdr_uint32 (XDR *, void *);
RPC_TYPEDEF_DECL (uint32)

typedef int32_t int32;
void *int32_alloc ();
bool_t xdr_int32 (XDR *, void *);
RPC_TYPEDEF_DECL (int32)

enum { NFS3_FHSIZE = 64 };
enum { NFS3_COOKIEVERFSIZE = 8 };
enum { NFS3_CREATEVERFSIZE = 8 };
enum { NFS3_WRITEVERFSIZE = 8 };

typedef rpc_str<RPC_INFINITY> filename3;
void *filename3_alloc ();
bool_t xdr_filename3 (XDR *, void *);
RPC_TYPEDEF_DECL (filename3)

typedef rpc_str<RPC_INFINITY> nfspath3;
void *nfspath3_alloc ();
bool_t xdr_nfspath3 (XDR *, void *);
RPC_TYPEDEF_DECL (nfspath3)

typedef rpc_opaque<NFS3_COOKIEVERFSIZE> cookieverf3;
void *cookieverf3_alloc ();
bool_t xdr_cookieverf3 (XDR *, void *);
RPC_TYPEDEF_DECL (cookieverf3)

typedef rpc_opaque<NFS3_CREATEVERFSIZE> createverf3;
void *createverf3_alloc ();
bool_t xdr_createverf3 (XDR *, void *);
RPC_TYPEDEF_DECL (createverf3)

typedef rpc_opaque<NFS3_WRITEVERFSIZE> writeverf3;
void *writeverf3_alloc ();
bool_t xdr_writeverf3 (XDR *, void *);
RPC_TYPEDEF_DECL (writeverf3)

enum nfsstat3 {
  NFS3_OK = 0,
  NFS3ERR_PERM = 1,
  NFS3ERR_NOENT = 2,
  NFS3ERR_IO = 5,
  NFS3ERR_NXIO = 6,
  NFS3ERR_ACCES = 13,
  NFS3ERR_EXIST = 17,
  NFS3ERR_XDEV = 18,
  NFS3ERR_NODEV = 19,
  NFS3ERR_NOTDIR = 20,
  NFS3ERR_ISDIR = 21,
  NFS3ERR_INVAL = 22,
  NFS3ERR_FBIG = 27,
  NFS3ERR_NOSPC = 28,
  NFS3ERR_ROFS = 30,
  NFS3ERR_MLINK = 31,
  NFS3ERR_NAMETOOLONG = 63,
  NFS3ERR_NOTEMPTY = 66,
  NFS3ERR_DQUOT = 69,
  NFS3ERR_STALE = 70,
  NFS3ERR_REMOTE = 71,
  NFS3ERR_BADHANDLE = 10001,
  NFS3ERR_NOT_SYNC = 10002,
  NFS3ERR_BAD_COOKIE = 10003,
  NFS3ERR_NOTSUPP = 10004,
  NFS3ERR_TOOSMALL = 10005,
  NFS3ERR_SERVERFAULT = 10006,
  NFS3ERR_BADTYPE = 10007,
  NFS3ERR_JUKEBOX = 10008,
};
void *nfsstat3_alloc ();
bool_t xdr_nfsstat3 (XDR *, void *);
RPC_ENUM_DECL (nfsstat3)

template<class T> inline bool
rpc_traverse (T &t, nfsstat3 &obj)
{
  u_int32_t val = obj;
  if (!rpc_traverse (t, val))
    return false;
  obj = nfsstat3 (val);
  return true;
}

enum ftype3 {
  NF3REG = 1,
  NF3DIR = 2,
  NF3BLK = 3,
  NF3CHR = 4,
  NF3LNK = 5,
  NF3SOCK = 6,
  NF3FIFO = 7,
};
void *ftype3_alloc ();
bool_t xdr_ftype3 (XDR *, void *);
RPC_ENUM_DECL (ftype3)

template<class T> inline bool
rpc_traverse (T &t, ftype3 &obj)
{
  u_int32_t val = obj;
  if (!rpc_traverse (t, val))
    return false;
  obj = ftype3 (val);
  return true;
}


struct specdata3 {
  uint32 major;
  uint32 minor;
};
void *specdata3_alloc ();
bool_t xdr_specdata3 (XDR *, void *);
RPC_STRUCT_DECL (specdata3)

template<class T> bool
rpc_traverse (T &t, specdata3 &obj)
{
  return rpc_traverse (t, obj.major)
    && rpc_traverse (t, obj.minor);
}



struct nfs_fh3 {
  rpc_bytes<NFS3_FHSIZE> data;
};
void *nfs_fh3_alloc ();
bool_t xdr_nfs_fh3 (XDR *, void *);
RPC_STRUCT_DECL (nfs_fh3)

template<class T> inline bool
rpc_traverse (T &t, nfs_fh3 &obj)
{
  return rpc_traverse (t, obj.data);
}



struct nfstime3 {
  uint32 seconds;
  uint32 nseconds;
};
void *nfstime3_alloc ();
bool_t xdr_nfstime3 (XDR *, void *);
RPC_STRUCT_DECL (nfstime3)

template<class T> bool
rpc_traverse (T &t, nfstime3 &obj)
{
  return rpc_traverse (t, obj.seconds)
    && rpc_traverse (t, obj.nseconds);
}



struct fattr3 {
  ftype3 type;
  uint32 mode;
  uint32 nlink;
  uint32 uid;
  uint32 gid;
  uint64 size;
  uint64 used;
  specdata3 rdev;
  uint64 fsid;
  uint64 fileid;
  nfstime3 atime;
  nfstime3 mtime;
  nfstime3 ctime;
};
void *fattr3_alloc ();
bool_t xdr_fattr3 (XDR *, void *);
RPC_STRUCT_DECL (fattr3)

template<class T> bool
rpc_traverse (T &t, fattr3 &obj)
{
  return rpc_traverse (t, obj.type)
    && rpc_traverse (t, obj.mode)
    && rpc_traverse (t, obj.nlink)
    && rpc_traverse (t, obj.uid)
    && rpc_traverse (t, obj.gid)
    && rpc_traverse (t, obj.size)
    && rpc_traverse (t, obj.used)
    && rpc_traverse (t, obj.rdev)
    && rpc_traverse (t, obj.fsid)
    && rpc_traverse (t, obj.fileid)
    && rpc_traverse (t, obj.atime)
    && rpc_traverse (t, obj.mtime)
    && rpc_traverse (t, obj.ctime);
}



struct post_op_attr {
  const bool present;
  union {
    union_entry_base _base;
    union_entry<fattr3> attributes;
  };

#define rpcunion_tag_post_op_attr present
#define rpcunion_switch_post_op_attr(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case true: \
    action (fattr3, attributes); \
    break; \
  case false: \
    voidaction; \
    break; \
  default: \
    defaction; \
    break; \
  }

  post_op_attr (bool _tag = (bool) 0) : present (_tag)
    { _base.init (); set_present (_tag); }
  post_op_attr (const post_op_attr &_s)
    : present (_s.present)
    { _base.init (_s._base); }
  ~post_op_attr () { _base.destroy (); }
  post_op_attr &operator= (const post_op_attr &_s) {
    const_cast<bool &> (present) = _s.present;
    _base.assign (_s._base);
    return *this;
  }

  void set_present (bool _tag) {
    const_cast<bool &> (present) = _tag;
    rpcunion_switch_post_op_attr
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, post_op_attr &obj)
{
  bool tag = obj.present;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.present)
    obj.set_present (tag);

  rpcunion_switch_post_op_attr
    (obj.present, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, post_op_attr &obj)
{
  rpcunion_switch_post_op_attr
    (obj.present, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *post_op_attr_alloc ();
bool_t xdr_post_op_attr (XDR *, void *);
RPC_UNION_DECL (post_op_attr)



struct wcc_attr {
  uint64 size;
  nfstime3 mtime;
  nfstime3 ctime;
};
void *wcc_attr_alloc ();
bool_t xdr_wcc_attr (XDR *, void *);
RPC_STRUCT_DECL (wcc_attr)

template<class T> bool
rpc_traverse (T &t, wcc_attr &obj)
{
  return rpc_traverse (t, obj.size)
    && rpc_traverse (t, obj.mtime)
    && rpc_traverse (t, obj.ctime);
}



struct pre_op_attr {
  const bool present;
  union {
    union_entry_base _base;
    union_entry<wcc_attr> attributes;
  };

#define rpcunion_tag_pre_op_attr present
#define rpcunion_switch_pre_op_attr(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case true: \
    action (wcc_attr, attributes); \
    break; \
  case false: \
    voidaction; \
    break; \
  default: \
    defaction; \
    break; \
  }

  pre_op_attr (bool _tag = (bool) 0) : present (_tag)
    { _base.init (); set_present (_tag); }
  pre_op_attr (const pre_op_attr &_s)
    : present (_s.present)
    { _base.init (_s._base); }
  ~pre_op_attr () { _base.destroy (); }
  pre_op_attr &operator= (const pre_op_attr &_s) {
    const_cast<bool &> (present) = _s.present;
    _base.assign (_s._base);
    return *this;
  }

  void set_present (bool _tag) {
    const_cast<bool &> (present) = _tag;
    rpcunion_switch_pre_op_attr
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, pre_op_attr &obj)
{
  bool tag = obj.present;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.present)
    obj.set_present (tag);

  rpcunion_switch_pre_op_attr
    (obj.present, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, pre_op_attr &obj)
{
  rpcunion_switch_pre_op_attr
    (obj.present, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *pre_op_attr_alloc ();
bool_t xdr_pre_op_attr (XDR *, void *);
RPC_UNION_DECL (pre_op_attr)



struct wcc_data {
  pre_op_attr before;
  post_op_attr after;
};
void *wcc_data_alloc ();
bool_t xdr_wcc_data (XDR *, void *);
RPC_STRUCT_DECL (wcc_data)

template<class T> bool
rpc_traverse (T &t, wcc_data &obj)
{
  return rpc_traverse (t, obj.before)
    && rpc_traverse (t, obj.after);
}



struct post_op_fh3 {
  const bool present;
  union {
    union_entry_base _base;
    union_entry<nfs_fh3> handle;
  };

#define rpcunion_tag_post_op_fh3 present
#define rpcunion_switch_post_op_fh3(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case true: \
    action (nfs_fh3, handle); \
    break; \
  case false: \
    voidaction; \
    break; \
  default: \
    defaction; \
    break; \
  }

  post_op_fh3 (bool _tag = (bool) 0) : present (_tag)
    { _base.init (); set_present (_tag); }
  post_op_fh3 (const post_op_fh3 &_s)
    : present (_s.present)
    { _base.init (_s._base); }
  ~post_op_fh3 () { _base.destroy (); }
  post_op_fh3 &operator= (const post_op_fh3 &_s) {
    const_cast<bool &> (present) = _s.present;
    _base.assign (_s._base);
    return *this;
  }

  void set_present (bool _tag) {
    const_cast<bool &> (present) = _tag;
    rpcunion_switch_post_op_fh3
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, post_op_fh3 &obj)
{
  bool tag = obj.present;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.present)
    obj.set_present (tag);

  rpcunion_switch_post_op_fh3
    (obj.present, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, post_op_fh3 &obj)
{
  rpcunion_switch_post_op_fh3
    (obj.present, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *post_op_fh3_alloc ();
bool_t xdr_post_op_fh3 (XDR *, void *);
RPC_UNION_DECL (post_op_fh3)



struct set_uint32 {
  const bool set;
  union {
    union_entry_base _base;
    union_entry<uint32> val;
  };

#define rpcunion_tag_set_uint32 set
#define rpcunion_switch_set_uint32(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case true: \
    action (uint32, val); \
    break; \
  default: \
    voidaction; \
    break; \
  }

  set_uint32 (bool _tag = (bool) 0) : set (_tag)
    { _base.init (); set_set (_tag); }
  set_uint32 (const set_uint32 &_s)
    : set (_s.set)
    { _base.init (_s._base); }
  ~set_uint32 () { _base.destroy (); }
  set_uint32 &operator= (const set_uint32 &_s) {
    const_cast<bool &> (set) = _s.set;
    _base.assign (_s._base);
    return *this;
  }

  void set_set (bool _tag) {
    const_cast<bool &> (set) = _tag;
    rpcunion_switch_set_uint32
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, set_uint32 &obj)
{
  bool tag = obj.set;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.set)
    obj.set_set (tag);

  rpcunion_switch_set_uint32
    (obj.set, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, set_uint32 &obj)
{
  rpcunion_switch_set_uint32
    (obj.set, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *set_uint32_alloc ();
bool_t xdr_set_uint32 (XDR *, void *);
RPC_UNION_DECL (set_uint32)



struct set_uint64 {
  const bool set;
  union {
    union_entry_base _base;
    union_entry<uint64> val;
  };

#define rpcunion_tag_set_uint64 set
#define rpcunion_switch_set_uint64(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case true: \
    action (uint64, val); \
    break; \
  default: \
    voidaction; \
    break; \
  }

  set_uint64 (bool _tag = (bool) 0) : set (_tag)
    { _base.init (); set_set (_tag); }
  set_uint64 (const set_uint64 &_s)
    : set (_s.set)
    { _base.init (_s._base); }
  ~set_uint64 () { _base.destroy (); }
  set_uint64 &operator= (const set_uint64 &_s) {
    const_cast<bool &> (set) = _s.set;
    _base.assign (_s._base);
    return *this;
  }

  void set_set (bool _tag) {
    const_cast<bool &> (set) = _tag;
    rpcunion_switch_set_uint64
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, set_uint64 &obj)
{
  bool tag = obj.set;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.set)
    obj.set_set (tag);

  rpcunion_switch_set_uint64
    (obj.set, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, set_uint64 &obj)
{
  rpcunion_switch_set_uint64
    (obj.set, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *set_uint64_alloc ();
bool_t xdr_set_uint64 (XDR *, void *);
RPC_UNION_DECL (set_uint64)


enum time_how {
  DONT_CHANGE = 0,
  SET_TO_SERVER_TIME = 1,
  SET_TO_CLIENT_TIME = 2,
};
void *time_how_alloc ();
bool_t xdr_time_how (XDR *, void *);
RPC_ENUM_DECL (time_how)

template<class T> inline bool
rpc_traverse (T &t, time_how &obj)
{
  u_int32_t val = obj;
  if (!rpc_traverse (t, val))
    return false;
  obj = time_how (val);
  return true;
}


struct set_time {
  const time_how set;
  union {
    union_entry_base _base;
    union_entry<nfstime3> time;
  };

#define rpcunion_tag_set_time set
#define rpcunion_switch_set_time(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case SET_TO_CLIENT_TIME: \
    action (nfstime3, time); \
    break; \
  default: \
    voidaction; \
    break; \
  }

  set_time (time_how _tag = (time_how) 0) : set (_tag)
    { _base.init (); set_set (_tag); }
  set_time (const set_time &_s)
    : set (_s.set)
    { _base.init (_s._base); }
  ~set_time () { _base.destroy (); }
  set_time &operator= (const set_time &_s) {
    const_cast<time_how &> (set) = _s.set;
    _base.assign (_s._base);
    return *this;
  }

  void set_set (time_how _tag) {
    const_cast<time_how &> (set) = _tag;
    rpcunion_switch_set_time
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, set_time &obj)
{
  time_how tag = obj.set;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.set)
    obj.set_set (tag);

  rpcunion_switch_set_time
    (obj.set, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, set_time &obj)
{
  rpcunion_switch_set_time
    (obj.set, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *set_time_alloc ();
bool_t xdr_set_time (XDR *, void *);
RPC_UNION_DECL (set_time)



struct sattr3 {
  set_uint32 mode;
  set_uint32 uid;
  set_uint32 gid;
  set_uint64 size;
  set_time atime;
  set_time mtime;
};
void *sattr3_alloc ();
bool_t xdr_sattr3 (XDR *, void *);
RPC_STRUCT_DECL (sattr3)

template<class T> bool
rpc_traverse (T &t, sattr3 &obj)
{
  return rpc_traverse (t, obj.mode)
    && rpc_traverse (t, obj.uid)
    && rpc_traverse (t, obj.gid)
    && rpc_traverse (t, obj.size)
    && rpc_traverse (t, obj.atime)
    && rpc_traverse (t, obj.mtime);
}



struct diropargs3 {
  nfs_fh3 dir;
  filename3 name;
};
void *diropargs3_alloc ();
bool_t xdr_diropargs3 (XDR *, void *);
RPC_STRUCT_DECL (diropargs3)

template<class T> bool
rpc_traverse (T &t, diropargs3 &obj)
{
  return rpc_traverse (t, obj.dir)
    && rpc_traverse (t, obj.name);
}



struct diropres3ok {
  post_op_fh3 obj;
  post_op_attr obj_attributes;
  wcc_data dir_wcc;
};
void *diropres3ok_alloc ();
bool_t xdr_diropres3ok (XDR *, void *);
RPC_STRUCT_DECL (diropres3ok)

template<class T> bool
rpc_traverse (T &t, diropres3ok &obj)
{
  return rpc_traverse (t, obj.obj)
    && rpc_traverse (t, obj.obj_attributes)
    && rpc_traverse (t, obj.dir_wcc);
}



struct diropres3 {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<diropres3ok> resok;
    union_entry<wcc_data> resfail;
  };

#define rpcunion_tag_diropres3 status
#define rpcunion_switch_diropres3(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (diropres3ok, resok); \
    break; \
  default: \
    action (wcc_data, resfail); \
    break; \
  }

  diropres3 (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  diropres3 (const diropres3 &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~diropres3 () { _base.destroy (); }
  diropres3 &operator= (const diropres3 &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_diropres3
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, diropres3 &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_diropres3
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, diropres3 &obj)
{
  rpcunion_switch_diropres3
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *diropres3_alloc ();
bool_t xdr_diropres3 (XDR *, void *);
RPC_UNION_DECL (diropres3)



struct wccstat3 {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<wcc_data> wcc;
  };

#define rpcunion_tag_wccstat3 status
#define rpcunion_switch_wccstat3(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case -1: \
    voidaction; \
    break; \
  default: \
    action (wcc_data, wcc); \
    break; \
  }

  wccstat3 (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  wccstat3 (const wccstat3 &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~wccstat3 () { _base.destroy (); }
  wccstat3 &operator= (const wccstat3 &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_wccstat3
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, wccstat3 &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_wccstat3
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, wccstat3 &obj)
{
  rpcunion_switch_wccstat3
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *wccstat3_alloc ();
bool_t xdr_wccstat3 (XDR *, void *);
RPC_UNION_DECL (wccstat3)



struct getattr3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<fattr3> attributes;
  };

#define rpcunion_tag_getattr3res status
#define rpcunion_switch_getattr3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (fattr3, attributes); \
    break; \
  default: \
    voidaction; \
    break; \
  }

  getattr3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  getattr3res (const getattr3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~getattr3res () { _base.destroy (); }
  getattr3res &operator= (const getattr3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_getattr3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, getattr3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_getattr3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, getattr3res &obj)
{
  rpcunion_switch_getattr3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *getattr3res_alloc ();
bool_t xdr_getattr3res (XDR *, void *);
RPC_UNION_DECL (getattr3res)



struct sattrguard3 {
  const bool check;
  union {
    union_entry_base _base;
    union_entry<nfstime3> ctime;
  };

#define rpcunion_tag_sattrguard3 check
#define rpcunion_switch_sattrguard3(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case true: \
    action (nfstime3, ctime); \
    break; \
  case false: \
    voidaction; \
    break; \
  default: \
    defaction; \
    break; \
  }

  sattrguard3 (bool _tag = (bool) 0) : check (_tag)
    { _base.init (); set_check (_tag); }
  sattrguard3 (const sattrguard3 &_s)
    : check (_s.check)
    { _base.init (_s._base); }
  ~sattrguard3 () { _base.destroy (); }
  sattrguard3 &operator= (const sattrguard3 &_s) {
    const_cast<bool &> (check) = _s.check;
    _base.assign (_s._base);
    return *this;
  }

  void set_check (bool _tag) {
    const_cast<bool &> (check) = _tag;
    rpcunion_switch_sattrguard3
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, sattrguard3 &obj)
{
  bool tag = obj.check;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.check)
    obj.set_check (tag);

  rpcunion_switch_sattrguard3
    (obj.check, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, sattrguard3 &obj)
{
  rpcunion_switch_sattrguard3
    (obj.check, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *sattrguard3_alloc ();
bool_t xdr_sattrguard3 (XDR *, void *);
RPC_UNION_DECL (sattrguard3)



struct setattr3args {
  nfs_fh3 object;
  sattr3 new_attributes;
  sattrguard3 guard;
};
void *setattr3args_alloc ();
bool_t xdr_setattr3args (XDR *, void *);
RPC_STRUCT_DECL (setattr3args)

template<class T> bool
rpc_traverse (T &t, setattr3args &obj)
{
  return rpc_traverse (t, obj.object)
    && rpc_traverse (t, obj.new_attributes)
    && rpc_traverse (t, obj.guard);
}



struct lookup3resok {
  nfs_fh3 object;
  post_op_attr obj_attributes;
  post_op_attr dir_attributes;
};
void *lookup3resok_alloc ();
bool_t xdr_lookup3resok (XDR *, void *);
RPC_STRUCT_DECL (lookup3resok)

template<class T> bool
rpc_traverse (T &t, lookup3resok &obj)
{
  return rpc_traverse (t, obj.object)
    && rpc_traverse (t, obj.obj_attributes)
    && rpc_traverse (t, obj.dir_attributes);
}



struct lookup3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<lookup3resok> resok;
    union_entry<post_op_attr> resfail;
  };

#define rpcunion_tag_lookup3res status
#define rpcunion_switch_lookup3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (lookup3resok, resok); \
    break; \
  default: \
    action (post_op_attr, resfail); \
    break; \
  }

  lookup3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  lookup3res (const lookup3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~lookup3res () { _base.destroy (); }
  lookup3res &operator= (const lookup3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_lookup3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, lookup3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_lookup3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, lookup3res &obj)
{
  rpcunion_switch_lookup3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *lookup3res_alloc ();
bool_t xdr_lookup3res (XDR *, void *);
RPC_UNION_DECL (lookup3res)


enum { ACCESS3_READ = 0x0001 };
enum { ACCESS3_LOOKUP = 0x0002 };
enum { ACCESS3_MODIFY = 0x0004 };
enum { ACCESS3_EXTEND = 0x0008 };
enum { ACCESS3_DELETE = 0x0010 };
enum { ACCESS3_EXECUTE = 0x0020 };


struct access3args {
  nfs_fh3 object;
  uint32 access;
};
void *access3args_alloc ();
bool_t xdr_access3args (XDR *, void *);
RPC_STRUCT_DECL (access3args)

template<class T> bool
rpc_traverse (T &t, access3args &obj)
{
  return rpc_traverse (t, obj.object)
    && rpc_traverse (t, obj.access);
}



struct access3resok {
  post_op_attr obj_attributes;
  uint32 access;
};
void *access3resok_alloc ();
bool_t xdr_access3resok (XDR *, void *);
RPC_STRUCT_DECL (access3resok)

template<class T> bool
rpc_traverse (T &t, access3resok &obj)
{
  return rpc_traverse (t, obj.obj_attributes)
    && rpc_traverse (t, obj.access);
}



struct access3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<access3resok> resok;
    union_entry<post_op_attr> resfail;
  };

#define rpcunion_tag_access3res status
#define rpcunion_switch_access3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (access3resok, resok); \
    break; \
  default: \
    action (post_op_attr, resfail); \
    break; \
  }

  access3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  access3res (const access3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~access3res () { _base.destroy (); }
  access3res &operator= (const access3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_access3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, access3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_access3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, access3res &obj)
{
  rpcunion_switch_access3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *access3res_alloc ();
bool_t xdr_access3res (XDR *, void *);
RPC_UNION_DECL (access3res)



struct readlink3resok {
  post_op_attr symlink_attributes;
  nfspath3 data;
};
void *readlink3resok_alloc ();
bool_t xdr_readlink3resok (XDR *, void *);
RPC_STRUCT_DECL (readlink3resok)

template<class T> bool
rpc_traverse (T &t, readlink3resok &obj)
{
  return rpc_traverse (t, obj.symlink_attributes)
    && rpc_traverse (t, obj.data);
}



struct readlink3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<readlink3resok> resok;
    union_entry<post_op_attr> resfail;
  };

#define rpcunion_tag_readlink3res status
#define rpcunion_switch_readlink3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (readlink3resok, resok); \
    break; \
  default: \
    action (post_op_attr, resfail); \
    break; \
  }

  readlink3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  readlink3res (const readlink3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~readlink3res () { _base.destroy (); }
  readlink3res &operator= (const readlink3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_readlink3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, readlink3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_readlink3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, readlink3res &obj)
{
  rpcunion_switch_readlink3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *readlink3res_alloc ();
bool_t xdr_readlink3res (XDR *, void *);
RPC_UNION_DECL (readlink3res)



struct read3args {
  nfs_fh3 file;
  uint64 offset;
  uint32 count;
};
void *read3args_alloc ();
bool_t xdr_read3args (XDR *, void *);
RPC_STRUCT_DECL (read3args)

template<class T> bool
rpc_traverse (T &t, read3args &obj)
{
  return rpc_traverse (t, obj.file)
    && rpc_traverse (t, obj.offset)
    && rpc_traverse (t, obj.count);
}



struct read3resok {
  post_op_attr file_attributes;
  uint32 count;
  bool eof;
  rpc_bytes<RPC_INFINITY> data;
};
void *read3resok_alloc ();
bool_t xdr_read3resok (XDR *, void *);
RPC_STRUCT_DECL (read3resok)

template<class T> bool
rpc_traverse (T &t, read3resok &obj)
{
  return rpc_traverse (t, obj.file_attributes)
    && rpc_traverse (t, obj.count)
    && rpc_traverse (t, obj.eof)
    && rpc_traverse (t, obj.data);
}



struct read3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<read3resok> resok;
    union_entry<post_op_attr> resfail;
  };

#define rpcunion_tag_read3res status
#define rpcunion_switch_read3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (read3resok, resok); \
    break; \
  default: \
    action (post_op_attr, resfail); \
    break; \
  }

  read3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  read3res (const read3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~read3res () { _base.destroy (); }
  read3res &operator= (const read3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_read3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, read3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_read3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, read3res &obj)
{
  rpcunion_switch_read3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *read3res_alloc ();
bool_t xdr_read3res (XDR *, void *);
RPC_UNION_DECL (read3res)


enum stable_how {
  UNSTABLE = 0,
  DATA_SYNC = 1,
  FILE_SYNC = 2,
};
void *stable_how_alloc ();
bool_t xdr_stable_how (XDR *, void *);
RPC_ENUM_DECL (stable_how)

template<class T> inline bool
rpc_traverse (T &t, stable_how &obj)
{
  u_int32_t val = obj;
  if (!rpc_traverse (t, val))
    return false;
  obj = stable_how (val);
  return true;
}


struct write3args {
  nfs_fh3 file;
  uint64 offset;
  uint32 count;
  stable_how stable;
  rpc_bytes<RPC_INFINITY> data;
};
void *write3args_alloc ();
bool_t xdr_write3args (XDR *, void *);
RPC_STRUCT_DECL (write3args)

template<class T> bool
rpc_traverse (T &t, write3args &obj)
{
  return rpc_traverse (t, obj.file)
    && rpc_traverse (t, obj.offset)
    && rpc_traverse (t, obj.count)
    && rpc_traverse (t, obj.stable)
    && rpc_traverse (t, obj.data);
}



struct write3resok {
  wcc_data file_wcc;
  uint32 count;
  stable_how committed;
  writeverf3 verf;
};
void *write3resok_alloc ();
bool_t xdr_write3resok (XDR *, void *);
RPC_STRUCT_DECL (write3resok)

template<class T> bool
rpc_traverse (T &t, write3resok &obj)
{
  return rpc_traverse (t, obj.file_wcc)
    && rpc_traverse (t, obj.count)
    && rpc_traverse (t, obj.committed)
    && rpc_traverse (t, obj.verf);
}



struct write3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<write3resok> resok;
    union_entry<wcc_data> resfail;
  };

#define rpcunion_tag_write3res status
#define rpcunion_switch_write3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (write3resok, resok); \
    break; \
  default: \
    action (wcc_data, resfail); \
    break; \
  }

  write3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  write3res (const write3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~write3res () { _base.destroy (); }
  write3res &operator= (const write3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_write3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, write3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_write3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, write3res &obj)
{
  rpcunion_switch_write3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *write3res_alloc ();
bool_t xdr_write3res (XDR *, void *);
RPC_UNION_DECL (write3res)


enum createmode3 {
  UNCHECKED = 0,
  GUARDED = 1,
  EXCLUSIVE = 2,
};
void *createmode3_alloc ();
bool_t xdr_createmode3 (XDR *, void *);
RPC_ENUM_DECL (createmode3)

template<class T> inline bool
rpc_traverse (T &t, createmode3 &obj)
{
  u_int32_t val = obj;
  if (!rpc_traverse (t, val))
    return false;
  obj = createmode3 (val);
  return true;
}


struct createhow3 {
  const createmode3 mode;
  union {
    union_entry_base _base;
    union_entry<sattr3> obj_attributes;
    union_entry<createverf3> verf;
  };

#define rpcunion_tag_createhow3 mode
#define rpcunion_switch_createhow3(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case UNCHECKED: \
  case GUARDED: \
    action (sattr3, obj_attributes); \
    break; \
  case EXCLUSIVE: \
    action (createverf3, verf); \
    break; \
  default: \
    defaction; \
    break; \
  }

  createhow3 (createmode3 _tag = (createmode3) 0) : mode (_tag)
    { _base.init (); set_mode (_tag); }
  createhow3 (const createhow3 &_s)
    : mode (_s.mode)
    { _base.init (_s._base); }
  ~createhow3 () { _base.destroy (); }
  createhow3 &operator= (const createhow3 &_s) {
    const_cast<createmode3 &> (mode) = _s.mode;
    _base.assign (_s._base);
    return *this;
  }

  void set_mode (createmode3 _tag) {
    const_cast<createmode3 &> (mode) = _tag;
    rpcunion_switch_createhow3
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, createhow3 &obj)
{
  createmode3 tag = obj.mode;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.mode)
    obj.set_mode (tag);

  rpcunion_switch_createhow3
    (obj.mode, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, createhow3 &obj)
{
  rpcunion_switch_createhow3
    (obj.mode, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *createhow3_alloc ();
bool_t xdr_createhow3 (XDR *, void *);
RPC_UNION_DECL (createhow3)



struct create3args {
  diropargs3 where;
  createhow3 how;
};
void *create3args_alloc ();
bool_t xdr_create3args (XDR *, void *);
RPC_STRUCT_DECL (create3args)

template<class T> bool
rpc_traverse (T &t, create3args &obj)
{
  return rpc_traverse (t, obj.where)
    && rpc_traverse (t, obj.how);
}



struct mkdir3args {
  diropargs3 where;
  sattr3 attributes;
};
void *mkdir3args_alloc ();
bool_t xdr_mkdir3args (XDR *, void *);
RPC_STRUCT_DECL (mkdir3args)

template<class T> bool
rpc_traverse (T &t, mkdir3args &obj)
{
  return rpc_traverse (t, obj.where)
    && rpc_traverse (t, obj.attributes);
}



struct symlinkdata3 {
  sattr3 symlink_attributes;
  nfspath3 symlink_data;
};
void *symlinkdata3_alloc ();
bool_t xdr_symlinkdata3 (XDR *, void *);
RPC_STRUCT_DECL (symlinkdata3)

template<class T> bool
rpc_traverse (T &t, symlinkdata3 &obj)
{
  return rpc_traverse (t, obj.symlink_attributes)
    && rpc_traverse (t, obj.symlink_data);
}



struct symlink3args {
  diropargs3 where;
  symlinkdata3 symlink;
};
void *symlink3args_alloc ();
bool_t xdr_symlink3args (XDR *, void *);
RPC_STRUCT_DECL (symlink3args)

template<class T> bool
rpc_traverse (T &t, symlink3args &obj)
{
  return rpc_traverse (t, obj.where)
    && rpc_traverse (t, obj.symlink);
}



struct devicedata3 {
  sattr3 dev_attributes;
  specdata3 spec;
};
void *devicedata3_alloc ();
bool_t xdr_devicedata3 (XDR *, void *);
RPC_STRUCT_DECL (devicedata3)

template<class T> bool
rpc_traverse (T &t, devicedata3 &obj)
{
  return rpc_traverse (t, obj.dev_attributes)
    && rpc_traverse (t, obj.spec);
}



struct mknoddata3 {
  const ftype3 type;
  union {
    union_entry_base _base;
    union_entry<devicedata3> device;
    union_entry<sattr3> pipe_attributes;
  };

#define rpcunion_tag_mknoddata3 type
#define rpcunion_switch_mknoddata3(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NF3CHR: \
  case NF3BLK: \
    action (devicedata3, device); \
    break; \
  case NF3SOCK: \
  case NF3FIFO: \
    action (sattr3, pipe_attributes); \
    break; \
  default: \
    voidaction; \
    break; \
  }

  mknoddata3 (ftype3 _tag = (ftype3) 0) : type (_tag)
    { _base.init (); set_type (_tag); }
  mknoddata3 (const mknoddata3 &_s)
    : type (_s.type)
    { _base.init (_s._base); }
  ~mknoddata3 () { _base.destroy (); }
  mknoddata3 &operator= (const mknoddata3 &_s) {
    const_cast<ftype3 &> (type) = _s.type;
    _base.assign (_s._base);
    return *this;
  }

  void set_type (ftype3 _tag) {
    const_cast<ftype3 &> (type) = _tag;
    rpcunion_switch_mknoddata3
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, mknoddata3 &obj)
{
  ftype3 tag = obj.type;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.type)
    obj.set_type (tag);

  rpcunion_switch_mknoddata3
    (obj.type, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, mknoddata3 &obj)
{
  rpcunion_switch_mknoddata3
    (obj.type, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *mknoddata3_alloc ();
bool_t xdr_mknoddata3 (XDR *, void *);
RPC_UNION_DECL (mknoddata3)



struct mknod3args {
  diropargs3 where;
  mknoddata3 what;
};
void *mknod3args_alloc ();
bool_t xdr_mknod3args (XDR *, void *);
RPC_STRUCT_DECL (mknod3args)

template<class T> bool
rpc_traverse (T &t, mknod3args &obj)
{
  return rpc_traverse (t, obj.where)
    && rpc_traverse (t, obj.what);
}



struct rename3args {
  diropargs3 from;
  diropargs3 to;
};
void *rename3args_alloc ();
bool_t xdr_rename3args (XDR *, void *);
RPC_STRUCT_DECL (rename3args)

template<class T> bool
rpc_traverse (T &t, rename3args &obj)
{
  return rpc_traverse (t, obj.from)
    && rpc_traverse (t, obj.to);
}



struct rename3wcc {
  wcc_data fromdir_wcc;
  wcc_data todir_wcc;
};
void *rename3wcc_alloc ();
bool_t xdr_rename3wcc (XDR *, void *);
RPC_STRUCT_DECL (rename3wcc)

template<class T> bool
rpc_traverse (T &t, rename3wcc &obj)
{
  return rpc_traverse (t, obj.fromdir_wcc)
    && rpc_traverse (t, obj.todir_wcc);
}



struct rename3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<rename3wcc> res;
  };

#define rpcunion_tag_rename3res status
#define rpcunion_switch_rename3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case -1: \
    voidaction; \
    break; \
  default: \
    action (rename3wcc, res); \
    break; \
  }

  rename3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  rename3res (const rename3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~rename3res () { _base.destroy (); }
  rename3res &operator= (const rename3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_rename3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, rename3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_rename3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, rename3res &obj)
{
  rpcunion_switch_rename3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *rename3res_alloc ();
bool_t xdr_rename3res (XDR *, void *);
RPC_UNION_DECL (rename3res)



struct link3args {
  nfs_fh3 file;
  diropargs3 link;
};
void *link3args_alloc ();
bool_t xdr_link3args (XDR *, void *);
RPC_STRUCT_DECL (link3args)

template<class T> bool
rpc_traverse (T &t, link3args &obj)
{
  return rpc_traverse (t, obj.file)
    && rpc_traverse (t, obj.link);
}



struct link3wcc {
  post_op_attr file_attributes;
  wcc_data linkdir_wcc;
};
void *link3wcc_alloc ();
bool_t xdr_link3wcc (XDR *, void *);
RPC_STRUCT_DECL (link3wcc)

template<class T> bool
rpc_traverse (T &t, link3wcc &obj)
{
  return rpc_traverse (t, obj.file_attributes)
    && rpc_traverse (t, obj.linkdir_wcc);
}



struct link3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<link3wcc> res;
  };

#define rpcunion_tag_link3res status
#define rpcunion_switch_link3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case -1: \
    voidaction; \
    break; \
  default: \
    action (link3wcc, res); \
    break; \
  }

  link3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  link3res (const link3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~link3res () { _base.destroy (); }
  link3res &operator= (const link3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_link3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, link3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_link3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, link3res &obj)
{
  rpcunion_switch_link3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *link3res_alloc ();
bool_t xdr_link3res (XDR *, void *);
RPC_UNION_DECL (link3res)



struct readdir3args {
  nfs_fh3 dir;
  uint64 cookie;
  cookieverf3 cookieverf;
  uint32 count;
};
void *readdir3args_alloc ();
bool_t xdr_readdir3args (XDR *, void *);
RPC_STRUCT_DECL (readdir3args)

template<class T> bool
rpc_traverse (T &t, readdir3args &obj)
{
  return rpc_traverse (t, obj.dir)
    && rpc_traverse (t, obj.cookie)
    && rpc_traverse (t, obj.cookieverf)
    && rpc_traverse (t, obj.count);
}



struct entry3 {
  uint64 fileid;
  filename3 name;
  uint64 cookie;
  rpc_ptr<entry3> nextentry;
};
void *entry3_alloc ();
bool_t xdr_entry3 (XDR *, void *);
RPC_STRUCT_DECL (entry3)

template<class T> bool
rpc_traverse (T &t, entry3 &obj)
{
  return rpc_traverse (t, obj.fileid)
    && rpc_traverse (t, obj.name)
    && rpc_traverse (t, obj.cookie)
    && rpc_traverse (t, obj.nextentry);
}



struct dirlist3 {
  rpc_ptr<entry3> entries;
  bool eof;
};
void *dirlist3_alloc ();
bool_t xdr_dirlist3 (XDR *, void *);
RPC_STRUCT_DECL (dirlist3)

template<class T> bool
rpc_traverse (T &t, dirlist3 &obj)
{
  return rpc_traverse (t, obj.entries)
    && rpc_traverse (t, obj.eof);
}



struct readdir3resok {
  post_op_attr dir_attributes;
  cookieverf3 cookieverf;
  dirlist3 reply;
};
void *readdir3resok_alloc ();
bool_t xdr_readdir3resok (XDR *, void *);
RPC_STRUCT_DECL (readdir3resok)

template<class T> bool
rpc_traverse (T &t, readdir3resok &obj)
{
  return rpc_traverse (t, obj.dir_attributes)
    && rpc_traverse (t, obj.cookieverf)
    && rpc_traverse (t, obj.reply);
}



struct readdir3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<readdir3resok> resok;
    union_entry<post_op_attr> resfail;
  };

#define rpcunion_tag_readdir3res status
#define rpcunion_switch_readdir3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (readdir3resok, resok); \
    break; \
  default: \
    action (post_op_attr, resfail); \
    break; \
  }

  readdir3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  readdir3res (const readdir3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~readdir3res () { _base.destroy (); }
  readdir3res &operator= (const readdir3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_readdir3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, readdir3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_readdir3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, readdir3res &obj)
{
  rpcunion_switch_readdir3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *readdir3res_alloc ();
bool_t xdr_readdir3res (XDR *, void *);
RPC_UNION_DECL (readdir3res)



struct readdirplus3args {
  nfs_fh3 dir;
  uint64 cookie;
  cookieverf3 cookieverf;
  uint32 dircount;
  uint32 maxcount;
};
void *readdirplus3args_alloc ();
bool_t xdr_readdirplus3args (XDR *, void *);
RPC_STRUCT_DECL (readdirplus3args)

template<class T> bool
rpc_traverse (T &t, readdirplus3args &obj)
{
  return rpc_traverse (t, obj.dir)
    && rpc_traverse (t, obj.cookie)
    && rpc_traverse (t, obj.cookieverf)
    && rpc_traverse (t, obj.dircount)
    && rpc_traverse (t, obj.maxcount);
}



struct entryplus3 {
  uint64 fileid;
  filename3 name;
  uint64 cookie;
  post_op_attr name_attributes;
  post_op_fh3 name_handle;
  rpc_ptr<entryplus3> nextentry;
};
void *entryplus3_alloc ();
bool_t xdr_entryplus3 (XDR *, void *);
RPC_STRUCT_DECL (entryplus3)

template<class T> bool
rpc_traverse (T &t, entryplus3 &obj)
{
  return rpc_traverse (t, obj.fileid)
    && rpc_traverse (t, obj.name)
    && rpc_traverse (t, obj.cookie)
    && rpc_traverse (t, obj.name_attributes)
    && rpc_traverse (t, obj.name_handle)
    && rpc_traverse (t, obj.nextentry);
}



struct dirlistplus3 {
  rpc_ptr<entryplus3> entries;
  bool eof;
};
void *dirlistplus3_alloc ();
bool_t xdr_dirlistplus3 (XDR *, void *);
RPC_STRUCT_DECL (dirlistplus3)

template<class T> bool
rpc_traverse (T &t, dirlistplus3 &obj)
{
  return rpc_traverse (t, obj.entries)
    && rpc_traverse (t, obj.eof);
}



struct readdirplus3resok {
  post_op_attr dir_attributes;
  cookieverf3 cookieverf;
  dirlistplus3 reply;
};
void *readdirplus3resok_alloc ();
bool_t xdr_readdirplus3resok (XDR *, void *);
RPC_STRUCT_DECL (readdirplus3resok)

template<class T> bool
rpc_traverse (T &t, readdirplus3resok &obj)
{
  return rpc_traverse (t, obj.dir_attributes)
    && rpc_traverse (t, obj.cookieverf)
    && rpc_traverse (t, obj.reply);
}



struct readdirplus3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<readdirplus3resok> resok;
    union_entry<post_op_attr> resfail;
  };

#define rpcunion_tag_readdirplus3res status
#define rpcunion_switch_readdirplus3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (readdirplus3resok, resok); \
    break; \
  default: \
    action (post_op_attr, resfail); \
    break; \
  }

  readdirplus3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  readdirplus3res (const readdirplus3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~readdirplus3res () { _base.destroy (); }
  readdirplus3res &operator= (const readdirplus3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_readdirplus3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, readdirplus3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_readdirplus3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, readdirplus3res &obj)
{
  rpcunion_switch_readdirplus3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *readdirplus3res_alloc ();
bool_t xdr_readdirplus3res (XDR *, void *);
RPC_UNION_DECL (readdirplus3res)



struct fsstat3resok {
  post_op_attr obj_attributes;
  uint64 tbytes;
  uint64 fbytes;
  uint64 abytes;
  uint64 tfiles;
  uint64 ffiles;
  uint64 afiles;
  uint32 invarsec;
};
void *fsstat3resok_alloc ();
bool_t xdr_fsstat3resok (XDR *, void *);
RPC_STRUCT_DECL (fsstat3resok)

template<class T> bool
rpc_traverse (T &t, fsstat3resok &obj)
{
  return rpc_traverse (t, obj.obj_attributes)
    && rpc_traverse (t, obj.tbytes)
    && rpc_traverse (t, obj.fbytes)
    && rpc_traverse (t, obj.abytes)
    && rpc_traverse (t, obj.tfiles)
    && rpc_traverse (t, obj.ffiles)
    && rpc_traverse (t, obj.afiles)
    && rpc_traverse (t, obj.invarsec);
}



struct fsstat3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<fsstat3resok> resok;
    union_entry<post_op_attr> resfail;
  };

#define rpcunion_tag_fsstat3res status
#define rpcunion_switch_fsstat3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (fsstat3resok, resok); \
    break; \
  default: \
    action (post_op_attr, resfail); \
    break; \
  }

  fsstat3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  fsstat3res (const fsstat3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~fsstat3res () { _base.destroy (); }
  fsstat3res &operator= (const fsstat3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_fsstat3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, fsstat3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_fsstat3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, fsstat3res &obj)
{
  rpcunion_switch_fsstat3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *fsstat3res_alloc ();
bool_t xdr_fsstat3res (XDR *, void *);
RPC_UNION_DECL (fsstat3res)


enum { FSF3_LINK = 0x0001 };
enum { FSF3_SYMLINK = 0x0002 };
enum { FSF3_HOMOGENEOUS = 0x0008 };
enum { FSF3_CANSETTIME = 0x0010 };


struct fsinfo3resok {
  post_op_attr obj_attributes;
  uint32 rtmax;
  uint32 rtpref;
  uint32 rtmult;
  uint32 wtmax;
  uint32 wtpref;
  uint32 wtmult;
  uint32 dtpref;
  uint64 maxfilesize;
  nfstime3 time_delta;
  uint32 properties;
};
void *fsinfo3resok_alloc ();
bool_t xdr_fsinfo3resok (XDR *, void *);
RPC_STRUCT_DECL (fsinfo3resok)

template<class T> bool
rpc_traverse (T &t, fsinfo3resok &obj)
{
  return rpc_traverse (t, obj.obj_attributes)
    && rpc_traverse (t, obj.rtmax)
    && rpc_traverse (t, obj.rtpref)
    && rpc_traverse (t, obj.rtmult)
    && rpc_traverse (t, obj.wtmax)
    && rpc_traverse (t, obj.wtpref)
    && rpc_traverse (t, obj.wtmult)
    && rpc_traverse (t, obj.dtpref)
    && rpc_traverse (t, obj.maxfilesize)
    && rpc_traverse (t, obj.time_delta)
    && rpc_traverse (t, obj.properties);
}



struct fsinfo3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<fsinfo3resok> resok;
    union_entry<post_op_attr> resfail;
  };

#define rpcunion_tag_fsinfo3res status
#define rpcunion_switch_fsinfo3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (fsinfo3resok, resok); \
    break; \
  default: \
    action (post_op_attr, resfail); \
    break; \
  }

  fsinfo3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  fsinfo3res (const fsinfo3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~fsinfo3res () { _base.destroy (); }
  fsinfo3res &operator= (const fsinfo3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_fsinfo3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, fsinfo3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_fsinfo3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, fsinfo3res &obj)
{
  rpcunion_switch_fsinfo3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *fsinfo3res_alloc ();
bool_t xdr_fsinfo3res (XDR *, void *);
RPC_UNION_DECL (fsinfo3res)



struct pathconf3resok {
  post_op_attr obj_attributes;
  uint32 linkmax;
  uint32 name_max;
  bool no_trunc;
  bool chown_restricted;
  bool case_insensitive;
  bool case_preserving;
};
void *pathconf3resok_alloc ();
bool_t xdr_pathconf3resok (XDR *, void *);
RPC_STRUCT_DECL (pathconf3resok)

template<class T> bool
rpc_traverse (T &t, pathconf3resok &obj)
{
  return rpc_traverse (t, obj.obj_attributes)
    && rpc_traverse (t, obj.linkmax)
    && rpc_traverse (t, obj.name_max)
    && rpc_traverse (t, obj.no_trunc)
    && rpc_traverse (t, obj.chown_restricted)
    && rpc_traverse (t, obj.case_insensitive)
    && rpc_traverse (t, obj.case_preserving);
}



struct pathconf3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<pathconf3resok> resok;
    union_entry<post_op_attr> resfail;
  };

#define rpcunion_tag_pathconf3res status
#define rpcunion_switch_pathconf3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (pathconf3resok, resok); \
    break; \
  default: \
    action (post_op_attr, resfail); \
    break; \
  }

  pathconf3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  pathconf3res (const pathconf3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~pathconf3res () { _base.destroy (); }
  pathconf3res &operator= (const pathconf3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_pathconf3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, pathconf3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_pathconf3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, pathconf3res &obj)
{
  rpcunion_switch_pathconf3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *pathconf3res_alloc ();
bool_t xdr_pathconf3res (XDR *, void *);
RPC_UNION_DECL (pathconf3res)



struct commit3args {
  nfs_fh3 file;
  uint64 offset;
  uint32 count;
};
void *commit3args_alloc ();
bool_t xdr_commit3args (XDR *, void *);
RPC_STRUCT_DECL (commit3args)

template<class T> bool
rpc_traverse (T &t, commit3args &obj)
{
  return rpc_traverse (t, obj.file)
    && rpc_traverse (t, obj.offset)
    && rpc_traverse (t, obj.count);
}



struct commit3resok {
  wcc_data file_wcc;
  writeverf3 verf;
};
void *commit3resok_alloc ();
bool_t xdr_commit3resok (XDR *, void *);
RPC_STRUCT_DECL (commit3resok)

template<class T> bool
rpc_traverse (T &t, commit3resok &obj)
{
  return rpc_traverse (t, obj.file_wcc)
    && rpc_traverse (t, obj.verf);
}



struct commit3res {
  const nfsstat3 status;
  union {
    union_entry_base _base;
    union_entry<commit3resok> resok;
    union_entry<wcc_data> resfail;
  };

#define rpcunion_tag_commit3res status
#define rpcunion_switch_commit3res(swarg, action, voidaction, defaction) \
  switch (swarg) { \
  case NFS3_OK: \
    action (commit3resok, resok); \
    break; \
  default: \
    action (wcc_data, resfail); \
    break; \
  }

  commit3res (nfsstat3 _tag = (nfsstat3) 0) : status (_tag)
    { _base.init (); set_status (_tag); }
  commit3res (const commit3res &_s)
    : status (_s.status)
    { _base.init (_s._base); }
  ~commit3res () { _base.destroy (); }
  commit3res &operator= (const commit3res &_s) {
    const_cast<nfsstat3 &> (status) = _s.status;
    _base.assign (_s._base);
    return *this;
  }

  void set_status (nfsstat3 _tag) {
    const_cast<nfsstat3 &> (status) = _tag;
    rpcunion_switch_commit3res
      (_tag, RPCUNION_SET, _base.destroy (), _base.destroy ());
  }
};

template<class T> bool
rpc_traverse (T &t, commit3res &obj)
{
  nfsstat3 tag = obj.status;
  if (!rpc_traverse (t, tag))
    return false;
  if (tag != obj.status)
    obj.set_status (tag);

  rpcunion_switch_commit3res
    (obj.status, RPCUNION_TRAVERSE, return true, return false);
}
inline bool
rpc_traverse (const stompcast_t &s, commit3res &obj)
{
  rpcunion_switch_commit3res
    (obj.status, RPCUNION_REC_STOMPCAST,
     obj._base.destroy (); return true, obj._base.destroy (); return true)
  RPCUNION_XXX_GCC40
}
void *commit3res_alloc ();
bool_t xdr_commit3res (XDR *, void *);
RPC_UNION_DECL (commit3res)


#ifndef NFS_PROGRAM
#define NFS_PROGRAM 100003
#endif /* !NFS_PROGRAM */
extern const rpc_program nfs_program_3;
enum { NFS_V3 = 3 };
enum {
  NFSPROC3_NULL = 0,
  NFSPROC3_GETATTR = 1,
  NFSPROC3_SETATTR = 2,
  NFSPROC3_LOOKUP = 3,
  NFSPROC3_ACCESS = 4,
  NFSPROC3_READLINK = 5,
  NFSPROC3_READ = 6,
  NFSPROC3_WRITE = 7,
  NFSPROC3_CREATE = 8,
  NFSPROC3_MKDIR = 9,
  NFSPROC3_SYMLINK = 10,
  NFSPROC3_MKNOD = 11,
  NFSPROC3_REMOVE = 12,
  NFSPROC3_RMDIR = 13,
  NFSPROC3_RENAME = 14,
  NFSPROC3_LINK = 15,
  NFSPROC3_READDIR = 16,
  NFSPROC3_READDIRPLUS = 17,
  NFSPROC3_FSSTAT = 18,
  NFSPROC3_FSINFO = 19,
  NFSPROC3_PATHCONF = 20,
  NFSPROC3_COMMIT = 21,
};
#define NFS_PROGRAM_3_APPLY_NOVOID(macro, void) \
  macro (NFSPROC3_NULL, void, void) \
  macro (NFSPROC3_GETATTR, nfs_fh3, getattr3res) \
  macro (NFSPROC3_SETATTR, setattr3args, wccstat3) \
  macro (NFSPROC3_LOOKUP, diropargs3, lookup3res) \
  macro (NFSPROC3_ACCESS, access3args, access3res) \
  macro (NFSPROC3_READLINK, nfs_fh3, readlink3res) \
  macro (NFSPROC3_READ, read3args, read3res) \
  macro (NFSPROC3_WRITE, write3args, write3res) \
  macro (NFSPROC3_CREATE, create3args, diropres3) \
  macro (NFSPROC3_MKDIR, mkdir3args, diropres3) \
  macro (NFSPROC3_SYMLINK, symlink3args, diropres3) \
  macro (NFSPROC3_MKNOD, mknod3args, diropres3) \
  macro (NFSPROC3_REMOVE, diropargs3, wccstat3) \
  macro (NFSPROC3_RMDIR, diropargs3, wccstat3) \
  macro (NFSPROC3_RENAME, rename3args, rename3res) \
  macro (NFSPROC3_LINK, link3args, link3res) \
  macro (NFSPROC3_READDIR, readdir3args, readdir3res) \
  macro (NFSPROC3_READDIRPLUS, readdirplus3args, readdirplus3res) \
  macro (NFSPROC3_FSSTAT, nfs_fh3, fsstat3res) \
  macro (NFSPROC3_FSINFO, nfs_fh3, fsinfo3res) \
  macro (NFSPROC3_PATHCONF, nfs_fh3, pathconf3res) \
  macro (NFSPROC3_COMMIT, commit3args, commit3res)
#define NFS_PROGRAM_3_APPLY(macro) \
  NFS_PROGRAM_3_APPLY_NOVOID(macro, void)

#endif /* !__RPCC_NFS3_PROT_H_INCLUDED__ */
