

/*
#    Sfront, a SAOL to C translator    
#    This file: Main loop for runtime: active driver, shorts
#    Copyright (C) 1999  Regents of the University of California
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License (Version 2) as
#    published by the Free Software Foundation.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Primary Author: John Lazzaro, lazzaro@cs.berkeley.edu
*/


#if defined(ASYS_ACTIVE_O)

int asys_orun(ASYS_OTYPE obuf[], long * osize)

{
  int obusidx = 0;
  int busidx;

  if (asys_exit_status == ASYS_EXIT)
    return ASYS_EXIT;

  while (obusidx < *osize)
    if (acycleidx < ACYCLE)
      {
	for (busidx=0; busidx<ENDBUS;busidx++)
	  bus[busidx]=0.0F;
	main_apass();
	for (busidx=BUS_output_bus; busidx<ENDBUS_output_bus;busidx++)
	  {
	    bus[busidx] = (bus[busidx] >  1.0F) ?  1.0F : bus[busidx];

#if (ASYS_OTYPENAME == ASYS_SHORT)
	    bus[busidx] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];
	    obuf[obusidx++] = (short) (32767.0F * bus[busidx]);
#endif

#if (ASYS_OTYPENAME == ASYS_FLOAT)
	    obuf[obusidx++] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];
#endif

	  }
	acycleidx++;
      }
    else
      {
	acycleidx = 0;
	if (pass == APASS)
	  {      
	    cpuload = ksync();
	    kcycleidx++;
	  }
	if (kcycleidx > endkcycle)
	  {
	    *osize = obusidx;
	    return (asys_exit_status = ASYS_EXIT);
	  }
	pass = IPASS;
	scorebeats = scoremult*(kcycleidx - kbase) + scorebase;
	absolutetime = (kcycleidx - 1)*KTIME;
	main_ipass();
	pass = KPASS;
	main_control();
	if (main_kpass())
	  {
	    *osize = obusidx;
	    return (asys_exit_status = ASYS_EXIT);
	  }
	pass = APASS;
      }

  return ASYS_DONE;
}

#endif  /* ASYS_ACTIVE_O */


#if defined(ASYS_ACTIVE_IO)

int asys_iorun(ASYS_ITYPE ibuf[], long * isize,ASYS_OTYPE obuf[], long * osize)

{  
  int ibusidx = 0;
  int obusidx = 0;
  int busidx;

  if (asys_exit_status == ASYS_EXIT)
    return ASYS_EXIT;

  while ((obusidx < *osize) && (ibusidx < *isize))
    if (acycleidx < ACYCLE)
      {
	for (busidx=0; busidx<ENDBUS;busidx++)
	  bus[busidx] = 0.0F;

#if (ASYS_ITYPENAME == ASYS_SHORT)
	for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)
	  bus[busidx] = 3.051851e-5F*ibuf[ibusidx++];
#endif

#if (ASYS_ITYPENAME == ASYS_FLOAT)
	for(busidx=BUS_input_bus;busidx<ENDBUS_input_bus;busidx++)
	  bus[busidx] = ibuf[ibusidx++];
#endif

	main_apass();
	for (busidx=BUS_output_bus; busidx<ENDBUS_output_bus;busidx++)
	  {
	    bus[busidx] = (bus[busidx] >  1.0F) ?  1.0F : bus[busidx];

#if (ASYS_OTYPENAME == ASYS_SHORT)
	    bus[busidx] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];
	    obuf[obusidx++] = (short) (32767.0F * bus[busidx]);
#endif

#if (ASYS_OTYPENAME == ASYS_FLOAT)
	    obuf[obusidx++] = (bus[busidx] < -1.0F) ? -1.0F : bus[busidx];
#endif
	  }
	acycleidx++;
      }
    else
      {
	acycleidx = 0;
	if (pass == APASS)
	  {      
	    cpuload = ksync();
	    kcycleidx++;
	  }
	if (kcycleidx > endkcycle)
	  {
	    *osize = obusidx;
	    *isize = ibusidx;
	    return (asys_exit_status = ASYS_EXIT);
	  }
	pass = IPASS;
	scorebeats = scoremult*(kcycleidx - kbase) + scorebase;
	absolutetime = (kcycleidx - 1)*KTIME;
	main_ipass();
	pass = KPASS;
	main_control();
	if (main_kpass())
	  {
	    *osize = obusidx;
	    *isize = ibusidx;
	    return (asys_exit_status = ASYS_EXIT);
	  }
	pass = APASS;
      }

  if (obusidx < *osize)
    *osize = obusidx;
  if (ibusidx < *isize)
    *isize = ibusidx;
  return ASYS_DONE;
}

#endif /* ASYS_ACTIVE_IO */


int main(int argc, char *argv[])

{
  system_init(argc, argv);
  effects_init();
  main_initpass();

  kcycleidx = kbase;
  acycleidx = ACYCLE;
  pass = IPASS;

  asys_main();
  shut_down();
  return 0;
}





