/* @(#)list.c	1.56 03/09/28 Copyright 1985, 1995, 2000-2003 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)list.c	1.56 03/09/28 Copyright 1985, 1995, 2000-2003 J. Schilling";
#endif
/*
 *	List the content of an archive
 *
 *	Copyright (c) 1985, 1995, 2000-2003 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <mconfig.h>
#include <stdio.h>
#include <unixstd.h>
#include <utypes.h>
#include <dirdefs.h>
#include <timedefs.h>
#include <standard.h>
#include <strdefs.h>
#include <schily.h>
#include <device.h>

#ifdef	HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifndef	DEV_BSIZE
#define	DEV_BSIZE	512
#endif

#include "list.h"

#define	K_DIV	(1024/DEV_BSIZE)

extern	FILE	*tarf;
extern	FILE	*vpr;
extern	char	*listfile;
extern	Llong	curblockno;

extern	time_t	sixmonth;		/* 6 months before limit (ls)	*/
extern	time_t	now;			/* now limit (ls)		*/

extern	BOOL	havepat;
extern	int	iftype;
extern	BOOL	paxls;
extern	int	xdebug;
extern	BOOL	numeric;
extern	int	verbose;
extern	BOOL	prblockno;
extern	BOOL	tpath;
extern	BOOL	xflag;
extern	BOOL	interactive;

extern	BOOL	acctime;
extern	BOOL	no_dirslash;
extern	BOOL	Ctime;

extern	BOOL	listnew;
extern	BOOL	listnewf;

extern	BOOL	do_subst;

LOCAL	void	modstr		__PR((struct stat *fs, char *s, Ulong  mode));
EXPORT	void	list		__PR((struct stat *fs, char *name, char *sname));

/*--------------------------------------------------------------------------*/
extern	BOOL	nameuid	__PR((char *name, int namelen, Ulong uid));
extern	BOOL	namegid	__PR((char *name, int namelen, Ulong gid));
/*--------------------------------------------------------------------------*/

/*
 * Convert POSIX.1 TAR mode/permission flags into string.
 */
LOCAL void
modstr(fs, s, mode)
	struct stat	*fs;
		char	*s;
	register Ulong	mode;
{
	register char	*mstr = "xwrxwrxwr";
	register char	*str = s;
	register int	i;

	for (i = 9; --i >= 0; ) {
		if (mode & (1 << i))
			*str++ = mstr[i];
		else
			*str++ = '-';
	}
#ifdef	USE_ACL
	*str++ = ' ';
#endif
#ifdef	USE_XATTR
	*str++ = '\0';				/* Don't claim space for '@' */
#endif
	*str = '\0';
	str = s;
	if (mode & S_ISVTX) {
		if (mode &  S_IXOTH) {
			str[8] = 't';		/* Sticky & exec. by others  */
		} else {
			str[8] = 'T';		/* Sticky but !exec. by oth  */
		}
	}
	if (mode & S_ISGID) {
		if (mode & S_IXGRP) {
			str[5] = 's';		/* Sgid & executable by grp  */
		} else {
			if (S_ISDIR(fs->st_mode))
				str[5] = 'S';	/* Sgid directory	    */
			else
				str[5] = 'l';	/* Mandatory lock file	    */
		}
	}
	if (mode & S_ISUID) {
		if (mode & S_IXUSR)
			str[2] = 's';		/* Suid & executable by own. */
		else
			str[2] = 'S';		/* Suid but not executable   */
	}
	i = 9;
#ifdef	USE_ACL
	if ((info->f_xflags & (XF_ACL_ACCESS|XF_ACL_DEFAULT)) != 0)
		str[i++] = '+';
#endif
#ifdef	USE_XATTR
	if ((info->f_xflags & XF_XATTR) != 0)
		str[i++] = '@';
#endif
	i++;	/* Make lint believe that we always use i. */
}

EXPORT void
list(fs, name, sname)
	struct stat	*fs;
	char		*name;
	char		*sname;
{
		time_t	*tp;
		char	*tstr;
		char	mstr[12]; /* 9 UNIX chars + ACL '+' XATTR '@' + nul */
		char	lstr[11]; /* contains link count as string */
	static	char	nuid[11]; /* XXXX 64 bit longs??? */
	static	char	ngid[11]; /* XXXX 64 bit longs??? */
		char	*add = "";
char	lname[8192];
int	lsize;

#define	verbose	1
	if (verbose) {
		char	*uname;
		char	*gname;
		int	umaxlen;
		int	gmaxlen;
		char	ft;

		tp = acctime ? &fs->st_atime :
				(Ctime ? &fs->st_ctime : &fs->st_mtime);
		tstr = ctime(tp);
#define	USE_NAME
#ifdef	USE_NAME
		if (nameuid(nuid, sizeof (nuid), (Ulong)fs->st_uid)) {
#else
		if (0) {
#endif
			uname = nuid;
			umaxlen = sizeof (nuid)-1;
		} else {
			sprintf(nuid, "%llu", (Llong)fs->st_uid);
			uname = nuid;
			umaxlen = sizeof (nuid)-1;
		}
#ifdef	USE_NAME
		if (namegid(ngid, sizeof (ngid), (Ulong)fs->st_gid)) {
#else
		if (0) {
#endif
			gname = ngid;
			gmaxlen = sizeof (ngid)-1;
		} else {
			sprintf(ngid, "%llu", (Llong)fs->st_gid);
			gname = ngid;
			gmaxlen = sizeof (ngid)-1;
		}

		{
			printf("%7llu ", (Llong)fs->st_ino);
			printf("%4llu ", (Llong)fs->st_blocks/K_DIV);
		}
		if (!paxls) {
			if (S_ISBLK(fs->st_mode) || S_ISCHR(fs->st_mode))
				printf("%3lu %3lu",
					(long)major(fs->st_rdev), (long)minor(fs->st_rdev));
			else
				printf("%7llu", (Llong)fs->st_size);
		}
		modstr(fs, mstr, fs->st_mode);

		if (paxls || fs->st_nlink > 0) {
			/*
			 * UNIX ls uses %3d for the link count
			 * and does not claim space for ACL '+'
			 */
			js_sprintf(lstr, " %2ld", (long)fs->st_nlink);
		} else {
			lstr[0] = 0;
		}

		switch (fs->st_mode & S_IFMT) {

		case S_IFREG:	ft = '-'; break;
		case S_IFLNK:	ft = 'l';
				lname[0] = '\0';
				lsize = readlink(sname, lname, sizeof (lname));
				if (lsize < 0)
					errmsg("Cannot read link '%s'.\n", name);
				lname[sizeof (lname)-1] = '\0';
				if (lsize >= 0)
					lname[lsize] = '\0';
				break;
		case S_IFDIR:	ft = 'd'; break;
		case S_IFBLK:	ft = 'b'; break;
		case S_IFCHR:	ft = 'c'; break;
		case S_IFIFO:	ft = 'p'; break;
#ifdef	S_IFDOOR
		case S_IFDOOR:	ft = 'D'; break;
#endif
#ifdef	S_IFSOCK
		case S_IFSOCK:	ft = 's'; break;
#endif
#ifdef	S_IFNAM
		case S_IFNAM:	switch (fs->st_rdev) {
				case S_INSEM:
					ft = 's';
					break;
				case S_INSHD:
					ft = 'm';
					break;
				default:
					ft = '-';
					break;
				}
#endif

		default:	ft = '?'; break;
		}

		if (!paxls) {
			printf(" %c%s%s %3.*s/%-3.*s %.12s %4.4s ",
				ft,
				mstr,
				lstr,
				umaxlen, uname,
				gmaxlen, gname,
				&tstr[4], &tstr[20]);
		} else {
			printf("%c%s%s %-8.*s %-8.*s ",
				ft,
				mstr,
				lstr,
				umaxlen, uname,
				gmaxlen, gname);
			if (S_ISBLK(fs->st_mode) || S_ISCHR(fs->st_mode))
/*				printf("%3lu %3lu",*/
/* XXXXXXXXXXXXXX */		printf("%3lu, %3lu",
					(long)major(fs->st_rdev), (long)minor(fs->st_rdev));
			else
				printf("%7llu", (Llong)fs->st_size);
			if ((*tp < sixmonth) || (*tp > now)) {
				printf(" %.6s  %4.4s ",
					&tstr[4], &tstr[20]);
			} else {
				printf(" %.12s ",
					&tstr[4]);
			}
		}
	}
	printf("%s%s", name, add);

	if (S_ISLNK(fs->st_mode))
		printf(" -> %s", lname);

	printf("\n");
}

/*BOOL	paxls = FALSE;*/
BOOL	paxls = TRUE;
BOOL	Ctime;
BOOL	acctime;
