/* @(#)gettnum.c	1.4 04/10/10 Copyright 1984-2002, 2004 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)gettnum.c	1.4 04/10/10 Copyright 1984-2002, 2004 J. Schilling";
#endif
/*
 *	Time conversion routines rewritten from number conversion in 'sdd'.
 *
 *	Copyright (c) 1984-2002, 2004 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <mconfig.h>
#include <standard.h>
#include <utypes.h>
#include <timedefs.h>
#include <schily.h>
#include <nlsdefs.h>
#include "gettnum.h"

#define	MINSECS		(60)
#define	HOURSECS	(60  * MINSECS)
#define	DAYSECS		(24  * HOURSECS)
#define	WEEKSECS	(7   * DAYSECS)
#define	YEARSECS	(365 * DAYSECS)		/* A non leap year */


LOCAL	Llong	tnumber		__PR((char *arg, int *retp, int level));
EXPORT	int	gettnum		__PR((char *arg, time_t *valp));

LOCAL Llong
tnumber(arg, retp, level)
	register char	*arg;
		int	*retp;
		int	level;
{
	Llong	val	= 0;

	if (*retp != 1)
		return (val);
	if (*arg == '\0') {
		*retp = -1;
	} else if (*(arg = astoll(arg, &val))) {
		if (*arg == 's') {
			val *= 1;
			arg++;

		} else if (*arg == 'm') {
			val *= MINSECS;
			arg++;

		} else if (*arg == 'h') {
			val *= HOURSECS;
			arg++;

		} else if (*arg == 'd') {
			val *= DAYSECS;
			arg++;

		} else if (*arg == 'w') {
			val *= WEEKSECS;
			arg++;

		} else if (*arg == 'y') {
			val *= YEARSECS;
			arg++;

		}
		if (*arg >= '0' && *arg <= '9')
			val += tnumber(arg, retp, level+1);
		else if (*arg != '\0') {
			errmsgno(EX_BAD,
			gettext("Illegal character '%c' in timespec.\n"),
				*arg);
			*retp = -1;
		} else if (*arg == '\0')
			return (val);
	}
	if (level > 0 && *arg == '\0')
		*retp = -1;
	return (val);
}

EXPORT int
gettnum(arg, valp)
	char	*arg;
	time_t	*valp;
{
	Llong	llval;
	int	ret = 1;

	llval = tnumber(arg, &ret, 0);
	*valp = llval;
	if (*valp != llval) {
		errmsgno(EX_BAD,
		gettext("Value %lld is too large for data type 'time_t'.\n"),
									llval);
		ret = -1;
	}
	return (ret);
}
