#
# Copyright (C) 2006 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin

class plugin(Plugin):
    summary =_('''
    SELinux is preventing $SOURCE ($SOURCE_TYPE) "$ACCESS" access to device $TARGET_PATH. 
    ''')

    problem_description = _('''
    SELinux has denied the $SOURCE ($SOURCE_TYPE) "$ACCESS" access to device $TARGET_PATH.
    $TARGET_PATH is mislabeled, this device has the default label of the /dev directory, which should not
    happen.  All Character and/or Block Devices should have a label.  You can attempt to change the label of
    the file using restorecon '$TARGET_PATH'.  If this device remains labeled device_t, then this is a bug in
    SELinux policy.

    ''')

    fix_description = _('''
    If you want the SSL Tunnel to run as a daemon you need to turn on
    the $BOOLEAN boolean: "setsebool -P $BOOLEAN=1".  You also need to
    tell SELinux which port SSL Tunnel will be running on.  semanage
    port -a -t stunnel_port_t -p tcp $PORT_NUMBER
    ''')

    fix_cmd = 'setsebool -P $BOOLEAN=1'

    def __init__(self):
        Plugin.__init__(self, __name__)

    def analyze(self, avc):
        if avc.matches_source_types(['stunnel_t']) and \
           avc.has_any_access_in(['name_bind']):
            # MATCH
            avc.set_template_substitutions(BOOLEAN="stunnel_is_daemon")
            return self.report(avc, _("Networking"),
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        else:
            return None

