#
# Authors: Dan Walsh <dwalsh@redhat.com>
#
# Copyright (C) 2006 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin
import re

class plugin(Plugin):
    summary = _('''
    SELinux prevented $SOURCE from using the terminal $TARGET_PATH.
    ''')

    problem_description = _('''
    SELinux prevented $SOURCE from using the terminal $TARGET_PATH.
    In most cases daemons do not need to interact with the terminal, usually
    these avc messages can be ignored.  All of the confined daemons should
    have dontaudit rules around using the terminal.  Please file a <a
    href="http://bugzilla.redhat.com/bugzilla/enter_bug.cgi">bug
    report</a> against this selinux-policy.  If you would like to allow all
    daemons to interact with the terminal, you can turn on the $BOOLEAN boolean.
    ''')

    fix_description = _('''
    Changing the "$BOOLEAN" boolean to true will allow this access:
    "setsebool -P $BOOLEAN=1."
    ''')

    fix_cmd = 'setsebool -P $BOOLEAN=1'
    
    def __init__(self):
        Plugin.__init__(self, __name__)
        self.set_priority(65)
        
    def analyze(self, avc):
        if avc.matches_target_types(['.*console_device_t$', '.*devpts_t$', '.*devtty_t$', '.*tty_device_t$']) and \
           avc.has_tclass_in(['chr_file']):
            # MATCH
            avc.set_template_substitutions(BOOLEAN="allow_daemons_use_tty")
            return self.report(avc, None,
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        else:
            return None


