#!/bin/bash

usage="Usage: $0 -d destination [-o user:group] [-t]"

while getopts "d:o:t" opt ; do
    case "$opt" in
        d )  dest="$OPTARG";;
        o )  owner="$OPTARG";;
        t )  suexec="$OPTIND";;
        \? ) echo $usage
        exit 1;;
        * ) echo $usage
            exit 1;;
    esac
done

if [ -z "$dest" -o ! -d $(dirname "$dest") ] ; then
  echo No path given or directory does not exist.
  echo $usage
  exit 1
fi
mkdir $dest || exit 1

[ -z "$owner" ] && owner="root:www-data"
user=$(echo $owner | cut -d: -f1)
group=$(echo $owner | cut -d: -f2)

cp -r /usr/share/serendipity/deployment/* $dest
cd $dest
touch .htaccess serendipity_config_local.inc.php
cp /usr/share/doc/serendipity/examples/serendipity_config_local_deploy.inc.php serendipity_config_local.inc.php.example
for i in templates_c archives uploads serendipity_config_local.inc.php .htaccess; do
  chown $user:$group $i
  if [ -z "$suexec" ]; then
  ## standard
      [ -f $i ] && chmod 0660 $i
      [ -d $i ] && chmod 0770 $i
  else
  ## tighten permissions
      [ -f $i ] && chmod 0640 $i
      [ -d $i ] && chmod 0750 $i
  fi
done
chmod g-r,o-r archives templates_c
for link in templates htmlarea plugins; do
  ln -s /usr/share/serendipity/www/$link $link
done
