// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_SEQUENCE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_SEQUENCE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Alloc

template <typename TSpec > struct Alloc;       	// "projects/library/seqan/sequence/string_base.h"(51)

//____________________________________________________________________________
// AppendSequenceToSegment_

template <typename TExpand> struct AppendSequenceToSegment_;       	// "projects/library/seqan/sequence/segment_base.h"(758)

//____________________________________________________________________________
// AppendString_

template <typename TExpand> struct AppendString_;       	// "projects/library/seqan/sequence/string_base.h"(1085)

//____________________________________________________________________________
// AppendValueToSegment_

template <typename TExpand> struct AppendValueToSegment_;       	// "projects/library/seqan/sequence/segment_base.h"(920)

//____________________________________________________________________________
// AppendValueToString_

template <typename TExpand> struct AppendValueToString_;       	// "projects/library/seqan/sequence/string_base.h"(1202)

//____________________________________________________________________________
// AssignSegment_

template <typename TExpand> struct AssignSegment_;       	// "projects/library/seqan/sequence/segment_base.h"(519)

//____________________________________________________________________________
// AssignString_

template <typename TExpand> struct AssignString_;       	// "projects/library/seqan/sequence/string_base.h"(859)

//____________________________________________________________________________
// ClearSpaceExpandStringBase_

template <typename TExpand> struct ClearSpaceExpandStringBase_;       	// "projects/library/seqan/sequence/string_base.h"(519)

//____________________________________________________________________________
// ClearSpaceStringBase_

template <typename TExpand> struct ClearSpaceStringBase_;       	// "projects/library/seqan/sequence/string_base.h"(307)

//____________________________________________________________________________
// Comparator

template <typename T> struct Comparator;       	// "projects/library/seqan/sequence/sequence_lexical.h"(200)

//____________________________________________________________________________
// DefaultPrefixOrder

template <typename T> struct DefaultPrefixOrder;       	// "projects/library/seqan/sequence/sequence_lexical.h"(76)

//____________________________________________________________________________
// Infix

template <typename THost> struct Infix;       	// "projects/library/seqan/sequence/segment_infix.h"(476)

//____________________________________________________________________________
// InfixSegment

struct InfixSegment;       	// "projects/library/seqan/sequence/segment_base.h"(61)
struct InfixSegment;       	// "projects/library/seqan/sequence/segment_suffix.h"(368)
struct InfixSegment;       	// "projects/library/seqan/sequence/segment_prefix.h"(370)

//____________________________________________________________________________
// InsertValueToSegment_

template <typename TExpand> struct InsertValueToSegment_;       	// "projects/library/seqan/sequence/segment_base.h"(962)

//____________________________________________________________________________
// InsertValueToString_

template <typename TExpand> struct InsertValueToString_;       	// "projects/library/seqan/sequence/string_base.h"(1249)

//____________________________________________________________________________
// Lexical

template <typename TSpec > struct Lexical;       	// "projects/library/seqan/sequence/sequence_lexical.h"(136)

//____________________________________________________________________________
// Prefix

template <typename THost> struct Prefix;       	// "projects/library/seqan/sequence/segment_prefix.h"(375)

//____________________________________________________________________________
// PrefixSegment

struct PrefixSegment;       	// "projects/library/seqan/sequence/segment_suffix.h"(367)
struct PrefixSegment;       	// "projects/library/seqan/sequence/segment_prefix.h"(67)

//____________________________________________________________________________
// ReplaceSequenceToSegment_

template <typename TExpand> struct ReplaceSequenceToSegment_;       	// "projects/library/seqan/sequence/segment_base.h"(1015)

//____________________________________________________________________________
// ReplaceString_

template <typename TExpand> struct ReplaceString_;       	// "projects/library/seqan/sequence/string_base.h"(1288)

//____________________________________________________________________________
// Segment

template <typename THost, typename TSpec > class Segment;       	// "projects/library/seqan/sequence/segment_base.h"(65)

//____________________________________________________________________________
// SegmentSetImpl_

template <typename TSameSpec, typename TTargetInfix> struct SegmentSetImpl_;       	// "projects/library/seqan/sequence/segment_base.h"(315)

//____________________________________________________________________________
// String

template <typename TValue, typename TSpec > class String;       	// "projects/library/seqan/sequence/string_base.h"(71)
template <typename TAlphabet, typename TSpec> class String;       	// "projects/library/seqan/sequence/string_base.h"(146)

//____________________________________________________________________________
// StringSet

template <typename TString, typename TSpec> class StringSet;       	// "projects/library/seqan/sequence/string_base.h"(147)

//____________________________________________________________________________
// Suffix

template <typename THost> struct Suffix;       	// "projects/library/seqan/sequence/segment_suffix.h"(372)

//____________________________________________________________________________
// SuffixSegment

struct SuffixSegment;       	// "projects/library/seqan/sequence/segment_suffix.h"(66)
struct SuffixSegment;       	// "projects/library/seqan/sequence/segment_prefix.h"(371)

//____________________________________________________________________________
// TagPrefixGreater_

struct TagPrefixGreater_;       	// "projects/library/seqan/sequence/sequence_lexical.h"(60)

//____________________________________________________________________________
// TagPrefixLess_

struct TagPrefixLess_;       	// "projects/library/seqan/sequence/sequence_lexical.h"(57)

//____________________________________________________________________________
// TempCopy_

template <typename T> struct TempCopy_;       	// "projects/library/seqan/sequence/string_base.h"(125)

//____________________________________________________________________________
// _Resize_String

template <typename TExpand> struct _Resize_String;       	// "projects/library/seqan/sequence/string_base.h"(1620)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// AllowsFastRandomAccess

template <typename T> struct AllowsFastRandomAccess;       	// "projects/library/seqan/sequence/sequence_interface.h"(209)

//____________________________________________________________________________
// Array

template <unsigned int LENGTH> struct Array;       	// "projects/library/seqan/sequence/string_array.h"(66)

//____________________________________________________________________________
// AssignStringToStringArray_

template <typename TExpand, bool IS_CONTIGUOUS> struct AssignStringToStringArray_;       	// "projects/library/seqan/sequence/string_cstyle.h"(528)

//____________________________________________________________________________
// Block

template <unsigned int SPACE > struct Block;       	// "projects/library/seqan/sequence/string_block.h"(52)

//____________________________________________________________________________
// CStyle

struct CStyle;       	// "projects/library/seqan/sequence/string_cstyle.h"(93)

//____________________________________________________________________________
// ClearSpaceStringPacked_

template <typename TExpand> struct ClearSpaceStringPacked_;       	// "projects/library/seqan/sequence/string_packed.h"(594)

//____________________________________________________________________________
// ConcatDirect

template <typename TDelimiter > struct ConcatDirect;       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(53)

//____________________________________________________________________________
// ConcatVirtual

template <typename TDelimiter > struct ConcatVirtual;       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(58)

//____________________________________________________________________________
// Concatenator

template <typename T> struct Concatenator;       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(51)
template <typename TObject> struct Concatenator;       	// "projects/library/seqan/sequence/string_set_base.h"(89)

//____________________________________________________________________________
// ConcatenatorManyToOne

template <typename TStringSet> class ConcatenatorManyToOne;       	// "projects/library/seqan/sequence/sequence_concatenator.h"(72)

//____________________________________________________________________________
// CreateArrayStringExpand_

template <typename TExpand> struct CreateArrayStringExpand_;       	// "projects/library/seqan/sequence/string_cstyle.h"(632)

//____________________________________________________________________________
// CreateArrayString_

template <typename TExpand> struct CreateArrayString_;       	// "projects/library/seqan/sequence/string_cstyle.h"(685)

//____________________________________________________________________________
// DefaultOverflowExplicit

template <typename T> struct DefaultOverflowExplicit;       	// "projects/library/seqan/sequence/sequence_interface.h"(138)
template <typename TValue> struct DefaultOverflowExplicit;       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(92)

//____________________________________________________________________________
// DefaultOverflowImplicit

template <typename T> struct DefaultOverflowImplicit;       	// "projects/library/seqan/sequence/sequence_interface.h"(115)
template <typename TValue> struct DefaultOverflowImplicit;       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(61)

//____________________________________________________________________________
// Dependent

template <typename TSpec > struct Dependent;       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(70)

//____________________________________________________________________________
// GetSequenceByNo

template <typename TString> struct GetSequenceByNo;       	// "projects/library/seqan/sequence/string_set_base.h"(155)

//____________________________________________________________________________
// HostIterator

template <typename T> struct HostIterator;       	// "projects/library/seqan/sequence/string_packed.h"(825)

//____________________________________________________________________________
// IsContiguous

template <typename T> struct IsContiguous;       	// "projects/library/seqan/sequence/sequence_interface.h"(161)
template <typename TValue> struct IsContiguous;       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(118)

//____________________________________________________________________________
// IsSequence

template <typename T> struct IsSequence;       	// "projects/library/seqan/sequence/sequence_interface.h"(185)

//____________________________________________________________________________
// Owner

template <typename TSpec > struct Owner;       	// "projects/library/seqan/sequence/string_set_base.h"(50)

//____________________________________________________________________________
// Packed

template <typename THostspec > struct Packed;       	// "projects/library/seqan/sequence/string_packed.h"(51)

//____________________________________________________________________________
// PackedConsts_

template <typename TPackedContainer> struct PackedConsts_;       	// "projects/library/seqan/sequence/string_packed.h"(54)
template <typename TPackedContainer> struct PackedConsts_;       	// "projects/library/seqan/sequence/string_packed.h"(272)

//____________________________________________________________________________
// StringSet

template <typename TString, typename TSpec > class StringSet;       	// "projects/library/seqan/sequence/string_set_base.h"(65)

//____________________________________________________________________________
// StringSetLimits

template <typename TString> struct StringSetLimits;       	// "projects/library/seqan/sequence/string_set_base.h"(113)

//____________________________________________________________________________
// StringSetPosition

template <typename TString> struct StringSetPosition;       	// "projects/library/seqan/sequence/string_set_base.h"(137)

//____________________________________________________________________________
// TagExact_

struct TagExact_;       	// "projects/library/seqan/sequence/sequence_interface.h"(89)

//____________________________________________________________________________
// TagGenerous_

struct TagGenerous_;       	// "projects/library/seqan/sequence/sequence_interface.h"(86)

//____________________________________________________________________________
// TagInsist_

struct TagInsist_;       	// "projects/library/seqan/sequence/sequence_interface.h"(79)

//____________________________________________________________________________
// TagLimit_

struct TagLimit_;       	// "projects/library/seqan/sequence/sequence_interface.h"(83)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CharString

typedef String<char, Alloc<void> > CharString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(53)

//____________________________________________________________________________
// Dna5String

typedef String<Dna5, Alloc<void> > Dna5String;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(135)

//____________________________________________________________________________
// DnaString

typedef String<Dna, Alloc<void> > DnaString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(106)

//____________________________________________________________________________
// IupacString

typedef String<Iupac, Alloc<void> > IupacString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(222)

//____________________________________________________________________________
// Peptide

typedef String<AminoAcid, Alloc<void> > Peptide;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(250)

//____________________________________________________________________________
// Rna5String

typedef String<Rna5, Alloc<void> > Rna5String;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(193)

//____________________________________________________________________________
// RnaString

typedef String<Rna, Alloc<void> > RnaString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(164)

//____________________________________________________________________________
// TagPrefixGreater

typedef Tag<TagPrefixGreater_> const TagPrefixGreater;       	// "projects/library/seqan/sequence/sequence_lexical.h"(61)

//____________________________________________________________________________
// TagPrefixLess

typedef Tag<TagPrefixLess_> const TagPrefixLess;       	// "projects/library/seqan/sequence/sequence_lexical.h"(58)

//____________________________________________________________________________
// UnicodeString

typedef String<wchar_t, Alloc<void> > UnicodeString;       	// "projects/library/seqan/sequence/sequence_shortcuts.h"(79)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// Exact

typedef Tag<TagExact_> const Exact;       	// "projects/library/seqan/sequence/sequence_interface.h"(90)

//____________________________________________________________________________
// Generous

typedef Tag<TagGenerous_> const Generous;       	// "projects/library/seqan/sequence/sequence_interface.h"(87)

//____________________________________________________________________________
// Insist

typedef Tag<TagInsist_> const Insist;       	// "projects/library/seqan/sequence/sequence_interface.h"(80)

//____________________________________________________________________________
// Limit

typedef Tag<TagLimit_> const Limit;       	// "projects/library/seqan/sequence/sequence_interface.h"(84)

//____________________________________________________________________________
// Tight

typedef Tag<TagInsist_> const Tight;       	// "projects/library/seqan/sequence/sequence_interface.h"(81)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _clearSpace

template <typename TValue, typename TSpec, typename TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(724)
template <typename TValue, typename TSpec, typename TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(735)
template <typename TValue, typename TSpec, typename TSize, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(747)
template <typename TValue, typename TSpec, typename TSize, typename TPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type _clearSpace(String<TValue, TSpec> & me, TSize size, TPosition pos_begin, TPosition pos_end, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(760)

//____________________________________________________________________________
// _internalOrdValue

template <typename TValue> inline unsigned _internalOrdValue(TValue const & c);       	// "projects/library/seqan/sequence/sequence_lexical.h"(819)
template <typename TValue, typename TSpec> inline unsigned _internalOrdValue(SimpleType<TValue, TSpec> const & c);       	// "projects/library/seqan/sequence/sequence_lexical.h"(825)

//____________________________________________________________________________
// _moveContiguous

template <typename TTarget, typename TSource> void _moveContiguous(TTarget & target, TSource & source);       	// "projects/library/seqan/sequence/string_base.h"(970)

//____________________________________________________________________________
// _reallocateStorage

template <typename TValue, typename TSpec, typename TSize> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, TSize new_capacity);       	// "projects/library/seqan/sequence/string_base.h"(1428)
template <typename TValue, typename TSpec, typename TSize> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, TSize new_capacity, Exact);       	// "projects/library/seqan/sequence/string_base.h"(1439)
template <typename TValue, typename TSpec, typename TSize, typename TSize2> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, TSize new_capacity, TSize2 limit, Exact);       	// "projects/library/seqan/sequence/string_base.h"(1456)
template <typename TValue, typename TSpec, typename TSize> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, TSize new_capacity, Generous);       	// "projects/library/seqan/sequence/string_base.h"(1473)
template <typename TValue, typename TSpec, typename TSize, typename TSize2> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> & me, TSize new_capacity, TSize2 limit, Generous);       	// "projects/library/seqan/sequence/string_base.h"(1494)
template <typename TValue, typename TSpec, typename TSize> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> &, TSize, Insist);       	// "projects/library/seqan/sequence/string_base.h"(1512)
template <typename TValue, typename TSpec, typename TSize, typename TSize2> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> &, TSize, TSize2, Insist);       	// "projects/library/seqan/sequence/string_base.h"(1523)
template <typename TValue, typename TSpec, typename TSize> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> &, TSize, Limit);       	// "projects/library/seqan/sequence/string_base.h"(1533)
template <typename TValue, typename TSpec, typename TSize, typename TSize2> inline typename Value<String<TValue, TSpec> >::Type * _reallocateStorage( String<TValue, TSpec> &, TSize, TSize2, Limit);       	// "projects/library/seqan/sequence/string_base.h"(1544)

//____________________________________________________________________________
// _reserveStorage

template <typename TValue, typename TSpec, typename TSize_> inline void _reserveStorage( String<TValue, TSpec> & , TSize_ , Insist);       	// "projects/library/seqan/sequence/string_base.h"(1557)
template <typename TValue, typename TSpec, typename TSize_> inline void _reserveStorage( String<TValue, TSpec> & , TSize_ , Limit);       	// "projects/library/seqan/sequence/string_base.h"(1567)
template <typename TValue, typename TSpec, typename TSize_, typename TExpand> inline void _reserveStorage( String<TValue, TSpec> & seq, TSize_ new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(1577)

//____________________________________________________________________________
// _setLength

template <typename THost_> inline void _setLength( Segment<THost_, InfixSegment> & me, typename Size<THost_>::Type new_length);       	// "projects/library/seqan/sequence/segment_infix.h"(421)
template <typename THost_, typename TSize> inline void _setLength(Segment<THost_, SuffixSegment> &, TSize);       	// "projects/library/seqan/sequence/segment_suffix.h"(349)
template <typename THost_, typename TSize> inline void _setLength( Segment<THost_, PrefixSegment> & me, TSize new_length);       	// "projects/library/seqan/sequence/segment_prefix.h"(334)

//____________________________________________________________________________
// _streamEOF

template <typename TContainer, typename TSpec> inline bool _streamEOF(Iter<TContainer, TSpec> const & iter);       	// "projects/library/seqan/sequence/sequence_stream.h"(51)

//____________________________________________________________________________
// _streamGet

template <typename TContainer, typename TSpec> inline typename Value<Iter<TContainer, TSpec> >::Type _streamGet(Iter<TContainer, TSpec> & source);       	// "projects/library/seqan/sequence/sequence_stream.h"(78)

//____________________________________________________________________________
// _streamPeek

template <typename TContainer, typename TSpec> inline typename Value<Iter<TContainer, TSpec> >::Type _streamPeek(Iter<TContainer, TSpec> & source);       	// "projects/library/seqan/sequence/sequence_stream.h"(90)

//____________________________________________________________________________
// _streamPut

template <typename TContainer, typename TSpec, typename TChar> inline void _streamPut(Iter<TContainer, TSpec> & target, TChar character);       	// "projects/library/seqan/sequence/sequence_stream.h"(101)

//____________________________________________________________________________
// _streamRead

template <typename TValue, typename TContainer, typename TSpec> inline ::std::streamsize _streamRead(TValue * target, Iter<TContainer, TSpec> & source, ::std::streamsize limit);       	// "projects/library/seqan/sequence/sequence_stream.h"(63)

//____________________________________________________________________________
// _streamSeek2G

template <typename TContainer, typename TSpec> inline void _streamSeek2G(Iter<TContainer, TSpec> & me, int off);       	// "projects/library/seqan/sequence/sequence_stream.h"(160)

//____________________________________________________________________________
// _streamSeekG

template <typename TContainer, typename TSpec> inline void _streamSeekG(Iter<TContainer, TSpec> & me, typename Position<Iter<TContainer, TSpec> >::Type pos);       	// "projects/library/seqan/sequence/sequence_stream.h"(138)

//____________________________________________________________________________
// _streamSeekP

template <typename TContainer, typename TSpec> inline void _streamSeekP(Iter<TContainer, TSpec> & me, typename Position<Iter<TContainer, TSpec> >::Type pos);       	// "projects/library/seqan/sequence/sequence_stream.h"(149)

//____________________________________________________________________________
// _streamTellG

template <typename TContainer, typename TSpec> inline typename Position<Iter<TContainer, TSpec> >::Type _streamTellG(Iter<TContainer, TSpec> & me);       	// "projects/library/seqan/sequence/sequence_stream.h"(117)

//____________________________________________________________________________
// _streamTellP

template <typename TContainer, typename TSpec> inline typename Position<Iter<TContainer, TSpec> >::Type _streamTellP(Iter<TContainer, TSpec> & me);       	// "projects/library/seqan/sequence/sequence_stream.h"(127)

//____________________________________________________________________________
// append

template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(832)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(842)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(854)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(865)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(876)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(886)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(898)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void append( Segment<THost, TSpec> const & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(909)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1150)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSource const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1162)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSourceValue * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1176)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void append(String<TTargetValue, TTargetSpec> & target, TSourceValue * source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1188)

//____________________________________________________________________________
// appendValue

template <typename THost, typename TSpec, typename TValue, typename TExpand> inline void appendValue(Segment<THost, TSpec> & me, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(942)
template <typename THost, typename TSpec, typename TValue, typename TExpand> inline void appendValue(Segment<THost, TSpec> const & me, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(951)
template <typename TTargetValue, typename TTargetSpec, typename TValue, typename TExpand> inline void appendValue(String<TTargetValue, TTargetSpec> & me, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1234)

//____________________________________________________________________________
// assign

template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(479)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(488)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> const & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(500)
template <typename THost, typename TSpec, typename TSource> inline void assign(Segment<THost, TSpec> const & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(509)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(618)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(627)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(638)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(648)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(660)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(669)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(680)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void assign(Segment<THost, TSpec> const & target, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(690)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/string_base.h"(840)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/string_base.h"(849)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(918)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TSize, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSource const & source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(928)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(941)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TSize, typename TExpand> inline void assign(String<TTargetValue, TTargetSpec> & target, TSourceValue const * source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(951)

//____________________________________________________________________________
// assignValue

template <typename TValue, typename TSpec, typename TValue2> inline void assignValue(String<TValue, TSpec> & , TValue2 const & );       	// "projects/library/seqan/sequence/string_base.h"(821)

//____________________________________________________________________________
// atBegin

template <typename THost> inline bool atBegin(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(579)
template <typename THost> inline bool atBegin(Segment<THost, InfixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(586)
template <typename THost> inline bool atBegin(Segment<THost, SuffixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(451)
template <typename THost> inline bool atBegin(Segment<THost, PrefixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(454)

//____________________________________________________________________________
// atEnd

template <typename THost> inline bool atEnd(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(596)
template <typename THost> inline bool atEnd(Segment<THost, InfixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(603)
template <typename THost> inline bool atEnd(Segment<THost, SuffixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(461)
template <typename THost> inline bool atEnd(Segment<THost, PrefixSegment> const & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(464)

//____________________________________________________________________________
// begin

template <typename THost_> inline typename Iterator<Segment<THost_, InfixSegment>, Standard>::Type begin(Segment<THost_, InfixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_infix.h"(237)
template <typename THost_> inline typename Iterator<Segment<THost_, InfixSegment> const, Standard>::Type begin(Segment<THost_, InfixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_infix.h"(245)
template <typename THost_> inline typename Iterator<Segment<THost_, SuffixSegment>, Standard>::Type begin(Segment<THost_, SuffixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_suffix.h"(243)
template <typename THost_> inline typename Iterator<Segment<THost_, SuffixSegment> const, Standard>::Type begin(Segment<THost_, SuffixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_suffix.h"(251)
template <typename THost_> inline typename Iterator<Segment<THost_, PrefixSegment>, Standard>::Type begin(Segment<THost_, PrefixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_prefix.h"(243)
template <typename THost_> inline typename Iterator<Segment<THost_, PrefixSegment> const, Standard>::Type begin(Segment<THost_, PrefixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_prefix.h"(251)

//____________________________________________________________________________
// beginPosition

template <typename THost_> inline typename Position<Segment<THost_, InfixSegment> >::Type beginPosition(Segment<THost_, InfixSegment> & me);       	// "projects/library/seqan/sequence/segment_infix.h"(257)
template <typename THost_> inline typename Position<Segment<THost_, InfixSegment> const>::Type beginPosition(Segment<THost_, InfixSegment> const & me);       	// "projects/library/seqan/sequence/segment_infix.h"(264)
template <typename THost_> inline typename Position<Segment<THost_, SuffixSegment> const>::Type beginPosition(Segment<THost_, SuffixSegment> const & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(261)
template <typename THost_> inline typename Position<Segment<THost_, SuffixSegment> >::Type beginPosition(Segment<THost_, SuffixSegment> & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(268)
template <typename THost_> inline typename Position<Segment<THost_, PrefixSegment> const>::Type beginPosition(Segment<THost_, PrefixSegment> const & );       	// "projects/library/seqan/sequence/segment_prefix.h"(261)
template <typename THost_> inline typename Position<Segment<THost_, PrefixSegment> >::Type beginPosition(Segment<THost_, PrefixSegment> & );       	// "projects/library/seqan/sequence/segment_prefix.h"(268)

//____________________________________________________________________________
// capacity

template <typename THost, typename TSpec> inline typename Size< Segment<THost, TSpec> const>::Type capacity(Segment<THost, TSpec> const & me);       	// "projects/library/seqan/sequence/segment_base.h"(286)

//____________________________________________________________________________
// clear

template <typename THost, typename TSpec> inline void clear(Segment<THost, TSpec> & target);       	// "projects/library/seqan/sequence/segment_base.h"(1232)
template <typename TValue, typename TSpec> inline void clear(String<TValue, TSpec> & me);       	// "projects/library/seqan/sequence/string_base.h"(297)

//____________________________________________________________________________
// compare

template <typename TSpec, typename TLeft, typename TRight> inline void compare(Lexical<TSpec> & lexical, TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(300)
template <typename TSpec, typename TLeftValue, typename TRight> inline void compare(Lexical<TSpec> & lexical, TLeftValue const * left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(311)
template <typename TSpec, typename TLeftValue, typename TRightValue> inline void compare(Lexical<TSpec> & lexical, TLeftValue const * left, TRightValue const * right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(319)
template <typename TSpec, typename TLeft, typename TRightValue> inline void compare(Lexical<TSpec> & lexical, TLeft const & left, TRightValue const * right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(327)

//____________________________________________________________________________
// compare_

template <typename TSpec, typename TLeft, typename TRight> inline void compare_(Lexical<TSpec> & lexical, TLeft & left, TRight & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(258)

//____________________________________________________________________________
// empty

template <typename TValue, typename TSpec> inline bool empty(String<TValue, TSpec> const & me);       	// "projects/library/seqan/sequence/string_base.h"(271)

//____________________________________________________________________________
// end

template <typename THost_> inline typename Iterator<Segment<THost_, InfixSegment>, Standard>::Type end(Segment<THost_, InfixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_infix.h"(328)
template <typename THost_> inline typename Iterator<Segment<THost_, InfixSegment> const, Standard>::Type end(Segment<THost_, InfixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_infix.h"(336)
template <typename THost_> inline typename Iterator<Segment<THost_, SuffixSegment>, Standard>::Type end(Segment<THost_, SuffixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_suffix.h"(306)
template <typename THost_> inline typename Iterator<Segment<THost_, SuffixSegment> const, Standard>::Type end(Segment<THost_, SuffixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_suffix.h"(314)
template <typename THost_> inline typename Iterator<Segment<THost_, PrefixSegment>, Standard>::Type end(Segment<THost_, PrefixSegment> & me, Standard);       	// "projects/library/seqan/sequence/segment_prefix.h"(287)
template <typename THost_> inline typename Iterator<Segment<THost_, PrefixSegment> const, Standard>::Type end(Segment<THost_, PrefixSegment> const & me, Standard);       	// "projects/library/seqan/sequence/segment_prefix.h"(295)

//____________________________________________________________________________
// endPosition

template <typename THost_> inline typename Position<Segment<THost_, InfixSegment> >::Type endPosition(Segment<THost_, InfixSegment> & me);       	// "projects/library/seqan/sequence/segment_infix.h"(348)
template <typename THost_> inline typename Position<Segment<THost_, InfixSegment> >::Type endPosition(Segment<THost_, InfixSegment> const & me);       	// "projects/library/seqan/sequence/segment_infix.h"(355)
template <typename THost_> inline typename Position<Segment<THost_, SuffixSegment> >::Type endPosition(Segment<THost_, SuffixSegment> & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(325)
template <typename THost_> inline typename Position<Segment<THost_, SuffixSegment> const>::Type endPosition(Segment<THost_, SuffixSegment> const & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(333)
template <typename THost_> inline typename Position<Segment<THost_, PrefixSegment> >::Type endPosition(Segment<THost_, PrefixSegment> & me);       	// "projects/library/seqan/sequence/segment_prefix.h"(344)
template <typename THost_> inline typename Position<Segment<THost_, PrefixSegment> const>::Type endPosition(Segment<THost_, PrefixSegment> const & me);       	// "projects/library/seqan/sequence/segment_prefix.h"(351)

//____________________________________________________________________________
// goBegin

template <typename THost> inline void goBegin(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(614)
template <typename THost, typename THost2> inline void goBegin(Segment<THost, InfixSegment> & segment, THost2 &);       	// "projects/library/seqan/sequence/segment_infix.h"(623)
template <typename THost, typename THost2> inline void goBegin(Segment<THost, InfixSegment> & segment, THost2 const &);       	// "projects/library/seqan/sequence/segment_infix.h"(630)
template <typename THost> inline void goBegin(Segment<THost, SuffixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_suffix.h"(472)
template <typename THost> inline void goBegin(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(480)
template <typename THost> inline void goBegin(Segment<THost, PrefixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_prefix.h"(475)
template <typename THost> inline void goBegin(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(483)

//____________________________________________________________________________
// goEnd

template <typename THost> inline void goEnd(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(640)
template <typename THost, typename THost2> inline void goEnd(Segment<THost, InfixSegment> & segment, THost2 &);       	// "projects/library/seqan/sequence/segment_infix.h"(649)
template <typename THost, typename THost2> inline void goEnd(Segment<THost, InfixSegment> & segment, THost2 const &);       	// "projects/library/seqan/sequence/segment_infix.h"(656)
template <typename THost> inline void goEnd(Segment<THost, SuffixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_suffix.h"(490)
template <typename THost> inline void goEnd(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(498)
template <typename THost> inline void goEnd(Segment<THost, PrefixSegment> & segment, THost &);       	// "projects/library/seqan/sequence/segment_prefix.h"(493)
template <typename THost> inline void goEnd(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(501)

//____________________________________________________________________________
// hasNoHost

template <typename THost, typename TSpec> inline bool hasNoHost(Segment<THost, TSpec> const & target);       	// "projects/library/seqan/sequence/segment_base.h"(297)

//____________________________________________________________________________
// hasPrefix

template <typename TLeft, typename TRight > inline bool hasPrefix(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(738)
template <typename TSpec> inline bool hasPrefix(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/sequence_lexical.h"(746)

//____________________________________________________________________________
// host

template <typename THost_> inline typename Parameter_<THost_>::Type host(Segment<THost_, InfixSegment> & me);       	// "projects/library/seqan/sequence/segment_infix.h"(215)
template <typename THost_> inline typename Parameter_<THost_>::Type host(Segment<THost_, InfixSegment> const & me);       	// "projects/library/seqan/sequence/segment_infix.h"(223)
template <typename THost_> inline typename Parameter_<THost_>::Type host(Segment<THost_, SuffixSegment> & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(206)
template <typename THost_> inline typename Parameter_<THost_>::Type host(Segment<THost_, SuffixSegment> const & me);       	// "projects/library/seqan/sequence/segment_suffix.h"(214)
template <typename THost_> inline typename Parameter_<THost_>::Type host(Segment<THost_, PrefixSegment> & me);       	// "projects/library/seqan/sequence/segment_prefix.h"(206)
template <typename THost_> inline typename Parameter_<THost_>::Type host(Segment<THost_, PrefixSegment> const & me);       	// "projects/library/seqan/sequence/segment_prefix.h"(214)

//____________________________________________________________________________
// id

template <typename THost, typename TSpec> inline void const * id(Segment<THost, TSpec> const & me);       	// "projects/library/seqan/sequence/segment_base.h"(262)

//____________________________________________________________________________
// infix

template <typename T, typename TPosBegin, typename TPosEnd> inline typename Infix<T>::Type infix(T & t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(750)
template <typename T, typename TPosBegin, typename TPosEnd> inline typename Infix<T *>::Type infix(T * t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(758)
template <typename T, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<Segment<T, TSpec> >::Type infix(Segment<T, TSpec> & t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(766)
template <typename T, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<Segment<T, TSpec> const>::Type infix(Segment<T, TSpec> const & t, TPosBegin pos_begin, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_infix.h"(777)
template <typename T, typename TSpec, typename TIterSpec> inline typename Infix<Segment<T, TSpec> >::Type infix(Segment<T, TSpec> & t, Iter<Segment<T, TSpec>, TIterSpec> const & iterBegin, Iter<Segment<T, TSpec>, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_infix.h"(792)
template <typename T, typename TSpec, typename TIterSpec> inline typename Infix<Segment<T, TSpec> const>::Type infix(Segment<T, TSpec> const & t, Iter<Segment<T, TSpec> const, TIterSpec> const & iterBegin, Iter<Segment<T, TSpec> const, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_infix.h"(805)

//____________________________________________________________________________
// infixWithLength

template <typename T, typename TPosBegin, typename TSize> inline typename Infix<T>::Type infixWithLength(T & t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(837)
template <typename T, typename TPosBegin, typename TSize> inline typename Infix<T *>::Type infixWithLength(T * t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(845)
template <typename T, typename TSpec, typename TPosBegin, typename TSize> inline typename Infix<Segment<T, TSpec> >::Type infixWithLength(Segment<T, TSpec> & t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(853)
template <typename T, typename TSpec, typename TPosBegin, typename TSize> inline typename Infix<Segment<T, TSpec> const>::Type infixWithLength(Segment<T, TSpec> const & t, TPosBegin pos_begin, TSize length);       	// "projects/library/seqan/sequence/segment_infix.h"(864)

//____________________________________________________________________________
// insertValue

template <typename THost, typename TSpec, typename TPosition, typename TValue, typename TExpand> inline void insertValue(Segment<THost, TSpec> & me, TPosition pos, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(986)
template <typename THost, typename TSpec, typename TPosition, typename TValue, typename TExpand> inline void insertValue(Segment<THost, TSpec> const & me, TPosition pos, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(996)
template <typename TTargetValue, typename TTargetSpec, typename TPosition, typename TValue, typename TExpand> inline void insertValue(String<TTargetValue, TTargetSpec> & me, TPosition pos, TValue const & _value, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1274)

//____________________________________________________________________________
// isEqual

template <typename TLeft, typename TRight > inline bool isEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(353)
template <typename TSpec> inline bool isEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/sequence_lexical.h"(361)

//____________________________________________________________________________
// isGreater

template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isGreater(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/sequence_lexical.h"(568)
template <typename TLeft, typename TRight> inline bool isGreater(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(577)
template <typename TSpec> inline bool isGreater(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/sequence_lexical.h"(586)
template <typename TSpec> inline bool isGreater(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/sequence_lexical.h"(594)
template <typename TSpec> inline bool isGreater(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/sequence_lexical.h"(601)

//____________________________________________________________________________
// isGreaterOrEqual

template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isGreaterOrEqual(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/sequence_lexical.h"(637)
template <typename TLeft, typename TRight> inline bool isGreaterOrEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(646)
template <typename TSpec> inline bool isGreaterOrEqual(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/sequence_lexical.h"(655)
template <typename TSpec> inline bool isGreaterOrEqual(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/sequence_lexical.h"(663)
template <typename TSpec> inline bool isGreaterOrEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/sequence_lexical.h"(670)

//____________________________________________________________________________
// isLess

template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isLess(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/sequence_lexical.h"(431)
template <typename TLeft, typename TRight> inline bool isLess(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(440)
template <typename TSpec> inline bool isLess(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/sequence_lexical.h"(449)
template <typename TSpec> inline bool isLess(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/sequence_lexical.h"(457)
template <typename TSpec> inline bool isLess(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/sequence_lexical.h"(464)

//____________________________________________________________________________
// isLessOrEqual

template <typename TLeft, typename TRight, typename TPrefixOrder > inline bool isLessOrEqual(TLeft const & left, TRight const & right, Tag<TPrefixOrder> const tag);       	// "projects/library/seqan/sequence/sequence_lexical.h"(500)
template <typename TLeft, typename TRight> inline bool isLessOrEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(509)
template <typename TSpec> inline bool isLessOrEqual(Lexical<TSpec> const & _lex, TagPrefixLess);       	// "projects/library/seqan/sequence/sequence_lexical.h"(518)
template <typename TSpec> inline bool isLessOrEqual(Lexical<TSpec> const & _lex, TagPrefixGreater);       	// "projects/library/seqan/sequence/sequence_lexical.h"(526)
template <typename TSpec> inline bool isLessOrEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/sequence_lexical.h"(533)

//____________________________________________________________________________
// isNotEqual

template <typename TLeft, typename TRight > inline bool isNotEqual(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(388)
template <typename TSpec> inline bool isNotEqual(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/sequence_lexical.h"(396)

//____________________________________________________________________________
// isPrefix

template <typename TLeft, typename TRight > inline bool isPrefix(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(699)
template <typename TSpec> inline bool isPrefix(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/sequence_lexical.h"(707)

//____________________________________________________________________________
// lcpLength

template <typename TLeft, typename TRight > inline typename Size<TLeft>::Type lcpLength(TLeft const & left, TRight const & right);       	// "projects/library/seqan/sequence/sequence_lexical.h"(772)
template <typename TSpec> inline typename Size< Lexical<TSpec> >::Type lcpLength(Lexical<TSpec> const & _lex);       	// "projects/library/seqan/sequence/sequence_lexical.h"(781)

//____________________________________________________________________________
// length

template <typename THost, typename TSpec> inline typename Size<Segment<THost, TSpec> const>::Type length(Segment<THost, TSpec> const & me);       	// "projects/library/seqan/sequence/segment_base.h"(274)
template <typename TValue, typename TSpec> inline typename Size< String<TValue, TSpec> const>::Type length(String<TValue, TSpec> const & me);       	// "projects/library/seqan/sequence/string_base.h"(259)

//____________________________________________________________________________
// move

template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(705)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(714)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> const & target, TSource & source);       	// "projects/library/seqan/sequence/segment_base.h"(726)
template <typename THost, typename TSpec, typename TSource, typename TExpand> inline void move(Segment<THost, TSpec> const & target, TSource const & source);       	// "projects/library/seqan/sequence/segment_base.h"(735)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void move(String<TTargetValue, TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/sequence/string_base.h"(1023)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void move(String<TTargetValue, TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/sequence/string_base.h"(1032)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TTag> inline void move(String<TTargetValue, TTargetSpec> & target, TSource & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_base.h"(1045)
template <typename TTargetValue, typename TTargetSpec, typename TSource, typename TTag> inline void move(String<TTargetValue, TTargetSpec> & target, TSource const & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_base.h"(1055)

//____________________________________________________________________________
// operationToSet

template <typename THost, typename TSpec, typename TSource> inline bool operationToSet(Segment<THost, TSpec> &, TSource &);       	// "projects/library/seqan/sequence/segment_base.h"(349)
template <typename THost, typename TSpec, typename TSpec2> inline bool operationToSet(Segment<THost, TSpec> & target, Segment<THost, TSpec2> & source);       	// "projects/library/seqan/sequence/segment_base.h"(356)
template <typename THost, typename TSpec, typename TSpec2> inline bool operationToSet(Segment<THost const, TSpec> & target, Segment<THost, TSpec2> & source);       	// "projects/library/seqan/sequence/segment_base.h"(368)
template <typename THost, typename TSpec, typename TSpec2> inline bool operationToSet(Segment<THost const, TSpec> & target, Segment<THost, TSpec2> const & source);       	// "projects/library/seqan/sequence/segment_base.h"(380)
template <typename THost, typename TSpec, typename TSpec2> inline bool operationToSet(Segment<THost, TSpec> & target, Segment<THost, TSpec2> const & source);       	// "projects/library/seqan/sequence/segment_base.h"(392)
template <typename THost, typename TSpec> inline bool operationToSet(Segment<THost, TSpec> & target, THost & source);       	// "projects/library/seqan/sequence/segment_base.h"(404)
template <typename THost, typename TSpec, typename TSource, typename TSize> inline bool operationToSet(Segment<THost, TSpec> & , TSource & , TSize);       	// "projects/library/seqan/sequence/segment_base.h"(419)
template <typename THost, typename TSpec, typename TSpec2, typename TSize> inline bool operationToSet(Segment<THost, TSpec> & target, Segment<THost, TSpec2> & source, TSize limit);       	// "projects/library/seqan/sequence/segment_base.h"(427)
template <typename THost, typename TSpec, typename TSize> inline bool operationToSet(Segment<THost, TSpec> & target, THost & source, TSize limit);       	// "projects/library/seqan/sequence/segment_base.h"(446)

//____________________________________________________________________________
// operator!=

template <typename TLeftHost, typename TLeftSpec, typename TRight > inline bool operator!= (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1268)
template <typename TLeftValue, typename TLeftSpec, typename TRight > inline bool operator!=(String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1787)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator!= (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1796)

//____________________________________________________________________________
// operator++

template <typename THost> inline Segment<THost, InfixSegment> & operator++(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(665)
template <typename THost> inline Segment<THost, SuffixSegment> & operator++(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(507)
template <typename THost> inline Segment<THost, PrefixSegment> & operator++(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(510)

//____________________________________________________________________________
// operator+=

template <typename TLeftValue, typename TLeftSpec, typename TRight> Segment<TLeftValue, TLeftSpec> const & operator+= (Segment<TLeftValue, TLeftSpec> & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1243)
template <typename TLeftValue, typename TLeftSpec, typename TRight > String<TLeftValue, TLeftSpec> const & operator+= (String<TLeftValue, TLeftSpec> & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1754)

//____________________________________________________________________________
// operator--

template <typename THost> inline Segment<THost, InfixSegment> & operator--(Segment<THost, InfixSegment> & segment);       	// "projects/library/seqan/sequence/segment_infix.h"(685)
template <typename THost> inline Segment<THost, SuffixSegment> & operator--(Segment<THost, SuffixSegment> & segment);       	// "projects/library/seqan/sequence/segment_suffix.h"(517)
template <typename THost> inline Segment<THost, PrefixSegment> & operator--(Segment<THost, PrefixSegment> & segment);       	// "projects/library/seqan/sequence/segment_prefix.h"(520)

//____________________________________________________________________________
// operator<

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator< (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1280)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator< (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1808)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator< (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1816)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename THost, typename TSpec> inline TStream & operator<< (TStream & target, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_base.h"(1326)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator<< (TStream & target, String<TValue, TSpec> const & source);       	// "projects/library/seqan/sequence/string_base.h"(1886)

//____________________________________________________________________________
// operator<=

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator<= (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1291)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator<= (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1827)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator<= (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1835)

//____________________________________________________________________________
// operator==

template <typename TLeftHost, typename TLeftSpec, typename TRight > inline bool operator== (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1256)
template <typename TLeftValue, typename TLeftSpec, typename TRight > inline bool operator== (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1766)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator== (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1775)

//____________________________________________________________________________
// operator>

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator> (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1301)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator> (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1846)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator> (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1854)

//____________________________________________________________________________
// operator>=

template <typename TLeftHost, typename TLeftSpec, typename TRight> inline bool operator>= (Segment<TLeftHost, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/segment_base.h"(1312)
template <typename TLeftValue, typename TLeftSpec, typename TRight> inline bool operator>= (String<TLeftValue, TLeftSpec> const & left, TRight const & right);       	// "projects/library/seqan/sequence/string_base.h"(1865)
template <typename TLeftValue, typename TRightValue, typename TRightSpec > inline bool operator>= (TLeftValue * left, String<TRightValue, TRightSpec> const & right);       	// "projects/library/seqan/sequence/string_base.h"(1873)

//____________________________________________________________________________
// operator>>

template <typename TStream, typename THost, typename TSpec> inline TStream & operator>> (TStream & source, Segment<THost, TSpec> & target);       	// "projects/library/seqan/sequence/segment_base.h"(1338)
template <typename TStream, typename THost, typename TSpec> inline TStream & operator>> (TStream & source, Segment<THost, TSpec> const & target);       	// "projects/library/seqan/sequence/segment_base.h"(1347)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator>> (TStream & source, String<TValue, TSpec> & target);       	// "projects/library/seqan/sequence/string_base.h"(1898)

//____________________________________________________________________________
// ordValue

template <typename TValue> inline unsigned ordValue(TValue const & c);       	// "projects/library/seqan/sequence/sequence_lexical.h"(807)
template <typename TValue, typename TSpec> inline unsigned ordValue(SimpleType<TValue, TSpec> const & c);       	// "projects/library/seqan/sequence/sequence_lexical.h"(813)

//____________________________________________________________________________
// prefix

template <typename T, typename TPosEnd> inline typename Prefix<T>::Type prefix(T & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(552)
template <typename T, typename TPosEnd> inline typename Prefix<T const>::Type prefix(T const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(559)
template <typename T, typename TPosEnd> inline typename Prefix<T *>::Type prefix(T * t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(567)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, PrefixSegment> >::Type prefix(Segment<T, PrefixSegment> & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(577)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, PrefixSegment> const>::Type prefix(Segment<T, PrefixSegment> const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(586)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, InfixSegment> >::Type prefix(Segment<T, InfixSegment> & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(598)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, InfixSegment> const>::Type prefix(Segment<T, InfixSegment> const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(608)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, SuffixSegment> >::Type prefix(Segment<T, SuffixSegment> & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(622)
template <typename T, typename TPosEnd> inline typename Prefix<Segment<T, SuffixSegment> const>::Type prefix(Segment<T, SuffixSegment> const & t, TPosEnd pos_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(632)
template <typename T, typename TIterSpec> inline typename Prefix<T>::Type prefix(T & t, Iter<Segment<T, PrefixSegment>, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_prefix.h"(648)
template <typename T, typename TIterSpec> inline typename Prefix<T const>::Type prefix(T const & t, Iter<Segment<T, PrefixSegment>, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_prefix.h"(656)
template <typename T, typename TIterSpec> inline typename Prefix<T *>::Type prefix(T * t, Iter<Segment<T, PrefixSegment>, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_prefix.h"(665)
template <typename T, typename TIterSpec> inline typename Prefix<Segment<T, PrefixSegment> >::Type prefix(Segment<T, PrefixSegment> & t, Iter<Segment<T, PrefixSegment>, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_prefix.h"(676)
template <typename T, typename TIterSpec> inline typename Prefix<Segment<T, PrefixSegment> const>::Type prefix(Segment<T, PrefixSegment> const & t, Iter<Segment<T, PrefixSegment> const, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_prefix.h"(686)
template <typename T, typename TIterSpec> inline typename Prefix<Segment<T, InfixSegment> >::Type prefix(Segment<T, InfixSegment> & t, Iter<Segment<T, InfixSegment>, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_prefix.h"(699)
template <typename T, typename TIterSpec> inline typename Prefix<Segment<T, InfixSegment> const>::Type prefix(Segment<T, InfixSegment> const & t, Iter<Segment<T, InfixSegment> const, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_prefix.h"(710)
template <typename T, typename TIterSpec> inline typename Prefix<Segment<T, SuffixSegment> >::Type prefix(Segment<T, SuffixSegment> & t, Iter<Segment<T, SuffixSegment> const, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_prefix.h"(725)
template <typename T, typename TIterSpec> inline typename Prefix<Segment<T, SuffixSegment> const>::Type prefix(Segment<T, SuffixSegment> const & t, Iter<Segment<T, SuffixSegment> const, TIterSpec> const & iterEnd);       	// "projects/library/seqan/sequence/segment_prefix.h"(736)

//____________________________________________________________________________
// replace

template <typename THost, typename TSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1100)
template <typename THost, typename TSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1112)
template <typename THost, typename TSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1126)
template <typename THost, typename TSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1139)
template <typename THost, typename TSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1152)
template <typename THost, typename TSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1164)
template <typename THost, typename TSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1178)
template <typename THost, typename TSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace( Segment<THost, TSpec> const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, typename Size< Segment<THost, TSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/segment_base.h"(1191)
template <typename TTargetValue, typename TTargetSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1356)
template <typename TTargetValue, typename TTargetSpec, typename TPositionBegin, typename TPositionEnd, typename TSource, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1370)
template <typename TTargetValue, typename TTargetSpec, typename TPositionBegin, typename TPositionEnd, typename TSourceValue, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1386)
template <typename TTargetValue, typename TTargetSpec, typename TPositionBegin, typename TPositionEnd, typename TSourceValue, typename TExpand> inline void replace(String<TTargetValue, TTargetSpec> & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSourceValue const * source, typename Size< String<TTargetValue, TTargetSpec> >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1400)

//____________________________________________________________________________
// reserve

template <typename TValue, typename TSpec, typename TSize_, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type reserve( String<TValue, TSpec> & seq, TSize_ new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(1609)

//____________________________________________________________________________
// resize

template <typename THost, typename TSpec, typename TExpand> inline typename Size< Segment<THost, TSpec> >::Type resize( Segment<THost, TSpec> & me, typename Size< Segment<THost, TSpec> >::Type new_length, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/segment_base.h"(1206)
template <typename TValue, typename TSpec, typename TSize, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type resize( String<TValue, TSpec> & me, TSize new_length, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1703)
template <typename TValue, typename TSpec, typename TSize, typename TValue2, typename TExpand> inline TSize resize(String<TValue, TSpec> & me, TSize new_length, TValue2 const & val, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_base.h"(1714)

//____________________________________________________________________________
// resizeSpace

template <typename TValue, typename TSpec, typename TSize, typename TBeginPosition, typename TEndPosition, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type resizeSpace(String<TValue, TSpec> & me, TSize size, TBeginPosition pos_begin, TEndPosition pos_end, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(776)
template <typename TValue, typename TSpec, typename TSize, typename TBeginPosition, typename TEndPosition, typename TLimit, typename TExpand> inline typename Size< String<TValue, TSpec> >::Type resizeSpace(String<TValue, TSpec> & me, TSize size, TBeginPosition pos_begin, TEndPosition pos_end, TLimit limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_base.h"(798)

//____________________________________________________________________________
// set

template <typename THost, typename TPosition1, typename TPosition2> inline void set(Segment<THost, InfixSegment> & me, THost & host_, TPosition1 begin_, TPosition2 end_);       	// "projects/library/seqan/sequence/segment_infix.h"(502)
template <typename THost> inline void set(Segment<THost, InfixSegment> & me, THost & host_);       	// "projects/library/seqan/sequence/segment_infix.h"(514)
template <typename THost> inline void set(Segment<THost, InfixSegment> & me, THost const & host_);       	// "projects/library/seqan/sequence/segment_infix.h"(524)
template <typename THost, typename TSpec> inline void set(Segment<THost, InfixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_infix.h"(537)
template <typename THost, typename TSpec> inline void set(Segment<THost const, InfixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_infix.h"(547)
template <typename THost, typename TSpec> inline void set(Segment<THost, InfixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_infix.h"(557)
template <typename THost, typename TSpec> inline void set(Segment<THost const, InfixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_infix.h"(567)
template <typename THost, typename TPosition> inline void set(Segment<THost, SuffixSegment> & me, THost & host_, TPosition begin_);       	// "projects/library/seqan/sequence/segment_suffix.h"(407)
template <typename THost> inline void set(Segment<THost, SuffixSegment> & me, THost & host_);       	// "projects/library/seqan/sequence/segment_suffix.h"(418)
template <typename THost, typename TSpec> inline void set(Segment<THost, SuffixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_suffix.h"(430)
template <typename THost, typename TSpec> inline void set(Segment<THost, SuffixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_suffix.h"(440)
template <typename THost, typename TPosition> inline void set(Segment<THost, PrefixSegment> & me, THost & host_, TPosition end_);       	// "projects/library/seqan/sequence/segment_prefix.h"(410)
template <typename THost> inline void set(Segment<THost, PrefixSegment> & me, THost & host_);       	// "projects/library/seqan/sequence/segment_prefix.h"(421)
template <typename THost, typename TSpec> inline void set(Segment<THost, PrefixSegment> & me, Segment<THost, TSpec> & source);       	// "projects/library/seqan/sequence/segment_prefix.h"(433)
template <typename THost, typename TSpec> inline void set(Segment<THost, PrefixSegment> & me, Segment<THost, TSpec> const & source);       	// "projects/library/seqan/sequence/segment_prefix.h"(443)

//____________________________________________________________________________
// setBegin

template <typename THost_, typename TIterator> inline void setBegin(Segment<THost_, InfixSegment> & me, TIterator new_begin);       	// "projects/library/seqan/sequence/segment_infix.h"(288)
template <typename TIterator> inline void setBegin(TIterator new_begin);       	// "projects/library/seqan/sequence/segment_infix.h"(879)
template <typename THost_, typename TIterator> inline void setBegin(Segment<THost_, SuffixSegment> & me, TIterator new_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(277)
template <typename THost_> inline void setBegin(typename Iterator<Segment<THost_, SuffixSegment>, Rooted>::Type new_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(285)
template <typename THost_, typename TIterator> inline void setBegin(Segment<THost_, PrefixSegment> &, TIterator);       	// "projects/library/seqan/sequence/segment_prefix.h"(278)

//____________________________________________________________________________
// setBeginPosition

template <typename THost_, typename TPosition> inline void setBeginPosition(Segment<THost_, InfixSegment> & me, TPosition new_begin);       	// "projects/library/seqan/sequence/segment_infix.h"(315)
template <typename THost_, typename TPosition> inline void setBeginPosition(Segment<THost_, SuffixSegment> & me, TPosition new_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(295)

//____________________________________________________________________________
// setEnd

template <typename THost_, typename TIterator> inline void setEnd(Segment<THost_, InfixSegment> & me, TIterator new_end);       	// "projects/library/seqan/sequence/segment_infix.h"(381)
template <typename TIterator> inline void setEnd(TIterator new_end);       	// "projects/library/seqan/sequence/segment_infix.h"(891)
template <typename TIterator, typename THost_> inline void setEnd(Segment<THost_, SuffixSegment> &, TIterator);       	// "projects/library/seqan/sequence/segment_suffix.h"(343)
template <typename THost_, typename TIterator> inline void setEnd(Segment<THost_, PrefixSegment> & me, TIterator new_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(314)
template <typename THost_> inline void setEnd(typename Iterator<Segment<THost_, PrefixSegment>, Rooted>::Type new_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(322)

//____________________________________________________________________________
// setEndPosition

template <typename THost_, typename TPosition> inline void setEndPosition(Segment<THost_, InfixSegment> & me, TPosition new_end);       	// "projects/library/seqan/sequence/segment_infix.h"(409)
template <typename THost_, typename TPosition> inline void setEndPosition(Segment<THost_, PrefixSegment> & me, TPosition new_end);       	// "projects/library/seqan/sequence/segment_prefix.h"(306)

//____________________________________________________________________________
// setHost

template <typename THost_> inline void setHost(Segment<THost_, InfixSegment> & me, typename Parameter_<THost_>::Type _host);       	// "projects/library/seqan/sequence/segment_infix.h"(447)
template <typename THost_> inline void setHost(Segment<THost_ const, InfixSegment> & me, typename Parameter_<THost_>::Type _host);       	// "projects/library/seqan/sequence/segment_infix.h"(455)
template <typename THost_> inline void setHost(Segment<THost_, SuffixSegment> & me, typename Parameter_<THost_>::Type _host);       	// "projects/library/seqan/sequence/segment_suffix.h"(224)
template <typename THost_> inline void setHost(Segment<THost_ const, SuffixSegment> & me, typename Parameter_<THost_>::Type _host);       	// "projects/library/seqan/sequence/segment_suffix.h"(232)
template <typename THost_> inline void setHost(Segment<THost_, PrefixSegment> & me, typename Parameter_<THost_>::Type _host);       	// "projects/library/seqan/sequence/segment_prefix.h"(224)
template <typename THost_> inline void setHost(Segment<THost_ const, PrefixSegment> & me, typename Parameter_<THost_>::Type _host);       	// "projects/library/seqan/sequence/segment_prefix.h"(232)

//____________________________________________________________________________
// shareResources

template <typename TValue, typename TSpec> inline bool shareResources(String<TValue, TSpec> const & obj1, TValue const & obj2);       	// "projects/library/seqan/sequence/string_base.h"(208)
template <typename TValue, typename TSpec> inline bool shareResources(TValue const & obj1, String<TValue, TSpec> const & obj2);       	// "projects/library/seqan/sequence/string_base.h"(217)

//____________________________________________________________________________
// suffix

template <typename T, typename TPosBegin> inline typename Suffix<T>::Type suffix(T & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(548)
template <typename T, typename TPosBegin> inline typename Suffix<T const>::Type suffix(T const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(555)
template <typename T, typename TPosBegin> inline typename Suffix<T *>::Type suffix(T * t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(563)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, PrefixSegment> >::Type suffix(Segment<T, PrefixSegment> & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(573)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, PrefixSegment> const>::Type suffix(Segment<T, PrefixSegment> const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(583)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, InfixSegment> >::Type suffix(Segment<T, InfixSegment> & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(596)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, InfixSegment> const>::Type suffix(Segment<T, InfixSegment> const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(606)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, SuffixSegment> >::Type suffix(Segment<T, SuffixSegment> & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(620)
template <typename T, typename TPosBegin> inline typename Suffix<Segment<T, SuffixSegment> const>::Type suffix(Segment<T, SuffixSegment> const & t, TPosBegin pos_begin);       	// "projects/library/seqan/sequence/segment_suffix.h"(629)
template <typename T, typename TIterSpec> inline typename Suffix<T>::Type suffix(T & t, Iter<Segment<T, PrefixSegment>, TIterSpec> const & iterBegin);       	// "projects/library/seqan/sequence/segment_suffix.h"(644)
template <typename T, typename TIterSpec> inline typename Suffix<T const>::Type suffix(T const & t, Iter<Segment<T, PrefixSegment> const, TIterSpec> const & iterBegin);       	// "projects/library/seqan/sequence/segment_suffix.h"(652)
template <typename T> inline typename Suffix<T *>::Type suffix(T * t, T * & iterBegin);       	// "projects/library/seqan/sequence/segment_suffix.h"(661)
template <typename T, typename TIterSpec> inline typename Suffix<Segment<T, PrefixSegment> >::Type suffix(Segment<T, PrefixSegment> & t, Iter<Segment<T, PrefixSegment>, TIterSpec> const & iterBegin);       	// "projects/library/seqan/sequence/segment_suffix.h"(672)
template <typename T, typename TIterSpec> inline typename Suffix<Segment<T, PrefixSegment> const>::Type suffix(Segment<T, PrefixSegment> const & t, Iter<Segment<T, PrefixSegment> const, TIterSpec> const & iterBegin);       	// "projects/library/seqan/sequence/segment_suffix.h"(683)
template <typename T, typename TIterSpec> inline typename Suffix<Segment<T, InfixSegment> >::Type suffix(Segment<T, InfixSegment> & t, Iter<Segment<T, InfixSegment>, TIterSpec> const & iterBegin);       	// "projects/library/seqan/sequence/segment_suffix.h"(697)
template <typename T, typename TIterSpec> inline typename Suffix<Segment<T, InfixSegment> const>::Type suffix(Segment<T, InfixSegment> const & t, Iter<Segment<T, InfixSegment> const, TIterSpec> const & iterBegin);       	// "projects/library/seqan/sequence/segment_suffix.h"(708)
template <typename T, typename TIterSpec> inline typename Suffix<Segment<T, SuffixSegment> >::Type suffix(Segment<T, SuffixSegment> & t, Iter<Segment<T, SuffixSegment>, TIterSpec> const & iterBegin);       	// "projects/library/seqan/sequence/segment_suffix.h"(723)
template <typename T, typename TIterSpec> inline typename Suffix<Segment<T, SuffixSegment> const>::Type suffix(Segment<T, SuffixSegment> const & t, Iter<Segment<T, SuffixSegment> const, TIterSpec> const & iterBegin);       	// "projects/library/seqan/sequence/segment_suffix.h"(733)

//____________________________________________________________________________
// swap

template <typename TAlphabet, typename TSpec> inline void swap(String<TAlphabet, TSpec> & left, String<TAlphabet, TSpec> & right);       	// "projects/library/seqan/sequence/string_base.h"(174)
template <typename TString, typename TSpec> inline void swap(StringSet<TString, TSpec> & left, StringSet<TString, TSpec> & right);       	// "projects/library/seqan/sequence/string_base.h"(189)

//____________________________________________________________________________
// value

template <typename THost, typename TSpec, typename TPos> inline typename Reference< Segment<THost, TSpec> >::Type value(Segment<THost, TSpec> & me, TPos pos);       	// "projects/library/seqan/sequence/segment_infix.h"(708)
template <typename THost, typename TSpec, typename TPos> inline typename Reference< Segment<THost, TSpec> const >::Type value(Segment<THost, TSpec> const & me, TPos pos);       	// "projects/library/seqan/sequence/segment_infix.h"(718)
template <typename TValue, typename TSpec, typename TPos> inline typename Reference< String<TValue, TSpec> >::Type value(String<TValue, TSpec> & me, TPos pos);       	// "projects/library/seqan/sequence/string_base.h"(234)
template <typename TValue, typename TSpec, typename TPos> inline typename Reference< String<TValue, TSpec> const >::Type value(String<TValue, TSpec> const & me, TPos pos);       	// "projects/library/seqan/sequence/string_base.h"(245)

} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _allocateStorage

template <typename TValue, typename TSpec> inline typename Value<String<TValue, Alloc<TSpec> > >::Type * _allocateStorage( String<TValue, Alloc<TSpec> > & me, size_t new_capacity);       	// "projects/library/seqan/sequence/string_alloc.h"(336)

//____________________________________________________________________________
// _assignCopyPackedString

template <typename TTarget, typename TSource, typename TTag> inline void _assignCopyPackedString(TTarget & target, TSource & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(377)
template <typename TTarget, typename TSource, typename TSize, typename TTag> inline void _assignCopyPackedString(TTarget & target, TSource & source, TSize limit, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(396)

//____________________________________________________________________________
// _assignValuePackedStringIterator

template <typename TIter, typename TValue> inline void _assignValuePackedStringIterator(TIter & me, TValue & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1040)

//____________________________________________________________________________
// _beginDefault

template <typename T> inline typename Iterator<T, Standard>::Type _beginDefault(T & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(292)
template <typename T> inline typename Iterator<T const, Standard>::Type _beginDefault(T const & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(301)
template <typename T> inline typename Iterator<T, Rooted>::Type _beginDefault(T & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(311)
template <typename T> inline typename Iterator<T const, Rooted>::Type _beginDefault(T const & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(320)

//____________________________________________________________________________
// _bitpos

template <typename TContainer, typename THostspec> inline unsigned char & _bitpos(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(954)
template <typename TContainer, typename THostspec> inline unsigned char _bitpos(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(961)

//____________________________________________________________________________
// _capacityReturned

template <typename T, typename TSize, typename TExpand> inline typename Size<T>::Type _capacityReturned( T & me, TSize, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_interface.h"(1435)
template <typename T, typename TSize> inline typename Size<T>::Type _capacityReturned( T &, TSize new_capacity, Insist);       	// "projects/library/seqan/sequence/sequence_interface.h"(1445)

//____________________________________________________________________________
// _clearSpace

template <typename TValue, typename THostspec, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(743)
template <typename TValue, typename THostspec, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, typename Size< String<TValue, Packed<THostspec> > >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(754)
template <typename TValue, typename THostspec, typename TPosition, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(766)
template <typename TValue, typename THostspec, typename TPosition, typename TExpand> inline typename Size< String<TValue, Packed<THostspec> > >::Type _clearSpace(String<TValue, Packed<THostspec> > & me, typename Size< String<TValue, Packed<THostspec> > >::Type size, TPosition pos_begin, TPosition pos_end, typename Size< String<TValue, Packed<THostspec> > >::Type limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_packed.h"(779)
template <typename TValue, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(397)
template <typename TValue, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(408)
template <typename TValue, typename TPosition, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, TPosition pos_begin, TPosition pos_end, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(420)
template <typename TValue, typename TPosition, typename TExpand> inline size_t _clearSpace(TValue * me, size_t size, TPosition pos_begin, TPosition pos_end, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(433)

//____________________________________________________________________________
// _computeSizeForCapacity

template <typename T, typename TSize> inline TSize _computeSizeForCapacity(T const & , TSize capacity);       	// "projects/library/seqan/sequence/sequence_interface.h"(974)

//____________________________________________________________________________
// _countNonZeroValues

template <typename TValue, typename TSpec, typename TPos > inline typename Size< String<TValue, TSpec> >::Type _countNonZeroValues(String<TValue, TSpec> const & me, TPos i);       	// "projects/library/seqan/sequence/string_set_base.h"(1004)

//____________________________________________________________________________
// _deallocateStorage

template <typename TValue> inline void _deallocateStorage( String <TValue, CStyle > & me, TValue * ptr, size_t capacity);       	// "projects/library/seqan/sequence/string_cstyle.h"(409)
template <typename TValue, typename TSpec, typename TPtr> inline void _deallocateStorage( String<TValue, Alloc<TSpec> > & me, TPtr * ptr, size_t capacity);       	// "projects/library/seqan/sequence/string_alloc.h"(366)

//____________________________________________________________________________
// _endDefault

template <typename T> inline typename Iterator<T, Standard>::Type _endDefault(T & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(474)
template <typename T> inline typename Iterator<T const, Standard>::Type _endDefault(T const & me, Standard);       	// "projects/library/seqan/sequence/sequence_interface.h"(482)
template <typename T> inline typename Iterator<T, Rooted>::Type _endDefault(T & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(492)
template <typename T> inline typename Iterator<T const, Rooted>::Type _endDefault(T const & me, Rooted);       	// "projects/library/seqan/sequence/sequence_interface.h"(501)

//____________________________________________________________________________
// _findIthNonZeroValue

template <typename TValue, typename TSpec, typename TPos > inline typename Size< String<TValue, TSpec> >::Type _findIthNonZeroValue(String<TValue, TSpec> const & me, TPos i);       	// "projects/library/seqan/sequence/string_set_base.h"(981)

//____________________________________________________________________________
// _reallocateStorage

template <typename TValue> inline TValue * _reallocateStorage( String <TValue, CStyle > & me, size_t new_capacity, Exact);       	// "projects/library/seqan/sequence/string_cstyle.h"(380)

//____________________________________________________________________________
// _refreshStringSetLimits

template <typename TString, typename TSpec > inline void _refreshStringSetLimits(StringSet<TString, Owner<ConcatDirect<TSpec> > > &);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(224)
template <typename T > inline void _refreshStringSetLimits(T &);       	// "projects/library/seqan/sequence/string_set_base.h"(951)
template <typename TString, typename TSpec > inline void _refreshStringSetLimits(StringSet< TString, TSpec > & me);       	// "projects/library/seqan/sequence/string_set_base.h"(955)

//____________________________________________________________________________
// _setBegin

template <typename TValue, typename TValue2> inline void _setBegin(String <TValue, CStyle > & me, TValue2 new_begin);       	// "projects/library/seqan/sequence/string_cstyle.h"(313)
template <typename TValue, typename TSpec, typename TPtr> inline void _setBegin( String<TValue, Alloc<TSpec> > & me, TPtr * new_begin);       	// "projects/library/seqan/sequence/string_alloc.h"(275)

//____________________________________________________________________________
// _setCapacity

template <typename TValue, typename TSpec> inline void _setCapacity( String<TValue, Alloc<TSpec> > & me, size_t new_capacity);       	// "projects/library/seqan/sequence/string_alloc.h"(311)

//____________________________________________________________________________
// _setEnd

template <typename TValue, typename TValue2> inline void _setEnd(String <TValue, CStyle > & me, TValue2 new_end);       	// "projects/library/seqan/sequence/string_cstyle.h"(347)

//____________________________________________________________________________
// _setLength

template <typename TValue, typename THostspec, typename TSize> inline void _setLength( String<TValue, Packed<THostspec> > & me, TSize new_length);       	// "projects/library/seqan/sequence/string_packed.h"(359)
template <typename TValue> inline void _setLength(TValue * me, size_t new_length);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(365)
template <typename TValue, unsigned int LENGTH> inline void _setLength( String<TValue, Array<LENGTH> > & me, size_t new_length);       	// "projects/library/seqan/sequence/string_array.h"(233)
template <typename TValue, typename TSpec> inline void _setLength( String<TValue, Alloc<TSpec> > & me, size_t new_length);       	// "projects/library/seqan/sequence/string_alloc.h"(296)

//____________________________________________________________________________
// _tell

template <typename TStringSet, typename TSpec> inline typename Size<typename Value<TStringSet>::Type >::Type _tell(Iter<TStringSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(319)

//____________________________________________________________________________
// _toCStringImpl

template <typename TValue, typename TSpec> inline TValue * _toCStringImpl(String<TValue, TSpec> & me, True);       	// "projects/library/seqan/sequence/string_cstyle.h"(908)

//____________________________________________________________________________
// _validStringSetLimits

template <typename TString, typename TSpec > inline bool _validStringSetLimits(StringSet<TString, Owner<ConcatDirect<TSpec> > > const &);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(215)
template <typename T > inline bool _validStringSetLimits(T const &);       	// "projects/library/seqan/sequence/string_set_base.h"(937)
template <typename TString, typename TSpec > inline bool _validStringSetLimits(StringSet< TString, TSpec > const & me);       	// "projects/library/seqan/sequence/string_set_base.h"(942)

//____________________________________________________________________________
// append

template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Generous);       	// "projects/library/seqan/sequence/adapt_std_string.h"(434)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/adapt_std_string.h"(445)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(472)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void append(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(483)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1105)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1114)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1123)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1132)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1142)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1152)
template <typename TTarget, typename TSource> inline void append(TTarget & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1162)
template <typename TTarget, typename TSource> inline void append(TTarget const & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1172)
template <typename TTargetValue, typename TSource, typename TExpand> inline void append(TTargetValue * target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(541)
template <typename TTargetValue, typename TSource, typename TExpand> inline void append(TTargetValue * target, TSource const & source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(552)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void append(TTargetValue * target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(565)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void append(TTargetValue * target, TSourceValue const * source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(576)
template <typename TValue, unsigned int SPACE, typename TSource, typename TExpand> inline void append( String<TValue, Block<SPACE> >& me, TSource const& source, Tag<TExpand> const );       	// "projects/library/seqan/sequence/string_block.h"(408)
template <typename TChar, typename TAlloc, typename TSource> inline void append(::std::vector<TChar, TAlloc> & target, TSource const & source, Generous);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(432)
template <typename TChar, typename TAlloc, typename TSource> inline void append(::std::vector<TChar, TAlloc> & target, TSource const & source, typename Size< ::std::vector<TChar, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(443)
template <typename TChar, typename TAlloc, typename TSource> inline void append(::std::vector<TChar, TAlloc> & target, TSource const & source, Limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(471)
template <typename TChar, typename TAlloc, typename TSource> inline void append(::std::vector<TChar, TAlloc> & target, TSource const & source, typename Size< ::std::vector<TChar, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(482)

//____________________________________________________________________________
// appendValue

template <typename TString, typename TExpand > inline void appendValue( StringSet<TString, Dependent<Tight> > & me, TString const & obj, Tag<TExpand> const & tag);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(147)
template <typename TString, typename TString2, typename TExpand > inline void appendValue( StringSet<TString, Owner<Default> > & me, TString2 const & obj, Tag<TExpand> const & tag);       	// "projects/library/seqan/sequence/string_set_owner.h"(129)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TValue, typename TTag> inline void appendValue(::std::basic_string<TChar, TCharTraits, TAlloc> & me, TValue const & _value, TTag);       	// "projects/library/seqan/sequence/adapt_std_string.h"(501)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TValue> inline void appendValue(::std::basic_string<TChar, TCharTraits, TAlloc> & me, TValue const & _value, Limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(511)
template <typename TString, typename TString2, typename TExpand > inline void appendValue( StringSet<TString, Owner<ConcatDirect<void> > > & me, TString2 const & obj, Tag<TExpand> const & tag);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(235)
template <typename TString, typename TDelimiter, typename TString2, typename TExpand > inline void appendValue( StringSet<TString, Owner<ConcatDirect<TDelimiter> > > & me, TString2 const & obj, Tag<TExpand> const & tag);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(245)
template <typename T, typename TValue> inline void appendValue(T & me, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1199)
template <typename T, typename TValue> inline void appendValue(T const & me, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1208)
template <typename TValue, unsigned int SPACE, typename TVal, typename TExpand> inline void appendValue( String<TValue, Block<SPACE> >& me, TVal const& source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_block.h"(427)
template <typename TChar, typename TAlloc, typename TValue, typename TTag> inline void appendValue(::std::vector<TChar, TAlloc> & me, TValue const & _value, TTag);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(500)
template <typename TChar, typename TAlloc, typename TValue> inline void appendValue(::std::vector<TChar, TAlloc> & me, TValue const & _value, Limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(510)
template <typename TString, typename TExpand > inline void appendValue( StringSet<TString, Dependent<Generous> > & me, TString const & obj, Tag<TExpand> const & tag);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(122)

//____________________________________________________________________________
// assign

template <typename TValue> inline void assign(String <TValue, CStyle > & target, TValue * source);       	// "projects/library/seqan/sequence/string_cstyle.h"(448)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource & source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(464)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource const & source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(474)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource & source, TSize , Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(485)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSource const & source, TSize limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(496)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSourceValue const * source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(508)
template <typename TTargetValue, typename TSourceValue, typename TSize, typename TExpand> inline void assign(String<TTargetValue, CStyle> & target, TSourceValue const * source, TSize limit, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_cstyle.h"(519)
template <typename TValue, typename TSourceSpec, typename TExpand> inline void assign(String<TValue, CStyle> & target, String<TValue, TSourceSpec> & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(587)
template <typename TValue, typename THostspec, typename TTag> inline void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(423)
template <typename TValue, typename THostspec, typename TTag> inline void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > const & source, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(432)
template <typename TValue, typename THostspec, typename TSize, typename TTag> void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > & source, TSize limit, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(441)
template <typename TValue, typename THostspec, typename TSize, typename TTag> void assign(String<TValue, Packed<THostspec> > & target, String<TValue, Packed<THostspec> > const & source, TSize limit, Tag<TTag> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(449)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source);       	// "projects/library/seqan/sequence/adapt_std_string.h"(281)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source);       	// "projects/library/seqan/sequence/adapt_std_string.h"(289)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource, typename TSize> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, TSize limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(299)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource, typename TSize> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, TSize limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(308)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, Generous);       	// "projects/library/seqan/sequence/adapt_std_string.h"(320)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Generous);       	// "projects/library/seqan/sequence/adapt_std_string.h"(329)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/adapt_std_string.h"(356)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/adapt_std_string.h"(366)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, Limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(378)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, Limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(387)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(398)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(413)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1045)
template <typename TTarget, typename TSource> inline void assign(TTarget const & target, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1055)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1065)
template <typename TTarget, typename TSource> inline void assign(TTarget const & target, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1075)
template <typename TTargetValue, typename TSource> inline void assign(TTargetValue * target, TSource & source);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(447)
template <typename TTargetValue, typename TSource> inline void assign(TTargetValue * target, TSource const & source);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(456)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(TTargetValue * target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(467)
template <typename TTargetValue, typename TSource, typename TExpand> inline void assign(TTargetValue * target, TSource const & source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(478)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void assign(TTargetValue * target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(491)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void assign(TTargetValue * target, TSourceValue const * source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(502)
template <typename TValue, unsigned int SPACE, typename TSource> inline void assign( String<TValue, Block<SPACE> >& target, TSource const& source);       	// "projects/library/seqan/sequence/string_block.h"(245)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource & source);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(279)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource const & source);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(287)
template <typename TChar, typename TAlloc, typename TSource, typename TSize> inline void assign(::std::vector<TChar, TAlloc> & target, TSource & source, TSize limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(297)
template <typename TChar, typename TAlloc, typename TSource, typename TSize> inline void assign(::std::vector<TChar, TAlloc> & target, TSource const & source, TSize limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(306)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource & source, Generous);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(318)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource const & source, Generous);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(327)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource & source, typename Size< ::std::vector<TChar, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(354)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource const & source, typename Size< ::std::vector<TChar, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(364)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource & source, Limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(376)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource const & source, Limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(385)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource & source, typename Size< ::std::vector<TChar, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(396)
template <typename TChar, typename TAlloc, typename TSource> inline void assign(::std::vector<TChar, TAlloc> & target, TSource const & source, typename Size< ::std::vector<TChar, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(411)

//____________________________________________________________________________
// assignValue

template <typename TContainer, typename THostspec, typename TValue> inline void assignValue(Iter<TContainer, Packed<THostspec> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1057)
template <typename TContainer, typename THostspec, typename TValue> inline void assignValue(Iter<TContainer, Packed<THostspec> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1067)
template <typename TString, typename TSpec, typename TPos, typename TSequence > inline void assignValue( StringSet<TString, Owner<TSpec> > & me, TPos pos, TSequence const & seq);       	// "projects/library/seqan/sequence/string_set_owner.h"(144)
template <typename T, typename TValue, typename TPos> inline void assignValue(T & me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(833)
template <typename TValue, typename TPos> inline void assignValue(TValue * me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(285)

//____________________________________________________________________________
// assignValueById

template <typename TString, typename TString2> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type assignValueById(StringSet<TString, Dependent<Tight> >& me, TString2& obj);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(215)
template <typename TString, typename TId1> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type assignValueById(StringSet<TString, Dependent<Tight> >& me, TString& obj, TId1 id);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(228)
template <typename TString, typename TSpec, typename TId> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type assignValueById(StringSet<TString, Owner<TSpec> > & me, TString& obj, TId id);       	// "projects/library/seqan/sequence/string_set_owner.h"(216)
template <typename TString, typename TSpec, typename TString2> inline typename Id<StringSet<TString, TSpec> >::Type assignValueById(StringSet<TString, TSpec>& me, TString2& obj);       	// "projects/library/seqan/sequence/string_set_base.h"(1201)
template <typename TString, typename TSpec1, typename TSpec2, typename TId> inline typename Id<StringSet<TString, TSpec1> >::Type assignValueById(StringSet<TString, TSpec1>& dest, StringSet<TString, TSpec2>& source, TId id);       	// "projects/library/seqan/sequence/string_set_base.h"(1213)
template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type assignValueById(StringSet<TString, Dependent<Generous> >& me, TString& obj, TId id);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(194)

//____________________________________________________________________________
// assign_std_string_Generous_impl

template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void assign_std_string_Generous_impl(::std::basic_string<TChar, TCharTraits, TAlloc> & target, TSource & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(340)

//____________________________________________________________________________
// assign_std_vector_Generous_impl

template <typename TChar, typename TAlloc, typename TSource> inline void assign_std_vector_Generous_impl(::std::vector<TChar, TAlloc> & target, TSource & source, typename Size< ::std::vector<TChar, TAlloc> >::Type limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(338)

//____________________________________________________________________________
// atBegin

template <typename TSSet, typename TSpec> inline bool atBegin(Iter<TSSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(442)
template <typename TSSet, typename TSpec> inline bool atBegin(Iter<TSSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(449)

//____________________________________________________________________________
// atEnd

template <typename TValue> inline bool atEnd(TValue * pos);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(307)
template <typename TValue> inline bool atEnd(TValue const * pos, TValue const * );       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(316)
template <typename TSSet, typename TSpec> inline bool atEnd(Iter<TSSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(460)
template <typename TSSet, typename TSpec> inline bool atEnd(Iter<TSSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(467)
template <typename TValue, unsigned int SPACE, typename TIteratorSpec> inline bool atEnd( Iter<String<TValue, Block<SPACE> >, TIteratorSpec>& it, String<TValue, Block<SPACE> >& container);       	// "projects/library/seqan/sequence/string_block.h"(287)

//____________________________________________________________________________
// atEndOfSequence

template <typename TIterator> inline bool atEndOfSequence(TIterator const & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(492)
template <typename TSSet, typename TSpec> inline bool atEndOfSequence(Iter<TSSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(499)
template <typename TIterator> inline bool atEndOfSequence(TIterator & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(510)

//____________________________________________________________________________
// back

template <typename T> inline typename Reference<T const>::Type back(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(732)
template <typename T> inline typename Reference<T>::Type back(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(740)

//____________________________________________________________________________
// begin

template <typename TValue> inline typename Iterator<String<TValue, CStyle >, Standard>::Type begin(String <TValue, CStyle > & me, Standard);       	// "projects/library/seqan/sequence/string_cstyle.h"(292)
template <typename TValue> inline typename Iterator<String<TValue, CStyle > const, Standard>::Type begin(String <TValue, CStyle > const & me, Standard);       	// "projects/library/seqan/sequence/string_cstyle.h"(301)
template <typename TStringSet, typename TSpec > inline typename Iterator<ConcatenatorManyToOne<TStringSet const>, Tag<TSpec> const>::Type begin(ConcatenatorManyToOne<TStringSet const> concat, Tag<TSpec> const &);       	// "projects/library/seqan/sequence/sequence_concatenator.h"(220)
template <typename TStringSet, typename TSpec > inline typename Iterator<ConcatenatorManyToOne<TStringSet>, Tag<TSpec> const>::Type begin(ConcatenatorManyToOne<TStringSet> concat, Tag<TSpec> const &);       	// "projects/library/seqan/sequence/sequence_concatenator.h"(228)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> >, Tag<TTag> const>::Type begin(String<TValue, Packed<THostspec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(499)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> > const, Tag<TTag> const>::Type begin(String<TValue, Packed<THostspec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(508)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc>, Standard>::Type begin(::std::basic_string<TChar, TCharTraits, TAlloc> & me, Standard);       	// "projects/library/seqan/sequence/adapt_std_string.h"(186)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc> const, Standard>::Type begin(::std::basic_string<TChar, TCharTraits, TAlloc> const & me, Standard);       	// "projects/library/seqan/sequence/adapt_std_string.h"(194)
template <typename T> inline typename Iterator<T, typename DefaultGetIteratorSpec<T>::Type>::Type begin(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(351)
template <typename T> inline typename Iterator<T const, typename DefaultGetIteratorSpec<T>::Type>::Type begin(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(359)
template <typename T, typename TSpec> inline typename Iterator<T, Tag<TSpec> const>::Type begin(T & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(375)
template <typename T, typename TSpec> inline typename Iterator<T const, Tag<TSpec> const>::Type begin(T const & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(383)
template <typename T> inline typename Iterator<T *, typename DefaultGetIteratorSpec<T>::Type>::Type begin(T * me);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(172)
template <typename TValue> inline typename Iterator<TValue *, Standard>::Type begin(TValue * me, Standard);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(183)
template <typename TValue> inline typename Iterator<TValue const *, Standard>::Type begin(TValue const * me, Standard);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(194)
template <typename TValue, typename TSpec> inline typename Iterator<TValue *, Tag<TSpec> const>::Type begin(TValue * me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(203)
template <typename TValue, typename TSpec> inline typename Iterator<TValue const *, Tag<TSpec> const>::Type begin(TValue const * me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(213)
template <typename TValue, unsigned int LENGTH> inline typename Iterator<String<TValue, Array<LENGTH> >, Standard>::Type begin(String<TValue, Array<LENGTH> > & me, Standard);       	// "projects/library/seqan/sequence/string_array.h"(160)
template <typename TValue, unsigned int LENGTH> inline typename Iterator<String<TValue, Array<LENGTH> > const, Standard>::Type begin(String<TValue, Array<LENGTH> > const & me, Standard);       	// "projects/library/seqan/sequence/string_array.h"(168)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> >, Tag<TSpec> const >::Type begin(String<TValue, Block<SPACE> > & me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_block.h"(203)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> > const, Tag<TSpec> const>::Type begin(String<TValue, Block<SPACE> > const & me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_block.h"(211)
template <typename TString, typename TSpec, typename TTag> inline typename Iterator<StringSet<TString, TSpec >, Tag<TTag> const>::Type begin(StringSet<TString, TSpec > & me, Tag<TTag> const & tag);       	// "projects/library/seqan/sequence/string_set_base.h"(1084)
template <typename TString, typename TSpec, typename TTag> inline typename Iterator<StringSet<TString, TSpec > const, Tag<TTag> const>::Type begin(StringSet<TString, TSpec > const & me, Tag<TTag> const & tag);       	// "projects/library/seqan/sequence/string_set_base.h"(1092)
template <typename TChar, typename TAlloc> inline typename Iterator< ::std::vector<TChar, TAlloc>, Standard>::Type begin(::std::vector<TChar, TAlloc> & me, Standard);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(184)
template <typename TChar, typename TAlloc> inline typename Iterator< ::std::vector<TChar, TAlloc> const, Standard>::Type begin(::std::vector<TChar, TAlloc> const & me, Standard);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(192)
template <typename TValue, typename TSpec> inline typename Iterator<String<TValue, Alloc<TSpec> >, Standard>::Type begin(String<TValue, Alloc<TSpec> > & me, Standard);       	// "projects/library/seqan/sequence/string_alloc.h"(199)
template <typename TValue, typename TSpec> inline typename Iterator<String<TValue, Alloc<TSpec> > const, Standard>::Type begin(String<TValue, Alloc<TSpec> > const & me, Standard);       	// "projects/library/seqan/sequence/string_alloc.h"(207)

//____________________________________________________________________________
// beginPosition

template <typename T> inline typename Position<T>::Type beginPosition(T &);       	// "projects/library/seqan/sequence/sequence_interface.h"(452)
template <typename T> inline typename Position<T>::Type beginPosition(T const &);       	// "projects/library/seqan/sequence/sequence_interface.h"(460)

//____________________________________________________________________________
// capacity

template <typename TValue> inline size_t capacity(String <TValue, CStyle > const & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(361)
template <typename TValue, typename THostspec> inline typename Size<String<TValue, Packed<THostspec> > const>::Type capacity(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(566)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type capacity(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/adapt_std_string.h"(248)
template <typename T> inline typename Size<T const>::Type capacity(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(929)
template <typename TValue, unsigned int LENGTH> inline size_t capacity(String<TValue, Array<LENGTH> > &);       	// "projects/library/seqan/sequence/string_array.h"(197)
template <typename TValue, unsigned int LENGTH> inline size_t capacity(String<TValue, Array<LENGTH> > const &);       	// "projects/library/seqan/sequence/string_array.h"(205)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type capacity(String<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/sequence/string_block.h"(605)
template <typename TChar, typename TAlloc> inline typename Size< ::std::vector<TChar, TAlloc> >::Type capacity(::std::vector<TChar, TAlloc> const & me);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(246)
template <typename TValue, typename TSpec> inline size_t capacity(String<TValue, Alloc<TSpec> > & me);       	// "projects/library/seqan/sequence/string_alloc.h"(236)
template <typename TValue, typename TSpec> inline size_t capacity(String<TValue, Alloc<TSpec> > const & me);       	// "projects/library/seqan/sequence/string_alloc.h"(244)

//____________________________________________________________________________
// clear

template <typename TString > inline void clear(StringSet<TString, Dependent<Tight> >& me);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(164)
template <typename TValue> inline void clear(String<TValue, CStyle> & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(599)
template <typename TValue, typename THostspec> inline void clear(String<TValue, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(581)
template <typename TString > inline void clear(StringSet<TString, Owner<Default> > & me);       	// "projects/library/seqan/sequence/string_set_owner.h"(167)
template <typename TChar, typename TCharTraits, typename TAlloc> inline void clear(::std::basic_string<TChar, TCharTraits, TAlloc> & me);       	// "projects/library/seqan/sequence/adapt_std_string.h"(266)
template <typename TString, typename TDelimiter > inline void clear(StringSet<TString, Owner<ConcatDirect<TDelimiter> > > & me);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(310)
template <typename TValue> inline void clear(TValue * me);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(375)
template <typename TValue, unsigned int SPACE> inline void clear(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_block.h"(301)
template <typename TChar, typename TAlloc> inline void clear(::std::vector<TChar, TAlloc> & me);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(264)
template <typename TString > inline void clear(StringSet<TString, Dependent<Generous> > & me);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(134)

//____________________________________________________________________________
// computeGenerousCapacity

template <typename T, typename TSize> inline TSize computeGenerousCapacity(T const & , TSize capacity);       	// "projects/library/seqan/sequence/sequence_interface.h"(1003)

//____________________________________________________________________________
// concat

template <typename TString, typename TSpec> inline typename Concatenator<StringSet<TString, Owner<ConcatDirect<TSpec> > > >::Type & concat(StringSet<TString, Owner<ConcatDirect<TSpec> > > & me);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(456)
template <typename TString, typename TSpec> inline typename Concatenator<StringSet<TString, Owner<ConcatDirect<TSpec> > > const>::Type & concat(StringSet<TString, Owner<ConcatDirect<TSpec> > > const & me);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(463)
template <typename TString> inline typename Concatenator<TString>::Type & concat(TString & string);       	// "projects/library/seqan/sequence/string_set_base.h"(1280)
template <typename TString> inline typename Concatenator<TString const>::Type & concat(TString const & string);       	// "projects/library/seqan/sequence/string_set_base.h"(1288)
template <typename TString, typename TSpec> inline typename Concatenator<StringSet<TString, TSpec> >::Type & concat(StringSet<TString, TSpec> & me);       	// "projects/library/seqan/sequence/string_set_base.h"(1295)
template <typename TString, typename TSpec> inline typename Concatenator<StringSet<TString, TSpec> const>::Type & concat(StringSet<TString, TSpec> const & constMe);       	// "projects/library/seqan/sequence/string_set_base.h"(1303)

//____________________________________________________________________________
// container

template <typename TContainer, typename THostspec> inline typename Parameter_<TContainer>::Type container(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(908)
template <typename TContainer, typename THostspec> inline typename Parameter_<TContainer>::Type container(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(915)
template <typename TSSet, typename TSpec> inline typename Concatenator<TSSet>::Type container(Iter<TSSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(424)
template <typename TSSet, typename TSpec> inline typename Concatenator<TSSet>::Type container(Iter<TSSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(431)

//____________________________________________________________________________
// countSequences

template <typename TString> inline unsigned countSequences(TString const &);       	// "projects/library/seqan/sequence/string_set_base.h"(885)
template <typename TString, typename TSpec> inline typename Size<StringSet<TString, TSpec> >::Type countSequences(StringSet<TString, TSpec> const & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(891)

//____________________________________________________________________________
// create

template <typename TTargetValue, typename TSource> inline void create(String<TTargetValue, CStyle> & target, TSource & source);       	// "projects/library/seqan/sequence/string_cstyle.h"(770)
template <typename TTargetValue, typename TSource, typename TSize> inline void create(String<TTargetValue, CStyle> & target, TSource & source, TSize limit);       	// "projects/library/seqan/sequence/string_cstyle.h"(781)
template <typename TTargetValue, typename TSource, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(792)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource & source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(803)
template <typename TTargetValue, typename TSource, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(813)
template <typename TTargetValue, typename TSource, typename TSize, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSource const & source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(824)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(836)
template <typename TTargetValue, typename TSourceValue, typename TSize, typename TExpand> inline void create(String<TTargetValue, CStyle> & target, TSourceValue const * source, TSize limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_cstyle.h"(847)

//____________________________________________________________________________
// dependent

template <typename TValue> inline bool dependent(String <TValue, CStyle > & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(434)

//____________________________________________________________________________
// empty

template <typename TChar, typename TCharTraits, typename TAlloc> inline bool empty(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/adapt_std_string.h"(257)
template <typename T> inline bool empty(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(953)
template <typename TValue> inline bool empty(TValue * me);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(387)
template <typename TValue, unsigned int SPACE> inline bool empty(String<TValue, Block<SPACE> > const& me);       	// "projects/library/seqan/sequence/string_block.h"(578)
template <typename TChar, typename TAlloc> inline bool empty(::std::vector<TChar, TAlloc> const & me);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(255)

//____________________________________________________________________________
// end

template <typename TValue> inline typename Iterator<String <TValue, CStyle >, Standard>::Type end(String <TValue, CStyle > & me, Standard);       	// "projects/library/seqan/sequence/string_cstyle.h"(326)
template <typename TValue> inline typename Iterator<String <TValue, CStyle > const, Standard>::Type end(String <TValue, CStyle > const & me, Standard);       	// "projects/library/seqan/sequence/string_cstyle.h"(335)
template <typename TStringSet, typename TSpec > inline typename Iterator<ConcatenatorManyToOne<TStringSet const>, Tag<TSpec> const>::Type end(ConcatenatorManyToOne<TStringSet const> concat, Tag<TSpec> const &);       	// "projects/library/seqan/sequence/sequence_concatenator.h"(240)
template <typename TStringSet, typename TSpec > inline typename Iterator<ConcatenatorManyToOne<TStringSet>, Tag<TSpec> const>::Type end(ConcatenatorManyToOne<TStringSet> concat, Tag<TSpec> const &);       	// "projects/library/seqan/sequence/sequence_concatenator.h"(248)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> >, Tag<TTag> const>::Type end(String<TValue, Packed<THostspec> > & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(521)
template <typename TValue, typename THostspec, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> > const, Tag<TTag> const>::Type end(String<TValue, Packed<THostspec> > const & me, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/string_packed.h"(530)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc>, Standard>::Type end(::std::basic_string<TChar, TCharTraits, TAlloc> & me, Standard);       	// "projects/library/seqan/sequence/adapt_std_string.h"(204)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Iterator< ::std::basic_string<TChar, TCharTraits, TAlloc> const, Standard>::Type end(::std::basic_string<TChar, TCharTraits, TAlloc> const & me, Standard);       	// "projects/library/seqan/sequence/adapt_std_string.h"(212)
template <typename T> inline typename Iterator<T, typename DefaultGetIteratorSpec<T>::Type>::Type end(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(532)
template <typename T> inline typename Iterator<T const, typename DefaultGetIteratorSpec<T>::Type>::Type end(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(540)
template <typename T, typename TSpec> inline typename Iterator<T, Tag<TSpec> const>::Type end(T & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(549)
template <typename T, typename TSpec> inline typename Iterator<T const, Tag<TSpec> const>::Type end(T const & me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(558)
template <typename TValue> inline typename Iterator<TValue *, Standard>::Type end(TValue * me, Standard);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(225)
template <typename TValue> inline typename Iterator<TValue const *, Standard>::Type end(TValue const * me, Standard);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(235)
template <typename TValue, typename TSpec> inline typename Iterator<TValue *, Tag<TSpec> const>::Type end(TValue * me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(244)
template <typename TValue, typename TSpec> inline typename Iterator<TValue const *, Tag<TSpec> const>::Type end(TValue const * me, Tag<TSpec> const tag_);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(253)
template <typename TValue, unsigned int LENGTH> inline typename Iterator<String<TValue, Array<LENGTH> >, Standard>::Type end(String<TValue, Array<LENGTH> > & me, Standard);       	// "projects/library/seqan/sequence/string_array.h"(179)
template <typename TValue, unsigned int LENGTH> inline typename Iterator<String<TValue, Array<LENGTH> > const, Standard>::Type end(String<TValue, Array<LENGTH> > const & me, Standard);       	// "projects/library/seqan/sequence/string_array.h"(187)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> >, Tag<TSpec> const >::Type end(String<TValue, Block<SPACE> > & me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_block.h"(223)
template <typename TValue, unsigned int SPACE, typename TSpec> inline typename Iterator<String<TValue, Block<SPACE> > const, Tag<TSpec> const>::Type end(String<TValue, Block<SPACE> > const & me, Tag<TSpec> const);       	// "projects/library/seqan/sequence/string_block.h"(231)
template <typename TString, typename TSpec, typename TTag> inline typename Iterator<StringSet<TString, TSpec >, Tag<TTag> const>::Type end(StringSet<TString, TSpec > & me, Tag<TTag> const & tag);       	// "projects/library/seqan/sequence/string_set_base.h"(1105)
template <typename TString, typename TSpec, typename TTag> inline typename Iterator<StringSet<TString, TSpec > const, Tag<TTag> const>::Type end(StringSet<TString, TSpec > const & me, Tag<TTag> const & tag);       	// "projects/library/seqan/sequence/string_set_base.h"(1113)
template <typename TChar, typename TAlloc> inline typename Iterator< ::std::vector<TChar, TAlloc>, Standard>::Type end(::std::vector<TChar, TAlloc> & me, Standard);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(202)
template <typename TChar, typename TAlloc> inline typename Iterator< ::std::vector<TChar, TAlloc> const, Standard>::Type end(::std::vector<TChar, TAlloc> const & me, Standard);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(210)
template <typename TValue, typename TSpec> inline typename Iterator<String<TValue, Alloc<TSpec> >, Standard>::Type end(String<TValue, Alloc<TSpec> > & me, Standard);       	// "projects/library/seqan/sequence/string_alloc.h"(218)
template <typename TValue, typename TSpec> inline typename Iterator<String<TValue, Alloc<TSpec> > const, Standard>::Type end(String<TValue, Alloc<TSpec> > const & me, Standard);       	// "projects/library/seqan/sequence/string_alloc.h"(226)

//____________________________________________________________________________
// endPosition

template <typename T> inline typename Position<T>::Type endPosition(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(584)
template <typename T> inline typename Position<T>::Type endPosition(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(592)

//____________________________________________________________________________
// erase

template <typename TString, typename TDelimiter, typename TPos > inline void erase( StringSet<TString, Owner<ConcatDirect<TDelimiter> > > & me, TPos pos, TPos pos_end);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(285)
template <typename T, typename TBeginPosition, typename TEndPosition> inline void erase(T & me, TBeginPosition pos, TEndPosition pos_end);       	// "projects/library/seqan/sequence/sequence_interface.h"(1614)
template <typename T, typename TBeginPosition, typename TEndPosition> inline void erase(T const & me, TBeginPosition pos, TEndPosition pos_end);       	// "projects/library/seqan/sequence/sequence_interface.h"(1625)
template <typename T, typename TPosition> inline void erase(T & me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(1634)
template <typename T, typename TPosition> inline void erase(T const & me, TPosition pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(1643)

//____________________________________________________________________________
// eraseBack

template <typename T> inline void eraseBack(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(1666)

//____________________________________________________________________________
// fill

template <typename TChar, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::vector<TChar, TAlloc> >::Type fill( ::std::vector<TChar, TAlloc> & me, TSize new_length, TChar const & val, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(700)

//____________________________________________________________________________
// front

template <typename T> inline typename Reference<T>::Type front(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(697)
template <typename T> inline typename Reference<T const>::Type front(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(704)

//____________________________________________________________________________
// getSeqNo

template <typename TPosition> inline TPosition getSeqNo(TPosition const &, Nothing const &);       	// "projects/library/seqan/sequence/string_set_base.h"(346)
template <typename TPosition> inline TPosition getSeqNo(TPosition const &);       	// "projects/library/seqan/sequence/string_set_base.h"(354)
template <typename T1, typename T2, typename TCompression, typename TLimitsString> inline T1 getSeqNo(Pair<T1, T2, TCompression> const & pos, TLimitsString const &);       	// "projects/library/seqan/sequence/string_set_base.h"(361)
template <typename T1, typename T2, typename TCompression> inline T1 getSeqNo(Pair<T1, T2, TCompression> const & pos);       	// "projects/library/seqan/sequence/string_set_base.h"(368)
template <typename TPos, typename TLimitsString> inline TPos getSeqNo(TPos const & pos, TLimitsString const & limits);       	// "projects/library/seqan/sequence/string_set_base.h"(375)

//____________________________________________________________________________
// getSeqOffset

template <typename TPosition> inline TPosition getSeqOffset(TPosition const & pos, Nothing const &);       	// "projects/library/seqan/sequence/string_set_base.h"(406)
template <typename TPosition> inline TPosition getSeqOffset(TPosition const & pos);       	// "projects/library/seqan/sequence/string_set_base.h"(414)
template <typename T1, typename T2, typename TCompression, typename TLimitsString> inline T2 getSeqOffset(Pair<T1, T2, TCompression> const & pos, TLimitsString const &);       	// "projects/library/seqan/sequence/string_set_base.h"(420)
template <typename T1, typename T2, typename TCompression> inline T1 getSeqOffset(Pair<T1, T2, TCompression> const & pos);       	// "projects/library/seqan/sequence/string_set_base.h"(426)
template <typename TPos, typename TLimitsString> inline TPos getSeqOffset(TPos const & pos, TLimitsString const & limits);       	// "projects/library/seqan/sequence/string_set_base.h"(432)

//____________________________________________________________________________
// getSequenceByNo

template <typename TSeqNo, typename TString> inline typename GetSequenceByNo<TString>::Type getSequenceByNo(TSeqNo , TString & string);       	// "projects/library/seqan/sequence/string_set_base.h"(902)
template <typename TSeqNo, typename TString, typename TSpec> inline typename GetSequenceByNo< StringSet<TString, TSpec> >::Type getSequenceByNo(TSeqNo seqNo, StringSet<TString, TSpec> & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(909)
template <typename TSeqNo, typename TString, typename TSpec> inline typename GetSequenceByNo< StringSet<TString, TSpec> const>::Type getSequenceByNo(TSeqNo seqNo, StringSet<TString, TSpec> const & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(916)

//____________________________________________________________________________
// getValue

template <typename TContainer, typename THostspec> inline typename GetValue<Iter<TContainer, Packed<THostspec> > >::Type getValue(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(1020)
template <typename TContainer, typename THostspec> inline typename GetValue<Iter<TContainer, Packed<THostspec> > const>::Type getValue(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(1027)
template <typename T, typename TPos> inline typename GetValue<T>::Type getValue(T & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(661)
template <typename T, typename TPos> inline typename GetValue<T const>::Type getValue(T const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(670)

//____________________________________________________________________________
// getValueById

template <typename TString, typename TId> inline typename Reference<StringSet<TString, Dependent<Tight> > >::Type getValueById(StringSet<TString, Dependent<Tight> > & me, TId const id);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(202)
template <typename TString, typename TSpec, typename TId> inline typename Reference<StringSet<TString, Owner<TSpec> > >::Type getValueById(StringSet<TString, Owner<TSpec> >& me, TId const id);       	// "projects/library/seqan/sequence/string_set_owner.h"(200)
template <typename TString, typename TId> inline typename Reference<StringSet<TString, Dependent<Generous> > >::Type getValueById(StringSet<TString, Dependent<Generous> >& me, TId const id);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(177)

//____________________________________________________________________________
// goNext

template <typename TContainer, typename THostspec> inline void goNext(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(1216)
template <typename TStringSet, typename TSpec> inline void goNext(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(257)

//____________________________________________________________________________
// goPrevious

template <typename TContainer, typename THostspec> inline void goPrevious(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(1237)
template <typename TStringSet, typename TSpec> inline void goPrevious(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(286)

//____________________________________________________________________________
// host

template <typename TValue, typename THostspec> inline typename Host<String<TValue, Packed<THostspec> > >::Type & host(String<TValue, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(317)
template <typename TValue, typename THostspec> inline typename Host<String<TValue, Packed<THostspec> > const>::Type const & host(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(325)

//____________________________________________________________________________
// hostIterator

template <typename TContainer, typename THostspec> inline typename HostIterator<Iter<TContainer, Packed<THostspec> > >::Type & hostIterator(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(937)
template <typename TContainer, typename THostspec> inline typename HostIterator<Iter<TContainer, Packed<THostspec> > const>::Type & hostIterator(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(944)

//____________________________________________________________________________
// id

template <typename TValue, typename THostspec> inline void const * id(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(460)
template <typename TChar, typename TCharTraits, typename TAlloc> inline void const * id(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/adapt_std_string.h"(173)
template <typename T> inline void const * id(T const & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(252)
template <typename TChar, typename TAlloc> inline void const * id(::std::vector<TChar, TAlloc> const & me);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(171)

//____________________________________________________________________________
// idToPosition

template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type idToPosition(StringSet<TString, Dependent<Tight> > const & me, TId const id);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(309)
template <typename TString, typename TSpec, typename TId> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type idToPosition(StringSet<TString, Owner<TSpec> > const&, TId const id);       	// "projects/library/seqan/sequence/string_set_owner.h"(276)
template <typename TString, typename TId> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type idToPosition(StringSet<TString, Dependent<Generous> > const& me, TId const id);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(255)

//____________________________________________________________________________
// infix

template <typename TString, typename TDelimiter, typename TPosBegin, typename TPosEnd > inline typename Infix<TString>::Type infix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > & me, TPosBegin posBegin, TPosEnd posEnd);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(402)
template <typename TString, typename TDelimiter, typename TPosBegin, typename TPosEnd > inline typename Infix<TString const>::Type infix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const & me, TPosBegin posBegin, TPosEnd posEnd);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(409)
template <typename TString, typename TSpec, typename TPosBegin, typename TPosEnd > inline typename Infix<TString>::Type infix(StringSet< TString, TSpec > & me, TPosBegin posBegin, TPosEnd posEnd);       	// "projects/library/seqan/sequence/string_set_base.h"(676)
template <typename TString, typename TSpec, typename TPosBegin, typename TPosEnd > inline typename Infix<TString const>::Type infix(StringSet< TString, TSpec > const & me, TPosBegin posBegin, TPosEnd posEnd);       	// "projects/library/seqan/sequence/string_set_base.h"(691)

//____________________________________________________________________________
// infixWithLength

template <typename TString, typename TDelimiter, typename TPosition, typename TSize > inline typename Infix<TString>::Type infixWithLength(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > & me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(420)
template <typename TString, typename TDelimiter, typename TPosition, typename TSize > inline typename Infix<TString const>::Type infixWithLength(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const & me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(427)
template <typename TString, typename TSpec, typename TPosition, typename TSize > inline typename Infix<TString>::Type infixWithLength(StringSet< TString, TSpec > & me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/string_set_base.h"(642)
template <typename TString, typename TSpec, typename TPosition, typename TSize > inline typename Infix<TString const>::Type infixWithLength(StringSet< TString, TSpec > const & me, TPosition pos, TSize length);       	// "projects/library/seqan/sequence/string_set_base.h"(656)

//____________________________________________________________________________
// insert

template <typename T, typename TPosition, typename TSeq, typename TExpand> inline void insert(T & me, TPosition pos, TSeq const & insertSeq, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_interface.h"(1238)
template <typename T, typename TPosition, typename TSeq, typename TExpand> inline void insert(T const & me, TPosition pos, TSeq const & insertSeq, Tag<TExpand> const);       	// "projects/library/seqan/sequence/sequence_interface.h"(1249)
template <typename T, typename TPosition, typename TSeq> inline void insert(T & me, TPosition pos, TSeq const & insertSeq);       	// "projects/library/seqan/sequence/sequence_interface.h"(1259)
template <typename T, typename TPosition, typename TSeq> inline void insert(T const & me, TPosition pos, TSeq const & insertSeq);       	// "projects/library/seqan/sequence/sequence_interface.h"(1269)

//____________________________________________________________________________
// insertValue

template <typename TString, typename TDelimiter, typename TPos, typename TSequence, typename TExpand > inline void insertValue( StringSet<TString, Owner<ConcatDirect<TDelimiter> > > & me, TPos pos, TSequence const & seq, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(262)
template <typename T, typename TPosition, typename TValue> inline void insertValue(T & me, TPosition pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1298)
template <typename T, typename TPosition, typename TValue> inline void insertValue(T const & me, TPosition pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(1308)

//____________________________________________________________________________
// isEqual

template <typename TLeftValue, typename TRight > inline bool isEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(712)

//____________________________________________________________________________
// isGreater

template <typename TLeftValue, typename TRight> inline bool isGreater(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(797)

//____________________________________________________________________________
// isGreaterOrEqual

template <typename TLeftValue, typename TRight> inline bool isGreaterOrEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(817)

//____________________________________________________________________________
// isLess

template <typename TLeftValue, typename TRight> inline bool isLess(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(757)

//____________________________________________________________________________
// isLessOrEqual

template <typename TLeftValue, typename TRight> inline bool isLessOrEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(777)

//____________________________________________________________________________
// isNotEqual

template <typename TLeftValue, typename TRight > inline bool isNotEqual(TLeftValue * left, TRight const & right);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(734)

//____________________________________________________________________________
// iter

template <typename TValue, typename THostspec, typename TPos, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> >, Tag<TTag> const>::Type iter(String<TValue, Packed<THostspec> > & me, TPos pos_, Tag<TTag> const);       	// "projects/library/seqan/sequence/string_packed.h"(474)
template <typename TValue, typename THostspec, typename TPos, typename TTag> inline typename Iterator<String<TValue, Packed<THostspec> > const, Tag<TTag> const>::Type iter(String<TValue, Packed<THostspec> > const & me, TPos pos_, Tag<TTag> const);       	// "projects/library/seqan/sequence/string_packed.h"(485)
template <typename T, typename TPos> inline typename Iterator<T, typename DefaultGetIteratorSpec<T>::Type>::Type iter(T & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(773)
template <typename T, typename TPos> inline typename Iterator<T const, typename DefaultGetIteratorSpec<T>::Type>::Type iter(T const & me, TPos pos);       	// "projects/library/seqan/sequence/sequence_interface.h"(782)
template <typename T, typename TPos, typename TTag> inline typename Iterator<T, Tag<TTag> const>::Type iter(T & me, TPos pos, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(792)
template <typename T, typename TPos, typename TTag> inline typename Iterator<T const, Tag<TTag> const>::Type iter(T const & me, TPos pos, Tag<TTag> const tag_);       	// "projects/library/seqan/sequence/sequence_interface.h"(803)
template <typename TString, typename TSpec, typename TPos, typename TTag> inline typename Iterator<StringSet<TString, TSpec >, Tag<TTag> const>::Type iter(StringSet<TString, TSpec > & me, TPos pos, Tag<TTag> const &);       	// "projects/library/seqan/sequence/string_set_base.h"(1056)
template <typename TString, typename TSpec, typename TPos, typename TTag> inline typename Iterator<StringSet<TString, TSpec > const, Tag<TTag> const>::Type iter(StringSet<TString, TSpec > const & me, TPos pos, Tag<TTag> const &);       	// "projects/library/seqan/sequence/string_set_base.h"(1068)

//____________________________________________________________________________
// length

template <typename TStringSet > inline typename Size<ConcatenatorManyToOne<TStringSet> >::Type length(ConcatenatorManyToOne<TStringSet> const & me);       	// "projects/library/seqan/sequence/sequence_concatenator.h"(209)
template <typename TValue, typename THostspec> inline typename Size<String<TValue, Packed<THostspec> > >::Type length(String<TValue, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(337)
template <typename TValue, typename THostspec> inline typename Size<String<TValue, Packed<THostspec> > const>::Type length(String<TValue, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(345)
template <typename TChar, typename TCharTraits, typename TAlloc> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type length(::std::basic_string<TChar, TCharTraits, TAlloc> const & me);       	// "projects/library/seqan/sequence/adapt_std_string.h"(239)
template <typename TString, typename TDelimiter> inline typename Size<StringSet<TString, Owner<ConcatDirect<TDelimiter> > > >::Type length(StringSet<TString, Owner<ConcatDirect<TDelimiter> > > const & me);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(323)
template <typename T> inline typename Size<T>::Type length(T const & );       	// "projects/library/seqan/sequence/sequence_interface.h"(901)
template <typename TValue> inline size_t length(TValue * me);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(326)
template <typename TValue> inline size_t length(TValue const * me);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(338)
inline size_t length(char * me);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(349)
inline size_t length(char const * me);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(356)
template <typename TValue, unsigned int SPACE> inline typename Size<String<TValue, Block<SPACE> > >::Type length(String<TValue, Block<SPACE> > const & me);       	// "projects/library/seqan/sequence/string_block.h"(590)
template <typename TString, typename TSpec > inline typename Size<StringSet<TString, TSpec > >::Type length(StringSet<TString, TSpec > const & me);       	// "projects/library/seqan/sequence/string_set_base.h"(1042)
template <typename TChar, typename TAlloc> inline typename Size< ::std::vector<TChar, TAlloc> >::Type length(::std::vector<TChar, TAlloc> const & me);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(237)

//____________________________________________________________________________
// lengthSum

template <typename TString > inline typename Size<TString>::Type lengthSum(TString const & me);       	// "projects/library/seqan/sequence/string_set_base.h"(1019)
template <typename TString, typename TSpec > inline typename Size<TString>::Type lengthSum(StringSet< TString, TSpec > const & me);       	// "projects/library/seqan/sequence/string_set_base.h"(1025)

//____________________________________________________________________________
// move

template <typename TValue> inline void move( String <TValue, CStyle > & target, String <TValue, CStyle > & source);       	// "projects/library/seqan/sequence/string_cstyle.h"(261)
template <typename TValue> inline void move( String <TValue, CStyle > & target, String <TValue, CStyle > const & source);       	// "projects/library/seqan/sequence/string_cstyle.h"(279)
template <typename TTargetValue, typename TSource> inline void move(TTargetValue * & target, TSource & source);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(515)
template <typename TTargetValue, typename TSource> inline void move(TTargetValue * & target, TSource const & source);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(523)
template <typename TTargetValue, typename TSourceValue, typename TSpec> inline void move(String<TTargetValue, Alloc<TSpec> > & target, String<TSourceValue, Alloc<TSpec> > & source);       	// "projects/library/seqan/sequence/string_alloc.h"(402)
template <typename TTargetValue, typename TSourceValue, typename TSpec> inline void move(String<TTargetValue, Alloc<TSpec> > & target, String<TSourceValue, Alloc<TSpec> > const & source);       	// "projects/library/seqan/sequence/string_alloc.h"(409)
template <typename TValue, typename TSpec> inline void move(String<TValue, Alloc<TSpec> > & target, String<TValue, Alloc<TSpec> > & source);       	// "projects/library/seqan/sequence/string_alloc.h"(417)
template <typename TValue, typename TSpec> inline void move(String<TValue, Alloc<TSpec> > & target, String<TValue, Alloc<TSpec> > const & source);       	// "projects/library/seqan/sequence/string_alloc.h"(432)

//____________________________________________________________________________
// moveValue

template <typename TContainer, typename THostspec, typename TValue> inline void moveValue(Iter<TContainer, Packed<THostspec> > & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1082)
template <typename TContainer, typename THostspec, typename TValue> inline void moveValue(Iter<TContainer, Packed<THostspec> > const & me, TValue const & _value);       	// "projects/library/seqan/sequence/string_packed.h"(1090)
template <typename T, typename TValue, typename TPos> inline void moveValue(T & me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(864)
template <typename T, typename TValue, typename TPos> inline void moveValue(T const & me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/sequence_interface.h"(874)
template <typename TValue, typename TPos> inline void moveValue(TValue * me, TPos pos, TValue const & _value);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(297)

//____________________________________________________________________________
// operator!=

template <typename TContainer, typename THostspec> inline bool operator!= (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1152)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator!=( Iter<TSSetL, ConcatVirtual<TSpecL> > const & L, Iter<TSSetR, ConcatVirtual<TSpecR> > const & R);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(388)

//____________________________________________________________________________
// operator*

template <typename TStringSet, typename TSpec> inline typename Reference<Iter<TStringSet, ConcatVirtual<TSpec> > const>::Type operator*(Iter<TStringSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(239)
template <typename TStringSet, typename TSpec> inline typename Reference<Iter<TStringSet, ConcatVirtual<TSpec> > >::Type operator*(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(246)

//____________________________________________________________________________
// operator+

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > operator+ (Iter<TContainer, Packed<THostspec> > const & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1259)
template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > operator+ (TIntegral left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1267)
template <typename TStringSet, typename TSpec, typename TDelta> inline Iter<TStringSet, ConcatVirtual<TSpec> > operator+(Iter<TStringSet, ConcatVirtual<TSpec> > const & me, TDelta delta);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(332)
template <typename TStringSet, typename TSpec, typename T1, typename T2, typename TCompression> inline Iter<TStringSet, ConcatVirtual<TSpec> > operator+(Iter<TStringSet, ConcatVirtual<TSpec> > const & me, Pair<T1, T2, TCompression> delta);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(341)

//____________________________________________________________________________
// operator++

template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator++(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(265)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator++(Iter<TStringSet, ConcatVirtual<TSpec> > & me, int);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(273)

//____________________________________________________________________________
// operator+=

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > & operator+= (Iter<TContainer, Packed<THostspec> > & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1280)

//____________________________________________________________________________
// operator-

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > operator- (Iter<TContainer, Packed<THostspec> > const & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1294)
template <typename TContainer, typename THostspec> inline typename Difference<Iter<TContainer, Packed<THostspec> > >::Type operator- (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1305)
template <typename TContainer, typename THostspec> inline typename Difference<Iter<TContainer, Packed<THostspec> > >::Type operator- (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > & right);       	// "projects/library/seqan/sequence/string_packed.h"(1314)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> typename Difference<Iter<TSSetL, ConcatVirtual<TSpecL> > >::Type operator-( Iter<TSSetL, ConcatVirtual<TSpecL> > const & L, Iter<TSSetR, ConcatVirtual<TSpecR> > const & R);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(356)
template <typename TStringSet, typename TSpec, typename TDelta> inline Iter<TStringSet, ConcatVirtual<TSpec> > operator-(Iter<TStringSet, ConcatVirtual<TSpec> > const & me, TDelta delta);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(363)

//____________________________________________________________________________
// operator--

template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator--(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(298)
template <typename TStringSet, typename TSpec> inline Iter<TStringSet, ConcatVirtual<TSpec> > const & operator--(Iter<TStringSet, ConcatVirtual<TSpec> > & me, int);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(306)

//____________________________________________________________________________
// operator-=

template <typename TContainer, typename THostspec, typename TIntegral> inline Iter<TContainer, Packed<THostspec> > & operator-= (Iter<TContainer, Packed<THostspec> > & left, TIntegral right);       	// "projects/library/seqan/sequence/string_packed.h"(1327)

//____________________________________________________________________________
// operator<

template <typename TContainer, typename THostspec> inline bool operator< (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1191)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator<( Iter<TSSetL, ConcatVirtual<TSpecL> > const & L, Iter<TSSetR, ConcatVirtual<TSpecR> > const & R);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(402)

//____________________________________________________________________________
// operator<=

template <typename TContainer, typename THostspec> inline bool operator<= (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1204)

//____________________________________________________________________________
// operator==

template <typename TContainer, typename THostspec> inline bool operator== (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1139)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator==( Iter<TSSetL, ConcatVirtual<TSpecL> > const & L, Iter<TSSetR, ConcatVirtual<TSpecR> > const & R);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(378)

//____________________________________________________________________________
// operator>

template <typename TContainer, typename THostspec> inline bool operator> (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1165)
template <typename TSSetL, typename TSpecL, typename TSSetR, typename TSpecR> inline bool operator> ( Iter<TSSetL, ConcatVirtual<TSpecL> > const & L, Iter<TSSetR, ConcatVirtual<TSpecR> > const & R);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(412)

//____________________________________________________________________________
// operator>=

template <typename TContainer, typename THostspec> inline bool operator>= (Iter<TContainer, Packed<THostspec> > const & left, Iter<TContainer, Packed<THostspec> > const & right);       	// "projects/library/seqan/sequence/string_packed.h"(1178)

//____________________________________________________________________________
// pop

template <typename TValue, unsigned int SPACE> inline void pop(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_block.h"(538)

//____________________________________________________________________________
// pop_back

template <typename TValue, unsigned int SPACE> inline void pop_back(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_block.h"(566)

//____________________________________________________________________________
// posAdd

template <typename TPos, typename TDelta> inline TPos posAdd(TPos pos, TDelta delta);       	// "projects/library/seqan/sequence/string_set_base.h"(767)
template <typename T1, typename T2, typename TCompression, typename TDelta> inline Pair<T1, T2, TCompression> posAdd(Pair<T1, T2, TCompression> const & pos, TDelta delta);       	// "projects/library/seqan/sequence/string_set_base.h"(773)

//____________________________________________________________________________
// posAddAndCheck

template <typename TPos, typename TDelta, typename TSequence> inline TPos posAddAndCheck(TPos & pos, TDelta delta, TSequence const & sequence);       	// "projects/library/seqan/sequence/string_set_base.h"(783)
template <typename TPos, typename TDelta, typename TSequence, typename TSpec> inline TPos posAddAndCheck(TPos & pos, TDelta delta, StringSet<TSequence, TSpec> const & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(789)
template <typename T1, typename T2, typename TCompression, typename TDelta, typename TSequence, typename TSpec> inline bool posAddAndCheck(Pair<T1, T2, TCompression> & pos, TDelta delta, StringSet<TSequence, TSpec> const & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(807)

//____________________________________________________________________________
// posAtEnd

template <typename T1, typename T2, typename TCompression, typename TSequence, typename TSpec> inline bool posAtEnd(Pair<T1, T2, TCompression> const & pos, StringSet<TSequence, TSpec> const & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(721)
template <typename TPos, typename TSequence, typename TSpec> inline bool posAtEnd(TPos pos, StringSet<TSequence, TSpec> const & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(725)
template <typename TPos, typename TSequence> inline bool posAtEnd(TPos pos, TSequence const & seq);       	// "projects/library/seqan/sequence/string_set_base.h"(729)

//____________________________________________________________________________
// posAtFirstLocal

template <typename TPos, typename TLimitsString> inline bool posAtFirstLocal(TPos pos, TLimitsString const & limits);       	// "projects/library/seqan/sequence/string_set_base.h"(708)
template <typename TPos> inline bool posAtFirstLocal(TPos pos);       	// "projects/library/seqan/sequence/string_set_base.h"(712)

//____________________________________________________________________________
// posCompare

template <typename TPos> inline int posCompare(TPos const & a, TPos const & b);       	// "projects/library/seqan/sequence/string_set_base.h"(850)
template <typename T1, typename T2, typename TCompression> inline int posCompare(Pair<T1, T2, TCompression> const & a, Pair<T1, T2, TCompression> const & b);       	// "projects/library/seqan/sequence/string_set_base.h"(857)

//____________________________________________________________________________
// posGlobalize

template <typename TPosition> inline TPosition posGlobalize(TPosition const & pos, Nothing const &);       	// "projects/library/seqan/sequence/string_set_base.h"(461)
template <typename T1, typename T2, typename TCompression> inline T2 posGlobalize(Pair<T1, T2, TCompression> const & pos, Nothing const &);       	// "projects/library/seqan/sequence/string_set_base.h"(468)
template <typename TLimitsString, typename TPosition> inline TPosition posGlobalize(TPosition const & pos, TLimitsString const &);       	// "projects/library/seqan/sequence/string_set_base.h"(475)
template <typename TLimitsString, typename T1, typename T2, typename TCompression> inline typename Value<TLimitsString>::Type posGlobalize(Pair<T1, T2, TCompression> const & pos, TLimitsString const & limits);       	// "projects/library/seqan/sequence/string_set_base.h"(483)

//____________________________________________________________________________
// posLess

template <typename TPos> inline bool posLess(TPos const & a, TPos const & b);       	// "projects/library/seqan/sequence/string_set_base.h"(834)
template <typename T1, typename T2, typename TCompression> inline bool posLess(Pair<T1, T2, TCompression> const & a, Pair<T1, T2, TCompression> const & b);       	// "projects/library/seqan/sequence/string_set_base.h"(839)

//____________________________________________________________________________
// posLocalToX

template <typename TDest, typename TLimitsString, typename T1, typename T2, typename TCompression> inline void posLocalToX(TDest & dst, Pair<T1, T2, TCompression> const & localPos, TLimitsString const & limits);       	// "projects/library/seqan/sequence/string_set_base.h"(507)
template <typename TD1, typename TD2, typename TDCompression, typename TLimitsString, typename T1, typename T2, typename TCompression> inline void posLocalToX(Pair<TD1, TD2, TDCompression> & dst, Pair<T1, T2, TCompression> const & localPos, TLimitsString const &);       	// "projects/library/seqan/sequence/string_set_base.h"(514)

//____________________________________________________________________________
// posLocalize

template <typename TResult, typename TPosition> inline void posLocalize(TResult & result, TPosition const & pos, Nothing const &);       	// "projects/library/seqan/sequence/string_set_base.h"(539)
template <typename T1, typename T2, typename TCompression, typename TPosition> inline void posLocalize(Pair<T1, T2, TCompression> & result, TPosition const & pos, Nothing const &);       	// "projects/library/seqan/sequence/string_set_base.h"(544)
template <typename TResult, typename TSize, typename TSpec, typename TPosition> inline void posLocalize(TResult & result, TPosition const & pos, String<TSize, TSpec> const & limits);       	// "projects/library/seqan/sequence/string_set_base.h"(551)
template <typename TResult, typename TSize, typename TSpec, typename T1, typename T2, typename TCompression> inline void posLocalize(TResult & result, Pair<T1, T2, TCompression> const & pos, String<TSize, TSpec> const & );       	// "projects/library/seqan/sequence/string_set_base.h"(561)

//____________________________________________________________________________
// posNext

template <typename TPos> inline TPos posNext(TPos pos);       	// "projects/library/seqan/sequence/string_set_base.h"(752)
template <typename T1, typename T2, typename TCompression> inline Pair<T1, T2, TCompression> posNext(Pair<T1, T2, TCompression> const & pos);       	// "projects/library/seqan/sequence/string_set_base.h"(758)

//____________________________________________________________________________
// posPrev

template <typename TPos> inline TPos posPrev(TPos pos);       	// "projects/library/seqan/sequence/string_set_base.h"(738)
template <typename T1, typename T2, typename TCompression> inline Pair<T1, T2, TCompression> posPrev(Pair<T1, T2, TCompression> const & pos);       	// "projects/library/seqan/sequence/string_set_base.h"(743)

//____________________________________________________________________________
// posSub

template <typename TA, typename TB> inline TA posSub(TA a, TB b);       	// "projects/library/seqan/sequence/string_set_base.h"(816)
template <typename TA1, typename TA2, typename TACompression, typename TB1, typename TB2, typename TBCompression > inline TA2 posSub(Pair<TA1, TA2, TACompression> const & a, Pair<TB1, TB2, TBCompression> const & b);       	// "projects/library/seqan/sequence/string_set_base.h"(825)

//____________________________________________________________________________
// position

template <typename TContainer, typename THostspec> inline typename Position<Iter<TContainer, Packed<THostspec> > const>::Type position(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(973)

//____________________________________________________________________________
// positionToId

template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type positionToId(StringSet<TString, Dependent<Tight> > & me, TPos const pos);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(287)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Tight> > >::Type positionToId(StringSet<TString, Dependent<Tight> > const & me, TPos const pos);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(296)
template <typename TString, typename TSpec, typename TPos> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type positionToId(StringSet<TString, Owner<TSpec> > &, TPos const pos);       	// "projects/library/seqan/sequence/string_set_owner.h"(250)
template <typename TString, typename TSpec, typename TPos> inline typename Id<StringSet<TString, Owner<TSpec> > >::Type positionToId(StringSet<TString, Owner<TSpec> > const &, TPos const pos);       	// "projects/library/seqan/sequence/string_set_owner.h"(263)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type positionToId(StringSet<TString, Dependent<Generous> >& me, TPos const pos);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(233)
template <typename TString, typename TPos> inline typename Id<StringSet<TString, Dependent<Generous> > >::Type positionToId(StringSet<TString, Dependent<Generous> > const& me, TPos const pos);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(242)

//____________________________________________________________________________
// prefix

template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString>::Type prefix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > & me, TPosition pos);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(366)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString const>::Type prefix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const & me, TPosition pos);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(373)
template <typename TString, typename TSpec, typename TPosition > inline typename Prefix<TString>::Type prefix(StringSet< TString, TSpec > & me, TPosition pos);       	// "projects/library/seqan/sequence/string_set_base.h"(574)
template <typename TString, typename TSpec, typename TPosition > inline typename Prefix<TString const>::Type prefix(StringSet< TString, TSpec > const & me, TPosition pos);       	// "projects/library/seqan/sequence/string_set_base.h"(588)

//____________________________________________________________________________
// push

template <typename TValue, unsigned int SPACE, typename TVal> inline void push( String<TValue, Block<SPACE> >& me, TVal const& source);       	// "projects/library/seqan/sequence/string_block.h"(450)
template <typename TValue, unsigned int SPACE> inline void push(String<TValue, Block<SPACE> >& me);       	// "projects/library/seqan/sequence/string_block.h"(457)

//____________________________________________________________________________
// push_back

template <typename TValue, unsigned int SPACE, typename TVal> inline void push_back( String<TValue, Block<SPACE> >& me, TVal const& source);       	// "projects/library/seqan/sequence/string_block.h"(481)

//____________________________________________________________________________
// removeValueById

template <typename TString, typename TId> inline void removeValueById(StringSet<TString, Dependent<Tight> >& me, TId const id);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(257)
template <typename TString, typename TSpec, typename TId> inline void removeValueById(StringSet<TString, Owner<TSpec> > & me, TId const id);       	// "projects/library/seqan/sequence/string_set_owner.h"(235)
template <typename TString, typename TId> inline void removeValueById(StringSet<TString, Dependent<Generous> >& me, TId const id);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(213)

//____________________________________________________________________________
// replace

template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, Generous);       	// "projects/library/seqan/sequence/adapt_std_string.h"(529)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/adapt_std_string.h"(542)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, Limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(576)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource> inline void replace(::std::basic_string<TChar, TCharTraits, TAlloc> & target, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_begin, typename Position< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type pos_end, TSource const & source, typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/adapt_std_string.h"(589)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1346)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1356)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1366)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source);       	// "projects/library/seqan/sequence/sequence_interface.h"(1376)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1387)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1398)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1409)
template <typename TTarget, typename TPositionBegin, typename TPositionEnd, typename TSource> inline void replace(TTarget const & target, TPositionBegin pos_begin, TPositionEnd pos_end, TSource const & source, typename Size<TTarget>::Type limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1420)
template <typename TTargetValue, typename TSource, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSource const & source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(595)
template <typename TTargetValue, typename TSource, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSource const & source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(608)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSourceValue const * source, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(622)
template <typename TTargetValue, typename TSourceValue, typename TExpand> inline void replace(TTargetValue * target, size_t pos_begin, size_t pos_end, TSourceValue const * source, size_t limit, Tag<TExpand> const);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(635)
template <typename TChar, typename TAlloc, typename TSource> inline void replace(::std::vector<TChar, TAlloc> & target, typename Position< ::std::vector<TChar, TAlloc> >::Type pos_begin, typename Position< ::std::vector<TChar, TAlloc> >::Type pos_end, TSource const & source, Generous);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(528)
template <typename TChar, typename TAlloc, typename TSource> inline void replace(::std::vector<TChar, TAlloc> & target, typename Position< ::std::vector<TChar, TAlloc> >::Type pos_begin, typename Position< ::std::vector<TChar, TAlloc> >::Type pos_end, TSource const & source, typename Size< ::std::vector<TChar, TAlloc> >::Type limit, Generous);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(554)
template <typename TChar, typename TAlloc, typename TSource> inline void replace(::std::vector<TChar, TAlloc> & target, typename Position< ::std::vector<TChar, TAlloc> >::Type pos_begin, typename Position< ::std::vector<TChar, TAlloc> >::Type pos_end, TSource const & source, Limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(590)
template <typename TChar, typename TAlloc, typename TSource> inline void replace(::std::vector<TChar, TAlloc> & target, typename Position< ::std::vector<TChar, TAlloc> >::Type pos_begin, typename Position< ::std::vector<TChar, TAlloc> >::Type pos_end, TSource const & source, typename Size< ::std::vector<TChar, TAlloc> >::Type limit, Limit);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(603)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSource, typename TExpand> inline void replace(::std::vector<TChar, TAlloc> & target, typename Iterator< ::std::vector<TChar, TAlloc>, Rooted>::Type pos_begin, typename Iterator< ::std::vector<TChar, TAlloc>, Rooted>::Type pos_end, TSource & source, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(623)

//____________________________________________________________________________
// reserve

template <typename TValue, typename TSpec, typename TSize_, typename TExpand> inline typename Size< String<TValue, Packed<TSpec> > >::Type reserve( String<TValue, Packed<TSpec> > & seq, TSize_ new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/string_packed.h"(795)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type reserve( ::std::basic_string<TChar, TCharTraits, TAlloc> & seq, TSize new_capacity, Tag<TExpand> const & tag);       	// "projects/library/seqan/sequence/adapt_std_string.h"(635)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type reserve( ::std::basic_string<TChar, TCharTraits, TAlloc> & seq, TSize new_capacity, Insist const &);       	// "projects/library/seqan/sequence/adapt_std_string.h"(647)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type reserve( ::std::basic_string<TChar, TCharTraits, TAlloc> & seq, TSize new_capacity, Limit const &);       	// "projects/library/seqan/sequence/adapt_std_string.h"(659)
template <typename T, typename TSize, typename TExpand> inline typename Size<T>::Type reserve( T & me, TSize new_capacity, Tag<TExpand> const tag);       	// "projects/library/seqan/sequence/sequence_interface.h"(1481)
template <typename T, typename TSize> inline typename Size<T>::Type reserve( T & me, TSize new_capacity);       	// "projects/library/seqan/sequence/sequence_interface.h"(1491)
template <typename TValue, unsigned int LENGTH, typename TExpand> inline size_t reserve( String<TValue, Array<LENGTH> > & me, size_t, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_array.h"(217)
template <typename TValue, unsigned int SPACE, typename TSize, typename TExpand> inline typename Size< String<TValue, Block<SPACE> > >::Type reserve(String<TValue, Block<SPACE> > & , TSize new_capacity, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_block.h"(393)
template <typename TChar, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::vector<TChar, TAlloc> >::Type reserve( ::std::vector<TChar, TAlloc> & seq, TSize new_capacity, Tag<TExpand> const & tag);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(650)
template <typename TChar, typename TAlloc, typename TSize> inline typename Size< ::std::vector<TChar, TAlloc> >::Type reserve( ::std::vector<TChar, TAlloc> & seq, TSize new_capacity, Insist const &);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(662)
template <typename TChar, typename TAlloc, typename TSize> inline typename Size< ::std::vector<TChar, TAlloc> >::Type reserve( ::std::vector<TChar, TAlloc> & seq, TSize new_capacity, Limit const &);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(674)

//____________________________________________________________________________
// resize

template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type resize( ::std::basic_string<TChar, TCharTraits, TAlloc> & me, TSize new_length, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/adapt_std_string.h"(672)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type resize( ::std::basic_string<TChar, TCharTraits, TAlloc> & me, TSize new_length, TChar const & val, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/adapt_std_string.h"(685)
template <typename TString, typename TSpec, typename TSize, typename TExpand > inline typename Size<StringSet<TString, TSpec > >::Type resize(StringSet<TString, TSpec > & me, TSize new_size, Tag<TExpand> const & tag);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(334)
template <typename TString, typename TSpec, typename TSize, typename TExpand > inline typename Size<StringSet<TString, Owner<ConcatDirect<TSpec> > > >::Type resize(StringSet<TString, Owner<ConcatDirect<TSpec> > > & me, TSize new_size, Tag<TExpand> const & tag);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(350)
template <typename T, typename TSize> inline typename Size<T>::Type resize( T & me, TSize new_length);       	// "projects/library/seqan/sequence/sequence_interface.h"(1525)
template <typename T, typename TSize, typename TValue> inline typename Size<T>::Type resize( T & me, TSize new_length, TValue const & val);       	// "projects/library/seqan/sequence/sequence_interface.h"(1536)
template <typename TValue, typename TSize, typename TExpand> inline size_t resize( TValue * me, TSize new_length, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(674)
template <typename TValue, typename TSize, typename TExpand> inline size_t resize( TValue * me, TSize new_length, TValue const & val, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(686)
template <typename TValue, unsigned int SPACE, typename TSize2, typename TExpand> inline typename Size< String<TValue, Block<SPACE> > >::Type resize(String<TValue, Block<SPACE> > & me, TSize2 new_length, Tag<TExpand> const);       	// "projects/library/seqan/sequence/string_block.h"(325)
template <typename TValue, unsigned int SPACE, typename TSize2> inline typename Size< String<TValue, Block<SPACE> > >::Type resize(String<TValue, Block<SPACE> > & me, TSize2 new_length, Limit);       	// "projects/library/seqan/sequence/string_block.h"(347)
template <typename TChar, typename TAlloc, typename TSize, typename TExpand> inline typename Size< ::std::vector<TChar, TAlloc> >::Type resize( ::std::vector<TChar, TAlloc> & me, TSize new_length, Tag<TExpand> const &);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(687)

//____________________________________________________________________________
// resizeSpace

template <typename T, typename TSize, typename TBeginPosition, typename TEndPosition> inline TSize resizeSpace(T & me, TSize size, TBeginPosition pos_begin, TEndPosition pos_end);       	// "projects/library/seqan/sequence/sequence_interface.h"(1572)
template <typename T, typename TSize, typename TBeginPosition, typename TEndPosition, typename TLimit> inline TSize resizeSpace(T & me, TSize size, TBeginPosition pos_begin, TEndPosition pos_end, TLimit limit);       	// "projects/library/seqan/sequence/sequence_interface.h"(1584)

//____________________________________________________________________________
// sequenceLength

template <typename TSeqNo, typename TText> inline typename Size< typename GetSequenceByNo<TText const>::Type>::Type sequenceLength(TSeqNo seqNo, TText const & text);       	// "projects/library/seqan/sequence/string_set_base.h"(927)

//____________________________________________________________________________
// setContainer

template <typename TContainer, typename THostspec, typename TContainer2> inline void setContainer(Iter<TContainer, Packed<THostspec> > & me, TContainer2 container_);       	// "projects/library/seqan/sequence/string_packed.h"(924)

//____________________________________________________________________________
// setPosition

template <typename TContainer, typename THostspec, typename TPosition> inline void setPosition(Iter<TContainer, Packed<THostspec> > & me, TPosition pos_);       	// "projects/library/seqan/sequence/string_packed.h"(988)

//____________________________________________________________________________
// shareResources

template <typename T1, typename T2> inline bool shareResources(T1 const & obj1, T2 const & obj2);       	// "projects/library/seqan/sequence/sequence_interface.h"(277)

//____________________________________________________________________________
// shrinkToFit

template <typename T, typename TSize, typename TValue> inline void shrinkToFit(T & me);       	// "projects/library/seqan/sequence/sequence_interface.h"(1693)

//____________________________________________________________________________
// stringSetLimits

template <typename TStringSet> inline typename StringSetLimits<TStringSet>::Type stringSetLimits(TStringSet &);       	// "projects/library/seqan/sequence/string_set_base.h"(301)
template <typename TString, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSpec> >::Type & stringSetLimits(StringSet<TString, TSpec> & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(308)
template <typename TString, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSpec> const>::Type & stringSetLimits(StringSet<TString, TSpec> const & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(317)

//____________________________________________________________________________
// suffix

template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString>::Type suffix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > & me, TPosition pos);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(384)
template <typename TString, typename TDelimiter, typename TPosition > inline typename Infix<TString const>::Type suffix(StringSet< TString, Owner<ConcatDirect<TDelimiter> > > const & me, TPosition pos);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(391)
template <typename TString, typename TSpec, typename TPosition > inline typename Suffix<TString>::Type suffix(StringSet< TString, TSpec > & me, TPosition pos);       	// "projects/library/seqan/sequence/string_set_base.h"(608)
template <typename TString, typename TSpec, typename TPosition > inline typename Suffix<TString const>::Type suffix(StringSet< TString, TSpec > const & me, TPosition pos);       	// "projects/library/seqan/sequence/string_set_base.h"(622)

//____________________________________________________________________________
// suffixLength

template <typename TPos, typename TString> inline typename Size<TString>::Type suffixLength(TPos pos, TString const & string);       	// "projects/library/seqan/sequence/string_set_base.h"(869)
template <typename TPos, typename TString, typename TSpec> inline typename Size<TString>::Type suffixLength(TPos pos, StringSet<TString, TSpec> const & stringSet);       	// "projects/library/seqan/sequence/string_set_base.h"(875)

//____________________________________________________________________________
// toCString

template <typename TValue> inline TValue * toCString(TValue * me);       	// "projects/library/seqan/sequence/string_cstyle.h"(876)
template <typename TValue> inline TValue const * toCString(TValue const * me);       	// "projects/library/seqan/sequence/string_cstyle.h"(884)
template <typename TValue> inline TValue * toCString(String<TValue, CStyle> & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(892)
template <typename TValue> inline TValue const * toCString(String<TValue, CStyle> const & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(900)
template <typename TValue, typename TSpec> inline TValue * toCString(String<TValue, TSpec> & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(928)
template <typename TValue, typename TSpec> inline TValue * toCString(String<TValue, TSpec> const & me);       	// "projects/library/seqan/sequence/string_cstyle.h"(936)

//____________________________________________________________________________
// top

template <typename TValue, unsigned int SPACE> inline TValue & top(String<TValue, Block<SPACE> > & me);       	// "projects/library/seqan/sequence/string_block.h"(492)
template <typename TValue, unsigned int SPACE> inline TValue const & top(String<TValue, Block<SPACE> > const& me);       	// "projects/library/seqan/sequence/string_block.h"(500)

//____________________________________________________________________________
// topPrev

template <typename TValue, unsigned int SPACE> inline TValue & topPrev(String<TValue, Block<SPACE> > & me);       	// "projects/library/seqan/sequence/string_block.h"(512)
template <typename TValue, unsigned int SPACE> inline TValue const & topPrev(String<TValue, Block<SPACE> > const& me);       	// "projects/library/seqan/sequence/string_block.h"(523)

//____________________________________________________________________________
// value

template <typename TString, typename TPos > inline typename Reference<StringSet<TString, Dependent<Tight> > >::Type value(StringSet<TString, Dependent<Tight> >& me, TPos pos);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(182)
template <typename TString, typename TPos > inline typename Reference<StringSet<TString, Dependent<Tight> > const >::Type value(StringSet<TString, Dependent<Tight> >const & me, TPos pos);       	// "projects/library/seqan/sequence/string_set_dependent_tight.h"(190)
template <typename TStringSet, typename TPos > inline typename Reference<ConcatenatorManyToOne<TStringSet> >::Type value(ConcatenatorManyToOne<TStringSet> & me, TPos globalPos);       	// "projects/library/seqan/sequence/sequence_concatenator.h"(186)
template <typename TStringSet, typename TPos > inline typename Reference<ConcatenatorManyToOne<TStringSet> const >::Type value(ConcatenatorManyToOne<TStringSet> const & me, TPos globalPos);       	// "projects/library/seqan/sequence/sequence_concatenator.h"(195)
template <typename TValue, typename THostspec, typename TPos> inline typename Reference<String<TValue, Packed<THostspec> > >::Type value(String<TValue, Packed<THostspec> > & me, TPos pos);       	// "projects/library/seqan/sequence/string_packed.h"(543)
template <typename TValue, typename THostspec, typename TPos> inline typename Reference<String<TValue, Packed<THostspec> > const>::Type value(String<TValue, Packed<THostspec> > const & me, TPos pos);       	// "projects/library/seqan/sequence/string_packed.h"(553)
template <typename TContainer, typename THostspec> inline typename Reference<Iter<TContainer, Packed<THostspec> > >::Type value(Iter<TContainer, Packed<THostspec> > & me);       	// "projects/library/seqan/sequence/string_packed.h"(1001)
template <typename TContainer, typename THostspec> inline typename Reference<Iter<TContainer, Packed<THostspec> > const>::Type value(Iter<TContainer, Packed<THostspec> > const & me);       	// "projects/library/seqan/sequence/string_packed.h"(1008)
template <typename TString, typename TPos > inline typename Reference<StringSet<TString, Owner<Default> > >::Type value(StringSet<TString, Owner<Default> > & me, TPos pos);       	// "projects/library/seqan/sequence/string_set_owner.h"(181)
template <typename TString, typename TPos > inline typename Reference<StringSet<TString, Owner<Default> > const >::Type value(StringSet<TString, Owner<Default> > const & me, TPos pos);       	// "projects/library/seqan/sequence/string_set_owner.h"(188)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TPos> inline typename GetValue< ::std::basic_string<TChar, TCharTraits, TAlloc> >::Type value(::std::basic_string<TChar, TCharTraits, TAlloc> & me, TPos pos);       	// "projects/library/seqan/sequence/adapt_std_string.h"(222)
template <typename TChar, typename TCharTraits, typename TAlloc, typename TPos> inline typename GetValue< ::std::basic_string<TChar, TCharTraits, TAlloc> const>::Type value(::std::basic_string<TChar, TCharTraits, TAlloc> const & me, TPos pos);       	// "projects/library/seqan/sequence/adapt_std_string.h"(230)
template <typename TString, typename TSpec, typename TPos > inline typename Infix<TString>::Type value(StringSet<TString, Owner<ConcatDirect<TSpec> > > & me, TPos pos);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(438)
template <typename TString, typename TSpec, typename TPos > inline typename Infix<TString const>::Type value(StringSet<TString, Owner<ConcatDirect<TSpec> > > const & me, TPos pos);       	// "projects/library/seqan/sequence/string_set_concat_direct.h"(445)
template <typename T, typename TPos> inline typename Reference<T>::Type value(T & me, TPos );       	// "projects/library/seqan/sequence/sequence_interface.h"(618)
template <typename T, typename TPos> inline typename Reference<T const>::Type value(T const & me, TPos );       	// "projects/library/seqan/sequence/sequence_interface.h"(627)
template <typename TValue, typename TPos> inline TValue & value(TValue * me, TPos pos);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(264)
template <typename TValue, typename TPos> inline TValue const & value(TValue const * me, TPos pos);       	// "projects/library/seqan/sequence/adapt_array_pointer.h"(273)
template <typename TStringSet, typename TSpec> inline typename Reference<Iter<TStringSet, ConcatVirtual<TSpec> > const>::Type value(Iter<TStringSet, ConcatVirtual<TSpec> > const & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(225)
template <typename TStringSet, typename TSpec> inline typename Reference<Iter<TStringSet, ConcatVirtual<TSpec> > >::Type value(Iter<TStringSet, ConcatVirtual<TSpec> > & me);       	// "projects/library/seqan/sequence/iter_concat_virtual.h"(232)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( String<TValue, Block<SPACE> >& stack, TPos const pos);       	// "projects/library/seqan/sequence/string_block.h"(262)
template <typename TValue, unsigned int SPACE, typename TPos> inline typename Reference<String<TValue, Block<SPACE> > >::Type value( String<TValue, Block<SPACE> > const& stack, TPos const pos);       	// "projects/library/seqan/sequence/string_block.h"(272)
template <typename TChar, typename TAlloc, typename TPos> inline typename GetValue< ::std::vector<TChar, TAlloc> >::Type value(::std::vector<TChar, TAlloc> & me, TPos pos);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(220)
template <typename TChar, typename TAlloc, typename TPos> inline typename GetValue< ::std::vector<TChar, TAlloc> const>::Type value(::std::vector<TChar, TAlloc> const & me, TPos pos);       	// "projects/library/seqan/sequence/adapt_std_vector.h"(228)
template <typename TString, typename TPos > inline typename Reference<StringSet<TString, Dependent<Generous> > >::Type value(StringSet<TString, Dependent<Generous> >& me, TPos pos);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(148)
template <typename TString, typename TPos > inline typename Reference<StringSet<TString, Dependent<Generous> > const >::Type value(StringSet<TString, Dependent<Generous> > const & me, TPos pos);       	// "projects/library/seqan/sequence/string_set_dependent_generous.h"(160)

//____________________________________________________________________________
// valueById

template <typename TString, typename TSpec, typename TId> inline typename Reference<StringSet<TString, TSpec> >::Type valueById(StringSet<TString, TSpec> & me, TId const id);       	// "projects/library/seqan/sequence/string_set_base.h"(1167)

//____________________________________________________________________________
// valueConstruct

template <typename TContainer, typename THostspec> inline void valueConstruct(Iter<TContainer, Packed<THostspec> > const & );       	// "projects/library/seqan/sequence/string_packed.h"(1103)
template <typename TContainer, typename THostspec, typename TParam> inline void valueConstruct(Iter<TContainer, Packed<THostspec> > const & it, TParam const & param_);       	// "projects/library/seqan/sequence/string_packed.h"(1109)
template <typename TContainer, typename THostspec, typename TParam> inline void valueConstruct(Iter<TContainer, Packed<THostspec> > const & it, TParam const & param_, Move );       	// "projects/library/seqan/sequence/string_packed.h"(1117)

//____________________________________________________________________________
// valueDestruct

template <typename TContainer, typename THostspec> inline void valueDestruct(Iter<TContainer, Packed<THostspec> > const & );       	// "projects/library/seqan/sequence/string_packed.h"(1128)

} //namespace seqan

#endif

