 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_SCORE_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_SCORE_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Pam

template <typename TSequenceValue , typename TSource > struct Pam;       	// "projects/library/seqan/score/score_pam_matrix.h"(74)

//____________________________________________________________________________
// Pam_Data_Dayhoff_MDM78

struct Pam_Data_Dayhoff_MDM78;       	// "projects/library/seqan/score/score_pam_matrix.h"(29)

//____________________________________________________________________________
// Pam_Data_Jones_All_Membrane

struct Pam_Data_Jones_All_Membrane;       	// "projects/library/seqan/score/score_pam_matrix.h"(33)

//____________________________________________________________________________
// Pam_Data_Jones_Multi_Membrane

struct Pam_Data_Jones_Multi_Membrane;       	// "projects/library/seqan/score/score_pam_matrix.h"(35)

//____________________________________________________________________________
// Pam_Data_Jones_PET91_SWISS15

struct Pam_Data_Jones_PET91_SWISS15;       	// "projects/library/seqan/score/score_pam_matrix.h"(31)

//____________________________________________________________________________
// Pam_Data_Jones_PET91_SWISS22

struct Pam_Data_Jones_PET91_SWISS22;       	// "projects/library/seqan/score/score_pam_matrix.h"(32)

//____________________________________________________________________________
// Pam_Data_Jones_PRI29

struct Pam_Data_Jones_PRI29;       	// "projects/library/seqan/score/score_pam_matrix.h"(30)

//____________________________________________________________________________
// Pam_Data_Jones_Single_Membrane

struct Pam_Data_Jones_Single_Membrane;       	// "projects/library/seqan/score/score_pam_matrix.h"(34)

//____________________________________________________________________________
// Score

template <typename TValue , typename TSpec > class Score;       	// "projects/library/seqan/score/score_base.h"(45)

//____________________________________________________________________________
// ScoreMatrix

template <typename TSequenceValue , typename TSpec > struct ScoreMatrix;       	// "projects/library/seqan/score/score_matrix.h"(35)

//____________________________________________________________________________
// Simple

struct Simple;       	// "projects/library/seqan/score/score_base.h"(29)

//____________________________________________________________________________
// TagScoreMatrixFile_

struct TagScoreMatrixFile_;       	// "projects/library/seqan/score/score_matrix.h"(42)

//____________________________________________________________________________
// _Blosum30

struct _Blosum30;       	// "projects/library/seqan/score/score_matrix_data.h"(94)

//____________________________________________________________________________
// _Blosum62

struct _Blosum62;       	// "projects/library/seqan/score/score_matrix_data.h"(38)

//____________________________________________________________________________
// _Blosum80

struct _Blosum80;       	// "projects/library/seqan/score/score_matrix_data.h"(154)

//____________________________________________________________________________
// _ScoringMatrixData

template <typename TValue, typename TSequenceValue, typename TSpec> struct _ScoringMatrixData;       	// "projects/library/seqan/score/score_matrix.h"(30)

//____________________________________________________________________________
// _TempMembersPam

template <typename TValue, typename TSequenceValue> struct _TempMembersPam;       	// "projects/library/seqan/score/score_pam_matrix.h"(45)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Blosum30

typedef Score<int, ScoreMatrix<AminoAcid, _Blosum30> > Blosum30;       	// "projects/library/seqan/score/score_matrix_data.h"(95)

//____________________________________________________________________________
// Blosum62

typedef Score<int, ScoreMatrix<AminoAcid, _Blosum62> > Blosum62;       	// "projects/library/seqan/score/score_matrix_data.h"(39)

//____________________________________________________________________________
// Blosum80

typedef Score<int, ScoreMatrix<AminoAcid, _Blosum80> > Blosum80;       	// "projects/library/seqan/score/score_matrix_data.h"(155)

//____________________________________________________________________________
// EditDistanceScore

typedef Score<int, EditDistance> EditDistanceScore;       	// "projects/library/seqan/score/score_edit.h"(77)

//____________________________________________________________________________
// PamDayhoff

typedef Score <int, Pam<AminoAcid, Pam_Data_Dayhoff_MDM78> > PamDayhoff;       	// "projects/library/seqan/score/score_pam.h"(399)

//____________________________________________________________________________
// PamJones

typedef Score <int, Pam<AminoAcid, Pam_Data_Jones_PRI29> > PamJones;       	// "projects/library/seqan/score/score_pam.h"(400)

//____________________________________________________________________________
// PamJonesSWISS15

typedef Score <int, Pam<AminoAcid, Pam_Data_Jones_PET91_SWISS15> > PamJonesSWISS15;       	// "projects/library/seqan/score/score_pam.h"(401)

//____________________________________________________________________________
// PamJonesSWISS22

typedef Score <int, Pam<AminoAcid, Pam_Data_Jones_PET91_SWISS22> > PamJonesSWISS22;       	// "projects/library/seqan/score/score_pam.h"(402)

//____________________________________________________________________________
// PamMembrane

typedef Score <int, Pam<AminoAcid, Pam_Data_Jones_All_Membrane> > PamMembrane;       	// "projects/library/seqan/score/score_pam.h"(403)

//____________________________________________________________________________
// PamMultiMembrane

typedef Score <int, Pam<AminoAcid, Pam_Data_Jones_Multi_Membrane> > PamMultiMembrane;       	// "projects/library/seqan/score/score_pam.h"(405)

//____________________________________________________________________________
// PamSingleMembrane

typedef Score <int, Pam<AminoAcid, Pam_Data_Jones_Single_Membrane> > PamSingleMembrane;       	// "projects/library/seqan/score/score_pam.h"(404)

//____________________________________________________________________________
// ScoreMatrixFile

typedef Tag<TagScoreMatrixFile_> const ScoreMatrixFile;       	// "projects/library/seqan/score/score_matrix.h"(43)

//____________________________________________________________________________
// SimpleScore

typedef Score<int, Simple> SimpleScore;       	// "projects/library/seqan/score/score_simple.h"(125)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _computeEntropyPam

template <typename TValue, typename TSequenceValue, typename TSource> void _computeEntropyPam(Score<TValue, Pam<TSequenceValue, TSource> > & _score , _TempMembersPam<TValue, TSequenceValue> & _member );       	// "projects/library/seqan/score/score_pam.h"(772)
template <typename TValue, typename TSource> void _computeEntropyPam(Score<TValue, Pam<AminoAcid, TSource> > & _score , _TempMembersPam<TValue, AminoAcid> & _member );       	// "projects/library/seqan/score/score_pam.h"(793)

//____________________________________________________________________________
// _computeLogOddsPam

template <typename TValue, typename TSequenceValue> void _computeLogOddsPam(_TempMembersPam<TValue, TSequenceValue> & _member);       	// "projects/library/seqan/score/score_pam.h"(579)

//____________________________________________________________________________
// _computePamScale

template <typename TValue, typename TSequenceValue, typename TSource> void _computePamScale(Score<TValue, Pam<TSequenceValue, TSource> > & _score);       	// "projects/library/seqan/score/score_pam.h"(828)

//____________________________________________________________________________
// _extendAlphabetPam

template <typename TValue, typename TSource> void _extendAlphabetPam(Score<TValue, Pam<AminoAcid, TSource> > &, _TempMembersPam<TValue,AminoAcid> & _member);       	// "projects/library/seqan/score/score_pam.h"(531)
template <typename TValue, typename TSequenceValue, typename TSource> void _extendAlphabetPam(Score<TValue, Pam<TSequenceValue, TSource> > & _score, _TempMembersPam<TValue, TSequenceValue> & _member);       	// "projects/library/seqan/score/score_pam.h"(562)

//____________________________________________________________________________
// _extrapolatePam

template <typename TValue, typename TSource, typename TSequenceValue> void _extrapolatePam (_TempMembersPam<TValue, TSequenceValue> & _member, Score<TValue, Pam<TSequenceValue, TSource> > _score);       	// "projects/library/seqan/score/score_pam.h"(446)

//____________________________________________________________________________
// _finishPam

template <typename TValue, typename TSequenceValue, typename TSource> void _finishPam(Score<TValue, Pam<TSequenceValue, TSource> > & _score, _TempMembersPam<TValue, TSequenceValue> & _member);       	// "projects/library/seqan/score/score_pam.h"(606)
template <typename TValue, typename TSource> void _finishPam(Score<TValue, Pam<AminoAcid, TSource> > & _score, _TempMembersPam<TValue, AminoAcid> & _member);       	// "projects/library/seqan/score/score_pam.h"(680)

//____________________________________________________________________________
// _getDataPam

template <typename TValue, typename TSequenceValue, typename TSource> inline TValue * _getDataPam(Score<TValue, Pam<TSequenceValue, TSource> > & _score);       	// "projects/library/seqan/score/score_pam.h"(230)
template <typename TValue, typename TSequenceValue, typename TSource> inline const TValue * _getDataPam(const Score<TValue, Pam<TSequenceValue, TSource> > & _score);       	// "projects/library/seqan/score/score_pam.h"(237)

//____________________________________________________________________________
// _setDist

template <typename TValue, typename TSequenceValue, typename TSource> inline void _setDist(Score<TValue, Pam<TSequenceValue, TSource> > & _score, int _givenDist);       	// "projects/library/seqan/score/score_pam.h"(343)

//____________________________________________________________________________
// _setEntropy

template <typename TValue, typename TSequenceValue, typename TSource> inline void _setEntropy(Score<TValue, Pam<TSequenceValue, TSource> > & _score, double H);       	// "projects/library/seqan/score/score_pam.h"(381)

//____________________________________________________________________________
// _setScale

template <typename TValue, typename TSequenceValue, typename TSource> inline void _setScale(Score<TValue, Pam<TSequenceValue, TSource> > & _score, double _scale);       	// "projects/library/seqan/score/score_pam.h"(302)

//____________________________________________________________________________
// _sprintfValue

inline void _sprintfValue(char * buf, unsigned int val);       	// "projects/library/seqan/score/score_matrix.h"(334)
inline void _sprintfValue(char * buf, int val);       	// "projects/library/seqan/score/score_matrix.h"(339)
inline void _sprintfValue(char * buf, float val);       	// "projects/library/seqan/score/score_matrix.h"(344)
inline void _sprintfValue(char * buf, double val);       	// "projects/library/seqan/score/score_matrix.h"(350)

//____________________________________________________________________________
// _sscanfValue

inline void _sscanfValue(char * buf, unsigned int & val);       	// "projects/library/seqan/score/score_matrix.h"(157)
inline void _sscanfValue(char * buf, int & val);       	// "projects/library/seqan/score/score_matrix.h"(162)
inline void _sscanfValue(char * buf, float & val);       	// "projects/library/seqan/score/score_matrix.h"(167)
inline void _sscanfValue(char * buf, double & val);       	// "projects/library/seqan/score/score_matrix.h"(172)

//____________________________________________________________________________
// _starting_data_pam

template <typename TValue, typename TSequenceValue, typename TSource> void _starting_data_pam(_TempMembersPam<TValue, TSequenceValue> & _member, Score <TValue, Pam<TSequenceValue, TSource> > & _score);       	// "projects/library/seqan/score/score_pam_matrix.h"(80)
template <typename TValue> void _starting_data_pam(_TempMembersPam<TValue, AminoAcid> & _member, Score <TValue, Pam<AminoAcid, Pam_Data_Dayhoff_MDM78> > &);       	// "projects/library/seqan/score/score_pam_matrix.h"(84)
template <typename TValue> void _starting_data_pam(_TempMembersPam<TValue, AminoAcid> & _member, Score <TValue, Pam<AminoAcid, Pam_Data_Jones_PRI29> > & _score);       	// "projects/library/seqan/score/score_pam_matrix.h"(132)
template <typename TValue> void _starting_data_pam(_TempMembersPam<TValue, AminoAcid> & _member, Score <TValue, Pam<AminoAcid, Pam_Data_Jones_PET91_SWISS15> > & _score);       	// "projects/library/seqan/score/score_pam_matrix.h"(177)
template <typename TValue> void _starting_data_pam(_TempMembersPam<TValue, AminoAcid> & _member, Score <TValue, Pam<AminoAcid, Pam_Data_Jones_PET91_SWISS22> > & _score);       	// "projects/library/seqan/score/score_pam_matrix.h"(218)
template <typename TValue> void _starting_data_pam(_TempMembersPam<TValue, AminoAcid> & _member, Score <TValue, Pam<AminoAcid, Pam_Data_Jones_All_Membrane> > & _score);       	// "projects/library/seqan/score/score_pam_matrix.h"(259)
template <typename TValue> void _starting_data_pam(_TempMembersPam<TValue, AminoAcid> & _member, Score <TValue, Pam<AminoAcid, Pam_Data_Jones_Single_Membrane> > & _score);       	// "projects/library/seqan/score/score_pam_matrix.h"(306)
template <typename TValue> void _starting_data_pam(_TempMembersPam<TValue, AminoAcid> & _member, Score <TValue, Pam<AminoAcid, Pam_Data_Jones_Multi_Membrane> > & _score);       	// "projects/library/seqan/score/score_pam_matrix.h"(351)

//____________________________________________________________________________
// _writeScoringMatrix

template <typename TSequenceValue, typename TFile, typename TValue, typename TMeta> void _writeScoringMatrix(TFile & fl, TValue * tab, TMeta & meta);       	// "projects/library/seqan/score/score_matrix.h"(361)

//____________________________________________________________________________
// buildPam

template <typename TValue, typename TSequenceValue, typename TSource> void buildPam(Score<TValue, Pam<TSequenceValue, TSource> > & _score, int _givenDist);       	// "projects/library/seqan/score/score_pam.h"(416)

//____________________________________________________________________________
// getDist

template <typename TValue, typename TSequenceValue, typename TSource> inline int getDist(Score<TValue, Pam<TSequenceValue, TSource> > & _score);       	// "projects/library/seqan/score/score_pam.h"(319)
template <typename TValue, typename TSequenceValue, typename TSource> inline int getDist(Score<TValue, Pam<TSequenceValue, TSource> > const & _score);       	// "projects/library/seqan/score/score_pam.h"(325)

//____________________________________________________________________________
// getEntropy

template <typename TValue, typename TSequenceValue, typename TSource> inline double getEntropy(Score<TValue, Pam<TSequenceValue, TSource> > & _score);       	// "projects/library/seqan/score/score_pam.h"(358)
template <typename TValue, typename TSequenceValue, typename TSource> inline double getEntropy(Score<TValue, Pam<TSequenceValue, TSource> > const & _score);       	// "projects/library/seqan/score/score_pam.h"(365)

//____________________________________________________________________________
// getScale

template <typename TValue, typename TSequenceValue, typename TSource> inline double getScale(Score<TValue, Pam<TSequenceValue, TSource> > & _score);       	// "projects/library/seqan/score/score_pam.h"(280)
template <typename TValue, typename TSequenceValue, typename TSource> inline double getScale(Score<TValue, Pam<TSequenceValue, TSource> > const & _score);       	// "projects/library/seqan/score/score_pam.h"(286)

//____________________________________________________________________________
// loadScoreMatrix

template <typename TValue, typename TSequenceValue, typename TSpec, typename TString> inline void loadScoreMatrix(Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > & sc, TString & filename);       	// "projects/library/seqan/score/score_matrix.h"(310)
template <typename TValue, typename TSequenceValue, typename TSpec, typename TString, typename TMeta> inline void loadScoreMatrix(Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > & sc, TString & filename, TMeta & meta);       	// "projects/library/seqan/score/score_matrix.h"(321)

//____________________________________________________________________________
// read

template <typename TFile, typename TValue, typename TSequenceValue, typename TSpec> void read(TFile & fl, Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > & sc, ScoreMatrixFile);       	// "projects/library/seqan/score/score_matrix.h"(208)
template <typename TFile, typename TValue, typename TSequenceValue, typename TSpec> inline void read(TFile & fl, Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > & sc);       	// "projects/library/seqan/score/score_matrix.h"(300)

//____________________________________________________________________________
// readMeta

template <typename TFile, typename TMeta> void readMeta(TFile & fl, TMeta & meta, ScoreMatrixFile);       	// "projects/library/seqan/score/score_matrix.h"(185)

//____________________________________________________________________________
// roundConvert

template <typename TSource, typename TValue, typename TSequenceValue > TValue roundConvert(TSource to_round, Score<TValue, TSequenceValue> _roundType);       	// "projects/library/seqan/score/score_pam.h"(859)
template <typename TSource, typename TSequenceValue> int roundConvert(TSource to_round, Score<int, TSequenceValue>);       	// "projects/library/seqan/score/score_pam.h"(865)

//____________________________________________________________________________
// score

template <typename TValue, typename TSequenceValue, typename TSpec, typename TVal1, typename TVal2> inline TValue score(Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > const & sc, TVal1 val1, TVal2 val2);       	// "projects/library/seqan/score/score_matrix.h"(110)
template <typename TValue, typename TSpec, typename TVal1, typename TVal2> inline TValue score(Score<TValue, TSpec> const & me, TVal1 left, TVal2 right);       	// "projects/library/seqan/score/score_simple.h"(274)
template <typename TValue, typename TSpec, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue score(Score<TValue, TSpec> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "projects/library/seqan/score/score_base.h"(166)
template <typename TValue, typename TSequenceValue, typename TSource, typename TVal1, typename TVal2> inline TValue & score(Score<TValue, Pam<TSequenceValue, TSource> > & _score, TVal1 as_1, TVal2 as_2);       	// "projects/library/seqan/score/score_pam.h"(904)
template <typename TValue, typename TSequenceValue, typename TSource, typename TVal1, typename TVal2> inline TValue const & score(Score<TValue, Pam<TSequenceValue, TSource> > const & _score, TVal1 as_1, TVal2 as_2);       	// "projects/library/seqan/score/score_pam.h"(915)

//____________________________________________________________________________
// scoreGap

template <typename TValue, typename TSpec> inline TValue & scoreGap(Score<TValue, TSpec> & me);       	// "projects/library/seqan/score/score_simple.h"(245)
template <typename TValue, typename TSpec> inline TValue const & scoreGap(Score<TValue, TSpec> const & me);       	// "projects/library/seqan/score/score_simple.h"(251)

//____________________________________________________________________________
// scoreGapExtend

template <typename TValue, typename TSpec> inline TValue & scoreGapExtend(Score<TValue, TSpec> & me);       	// "projects/library/seqan/score/score_simple.h"(194)
template <typename TValue, typename TSpec> inline TValue const & scoreGapExtend(Score<TValue, TSpec> const & me);       	// "projects/library/seqan/score/score_simple.h"(200)
template <typename TValue> inline TValue scoreGapExtend(Score<TValue, EditDistance> &);       	// "projects/library/seqan/score/score_edit.h"(112)
template <typename TValue> inline TValue scoreGapExtend(Score<TValue, EditDistance> const &);       	// "projects/library/seqan/score/score_edit.h"(119)

//____________________________________________________________________________
// scoreGapExtendHorizontal

template <typename TValue, typename TSpec, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendHorizontal( Score<TValue, TSpec> const & me, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/score/score_base.h"(116)

//____________________________________________________________________________
// scoreGapExtendVertical

template <typename TValue, typename TSpec, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendVertical( Score<TValue, TSpec> const & me, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/score/score_base.h"(128)

//____________________________________________________________________________
// scoreGapHorizontal

template <typename TValue, typename TSpec, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapHorizontal( Score<TValue, TSpec> const & me, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/score/score_base.h"(140)

//____________________________________________________________________________
// scoreGapOpen

template <typename TValue, typename TSpec> inline TValue & scoreGapOpen(Score<TValue, TSpec> & me);       	// "projects/library/seqan/score/score_simple.h"(218)
template <typename TValue, typename TSpec> inline TValue const & scoreGapOpen(Score<TValue, TSpec> const & me);       	// "projects/library/seqan/score/score_simple.h"(224)
template <typename TValue> inline TValue scoreGapOpen(Score<TValue, EditDistance> &);       	// "projects/library/seqan/score/score_edit.h"(126)
template <typename TValue> inline TValue scoreGapOpen(Score<TValue, EditDistance> const &);       	// "projects/library/seqan/score/score_edit.h"(133)

//____________________________________________________________________________
// scoreGapOpenHorizontal

template <typename TValue, typename TSpec, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenHorizontal( Score<TValue, TSpec> const & me, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/score/score_base.h"(92)

//____________________________________________________________________________
// scoreGapOpenVertical

template <typename TValue, typename TSpec, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenVertical( Score<TValue, TSpec> const & me, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "projects/library/seqan/score/score_base.h"(104)

//____________________________________________________________________________
// scoreGapVertical

template <typename TValue, typename TSpec, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapVertical( Score<TValue, TSpec> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "projects/library/seqan/score/score_base.h"(152)

//____________________________________________________________________________
// scoreMatch

template <typename TValue, typename TSpec> inline TValue & scoreMatch(Score<TValue, TSpec> & me);       	// "projects/library/seqan/score/score_simple.h"(144)
template <typename TValue, typename TSpec> inline TValue const & scoreMatch(Score<TValue, TSpec> const & me);       	// "projects/library/seqan/score/score_simple.h"(150)
template <typename TValue> inline TValue scoreMatch(Score<TValue, EditDistance> &);       	// "projects/library/seqan/score/score_edit.h"(84)
template <typename TValue> inline TValue scoreMatch(Score<TValue, EditDistance> const &);       	// "projects/library/seqan/score/score_edit.h"(91)

//____________________________________________________________________________
// scoreMismatch

template <typename TValue, typename TSpec> inline TValue & scoreMismatch(Score<TValue, TSpec> & me);       	// "projects/library/seqan/score/score_simple.h"(169)
template <typename TValue, typename TSpec> inline TValue const & scoreMismatch(Score<TValue, TSpec> const & me);       	// "projects/library/seqan/score/score_simple.h"(175)
template <typename TValue> inline TValue scoreMismatch(Score<TValue, EditDistance> &);       	// "projects/library/seqan/score/score_edit.h"(98)
template <typename TValue> inline TValue scoreMismatch(Score<TValue, EditDistance> const &);       	// "projects/library/seqan/score/score_edit.h"(105)

//____________________________________________________________________________
// setDefaultScoreMatrix

template <typename TValue, typename TSequenceValue, typename TSpec, typename TTag> inline void setDefaultScoreMatrix(Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > & sc, TTag);       	// "projects/library/seqan/score/score_matrix.h"(138)
template <typename TValue, typename TSequenceValue, typename TSpec> inline void setDefaultScoreMatrix(Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > & sc, Default);       	// "projects/library/seqan/score/score_matrix.h"(147)

//____________________________________________________________________________
// setScore

template <typename TValue, typename TSequenceValue, typename TSpec, typename TVal1, typename TVal2, typename T> inline void setScore(Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > & sc, TVal1 val1, TVal2 val2, T score);       	// "projects/library/seqan/score/score_matrix.h"(125)

//____________________________________________________________________________
// write

template <typename TFile, typename TValue, typename TSequenceValue, typename TSpec, typename TMeta> inline void write(TFile & fl, Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > const & sc, TMeta & meta);       	// "projects/library/seqan/score/score_matrix.h"(445)
template <typename TFile, typename TValue, typename TSequenceValue, typename TSpec> inline void write(TFile & fl, Score<TValue, ScoreMatrix<TSequenceValue, TSpec> > const & sc);       	// "projects/library/seqan/score/score_matrix.h"(453)
template <typename TFile, typename TValue, typename TSequenceValue, typename TSpec, typename TMeta> void write(TFile & fl, Score<TValue, Pam<TSequenceValue, TSpec> > & sc, TMeta & meta);       	// "projects/library/seqan/score/score_pam.h"(882)
template <typename TFile, typename TValue, typename TSequenceValue, typename TSpec> void write(TFile & fl, Score<TValue, Pam<TSequenceValue, TSpec> > & sc);       	// "projects/library/seqan/score/score_pam.h"(890)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

