 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_BLAST_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_BLAST_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BasicInfo

struct BasicInfo;       	// "projects/library/seqan/blast/blast_base.h"(35)

//____________________________________________________________________________
// BlastHit

template <typename TBlastHsp, typename TStoreSpec> class BlastHit;       	// "projects/library/seqan/blast/blast_hit.h"(28)

//____________________________________________________________________________
// BlastHsp

template <typename TBlastSpec , typename TInfoSpec > class BlastHsp;       	// "projects/library/seqan/blast/blast_hsp.h"(34)

//____________________________________________________________________________
// BlastReport

template <typename TBlastHsp , typename TStoreSpec > class BlastReport;       	// "projects/library/seqan/blast/blast_report.h"(31)

//____________________________________________________________________________
// FullInfo

struct FullInfo;       	// "projects/library/seqan/blast/blast_base.h"(32)

//____________________________________________________________________________
// Hit

template <typename T> struct Hit;       	// "projects/library/seqan/blast/blast_base.h"(94)

//____________________________________________________________________________
// HitIterator

struct HitIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(39)

//____________________________________________________________________________
// Hsp

template <typename T> struct Hsp;       	// "projects/library/seqan/blast/blast_base.h"(106)

//____________________________________________________________________________
// HspIterator

struct HspIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(42)

//____________________________________________________________________________
// NucleotideBlast

template <typename TSpec > class NucleotideBlast;       	// "projects/library/seqan/blast/blast_base.h"(157)

//____________________________________________________________________________
// ProteinBlast

template <typename TSpec > class ProteinBlast;       	// "projects/library/seqan/blast/blast_base.h"(164)

//____________________________________________________________________________
// SimpleBlastIterator

template <typename TSpec> struct SimpleBlastIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(35)

//____________________________________________________________________________
// StoreReport

template <typename TInfoSpec > struct StoreReport;       	// "projects/library/seqan/blast/blast_base.h"(59)

//____________________________________________________________________________
// StreamBlastIterator

template <typename TSpec> struct StreamBlastIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(50)

//____________________________________________________________________________
// StreamReport

template <typename TFile > struct StreamReport;       	// "projects/library/seqan/blast/blast_base.h"(76)

//____________________________________________________________________________
// TagBlastN_

struct TagBlastN_;       	// "projects/library/seqan/blast/blast_base.h"(149)

//____________________________________________________________________________
// TagBlastP_

struct TagBlastP_;       	// "projects/library/seqan/blast/blast_base.h"(151)

//____________________________________________________________________________
// TagBlastX_

struct TagBlastX_;       	// "projects/library/seqan/blast/blast_base.h"(152)

//____________________________________________________________________________
// TagBlast_

struct TagBlast_;       	// "projects/library/seqan/blast/blast_base.h"(112)

//____________________________________________________________________________
// TagKnownSource_

struct TagKnownSource_;       	// "projects/library/seqan/blast/blast_hsp.h"(844)

//____________________________________________________________________________
// TagMegaBlast_

struct TagMegaBlast_;       	// "projects/library/seqan/blast/blast_base.h"(150)

//____________________________________________________________________________
// TagRunBlastN_

struct TagRunBlastN_;       	// "projects/library/seqan/blast/blast_run.h"(35)

//____________________________________________________________________________
// TagRunBlastP_

struct TagRunBlastP_;       	// "projects/library/seqan/blast/blast_run.h"(46)

//____________________________________________________________________________
// TagRunBlastX_

struct TagRunBlastX_;       	// "projects/library/seqan/blast/blast_run.h"(49)

//____________________________________________________________________________
// TagRunBlat_

struct TagRunBlat_;       	// "projects/library/seqan/blast/blast_run.h"(41)

//____________________________________________________________________________
// TagRunMegaBlast_

struct TagRunMegaBlast_;       	// "projects/library/seqan/blast/blast_run.h"(38)

//____________________________________________________________________________
// TagRunTBlastN_

struct TagRunTBlastN_;       	// "projects/library/seqan/blast/blast_run.h"(52)

//____________________________________________________________________________
// TagRunTBlastX_

struct TagRunTBlastX_;       	// "projects/library/seqan/blast/blast_run.h"(55)

//____________________________________________________________________________
// TagTBlastN_

struct TagTBlastN_;       	// "projects/library/seqan/blast/blast_base.h"(153)

//____________________________________________________________________________
// TagTBlastX_

struct TagTBlastX_;       	// "projects/library/seqan/blast/blast_base.h"(154)

//____________________________________________________________________________
// TagUnknownSource_

struct TagUnknownSource_;       	// "projects/library/seqan/blast/blast_hsp.h"(841)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Blast

typedef Tag<TagBlast_> const Blast;       	// "projects/library/seqan/blast/blast_base.h"(113)

//____________________________________________________________________________
// BlastN

typedef NucleotideBlast<TagBlastN_> BlastN;       	// "projects/library/seqan/blast/blast_base.h"(170)

//____________________________________________________________________________
// BlastP

typedef ProteinBlast<TagBlastP_> BlastP;       	// "projects/library/seqan/blast/blast_base.h"(173)

//____________________________________________________________________________
// BlastX

typedef ProteinBlast<TagBlastX_> BlastX;       	// "projects/library/seqan/blast/blast_base.h"(174)

//____________________________________________________________________________
// KnownSource

typedef Tag<TagKnownSource_> const KnownSource;       	// "projects/library/seqan/blast/blast_hsp.h"(845)

//____________________________________________________________________________
// MegaBlast

typedef NucleotideBlast<TagMegaBlast_> MegaBlast;       	// "projects/library/seqan/blast/blast_base.h"(171)

//____________________________________________________________________________
// RunBlastN

typedef Tag<TagRunBlastN_> const RunBlastN;       	// "projects/library/seqan/blast/blast_run.h"(36)

//____________________________________________________________________________
// RunBlastP

typedef Tag<TagRunBlastP_> const RunBlastP;       	// "projects/library/seqan/blast/blast_run.h"(47)

//____________________________________________________________________________
// RunBlastX

typedef Tag<TagRunBlastX_> const RunBlastX;       	// "projects/library/seqan/blast/blast_run.h"(50)

//____________________________________________________________________________
// RunBlat

typedef Tag<TagRunBlat_> const RunBlat;       	// "projects/library/seqan/blast/blast_run.h"(42)

//____________________________________________________________________________
// RunMegaBlast

typedef Tag<TagRunMegaBlast_> const RunMegaBlast;       	// "projects/library/seqan/blast/blast_run.h"(39)

//____________________________________________________________________________
// RunTBlastN

typedef Tag<TagRunTBlastN_> const RunTBlastN;       	// "projects/library/seqan/blast/blast_run.h"(53)

//____________________________________________________________________________
// RunTBlastX

typedef Tag<TagRunTBlastX_> const RunTBlastX;       	// "projects/library/seqan/blast/blast_run.h"(56)

//____________________________________________________________________________
// TBlastN

typedef ProteinBlast<TagTBlastN_> TBlastN;       	// "projects/library/seqan/blast/blast_base.h"(175)

//____________________________________________________________________________
// TBlastX

typedef ProteinBlast<TagTBlastX_> TBlastX;       	// "projects/library/seqan/blast/blast_base.h"(176)

//____________________________________________________________________________
// UnknownSource

typedef Tag<TagUnknownSource_> const UnknownSource;       	// "projects/library/seqan/blast/blast_hsp.h"(842)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _parseBlastHit

template <typename TFile, typename TChar, typename TBlastHit> inline typename Position<TFile>::Type _parseBlastHit(TFile & file, TChar & c, TBlastHit & hit);       	// "projects/library/seqan/blast/blast_hit.h"(151)
template <typename TFile, typename TChar, typename TBlastSpec> inline typename Position<TFile>::Type _parseBlastHit(TFile & file, TChar & c, BlastHit<TBlastSpec,StreamReport<TFile> > & hit);       	// "projects/library/seqan/blast/blast_stream_hit.h"(65)

//____________________________________________________________________________
// _parseBlastHsp

template <typename TFile, typename TChar, typename TSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<NucleotideBlast<TSpec>,FullInfo > & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(171)
template <typename TFile, typename TChar, typename TSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<ProteinBlast<TSpec>,FullInfo> & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(462)
template <typename TFile, typename TChar, typename TBlastSpec, typename TInfoSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<TBlastSpec,TInfoSpec> & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(743)

//____________________________________________________________________________
// _parse_readAlignmentString

template <typename TFile, typename TChar> inline String<char> _parse_readAlignmentString(TFile & file, TChar& c);       	// "projects/library/seqan/blast/blast_parsing.h"(40)

//____________________________________________________________________________
// _parse_readQueryAndDBName

template <typename TFile, typename TChar> typename Position<TFile>::Type _parse_readQueryAndDBName(TFile & file, TChar & c, String<char> & query_name, String<char> & db_name);       	// "projects/library/seqan/blast/blast_parsing.h"(64)

//____________________________________________________________________________
// _readParameters

template <typename TFile, typename TChar, typename TBlastHsp> void _readParameters(TFile & file, TChar & c, BlastReport<TBlastHsp, StoreReport<FullInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(386)
template <typename TFile, typename TChar, typename TBlastHsp> void _readParameters(TFile & , TChar & , BlastReport<TBlastHsp, StoreReport<BasicInfo> >& );       	// "projects/library/seqan/blast/blast_report.h"(478)

//____________________________________________________________________________
// _runBlast

template <typename TString, typename TPath1, typename TPath, typename TParamString> void _runBlast(TPath1 blast_path, TPath db_path, TString db_name, TPath query_path, TString query_name, TPath out_path, TString outfile_name, Tag<TagRunBlastN_>, TParamString params);       	// "projects/library/seqan/blast/blast_run.h"(81)

//____________________________________________________________________________
// atBegin

template <typename TBlastHsp, typename TStoreSpec> inline bool atBegin(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(181)
template <typename TBlastReport, typename TFile> inline bool atBegin(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(198)
template <typename TBlastHit, typename TFile> inline bool atBegin(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(209)
template <typename TBlastObject, typename TIteratorSpec> inline bool atBegin(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(199)

//____________________________________________________________________________
// atEnd

template <typename TBlastHsp, typename TStoreSpec> inline bool atEnd(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(202)
template <typename TBlastReport, typename TFile> inline bool atEnd(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(383)
template <typename TBlastHsp, typename TSpec, typename TFile> inline bool atEnd(TFile & file, BlastReport<TBlastHsp,TSpec> & blast);       	// "projects/library/seqan/blast/blast_report.h"(1106)
template <typename TBlastHit, typename TFile> inline bool atEnd(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(359)
template <typename TBlastReport> inline bool atEnd(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(388)

//____________________________________________________________________________
// bitScore

template <typename TBlastSpec> inline float & bitScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1478)

//____________________________________________________________________________
// clear

template <typename TSpec> inline void clear(BlastHsp<NucleotideBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(336)
template <typename TSpec> inline void clear(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(635)
template <typename TBlastSpec> inline void clear(BlastHsp<TBlastSpec, BasicInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(723)
template <typename TBlastHsp, typename TSpec> inline void clear(BlastHit<TBlastHsp, StoreReport<TSpec> >& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(91)
template <typename TBlastHsp> inline void clear(BlastReport<TBlastHsp, StoreReport<FullInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(194)
template <typename TBlastHsp> inline void clear(BlastReport<TBlastHsp, StoreReport<BasicInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(366)

//____________________________________________________________________________
// databaseAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> & databaseAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1406)

//____________________________________________________________________________
// databaseBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & databaseBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1304)

//____________________________________________________________________________
// databaseEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & databaseEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1370)

//____________________________________________________________________________
// databaseFrame

template <typename TSpec> inline int & databaseFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1626)

//____________________________________________________________________________
// databaseName

template <typename TBlastHsp, typename TSpec> inline String<char> & databaseName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(759)

//____________________________________________________________________________
// databaseOrientationPlus

template <typename TBlastSpec> inline bool databaseOrientationPlus(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1598)

//____________________________________________________________________________
// eValue

template <typename TBlastSpec, typename TInfoSpec> inline double & eValue(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1423)

//____________________________________________________________________________
// eValueCutoff

template <typename TBlastHsp> inline double & eValueCutoff(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(843)

//____________________________________________________________________________
// entropy

template <typename TBlastHsp> inline float & entropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1059)

//____________________________________________________________________________
// gapExtension

template <typename TBlastHsp> inline float & gapExtension(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(912)

//____________________________________________________________________________
// gapOpen

template <typename TBlastHsp> inline float & gapOpen(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(886)

//____________________________________________________________________________
// gappedEntropy

template <typename TBlastHsp> inline float & gappedEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1076)

//____________________________________________________________________________
// gappedKappa

template <typename TBlastHsp> inline float & gappedKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1032)

//____________________________________________________________________________
// gappedLambda

template <typename TBlastHsp> inline float & gappedLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(976)

//____________________________________________________________________________
// gapsAllowed

template <typename TBlastHsp> inline bool gapsAllowed(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(940)

//____________________________________________________________________________
// getAlignment

template <typename TBlastHsp, typename TSpec, typename TSource> inline unsigned int getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali, UnknownSource);       	// "projects/library/seqan/blast/blast_hsp.h"(854)
template <typename TBlastHsp, typename TSpec, typename TSource> inline unsigned int getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali);       	// "projects/library/seqan/blast/blast_hsp.h"(963)
template <typename TBlastHsp, typename TSpec, typename TSource> inline unsigned int getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali, KnownSource);       	// "projects/library/seqan/blast/blast_hsp.h"(983)
template <typename TBlastHsp, typename TAlign, typename TId> inline unsigned int getAlignment(TBlastHsp & hsp, Graph<TAlign> & ali, TId id0, TId id1);       	// "projects/library/seqan/blast/blast_hsp.h"(1055)
template <typename TBlastHsp, typename TStringSet, typename TCargo, typename TSpec> inline unsigned int getAlignment(TBlastHsp & hsp, Graph<Alignment<TStringSet,TCargo,TSpec> > & ali);       	// "projects/library/seqan/blast/blast_hsp.h"(1143)

//____________________________________________________________________________
// getBitScore

template <typename TBlastSpec> inline float getBitScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1497)

//____________________________________________________________________________
// getDatabaseAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> getDatabaseAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1414)

//____________________________________________________________________________
// getDatabaseBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getDatabaseBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1322)

//____________________________________________________________________________
// getDatabaseEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getDatabaseEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1378)

//____________________________________________________________________________
// getDatabaseFrame

template <typename TSpec> inline int getDatabaseFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1634)

//____________________________________________________________________________
// getDatabaseName

template <typename TBlastHsp, typename TSpec> inline String<char> getDatabaseName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(779)

//____________________________________________________________________________
// getEValue

template <typename TBlastSpec, typename TInfoSpec> inline double getEValue(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1441)

//____________________________________________________________________________
// getEValueCutoff

template <typename TBlastHsp> inline double getEValueCutoff(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(862)

//____________________________________________________________________________
// getEntropy

template <typename TBlastHsp> inline float getEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1067)

//____________________________________________________________________________
// getGapExtension

template <typename TBlastHsp> inline float getGapExtension(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(931)

//____________________________________________________________________________
// getGapOpen

template <typename TBlastHsp> inline float getGapOpen(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(904)

//____________________________________________________________________________
// getGappedEntropy

template <typename TBlastHsp> inline float getGappedEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1084)

//____________________________________________________________________________
// getGappedKappa

template <typename TBlastHsp> inline float getGappedKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1050)

//____________________________________________________________________________
// getGappedLambda

template <typename TBlastHsp> inline float getGappedLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(994)

//____________________________________________________________________________
// getKappa

template <typename TBlastHsp> inline float getKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1023)

//____________________________________________________________________________
// getLambda

template <typename TBlastHsp> inline float getLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(967)

//____________________________________________________________________________
// getLength

template <typename TBlastHsp, typename TStoreSpec> inline unsigned int getLength(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(128)

//____________________________________________________________________________
// getMatrixName

template <typename TBlastHsp> inline String<char> getMatrixName(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(878)

//____________________________________________________________________________
// getName

template <typename TBlastHsp, typename TStoreSpec> inline String<char> getName(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(112)

//____________________________________________________________________________
// getNext

template <typename TBlastHsp, typename TSpec, typename TFile> inline void getNext(TFile & file, BlastReport<TBlastHsp,TSpec> & blast);       	// "projects/library/seqan/blast/blast_report.h"(1128)

//____________________________________________________________________________
// getNextHitFilePos

template <typename TBlastHsp, typename TFile> inline void getNextHitFilePos(TFile & file, Iter<BlastReport<TBlastHsp, StreamReport<TFile> >, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(405)

//____________________________________________________________________________
// getNextHspFilePos

template <typename TBlastHsp, typename TFile> inline void getNextHspFilePos(TFile & file, Iter<BlastHit<TBlastHsp, StreamReport<TFile> >, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(381)

//____________________________________________________________________________
// getNumGaps

template <typename TBlastSpec> inline unsigned int getNumGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1560)

//____________________________________________________________________________
// getPercentGaps

template <typename TBlastSpec> inline unsigned int getPercentGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1532)

//____________________________________________________________________________
// getPercentIdentity

template <typename TBlastSpec> inline unsigned int getPercentIdentity(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1516)

//____________________________________________________________________________
// getPercentPositives

template <typename TSpec> inline unsigned int getPercentPositives(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1650)

//____________________________________________________________________________
// getQueryAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> getQueryAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1396)

//____________________________________________________________________________
// getQueryBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getQueryBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1294)

//____________________________________________________________________________
// getQueryEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getQueryEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1350)

//____________________________________________________________________________
// getQueryFrame

template <typename TSpec> inline int getQueryFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1617)

//____________________________________________________________________________
// getQueryName

template <typename TBlastHsp, typename TSpec> inline String<char> getQueryName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(739)

//____________________________________________________________________________
// getScore

template <typename TBlastSpec> inline float getScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1470)

//____________________________________________________________________________
// getValue

template <typename TBlastHsp, typename TStoreSpec> inline typename GetValue<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type getValue(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(132)
template <typename TBlastReport, typename TFile> inline typename GetValue<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type getValue(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(320)
template <typename TBlastHit, typename TFile> inline typename GetValue<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type getValue(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(290)
template <typename TBlastReport> inline typename GetValue<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type getValue(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(334)

//____________________________________________________________________________
// goBegin

template <typename TBlastHsp, typename TStoreSpec> inline void goBegin(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(191)
template <typename TBlastReport, typename TFile> inline void goBegin(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(220)
template <typename TBlastHit, typename TFile> inline void goBegin(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(222)
template <typename TBlastObject, typename TIteratorSpec> inline void goBegin(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(218)

//____________________________________________________________________________
// goEnd

template <typename TBlastHsp, typename TStoreSpec> inline void goEnd(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(212)
template <typename TBlastReport> inline void goEnd(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(405)

//____________________________________________________________________________
// goNext

template <typename TBlastHsp, typename TStoreSpec> inline void goNext(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(222)
template <typename TBlastReport, typename TFile> inline void goNext(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(247)
template <typename TBlastHit, typename TFile> inline void goNext(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(237)
template <typename TBlastObject, typename TIteratorSpec> inline void goNext(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(237)

//____________________________________________________________________________
// goPrevious

template <typename TBlastHsp, typename TStoreSpec> inline void goPrevious(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(245)
template <typename TBlastObject, typename TIteratorSpec> inline void goPrevious(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(268)

//____________________________________________________________________________
// hostHit

template <typename TBlastHit> inline typename Host<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type const& hostHit(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(347)

//____________________________________________________________________________
// hostReport

template <typename TBlastReport> inline typename Host<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type & hostReport(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(361)
template <typename TBlastReport> inline typename Host<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type & hostReport(Iter<TBlastReport, SimpleBlastIterator<HitIterator> > & it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(370)

//____________________________________________________________________________
// kappa

template <typename TBlastHsp> inline float & kappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1004)

//____________________________________________________________________________
// lambda

template <typename TBlastHsp> inline float & lambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(949)

//____________________________________________________________________________
// length

template <typename TBlast, typename TSpec> inline unsigned int length(BlastHsp<TBlast,TSpec >& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1664)
template <typename TBlastHsp, typename TStoreSpec> inline unsigned int & length(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(120)

//____________________________________________________________________________
// matrixName

template <typename TBlastHsp> inline String<char> & matrixName(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(870)

//____________________________________________________________________________
// name

template <typename TBlastHsp, typename TStoreSpec> inline String<char> & name(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(104)

//____________________________________________________________________________
// numGaps

template <typename TBlastSpec> inline unsigned int & numGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1540)

//____________________________________________________________________________
// numHits

template <typename TBlastHsp, typename TInfoSpec> inline unsigned int numHits(BlastReport<TBlastHsp,StoreReport<TInfoSpec> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(799)

//____________________________________________________________________________
// numHsps

template <typename TBlastHsp, typename TSpec> inline unsigned int numHsps(BlastHit<TBlastHsp, StoreReport<TSpec> >& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(137)
template <typename TBlastHsp, typename TInfoSpec> inline unsigned int numHsps(BlastReport<TBlastHsp,StoreReport<TInfoSpec> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(818)

//____________________________________________________________________________
// operator!=

template <typename TBlastHsp, typename TStoreSpec> inline bool operator!=(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it1, Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(289)
template <typename TBlastReport> inline bool operator!=(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it1, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(299)
template <typename TBlastHit> inline bool operator!=(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it1, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(278)
template <typename TBlastObject, typename TIteratorSpec> inline bool operator!=(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it1, Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it2);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(312)

//____________________________________________________________________________
// operator*

template <typename TBlastHsp, typename TStoreSpec> inline typename Reference<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type operator* (Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(153)
template <typename TBlastObject, typename TIteratorSpec> inline typename Reference<Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> > >::Type operator* (Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(181)

//____________________________________________________________________________
// operator++

template <typename TBlastHsp, typename TStoreSpec> inline Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& operator++(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(232)
template <typename TBlastObject, typename TIteratorSpec> inline Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& operator++(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(247)

//____________________________________________________________________________
// operator--

template <typename TBlastHsp, typename TStoreSpec> inline Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& operator--(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(255)
template <typename TBlastObject, typename TIteratorSpec> inline Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& operator--(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(278)

//____________________________________________________________________________
// operator==

template <typename TBlastHsp, typename TStoreSpec> inline bool operator==(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it1, Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(278)
template <typename TBlastReport> inline bool operator==(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it1, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(288)
template <typename TBlastHit> inline bool operator==(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it1, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(267)
template <typename TBlastObject, typename TIteratorSpec> inline bool operator==(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it1, Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it2);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(301)

//____________________________________________________________________________
// percentGaps

template <typename TBlastSpec> inline unsigned int & percentGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1524)

//____________________________________________________________________________
// percentIdentity

template <typename TBlastSpec> inline unsigned int & percentIdentity(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1506)

//____________________________________________________________________________
// percentPositives

template <typename TSpec> inline unsigned int & percentPositives(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1642)

//____________________________________________________________________________
// queryAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> & queryAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1387)

//____________________________________________________________________________
// queryBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & queryBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1273)

//____________________________________________________________________________
// queryEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & queryEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1332)

//____________________________________________________________________________
// queryFrame

template <typename TSpec> inline int & queryFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1609)

//____________________________________________________________________________
// queryName

template <typename TBlastHsp, typename TSpec> inline String<char> & queryName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(719)

//____________________________________________________________________________
// queryOrientationPlus

template <typename TBlastSpec> inline bool queryOrientationPlus(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1580)

//____________________________________________________________________________
// read

template <typename TBlastHsp, typename TFile> void read(TFile & file, BlastReport<TBlastHsp, StreamReport<TFile> >& blastObj, Tag<TagBlast_>);       	// "projects/library/seqan/blast/blast_stream_report.h"(91)
template <typename TFile, typename TBlastHsp, typename TInfoSpec> void read(TFile & file, BlastReport<TBlastHsp, StoreReport<TInfoSpec> >& blastObj, Tag<TagBlast_>);       	// "projects/library/seqan/blast/blast_report.h"(494)

//____________________________________________________________________________
// run

template <typename TBlast, typename TBlastReport, typename TString, typename TParamString> void run(Tag<TBlast> tag, TString blast_path, TString db_path, TString db_name, TString query_path, TString query_name, TBlastReport & blastObj, TParamString params );       	// "projects/library/seqan/blast/blast_run.h"(111)

//____________________________________________________________________________
// score

template <typename TBlastSpec> inline float & score(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1452)

//____________________________________________________________________________
// value

template <typename TBlastHsp, typename TStoreSpec> inline typename Reference<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type value(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(143)
template <typename TBlastReport, typename TFile> inline typename Reference<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type value(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(348)
template <typename TBlastHit, typename TFile> inline typename Reference<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type value(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(313)
template <typename TBlastReport> inline typename Reference<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type value(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(351)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

