//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------


#ifndef SEQ24_SEQEVENT
#define SEQ24_SEQEVENT

#include "sequence.h"
#include "seqkeys.h"

#include <gtk--/button.h>
#include <gtk--/window.h>
#include <gtk--/accelgroup.h>
#include <gtk--/box.h>
#include <gtk--/main.h>
#include <gtk--/menu.h>
#include <gtk--/menubar.h>
#include <gtk--/eventbox.h>
#include <gtk--/window.h>
#include <gtk--/table.h>
#include <gtk--/drawingarea.h>
#include <gtk--/widget.h>

#include "globals.h"
#include "seqdata.h"

using namespace Gtk;
using SigC::slot;

/* piano event */
class seqevent : public Gtk::DrawingArea
{

 private: 

    Gdk_GC       m_gc;
    Gdk_Window   m_window;
    Gdk_Color    m_black, m_white, m_grey, m_dk_grey;

    Gdk_Pixmap   m_pixmap;
    Gdk_Pixmap   m_background;
 
    GdkRectangle m_old;
    GdkRectangle m_selected;

    sequence     *m_seq;
    seqdata      *m_seqdata_wid;

    /* one pixel == m_zoom ticks */
    int          m_zoom;
    int          m_snap;

    int m_window_x, m_window_y;

    /* when highlighting a bunch of events */
    bool m_selecting;
    bool m_moving;
    bool m_growing;
    bool m_adding;
    bool m_paste;

    /* where the dragging started */
    int m_drop_x; 
    int m_drop_y;
    int m_current_x;
    int m_current_y;

    /* what is the data window currently editing ? */
    unsigned char m_status;
    unsigned char m_cc;

    void realize_impl();
    int expose_event_impl(GdkEventExpose* a_ev);

    int button_press_event_impl(GdkEventButton* a_ev); 
    int button_release_event_impl(GdkEventButton* a_ev);
    int motion_notify_event_impl(GdkEventMotion* a_ev);
    int key_press_event_impl(GdkEventKey* a_p0);
    int focus_in_event_impl(GdkEventFocus*);
    int focus_out_event_impl(GdkEventFocus*);

    void convert_x( int a_x, long *a_ticks );
    void convert_t( long a_ticks, int *a_x );

    void snap_y( int *a_y );
    void snap_x( int *a_x );

    void x_to_w( int a_x1, int a_x2,
		 int *a_x, int *a_w  );

    void drop_event( long a_tick );
    void draw_events_on ( Gdk_Drawable *a_draw );

    void start_paste( void );

 public:

    seqevent( sequence *a_seq, int a_zoom, int a_snap, seqdata *a_seqdata_wid );

    void reset();
    void set_zoom( int a_zoom );
    void set_snap( int a_snap );

    void set_data_type( unsigned char a_status, unsigned char a_control  );
   
    void update_sizes();
    void fill_background_pixmap();
    void draw_events_on_pixmap();
    void draw_pixmap_on_window();
    void draw_selection_on_window();
    void update_pixmap();
    
    int idle_redraw();

    void set_adding( bool a_adding );


  
};

#endif
