//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------

#ifndef SEQ24_OPTIONS
#define SEQ24_OPTIONS

#include <gtk--/button.h>
#include <gtk--/window.h>
#include <gtk--/accelgroup.h>
#include <gtk--/box.h>
#include <gtk--/main.h>
#include <gtk--/menu.h>
#include <gtk--/menubar.h>
#include <gtk--/eventbox.h>
#include <gtk--/window.h>
#include <gtk--/dialog.h>
#include <gtk--/table.h>
#include <gtk--/drawingarea.h>
#include <gtk--/label.h>
#include <gtk--/frame.h> 
#include <gtk--/fileselection.h>
#include <gtk--/dialog.h>
#include <gtk--/text.h>
#include <gtk--/arrow.h>
#include <gtk--/spinbutton.h>
#include <gtk--/progressbar.h>
#include <gtk--/checkbutton.h>
#include <gtk--/togglebutton.h>
#include <gtk--/notebook.h>


#include "globals.h"
#include "perform.h"

using namespace Gtk;
using SigC::slot;
using SigC::bind;


class options : public Gtk::Dialog
{

 private:

    perform *m_perf;

    Button  *m_button_ok;

    //Frame   *m_frame_clock;
	//Frame   *m_frame_midi;
	//Frame   *m_frame_test;
	
    Table      *m_table;

	Notebook *m_notebook;

	ToggleButton *m_check_toggle[ c_seqs_in_set ];
	ToggleButton *m_check_toggle_inverse[ c_seqs_in_set ];
	ToggleButton *m_check_on[ c_seqs_in_set ];
	ToggleButton *m_check_on_inverse[ c_seqs_in_set ];
    ToggleButton *m_check_off[ c_seqs_in_set ];
	ToggleButton *m_check_off_inverse[ c_seqs_in_set ];

	Entry   *m_entry_toggle_status[ c_seqs_in_set ];
	Entry   *m_entry_toggle_d1[ c_seqs_in_set ];
	Entry   *m_entry_toggle_d2[ c_seqs_in_set ];	
	Entry   *m_entry_toggle_d3[ c_seqs_in_set ];	

	Entry   *m_entry_on_status[ c_seqs_in_set ];
	Entry   *m_entry_on_d1[ c_seqs_in_set ];
	Entry   *m_entry_on_d2[ c_seqs_in_set ];	
	Entry   *m_entry_on_d3[ c_seqs_in_set ];

	Entry   *m_entry_off_status[ c_seqs_in_set ];
	Entry   *m_entry_off_d1[ c_seqs_in_set ];
	Entry   *m_entry_off_d2[ c_seqs_in_set ];	
	Entry   *m_entry_off_d3[ c_seqs_in_set ];

    void clock_callback( int a_bus, CheckButton *a_button );

	string uc_2_hex_string( unsigned char a_c );
	unsigned char hex_string_2_uc( string a_s ); 

    void toggle_callback_toggle(  ToggleButton *a_toggle, int a_sequence  );
	void toggle_callback_on(  ToggleButton *a_toggle, int a_sequence  );
	void toggle_callback_off(  ToggleButton *a_toggle, int a_sequence  );

	void toggle_callback_toggle_inverse(  ToggleButton *a_toggle, int a_sequence  );
	void toggle_callback_on_inverse(  ToggleButton *a_toggle, int a_sequence  );
	void toggle_callback_off_inverse(  ToggleButton *a_toggle, int a_sequence  );


	void toggle_callback(  ToggleButton *a_toggle,
						   ToggleButton *a_toggle_inv,
						   Entry *m_entry_status,
						   Entry *m_entry_d1,
						   Entry *m_entry_d2,	
						   Entry *m_entry_d3,
						   int a_sequence,
						   midi_control *a_midi_control  );

	void on_changed_callback( Entry *a_entry, 
							  int a_pos, 
							  midi_control *a_midi_control  );

	void on_changed_callback_toggle_status( Entry *a_entry, int a_sequence  );
	void on_changed_callback_toggle_d1(     Entry *a_entry, int a_sequence  );
	void on_changed_callback_toggle_d2(     Entry *a_entry, int a_sequence  );
	void on_changed_callback_toggle_d3(     Entry *a_entry, int a_sequence  );

	void on_changed_callback_on_status( Entry *a_entry, int a_sequence  );
	void on_changed_callback_on_d1(     Entry *a_entry, int a_sequence  );
	void on_changed_callback_on_d2(     Entry *a_entry, int a_sequence  );
	void on_changed_callback_on_d3(     Entry *a_entry, int a_sequence  );

	void on_changed_callback_off_status( Entry *a_entry, int a_sequence  );
	void on_changed_callback_off_d1(     Entry *a_entry, int a_sequence  );
	void on_changed_callback_off_d2(     Entry *a_entry, int a_sequence  );
	void on_changed_callback_off_d3(     Entry *a_entry, int a_sequence  );

	void validate_hex_entry( Entry *a_entry );

 public:

    options( perform *a_p );

};

#endif
