//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------


#ifndef SEQ24_MAINWID
#define SEQ24_MAINWID


#include <gtk--/button.h>
#include <gtk--/window.h>
#include <gtk--/accelgroup.h>
#include <gtk--/box.h>
#include <gtk--/main.h>
#include <gtk--/menu.h>
#include <gtk--/menubar.h>
#include <gtk--/eventbox.h>
#include <gtk--/window.h>
#include <gtk--/table.h>
#include <gtk--/drawingarea.h>
#include <gtk--/widget.h>
#include <gtk--/style.h> 

#include "globals.h"
#include "perform.h"

using namespace Gtk;
using SigC::slot;

const int c_seqarea_seq_x = c_text_x * 13;
const int c_seqarea_seq_y = c_text_y * 2 - 2;

/* piano roll */
class mainwid : public Gtk::DrawingArea
{

 private: 

    Gdk_GC       m_gc;
    Gdk_Window   m_window;
    Gdk_Color    m_black, m_white, m_grey, m_dk_grey;
    Gdk_Color    m_background, m_foreground;

    Gdk_Pixmap   m_pixmap;
   
    GdkRectangle m_old;
    GdkRectangle m_selected;

    int          m_screenset;

    Menu         *m_menu;

    perform      *m_mainperf;

    sequence     m_clipboard;
    sequence     m_moving_seq;

    int          m_window_x, 
                 m_window_y;

    bool         m_button_down;
    bool         m_moving;

    /* when highlighting a bunch of events */
 
    /* where the dragging started */
    int m_drop_x; 
    int m_drop_y;
    int m_current_x;
    int m_current_y;

    int m_current_seq;
    int m_old_seq;

    long m_last_tick_x[c_max_sequence];
    bool m_last_playing[c_max_sequence];
    static const char m_seq_to_char[c_seqs_in_set];



    void realize_impl();

    int expose_event_impl(GdkEventExpose* a_ev);
    int button_press_event_impl(GdkEventButton* a_ev); 
    int button_release_event_impl(GdkEventButton* a_ev);
    int motion_notify_event_impl(GdkEventMotion* a_p0);
    int focus_in_event_impl(GdkEventFocus*);
    int focus_out_event_impl(GdkEventFocus*);

    void seq_edit();
    void seq_new();

    void seq_copy();   
    void seq_cut();
    void seq_paste(); 

	void seq_clear_perf();
 
    void draw_sequence_on_pixmap( int a_seq );
    void draw_sequences_on_pixmap();

    void fill_background_window();
    void draw_pixmap_on_window();

    int seq_from_xy( int a_x, int a_y );

    int timeout( void );

 public:

    mainwid( perform *a_p );
    ~mainwid( );

    void reset();
 
    int get_screenset( ); 
    void set_screenset( int a_ss );

    void update_sequence_on_window( int a_seq  );
    void update_sequences_on_window( );
   
    void update_markers( int a_ticks );
    void draw_marker_on_sequence( int a_seq, int a_tick );

};

#endif
