//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------
#include "event.h"
#include "seqtime.h"


seqtime::seqtime(sequence *a_seq, int a_zoom): DrawingArea() 
{     
    m_seq = a_seq;
    m_zoom = a_zoom;

    add_events( GDK_BUTTON_PRESS_MASK | 
		GDK_BUTTON_RELEASE_MASK );

    // in the construor you can only allocate colors, 
    // get_window() returns 0 because we have not be realized
    Gdk_Colormap colormap = get_default_colormap();

    m_black = Gdk_Color( "black" );
    m_white = Gdk_Color( "white" );
    m_grey  = Gdk_Color( "grey" );

    colormap.alloc( m_black );
    colormap.alloc( m_white );
    colormap.alloc( m_grey );

} 

void 
seqtime::update_sizes()
{
    /* set default size */
    size( m_seq->get_length() / m_zoom , c_timearea_y );

    /* set these for later */
    m_window_x = m_seq->get_length() / m_zoom;
    m_window_y = c_timearea_y;

    m_pixmap = Gdk_Pixmap( m_window,
			   m_window_x,
			   m_window_y );
}

void 
seqtime::realize_impl()
{
    // we need to do the default realize
    Gtk::DrawingArea::realize_impl();

    //Gtk::Main::idle.connect(slot(this,&seqtime::idleProgress));
    Gtk::Main::timeout.connect(slot(this,&seqtime::idle_progress), 50);
    
    // Now we can allocate any additional resources we need
    m_window = get_window();
    m_gc.create( m_window );
    m_window.clear();

    update_sizes();
    update_pixmap();
}


int 
seqtime::idle_progress( )
{
    return true;
}



void 
seqtime::set_zoom( int a_zoom )
{
    m_zoom = a_zoom;
    update_sizes();
    update_pixmap();
    draw_pixmap_on_window();
}

void 
seqtime::reset()
{
    update_sizes();
    update_pixmap();
    draw_pixmap_on_window();
}

void 
seqtime::update_pixmap()
{
    /* clear background */
    m_gc.set_foreground(m_white);
    m_pixmap.draw_rectangle(m_gc,true,
			    0,
			    0, 
			    m_window_x, 
			    m_window_y );


    m_gc.set_foreground(m_black);
    m_pixmap.draw_line(m_gc,
		       0,
		       m_window_y - 1,
		       m_window_x,
		       m_window_y - 1 );


    /* draw vert lines */
    m_gc.set_foreground(m_black);
    for ( int i=0; i<c_maxbeats; i++ )
    {
	int base_line = i * (c_ppqn * 4) / m_seq->get_bw() / m_zoom;

	/* beat */
	m_pixmap.draw_line(m_gc,
			   base_line,
			   0,
			   base_line,
			   m_window_y );
	
	/* bar */
	if ( i %  m_seq->get_bpm() == 0 ){

	    char bar[5];
	    sprintf( bar, "%d", i/ m_seq->get_bpm()  ); 

	    m_gc.set_foreground(m_black);
	    m_pixmap.draw_string(c_text_font_6_12, m_gc, 
				 base_line + 2, 
				 8,
				 bar );
	}
    }
}




void 
seqtime::draw_pixmap_on_window()
{
    m_window.draw_pixmap(m_gc, 
			 m_pixmap, 
			 0,0,
			 0,0,
			 m_window_x,
			 m_window_y );
}

int 
seqtime::expose_event_impl(GdkEventExpose* a_e)
{
    m_window.draw_pixmap(m_gc,  
    			 m_pixmap, 
    			 a_e->area.x,
			 a_e->area.y,
			 a_e->area.x,
			 a_e->area.y,
			 a_e->area.width,
			 a_e->area.height );
    return true;
}

int 
seqtime::button_press_event_impl(GdkEventButton* p0)
{
    return false;
}

int 
seqtime::button_release_event_impl(GdkEventButton* p0)
{
    return false;
}
