//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------


#ifndef SEQ24_SEQKEYS
#define SEQ24_SEQKEYS

#include "sequence.h"

#include <gtk--/button.h>
#include <gtk--/window.h>
#include <gtk--/accelgroup.h>
#include <gtk--/box.h>
#include <gtk--/main.h>
#include <gtk--/menu.h>
#include <gtk--/menubar.h>
#include <gtk--/eventbox.h>
#include <gtk--/window.h>
#include <gtk--/table.h>
#include <gtk--/drawingarea.h>
#include <gtk--/widget.h>

#include "globals.h"

/* holds the left side piano */
class seqkeys : public Gtk::DrawingArea
{
 private: 

    Gdk_GC       m_gc;
    Gdk_Window   m_window;
    Gdk_Color    m_black, m_white, m_grey;

    Gdk_Pixmap   m_pixmap;

    sequence *m_seq;

    void realize_impl();
    int expose_event_impl(GdkEventExpose* a_ev);
    int button_press_event_impl(GdkEventButton* a_ev); 
    int button_release_event_impl(GdkEventButton* a_ev);
    int motion_notify_event_impl(GdkEventMotion* a_p0);
    int leave_notify_event_impl	(GdkEventCrossing* p0);

    void draw_area();
    void update_pixmap();
    void convert_y( int a_y, int *a_note);

    bool m_hint_state;
    int m_hint_key;

    bool m_keying;
    int m_keying_note;

    void draw_key( int a_key, bool a_state );


 public:

    /* sets key to grey */
    void set_hint_key( int a_key );

    /* true == on, false == off */
    void set_hint_state( bool a_state );

    seqkeys( sequence *a_seq );


};

#endif
