//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------
#include "mainwnd.h"
#include "perform.h"
#include "midifile.h"
#include "perfedit.h"

#include "play2.xpm"
#include "stop.xpm"
#include "perfedit.xpm"
#include "seq24.xpm"
 
Gdk_Font c_text_font_6_12;
Gdk_Font c_text_font_8_13;
Gdk_Font c_text_font_5_7;

mainwnd::mainwnd(perform *a_p) 
: Gtk::Window( GTK_WINDOW_TOPLEVEL )
{

//     c_text_font_6_12 = Gdk_Font( "6x12" );
//     c_text_font_8_13 = Gdk_Font( "8x13" );
//     c_text_font_5_7 = Gdk_Font( "5x7" );

    c_text_font_6_12 = Gdk_Font( "-*-fixed-medium-r-*--12-*-*-*-*-*-*");
    c_text_font_8_13 = Gdk_Font( "-*-fixed-medium-r-*--13-*-*-*-*-*-*");
    c_text_font_5_7 =  Gdk_Font( "-*-fixed-medium-r-*--7-*-*-*-*-*-*");

    /* set the performance */
    m_mainperf = a_p;

    /* handle destroy event */
    destroy.connect(slot(this, &mainwnd::destroy_func));

    /* main window */
    set_title (" seq24 ");

    m_filesel = NULL;
    m_screen_set = 0;

    m_main_wid = manage( new mainwid(  m_mainperf ));
    m_main_time = manage( new maintime( ));

    m_menubar   = manage(new MenuBar());
    m_menu_file = manage(new Menu());
    m_menu_control = manage( new Menu());
    m_menu_help    = manage( new Menu());
    
    /* fill with items */
    m_menu_file->items().push_back(MenuElem("Open", slot(this,&mainwnd::file_open_dialog)));
    m_menu_file->items().push_back(MenuElem("Save", slot(this,&mainwnd::file_save_dialog)));
    m_menu_file->items().push_back(SeparatorElem());
    m_menu_file->items().push_back(MenuElem("Options", slot(this,&mainwnd::options_dialog)));
    m_menu_file->items().push_back(SeparatorElem());
    m_menu_file->items().push_back(MenuElem("Exit", destroy.slot()));

    m_menu_help->items().push_back(MenuElem("About", slot(this,&mainwnd::about_dialog)));
 
    m_menubar->items().push_front(MenuElem("File","<control>f",*m_menu_file));
    m_menubar->items().push_back(MenuElem("Help","<control>a",*m_menu_help));

    HBox *hbox = manage( new HBox( false, 2 ) );

    m_button_stop = manage( new Button( ));
    m_button_stop->add( *manage( new Pixmap( stop_xpm  )));
    m_button_stop->clicked.connect( slot(this,&mainwnd::stop_playing));
    hbox->pack_start(*m_button_stop, false, false);

    m_button_play = manage( new Button() );
    m_button_play->add( *manage( new Pixmap( play2_xpm  )));
    m_button_play->clicked.connect(  slot( this, &mainwnd::start_playing));
    hbox->pack_start(*m_button_play, false, false);

    m_button_perfedit = manage( new Button(  ));
    m_button_perfedit->add( *manage( new Pixmap( perfedit_xpm  )));
    m_button_perfedit->clicked.connect( slot( this, &mainwnd::open_performance_edit ));
    hbox->pack_end(*m_button_perfedit, false, false, 4);

    m_adjust_bpm = manage( new Adjustment( c_bpm, 20, 500, 1 ));
    m_spinbutton_bpm = manage( new SpinButton( *m_adjust_bpm ));
    m_spinbutton_bpm->set_editable( false );
    hbox->pack_start(*(manage( new Label( "  bpm " ))), false, false, 4);
    hbox->pack_start(*m_spinbutton_bpm, false, false );
  
    m_adjust_ss = manage( new Adjustment( 0, 0, c_max_sets - 1, 1 ));
    m_spinbutton_ss = manage( new SpinButton( *m_adjust_ss ));
    m_spinbutton_ss->set_editable( false );
    m_spinbutton_ss->set_wrap( true );
    hbox->pack_end(*m_spinbutton_ss, false, false );
    hbox->pack_end(*(manage( new Label( "  set " ))), false, false, 4);

    m_adjust_bpm->value_changed.connect( slot(this,&mainwnd::adj_callback_bpm ));
    m_adjust_ss->value_changed.connect( slot(this,&mainwnd::adj_callback_ss ));
 
    m_entry_notes = manage( new Entry());
    m_entry_notes->changed.connect( slot(this,&mainwnd::edit_callback_notepad ));

    hbox->pack_start( *m_entry_notes, true, true );

    /* 2nd hbox */
    HBox *hbox2 = manage( new HBox( false, 0 ) );
    hbox2->pack_start( *manage( new Pixmap( seq24_xpm )), false, false );
    hbox2->pack_end( *m_main_time, false, false );

    /* set up a vbox, put the menu in it, and add it */
    VBox *vbox = new VBox();
    vbox->set_border_width( 10 );
    vbox->pack_start(*hbox2, false, false );
    vbox->pack_start(*m_main_wid, true, true, 10 );
    vbox->pack_start(*hbox, false, false ); 
 

    VBox *ovbox = new VBox();
 
    ovbox->pack_start(*m_menubar, false, false );
    ovbox->pack_start( *vbox );

    /* add box */
    this->add (*ovbox);
  
    /* show everything */
    show_all();

    add_events( GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK );

    m_entry_notes->set_text( * m_mainperf->get_screen_set_notepad( m_main_wid->get_screenset() )); 

    m_timeout_connect = Gtk::Main::timeout.connect(slot(this,&mainwnd::timer_callback), 25);

    /* set up hash for key events */
    key_events[ GDK_1 ] = 0; 
    key_events[ GDK_q ] = 1; 
    key_events[ GDK_a ] = 2;
    key_events[ GDK_z ] = 3; 
    key_events[ GDK_2 ] = 4; 
    key_events[ GDK_w ] = 5;
    key_events[ GDK_s ] = 6; 
    key_events[ GDK_x ] = 7; 
    key_events[ GDK_3 ] = 8;
    key_events[ GDK_e ] = 9; 
    key_events[ GDK_d ] = 10; 
    key_events[ GDK_c ] = 11;
    key_events[ GDK_4 ] = 12; 
    key_events[ GDK_r ] = 13; 
    key_events[ GDK_f ] = 14;
    key_events[ GDK_v ] = 15; 
    key_events[ GDK_5 ] = 16; 
    key_events[ GDK_t ] = 17;
    key_events[ GDK_g ] = 18; 
    key_events[ GDK_b ] = 19; 
    key_events[ GDK_6 ] = 20;
    key_events[ GDK_y ] = 21; 
    key_events[ GDK_h ] = 22; 
    key_events[ GDK_n ] = 23;
    key_events[ GDK_7 ] = 24; 
    key_events[ GDK_u ] = 25; 
    key_events[ GDK_j ] = 26;
    key_events[ GDK_m ] = 27; 
    key_events[ GDK_8 ] = 28; 
    key_events[ GDK_i ] = 29;
    key_events[ GDK_k ] = 30; 
    key_events[ GDK_comma ] = 31; 

    m_l_control_pressed = false;
	m_r_control_pressed = false;
    m_l_alt_pressed = false;

    for( int i=0; i<c_total_seqs; i++ )
	m_sequence_state[i] = false;
}



// This is the GTK timer callback, used to draw our current time and bpm
// on the main window
int 
mainwnd::timer_callback( void )
{
    long ticks = m_mainperf->get_tick();
	
    m_main_time->idle_progress( ticks );
    m_main_wid->update_markers( ticks );

    return true;

}


void 
mainwnd::open_performance_edit( void )
{
    manage( new perfedit( m_mainperf ));
}

/* connects with the windows close function */
void 
mainwnd::destroy_func()
{  
    m_timeout_connect.disconnect();
    Gtk::Main::quit();
}


void 
mainwnd::start_playing( void )
{
    m_mainperf->start( false );
}

void 
mainwnd::stop_playing( void )
{
    m_mainperf->stop();
    m_main_wid->update_sequences_on_window();
}


void 
mainwnd::file_save_dialog( void )
{
    /* no memleak */
    if ( m_filesel != NULL )
       delete m_filesel;

    m_filesel = new FileSelection ( "Save File" );
       
    m_filesel->get_ok_button()->clicked.connect(bind(slot(this, &mainwnd::file_save), true ));
    m_filesel->get_cancel_button()->clicked.connect(bind(slot(this, &mainwnd::file_save), false ));
      
    m_filesel->set_modal( true );
    m_filesel->show_all();
}


void 
mainwnd::options_dialog( void )
{
    manage( new options( m_mainperf ));
}


void 
mainwnd::file_open_dialog( void )
{
    /* no memleak */
    if ( m_filesel != NULL )
	delete m_filesel;

    m_filesel = new FileSelection ( "Open File" );

    HBox *abox = m_filesel->get_action_area();
    HBox *hbox = manage( new HBox( false, 2 ) );

    m_adjust_load_offset = manage( new Adjustment( 0, -(c_max_sets - 1) , c_max_sets - 1, 1 ));
    m_spinbutton_load_offset = manage( new SpinButton( *m_adjust_load_offset ));
    m_spinbutton_load_offset->set_editable( false );
    m_spinbutton_load_offset->set_wrap( true );
    hbox->pack_end(*m_spinbutton_load_offset, false, false );
    hbox->pack_end(*(manage( new Label( "Screen Set Offset" ))), false, false, 4);


    m_filesel->get_ok_button()->clicked.connect(bind(slot(this, &mainwnd::file_open), true ));
    m_filesel->get_cancel_button()->clicked.connect(bind(slot(this, &mainwnd::file_open), false ));

    abox->pack_end(*hbox, false, false );  

    m_filesel->set_modal( true );
    m_filesel->show_all();
}



void 
mainwnd::about_dialog( void )
{
    Dialog *dialog = manage( new Dialog(  ) );

    dialog->set_usize( 450, 400 );

    Button *ok = manage( new Button( " Ok " ));
    ok->clicked.connect( dialog->destroy.slot());

    Text *text = manage( new Text() );
    text->set_word_wrap( true );
    text->insert( c_about );

    dialog->get_action_area()->pack_start( *ok, false, false, 0);
    dialog->get_vbox()->pack_start( *text, true, true, 0);


    dialog->show_all();
}

void  
mainwnd::file_open( bool a_open )
{
    if ( a_open ) {
	midifile f( m_filesel->get_filename() );
	f.parse( m_mainperf, (int) m_adjust_load_offset->get_value() );
    }

    m_filesel->set_modal( false );
    m_filesel->hide();

    m_main_wid->reset();
    m_entry_notes->set_text( * m_mainperf->get_screen_set_notepad( m_main_wid->get_screenset() )); 

}


void  
mainwnd::file_save( bool a_save )
{
    if ( a_save ) {
	midifile f( m_filesel->get_filename() );
	f.write( m_mainperf );
    }


    m_filesel->set_modal( false );
    m_filesel->hide();
}


int 
mainwnd::delete_event_impl(GdkEventAny *a_e)
{

    midifile f( "autosave.mid" );
    f.write( m_mainperf );

    stop_playing();
    return false;
}


void 
mainwnd::adj_callback_ss( )
{
    m_main_wid->set_screenset( (int) m_adjust_ss->get_value()); 
    m_entry_notes->set_text( * m_mainperf->get_screen_set_notepad( m_main_wid->get_screenset() )); 
}


void 
mainwnd::adj_callback_bpm( )
{
    m_mainperf->set_bpm( (int) m_adjust_bpm->get_value()); 
}


int 
mainwnd::key_release_event_impl(GdkEventKey* a_ev)
{
    if ( a_ev->keyval == GDK_Control_L )
		{
			m_l_control_pressed = false;
		}
	

	if ( a_ev->keyval == GDK_Control_R )
		{
			m_r_control_pressed = false;
		}
	
	
    if ( a_ev->keyval == GDK_Alt_L ||
		 a_ev->keyval == GDK_Alt_R )
		{
			for( int i=0; i<c_total_seqs; i++ ){
				
				if ( m_mainperf->is_active( i ) ){
					m_mainperf->get_sequence( i )->set_playing( m_sequence_state[i] );
				}
			}
			
			m_main_wid->reset();
			m_l_alt_pressed = false;
		}
	
    return false;
}

void 
mainwnd::edit_callback_notepad( )
{
    m_mainperf->set_screen_set_notepad( m_main_wid->get_screenset(), 
				        &m_entry_notes->get_text()); 
}



int 
mainwnd::key_press_event_impl(GdkEventKey* a_ev)
{

    if( m_entry_notes->has_focus())
		m_entry_notes->key_press_event( a_ev );
    else
		{
			if ( a_ev->type == GDK_KEY_PRESS ){
				
				if ( a_ev->keyval == GDK_semicolon ){
					m_mainperf->set_bpm( m_mainperf->get_bpm() - 1 );  
					m_adjust_bpm->set_value(  m_mainperf->get_bpm() );
				}
				
				if ( a_ev->keyval == GDK_apostrophe ){
					m_mainperf->set_bpm( m_mainperf->get_bpm() + 1 );   
					m_adjust_bpm->set_value(  m_mainperf->get_bpm() );
				}
				
				if ( a_ev->keyval == GDK_Control_L )
					{
						m_l_control_pressed = true;
					}
				
				if (a_ev->keyval == GDK_Control_R )
					{
						m_r_control_pressed = true;
					}
				
				
				
				if ( a_ev->keyval == GDK_Alt_L ||
					 a_ev->keyval == GDK_Alt_R )
					{
						
						for( int i=0; i<c_total_seqs; i++ ){
							
							if ( m_mainperf->is_active( i ) ){
								m_sequence_state[i] = m_mainperf->get_sequence( i )->get_playing();
							}
							else
								m_sequence_state[i] = false;
						}
						m_l_alt_pressed = true;
					}
				
				
				
				if ( a_ev->keyval == GDK_bracketleft ){
					
					m_main_wid->set_screenset(  m_main_wid->get_screenset() - 1 );  
					m_adjust_ss->set_value(  m_main_wid->get_screenset() );	
					m_entry_notes->set_text( * m_mainperf->get_screen_set_notepad( m_main_wid->get_screenset() )); 
				}
				
				if ( a_ev->keyval == GDK_bracketright ){
					
					m_main_wid->set_screenset(  m_main_wid->get_screenset() + 1 );
					m_adjust_ss->set_value(  m_main_wid->get_screenset() );
					m_entry_notes->set_text( * m_mainperf->get_screen_set_notepad( m_main_wid->get_screenset() )); 
				}
				
				if( key_events.count( a_ev->keyval) != 0 ){
					
					if ( m_l_control_pressed ){
						m_l_control_pressed = false;
						m_mainperf->off_sequences( );
						m_main_wid->reset();
					}
					
					m_main_wid->sequence_key( key_events[a_ev->keyval], m_r_control_pressed );
				}
			}
		}

    return false;
}

