/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "Shutdown.h"
#include <QDBusInterface>
#include <kworkspace/kworkspace.h>

Shutdown::Shutdown(const bool isKDE, const bool shutdown, const bool force) :
	AbstractThreadedAction(), isKDE(isKDE), shutdown(shutdown), force(force) {

}

void Shutdown::run() {
	QDBusInterface* interface;
	if (isKDE) {
		interface = new QDBusInterface("org.kde.ksmserver", "/KSMServer",
				"org.kde.KSMServerInterface");
		interface->call("logout", 0, shutdown ? KWorkSpace::ShutdownTypeHalt
				: KWorkSpace::ShutdownTypeReboot, force ? KWorkSpace::ShutdownModeForceNow
				: KWorkSpace::ShutdownModeInteractive);
	} else {
		interface = new QDBusInterface("org.freedesktop.ConsoleKit",
				"/org/freedesktop/ConsoleKit/Manager", "org.freedesktop.ConsoleKit.Manager",
				QDBusConnection::systemBus());
		interface->call(shutdown ? "Stop" : "Restart");
	}
	delete interface;
}
