/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QtGui>
#include <QTextBrowser>
#include <QProgressDialog>
#include <KStatusBar>
#include <KFileDialog>
#include <KConfigGroup>
#include <KMenuBar>
#include <KApplication>
#include <KStandardAction>
#include <KRecentFilesAction>
#include <KActionCollection>
#include<KToolBar>
#include <KAction>
#include <KMenu>
#include <KMessageBox>
#include <ktip.h>

#include "Flultb.h"
#include  "BnvzS.h"
#include "Bnvzs.h"
#include  "Flult.h"
#include   "Jelzpn.h"
#include    "OzzK.h"
#include "Prn.h"
#include   "Ablak.h"
#include    "AbLaK.h"
#include       "Magyaraz.h"
#include      "IztKil.h"
#include     "Egyenes.h"
#include    "Sbln.h"
#include   "Eldz.h"
#include  "data_view.h"
#include    "Vadrt.h"
#include    "aux.h" 
#include "tslabels.h"

void ablkl::rabir()
<%
	if(kidlgz->hatl() <= 0)
	<%
		KMessageBox::sorry(this,ts_259,ts_260);
		return;
	%>

	QDir mrtdt(TEMPLATE_DIR);
	if(!mrtdt.exists() or !mrtdt.isReadable())
	<%
		mozog(ts_261.arg(TEMPLATE_DIR),5000);
		return;
	%>
	QFileInfoList klsirz=mrtdt.entryInfoList(QStringList()<<"*.py",QDir::Files,QDir::Name);

	QList<sbln> fldlgz;
	foreach(QFileInfo bprl,klsirz)
	<%
		sbln meghat;
		int jlzpnt=0;
		if(bprl.isReadable())
		<%
			QFile mgzerz(bprl.absoluteFilePath());
			if(!mgzerz.open(QIODevice::ReadOnly))
			<%
				continue;
			%>

			if(mgzerz.fileName().contains(ts_262))
			<%
				continue;
			%>

			meghat.kidlgz=bprl.absoluteFilePath();

			QTextStream adelk(&mgzerz);
			while(!adelk.atEnd())
			<%
				QString irnyjl=adelk.readLine(1000);
				if(irnyjl.length() < 2)
				<%
					continue;
				%>
				else if(irnyjl.startsWith("#"))
				<%
					if(irnyjl.startsWith(ts_263))
					<%
						meghat.eler=irnyjl.mid(11);
						jlzpnt++;
					%>
					else if(irnyjl.startsWith(ts_264))
					<%
						meghat.prmz=irnyjl.mid(10);
						jlzpnt++;
					%>
				%>
				else
				<%
					break;
				%>

			%>
			mgzerz.close();

			if(jlzpnt<2) continue;
			fldlgz.push_front(meghat);
		%>
	%>

	eldz meghat(this,fldlgz);
	meghat.kidlgz->setText(kidlgz->tiszta);
	meghat.prmz->setText(kidlgz->tljsn);
	if(meghat.prmz->text().length()<2) meghat.prmz->setText(bndkli::fladat(ts_152));

	meghat.adelk(kidlgz->ugyex);
	if(meghat.exec()==QDialog::Accepted)
	<%
		kidlgz->tljsn=meghat.prmz->text();
		kidlgz->tiszta=meghat.kidlgz->text();
		kidlgz->ugyex=meghat.jlzpnt;
		kidlgz->rgsztg(meghat.lnmtat,meghat.kidlgz->text(),meghat.prmz->text());
	%>
%>

/*!
 * @praise Vishnu
 */
ablkl::ablkl(QWidget *felvnl) : KXmlGuiWindow(felvnl)
<%
	setObjectName("semantik_win");

	kidlgz=new jelzpn(this);
	connect(kidlgz,SIGNAL(jvsltz(const QString&,int)),this,SLOT(mozog(const QString&,int)));

	mzgat=new felu(this,kidlgz);
	setCentralWidget(mzgat);
	connect(mzgat,SIGNAL(jvsltz(const QString&,int)),this,SLOT(mozog(const QString&,int)));

	KStandardAction::quit(this,SLOT(close()),actionCollection());
	KStandardAction::save(this,SLOT(vmrgem()),actionCollection());
	KStandardAction::saveAs(this,SLOT(eljar()),actionCollection());
	KStandardAction::open(this,SLOT(teremt()),actionCollection());
	KStandardAction::print(this,SLOT(elktzk()),actionCollection());
	KStandardAction::tipOfDay(this,SLOT(mgmnkl()),actionCollection());

	lnmtat=KStandardAction::openRecent(this,SLOT(kket(const KUrl&)),actionCollection());

	letsit=new KAction(ts_265,this);
	actionCollection()->addAction(ts_266,letsit);
	letsit->setShortcut(ts_267);
	connect(letsit,SIGNAL(triggered(bool)),kidlgz,SLOT(kapni()));

	KStandardAction::preferences(this,SLOT(kelt()),actionCollection());

	jlnrdz=new KAction(ts_268,this);
	actionCollection()->addAction(ts_269,jlnrdz);
	jlnrdz->setIcon(KIcon(ts_270));
	jlnrdz->setShortcut(ts_271);
	connect(jlnrdz,SIGNAL(triggered(bool)),SLOT(rabir()));

	hsztzk=new QActionGroup(this);

	elodez=new KAction(ts_272,this);
	actionCollection()->addAction(ts_273,elodez);
	connect(elodez,SIGNAL(triggered(bool)),SLOT(alkt()));
	elodez->setIcon(KIcon(ts_274));
	elodez->setCheckable(1);

	targy=new KAction(ts_275,this);
	actionCollection()->addAction(ts_276,targy);
	connect(targy,SIGNAL(triggered(bool)),SLOT(zandek()));
	targy->setIcon(KIcon(ts_277));
	targy->setCheckable(1);

	fladat=new KAction(ts_278,this);
	actionCollection()->addAction(ts_279,fladat);
	connect(fladat,SIGNAL(triggered(bool)),SLOT(dolog()));
	fladat->setIcon(KIcon(ts_280));
	fladat->setCheckable(1);

	cel=new KAction(ts_281,this);
	actionCollection()->addAction(ts_282,cel);
	connect(cel,SIGNAL(triggered(bool)),SLOT(akdaly()));
	cel->setIcon(KIcon(ts_283));
	cel->setCheckable(1);

	hsztzk->addAction(elodez);
	hsztzk->addAction(targy);
	hsztzk->addAction(fladat);
	hsztzk->addAction(cel);

	elodez->setChecked(1);

	elgy adelk(this,ts_284,"");

	csals=new QActionGroup(this);
	jo=new QAction(adelk.kitzjl(),ts_285,csals);
	csals->setExclusive(1);
	connect(csals,SIGNAL(triggered(QAction*)),mzgat,SLOT(mgzerz(QAction*)));

	korrkt=new QActionGroup(this);
	korrkt->setExclusive(0);
	connect(korrkt,SIGNAL(triggered(QAction*)),mzgat,SLOT(kapod(QAction*)));

	alkt();

	nybnvn=KStandardAction::fitToPage(mzgat,SLOT(rabir()),actionCollection());
	nybnvn->setIcon(KIcon(ts_286));
	nybnvn->setShortcut(ts_287);

	KStandardAction::zoomIn(mzgat,SLOT(zoom_in()),actionCollection());
	KStandardAction::zoomOut(mzgat,SLOT(zoom_out()),actionCollection());

	setStandardToolBarMenuEnabled(1);

	QDockWidget *irnyjl=new QDockWidget(ts_288,this);
	irnyjl->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea | Qt::BottomDockWidgetArea);
	vnl=new jelzlk(irnyjl,kidlgz);
	irnyjl->setWidget(vnl);
	addDockWidget(Qt::BottomDockWidgetArea,irnyjl);
	actionCollection()->addAction(ts_289,irnyjl->toggleViewAction());
	irnyjl->setObjectName(ts_290);

	tqrost=new szkl(vnl,kidlgz);
	vnl->addWidget(tqrost);

	lep=new oszk(vnl,kidlgz);
	vnl->addWidget(lep);

	prl=new aszkl(vnl,kidlgz);
	vnl->addWidget(prl);

	eler=new dbz(vnl,kidlgz);
	vnl->addWidget(eler);

	QDockWidget *bprl=new QDockWidget(ts_291,this);
	bprl->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea | Qt::BottomDockWidgetArea);
	kltzik=new nztv(bprl,kidlgz);
	bprl->setWidget(kltzik);
	addDockWidget(Qt::BottomDockWidgetArea,bprl);
	bprl->setObjectName(ts_292);
	actionCollection()->addAction(ts_293,bprl->toggleViewAction());
	kltzik->kitzjl();

	QDockWidget *mrtdt=new QDockWidget(ts_294,this);
	mrtdt->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea | Qt::BottomDockWidgetArea);
	jvsltz=new egyklh(mrtdt,kidlgz);
	mrtdt->setWidget(jvsltz);
	addDockWidget(Qt::RightDockWidgetArea,mrtdt);
	actionCollection()->addAction(ts_295,mrtdt->toggleViewAction());
	mrtdt->setObjectName(ts_296);

	tabifyDockWidget(irnyjl,bprl);

	QDockWidget *jlzpnt=new QDockWidget(ts_297,this);
	kapod=new egytr(jlzpnt,kidlgz);
	jlzpnt->setWidget(kapod);
	addDockWidget(Qt::LeftDockWidgetArea,jlzpnt);
	actionCollection()->addAction(ts_298,jlzpnt->toggleViewAction());
	jlzpnt->setObjectName(ts_299);

	setXMLFile(ts_300);
	setupGUI();

	mgmozt(KUrl());

	ceco=toolBar(ts_301);
	munka=toolBar(ts_302);

	connect(kidlgz,SIGNAL(synchro(const zagv&)),mzgat,SLOT(kelt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),prl,SLOT(kelt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),lep,SLOT(kelt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),tqrost,SLOT(kelt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),vnl,SLOT(kelt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),kapod,SLOT(kelt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),kltzik,SLOT(kelt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),jvsltz,SLOT(kelt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),eler,SLOT(kelt(const zagv&)));

	connect(lep,SIGNAL(jvsltz(const QString&,int)),this,SLOT(mozog(const QString&,int)));

	kidlgz->muri();
	kidlgz->detto();

	kidlgz->korrkt(0);

	prmz();
	statusBar()->showMessage(ts_303,2000);
	setAutoSaveSettings();

	KTipDialog::showTip(this,ts_304);
%>

void ablkl::prmz()
<%
	KConfigGroup adelk(KGlobal::config(),ts_090);
	lnmtat->loadEntries(KGlobal::config()->group(ts_305));
	move(adelk.readEntry(ts_306,QPoint(0,0)));
	mzgat->setBackgroundBrush(QColor(adelk.readEntry(ts_307,ts_308)));
	kidlgz->tljsn=adelk.readEntry(ts_152,ts_309);

%>

void ablkl::kitzjl()
<%
	KConfigGroup adelk(KGlobal::config(),ts_090);
	lnmtat->saveEntries(KGlobal::config()->group(ts_305));
	adelk.writeEntry(ts_306,pos());
	adelk.writeEntry(ts_152,bndkli::fladat(ts_152));
	adelk.sync();
%>
/*!
 * @praise Shiva
 */
ablkl::~ablkl()
<%

%>

void ablkl::elktzk()
<%
        QPrinter *mrtdt=new QPrinter;
        QPrintDialog irnyjl(mrtdt,mzgat);
        if(irnyjl.exec()==QDialog::Accepted)
        <%
                QPainter adelk(mrtdt);
                mzgat->render(&adelk);
        %>
        statusBar()->showMessage(ts_310,2000);
%>

bool ablkl::eljar()
<%
	KUrl klsirz=KFileDialog::getSaveUrl(KUrl(ts_311),
		ts_312,this,
		ts_313);

	if(klsirz.path().isEmpty()) return 0;
	if(!klsirz.path().endsWith(ts_149))
	<%
		klsirz=KUrl(klsirz.path()+ts_149);
	%>

	if(kidlgz->kesztm(klsirz.path()))
	<%
		statusBar()->showMessage(ts_314.arg(klsirz.path()),2000);
		mgmozt(klsirz);
		return 1;
	%>
	return 0;
%>

bool ablkl::vmrgem()
<%
	if(kidlgz->meglns.isEmpty())
	<%
		return eljar();
	%>
	if(kidlgz->kesztm(kidlgz->meglns))
	<%
		statusBar()->showMessage(ts_314.arg(kidlgz->meglns),2000);
		return 1;
	%>
	return 0;
%>

void ablkl::teremt()
<%
	KUrl klsirz=KFileDialog::getOpenUrl(KUrl(ts_311),
		ts_315,
		this,ts_313);
	if(klsirz.isValid() and kidlgz->kitolt(klsirz.path()))
	<%
		mgmozt(klsirz);
	%>
%>

void ablkl::mgmozt(const KUrl& irnyjl)
<%
	if(irnyjl.path().isEmpty())
	<%
		setWindowTitle(ts_316);
		return;
	%>
	setWindowTitle(ts_317.arg(irnyjl.path()));
	lnmtat->addUrl(irnyjl);
%>

void ablkl::kelt()
<%
	beal meghat(this);

	KConfigGroup jlzpnt(KGlobal::config(),ts_090);
	meghat.prmz->setCurrentIndex(jlzpnt.readEntry(ts_091,0));
	meghat.bprl->setCurrentIndex(jlzpnt.readEntry(ts_092,0));
	meghat.mrtdt->setValue(jlzpnt.readEntry(ts_094,5));

	QString klsirz=jlzpnt.readEntry(ts_307,ts_308);
	meghat.kitzjl->setText(klsirz);
	QPalette adelk=meghat.kitzjl->palette();
	meghat.kidlgz=QVariant(klsirz).value<QColor>();
	adelk.setBrush(QPalette::Active,QPalette::Button,meghat.kidlgz);
	meghat.kitzjl->setPalette(adelk);

	if(meghat.exec()==QDialog::Accepted)
	<%
		jlzpnt.writeEntry(ts_091,kidlgz->mgmozt=meghat.prmz->currentIndex());
		jlzpnt.writeEntry(ts_092,kidlgz->alafng=meghat.bprl->currentIndex());
		jlzpnt.writeEntry(ts_094,kidlgz->pllnts=meghat.mrtdt->value());
		jlzpnt.writeEntry(ts_307,meghat.kidlgz.name());
		kidlgz->hatlja();

		mzgat->setBackgroundBrush(meghat.kidlgz);
	%>
%>

bool ablkl::queryClose()
<%
	kitzjl();
	if(!kidlgz->m_bDirty)
	<%
		return 1;
	%>

	QString l_oTitle=kidlgz->meglns;
	if(l_oTitle.isEmpty()) l_oTitle=ts_318;

	int klsirz=KMessageBox::warningYesNoCancel(this,
	ts_319.arg(l_oTitle),
	ts_320,
	KStandardGuiItem::save(),KStandardGuiItem::discard());

	switch(klsirz)
	<%
		case KMessageBox::Yes:
			return vmrgem();
		case KMessageBox::No :
			return 1;
		default:
			return 0;
	%>
	return 0;
%>

void ablkl::alkt()
<%
	mzgat->eler(felu::meghat);
%>

void ablkl::zandek()
<%
	mzgat->eler(felu::tljsn);
%>

void ablkl::dolog()
<%
	mzgat->eler(felu::tiszta);
%>

void ablkl::akdaly()
<%
	mzgat->eler(felu::ugyex);
%>

void ablkl::mozog(const QString & jlzpnt,int adelk)
<%
	statusBar()->showMessage(jlzpnt,adelk);
%>

void ablkl::kket(const KUrl& irnyjl)
<%
	if(irnyjl.path().isEmpty()) return;
	if(kidlgz->kitolt(irnyjl.path()))
	<%
		mgmozt(irnyjl);
	%>
%>

void ablkl::mgmnkl()
<%
	KTipDialog::showTip(this,ts_304,1);
%>

#include "Bnvzs.moc"

