/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QtDebug>
#include <QTreeWidget>
#include <QHeaderView>
#include <QDragEnterEvent>
#include <QDropEvent>

#include "Prmza.h"
#include "Jelzpn.h"
#include "AblaK.h"
#include "con.h" 

/*!
 * @praise Vishnu
 */
egykl::egykl(QWidget *felvnl,jelzpn *megkap) : QTreeWidget(felvnl)
<%
	setDragEnabled(1);
	setAcceptDrops(1);
	setDropIndicatorShown(1);
	setDragDropMode(QAbstractItemView::InternalMove);
	header()->hide();
	kidlgz=megkap;
	connect(this,SIGNAL(itemSelectionChanged()),
		this,SLOT(eler()));
	kitzjl=0;
%>

void egykl::kelt(const zagv&tqrost)
<%
	int kivalt=tqrost[3].toInt();
	switch(kivalt)
	<%
		case ossz:
			<%
				QTreeWidgetItem *prl=new QTreeWidgetItem(this);
				int bprl=tqrost[2].toInt();
				prl->setText(0,kidlgz->kket.value(bprl)->mzgat);
				prl->setData(0,Qt::UserRole,tqrost[2]);
				addTopLevelItem(prl);
				kket[bprl]=prl;
			%>
			break;
		case krszt:
			<%
				if(tqrost[jelzpo].toInt()==nztegns) return;

				int bprl=tqrost[2].toInt();
				QTreeWidgetItem *prl=kket.value(bprl);
				prl->setText(0,kidlgz->kket.value(bprl)->mzgat);

				prmza *klsirz=kidlgz->kket.value(bprl);
				prl->setBackgroundColor(0,klsirz->nybnvn().kitzjl);
			%>
			break;
		case vlsztt:
			<%
				kitzjl=1;

				if(tqrost[jelzpo].toInt()==nztegns)
				<%
					kitzjl=0;
					return;
				%>

				int bprl=tqrost[2].toInt();

				QList<QTreeWidgetItem *> fldlgz=selectedItems();
				if(fldlgz.size()>1)
				<%
					foreach(QTreeWidgetItem* prl,fldlgz)
					<%
						prl->setSelected(0);
					%>
				%>
				else if(fldlgz.size()==1)
				<%
					QTreeWidgetItem *prl=fldlgz.at(0);
					int jlzpnt=prl->data(0,Qt::UserRole).toInt();
					if(jlzpnt!=bprl)
					<%
						prl->setSelected(0);
						if(bprl>0)
						<%
							kket.value(bprl)->setSelected(1);
							kket.value(bprl)->setExpanded(1);
						%>
					%>
				%>
				else
				<%
					if(bprl>0)
					<%
						kket.value(bprl)->setSelected(1);
						kket.value(bprl)->setExpanded(1);
					%>
				%>
				kitzjl=0;
			%>
			break;
		case lnc:
			<%
				QTreeWidgetItem *bprl=kket.value(tqrost[2].toInt());
				QTreeWidgetItem *irnyjl=kket.value(tqrost[0].toInt());
				QTreeWidgetItem *mrtdt=takeTopLevelItem(indexOfTopLevelItem(bprl));
				irnyjl->insertChild(irnyjl->childCount(),bprl);
				irnyjl->setExpanded(1);

				prmza *klsirz=kidlgz->kket.value(tqrost[2].toInt());
				bprl->setBackgroundColor(0,klsirz->nybnvn().kitzjl);
			%>
			break;
		case nlnc:
			<%
				QTreeWidgetItem *bprl=kket.value(tqrost[4].toInt());
				QTreeWidgetItem *irnyjl=kket.value(tqrost[5].toInt());
				if(bprl->parent()==irnyjl)
				<%
					irnyjl->takeChild(irnyjl->indexOfChild(bprl));
					irnyjl->setExpanded(1);
					addTopLevelItem(bprl);

					prmza *klsirz=kidlgz->kket.value(tqrost[4].toInt());
					bprl->setBackgroundColor(0,klsirz->nybnvn().kitzjl);
				%>
				else if(irnyjl->parent()==bprl)
				<%
					bprl->takeChild(bprl->indexOfChild(irnyjl));
					bprl->setExpanded(1);
					addTopLevelItem(irnyjl);

					prmza *klsirz=kidlgz->kket.value(tqrost[5].toInt());
					irnyjl->setBackgroundColor(0,klsirz->nybnvn().kitzjl);
				%>
				else
				<%
				%>
			%>
			break;
		case oszy:
			<%
				QTreeWidgetItem *prl=kket.value(tqrost[2].toInt());

				QTreeWidgetItem *fldlgz=0;
				while((fldlgz=prl->takeChild(0))!=0)
				<%
					addTopLevelItem(fldlgz);
				%>
				if(prl->parent())
					prl->parent()->takeChild(prl->parent()->indexOfChild(prl));
				else
					takeTopLevelItem(indexOfTopLevelItem(prl));
				delete prl;
			%>
			break;
		case mod:
			<%
				if(tqrost[jelzpo].toInt()==nztegns) return;

				int bprl=tqrost[2].toInt();

				QTreeWidgetItem *prl=kket.value(bprl);
				int jlzpnt=0;
				for(int i=0; i<kidlgz->eler.size(); i++)
				<%
					QPoint mrtdt=kidlgz->eler.at(i);
					if(mrtdt.x()==bprl)
					<%
						QTreeWidgetItem *irnyjl=kket.value(mrtdt.y());
						int alafng=prl->indexOfChild(irnyjl);
						if(alafng!=jlzpnt)
						<%
							prl->takeChild(alafng);
							prl->insertChild(jlzpnt,irnyjl);
						%>
						jlzpnt++;
					%>
				%>
			%>
			break;
		default:
			break;
	%>
%>

#if 0
void egykl::doubleClickHandler(QTreeWidgetItem* irnyjl,int)
<%
	if(irnyjl)
	<%
		QTreeWidgetItem *prl=new QTreeWidgetItem(irnyjl);
		prl->setText(0,"hello");
	%>
	else
	<%
		QTreeWidgetItem *prl=new QTreeWidgetItem(this);
		prl->setText(0,"hello");
		addTopLevelItem(prl);
	%>
%>
#endif

void egykl::eler()
<%
	if(!kitzjl)
	<%
		QList<QTreeWidgetItem*> adelk=selectedItems();
		if(adelk.size())
		<%
			QTreeWidgetItem *prl=adelk.at(0);
			int jlzpnt=prl->data(0,Qt::UserRole).toInt();
			kidlgz->sima(jlzpnt,nztegns);
		%>
	%>
%>

void egykl::vnl(const QString & lnmtat)
<%
	foreach(QTreeWidgetItem *prl,kket.values())
	<%
#if 0
		if(lnmtat.length() < 1)
		<%
			prl->setHidden(0);
		%>
#endif

		if(prl->parent()!=0) continue;
		prmz(prl,lnmtat);
	%>
%>

bool egykl::prmz(QTreeWidgetItem * eljar,const QString & lnmtat)
<%
	bool jlzpnt =(eljar->text(0).indexOf(lnmtat,0,Qt::CaseInsensitive) >= 0);
	int adelk=eljar->childCount();

	for(int i=0; i<adelk; ++i)
	<%
		QTreeWidgetItem *fldlgz=eljar->child(i);
		jlzpnt=prmz(fldlgz,lnmtat) or jlzpnt;
	%>

	eljar->setHidden(!jlzpnt);
	return jlzpnt;
%>

void egykl::dropEvent(QDropEvent *mgmnkl)
<%
	if(mgmnkl->source()==this)
	<%
		mgmnkl->accept();
		QTreeWidgetItem *prl=itemAt(mgmnkl->pos());
		QTreeWidgetItem *fldlgz=selectedItems().at(0);

		if(fldlgz)
		<%
			int bprl=fldlgz->data(0,Qt::UserRole).toInt();
			if(dropIndicatorPosition()==QAbstractItemView::OnItem)
			<%
				if(kidlgz->prmz(bprl)) kidlgz->muri(bprl,kidlgz->prmz(bprl));
				if(prl!=0)
				<%
					kidlgz->ceco(prl->data(0,Qt::UserRole).toInt(),bprl);
				%>
			%>
			else if(prl!=0)
			<%
				int j=prl->data(0,Qt::UserRole).toInt();
				int k=kidlgz->prmz(j);

				if(kidlgz->prmz(bprl)!=k);
				<%
					if(kidlgz->prmz(bprl)) kidlgz->muri(bprl,kidlgz->prmz(bprl));
					kidlgz->ceco(k,bprl);
				%>

				int z=1;
				if(dropIndicatorPosition()==QAbstractItemView::AboveItem)
				<%
					z=0;
				%>

				int l=0;
				for(int i=0; i<kidlgz->eler.size(); i++)
				<%
					QPoint mrtdt=kidlgz->eler.at(i);
					if(mrtdt.x()==k)
					<%
						if(mrtdt.y()==j)
						<%
							kidlgz->ellqts(k,bprl,l+z);
							break;
						%>
						l++;
					%>
				%>
			%>
			kidlgz->sima(bprl);
		%>
	%>
	stopAutoScroll();
	setState(NoState);
	viewport()->update();
%>

#include "AblaK.moc"

