%define type targeted
Summary: SELinux %{type} policy configuration
Name: selinux-policy-%{type}
Version: 1.18
Release: 1
License: GPL
Group: System Environment/Base
Source: http://www.nsa.gov/selinux/archives/policy-%{version}.tgz
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-buildroot

BuildArch: noarch
BuildRequires: checkpolicy m4 policycoreutils
BuildRequires: python
Obsoletes: policy

%description
Security-enhanced Linux is a patch of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

This package contains the SELinux example policy configuration along
with the Flask configuration information and the application
configuration files.  

%prep
%setup -q -n policy-%{version}
sed "s/strict/targeted/" Makefile > Makefile.new
mv Makefile.new Makefile

%build
mv domains/misc/*.te domains/misc/unused
mv domains/program/*.te domains/program/unused/
rm domains/*.te
for i in nscd.te apache.te ypbind.te mailman.te dhcpd.te named.te  ntpd.te  portmap.te snmpd.te squid.te syslogd.te; do
mv domains/program/unused/$i domains/program/
done
rm -rf domains/program/unused
rm -rf domains/misc/used
cp -R %{type}/* .
echo "define(\`targeted_policy')"  > tunables/tunable.tun
echo "define(\`nscd_all_connect')"  >> tunables/tunable.tun
make policy

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/root
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/selinux/%{type}/contexts/users
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/selinux/%{type}/contexts/files
make DESTDIR="${RPM_BUILD_ROOT}" install
make clean
make DESTDIR="${RPM_BUILD_ROOT}" install-src
rm -rf "${RPM_BUILD_ROOT}%{_sysconfdir}/selinux/%{type}/src/policy/targeted"
rm -rf "${RPM_BUILD_ROOT}%{_sysconfdir}/selinux/%{type}/src/policy"/*.spec
touch ${RPM_BUILD_ROOT}%{_sysconfdir}/selinux/%{type}/src/policy/policy.conf
touch ${RPM_BUILD_ROOT}%{_sysconfdir}/selinux/config

%clean
rm -rf ${RPM_BUILD_ROOT}

%files 
%defattr(-,root,root)
%dir %{_sysconfdir}/selinux
%ghost %config(noreplace) %{_sysconfdir}/selinux/config
%dir %{_sysconfdir}/selinux/%{type}
%dir %{_sysconfdir}/selinux/%{type}/policy
%dir %{_sysconfdir}/selinux/%{type}/contexts
%dir %{_sysconfdir}/selinux/%{type}/contexts/files
%dir %{_sysconfdir}/selinux/%{type}/contexts/users
%config(noreplace) %{_sysconfdir}/selinux/%{type}/policy/policy\.*
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/files/file_contexts
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/files/media
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/default_contexts
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/default_type
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/initrc_context
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/failsafe_context
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/removable_context
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/dbus_contexts
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/userhelper_context
%config(noreplace) %{_sysconfdir}/selinux/%{type}/contexts/users/root

%post
if [ ! -s /etc/selinux/config ]; then
	if [ -s /etc/sysconfig/selinux ]; then 
		#
		#	Previous install of FC2 so we will default 
		#       to strict policy
		#
		mv /etc/sysconfig/selinux /etc/selinux/config
		echo "
# SELINUXTYPE= can take one of these two values:
#	targeted - Only targeted network daemons are protected.
#	strict - Full SELinux protection.
SELINUXTYPE=strict " >> /etc/selinux/config
		rm -f /etc/sysconfig/selinux
	else
		#
		#	New install so we will default to targeted policy
		#
		echo "
# This file controls the state of SELinux on the system.
# SELINUX= can take one of these three values:
#	enforcing - SELinux security policy is enforced.
#	permissive - SELinux prints warnings instead of enforcing.
#	disabled - No SELinux policy is loaded.
SELINUX=enforcing
# SELINUXTYPE= can take one of these two values:
#	targeted - Only targeted network daemons are protected.
#	strict - Full SELinux protection.
SELINUXTYPE=targeted " > /etc/selinux/config

	fi
fi
ln -sf /etc/selinux/config /etc/sysconfig/selinux 
restorecon /etc/selinux/config 2> /dev/null

if [ -x /usr/bin/selinuxenabled ] && /usr/bin/selinuxenabled && [ -e /selinux/policyvers ]; then
	. /etc/selinux/config
	if [ "${SELINUXTYPE}" = "%{type}" ]; then 
		/usr/sbin/load_policy /etc/selinux/%{type}/policy/policy.`cat /selinux/policyvers`
	fi
fi
exit 0

%package sources
Summary: SELinux example policy configuration source files 
Group: System Environment/Base
Requires: m4 make checkpolicy policycoreutils kernel 
Requires: selinux-policy-%{type} = %{version}-%{release}
Requires: python
BuildRequires: checkpolicy policycoreutils
Obsoletes: policy-sources

%description sources
This subpackage includes the source files used to build the policy
configuration.  Includes policy.conf and the Makefiles, macros and
source files for it.

%files sources
%defattr(0600,root,root,0700)
%config(noreplace) %{_sysconfdir}/selinux/%{type}/src/policy/users
%dir %{_sysconfdir}/selinux/%{type}/src/policy/tunables
%config %{_sysconfdir}/selinux/%{type}/src/policy/tunables/*.tun
%dir %{_sysconfdir}/selinux/%{type}/src
%dir %{_sysconfdir}/selinux/%{type}/src/policy
%{_sysconfdir}/selinux/%{type}/src/policy/ChangeLog
%{_sysconfdir}/selinux/%{type}/src/policy/COPYING
%{_sysconfdir}/selinux/%{type}/src/policy/Makefile
%{_sysconfdir}/selinux/%{type}/src/policy/README
%{_sysconfdir}/selinux/%{type}/src/policy/VERSION
%dir %{_sysconfdir}/selinux/%{type}/src/policy/appconfig
%config %{_sysconfdir}/selinux/%{type}/src/policy/appconfig/*
%config %{_sysconfdir}/selinux/%{type}/src/policy/assert.te
%config %{_sysconfdir}/selinux/%{type}/src/policy/attrib.te
%config %{_sysconfdir}/selinux/%{type}/src/policy/constraints
%dir %{_sysconfdir}/selinux/%{type}/src/policy/domains
%config %{_sysconfdir}/selinux/%{type}/src/policy/domains/*
%dir %{_sysconfdir}/selinux/%{type}/src/policy/file_contexts
%config %{_sysconfdir}/selinux/%{type}/src/policy/file_contexts/*
%dir %{_sysconfdir}/selinux/%{type}/src/policy/flask
%config %{_sysconfdir}/selinux/%{type}/src/policy/flask/*
%config %{_sysconfdir}/selinux/%{type}/src/policy/fs_use
%config %{_sysconfdir}/selinux/%{type}/src/policy/genfs_contexts
%config %{_sysconfdir}/selinux/%{type}/src/policy/initial_sid_contexts
%dir %{_sysconfdir}/selinux/%{type}/src/policy/macros
%config %{_sysconfdir}/selinux/%{type}/src/policy/macros/*
%config %{_sysconfdir}/selinux/%{type}/src/policy/mls
%config %{_sysconfdir}/selinux/%{type}/src/policy/net_contexts
%config %{_sysconfdir}/selinux/%{type}/src/policy/rbac
%config %{_sysconfdir}/selinux/%{type}/src/policy/serviceusers
%dir %{_sysconfdir}/selinux/%{type}/src/policy/types
%config %{_sysconfdir}/selinux/%{type}/src/policy/types/*
%ghost %{_sysconfdir}/selinux/%{type}/src/policy/policy.conf
%ghost %{_sysconfdir}/selinux/%{type}/src/policy/tmp

%post sources
if [ -x /usr/bin/selinuxenabled ]; then 
   make -W /etc/selinux/%{type}/src/policy/users \
        -C /etc/selinux/%{type}/src/policy > /dev/null 2>&1
   if [ -f /etc/selinux/config ]; then
	. /etc/selinux/config
	if [ "${SELINUXTYPE}" = "%{type}" ]; then 
	   /usr/bin/selinuxenabled && [ -e /selinux/policyvers ] && \
	   make -C /etc/selinux/%{type}/src/policy load 
	fi
   fi
fi
exit 0

%changelog

