/*  selectwm - X11 window manager selector
 *
 *  Copyright (C) 1999-2003  Luc Dufresne - luc@ordiluc.net
 *                           26, rue des Comices
 *                           59650 Villeneuve d'Ascq
 *                           FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include "define.h"

#include <gtk/gtk.h>

#include "misc.h"
#include "modify.h"
#include "miscui.h"

static struct  WM {
	gchar *name;
	gchar *command;
} wm [] = {
	{"Gnome", "gnome-session"},
	{"kde", "startkde"},
	{"Window Maker", "wmaker"},
	{"Enlightenment", "enlightenment"},
	{"Blackbox", "blackbox"},
	{"xfce", "xfwm"},
	{"Sawfish", "sawfish"},
	{"Fluxbox", "fluxbox"},
	{"Icewm", "icewm"},
	{"fvwm", "fvwm"},
	{"mwm", "mwm"},
	{"mlvwm", "mlvwm"},
	{"Afterstep", "afterstep"},
	{"ctwm", "ctwm"},
	{"flwm", "flwm"},
	{"pwm", "pwm"},
	{"vtwm", "vtwm"},
	{"twm", "twm"},
	{"xterm", "xterm"},
	{"rxvt", "rxvt"},
	{"", ""}
};

static gchar * path [] = {
	"/usr/local/bin/",
	"/usr/bin/X11/",
	"/usr/bin/",
	""
};

enum
{
  COLUMN_CMD,
  COLUMN_DESC,
  COLUMN_EDITABLE,
  NUM_COLUMNS
};

static void add_wms (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data) {
	gchar *cmd, *dsc;	
	config *selectwm_config = (config *) data;
	
	gtk_tree_model_get (model, iter, COLUMN_CMD, &cmd,COLUMN_DESC, &dsc , -1);
	insert_item (selectwm_config, cmd, dsc);
	g_free (cmd);
	g_free (dsc);
}

static void add_columns (GtkTreeView *treeview) {
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeModel *model = gtk_tree_view_get_model (treeview);

	renderer = gtk_cell_renderer_text_new ();
	g_signal_connect (G_OBJECT (renderer), "edited", G_CALLBACK (cell_edited), model);
	column = gtk_tree_view_column_new_with_attributes (_("Command"), renderer, "text", COLUMN_CMD, "editable", COLUMN_EDITABLE, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gint *) COLUMN_CMD);
	gtk_tree_view_append_column (treeview, column);

	renderer = gtk_cell_renderer_text_new ();
	g_signal_connect (G_OBJECT (renderer), "edited", G_CALLBACK (cell_edited), model);
	column = gtk_tree_view_column_new_with_attributes (_("Description"), renderer, "text", COLUMN_DESC, "editable", COLUMN_EDITABLE, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gint *) COLUMN_DESC);
	gtk_tree_view_append_column (treeview, column);
}

static GtkTreeModel * create_model (void) {
	GtkListStore *store;
	GtkTreeIter iter;
	gint i, j;
	GString *command;

	store = gtk_list_store_new (NUM_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	i = 0;
	while (wm[i].command != "") {
		j = 0;
		while (path[j] != "") {
			command = g_string_new ("");
			g_string_printf (command, "%s%s", path[j], wm[i].command);
			if (g_file_test (command->str, G_FILE_TEST_IS_EXECUTABLE)) {
				gtk_list_store_append (store, &iter);
				gtk_list_store_set (store, &iter, COLUMN_CMD, command->str, COLUMN_DESC, wm[i].name, COLUMN_EDITABLE, TRUE, -1);
			}
			g_string_free (command, TRUE);
			j++;
		}
		i++;
	}

	return GTK_TREE_MODEL (store);
}

void find_wm (config *selectwm_config) {
	GtkWidget *treeview, *sw, *find_window;
	GtkTreeModel *model;
	
	model = create_model ();
	
	find_window = gtk_dialog_new_with_buttons (_("Window Managers found"), NULL, GTK_DIALOG_MODAL, GTK_STOCK_ADD, GTK_RESPONSE_OK, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);
	gtk_window_set_position (GTK_WINDOW (find_window), GTK_WIN_POS_MOUSE);

	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw), GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (find_window)->vbox), sw, TRUE, TRUE, 0);
	
	treeview = gtk_tree_view_new_with_model (model);
	gtk_widget_set_size_request (treeview, 350, 200);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
	gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)), GTK_SELECTION_MULTIPLE);
	add_columns (GTK_TREE_VIEW (treeview));
	gtk_tree_selection_select_all (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)));
	
	g_object_unref (G_OBJECT (model));
	gtk_container_add (GTK_CONTAINER (sw), treeview);

	gtk_widget_show_all (find_window);	
	if (GTK_RESPONSE_OK == gtk_dialog_run (GTK_DIALOG (find_window))) {
		gtk_tree_selection_selected_foreach (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)), add_wms, selectwm_config);
	}

	gtk_widget_destroy (find_window);
}
