/*
                             SAR Menu Codes

	Menu Names and Operation codes
 */

#ifndef SARMENUCODES_H
#define SARMENUCODES_H


/*
 *      Menu names:
 */
#define SAR_MENU_NAME_MAIN                      "Main"

#define SAR_MENU_NAME_FREE_FLIGHT               "Free Flight"
#define SAR_MENU_NAME_FREE_FLIGHT_AIRCRAFT      "Free Flight Aircraft"
#define SAR_MENU_NAME_FREE_FLIGHT_WEATHER       "Free Flight Weather"
#define SAR_MENU_NAME_FREE_FLIGHT_AIRCRAFT_INFO "Free Flight Aircraft Info"

#define SAR_MENU_NAME_MISSION                   "Mission"
#define SAR_MENU_NAME_MISSION_BRIEF             "Mission Brief"
#define SAR_MENU_NAME_MISSION_MAP               "Mission Map"
#define SAR_MENU_NAME_MISSION_LOG_MAP           "Mission Log Map"

#define SAR_MENU_NAME_CAMPAIGN                  "Campaign"

#define SAR_MENU_NAME_OPTIONS                   "Options"
#define SAR_MENU_NAME_OPTIONS_SIMULATION        "Options Simulation"
#define SAR_MENU_NAME_OPTIONS_CONTROLLER        "Options Controler"
#define SAR_MENU_NAME_OPTIONS_CONTROLLER_JS_BTN "Options Controler JS Buttons"
#define SAR_MENU_NAME_OPTIONS_CONTROLLER_TEST	"Options Controler Test"
#define SAR_MENU_NAME_OPTIONS_GRAPHICS          "Options Graphics"
#define SAR_MENU_NAME_OPTIONS_GRAPHICS_INFO     "Options Graphics Info"
#define SAR_MENU_NAME_OPTIONS_SOUND             "Options Sound"
#define SAR_MENU_NAME_OPTIONS_SOUND_INFO        "Options Sound Info"

#define SAR_MENU_NAME_LOADING_SIMULATION        "Loading Simulation"


/*
 *	Operation codes:
 *
 *	ID codes for menu objects (buttons, switch, spin, sliders etc).
 */
#define SAR_OP_MENU_TO_MAIN		0
#define SAR_OP_MENU_EXIT		1

#define SAR_OP_MENU_TO_MISSION		10
#define SAR_OP_MENU_TO_CAMPAIGN		11
#define SAR_OP_MENU_TO_FREE_FLIGHT      12
#define SAR_OP_MENU_TO_OPTIONS		13

#define SAR_OP_MISSION_LIST_SELECT		20
#define SAR_OP_MISSION_BRIEF_MESG		21
#define SAR_OP_MENU_TO_MISSION_BRIEF		22
#define SAR_OP_MENU_TO_MISSION_BEGIN		23
#define SAR_OP_MENU_TO_MISSION_MAP		24
#define SAR_OP_MENU_TO_MISSION_LOG_MAP		25	/* View last log. */
#define SAR_OP_MISSION_MAP_LEFT			26
#define SAR_OP_MISSION_MAP_RIGHT		27
#define SAR_OP_MISSION_MAP_UP			28
#define SAR_OP_MISSION_MAP_DOWN			29
#define SAR_OP_MISSION_MAP_ZOOM_IN		30
#define SAR_OP_MISSION_MAP_ZOOM_OUT		31
#define SAR_OP_MISSION_LOG_MAP_LEFT		32
#define SAR_OP_MISSION_LOG_MAP_RIGHT		33
#define SAR_OP_MISSION_LOG_MAP_UP		34
#define SAR_OP_MISSION_LOG_MAP_DOWN		35
#define SAR_OP_MISSION_LOG_MAP_ZOOM_IN		36
#define SAR_OP_MISSION_LOG_MAP_ZOOM_OUT		37
#define SAR_OP_MISSION_LOG_MAP_EVENT_NEXT	38
#define SAR_OP_MISSION_LOG_MAP_EVENT_PREV	39

#define SAR_OP_FREE_FLIGHT_SCENERY_LIST		50
#define SAR_OP_FREE_FLIGHT_LOCATIONS_LIST	51
#define SAR_OP_FREE_FLIGHT_AIRCRAFTS_LIST	52
#define SAR_OP_MENU_TO_FREE_FLIGHT_AIRCRAFT	53
#define SAR_OP_MENU_TO_FREE_FLIGHT_BEGIN	54
#define SAR_OP_MENU_TO_FREE_FLIGHT_WEATHER	55
#define SAR_OP_MENU_TO_FREE_FLIGHT_AIRCRAFT_INFO	56

#define SAR_OP_MENU_FREE_FLIGHT_WEATHER_CONDITION	60
#define SAR_OP_MENU_FREE_FLIGHT_SYSTEM_TIME		61

#define SAR_OP_MENU_TO_OPTIONS_SIMULATION		100
#define SAR_OP_MENU_TO_OPTIONS_CONTROLLER		110
#define SAR_OP_MENU_TO_OPTIONS_CONTROLLER_JS_BTN	111
#define SAR_OP_MENU_TO_OPTIONS_CONTROLLER_TEST		112
#define SAR_OP_MENU_TO_OPTIONS_GRAPHICS			120
#define SAR_OP_MENU_TO_OPTIONS_GRAPHICS_INFO		121
#define SAR_OP_GRAPHICS_INFO_MESG			122
#define SAR_OP_MENU_TO_OPTIONS_SOUND			130
#define SAR_OP_MENU_TO_OPTIONS_SOUND_INFO		131
#define SAR_OP_SOUND_INFO_MESG				132

/* Test menu operation, used for debugging purposes. */
#define SAR_OP_TEST				9999

/*
 *	ID codes for options menu objects, these should not conflict
 *	with any of the SAR_OP_MENU_* codes).
 */
#define SAR_OPT_SELECT_HOIST_CONTACT		510	/* Spin */
#define SAR_OPT_SELECT_DAMAGE_RESISTANCE	511	/* Spin */
#define SAR_OPT_SELECT_FLIGHT_PHYSICS		512	/* Spin */

#define SAR_OPT_SELECT_JS0_CONNECTION		520	/* Spin */
#define SAR_OPT_SELECT_JS1_CONNECTION		521	/* Spin */
#define SAR_OPT_SELECT_JS0_AXISES		522	/* Spin */
#define SAR_OPT_SELECT_JS1_AXISES		523	/* Spin */
#define SAR_OPT_SELECT_JS_PRIORITY		524	/* Spin */
#define SAR_OPT_SELECT_JS0_BUTTON_ACTION	530	/* Spin */
#define SAR_OPT_SELECT_JS0_BUTTON_NUMBER	531	/* Spin */
#define SAR_OPT_SELECT_JS1_BUTTON_ACTION	532	/* Spin */
#define SAR_OPT_SELECT_JS1_BUTTON_NUMBER	533	/* Spin */
#define SAR_OPT_CONTROLLER_REFRESH		534	/* Button */
#define SAR_OPT_UPDATE_JS_TEST			535	/* MDisplay */

#define SAR_OPT_SELECT_GROUND_TEXTURE		550	/* Switch */
#define SAR_OPT_SELECT_OBJECT_TEXTURE		551	/* Switch */
#define SAR_OPT_SELECT_CLOUDS			552	/* Switch */
#define SAR_OPT_SELECT_ATMOSPHERE               553	/* Switch */
#define SAR_OPT_SELECT_DUAL_PASS_DEPTH		554	/* Switch */
#define SAR_OPT_SELECT_PROP_WASH		555	/* Switch */
#define SAR_OPT_SELECT_SMOKE_TRAILS		556	/* Switch */
#define SAR_OPT_SELECT_CELESTIAL_OBJECTS	557	/* Switch */
#define SAR_OPT_SELECT_MAX_VISIBILITY		558	/* Spin */
#define SAR_OPT_ADJUST_GRAPHICS_ACCELERATION	559	/* Slider */
#define SAR_OPT_SELECT_RESOLUTION		560	/* Switch */
#define SAR_OPT_SELECT_FULLSCREEN		561	/* Spin */
#define SAR_OPT_GRAPHICS_INFO_SAVE		570	/* Button */

#define SAR_OPT_SELECT_SOUND_LEVEL		580	/* Spin */
#define SAR_OPT_SELECT_SOUND_PRIORITY		581	/* Spin */
#define SAR_OPT_SELECT_MUSIC			582	/* Switch */
#define SAR_OPT_ADJUST_MASTER_VOLUME		585	/* Slider */
#define SAR_OPT_ADJUST_SOUND_VOLUME		586	/* Slider */
#define SAR_OPT_ADJUST_MUSIC_VOLUME		587	/* Slider */
#define SAR_OPT_SOUND_TEST			590	/* Button */
#define SAR_OPT_SOUND_INFO_SAVE			591	/* Button */

#endif	/* SARMENUCODES_H */
