/*
	                   Scene & Object Drawing
 */

#ifndef SARDRAW_H
#define SARDRAW_H

#include "gw.h"
#include "obj.h"
#include "sar.h"

/*
 *	Drawing context:
 *
 *	This structure is passed around in the SARDraw*() functions
 *	starting from SARDraw() or SARDrawMap(), it contains values
 *	that other SARDraw*() functions can conviently obtain and
 *	modify while sharing with other SARDraw*() functions.
 */
typedef struct {

	sar_core_struct		*core_ptr;	/* Core */
	sar_option_struct	*option;	/* Options */
	sar_scene_struct	*scene;		/* Scene */
	sar_object_struct	**object;	/* Objects list */
	int			total_objects;
	gw_display_struct	*display;	/* Graphics wrapper */
	gctl_struct		*gctl;		/* Game controller */

	int	width,		/* Size of display in pixels */
		height;

	float	visibility_max;	/* Maximum clipping visibility, in meters */
	float	view_aspect;	/* Width / height (with aspect offset applied) */ 
	float	fovz_um;	/* Field of view unit meters, z axis */

	Boolean	camera_in_cockpit,	/* Camera in cockpit hint */
		ear_in_cockpit,		/* Ear in cockpit hint */
		ifr;			/* IFR (night vision) hint */

	int	camera_ref;		/* One of SAR_CAMERA_REF_* */

	sar_position_struct	camera_pos;
	sar_direction_struct	camera_dir;

	float	map_dxm,	/* Map view visible size in meters */
		map_dym;

	sar_position_struct	primary_light_pos;

	GLfloat			sky_color[3],
				atmosphere_color[3],
				light_color[3];	/* Scene light color */

	sar_cloud_layer_struct	*lowest_cloud_layer_ptr,
				*highest_cloud_layer_ptr;

	sar_object_struct	*player_obj_cockpit_ptr;

	int	player_flight_model_type,
		player_wheel_brakes;
	Boolean	player_air_brakes,
		player_autopilot,
		player_stall,
		player_overspeed;

} sar_dc_struct;

#define SAR_DC(p)		((sar_dc_struct *)(p))


/* sardrawhelipad. */
extern void SARDrawHelipad(
	sar_dc_struct *dc, sar_object_struct *obj_ptr,
        sar_object_helipad_struct *obj_helipad_ptr,
	float distance
);
extern void SARDrawHelipadMap(
	sar_dc_struct *dc, sar_object_struct *obj_ptr,
        sar_object_helipad_struct *obj_helipad_ptr,
	float icon_len
);

/* sardrawhuman.c */
extern void SARDrawHumanIterate(
	sar_dc_struct *dc,
        float height, float mass,
        sar_obj_flags_t flags,          /* Human flags. */
        sar_color_struct *palette,      /* Human colors. */
        int water_ripple_tex_num,
        sar_grad_anim_t anim_pos
);
extern void SARDrawHuman(
	sar_dc_struct *dc, sar_object_struct *obj_ptr,
        sar_object_human_struct *obj_human_ptr
);

/* sardrawrunway.c */
extern void SARDrawRunway(
	sar_dc_struct *dc, sar_object_struct *obj_ptr,
        sar_object_runway_struct *obj_runway_ptr,
	float distance
);
extern void SARDrawRunwayMap(
	sar_dc_struct *dc, sar_object_struct *obj_ptr,
        sar_object_runway_struct *obj_runway_ptr,
	float icon_len
);

/* sardrawmessages.c */
extern void SARDrawHelp(sar_dc_struct *dc);
extern void SARDrawMessages(sar_dc_struct *dc);
extern void SARDrawBanner(sar_dc_struct *dc);
extern void SARDrawCameraRefTitle(sar_dc_struct *dc);
extern void SARDrawControlMessages(sar_dc_struct *dc);

/* sardrawutils.c */
extern void SARDrawBoxNS(float x_len, float y_len, float z_len);
extern void SARDrawBoxBaseNS(
	float x_len, float y_len, float z_len,
	Boolean draw_base
);

/* sardraw.c */
extern void SARDraw(sar_core_struct *core_ptr);
extern void SARDrawMap(
        sar_core_struct *core_ptr,
        Boolean draw_for_gcc, Boolean draw_for_ghc, int gcc_obj_num
);

#endif	/* SARDRAW_H */
