/*-------------------------------------------------------------------------
   fabsf.c - Returns the absolute value of a 32-bit float.

   Copyright (C) 2001,2002, Jesus Calvino-Fraga, jesusc@ieee.org 

   This library is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2.1, or (at your option) any
   later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License 
   along with this library; see the file COPYING. If not, write to the
   Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.

   As a special exception, if you link this library with other files,
   some of which are compiled with SDCC, to produce an executable,
   this library does not by itself cause the resulting executable to
   be covered by the GNU General Public License. This exception does
   not however invalidate any other reasons why the executable file
   might be covered by the GNU General Public License.
-------------------------------------------------------------------------*/

#include <float.h>
#include <math.h>
#include <errno.h>

float fabsf(const float x) _MATH_REENTRANT
{
    FS_STATIC union float_long fl;

    fl.f = x;
    fl.l &= 0x7fffffff;
    return fl.f;
}
