/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef AGS_ACHIEVEMENTS_H
#define AGS_ACHIEVEMENTS_H

#include "common/achievements.h"

namespace AGS {

static const Common::AchievementDescriptionList achievementDescriptionList[] = {
	{"adateinthepark", Common::STEAM_ACHIEVEMENTS, "468530"},
	{"alemmo", Common::STEAM_ACHIEVEMENTS, "296850"},
	{"alum", Common::STEAM_ACHIEVEMENTS, "338420"},
	{"astroloco", Common::STEAM_ACHIEVEMENTS, "357490"},
	{"atotkdeluxe", Common::STEAM_ACHIEVEMENTS, "603870"},
	{"apotheosis", Common::STEAM_ACHIEVEMENTS, "364350"},
	{"beer", Common::STEAM_ACHIEVEMENTS, "782280"},
	{"blackwell1", Common::STEAM_ACHIEVEMENTS, "80330"},
	{"blackwell2", Common::STEAM_ACHIEVEMENTS, "80340"},
	{"blackwell3", Common::STEAM_ACHIEVEMENTS, "80350"},
	{"blackwell4", Common::STEAM_ACHIEVEMENTS, "80360"},
	{"blackwell5", Common::STEAM_ACHIEVEMENTS, "236930"},
	{"charnelhousetrilogy", Common::STEAM_ACHIEVEMENTS, "288930"},
	{"chronicleofinnsmouth", Common::STEAM_ACHIEVEMENTS, "420180"},
	{"crystalshardadventurebundle", Common::STEAM_ACHIEVEMENTS, "551840"},
	{"detectivegallo", Common::GALAXY_ACHIEVEMENTS, "1745746005"},
	{"detectivegallo", Common::STEAM_ACHIEVEMENTS, "556060"},
	{"docapocalypse", Common::STEAM_ACHIEVEMENTS, "509920"},
	{"downfall2009", Common::STEAM_ACHIEVEMENTS, "364390"},
	{"dustbowl", Common::STEAM_ACHIEVEMENTS, "367110"},
	{"falconcity", Common::STEAM_ACHIEVEMENTS, "1270590"},
	{"feriadarles", Common::STEAM_ACHIEVEMENTS, "1181570"},
	{"footballgame", Common::STEAM_ACHIEVEMENTS, "654550"},
	{"geminirue", Common::STEAM_ACHIEVEMENTS, "80310"},
	{"goldenwake", Common::STEAM_ACHIEVEMENTS, "307570"},
	{"guardduty", Common::GALAXY_ACHIEVEMENTS, "1455980545"},
	{"guardduty", Common::STEAM_ACHIEVEMENTS, "872750"},
	{"herdiscoming", Common::STEAM_ACHIEVEMENTS, "1028740"},
	{"heroinesquest", Common::STEAM_ACHIEVEMENTS, "283880"},
	{"justignorethem", Common::STEAM_ACHIEVEMENTS, "561770"},
	{"kathyrain", Common::GALAXY_ACHIEVEMENTS, "1460710709"},
	{"kathyrain", Common::STEAM_ACHIEVEMENTS, "370910"},
	{"killyourself", Common::STEAM_ACHIEVEMENTS, "1251910"},
	{"lamplightcity", Common::STEAM_ACHIEVEMENTS, "761460"},
	{"legendofhand", Common::STEAM_ACHIEVEMENTS, "595560"},
	{"mage", Common::GALAXY_ACHIEVEMENTS, "1469845437"},
	{"mage", Common::STEAM_ACHIEVEMENTS, "270610"},
	{"metaldead", Common::STEAM_ACHIEVEMENTS, "302690"},
	{"metaphobia", Common::STEAM_ACHIEVEMENTS, "1220930"},
	{"neofeud", Common::STEAM_ACHIEVEMENTS, "673850"},
	{"oott", Common::GALAXY_ACHIEVEMENTS, "1444830704"},
	{"oott", Common::STEAM_ACHIEVEMENTS, "425600"},
	{"primordia", Common::STEAM_ACHIEVEMENTS, "227000"},
	{"qfi", Common::STEAM_ACHIEVEMENTS, "264560"},
	{"resonance", Common::STEAM_ACHIEVEMENTS, "212050"},
	{"richardandalice", Common::STEAM_ACHIEVEMENTS, "279260"},
	{"roguestate", Common::STEAM_ACHIEVEMENTS, "396090"},
	{"samaritan", Common::STEAM_ACHIEVEMENTS, "283180"},
	{"shardlight", Common::STEAM_ACHIEVEMENTS, "336130"},
	{"shivah", Common::STEAM_ACHIEVEMENTS, "252370"},
	{"sumatra", Common::STEAM_ACHIEVEMENTS, "610900"},
	{"technobabylon", Common::STEAM_ACHIEVEMENTS, "307580"},
	{"thecastle", Common::STEAM_ACHIEVEMENTS, "1133950"},
	{"thecatlady", Common::STEAM_ACHIEVEMENTS, "253110"},
	{"thesecretsofjesus", Common::STEAM_ACHIEVEMENTS, "1142230"},
	{"theterribleoldman", Common::STEAM_ACHIEVEMENTS, "1147030"},
	{"unavowed", Common::STEAM_ACHIEVEMENTS, "336140"},
	{"untilihaveyou", Common::STEAM_ACHIEVEMENTS, "439310"},
	{"whispersofamachine", Common::GALAXY_ACHIEVEMENTS, "1845001352"},
	{"whispersofamachine", Common::STEAM_ACHIEVEMENTS, "631570"},
	{"zniwadventure", Common::STEAM_ACHIEVEMENTS, "904750"},

	ACHIEVEMENT_DESC_TABLE_END_MARKER
};

} // End of namespace AGS

#endif /* AGS_ACHIEVEMENTS_H */
