/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "titanic/game/sgt/chest_of_drawers.h"

namespace Titanic {

BEGIN_MESSAGE_MAP(CChestOfDrawers, CSGTStateRoom)
	ON_MESSAGE(TurnOn)
	ON_MESSAGE(TurnOff)
	ON_MESSAGE(MovieEndMsg)
END_MESSAGE_MAP()

void CChestOfDrawers::save(SimpleFile *file, int indent) {
	file->writeNumberLine(1, indent);
	CSGTStateRoom::save(file, indent);
}

void CChestOfDrawers::load(SimpleFile *file) {
	file->readNumber();
	CSGTStateRoom::load(file);
}

bool CChestOfDrawers::TurnOn(CTurnOn *msg) {
	if (_statics->_v6 == "Closed" && _statics->_v5 == "Open") {
		_fieldE0 = false;
		_statics->_v6 = "Open";
		_startFrame = 1;
		_endFrame = 14;
		playSound("b#11.wav");
	}

	return true;
}

bool CChestOfDrawers::TurnOff(CTurnOff *msg) {
	if (_statics->_v6 == "Open" && _statics->_v5 == "Closed") {
		CVisibleMsg visibleMsg;
		visibleMsg.execute("Drawer");
		_statics->_v6 = "Closed";
		_fieldE0 = true;

		_startFrame = 14;
		_endFrame = 27;
		playMovie(14, 27, MOVIE_NOTIFY_OBJECT | MOVIE_GAMESTATE);
		playSound("b#11.wav");
	}

	return true;
}

bool CChestOfDrawers::MovieEndMsg(CMovieEndMsg *msg) {
	if (_statics->_v6 == "Open") {
		CVisibleMsg visibleMsg;
		visibleMsg.execute("Drawer");
	}

	return true;
}

} // End of namespace Titanic
