/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL$
 * $Id$
 *
 */

#ifndef TSAGE_STATICRES_H
#define TSAGE_STATICRES_H

#include "common/scummsys.h"

namespace tSage {

extern const byte CURSOR_ARROW_DATA[];

extern const byte CURSOR_WALK_DATA[];

extern const char *LOOK_SCENE_HOTSPOT;
extern const char *USE_SCENE_HOTSPOT;
extern const char *TALK_SCENE_HOTSPOT;
extern const char *SPECIAL_SCENE_HOTSPOT;
extern const char *DEFAULT_SCENE_HOTSPOT;
extern const char *SAVE_ERROR_MSG;
extern const char *SAVING_NOT_ALLOWED_MSG;
extern const char *RESTORING_NOT_ALLOWED_MSG;
extern const char *RESTART_CONFIRM_MSG;
extern const char *WATCH_INTRO_MSG;

// Dialogs
extern const char *HELP_MSG;
extern const char *QUIT_CONFIRM_MSG;
extern const char *RESTART_MSG;
extern const char *GAME_PAUSED_MSG;
extern const char *OPTIONS_MSG;
extern const char *OK_BTN_STRING;
extern const char *CANCEL_BTN_STRING;
extern const char *QUIT_BTN_STRING;
extern const char *RESTART_BTN_STRING;
extern const char *SAVE_BTN_STRING;
extern const char *RESTORE_BTN_STRING;
extern const char *SOUND_BTN_STRING;
extern const char *RESUME_BTN_STRING;
extern const char *LOOK_BTN_STRING;
extern const char *PICK_BTN_STRING;
extern const char *INV_EMPTY_MSG;
extern const char *START_PLAY_BTN_STRING;
extern const char *INTRODUCTION_BTN_STRING;

// Scene specific resources
extern const char *EXIT_MSG;
extern const char *SCENE6100_CAREFUL;
extern const char *SCENE6100_TOUGHER;
extern const char *SCENE6100_ONE_MORE_HIT;
extern const char *SCENE6100_DOING_BEST;
extern const char *SCENE6100_REPAIR;
extern const char *SCENE6100_ROCKY_AREA;
extern const char *SCENE6100_REPLY;
extern const char *SCENE6100_TAKE_CONTROLS;
extern const char *SCENE6100_SURPRISE;
extern const char *SCENE6100_SWEAT;
extern const char *SCENE6100_VERY_WELL;

// Demo messages
extern const char *DEMO_HELP_MSG;
extern const char *DEMO_PAUSED_MSG;

} // End of namespace tSage

#endif
