/* ScummVM - Scumm Interpreter
 * Copyright (C) 2006 The ScummVM project
 *
 * Copyright (C) 1999-2001 Sarien Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-9-0/engines/agi/savegame.h $
 * $Id: savegame.h 22611 2006-05-24 14:25:42Z eriktorbjorn $
 *
 */

#ifndef AGI_SAVEGAME_H
#define AGI_SAVEGAME_H

#include "agi/agi.h"

namespace Agi {

int savegame_dialog(void);
int loadgame_dialog(void);
int savegame_simple(void);
int loadgame_simple(void);

/* Image stack support */
#define ADD_PIC 1
#define ADD_VIEW 2

void clear_image_stack(void);
void record_image_stack_call(uint8 type, int16 p1, int16 p2, int16 p3,
		int16 p4, int16 p5, int16 p6, int16 p7);
void replay_image_stack_call(uint8 type, int16 p1, int16 p2, int16 p3,
		int16 p4, int16 p5, int16 p6, int16 p7);
void release_image_stack(void);

}                             // End of namespace Agi

#endif				/* AGI_SAVEGAME_H */
