<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE TS>
<TS version="2.0" language="es_ES">
<context>
    <name></name>
    <message>
        <source>getColorNames() -&gt; list

Returns a list containing the names of all defined colors in the document.
If no document is open, returns a list of the default document colors.
</source>
        <translation type="obsolete">getColorNames() -&gt; list

Devuelve una lista que contiene los nombres de todos los colores definidos 
en el documento. Si no hay abierto ningún documento, devuelve una lista de 
los colores del documento por defecto.
</translation>
    </message>
    <message>
        <source>getColor(&quot;name&quot;) -&gt; tuple

Returns a tuple (C, M, Y, K) containing the four color components of the
color &quot;name&quot; from the current document. If no document is open, returns
the value of the named color from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">getColor(&quot;name&quot;) -&gt; tuple

Devuelve un vector (C, M, Y, K) que tiene las cuatro componentes de 
color del color &quot;name&quot; del documento actual. Si no hay un documento 
abierto, usa los colores del documento por defecto. 

Puede lanzar NotFoundError si no se encuentra el color indicado. 
Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>changeColor(&quot;name&quot;, c, m, y, k)

Changes the color &quot;name&quot; to the specified CMYK value. The color value is
defined via four components c = Cyan, m = Magenta, y = Yellow and k = Black.
Color components should be in the range from 0 to 255.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">changeColor(&quot;name&quot;, c, m, y, k)

Cambia el color &quot;name&quot; al valor CMYK especificado. El valor del color 
se define mediante cuatro componentes: c = cian, m = magenta, 
y = amarillo y k = negro. Las componentes deberían estar en el 
rango 0 a 255. 

Puede lanzar NotFoundError si no se encuentra el color indicado. 
Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>defineColor(&quot;name&quot;, c, m, y, k)

Defines a new color &quot;name&quot;. The color Value is defined via four components:
c = Cyan, m = Magenta, y = Yellow and k = Black. Color components should be in
the range from 0 to 255.

May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">defineColor(&quot;name&quot;, c, m, y, k)

Define un nuevo color llamado &quot;name&quot;. El valor del color se define mediante 
cuatro componentes: c = cian, m = magenta, y = amarillo y k = negro. 
Las componentes deberían estar en el rango 0 a 255. 

Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>deleteColor(&quot;name&quot;, &quot;replace&quot;)

Deletes the color &quot;name&quot;. Every occurence of that color is replaced by the
color &quot;replace&quot;. If not specified, &quot;replace&quot; defaults to the color
&quot;None&quot; - transparent.

deleteColor works on the default document colors if there is no document open.
In that case, &quot;replace&quot;, if specified, has no effect.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">deleteColor(&quot;name&quot;, &quot;replace&quot;)

Borra el color &quot;name&quot;. Cada aparición de ese color se reemplaza 
con el color &quot;replace&quot;. Si no se especifica, se reemplaza por el 
color &quot;Ninguno&quot; - transparente.

Si no hay ningún documento abierto, deleteColor funciona sobre los 
colores del documento por defecto. En ese caso, aunque se indique,
&quot;replace&quot; no tiene efecto.

Puede lanzar NotFoundError si no se encuentra el color indicado. 
Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>replaceColor(&quot;name&quot;, &quot;replace&quot;)

Every occurence of the color &quot;name&quot; is replaced by the color &quot;replace&quot;.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">replaceColor(&quot;name&quot;, &quot;replace&quot;)

Cada aparición del color &quot;name&quot; se reemplaza por el color &quot;replace&quot;.

Puede lanzar NotFoundError si no se encuentra el color indicado. 
Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>newDocDialog() -&gt; bool

Displays the &quot;New Document&quot; dialog box. Creates a new document if the user
accepts the settings. Does not create a document if the user presses cancel.
Returns true if a new document was created.
</source>
        <translation type="obsolete">newDocDialog() -&gt; bool

Muestra el diálogo &quot;Nuevo Documento&quot;. Crea un nuevo documento si el 
usuario presiona Aceptar. No lo crea si presiona Cancelar. Devuelve true 
si se crea un nuevo documento.</translation>
    </message>
    <message>
        <source>messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Displays a message box with the title &quot;caption&quot;, the message &quot;message&quot;, and
an icon &quot;icon&quot; and up to 3 buttons. By default no icon is used and a single
button, OK, is displayed. Only the caption and message arguments are required,
though setting an icon and appropriate button(s) is strongly
recommended. The message text may contain simple HTML-like markup.

Returns the number of the button the user pressed. Button numbers start
at 1.

For the icon and the button parameters there are predefined constants available
with the same names as in the Qt Documentation. These are the BUTTON_* and
ICON_* constants defined in the module. There are also two extra constants that
can be binary-ORed with button constants:
    BUTTONOPT_DEFAULT   Pressing enter presses this button.
    BUTTONOPT_ESCAPE    Pressing escape presses this button.

Usage examples:
result = messageBox(&apos;Script failed&apos;,
                    &apos;This script only works when you have a text frame selected.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Defined button and icon constants:
BUTTON_NONE, BUTTON_ABORT, BUTTON_CANCEL, BUTTON_IGNORE, BUTTON_NO,
BUTTON_NOALL, BUTTON_OK, BUTTON_RETRY, BUTTON_YES, BUTTON_YESALL,
ICON_NONE, ICON_INFORMATION, ICON_WARNING, ICON_CRITICAL.
</source>
        <translation type="obsolete">messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Muestra un cuadro de mensaje con el título &quot;caption&quot;, el mensaje &quot;message&quot;, 
un icono &quot;icon&quot; y hasta 3 botones. Por defecto no se usa ningún icono y sólo 
hay un botón, Aceptar. Sólo son obligatorios los parámetros caption y message, 
sin embargo se recomienda definir un icono y el botón o botones apropiados. 
El mensaje puede contener etiquetas simples similares a las de HTML.

Devuelve el número del botón que presionó el usuario. Los números de los 
botones empiezan en 1. 

Para los parámetros del icono y de los botones hay constantes predefinidas 
disponibles con los mismos nombres que en la Documentación de Qt. Son las 
constantes BUTTON_* e ICON_* definidas en el módulo. Hay también otras 
dos constantes extra que pueden ser combinadas con un OR binario con las 
constantes de los botones: 
    BUTTONOPT_DEFAULT   Presionar intro presiona este botón.
    BUTTONOPT_ESCAPE    Presionar escape presiona este botón.

Ejemplos de uso: 
result = messageBox(&apos;Error en Script&apos;,
                    &apos;Este scrpt sólo funciona cuando tienes un marco de texto seleccionado.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Botones definidos y constantes de iconos:
BUTTON_NONE (ninguno), BUTTON_ABORT (abortar), BUTTON_CANCEL (cancelar), 
BUTTON_IGNORE (ignorar), BUTTON_NO (no), BUTTON_NOALL (no a todo), 
BUTTON_OK (aceptar), BUTTON_RETRY (reintentar), BUTTON_YES (sí), 
BUTTON_YESALL (sí a todo), ICON_NONE (ninguno), ICON_INFORMATION (información),
ICON_WARNING (aviso).
</translation>
    </message>
    <message>
        <source>valueDialog(caption, message [,defaultvalue]) -&gt; string

Shows the common &apos;Ask for string&apos; dialog and returns its value as a string
Parameters: window title, text in the window and optional &apos;default&apos; value.

Example: valueDialog(&apos;title&apos;, &apos;text in the window&apos;, &apos;optional&apos;)
</source>
        <translation type="obsolete">valueDialog(caption, message [,defaultvalue]) -&gt; string

Muestra el diálogo &apos;Introducir una cadena&apos; y devuelve su valor 
como un string. 
Parámetros: título de la ventana, texto de la ventana y un valor 
por defecto opcional. 

Ejemplo: valueDialog(&apos;título&apos;, &apos;texto de la ventana&apos;, &apos;opcional&apos;)
</translation>
    </message>
    <message>
        <source>newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Creates a new document and returns true if successful. The parameters have the
following meaning:

size = A tuple (width, height) describing the size of the document. You can
use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

margins = A tuple (left, right, top, bottom) describing the document
margins

orientation = the page orientation - constants PORTRAIT, LANDSCAPE

firstPageNumer = is the number of the first page in the document used for
pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
numbers if you&apos;re creating a document in several parts.

unit: this value sets the measurement units used by the document. Use a
predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
UNIT_PICAS, UNIT_POINTS.

pagesType = One of the predefined constants PAGE_n. PAGE_1 is single page,
PAGE_2 is for double sided documents, PAGE_3 is for 3 pages fold and
PAGE_4 is 4-fold.

firstPageOrder = What is position of first page in the document.
Indexed from 0 (0 = first).

numPage = Number of pages to be created.

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS,
PAGE_4, 3, 1)

May raise ScribusError if is firstPageOrder bigger than allowed by pagesType.
</source>
        <translation type="obsolete">newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Crea un nuevo documento y devuelve true si tiene éxito. Los parámetros tienen 
el siguiente significado:

size = Un par (ancho, alto) que describe el tamaño del documento. Se 
pueden usar constantes predefinidas llamadas PAPER_&lt;tipo_de_papel&gt; 
p. ej. PAPER_A4 etc.

margins = Un vector (izquierda, derecha, arriba, abajo) que describe 
los márgenes del documento

orientation = La orientación de la página - constantes PORTRAIT (vertical), 
LANDSCAPE (apasaido)

firstPageNumber = Es el número de la primera página del documento 
usado para la numeración de páginas. Aunque normalmente será 1, es útil 
para tener números mayores si se crea un documento en varias partes.

unit: Este valor establece las unidades de medida usadas por el 
documento. Usa una de estas constantes predefinidas para ello: 
UNIT_INCHES (pulgadas), UNIT_MILLIMETERS (milímetros), 
UNIT_PICAS (picas), UNIT_POINTS (puntos).

pagesType = Una de las constantes predefinidas PAGE_n. PAGE_1 es una
página simple, PAGE_2 es para documentos a doble página, PAGE_3 es para
trípticos y PAGE_4 es para cuatro páginas.

firstPageOrder = Cuál es la posición de la primera página del documento.
Indizadas desde 0 (0 = primera).

numPage = Número de páginas a crear.

Los valores para la anchura, altura y los márgenes están expresados en la unidad 
dada para el documento. Las constantes PAPER_* están expresadas en puntos. Si 
tu documento no está en puntos, asegurate de tenerlo en cuenta. 

ejemplo: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS, 
PAGE_4, 3, 1)

Puede lanzar ScribusError si firstPageOrder es mayor que el permitido por pagesType.
</translation>
    </message>
    <message>
        <source>closeDoc()

Closes the current document without prompting to save.

May throw NoDocOpenError if there is no document to close
</source>
        <translation type="obsolete">closeDoc()

Cierra el documento actual sin preguntar para guardar.

Puede lanzar NoDocOpenError si no hay ningún 
documento que cerrar
</translation>
    </message>
    <message>
        <source>haveDoc() -&gt; bool

Returns true if there is a document open.
</source>
        <translation type="obsolete">haveDoc() -&gt; bool

Devuelve true si hay un documento abierto.</translation>
    </message>
    <message>
        <source>openDoc(&quot;name&quot;)

Opens the document &quot;name&quot;.

May raise ScribusError if the document could not be opened.
</source>
        <translation type="obsolete">openDoc(&quot;name&quot;)

Abre el documento &quot;name&quot;.

Puede lanzar la excepción ScribusError si el documento no se puede abrir.
</translation>
    </message>
    <message>
        <source>saveDoc()

Saves the current document with its current name, returns true if successful.
If the document has not already been saved, this may bring up an interactive
save file dialog.

If the save fails, there is currently no way to tell.
</source>
        <translation type="obsolete">saveDoc()

Guarda el documento actual con su nombre actual, y devuelve true si se 
guarda correctamente. Si el documento no se había guardado todavía, 
muestra un diálogo de guardar archivo. 

Si se produce un error al guardar, actualmente no hay forma de informarlo.
</translation>
    </message>
    <message>
        <source>saveDocAs(&quot;name&quot;)

Saves the current document under the new name &quot;name&quot; (which may be a full or
relative path).

May raise ScribusError if the save fails.
</source>
        <translation type="obsolete">saveDocAs(&quot;name&quot;)

Guarda el documento actual con el nombre &quot;name&quot; (que puede ser un ruta 
absoluta o relativa).

Puede lanzar la excepción ScribusError si se produce un error al guardar.
</translation>
    </message>
    <message>
        <source>setUnit(type)

Changes the measurement unit of the document. Possible values for &quot;unit&quot; are
defined as constants UNIT_&lt;type&gt;.

May raise ValueError if an invalid unit is passed.
</source>
        <translation type="obsolete">setUnit(type)

Cambia las unidades de medida del documento. Los valores posibles para &quot;unit&quot; 
son las constantes UNIT_&lt;tipo&gt;.

Puede lanzar una excepción ValueError si se pasa una unidad no válida.
</translation>
    </message>
    <message>
        <source>getUnit() -&gt; integer (Scribus unit constant)

Returns the measurement units of the document. The returned value will be one
of the UNIT_* constants:
UNIT_INCHES, UNIT_MILLIMETERS, UNIT_PICAS, UNIT_POINTS.
</source>
        <translation type="obsolete">getUnit() -&gt; integer (constante de unidad de Scribus)

Devuelve las unidades de medida del documento. El valor devuelto será una 
de las constantes UNIT_*:
UNIT_INCHES (pulgadas), UNIT_MILLIMETERS (milimetros), 
UNIT_PICAS (picas), UNIT_POINTS (puntos).
</translation>
    </message>
    <message>
        <source>loadStylesFromFile(&quot;filename&quot;)

Loads paragraph styles from the Scribus document at &quot;filename&quot; into the
current document.
</source>
        <translation type="obsolete">loadStylesFromFile(&quot;filename&quot;)

Carga en el documento actual los estilos de párrafo del documento 
de Scribus que se encuentra en &quot;filename&quot;.
</translation>
    </message>
    <message>
        <source>setDocType(facingPages, firstPageLeft)

Sets the document type. To get facing pages set the first parameter to
FACINGPAGES, to switch facingPages off use NOFACINGPAGES instead.  If you want
to be the first page a left side set the second parameter to FIRSTPAGELEFT, for
a right page use FIRSTPAGERIGHT.
</source>
        <translation type="obsolete">setDocType(facingPages, firstPageLeft)

Establece el tipo de documento. Para que las páginas se muestren enfrentadas 
el primer parámetro debe ser FACINGPAGES, para desactivar las páginas 
enfrentadas debe ser NOFACINGPAGES. Si se quiere que la primera página esté 
a la izquierda el segundo parámetro debe ser FIRSTPAGELEFT, para que esté a 
la derecha debe ser FIRSTPAGERIGHT.
</translation>
    </message>
    <message>
        <source>getFillColor([&quot;name&quot;]) -&gt; string

Returns the name of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getFillColor([&quot;name&quot;]) -&gt; string

Devuelve el nombre del color de relleno del objeto con nombre&quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getLineColor([&quot;name&quot;]) -&gt; string

Returns the name of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getLineColor([&quot;name&quot;]) -&gt; string

Devuelve el nombre del color de línea del objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getLineWidth([&quot;name&quot;]) -&gt; integer

Returns the line width of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="obsolete">getLineWidth([&quot;name&quot;]) -&gt; integer

Devuelve el ancho de línea del objeto &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getLineShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getLineShade([&quot;name&quot;]) -&gt; integer

Devuelve la intesnsidad del color de línea del objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getLineEnd([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line cap style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. The cap types are:
CAP_FLAT, CAP_ROUND, CAP_SQUARE
</source>
        <translation type="obsolete">getLineEnd([&quot;name&quot;]) -&gt; integer (ver constantes)

Devuelve el estilo de extremo de línea del objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
Los tipos de extremo son: 
CAP_FLAT (plano), CAP_ROUND (redondeado), CAP_SQUARE (cuadrado)
</translation>
    </message>
    <message>
        <source>getLineStyle([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. Line style constants are:
LINE_DASH, LINE_DASHDOT, LINE_DASHDOTDOT, LINE_DOT, LINE_SOLID
</source>
        <translation type="obsolete">getLineStyle([&quot;name&quot;]) -&gt; integer (ver constantes)

Devuelve el estilo de línea del objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado. 
Las constantes de estilos de línea son:
LINE_DASH (a trazos), LINE_DASHDOT (raya punto), 
LINE_DASHDOTDOT (raya punto punto), LINE_DOT (a puntos), 
LINE_SOLID (sólida)
</translation>
    </message>
    <message>
        <source>getFillShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getFillShade([&quot;name&quot;]) -&gt; integer

Devuelve el valor de saturación del color de relleno del objeto &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getCornerRadius([&quot;name&quot;]) -&gt; integer

Returns the corner radius of the object &quot;name&quot;. The radius is
expressed in points. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">getCornerRadius([&quot;name&quot;]) -&gt; integer

Devuelve el radio de las esquinas del objeto &quot;name&quot;. 
El radio se expresa en puntos.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getImageScale([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple containing the scaling values of the image frame
&quot;name&quot;.  If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getImageScale([&quot;name&quot;]) -&gt; (x,y)

Devuelve un par (x, y) que contiene los valores de escalado del 
marco de imagen &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getImageName([&quot;name&quot;]) -&gt; string

Returns the filename for the image in the image frame. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="obsolete">getImageName([&quot;name&quot;]) -&gt; string

Devuelve el nombre de archivo de la imagen en el marco de imagen &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getPosition([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple with the position of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
The position is expressed in the actual measurement unit of the document
- see UNIT_&lt;type&gt; for reference.
</source>
        <translation type="obsolete">getPosition([&quot;name&quot;]) -&gt; (x,y)

Devuelve un par (x, y) con la posición del objeto &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
Las posiciones están expresadas en las unidades actuales del documento 
- ver UNIT_&lt;tipo&gt; para más referencias.
</translation>
    </message>
    <message>
        <source>getSize([&quot;name&quot;]) -&gt; (width,height)

Returns a (width, height) tuple with the size of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. The size is
expressed in the current measurement unit of the document - see UNIT_&lt;type&gt;
for reference.
</source>
        <translation type="obsolete">getSize([&quot;name&quot;]) -&gt; (width,height)

Devuelve un par (ancho, alto) con el tamaño del objeto &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
El tamaño está expresado en las unidades actuales del documento 
- ver UNIT_&lt;tipo&gt; para más referencias.
</translation>
    </message>
    <message>
        <source>getRotation([&quot;name&quot;]) -&gt; integer

Returns the rotation of the object &quot;name&quot;. The value is expressed in degrees,
and clockwise is positive. If &quot;name&quot; is not given the currently selected item
is used.
</source>
        <translation type="obsolete">getRotation([&quot;name&quot;]) -&gt; integer

Devuelve la rotación del objeto &quot;name&quot;. El valor está expresado 
en grados y si es positivo es en el sentido de las agujas del reloj.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getAllObjects() -&gt; list

Returns a list containing the names of all objects on the current page.
</source>
        <translation type="obsolete">getAllObjects() -&gt; list

Devuelve una lista que contiene los nombres de todos los objetos 
de la página actual.
</translation>
    </message>
    <message>
        <source>moveObject(dx, dy [, &quot;name&quot;])

Moves the object &quot;name&quot; by dx and dy relative to its current position. The
distances are expressed in the current measurement unit of the document (see
UNIT constants). If &quot;name&quot; is not given the currently selected item is used.
If the object &quot;name&quot; belongs to a group, the whole group is moved.
</source>
        <translation type="obsolete">moveObject(dx, dy [, &quot;name&quot;])

Mueve el objeto de nombre &quot;name&quot; dx y dy unidades, relativo a su posición 
actual. Las distancias se deben expresar en las unidades actuales del 
documento (ver constantes UNIT). Si no se pasa un nombre, se usa el objeto 
que esté seleccionado. Si el objeto &quot;name&quot; pertenece a un grupo, se 
mueve el grupo entero.
</translation>
    </message>
    <message>
        <source>moveObjectAbs(x, y [, &quot;name&quot;])

Moves the object &quot;name&quot; to a new location. The coordinates are expressed in
the current measurement unit of the document (see UNIT constants).  If &quot;name&quot;
is not given the currently selected item is used.  If the object &quot;name&quot;
belongs to a group, the whole group is moved.
</source>
        <translation type="obsolete">moveObjectAbs(x, y [, &quot;name&quot;])

Mueve el objeto &quot;name&quot; a una nueva posición. Las coordenadas están 
expresadas en las unidades actuales del documento (ver constantes UNIT).
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
Si el objeto a mover pertenece a un grupo, se mueve todo el grupo.
</translation>
    </message>
    <message>
        <source>rotateObjectAbs(rot [, &quot;name&quot;])

Sets the rotation of the object &quot;name&quot; to &quot;rot&quot;. Positive values
mean counter clockwise rotation. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">rotateObjectAbs(rot [, &quot;name&quot;])

Establece la rotación del objeto &quot;name&quot; a &quot;rot&quot;. Los valores positivos 
significan rotación en sentido contrario a las agujas del reloj.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>sizeObject(width, height [, &quot;name&quot;])

Resizes the object &quot;name&quot; to the given width and height. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="obsolete">sizeObject(width, height [, &quot;name&quot;])

Redimensiona el objeto &quot;name&quot; a la anchura (width) y altura (height) dados.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getSelectedObject([nr]) -&gt; string

Returns the name of the selected object. &quot;nr&quot; if given indicates the number
of the selected object, e.g. 0 means the first selected object, 1 means the
second selected Object and so on.
</source>
        <translation type="obsolete">getSelectedObject([nr]) -&gt; string

Devuelve el nombre del objeto seleccionado. &quot;nr&quot;, si se especifica, indica 
el número del objeto seleccionado, p. ej. 0 significa el primer objeto 
seleccionado, 1 el segundo objeto seleccionado, etc.
</translation>
    </message>
    <message>
        <source>selectionCount() -&gt; integer

Returns the number of selected objects.
</source>
        <translation type="obsolete">selectionCount() -&gt; integer

Devuelve el número de objetos seleccionados.
</translation>
    </message>
    <message>
        <source>selectObject(&quot;name&quot;)

Selects the object with the given &quot;name&quot;.
</source>
        <translation type="obsolete">selectObject(&quot;name&quot;)

Selecciona el objeto con el nombre &quot;name&quot;.
</translation>
    </message>
    <message>
        <source>deselectAll()

Deselects all objects in the whole document.
</source>
        <translation type="obsolete">deselectAll()

Deselecciona todos los objetos del documento entero.
</translation>
    </message>
    <message>
        <source>groupObjects(list)

Groups the objects named in &quot;list&quot; together. &quot;list&quot; must contain the names
of the objects to be grouped. If &quot;list&quot; is not given the currently selected
items are used.
</source>
        <translation type="obsolete">groupObjects(list)

Agrupa los objetos nombrados en &quot;list&quot;. &quot;list&quot; debe contener los nombres 
de los objetos a ser agrupados. 
Si no se pasa una lista se usan los objetos que estén seleccionados.
</translation>
    </message>
    <message>
        <source>unGroupObjects(&quot;name&quot;)

Destructs the group the object &quot;name&quot; belongs to.If &quot;name&quot; is not given the currently selected item is used.</source>
        <translation type="obsolete">unGroupObjects(&quot;name&quot;)

Destruye el grupo al que pertenece el objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>scaleGroup(factor [,&quot;name&quot;])

Scales the group the object &quot;name&quot; belongs to. Values greater than 1 enlarge
the group, values smaller than 1 make the group smaller e.g a value of 0.5
scales the group to 50 % of its original size, a value of 1.5 scales the group
to 150 % of its original size.  The value for &quot;factor&quot; must be greater than
0. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if an invalid scale factor is passed.
</source>
        <translation type="obsolete">scaleGroup(factor [,&quot;name&quot;])

Escala el grupo al que pertenece el objeto &quot;name&quot;. Los valores mayor de 1 
agrandan el grupo, los menores de 1 lo hacen más pequeño, p. ej. un valor 
de 0.5 escala el grupo al 50% de su tamaño original, un valor de 1.5 escala 
el grupo a 150% de su tamaño original. 
El valor de &quot;factor&quot; debe ser mayor de cero.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.

Puede lanzar la excepción ValueError si se pasa un factor de escala no válido. 
</translation>
    </message>
    <message>
        <source>loadImage(&quot;filename&quot; [, &quot;name&quot;])

Loads the picture &quot;picture&quot; into the image frame &quot;name&quot;. If &quot;name&quot; is
not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="obsolete">loadImage(&quot;filename&quot; [, &quot;name&quot;])

Carga la imagen &quot;filename&quot; en el marco de imagen &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.

Puede lanzar la excepción WrongFrameTypeError si el marco de destino 
no es un marco de imagen.
</translation>
    </message>
    <message>
        <source>scaleImage(x, y [, &quot;name&quot;])

Sets the scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="obsolete">scaleImage(x, y [, &quot;name&quot;])

Establece los factores de escalado de la imagen en el marco de 
imagen &quot;name&quot;. Un valor de 1 significa 100%.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.

Puede lanzar la excepción WrongFrameTypeError si el marco de destino 
no es un marco de imagen.
</translation>
    </message>
    <message>
        <source>lockObject([&quot;name&quot;]) -&gt; bool

Locks the object &quot;name&quot; if it&apos;s unlocked or unlock it if it&apos;s locked.
If &quot;name&quot; is not given the currently selected item is used. Returns true
if locked.
</source>
        <translation type="obsolete">lockObject([&quot;name&quot;]) -&gt; bool

Bloquea el objeto &quot;name&quot; si está desbloqueado o lo desbloquea en 
caso contrario. Devuelve true si se bloquea. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>isLocked([&quot;name&quot;]) -&gt; bool

Returns true if is the object &quot;name&quot; locked.  If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="obsolete">isLocked([&quot;name&quot;]) -&gt; bool

Devuelve true si el objeto &quot;name&quot; está bloqueado.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Sets the scale to frame on the selected or specified image frame to `scaletoframe&apos;.
If `proportional&apos; is specified, set fixed aspect ratio scaling to `proportional&apos;.
Both `scaletoframe&apos; and `proportional&apos; are boolean.

May raise WrongFrameTypeError.
</source>
        <translation type="obsolete">setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Establece la opción escalar al tamaño del marco a &quot;scaletoframe&quot; en el marco de
imagen seleccionado o especificado por &quot;name&quot;. 
Si se especifica &quot;proportional&quot;, establece la opción mantener la relación de aspecto
a &quot;proportional&quot;. 
Tanto &quot;scaletoframe&quot; como &quot;proportional&quot; son booleanos.

Puede lanzar la excepción WrongFrameTypeError.
</translation>
    </message>
    <message>
        <source>setRedraw(bool)

Disables page redraw when bool = False, otherwise redrawing is enabled.
This change will persist even after the script exits, so make sure to call
setRedraw(True) in a finally: clause at the top level of your script.
</source>
        <translation type="obsolete">setRedraw(bool)

Desactiva el redibujado de la página si bool = False, de otro modo, se activa 
el redibujado. Este cambio permanecerá incluso después de que el script 
termine, así que asegúrate de llamar a setRedraw(True) en una sentencia 
finally: en el nivel superior del script.
</translation>
    </message>
    <message>
        <source>getFontNames() -&gt; list

Returns a list with the names of all available fonts.
</source>
        <translation type="obsolete">getFontNames() -&gt; list

Devuelve una lista con los nombres de todas las tipografías disponibles.
</translation>
    </message>
    <message>
        <source>getXFontNames() -&gt; list of tuples

Returns a larger font info. It&apos;s a list of the tuples with:
[ (Scribus name, Family, Real name, subset (1|0), embed PS (1|0), font file), (...), ... ]
</source>
        <translation type="obsolete">getXFontNames() -&gt; list of tuples

Da una mayor información sobre las tipografías. Devuelve una lista de vectores con: 
[ (nombre de Scribus, Familia, Nombre real, empotrar subconjunto (1|0), 
empotrar PS (1|0), tipografía), (...), ...]
</translation>
    </message>
    <message>
        <source>renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Creates an image preview of font &quot;name&quot; with given text &quot;sample&quot; and size.
If &quot;filename&quot; is not &quot;&quot;, image is saved into &quot;filename&quot;. Otherwise
image data is returned as a string. The optional &quot;format&quot; argument
specifies the image format to generate, and supports any format allowed
by QPixmap.save(). Common formats are PPM, JPEG, PNG and XPM.

May raise NotFoundError if the specified font can&apos;t be found.
May raise ValueError if an empty sample or filename is passed.
</source>
        <translation type="obsolete">renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Crea una previsualización de la tipografía &quot;name&quot; con el texto &quot;sample&quot; y 
de tamaño &quot;size&quot;. Si &quot;filename&quot; no es &quot;&quot;, la imagen se guarda en&quot;filename&quot;. 
De otra forma la imagen se devuelve como una cadena. El argumento 
opcional &quot;format&quot; especifica el formato de imagen a generar, y admite 
cualquier formato permitido por QPixmap.save(). Los formatos comunes 
son PPM, JPEG, PNG y XPM.

Puede lanzar la excepción NotFoundError si no se puede encontrar la 
tipografía indicada.
Puede lanzar la excepción ValueError si &quot;filename&quot; o &quot;sample&quot; son 
cadenas vacías.
</translation>
    </message>
    <message>
        <source>getLayers() -&gt; list

Returns a list with the names of all defined layers.
</source>
        <translation type="obsolete">getLayers() -&gt; list

Devuelve una lista con los nombres de todas las capas definidas.
</translation>
    </message>
    <message>
        <source>setActiveLayer(&quot;name&quot;)

Sets the active layer to the layer named &quot;name&quot;.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">setActiveLayer(&quot;name&quot;)

Establece la capa activa a la capa con nombre &quot;name&quot;.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si la el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>getActiveLayer() -&gt; string

Returns the name of the current active layer.
</source>
        <translation type="obsolete">getActiveLayer() -&gt; string

Devuelve el nombre de la capa activa actual.
</translation>
    </message>
    <message>
        <source>sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Sends the object &quot;name&quot; to the layer &quot;layer&quot;. The layer must exist.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Envía el objeto &quot;name&quot; a la capa &quot;layer&quot;. La capa debe existir.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>setLayerVisible(&quot;layer&quot;, visible)

Sets the layer &quot;layer&quot; to be visible or not. If is the visible set to false
the layer is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">setLayerVisible(&quot;layer&quot;, visible)

Establece si la capa &quot;layer&quot; es visible o no. 
Si &quot;visible&quot; es false la capa será invisible.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>isLayerVisible(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is visible or not, a value of True means
that the layer &quot;layer&quot; is visible, a value of False means that the layer
&quot;layer&quot; is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">isLayerVisible(&quot;layer&quot;) -&gt; bool

Devuelve si la capa &quot;layer&quot; es visible o no, un valor de True significa 
que la capa &quot;layer&quot; es visible, un valor de False significa que la capa
&quot;layer&quot; es invisible.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>isLayerPrintable(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is printable or not, a value of True means
that the layer &quot;layer&quot; can be printed, a value of False means that printing
the layer &quot;layer&quot; is disabled.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">isLayerPrintable(&quot;layer&quot;) -&gt; bool

Devuelve si la capa &quot;layer&quot; es imprimible o no, un valor de True significa 
que la capa &quot;layer&quot; se puede imprimir, un valor de False significa que se 
ha desactivado la impresión de la capa&quot;layer&quot;.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>deleteLayer(&quot;layer&quot;)

Deletes the layer with the name &quot;layer&quot;. Nothing happens if the layer doesn&apos;t
exists or if it&apos;s the only layer in the document.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">deleteLayer(&quot;layer&quot;)

Borra la capa con el nombre &quot;layer&quot;. No ocurre nada si la capa no existe o 
si es la única capa del documento.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>createLayer(layer)

Creates a new layer with the name &quot;name&quot;.

May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">createLayer(layer)

Crea una nueva capa co el nombre &quot;name&quot;.

Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>getGuiLanguage() -&gt; string

Returns a string with the -lang value.
</source>
        <translation type="obsolete">getGuiLanguage() -&gt; string

Devuelve una cadena con el código del idioma usado.
</translation>
    </message>
    <message>
        <source>createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new rectangle on the current page and returns its name. The
coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name to reference that object in future. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Crea un nuevo rectángulo en la página actual y devuelve su nombre. Las 
coordenadas x, y, anchura y altura se expresan en las unidades actuales 
del documento (ver constantes UNIT). &quot;name&quot; debería ser un identificador 
único para el objeto porque el objeto se referenciará con ese nombre 
después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar NameExistsError si se pasa un nombre que ya se está usando.
</translation>
    </message>
    <message>
        <source>createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new ellipse on the current page and returns its name.
The coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name for further referencing of that object. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Crea una elipse en la página actual y devuelve su nombre. 
Las coordenadas x, y, anchura y altura se expresan en las unidades 
actuales del documento (ver constantes UNIT). &quot;name&quot; debería ser 
un identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando.
</translation>
    </message>
    <message>
        <source>createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new picture frame on the current page and returns its name. The
coordinates are given in the current measurement units of the document.
&quot;name&quot; should be a unique identifier for the object because you need this
name for further access to that object. If &quot;name&quot; is not given Scribus will
create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Crea un marco de imagen en la página actual y devuelve su nombre. 
Las coordenadas x, y, anchura y altura se expresan en las unidades 
actuales del documento. &quot;name&quot; debería ser un identificador único 
para el objeto porque se referenciará con ese nombre después. 
Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando.
</translation>
    </message>
    <message>
        <source>createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new text frame on the actual page and returns its name.
The coordinates are given in the actual measurement unit of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further referencing of that object. If &quot;name&quot; is not
given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Crea un marco de texto en la página actual y devuelve su nombre. 
Las coordenadas x, y, anchura y altura se expresan en las unidades 
actuales del documento (ver constantes UNIT). &quot;name&quot; debería ser 
un identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando.
</translation>
    </message>
    <message>
        <source>createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Creates a new line from the point(x1, y1) to the point(x2, y2) and returns
its name. The coordinates are given in the current measurement unit of the
document (see UNIT constants). &quot;name&quot; should be a unique identifier for the
object because you need this name for further access to that object. If
&quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Crea una línea del punto (x1, y1) al punto (x2, y2) y devuelve su 
nombre. Las coordenadas se expresan en las unidades actuales 
del documento (ver constantes UNIT). &quot;name&quot; debería ser un 
identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando.
</translation>
    </message>
    <message>
        <source>createPolyLine(list, [&quot;name&quot;]) -&gt; string

Creates a new polyline and returns its name. The points for the polyline are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
The coordinates are given in the current measurement units of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further access to that object. If &quot;name&quot; is not given
Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="obsolete">createPolyLine(list, [&quot;name&quot;]) -&gt; string

Crea una polilínea y devuelve su nombre. Los puntos de la polilínea 
se almacenan en la lista &quot;list&quot; en el orden siguiente: [x1, y1, x2, y2, ...xn, yn]. 
Las coordenadas se expresan en las unidades actuales del documento 
(ver constantes UNIT). &quot;name&quot; debería ser un identificador único para el 
objeto porque se referenciará con ese nombre después. Si no se le da 
un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando. 
Puede lanzar la excepción ValueError si se pasa un número de puntos 
insuficiente, o si el número de valores es impar.
</translation>
    </message>
    <message>
        <source>createPolygon(list, [&quot;name&quot;]) -&gt; string

Creates a new polygon and returns its name. The points for the polygon are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
At least three points are required. There is no need to repeat the first point
to close the polygon. The polygon is automatically closed by connecting the
first and the last point.  The coordinates are given in the current measurement
units of the document (see UNIT constants).  &quot;name&quot; should be a unique
identifier for the object because you need this name for further access to that
object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="obsolete">createPolygon(list, [&quot;name&quot;]) -&gt; string

Crea un polígono y devuelve su nombre. Los puntos del polígono se 
almacenan en la lista &quot;list&quot; en el orden siguiente: [x1, y1, x2, y2, ...xn, yn]. 
Al menos se necesitan 3 puntos. No se necesita repetir el primer punto 
para cerrar el polígono, se cierra automáticamente conectando el primer 
punto con el último. Las coordenadas se expresan en las unidades actuales 
del documento (ver constantes UNIT). &quot;name&quot; debería ser un identificador 
único para el objeto porque se referenciará con ese nombre después. 
Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando. 
Puede lanzar la excepción ValueError si se pasa un número de puntos 
insuficiente, o si el número de valores es impar.
</translation>
    </message>
    <message>
        <source>createBezierLine(list, [&quot;name&quot;]) -&gt; string

Creates a new bezier curve and returns its name. The points for the bezier
curve are stored in the list &quot;list&quot; in the following order:
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn. yn, kxn. kyn]
In the points list, x and y mean the x and y coordinates of the point and kx
and ky meaning the control point for the curve.  The coordinates are given in
the current measurement units of the document (see UNIT constants). &quot;name&quot;
should be a unique identifier for the object because you need this name for
further access to that object. If &quot;name&quot; is not given Scribus will create one
for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="obsolete">createBezierLine(list, [&quot;name&quot;]) -&gt; string

Crea una curva de bezier y devuelve su nombre. Los puntos de la 
curva de bezier se almacenan en la lista &quot;list&quot; en el orden siguiente: 
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn, yn, kxn, kyn]. 
En la lista de puntos, x e y son las coordenadas del punto y kx y ky 
el punto de control de la curva. Las coordenadas se expresan en las 
unidades actuales del documento (ver constantes UNIT). &quot;name&quot; debería 
ser un identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando. 
Puede lanzar la excepción ValueError si se pasa un número de puntos 
insuficiente, o si el número de valores es impar.
</translation>
    </message>
    <message>
        <source>createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Creates a new pathText by merging the two objects &quot;textbox&quot; and
&quot;beziercurve&quot; and returns its name. The coordinates are given in the current
measurement unit of the document (see UNIT constants). &quot;name&quot; should be a
unique identifier for the object because you need this name for further access
to that object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise NotFoundError if one or both of the named base object don&apos;t exist.
</source>
        <translation type="obsolete">createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Crea un texto adjunto a un trazado, adjuntando el objeto&quot;textbox&quot; al objeto 
&quot;beziercurve&quot; y devuelve su nombre. Las coordenadas se expresan en las 
unidades actuales del documento (ver constantes UNIT). &quot;name&quot; debería 
ser un identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando. 
Puede lanzar la excepción NotFoundError si alguno de los objetos no existe.
</translation>
    </message>
    <message>
        <source>deleteObject([&quot;name&quot;])

Deletes the item with the name &quot;name&quot;. If &quot;name&quot; is not given the currently
selected item is deleted.
</source>
        <translation type="obsolete">deleteObject([&quot;name&quot;])

Borra el objeto con el nombre &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>objectExists([&quot;name&quot;]) -&gt; bool

Test if an object with specified name really exists in the document.
The optional parameter is the object name. When no object name is given,
returns True if there is something selected.
</source>
        <translation type="obsolete">objectExists([&quot;name&quot;]) -&gt; bool

Comprueba si existe en el documento un objeto con el nombre &quot;name&quot;. 
Si no se pasa un nombre, devuelve true si hay algún objeto seleccionado.
</translation>
    </message>
    <message>
        <source>setStyle(&quot;style&quot; [, &quot;name&quot;])

Apply the named &quot;style&quot; to the object named &quot;name&quot;. If is no object name
given, it&apos;s applied on the selected object.
</source>
        <translation type="obsolete">setStyle(&quot;style&quot; [, &quot;name&quot;])

Aplica el estilo &quot;style&quot; al objeto &quot;name&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getAllStyles() -&gt; list

Return a list of the names of all paragraph styles in the current document.
</source>
        <translation type="obsolete">getAllStyles() -&gt; list

Devuelve una lista con los nombres de todos los estilos 
de párrafo del documento.
</translation>
    </message>
    <message>
        <source>newPage(where [,&quot;masterpage&quot;])

Creates a new page. If &quot;where&quot; is -1 the new Page is appended to the
document, otherwise the new page is inserted before &quot;where&quot;. Page numbers are
counted from 1 upwards, no matter what the displayed first page number of your
document is. The optional parameter &quot;masterpage&quot; specifies the name of the
master page for the new page.

May raise IndexError if the page number is out of range
</source>
        <translation type="obsolete">newPage(where [,&quot;masterpage&quot;])

Crea una nueva página. Si el lugar &quot;where&quot; es -1, la página nueva se añade al final
del documento, en cualquier otro caso, se inserta antes de &quot;where&quot;. Los números
de página se cuentan desde 1 en adelante, sin importar cual es el primer número de
página mostrado en tu documento. El parámetro opcional de página maestra
&quot;masterpage&quot; especifica el nombre de la página maestra a aplicar en la nueva
página.

Puede lanzar IndexError si el número de página esta fuera del rango
</translation>
    </message>
    <message>
        <source>currentPage() -&gt; integer

Returns the number of the current working page. Page numbers are counted from 1
upwards, no matter what the displayed first page number of your document is.
</source>
        <translation type="obsolete">currentPage() -&gt; integer

Devuelve el número de la página actual. Los números de página van del 1 en 
adelante, independientemente del número mostrado en la primera página.
</translation>
    </message>
    <message>
        <source>redrawAll()

Redraws all pages.
</source>
        <translation type="obsolete">redrawAll()

Redibuja todas las páginas.
</translation>
    </message>
    <message>
        <source>savePageAsEPS(&quot;name&quot;)

Saves the current page as an EPS to the file &quot;name&quot;.

May raise ScribusError if the save failed.
</source>
        <translation type="obsolete">savePageAsEPS(&quot;name&quot;)

Guarda la página actual como un EPS al archivo &quot;name&quot;.

Puede lanzar la excpeción ScribusError si hubo un error al guardar.
</translation>
    </message>
    <message>
        <source>deletePage(nr)

Deletes the given page. Does nothing if the document contains only one page.
Page numbers are counted from 1 upwards, no matter what the displayed first
page number is.

May raise IndexError if the page number is out of range
</source>
        <translation type="obsolete">deletePage(nr)

Borra la página &quot;nr&quot;. No hace nada si el documento sólo tiene una página. 
Los números de página van del 1 en adelante, independientemente del 
mostrado en la primera página. 

Puede lanzar la excepción IndexError si el número de página está fuera de rango.
</translation>
    </message>
    <message>
        <source>pageCount() -&gt; integer

Returns the number of pages in the document.
</source>
        <translation type="obsolete">pageCount() -&gt; integer

Devuelve el número de páginas del documento.
</translation>
    </message>
    <message>
        <source>getHGuides() -&gt; list

Returns a list containing positions of the horizontal guides. Values are in the
document&apos;s current units - see UNIT_&lt;type&gt; constants.
</source>
        <translation type="obsolete">getHGuides() -&gt; list

Devuelve una lista que contiene las posiciones de las guías horizontales. 
Los valores están en las unidades actuales del documento - ver las 
constantes UNIT_&lt;tipo&gt;.
</translation>
    </message>
    <message>
        <source>setHGuides(list)

Sets horizontal guides. Input parameter must be a list of guide positions
measured in the current document units - see UNIT_&lt;type&gt; constants.

Example: setHGuides(getHGuides() + [200.0, 210.0] # add new guides without any lost
         setHGuides([90,250]) # replace current guides entirely
</source>
        <translation type="obsolete">setHGuides(list)

Establece las guías horizontales. El parámetro debe ser una lista de 
posiciones medidas en las unidades actuales del documento - ver 
las constantes UNIT_&lt;tipo&gt;.

Ejemplo: setHGuides(getHGuides() + [200.0, 210.0] # añade guías sin perder ninguna
         setHGuides([90,250]) # reemplaza las guías actuales
</translation>
    </message>
    <message>
        <source>getVGuides()

See getHGuides.
</source>
        <translation type="obsolete">getVGuides()

Ver getHGuides.
</translation>
    </message>
    <message>
        <source>setVGuides()

See setHGuides.
</source>
        <translation type="obsolete">setVGuides()

Ver setHGuides.
</translation>
    </message>
    <message>
        <source>getPageSize() -&gt; tuple

Returns a tuple with page dimensions measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="obsolete">getPageSize() -&gt; tuple

Devuelve un vector con las dimensiones de página medidas en las unidades 
actuales del documento. Ver las constantes UNIT_&lt;tipo&gt; y getPageMargins()
</translation>
    </message>
    <message>
        <source>getPageItems() -&gt; list

Returns a list of tuples with items on the current page. The tuple is:
(name, objectType, order) E.g. [(&apos;Text1&apos;, 4, 0), (&apos;Image1&apos;, 2, 1)]
means that object named &apos;Text1&apos; is a text frame (type 4) and is the first at
the page...
</source>
        <translation type="obsolete">getPageItems() -&gt; list

Devuelve una lista de vectores con los objetos de la página actual. 
El vector es (nombre, tipoDeObjeto, orden). 
P. ej. [(&apos;Texto1&apos;, 4, 0), (&apos;Imagen1&apos;, 2, 1)] significa que el objeto &apos;Texto1&apos; 
es un marco de texto (tipo 4) y es el primero de la página...
</translation>
    </message>
    <message>
        <source>getPageMargins()

Returns the page margins as a (top, left, right, bottom) tuple in the current
units. See UNIT_&lt;type&gt; constants and getPageSize().
</source>
        <translation type="obsolete">getPageMargins()

Devuelve los márgenes de página como un vector (arriba, izquierda, derecha, abajo) 
en las unidades actuales. Ver las constantes UNIT_&lt;tipo&gt; y getPageSize().
</translation>
    </message>
    <message>
        <source>setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Sets the gradient fill of the object &quot;name&quot; to type. Color descriptions are
the same as for setFillColor() and setFillShade(). See the constants for
available types (FILL_&lt;type&gt;).
</source>
        <translation type="obsolete">setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Establece el degradado de relleno del objeto con nombre &quot;name&quot; como 
tipo &quot;type&quot;. Las descripciones de color son las mismas que para setFillColor() 
y setFillShade(). Ver las constantes FILL_&lt;tipo&gt; para los tipos disponibles.
</translation>
    </message>
    <message>
        <source>setFillColor(&quot;color&quot;, [&quot;name&quot;])

Sets the fill color of the object &quot;name&quot; to the color &quot;color&quot;. &quot;color&quot;
is the name of one of the defined colors. If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="obsolete">setFillColor(&quot;color&quot;, [&quot;name&quot;])

Establece el color de relleno del objeto &quot;name&quot; al color &quot;color&quot;. 
&quot;color&quot; es el nombre de uno de los colores definidos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setLineColor(&quot;color&quot;, [&quot;name&quot;])

Sets the line color of the object &quot;name&quot; to the color &quot;color&quot;. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="obsolete">setLineColor(&quot;color&quot;, [&quot;name&quot;])

Establece el color de línea del objeto &quot;name&quot; al color &quot;color&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setLineWidth(width, [&quot;name&quot;])

Sets line width of the object &quot;name&quot; to &quot;width&quot;. &quot;width&quot; must be in the
range from 0.0 to 12.0 inclusive, and is measured in points. If &quot;name&quot; is not
given the currently selected item is used.

May raise ValueError if the line width is out of bounds.
</source>
        <translation type="obsolete">setLineWidth(width, [&quot;name&quot;])

Establece el ancho de línea del objeto &quot;name&quot; a &quot;width&quot;. &quot;width&quot; debe estar 
en el rango de 0.0 a 12.0 inclusive, y se miede en puntos.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si el ancho de línea está fuera de rango.
</translation>
    </message>
    <message>
        <source>setLineShade(shade, [&quot;name&quot;])

Sets the shading of the line color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full color intensity). If &quot;name&quot; is not given the currently selected item
is used.

May raise ValueError if the line shade is out of bounds.
</source>
        <translation type="obsolete">setLineShade(shade, [&quot;name&quot;])

Establece la saturación del color de línea del objeto &quot;name&quot; a &quot;shade&quot;.
&quot;shade&quot; debe ser un valor entero en el rango de 0 (más claro) a 100
(color de mayor intensidad). 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si la saturación está fuera de rango.
</translation>
    </message>
    <message>
        <source>setLineJoin(join, [&quot;name&quot;])

Sets the line join style of the object &quot;name&quot; to the style &quot;join&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for join - JOIN_&lt;type&gt;.
</source>
        <translation type="obsolete">setLineJoin(join, [&quot;name&quot;])

Establece el estilo de unión de línea del objeto &quot;name&quot; al estilo &quot;join&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
Hay constantes predefinidas para &quot;join&quot; - JOIN_&lt;tipo&gt;.
</translation>
    </message>
    <message>
        <source>setLineEnd(endtype, [&quot;name&quot;])

Sets the line cap style of the object &quot;name&quot; to the style &quot;cap&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for &quot;cap&quot; - CAP_&lt;type&gt;.
</source>
        <translation type="obsolete">setLineEnd(endtype, [&quot;name&quot;])

Establece el estilo de extremo de línea del objeto &quot;name&quot; al estilo &quot;cap&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
Hay constantes predefinidas para &quot;cap&quot; - CAP_&lt;tipo&gt;.
</translation>
    </message>
    <message>
        <source>setLineStyle(style, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the style &quot;style&quot;. If &quot;name&quot;
is not given the currently selected item is used. There are predefined
constants for &quot;style&quot; - LINE_&lt;style&gt;.
</source>
        <translation type="obsolete">setLineStyle(style, [&quot;name&quot;])

Establece el estilo de línea del objeto &quot;name&quot; al estilo &quot;style&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
Hay constantes predefinidas para &quot;style&quot; - LINE_&lt;tipo&gt;.
</translation>
    </message>
    <message>
        <source>setFillShade(shade, [&quot;name&quot;])

Sets the shading of the fill color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full Color intensity). If &quot;name&quot; is not given the currently selected
Item is used.

May raise ValueError if the fill shade is out of bounds.
</source>
        <translation type="obsolete">setFillShade(shade, [&quot;name&quot;])

Establece la saturación del color de relleno del objeto &quot;name&quot; a &quot;shade&quot;.
&quot;shade&quot; debe ser un valor entero en el rango de 0 (más claro) a 100
(color de mayor intensidad). 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si la saturación está fuera de rango.
</translation>
    </message>
    <message>
        <source>setCornerRadius(radius, [&quot;name&quot;])

Sets the corner radius of the object &quot;name&quot;. The radius is expressed
in points. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if the corner radius is negative.
</source>
        <translation type="obsolete">setCornerRadius(radius, [&quot;name&quot;])

Establece el radio de las esquinas del objeto &quot;name&quot;. El radio está 
expreado en puntos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si el radio está fuera de rango.
</translation>
    </message>
    <message>
        <source>setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the named style &quot;namedStyle&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the line style doesn&apos;t exist.
</source>
        <translation type="obsolete">setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Establece el estilo de línea del objeto &quot;name&quot; al estilo de nombre &quot;namedStyle&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción NotFoundError si el estilo de línea no existe.
</translation>
    </message>
    <message>
        <source>createParagraphStyle(...)

Creates a paragraph style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; specifies the name of the paragraphstyle to create

linespacingmode [optional] -&gt; specifies the linespacing mode; possible modes are:

fixed linespacing:          0

automatic linespacing:      1

baseline grid linespacing:  2

linespacing [optional] -&gt; specifies the linespacing if using fixed linespacing

alignment [optional] -&gt; specifies the alignment of the paragraph

-&gt; left:     0

-&gt; center:   1

-&gt; right:    2

-&gt; justify:  3

-&gt; extend:   4

leftmargin [optional], rightmargin [optional] -&gt; specify the margin

gapbefore [optional], gapafter [optional] -&gt; specify the gaps to the heading and following paragraphs

firstindent [optional] -&gt; the indent of the first line

hasdropcap [optional] -&gt; specifies if there are caps (1 = yes, 0 = no)

dropcaplines [optional] -&gt; height (in lines) of the caps if used

dropcapoffset [optional] -&gt; offset of the caps if used

&quot;charstyle&quot; [optional] -&gt; char style to use

</source>
        <translation type="obsolete">createParagraphStyle(...)

Crea un estilo de párrafo. Esta función toma los siguientes parámetros:

&quot;name&quot; [requerido] -&gt; especifica el nombre del estilo de párrafo a crear

linespacingmode [opcional] -&gt; especifica el modo de interlineado; los modos posibles son:

interlineado corregido:             0

interlineado automático:          1

interlineado en base a rejilla:   2

linespacing [opcional] -&gt; especifica el interlineado si se usa interlineado corregido

alignment [opcional] -&gt; especifica la alineación del párrafo

-&gt; izquierda:     0

-&gt; centrado :    1

-&gt; derecha:       2

-&gt; justificado:    3

-&gt; forzado:       4

leftmargin [opcional], rightmargin [opcional] -&gt; especifica los márgenes

gapbefore [opcional], gapafter [opcional] -&gt; especifica el espaciado con el párrafo anterior y posterior

firstindent [opcional] -&gt; la sangría de la primera línea

hasdropcap [opcional] -&gt; especifica si hay mayúsculas (1 = sí, 0 = no)

dropcaplines [opcional] -&gt; altura (en líneas) de las mayúsculas si se usa

dropcapoffset [opcional] -&gt; desplazamiento de las mayúsculas si se usa

&quot;charstyle&quot; [opcional] -&gt; estilo de carácter a usar

</translation>
    </message>
    <message>
        <source>getFontSize([&quot;name&quot;]) -&gt; float

Returns the font size in points for the text frame &quot;name&quot;. If this text
frame has some text selected the value assigned to the first character of
the selection is returned.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getFontSize([&quot;name&quot;]) -&gt; float

Devuelve el tamaño de tipografía en puntos del marco de texto con nombre 
&quot;name&quot;. Si el marco de texto tiene texto seleccionado, devuelve el del 
primer carácter de la selección. 
Si no se le pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getFont([&quot;name&quot;]) -&gt; string

Returns the font name for the text frame &quot;name&quot;. If this text frame
has some text selected the value assigned to the first character
of the selection is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">getFont([&quot;name&quot;]) -&gt; string

Devuelve el nombre de la tipografía del marco de texto &quot;name&quot;. Si el 
marco de texto tiene texto seleccionado, devuelve el del primer 
caracter de la selección. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getTextLength([&quot;name&quot;]) -&gt; integer

Returns the length of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getTextLength([&quot;name&quot;]) -&gt; integer

Devuelve la longitud del texto en el marco de texto &quot;name&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot;. If this text frame has some text
selected, the selected text is returned. All text in the frame, not just
currently visible text, is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">getText([&quot;name&quot;]) -&gt; string

Devuelve el texto del marco de texto &quot;name&quot;.  Si el marco de texto 
tiene texto seleccionado, devuelve el texto seleccionado. Devuelve 
todo el texto del marco, no solo el que se ve actualmente.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getAllText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot; and of all text frames which are
linked with this frame. If this textframe has some text selected, the selected
text is returned. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="obsolete">getAllText([&quot;name&quot;]) -&gt; string

Devuelve el texto del marco de texto &quot;name&quot; y de todos los marcos de texto 
que están enlazados con este marco. Si el marco de texto tiene texto 
seleccionado, devuelve el texto seleccionado.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getLineSpacing([&quot;name&quot;]) -&gt; float

Returns the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; expressed in
points. If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getLineSpacing([&quot;name&quot;]) -&gt; float

Devuelve el interlineado del marco de texto &quot;name&quot; expresado en puntos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getColumnGap([&quot;name&quot;]) -&gt; float

Returns the column gap size of the text frame &quot;name&quot; expressed in points. If
&quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getColumnGap([&quot;name&quot;]) -&gt; float

Devuelve la distancia entre columnas del marco de texto &quot;name&quot; expresado 
en puntos. Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

</translation>
    </message>
    <message>
        <source>getColumns([&quot;name&quot;]) -&gt; integer

Gets the number of columns of the text frame &quot;name&quot;. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="obsolete">getColumns([&quot;name&quot;]) -&gt; integer

Devuelve el número de columnas del marco de texto &quot;name&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setText(&quot;text&quot;, [&quot;name&quot;])

Sets the text of the text frame &quot;name&quot; to the text of the string &quot;text&quot;.
Text must be UTF8 encoded - use e.g. unicode(text, &apos;iso-8859-2&apos;). See the FAQ
for more details. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="obsolete">setText(&quot;text&quot;, [&quot;name&quot;])

Establece el texto del marco de texto &quot;name&quot; al texto de la cadena &quot;text&quot;. 
El texto debe estar codificado en UTF8 - usa p. ej. unicode(&quot;text&quot;, &apos;iso-8859-2&apos;). 
Ver las FAQ para más detalles. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setFont(&quot;font&quot;, [&quot;name&quot;])

Sets the font of the text frame &quot;name&quot; to &quot;font&quot;. If there is some text
selected only the selected text is changed.  If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError if the font cannot be found.
</source>
        <translation type="obsolete">setFont(&quot;font&quot;, [&quot;name&quot;])

Establece la tipografía del marco de texto &quot;name&quot; a &quot;font&quot;. Si hay texto 
seleccionado sólo cambia la del texto seleccionado.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si no se puede encontrar la tipografía.
</translation>
    </message>
    <message>
        <source>setFontSize(size, [&quot;name&quot;])

Sets the font size of the text frame &quot;name&quot; to &quot;size&quot;. &quot;size&quot; is treated
as a value in points. If there is some text selected only the selected text is
changed. &quot;size&quot; must be in the range 1 to 512. If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError for a font size that&apos;s out of bounds.
</source>
        <translation type="obsolete">setFontSize(size, [&quot;name&quot;])

Establece el tamaño de tipografía del marco de texto &quot;name&quot; a &quot;size&quot;. 
&quot;size&quot; debe ser un valor en puntos. Si hay texto seleccionado sólo 
cambia la del texto seleccionado. &quot;size&quot; debe ser un entero en el 
rango 1 a 512. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si el tamaño está fuera de rango.
</translation>
    </message>
    <message>
        <source>setLineSpacing(size, [&quot;name&quot;])

Sets the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; to &quot;size&quot;.
&quot;size&quot; is a value in points. If &quot;name&quot; is not given the currently selected
item is used.

May throw ValueError if the line spacing is out of bounds.
</source>
        <translation type="obsolete">setLineSpacing(size, [&quot;name&quot;])

Establece el interlineado del marco de texto &quot;name&quot; a &quot;size&quot;. 
&quot;size&quot; es un valor en puntos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado. 

Puede lanzar la excepción ValueError si el interlineado está fuera de rango.
</translation>
    </message>
    <message>
        <source>setColumnGap(size, [&quot;name&quot;])

Sets the column gap of the text frame &quot;name&quot; to the value &quot;size&quot;. If
&quot;name&quot; is not given the currently selected item is used.

May throw ValueError if the column gap is out of bounds (must be positive).
</source>
        <translation type="obsolete">setColumnGap(size, [&quot;name&quot;])

Establece la distancia entre columnas del marco de texto &quot;name&quot; al 
valor &quot;size&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si la distancia entre columnas 
está fuera de rango (debe ser positiva).
</translation>
    </message>
    <message>
        <source>setColumns(nr, [&quot;name&quot;])

Sets the number of columns of the text frame &quot;name&quot; to the integer &quot;nr&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May throw ValueError if number of columns is not at least one.
</source>
        <translation type="obsolete">setColumns(nr, [&quot;name&quot;])

Establece el número de columnas del marco de texto &quot;name&quot; al entero &quot;nr&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado. 

Puede lanzar la excepción ValueError si el número de columnas es menor de uno.
</translation>
    </message>
    <message>
        <source>setTextAlignment(align, [&quot;name&quot;])

Sets the text alignment of the text frame &quot;name&quot; to the specified alignment.
If &quot;name&quot; is not given the currently selected item is used. &quot;align&quot; should
be one of the ALIGN_ constants defined in this module - see dir(scribus).

May throw ValueError for an invalid alignment constant.
</source>
        <translation type="obsolete">setTextAlignment(align, [&quot;name&quot;])

Establece el alineamiento del marco de texto &quot;name&quot; al alineamiento 
indicado. &quot;align&quot; debería ser una de las constantes ALIGN_ definidas 
en este módulo - ver dir(scribus).
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si la constante de la alineamiento 
no es válida.
</translation>
    </message>
    <message>
        <source>deleteText([&quot;name&quot;])

Deletes any text in the text frame &quot;name&quot;. If there is some text selected,
only the selected text will be deleted. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">deleteText([&quot;name&quot;])

Borrar el texto del marco de texto &quot;name&quot;. Si hay texto seleccionado sólo 
se borra el texto seleccionado. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setTextColor(&quot;color&quot;, [&quot;name&quot;])

Sets the text color of the text frame &quot;name&quot; to the color &quot;color&quot;. If there
is some text selected only the selected text is changed. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="obsolete">setTextColor(&quot;color&quot;, [&quot;name&quot;])

Establece el color del texto marco de texto &quot;name&quot; al color &quot;color&quot;. Si 
hay texto seleccionado sólo se cambia el texto seleccionado. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Set &quot;color&quot; of the text stroke. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Establece el color del trazo del texto a &quot;color&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setTextShade(shade, [&quot;name&quot;])

Sets the shading of the text color of the object &quot;name&quot; to &quot;shade&quot;. If
there is some text selected only the selected text is changed. &quot;shade&quot; must
be an integer value in the range from 0 (lightest) to 100 (full color
intensity). If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="obsolete">setTextShade(shade, [&quot;name&quot;])

Establece la saturación del color del texto del objeto &quot;name&quot; a &quot;shade&quot;. 
Si hay texto seleccionado, sólo cambia el texto seleccionado. &quot;shade&quot; 
debe ser un valor entero en el rango de 0 (más claro) a 100 (color de 
mayor intensidad).
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Link two text frames. The frame named &quot;fromname&quot; is linked to the
frame named &quot;toname&quot;. The target frame must be an empty text frame
and must not link to or be linked from any other frames already.

May throw ScribusException if linking rules are violated.
</source>
        <translation type="obsolete">linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Enlaza dos marcos de texto. El marco llamado &quot;fromname&quot; se enlaza al marco 
llamado &quot;toname&quot;. El marco de destino debe ser un marco de texto vacío y 
no debe estar enlazado a otros ni desde otros marcos de texto.

Puede lanzar la excepción ScribusException si se violan las reglas de enlazado.
</translation>
    </message>
    <message>
        <source>unlinkTextFrames(&quot;name&quot;)

Remove the specified (named) object from the text frame flow/linkage. If the
frame was in the middle of a chain, the previous and next frames will be
connected, eg &apos;a-&gt;b-&gt;c&apos; becomes &apos;a-&gt;c&apos; when you unlinkTextFrames(b)&apos;

May throw ScribusException if linking rules are violated.
</source>
        <translation type="obsolete">unlinkTextFrames(&quot;name&quot;)

Elimina el objeto &quot;name&quot; del flujo de enlazado de marcos de texto. Si el 
marco estaba en medio de una cadena, los marcos anterior y siguiente 
se enlazarán, p. ej. &apos;a-&gt;b-&gt;c&apos; pasa a ser &apos;a-&gt;c&apos; al ejecutar unlinkTextFrames(b) 

Puede lanzar la excepción ScribusException si se violan las reglas de enlazado.
</translation>
    </message>
    <message>
        <source>traceText([&quot;name&quot;])

Convert the text frame &quot;name&quot; to outlines. If &quot;name&quot; is not given the
currently selected item is used.</source>
        <translation type="obsolete">traceText([&quot;name&quot;])

Convierte el marco de texto &quot;name&quot; a contornos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>isPDFBookmark([&quot;name&quot;]) -&gt; bool

Returns true if the text frame &quot;name&quot; is a PDF bookmark.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="obsolete">isPDFBookmark([&quot;name&quot;]) -&gt; bool

Devuelve si el marco de texto &quot;name&quot; es un marcador de PDF. 
Si no se pasa &quot;name&quot; se usa el objeto actualmente seleccionado.

Puede lanzar la excepción WrongFrameTypeError si el marco de destino 
no es un marco de texto.
</translation>
    </message>
    <message>
        <source>messagebarText(&quot;string&quot;)

Writes the &quot;string&quot; into the Scribus message bar (status line). The text
must be UTF8 encoded or &apos;unicode&apos; string(recommended).
</source>
        <translation type="obsolete">messagebarText(&quot;string&quot;)

Escribe la cadena &quot;string&quot; en la barra de mensaje (barra de estado) de Scribus. 
El texto debe estar codificado en UTF8 o &apos;unicode&apos; (recomendado).
</translation>
    </message>
    <message>
        <source>progressReset()

Cleans up the Scribus progress bar previous settings. It is called before the
new progress bar use. See progressSet.
</source>
        <translation type="obsolete">progressReset()

Borra la barra de progreso de Scribus. Se llama antes de usar 
la barra de progreso. Ver progressSet.
</translation>
    </message>
    <message>
        <source>progressTotal(max)

Sets the progress bar&apos;s maximum steps value to the specified number.
See progressSet.
</source>
        <translation type="obsolete">progressTotal(max)

Establece el máximo número de pasos de la barra de progreso al 
número especificado. Ver progressSet.
</translation>
    </message>
    <message>
        <source>progressSet(nr)

Set the progress bar position to &quot;nr&quot;, a value relative to the previously set
progressTotal. The progress bar uses the concept of steps; you give it the
total number of steps and the number of steps completed so far and it will
display the percentage of steps that have been completed. You can specify the
total number of steps with progressTotal(). The current number of steps is set
with progressSet(). The progress bar can be rewound to the beginning with
progressReset(). [based on info taken from Trolltech&apos;s Qt docs]
</source>
        <translation type="obsolete">progressSet(nr)

Establece la posición de la barra de progreso a &quot;nr&quot;, un valor relativo a 
lo puesto anteriormente con progressTotal. La barra de progreso usa el 
concepto de pasos, se le dice el número de pasos totales y el número 
pasos completado y mostrará el porcentaje de pasos que se han 
completado. Se puede especificar el número de pasos con progressTotal(). 
El número actual de pasos se establece con progressSet(). Se rebobina al 
principio con progressReset(). 
[basado en la información tomada de la documentación de Qt de Trolltech]
</translation>
    </message>
    <message>
        <source>setCursor()

[UNSUPPORTED!] This might break things, so steer clear for now.
</source>
        <translation type="obsolete">setCursor()

[¡NO SOPORTADO!] 
Esto podría romper cosas, así que no se utiliza de momento.
</translation>
    </message>
    <message>
        <source>docChanged(bool)

Enable/disable save icon in the Scribus icon bar and the Save menu item. It&apos;s
useful to call this procedure when you&apos;re changing the document, because Scribus
won&apos;t automatically notice when you change the document using a script.
</source>
        <translation type="obsolete">docChanged(bool)

Activa o desactiva el icono de guardar en la barra de iconos de Scribs y la 
opción de menú Guardar. Es útil llamarlo cuando estás cambiando el documento, 
porque Scribus no notará automáticamente cuando se cambie el documento 
con un script.
</translation>
    </message>
    <message>
        <source>placeSVG(&quot;filename&quot;, x, y)

Places the SVG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SVG placed on the page

If loading was successful, the selection contains the imported SVG
</source>
        <translation type="obsolete">placeSVG(&quot;filename&quot;, x, y)

Inserta el archivo &quot;filename&quot; SVG en la página actual,
x e y indican las coordenadas de la esquina superior derecha del SVG insertado en la página

Si la carga fue correta, la selección contiene el SVG importado
</translation>
    </message>
</context>
<context>
    <name>@default</name>
    <message>
        <source>getColorNames() -&gt; list

Returns a list containing the names of all defined colors in the document.
If no document is open, returns a list of the default document colors.
</source>
        <translation type="obsolete">getColorNames() -&gt; list

Devuelve una lista que contiene los nombres de todos los colores definidos 
en el documento. Si no hay abierto ningún documento, devuelve una lista de 
los colores del documento por defecto.
</translation>
    </message>
    <message>
        <source>newDocDialog() -&gt; bool

Displays the &quot;New Document&quot; dialog box. Creates a new document if the user
accepts the settings. Does not create a document if the user presses cancel.
Returns true if a new document was created.
</source>
        <translation type="obsolete">newDocDialog() -&gt; bool

Muestra el diálogo &quot;Nuevo Documento&quot;. Crea un nuevo documento si el 
usuario presiona Aceptar. No lo crea si presiona Cancelar. Devuelve true 
si se crea un nuevo documento.</translation>
    </message>
    <message>
        <source>getFillColor([&quot;name&quot;]) -&gt; string

Returns the name of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getFillColor([&quot;name&quot;]) -&gt; string

Devuelve el nombre del color de relleno del objeto con nombre&quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>moveObject(dx, dy [, &quot;name&quot;])

Moves the object &quot;name&quot; by dx and dy relative to its current position. The
distances are expressed in the current measurement unit of the document (see
UNIT constants). If &quot;name&quot; is not given the currently selected item is used.
If the object &quot;name&quot; belongs to a group, the whole group is moved.
</source>
        <translation type="obsolete">moveObject(dx, dy [, &quot;name&quot;])

Mueve el objeto de nombre &quot;name&quot; dx y dy unidades, relativo a su posición 
actual. Las distancias se deben expresar en las unidades actuales del 
documento (ver constantes UNIT). Si no se pasa un nombre, se usa el objeto 
que esté seleccionado. Si el objeto &quot;name&quot; pertenece a un grupo, se 
mueve el grupo entero.
</translation>
    </message>
    <message>
        <source>setRedraw(bool)

Disables page redraw when bool = False, otherwise redrawing is enabled.
This change will persist even after the script exits, so make sure to call
setRedraw(True) in a finally: clause at the top level of your script.
</source>
        <translation type="obsolete">setRedraw(bool)

Desactiva el redibujado de la página si bool = False, de otro modo, se activa 
el redibujado. Este cambio permanecerá incluso después de que el script 
termine, así que asegúrate de llamar a setRedraw(True) en una sentencia 
finally: en el nivel superior del script.
</translation>
    </message>
    <message>
        <source>createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new rectangle on the current page and returns its name. The
coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name to reference that object in future. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Crea un nuevo rectángulo en la página actual y devuelve su nombre. Las 
coordenadas x, y, anchura y altura se expresan en las unidades actuales 
del documento (ver constantes UNIT). &quot;name&quot; debería ser un identificador 
único para el objeto porque el objeto se referenciará con ese nombre 
después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar NameExistsError si se pasa un nombre que ya se está usando.
</translation>
    </message>
    <message>
        <source>setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Sets the gradient fill of the object &quot;name&quot; to type. Color descriptions are
the same as for setFillColor() and setFillShade(). See the constants for
available types (FILL_&lt;type&gt;).
</source>
        <translation type="obsolete">setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Establece el degradado de relleno del objeto con nombre &quot;name&quot; como 
tipo &quot;type&quot;. Las descripciones de color son las mismas que para setFillColor() 
y setFillShade(). Ver las constantes FILL_&lt;tipo&gt; para los tipos disponibles.
</translation>
    </message>
    <message>
        <source>getFontSize([&quot;name&quot;]) -&gt; float

Returns the font size in points for the text frame &quot;name&quot;. If this text
frame has some text selected the value assigned to the first character of
the selection is returned.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getFontSize([&quot;name&quot;]) -&gt; float

Devuelve el tamaño de tipografía en puntos del marco de texto con nombre 
&quot;name&quot;. Si el marco de texto tiene texto seleccionado, devuelve el del 
primer carácter de la selección. 
Si no se le pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>messagebarText(&quot;string&quot;)

Writes the &quot;string&quot; into the Scribus message bar (status line). The text
must be UTF8 encoded or &apos;unicode&apos; string(recommended).
</source>
        <translation type="obsolete">messagebarText(&quot;string&quot;)

Escribe la cadena &quot;string&quot; en la barra de mensaje (barra de estado) de Scribus. 
El texto debe estar codificado en UTF8 o &apos;unicode&apos; (recomendado).
</translation>
    </message>
    <message>
        <source>newPage(where [,&quot;masterpage&quot;])

Creates a new page. If &quot;where&quot; is -1 the new Page is appended to the
document, otherwise the new page is inserted before &quot;where&quot;. Page numbers are
counted from 1 upwards, no matter what the displayed first page number of your
document is. The optional parameter &quot;masterpage&quot; specifies the name of the
master page for the new page.

May raise IndexError if the page number is out of range
</source>
        <translation type="obsolete">newPage(where [,&quot;masterpage&quot;])

Crea una nueva página. Si el lugar &quot;where&quot; es -1, la página nueva se añade al final
del documento, en cualquier otro caso, se inserta antes de &quot;where&quot;. Los números
de página se cuentan desde 1 en adelante, sin importar cual es el primer número de
página mostrado en tu documento. El parámetro opcional de página maestra
&quot;masterpage&quot; especifica el nombre de la página maestra a aplicar en la nueva
página.

Puede lanzar IndexError si el número de página esta fuera del rango
</translation>
    </message>
    <message>
        <source>newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Creates a new document and returns true if successful. The parameters have the
following meaning:

size = A tuple (width, height) describing the size of the document. You can
use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

margins = A tuple (left, right, top, bottom) describing the document
margins

orientation = the page orientation - constants PORTRAIT, LANDSCAPE

firstPageNumer = is the number of the first page in the document used for
pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
numbers if you&apos;re creating a document in several parts.

unit: this value sets the measurement units used by the document. Use a
predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
UNIT_PICAS, UNIT_POINTS.

pagesType = One of the predefined constants PAGE_n. PAGE_1 is single page,
PAGE_2 is for double sided documents, PAGE_3 is for 3 pages fold and
PAGE_4 is 4-fold.

firstPageOrder = What is position of first page in the document.
Indexed from 0 (0 = first).

numPage = Number of pages to be created.

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS,
PAGE_4, 3, 1)

May raise ScribusError if is firstPageOrder bigger than allowed by pagesType.
</source>
        <translation type="obsolete">newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Crea un nuevo documento y devuelve true si tiene éxito. Los parámetros tienen 
el siguiente significado:

size = Un par (ancho, alto) que describe el tamaño del documento. Se 
pueden usar constantes predefinidas llamadas PAPER_&lt;tipo_de_papel&gt; 
p. ej. PAPER_A4 etc.

margins = Un vector (izquierda, derecha, arriba, abajo) que describe 
los márgenes del documento

orientation = La orientación de la página - constantes PORTRAIT (vertical), 
LANDSCAPE (apasaido)

firstPageNumber = Es el número de la primera página del documento 
usado para la numeración de páginas. Aunque normalmente será 1, es útil 
para tener números mayores si se crea un documento en varias partes.

unit: Este valor establece las unidades de medida usadas por el 
documento. Usa una de estas constantes predefinidas para ello: 
UNIT_INCHES (pulgadas), UNIT_MILLIMETERS (milímetros), 
UNIT_PICAS (picas), UNIT_POINTS (puntos).

pagesType = Una de las constantes predefinidas PAGE_n. PAGE_1 es una
página simple, PAGE_2 es para documentos a doble página, PAGE_3 es para
trípticos y PAGE_4 es para cuatro páginas.

firstPageOrder = Cuál es la posición de la primera página del documento.
Indizadas desde 0 (0 = primera).

numPage = Número de páginas a crear.

Los valores para la anchura, altura y los márgenes están expresados en la unidad 
dada para el documento. Las constantes PAPER_* están expresadas en puntos. Si 
tu documento no está en puntos, asegurate de tenerlo en cuenta. 

ejemplo: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS, 
PAGE_4, 3, 1)

Puede lanzar ScribusError si firstPageOrder es mayor que el permitido por pagesType.
</translation>
    </message>
    <message>
        <source>placeSVG(&quot;filename&quot;, x, y)

Places the SVG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SVG placed on the page

If loading was successful, the selection contains the imported SVG
</source>
        <translation type="obsolete">placeSVG(&quot;filename&quot;, x, y)

Inserta el archivo &quot;filename&quot; SVG en la página actual,
x e y indican las coordenadas de la esquina superior derecha del SVG insertado en la página

Si la carga fue correta, la selección contiene el SVG importado
</translation>
    </message>
    <message>
        <source>createParagraphStyle(...)

Creates a paragraph style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; specifies the name of the paragraphstyle to create

linespacingmode [optional] -&gt; specifies the linespacing mode; possible modes are:

fixed linespacing:          0

automatic linespacing:      1

baseline grid linespacing:  2

linespacing [optional] -&gt; specifies the linespacing if using fixed linespacing

alignment [optional] -&gt; specifies the alignment of the paragraph

-&gt; left:     0

-&gt; center:   1

-&gt; right:    2

-&gt; justify:  3

-&gt; extend:   4

leftmargin [optional], rightmargin [optional] -&gt; specify the margin

gapbefore [optional], gapafter [optional] -&gt; specify the gaps to the heading and following paragraphs

firstindent [optional] -&gt; the indent of the first line

hasdropcap [optional] -&gt; specifies if there are caps (1 = yes, 0 = no)

dropcaplines [optional] -&gt; height (in lines) of the caps if used

dropcapoffset [optional] -&gt; offset of the caps if used

&quot;charstyle&quot; [optional] -&gt; char style to use

</source>
        <translation type="obsolete">createParagraphStyle(...)

Crea un estilo de párrafo. Esta función toma los siguientes parámetros:

&quot;name&quot; [requerido] -&gt; especifica el nombre del estilo de párrafo a crear

linespacingmode [opcional] -&gt; especifica el modo de interlineado; los modos posibles son:

interlineado corregido:             0

interlineado automático:          1

interlineado en base a rejilla:   2

linespacing [opcional] -&gt; especifica el interlineado si se usa interlineado corregido

alignment [opcional] -&gt; especifica la alineación del párrafo

-&gt; izquierda:     0

-&gt; centrado :    1

-&gt; derecha:       2

-&gt; justificado:    3

-&gt; forzado:       4

leftmargin [opcional], rightmargin [opcional] -&gt; especifica los márgenes

gapbefore [opcional], gapafter [opcional] -&gt; especifica el espaciado con el párrafo anterior y posterior

firstindent [opcional] -&gt; la sangría de la primera línea

hasdropcap [opcional] -&gt; especifica si hay mayúsculas (1 = sí, 0 = no)

dropcaplines [opcional] -&gt; altura (en líneas) de las mayúsculas si se usa

dropcapoffset [opcional] -&gt; desplazamiento de las mayúsculas si se usa

&quot;charstyle&quot; [opcional] -&gt; estilo de carácter a usar

</translation>
    </message>
    <message>
        <source>getColor(&quot;name&quot;) -&gt; tuple

Returns a tuple (C, M, Y, K) containing the four color components of the
color &quot;name&quot; from the current document. If no document is open, returns
the value of the named color from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">getColor(&quot;name&quot;) -&gt; tuple

Devuelve un vector (C, M, Y, K) que tiene las cuatro componentes de 
color del color &quot;name&quot; del documento actual. Si no hay un documento 
abierto, usa los colores del documento por defecto. 

Puede lanzar NotFoundError si no se encuentra el color indicado. 
Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>changeColor(&quot;name&quot;, c, m, y, k)

Changes the color &quot;name&quot; to the specified CMYK value. The color value is
defined via four components c = Cyan, m = Magenta, y = Yellow and k = Black.
Color components should be in the range from 0 to 255.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">changeColor(&quot;name&quot;, c, m, y, k)

Cambia el color &quot;name&quot; al valor CMYK especificado. El valor del color 
se define mediante cuatro componentes: c = cian, m = magenta, 
y = amarillo y k = negro. Las componentes deberían estar en el 
rango 0 a 255. 

Puede lanzar NotFoundError si no se encuentra el color indicado. 
Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>defineColor(&quot;name&quot;, c, m, y, k)

Defines a new color &quot;name&quot;. The color Value is defined via four components:
c = Cyan, m = Magenta, y = Yellow and k = Black. Color components should be in
the range from 0 to 255.

May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">defineColor(&quot;name&quot;, c, m, y, k)

Define un nuevo color llamado &quot;name&quot;. El valor del color se define mediante 
cuatro componentes: c = cian, m = magenta, y = amarillo y k = negro. 
Las componentes deberían estar en el rango 0 a 255. 

Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>deleteColor(&quot;name&quot;, &quot;replace&quot;)

Deletes the color &quot;name&quot;. Every occurence of that color is replaced by the
color &quot;replace&quot;. If not specified, &quot;replace&quot; defaults to the color
&quot;None&quot; - transparent.

deleteColor works on the default document colors if there is no document open.
In that case, &quot;replace&quot;, if specified, has no effect.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">deleteColor(&quot;name&quot;, &quot;replace&quot;)

Borra el color &quot;name&quot;. Cada aparición de ese color se reemplaza 
con el color &quot;replace&quot;. Si no se especifica, se reemplaza por el 
color &quot;Ninguno&quot; - transparente.

Si no hay ningún documento abierto, deleteColor funciona sobre los 
colores del documento por defecto. En ese caso, aunque se indique,
&quot;replace&quot; no tiene efecto.

Puede lanzar NotFoundError si no se encuentra el color indicado. 
Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>replaceColor(&quot;name&quot;, &quot;replace&quot;)

Every occurence of the color &quot;name&quot; is replaced by the color &quot;replace&quot;.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="obsolete">replaceColor(&quot;name&quot;, &quot;replace&quot;)

Cada aparición del color &quot;name&quot; se reemplaza por el color &quot;replace&quot;.

Puede lanzar NotFoundError si no se encuentra el color indicado. 
Puede lanzar ValueError si se especifica un nombre no válido.
</translation>
    </message>
    <message>
        <source>messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Displays a message box with the title &quot;caption&quot;, the message &quot;message&quot;, and
an icon &quot;icon&quot; and up to 3 buttons. By default no icon is used and a single
button, OK, is displayed. Only the caption and message arguments are required,
though setting an icon and appropriate button(s) is strongly
recommended. The message text may contain simple HTML-like markup.

Returns the number of the button the user pressed. Button numbers start
at 1.

For the icon and the button parameters there are predefined constants available
with the same names as in the Qt Documentation. These are the BUTTON_* and
ICON_* constants defined in the module. There are also two extra constants that
can be binary-ORed with button constants:
    BUTTONOPT_DEFAULT   Pressing enter presses this button.
    BUTTONOPT_ESCAPE    Pressing escape presses this button.

Usage examples:
result = messageBox(&apos;Script failed&apos;,
                    &apos;This script only works when you have a text frame selected.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Defined button and icon constants:
BUTTON_NONE, BUTTON_ABORT, BUTTON_CANCEL, BUTTON_IGNORE, BUTTON_NO,
BUTTON_NOALL, BUTTON_OK, BUTTON_RETRY, BUTTON_YES, BUTTON_YESALL,
ICON_NONE, ICON_INFORMATION, ICON_WARNING, ICON_CRITICAL.
</source>
        <translation type="obsolete">messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Muestra un cuadro de mensaje con el título &quot;caption&quot;, el mensaje &quot;message&quot;, 
un icono &quot;icon&quot; y hasta 3 botones. Por defecto no se usa ningún icono y sólo 
hay un botón, Aceptar. Sólo son obligatorios los parámetros caption y message, 
sin embargo se recomienda definir un icono y el botón o botones apropiados. 
El mensaje puede contener etiquetas simples similares a las de HTML.

Devuelve el número del botón que presionó el usuario. Los números de los 
botones empiezan en 1. 

Para los parámetros del icono y de los botones hay constantes predefinidas 
disponibles con los mismos nombres que en la Documentación de Qt. Son las 
constantes BUTTON_* e ICON_* definidas en el módulo. Hay también otras 
dos constantes extra que pueden ser combinadas con un OR binario con las 
constantes de los botones: 
    BUTTONOPT_DEFAULT   Presionar intro presiona este botón.
    BUTTONOPT_ESCAPE    Presionar escape presiona este botón.

Ejemplos de uso: 
result = messageBox(&apos;Error en Script&apos;,
                    &apos;Este scrpt sólo funciona cuando tienes un marco de texto seleccionado.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Botones definidos y constantes de iconos:
BUTTON_NONE (ninguno), BUTTON_ABORT (abortar), BUTTON_CANCEL (cancelar), 
BUTTON_IGNORE (ignorar), BUTTON_NO (no), BUTTON_NOALL (no a todo), 
BUTTON_OK (aceptar), BUTTON_RETRY (reintentar), BUTTON_YES (sí), 
BUTTON_YESALL (sí a todo), ICON_NONE (ninguno), ICON_INFORMATION (información),
ICON_WARNING (aviso).
</translation>
    </message>
    <message>
        <source>valueDialog(caption, message [,defaultvalue]) -&gt; string

Shows the common &apos;Ask for string&apos; dialog and returns its value as a string
Parameters: window title, text in the window and optional &apos;default&apos; value.

Example: valueDialog(&apos;title&apos;, &apos;text in the window&apos;, &apos;optional&apos;)
</source>
        <translation type="obsolete">valueDialog(caption, message [,defaultvalue]) -&gt; string

Muestra el diálogo &apos;Introducir una cadena&apos; y devuelve su valor 
como un string. 
Parámetros: título de la ventana, texto de la ventana y un valor 
por defecto opcional. 

Ejemplo: valueDialog(&apos;título&apos;, &apos;texto de la ventana&apos;, &apos;opcional&apos;)
</translation>
    </message>
    <message>
        <source>closeDoc()

Closes the current document without prompting to save.

May throw NoDocOpenError if there is no document to close
</source>
        <translation type="obsolete">closeDoc()

Cierra el documento actual sin preguntar para guardar.

Puede lanzar NoDocOpenError si no hay ningún 
documento que cerrar
</translation>
    </message>
    <message>
        <source>haveDoc() -&gt; bool

Returns true if there is a document open.
</source>
        <translation type="obsolete">haveDoc() -&gt; bool

Devuelve true si hay un documento abierto.</translation>
    </message>
    <message>
        <source>openDoc(&quot;name&quot;)

Opens the document &quot;name&quot;.

May raise ScribusError if the document could not be opened.
</source>
        <translation type="obsolete">openDoc(&quot;name&quot;)

Abre el documento &quot;name&quot;.

Puede lanzar la excepción ScribusError si el documento no se puede abrir.
</translation>
    </message>
    <message>
        <source>saveDoc()

Saves the current document with its current name, returns true if successful.
If the document has not already been saved, this may bring up an interactive
save file dialog.

If the save fails, there is currently no way to tell.
</source>
        <translation type="obsolete">saveDoc()

Guarda el documento actual con su nombre actual, y devuelve true si se 
guarda correctamente. Si el documento no se había guardado todavía, 
muestra un diálogo de guardar archivo. 

Si se produce un error al guardar, actualmente no hay forma de informarlo.
</translation>
    </message>
    <message>
        <source>saveDocAs(&quot;name&quot;)

Saves the current document under the new name &quot;name&quot; (which may be a full or
relative path).

May raise ScribusError if the save fails.
</source>
        <translation type="obsolete">saveDocAs(&quot;name&quot;)

Guarda el documento actual con el nombre &quot;name&quot; (que puede ser un ruta 
absoluta o relativa).

Puede lanzar la excepción ScribusError si se produce un error al guardar.
</translation>
    </message>
    <message>
        <source>setUnit(type)

Changes the measurement unit of the document. Possible values for &quot;unit&quot; are
defined as constants UNIT_&lt;type&gt;.

May raise ValueError if an invalid unit is passed.
</source>
        <translation type="obsolete">setUnit(type)

Cambia las unidades de medida del documento. Los valores posibles para &quot;unit&quot; 
son las constantes UNIT_&lt;tipo&gt;.

Puede lanzar una excepción ValueError si se pasa una unidad no válida.
</translation>
    </message>
    <message>
        <source>getUnit() -&gt; integer (Scribus unit constant)

Returns the measurement units of the document. The returned value will be one
of the UNIT_* constants:
UNIT_INCHES, UNIT_MILLIMETERS, UNIT_PICAS, UNIT_POINTS.
</source>
        <translation type="obsolete">getUnit() -&gt; integer (constante de unidad de Scribus)

Devuelve las unidades de medida del documento. El valor devuelto será una 
de las constantes UNIT_*:
UNIT_INCHES (pulgadas), UNIT_MILLIMETERS (milimetros), 
UNIT_PICAS (picas), UNIT_POINTS (puntos).
</translation>
    </message>
    <message>
        <source>loadStylesFromFile(&quot;filename&quot;)

Loads paragraph styles from the Scribus document at &quot;filename&quot; into the
current document.
</source>
        <translation type="obsolete">loadStylesFromFile(&quot;filename&quot;)

Carga en el documento actual los estilos de párrafo del documento 
de Scribus que se encuentra en &quot;filename&quot;.
</translation>
    </message>
    <message>
        <source>setDocType(facingPages, firstPageLeft)

Sets the document type. To get facing pages set the first parameter to
FACINGPAGES, to switch facingPages off use NOFACINGPAGES instead.  If you want
to be the first page a left side set the second parameter to FIRSTPAGELEFT, for
a right page use FIRSTPAGERIGHT.
</source>
        <translation type="obsolete">setDocType(facingPages, firstPageLeft)

Establece el tipo de documento. Para que las páginas se muestren enfrentadas 
el primer parámetro debe ser FACINGPAGES, para desactivar las páginas 
enfrentadas debe ser NOFACINGPAGES. Si se quiere que la primera página esté 
a la izquierda el segundo parámetro debe ser FIRSTPAGELEFT, para que esté a 
la derecha debe ser FIRSTPAGERIGHT.
</translation>
    </message>
    <message>
        <source>getLineColor([&quot;name&quot;]) -&gt; string

Returns the name of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getLineColor([&quot;name&quot;]) -&gt; string

Devuelve el nombre del color de línea del objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getLineWidth([&quot;name&quot;]) -&gt; integer

Returns the line width of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="obsolete">getLineWidth([&quot;name&quot;]) -&gt; integer

Devuelve el ancho de línea del objeto &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getLineShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getLineShade([&quot;name&quot;]) -&gt; integer

Devuelve la intesnsidad del color de línea del objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getLineEnd([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line cap style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. The cap types are:
CAP_FLAT, CAP_ROUND, CAP_SQUARE
</source>
        <translation type="obsolete">getLineEnd([&quot;name&quot;]) -&gt; integer (ver constantes)

Devuelve el estilo de extremo de línea del objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
Los tipos de extremo son: 
CAP_FLAT (plano), CAP_ROUND (redondeado), CAP_SQUARE (cuadrado)
</translation>
    </message>
    <message>
        <source>getLineStyle([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. Line style constants are:
LINE_DASH, LINE_DASHDOT, LINE_DASHDOTDOT, LINE_DOT, LINE_SOLID
</source>
        <translation type="obsolete">getLineStyle([&quot;name&quot;]) -&gt; integer (ver constantes)

Devuelve el estilo de línea del objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado. 
Las constantes de estilos de línea son:
LINE_DASH (a trazos), LINE_DASHDOT (raya punto), 
LINE_DASHDOTDOT (raya punto punto), LINE_DOT (a puntos), 
LINE_SOLID (sólida)
</translation>
    </message>
    <message>
        <source>getFillShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getFillShade([&quot;name&quot;]) -&gt; integer

Devuelve el valor de saturación del color de relleno del objeto &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getCornerRadius([&quot;name&quot;]) -&gt; integer

Returns the corner radius of the object &quot;name&quot;. The radius is
expressed in points. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">getCornerRadius([&quot;name&quot;]) -&gt; integer

Devuelve el radio de las esquinas del objeto &quot;name&quot;. 
El radio se expresa en puntos.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getImageScale([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple containing the scaling values of the image frame
&quot;name&quot;.  If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getImageScale([&quot;name&quot;]) -&gt; (x,y)

Devuelve un par (x, y) que contiene los valores de escalado del 
marco de imagen &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getImageName([&quot;name&quot;]) -&gt; string

Returns the filename for the image in the image frame. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="obsolete">getImageName([&quot;name&quot;]) -&gt; string

Devuelve el nombre de archivo de la imagen en el marco de imagen &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getPosition([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple with the position of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
The position is expressed in the actual measurement unit of the document
- see UNIT_&lt;type&gt; for reference.
</source>
        <translation type="obsolete">getPosition([&quot;name&quot;]) -&gt; (x,y)

Devuelve un par (x, y) con la posición del objeto &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
Las posiciones están expresadas en las unidades actuales del documento 
- ver UNIT_&lt;tipo&gt; para más referencias.
</translation>
    </message>
    <message>
        <source>getSize([&quot;name&quot;]) -&gt; (width,height)

Returns a (width, height) tuple with the size of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. The size is
expressed in the current measurement unit of the document - see UNIT_&lt;type&gt;
for reference.
</source>
        <translation type="obsolete">getSize([&quot;name&quot;]) -&gt; (width,height)

Devuelve un par (ancho, alto) con el tamaño del objeto &quot;name&quot;.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
El tamaño está expresado en las unidades actuales del documento 
- ver UNIT_&lt;tipo&gt; para más referencias.
</translation>
    </message>
    <message>
        <source>getRotation([&quot;name&quot;]) -&gt; integer

Returns the rotation of the object &quot;name&quot;. The value is expressed in degrees,
and clockwise is positive. If &quot;name&quot; is not given the currently selected item
is used.
</source>
        <translation type="obsolete">getRotation([&quot;name&quot;]) -&gt; integer

Devuelve la rotación del objeto &quot;name&quot;. El valor está expresado 
en grados y si es positivo es en el sentido de las agujas del reloj.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getAllObjects() -&gt; list

Returns a list containing the names of all objects on the current page.
</source>
        <translation type="obsolete">getAllObjects() -&gt; list

Devuelve una lista que contiene los nombres de todos los objetos 
de la página actual.
</translation>
    </message>
    <message>
        <source>moveObjectAbs(x, y [, &quot;name&quot;])

Moves the object &quot;name&quot; to a new location. The coordinates are expressed in
the current measurement unit of the document (see UNIT constants).  If &quot;name&quot;
is not given the currently selected item is used.  If the object &quot;name&quot;
belongs to a group, the whole group is moved.
</source>
        <translation type="obsolete">moveObjectAbs(x, y [, &quot;name&quot;])

Mueve el objeto &quot;name&quot; a una nueva posición. Las coordenadas están 
expresadas en las unidades actuales del documento (ver constantes UNIT).
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
Si el objeto a mover pertenece a un grupo, se mueve todo el grupo.
</translation>
    </message>
    <message>
        <source>rotateObjectAbs(rot [, &quot;name&quot;])

Sets the rotation of the object &quot;name&quot; to &quot;rot&quot;. Positive values
mean counter clockwise rotation. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">rotateObjectAbs(rot [, &quot;name&quot;])

Establece la rotación del objeto &quot;name&quot; a &quot;rot&quot;. Los valores positivos 
significan rotación en sentido contrario a las agujas del reloj.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>sizeObject(width, height [, &quot;name&quot;])

Resizes the object &quot;name&quot; to the given width and height. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="obsolete">sizeObject(width, height [, &quot;name&quot;])

Redimensiona el objeto &quot;name&quot; a la anchura (width) y altura (height) dados.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getSelectedObject([nr]) -&gt; string

Returns the name of the selected object. &quot;nr&quot; if given indicates the number
of the selected object, e.g. 0 means the first selected object, 1 means the
second selected Object and so on.
</source>
        <translation type="obsolete">getSelectedObject([nr]) -&gt; string

Devuelve el nombre del objeto seleccionado. &quot;nr&quot;, si se especifica, indica 
el número del objeto seleccionado, p. ej. 0 significa el primer objeto 
seleccionado, 1 el segundo objeto seleccionado, etc.
</translation>
    </message>
    <message>
        <source>selectionCount() -&gt; integer

Returns the number of selected objects.
</source>
        <translation type="obsolete">selectionCount() -&gt; integer

Devuelve el número de objetos seleccionados.
</translation>
    </message>
    <message>
        <source>selectObject(&quot;name&quot;)

Selects the object with the given &quot;name&quot;.
</source>
        <translation type="obsolete">selectObject(&quot;name&quot;)

Selecciona el objeto con el nombre &quot;name&quot;.
</translation>
    </message>
    <message>
        <source>deselectAll()

Deselects all objects in the whole document.
</source>
        <translation type="obsolete">deselectAll()

Deselecciona todos los objetos del documento entero.
</translation>
    </message>
    <message>
        <source>groupObjects(list)

Groups the objects named in &quot;list&quot; together. &quot;list&quot; must contain the names
of the objects to be grouped. If &quot;list&quot; is not given the currently selected
items are used.
</source>
        <translation type="obsolete">groupObjects(list)

Agrupa los objetos nombrados en &quot;list&quot;. &quot;list&quot; debe contener los nombres 
de los objetos a ser agrupados. 
Si no se pasa una lista se usan los objetos que estén seleccionados.
</translation>
    </message>
    <message>
        <source>unGroupObjects(&quot;name&quot;)

Destructs the group the object &quot;name&quot; belongs to.If &quot;name&quot; is not given the currently selected item is used.</source>
        <translation type="obsolete">unGroupObjects(&quot;name&quot;)

Destruye el grupo al que pertenece el objeto &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>scaleGroup(factor [,&quot;name&quot;])

Scales the group the object &quot;name&quot; belongs to. Values greater than 1 enlarge
the group, values smaller than 1 make the group smaller e.g a value of 0.5
scales the group to 50 % of its original size, a value of 1.5 scales the group
to 150 % of its original size.  The value for &quot;factor&quot; must be greater than
0. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if an invalid scale factor is passed.
</source>
        <translation type="obsolete">scaleGroup(factor [,&quot;name&quot;])

Escala el grupo al que pertenece el objeto &quot;name&quot;. Los valores mayor de 1 
agrandan el grupo, los menores de 1 lo hacen más pequeño, p. ej. un valor 
de 0.5 escala el grupo al 50% de su tamaño original, un valor de 1.5 escala 
el grupo a 150% de su tamaño original. 
El valor de &quot;factor&quot; debe ser mayor de cero.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.

Puede lanzar la excepción ValueError si se pasa un factor de escala no válido. 
</translation>
    </message>
    <message>
        <source>loadImage(&quot;filename&quot; [, &quot;name&quot;])

Loads the picture &quot;picture&quot; into the image frame &quot;name&quot;. If &quot;name&quot; is
not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="obsolete">loadImage(&quot;filename&quot; [, &quot;name&quot;])

Carga la imagen &quot;filename&quot; en el marco de imagen &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.

Puede lanzar la excepción WrongFrameTypeError si el marco de destino 
no es un marco de imagen.
</translation>
    </message>
    <message>
        <source>scaleImage(x, y [, &quot;name&quot;])

Sets the scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="obsolete">scaleImage(x, y [, &quot;name&quot;])

Establece los factores de escalado de la imagen en el marco de 
imagen &quot;name&quot;. Un valor de 1 significa 100%.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.

Puede lanzar la excepción WrongFrameTypeError si el marco de destino 
no es un marco de imagen.
</translation>
    </message>
    <message>
        <source>lockObject([&quot;name&quot;]) -&gt; bool

Locks the object &quot;name&quot; if it&apos;s unlocked or unlock it if it&apos;s locked.
If &quot;name&quot; is not given the currently selected item is used. Returns true
if locked.
</source>
        <translation type="obsolete">lockObject([&quot;name&quot;]) -&gt; bool

Bloquea el objeto &quot;name&quot; si está desbloqueado o lo desbloquea en 
caso contrario. Devuelve true si se bloquea. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>isLocked([&quot;name&quot;]) -&gt; bool

Returns true if is the object &quot;name&quot; locked.  If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="obsolete">isLocked([&quot;name&quot;]) -&gt; bool

Devuelve true si el objeto &quot;name&quot; está bloqueado.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getFontNames() -&gt; list

Returns a list with the names of all available fonts.
</source>
        <translation type="obsolete">getFontNames() -&gt; list

Devuelve una lista con los nombres de todas las tipografías disponibles.
</translation>
    </message>
    <message>
        <source>getXFontNames() -&gt; list of tuples

Returns a larger font info. It&apos;s a list of the tuples with:
[ (Scribus name, Family, Real name, subset (1|0), embed PS (1|0), font file), (...), ... ]
</source>
        <translation type="obsolete">getXFontNames() -&gt; list of tuples

Da una mayor información sobre las tipografías. Devuelve una lista de vectores con: 
[ (nombre de Scribus, Familia, Nombre real, empotrar subconjunto (1|0), 
empotrar PS (1|0), tipografía), (...), ...]
</translation>
    </message>
    <message>
        <source>getLayers() -&gt; list

Returns a list with the names of all defined layers.
</source>
        <translation type="obsolete">getLayers() -&gt; list

Devuelve una lista con los nombres de todas las capas definidas.
</translation>
    </message>
    <message>
        <source>setActiveLayer(&quot;name&quot;)

Sets the active layer to the layer named &quot;name&quot;.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">setActiveLayer(&quot;name&quot;)

Establece la capa activa a la capa con nombre &quot;name&quot;.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si la el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>getActiveLayer() -&gt; string

Returns the name of the current active layer.
</source>
        <translation type="obsolete">getActiveLayer() -&gt; string

Devuelve el nombre de la capa activa actual.
</translation>
    </message>
    <message>
        <source>sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Sends the object &quot;name&quot; to the layer &quot;layer&quot;. The layer must exist.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Envía el objeto &quot;name&quot; a la capa &quot;layer&quot;. La capa debe existir.
Si no se pasa un nombre, se usa el objeto que esté seleccionado.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>setLayerVisible(&quot;layer&quot;, visible)

Sets the layer &quot;layer&quot; to be visible or not. If is the visible set to false
the layer is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">setLayerVisible(&quot;layer&quot;, visible)

Establece si la capa &quot;layer&quot; es visible o no. 
Si &quot;visible&quot; es false la capa será invisible.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>deleteLayer(&quot;layer&quot;)

Deletes the layer with the name &quot;layer&quot;. Nothing happens if the layer doesn&apos;t
exists or if it&apos;s the only layer in the document.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">deleteLayer(&quot;layer&quot;)

Borra la capa con el nombre &quot;layer&quot;. No ocurre nada si la capa no existe o 
si es la única capa del documento.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>createLayer(layer)

Creates a new layer with the name &quot;name&quot;.

May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">createLayer(layer)

Crea una nueva capa co el nombre &quot;name&quot;.

Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>getGuiLanguage() -&gt; string

Returns a string with the -lang value.
</source>
        <translation type="obsolete">getGuiLanguage() -&gt; string

Devuelve una cadena con el código del idioma usado.
</translation>
    </message>
    <message>
        <source>createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new ellipse on the current page and returns its name.
The coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name for further referencing of that object. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Crea una elipse en la página actual y devuelve su nombre. 
Las coordenadas x, y, anchura y altura se expresan en las unidades 
actuales del documento (ver constantes UNIT). &quot;name&quot; debería ser 
un identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando.
</translation>
    </message>
    <message>
        <source>createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new picture frame on the current page and returns its name. The
coordinates are given in the current measurement units of the document.
&quot;name&quot; should be a unique identifier for the object because you need this
name for further access to that object. If &quot;name&quot; is not given Scribus will
create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Crea un marco de imagen en la página actual y devuelve su nombre. 
Las coordenadas x, y, anchura y altura se expresan en las unidades 
actuales del documento. &quot;name&quot; debería ser un identificador único 
para el objeto porque se referenciará con ese nombre después. 
Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando.
</translation>
    </message>
    <message>
        <source>createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new text frame on the actual page and returns its name.
The coordinates are given in the actual measurement unit of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further referencing of that object. If &quot;name&quot; is not
given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Crea un marco de texto en la página actual y devuelve su nombre. 
Las coordenadas x, y, anchura y altura se expresan en las unidades 
actuales del documento (ver constantes UNIT). &quot;name&quot; debería ser 
un identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando.
</translation>
    </message>
    <message>
        <source>createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Creates a new line from the point(x1, y1) to the point(x2, y2) and returns
its name. The coordinates are given in the current measurement unit of the
document (see UNIT constants). &quot;name&quot; should be a unique identifier for the
object because you need this name for further access to that object. If
&quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="obsolete">createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Crea una línea del punto (x1, y1) al punto (x2, y2) y devuelve su 
nombre. Las coordenadas se expresan en las unidades actuales 
del documento (ver constantes UNIT). &quot;name&quot; debería ser un 
identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando.
</translation>
    </message>
    <message>
        <source>createPolyLine(list, [&quot;name&quot;]) -&gt; string

Creates a new polyline and returns its name. The points for the polyline are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
The coordinates are given in the current measurement units of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further access to that object. If &quot;name&quot; is not given
Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="obsolete">createPolyLine(list, [&quot;name&quot;]) -&gt; string

Crea una polilínea y devuelve su nombre. Los puntos de la polilínea 
se almacenan en la lista &quot;list&quot; en el orden siguiente: [x1, y1, x2, y2, ...xn, yn]. 
Las coordenadas se expresan en las unidades actuales del documento 
(ver constantes UNIT). &quot;name&quot; debería ser un identificador único para el 
objeto porque se referenciará con ese nombre después. Si no se le da 
un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando. 
Puede lanzar la excepción ValueError si se pasa un número de puntos 
insuficiente, o si el número de valores es impar.
</translation>
    </message>
    <message>
        <source>createPolygon(list, [&quot;name&quot;]) -&gt; string

Creates a new polygon and returns its name. The points for the polygon are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
At least three points are required. There is no need to repeat the first point
to close the polygon. The polygon is automatically closed by connecting the
first and the last point.  The coordinates are given in the current measurement
units of the document (see UNIT constants).  &quot;name&quot; should be a unique
identifier for the object because you need this name for further access to that
object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="obsolete">createPolygon(list, [&quot;name&quot;]) -&gt; string

Crea un polígono y devuelve su nombre. Los puntos del polígono se 
almacenan en la lista &quot;list&quot; en el orden siguiente: [x1, y1, x2, y2, ...xn, yn]. 
Al menos se necesitan 3 puntos. No se necesita repetir el primer punto 
para cerrar el polígono, se cierra automáticamente conectando el primer 
punto con el último. Las coordenadas se expresan en las unidades actuales 
del documento (ver constantes UNIT). &quot;name&quot; debería ser un identificador 
único para el objeto porque se referenciará con ese nombre después. 
Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando. 
Puede lanzar la excepción ValueError si se pasa un número de puntos 
insuficiente, o si el número de valores es impar.
</translation>
    </message>
    <message>
        <source>createBezierLine(list, [&quot;name&quot;]) -&gt; string

Creates a new bezier curve and returns its name. The points for the bezier
curve are stored in the list &quot;list&quot; in the following order:
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn. yn, kxn. kyn]
In the points list, x and y mean the x and y coordinates of the point and kx
and ky meaning the control point for the curve.  The coordinates are given in
the current measurement units of the document (see UNIT constants). &quot;name&quot;
should be a unique identifier for the object because you need this name for
further access to that object. If &quot;name&quot; is not given Scribus will create one
for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="obsolete">createBezierLine(list, [&quot;name&quot;]) -&gt; string

Crea una curva de bezier y devuelve su nombre. Los puntos de la 
curva de bezier se almacenan en la lista &quot;list&quot; en el orden siguiente: 
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn, yn, kxn, kyn]. 
En la lista de puntos, x e y son las coordenadas del punto y kx y ky 
el punto de control de la curva. Las coordenadas se expresan en las 
unidades actuales del documento (ver constantes UNIT). &quot;name&quot; debería 
ser un identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando. 
Puede lanzar la excepción ValueError si se pasa un número de puntos 
insuficiente, o si el número de valores es impar.
</translation>
    </message>
    <message>
        <source>createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Creates a new pathText by merging the two objects &quot;textbox&quot; and
&quot;beziercurve&quot; and returns its name. The coordinates are given in the current
measurement unit of the document (see UNIT constants). &quot;name&quot; should be a
unique identifier for the object because you need this name for further access
to that object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise NotFoundError if one or both of the named base object don&apos;t exist.
</source>
        <translation type="obsolete">createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Crea un texto adjunto a un trazado, adjuntando el objeto&quot;textbox&quot; al objeto 
&quot;beziercurve&quot; y devuelve su nombre. Las coordenadas se expresan en las 
unidades actuales del documento (ver constantes UNIT). &quot;name&quot; debería 
ser un identificador único para el objeto porque se referenciará con ese 
nombre después. Si no se le da un nombre, Scribus creará uno. 

Puede lanzar la excepción NameExistsError si se pasa un nombre que 
ya se está usando. 
Puede lanzar la excepción NotFoundError si alguno de los objetos no existe.
</translation>
    </message>
    <message>
        <source>deleteObject([&quot;name&quot;])

Deletes the item with the name &quot;name&quot;. If &quot;name&quot; is not given the currently
selected item is deleted.
</source>
        <translation type="obsolete">deleteObject([&quot;name&quot;])

Borra el objeto con el nombre &quot;name&quot;. 
Si no se pasa un nombre, se usa el objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>objectExists([&quot;name&quot;]) -&gt; bool

Test if an object with specified name really exists in the document.
The optional parameter is the object name. When no object name is given,
returns True if there is something selected.
</source>
        <translation type="obsolete">objectExists([&quot;name&quot;]) -&gt; bool

Comprueba si existe en el documento un objeto con el nombre &quot;name&quot;. 
Si no se pasa un nombre, devuelve true si hay algún objeto seleccionado.
</translation>
    </message>
    <message>
        <source>setStyle(&quot;style&quot; [, &quot;name&quot;])

Apply the named &quot;style&quot; to the object named &quot;name&quot;. If is no object name
given, it&apos;s applied on the selected object.
</source>
        <translation type="obsolete">setStyle(&quot;style&quot; [, &quot;name&quot;])

Aplica el estilo &quot;style&quot; al objeto &quot;name&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getAllStyles() -&gt; list

Return a list of the names of all paragraph styles in the current document.
</source>
        <translation type="obsolete">getAllStyles() -&gt; list

Devuelve una lista con los nombres de todos los estilos 
de párrafo del documento.
</translation>
    </message>
    <message>
        <source>currentPage() -&gt; integer

Returns the number of the current working page. Page numbers are counted from 1
upwards, no matter what the displayed first page number of your document is.
</source>
        <translation type="obsolete">currentPage() -&gt; integer

Devuelve el número de la página actual. Los números de página van del 1 en 
adelante, independientemente del número mostrado en la primera página.
</translation>
    </message>
    <message>
        <source>redrawAll()

Redraws all pages.
</source>
        <translation type="obsolete">redrawAll()

Redibuja todas las páginas.
</translation>
    </message>
    <message>
        <source>savePageAsEPS(&quot;name&quot;)

Saves the current page as an EPS to the file &quot;name&quot;.

May raise ScribusError if the save failed.
</source>
        <translation type="obsolete">savePageAsEPS(&quot;name&quot;)

Guarda la página actual como un EPS al archivo &quot;name&quot;.

Puede lanzar la excpeción ScribusError si hubo un error al guardar.
</translation>
    </message>
    <message>
        <source>deletePage(nr)

Deletes the given page. Does nothing if the document contains only one page.
Page numbers are counted from 1 upwards, no matter what the displayed first
page number is.

May raise IndexError if the page number is out of range
</source>
        <translation type="obsolete">deletePage(nr)

Borra la página &quot;nr&quot;. No hace nada si el documento sólo tiene una página. 
Los números de página van del 1 en adelante, independientemente del 
mostrado en la primera página. 

Puede lanzar la excepción IndexError si el número de página está fuera de rango.
</translation>
    </message>
    <message>
        <source>pageCount() -&gt; integer

Returns the number of pages in the document.
</source>
        <translation type="obsolete">pageCount() -&gt; integer

Devuelve el número de páginas del documento.
</translation>
    </message>
    <message>
        <source>getHGuides() -&gt; list

Returns a list containing positions of the horizontal guides. Values are in the
document&apos;s current units - see UNIT_&lt;type&gt; constants.
</source>
        <translation type="obsolete">getHGuides() -&gt; list

Devuelve una lista que contiene las posiciones de las guías horizontales. 
Los valores están en las unidades actuales del documento - ver las 
constantes UNIT_&lt;tipo&gt;.
</translation>
    </message>
    <message>
        <source>setHGuides(list)

Sets horizontal guides. Input parameter must be a list of guide positions
measured in the current document units - see UNIT_&lt;type&gt; constants.

Example: setHGuides(getHGuides() + [200.0, 210.0] # add new guides without any lost
         setHGuides([90,250]) # replace current guides entirely
</source>
        <translation type="obsolete">setHGuides(list)

Establece las guías horizontales. El parámetro debe ser una lista de 
posiciones medidas en las unidades actuales del documento - ver 
las constantes UNIT_&lt;tipo&gt;.

Ejemplo: setHGuides(getHGuides() + [200.0, 210.0] # añade guías sin perder ninguna
         setHGuides([90,250]) # reemplaza las guías actuales
</translation>
    </message>
    <message>
        <source>getVGuides()

See getHGuides.
</source>
        <translation type="obsolete">getVGuides()

Ver getHGuides.
</translation>
    </message>
    <message>
        <source>setVGuides()

See setHGuides.
</source>
        <translation type="obsolete">setVGuides()

Ver setHGuides.
</translation>
    </message>
    <message>
        <source>getPageSize() -&gt; tuple

Returns a tuple with page dimensions measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="obsolete">getPageSize() -&gt; tuple

Devuelve un vector con las dimensiones de página medidas en las unidades 
actuales del documento. Ver las constantes UNIT_&lt;tipo&gt; y getPageMargins()
</translation>
    </message>
    <message>
        <source>getPageItems() -&gt; list

Returns a list of tuples with items on the current page. The tuple is:
(name, objectType, order) E.g. [(&apos;Text1&apos;, 4, 0), (&apos;Image1&apos;, 2, 1)]
means that object named &apos;Text1&apos; is a text frame (type 4) and is the first at
the page...
</source>
        <translation type="obsolete">getPageItems() -&gt; list

Devuelve una lista de vectores con los objetos de la página actual. 
El vector es (nombre, tipoDeObjeto, orden). 
P. ej. [(&apos;Texto1&apos;, 4, 0), (&apos;Imagen1&apos;, 2, 1)] significa que el objeto &apos;Texto1&apos; 
es un marco de texto (tipo 4) y es el primero de la página...
</translation>
    </message>
    <message>
        <source>setFillColor(&quot;color&quot;, [&quot;name&quot;])

Sets the fill color of the object &quot;name&quot; to the color &quot;color&quot;. &quot;color&quot;
is the name of one of the defined colors. If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="obsolete">setFillColor(&quot;color&quot;, [&quot;name&quot;])

Establece el color de relleno del objeto &quot;name&quot; al color &quot;color&quot;. 
&quot;color&quot; es el nombre de uno de los colores definidos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setLineColor(&quot;color&quot;, [&quot;name&quot;])

Sets the line color of the object &quot;name&quot; to the color &quot;color&quot;. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="obsolete">setLineColor(&quot;color&quot;, [&quot;name&quot;])

Establece el color de línea del objeto &quot;name&quot; al color &quot;color&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setLineWidth(width, [&quot;name&quot;])

Sets line width of the object &quot;name&quot; to &quot;width&quot;. &quot;width&quot; must be in the
range from 0.0 to 12.0 inclusive, and is measured in points. If &quot;name&quot; is not
given the currently selected item is used.

May raise ValueError if the line width is out of bounds.
</source>
        <translation type="obsolete">setLineWidth(width, [&quot;name&quot;])

Establece el ancho de línea del objeto &quot;name&quot; a &quot;width&quot;. &quot;width&quot; debe estar 
en el rango de 0.0 a 12.0 inclusive, y se miede en puntos.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si el ancho de línea está fuera de rango.
</translation>
    </message>
    <message>
        <source>setLineShade(shade, [&quot;name&quot;])

Sets the shading of the line color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full color intensity). If &quot;name&quot; is not given the currently selected item
is used.

May raise ValueError if the line shade is out of bounds.
</source>
        <translation type="obsolete">setLineShade(shade, [&quot;name&quot;])

Establece la saturación del color de línea del objeto &quot;name&quot; a &quot;shade&quot;.
&quot;shade&quot; debe ser un valor entero en el rango de 0 (más claro) a 100
(color de mayor intensidad). 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si la saturación está fuera de rango.
</translation>
    </message>
    <message>
        <source>setLineJoin(join, [&quot;name&quot;])

Sets the line join style of the object &quot;name&quot; to the style &quot;join&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for join - JOIN_&lt;type&gt;.
</source>
        <translation type="obsolete">setLineJoin(join, [&quot;name&quot;])

Establece el estilo de unión de línea del objeto &quot;name&quot; al estilo &quot;join&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
Hay constantes predefinidas para &quot;join&quot; - JOIN_&lt;tipo&gt;.
</translation>
    </message>
    <message>
        <source>setLineEnd(endtype, [&quot;name&quot;])

Sets the line cap style of the object &quot;name&quot; to the style &quot;cap&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for &quot;cap&quot; - CAP_&lt;type&gt;.
</source>
        <translation type="obsolete">setLineEnd(endtype, [&quot;name&quot;])

Establece el estilo de extremo de línea del objeto &quot;name&quot; al estilo &quot;cap&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
Hay constantes predefinidas para &quot;cap&quot; - CAP_&lt;tipo&gt;.
</translation>
    </message>
    <message>
        <source>setLineStyle(style, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the style &quot;style&quot;. If &quot;name&quot;
is not given the currently selected item is used. There are predefined
constants for &quot;style&quot; - LINE_&lt;style&gt;.
</source>
        <translation type="obsolete">setLineStyle(style, [&quot;name&quot;])

Establece el estilo de línea del objeto &quot;name&quot; al estilo &quot;style&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
Hay constantes predefinidas para &quot;style&quot; - LINE_&lt;tipo&gt;.
</translation>
    </message>
    <message>
        <source>setFillShade(shade, [&quot;name&quot;])

Sets the shading of the fill color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full Color intensity). If &quot;name&quot; is not given the currently selected
Item is used.

May raise ValueError if the fill shade is out of bounds.
</source>
        <translation type="obsolete">setFillShade(shade, [&quot;name&quot;])

Establece la saturación del color de relleno del objeto &quot;name&quot; a &quot;shade&quot;.
&quot;shade&quot; debe ser un valor entero en el rango de 0 (más claro) a 100
(color de mayor intensidad). 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si la saturación está fuera de rango.
</translation>
    </message>
    <message>
        <source>setCornerRadius(radius, [&quot;name&quot;])

Sets the corner radius of the object &quot;name&quot;. The radius is expressed
in points. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if the corner radius is negative.
</source>
        <translation type="obsolete">setCornerRadius(radius, [&quot;name&quot;])

Establece el radio de las esquinas del objeto &quot;name&quot;. El radio está 
expreado en puntos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si el radio está fuera de rango.
</translation>
    </message>
    <message>
        <source>setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the named style &quot;namedStyle&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the line style doesn&apos;t exist.
</source>
        <translation type="obsolete">setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Establece el estilo de línea del objeto &quot;name&quot; al estilo de nombre &quot;namedStyle&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción NotFoundError si el estilo de línea no existe.
</translation>
    </message>
    <message>
        <source>getFont([&quot;name&quot;]) -&gt; string

Returns the font name for the text frame &quot;name&quot;. If this text frame
has some text selected the value assigned to the first character
of the selection is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">getFont([&quot;name&quot;]) -&gt; string

Devuelve el nombre de la tipografía del marco de texto &quot;name&quot;. Si el 
marco de texto tiene texto seleccionado, devuelve el del primer 
caracter de la selección. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getTextLength([&quot;name&quot;]) -&gt; integer

Returns the length of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getTextLength([&quot;name&quot;]) -&gt; integer

Devuelve la longitud del texto en el marco de texto &quot;name&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot;. If this text frame has some text
selected, the selected text is returned. All text in the frame, not just
currently visible text, is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">getText([&quot;name&quot;]) -&gt; string

Devuelve el texto del marco de texto &quot;name&quot;.  Si el marco de texto 
tiene texto seleccionado, devuelve el texto seleccionado. Devuelve 
todo el texto del marco, no solo el que se ve actualmente.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getAllText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot; and of all text frames which are
linked with this frame. If this textframe has some text selected, the selected
text is returned. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="obsolete">getAllText([&quot;name&quot;]) -&gt; string

Devuelve el texto del marco de texto &quot;name&quot; y de todos los marcos de texto 
que están enlazados con este marco. Si el marco de texto tiene texto 
seleccionado, devuelve el texto seleccionado.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getLineSpacing([&quot;name&quot;]) -&gt; float

Returns the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; expressed in
points. If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getLineSpacing([&quot;name&quot;]) -&gt; float

Devuelve el interlineado del marco de texto &quot;name&quot; expresado en puntos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>getColumnGap([&quot;name&quot;]) -&gt; float

Returns the column gap size of the text frame &quot;name&quot; expressed in points. If
&quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="obsolete">getColumnGap([&quot;name&quot;]) -&gt; float

Devuelve la distancia entre columnas del marco de texto &quot;name&quot; expresado 
en puntos. Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

</translation>
    </message>
    <message>
        <source>getColumns([&quot;name&quot;]) -&gt; integer

Gets the number of columns of the text frame &quot;name&quot;. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="obsolete">getColumns([&quot;name&quot;]) -&gt; integer

Devuelve el número de columnas del marco de texto &quot;name&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setText(&quot;text&quot;, [&quot;name&quot;])

Sets the text of the text frame &quot;name&quot; to the text of the string &quot;text&quot;.
Text must be UTF8 encoded - use e.g. unicode(text, &apos;iso-8859-2&apos;). See the FAQ
for more details. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="obsolete">setText(&quot;text&quot;, [&quot;name&quot;])

Establece el texto del marco de texto &quot;name&quot; al texto de la cadena &quot;text&quot;. 
El texto debe estar codificado en UTF8 - usa p. ej. unicode(&quot;text&quot;, &apos;iso-8859-2&apos;). 
Ver las FAQ para más detalles. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setFont(&quot;font&quot;, [&quot;name&quot;])

Sets the font of the text frame &quot;name&quot; to &quot;font&quot;. If there is some text
selected only the selected text is changed.  If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError if the font cannot be found.
</source>
        <translation type="obsolete">setFont(&quot;font&quot;, [&quot;name&quot;])

Establece la tipografía del marco de texto &quot;name&quot; a &quot;font&quot;. Si hay texto 
seleccionado sólo cambia la del texto seleccionado.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si no se puede encontrar la tipografía.
</translation>
    </message>
    <message>
        <source>setFontSize(size, [&quot;name&quot;])

Sets the font size of the text frame &quot;name&quot; to &quot;size&quot;. &quot;size&quot; is treated
as a value in points. If there is some text selected only the selected text is
changed. &quot;size&quot; must be in the range 1 to 512. If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError for a font size that&apos;s out of bounds.
</source>
        <translation type="obsolete">setFontSize(size, [&quot;name&quot;])

Establece el tamaño de tipografía del marco de texto &quot;name&quot; a &quot;size&quot;. 
&quot;size&quot; debe ser un valor en puntos. Si hay texto seleccionado sólo 
cambia la del texto seleccionado. &quot;size&quot; debe ser un entero en el 
rango 1 a 512. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si el tamaño está fuera de rango.
</translation>
    </message>
    <message>
        <source>setLineSpacing(size, [&quot;name&quot;])

Sets the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; to &quot;size&quot;.
&quot;size&quot; is a value in points. If &quot;name&quot; is not given the currently selected
item is used.

May throw ValueError if the line spacing is out of bounds.
</source>
        <translation type="obsolete">setLineSpacing(size, [&quot;name&quot;])

Establece el interlineado del marco de texto &quot;name&quot; a &quot;size&quot;. 
&quot;size&quot; es un valor en puntos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado. 

Puede lanzar la excepción ValueError si el interlineado está fuera de rango.
</translation>
    </message>
    <message>
        <source>setColumnGap(size, [&quot;name&quot;])

Sets the column gap of the text frame &quot;name&quot; to the value &quot;size&quot;. If
&quot;name&quot; is not given the currently selected item is used.

May throw ValueError if the column gap is out of bounds (must be positive).
</source>
        <translation type="obsolete">setColumnGap(size, [&quot;name&quot;])

Establece la distancia entre columnas del marco de texto &quot;name&quot; al 
valor &quot;size&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si la distancia entre columnas 
está fuera de rango (debe ser positiva).
</translation>
    </message>
    <message>
        <source>setColumns(nr, [&quot;name&quot;])

Sets the number of columns of the text frame &quot;name&quot; to the integer &quot;nr&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May throw ValueError if number of columns is not at least one.
</source>
        <translation type="obsolete">setColumns(nr, [&quot;name&quot;])

Establece el número de columnas del marco de texto &quot;name&quot; al entero &quot;nr&quot;.
Si no se pasa un nombre, se aplica al objeto que esté seleccionado. 

Puede lanzar la excepción ValueError si el número de columnas es menor de uno.
</translation>
    </message>
    <message>
        <source>setTextAlignment(align, [&quot;name&quot;])

Sets the text alignment of the text frame &quot;name&quot; to the specified alignment.
If &quot;name&quot; is not given the currently selected item is used. &quot;align&quot; should
be one of the ALIGN_ constants defined in this module - see dir(scribus).

May throw ValueError for an invalid alignment constant.
</source>
        <translation type="obsolete">setTextAlignment(align, [&quot;name&quot;])

Establece el alineamiento del marco de texto &quot;name&quot; al alineamiento 
indicado. &quot;align&quot; debería ser una de las constantes ALIGN_ definidas 
en este módulo - ver dir(scribus).
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.

Puede lanzar la excepción ValueError si la constante de la alineamiento 
no es válida.
</translation>
    </message>
    <message>
        <source>deleteText([&quot;name&quot;])

Deletes any text in the text frame &quot;name&quot;. If there is some text selected,
only the selected text will be deleted. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">deleteText([&quot;name&quot;])

Borrar el texto del marco de texto &quot;name&quot;. Si hay texto seleccionado sólo 
se borra el texto seleccionado. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setTextColor(&quot;color&quot;, [&quot;name&quot;])

Sets the text color of the text frame &quot;name&quot; to the color &quot;color&quot;. If there
is some text selected only the selected text is changed. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="obsolete">setTextColor(&quot;color&quot;, [&quot;name&quot;])

Establece el color del texto marco de texto &quot;name&quot; al color &quot;color&quot;. Si 
hay texto seleccionado sólo se cambia el texto seleccionado. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Set &quot;color&quot; of the text stroke. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="obsolete">setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Establece el color del trazo del texto a &quot;color&quot;. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>setTextShade(shade, [&quot;name&quot;])

Sets the shading of the text color of the object &quot;name&quot; to &quot;shade&quot;. If
there is some text selected only the selected text is changed. &quot;shade&quot; must
be an integer value in the range from 0 (lightest) to 100 (full color
intensity). If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="obsolete">setTextShade(shade, [&quot;name&quot;])

Establece la saturación del color del texto del objeto &quot;name&quot; a &quot;shade&quot;. 
Si hay texto seleccionado, sólo cambia el texto seleccionado. &quot;shade&quot; 
debe ser un valor entero en el rango de 0 (más claro) a 100 (color de 
mayor intensidad).
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Link two text frames. The frame named &quot;fromname&quot; is linked to the
frame named &quot;toname&quot;. The target frame must be an empty text frame
and must not link to or be linked from any other frames already.

May throw ScribusException if linking rules are violated.
</source>
        <translation type="obsolete">linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Enlaza dos marcos de texto. El marco llamado &quot;fromname&quot; se enlaza al marco 
llamado &quot;toname&quot;. El marco de destino debe ser un marco de texto vacío y 
no debe estar enlazado a otros ni desde otros marcos de texto.

Puede lanzar la excepción ScribusException si se violan las reglas de enlazado.
</translation>
    </message>
    <message>
        <source>unlinkTextFrames(&quot;name&quot;)

Remove the specified (named) object from the text frame flow/linkage. If the
frame was in the middle of a chain, the previous and next frames will be
connected, eg &apos;a-&gt;b-&gt;c&apos; becomes &apos;a-&gt;c&apos; when you unlinkTextFrames(b)&apos;

May throw ScribusException if linking rules are violated.
</source>
        <translation type="obsolete">unlinkTextFrames(&quot;name&quot;)

Elimina el objeto &quot;name&quot; del flujo de enlazado de marcos de texto. Si el 
marco estaba en medio de una cadena, los marcos anterior y siguiente 
se enlazarán, p. ej. &apos;a-&gt;b-&gt;c&apos; pasa a ser &apos;a-&gt;c&apos; al ejecutar unlinkTextFrames(b) 

Puede lanzar la excepción ScribusException si se violan las reglas de enlazado.
</translation>
    </message>
    <message>
        <source>traceText([&quot;name&quot;])

Convert the text frame &quot;name&quot; to outlines. If &quot;name&quot; is not given the
currently selected item is used.</source>
        <translation type="obsolete">traceText([&quot;name&quot;])

Convierte el marco de texto &quot;name&quot; a contornos. 
Si no se pasa un nombre, se aplica al objeto que esté seleccionado.
</translation>
    </message>
    <message>
        <source>progressReset()

Cleans up the Scribus progress bar previous settings. It is called before the
new progress bar use. See progressSet.
</source>
        <translation type="obsolete">progressReset()

Borra la barra de progreso de Scribus. Se llama antes de usar 
la barra de progreso. Ver progressSet.
</translation>
    </message>
    <message>
        <source>progressTotal(max)

Sets the progress bar&apos;s maximum steps value to the specified number.
See progressSet.
</source>
        <translation type="obsolete">progressTotal(max)

Establece el máximo número de pasos de la barra de progreso al 
número especificado. Ver progressSet.
</translation>
    </message>
    <message>
        <source>progressSet(nr)

Set the progress bar position to &quot;nr&quot;, a value relative to the previously set
progressTotal. The progress bar uses the concept of steps; you give it the
total number of steps and the number of steps completed so far and it will
display the percentage of steps that have been completed. You can specify the
total number of steps with progressTotal(). The current number of steps is set
with progressSet(). The progress bar can be rewound to the beginning with
progressReset(). [based on info taken from Trolltech&apos;s Qt docs]
</source>
        <translation type="obsolete">progressSet(nr)

Establece la posición de la barra de progreso a &quot;nr&quot;, un valor relativo a 
lo puesto anteriormente con progressTotal. La barra de progreso usa el 
concepto de pasos, se le dice el número de pasos totales y el número 
pasos completado y mostrará el porcentaje de pasos que se han 
completado. Se puede especificar el número de pasos con progressTotal(). 
El número actual de pasos se establece con progressSet(). Se rebobina al 
principio con progressReset(). 
[basado en la información tomada de la documentación de Qt de Trolltech]
</translation>
    </message>
    <message>
        <source>setCursor()

[UNSUPPORTED!] This might break things, so steer clear for now.
</source>
        <translation type="obsolete">setCursor()

[¡NO SOPORTADO!] 
Esto podría romper cosas, así que no se utiliza de momento.
</translation>
    </message>
    <message>
        <source>docChanged(bool)

Enable/disable save icon in the Scribus icon bar and the Save menu item. It&apos;s
useful to call this procedure when you&apos;re changing the document, because Scribus
won&apos;t automatically notice when you change the document using a script.
</source>
        <translation type="obsolete">docChanged(bool)

Activa o desactiva el icono de guardar en la barra de iconos de Scribs y la 
opción de menú Guardar. Es útil llamarlo cuando estás cambiando el documento, 
porque Scribus no notará automáticamente cuando se cambie el documento 
con un script.
</translation>
    </message>
    <message>
        <source>setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Sets the scale to frame on the selected or specified image frame to `scaletoframe&apos;.
If `proportional&apos; is specified, set fixed aspect ratio scaling to `proportional&apos;.
Both `scaletoframe&apos; and `proportional&apos; are boolean.

May raise WrongFrameTypeError.
</source>
        <translation type="obsolete">setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Establece la opción escalar al tamaño del marco a &quot;scaletoframe&quot; en el marco de
imagen seleccionado o especificado por &quot;name&quot;. 
Si se especifica &quot;proportional&quot;, establece la opción mantener la relación de aspecto
a &quot;proportional&quot;. 
Tanto &quot;scaletoframe&quot; como &quot;proportional&quot; son booleanos.

Puede lanzar la excepción WrongFrameTypeError.
</translation>
    </message>
    <message>
        <source>isLayerPrintable(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is printable or not, a value of True means
that the layer &quot;layer&quot; can be printed, a value of False means that printing
the layer &quot;layer&quot; is disabled.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">isLayerPrintable(&quot;layer&quot;) -&gt; bool

Devuelve si la capa &quot;layer&quot; es imprimible o no, un valor de True significa 
que la capa &quot;layer&quot; se puede imprimir, un valor de False significa que se 
ha desactivado la impresión de la capa&quot;layer&quot;.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Creates an image preview of font &quot;name&quot; with given text &quot;sample&quot; and size.
If &quot;filename&quot; is not &quot;&quot;, image is saved into &quot;filename&quot;. Otherwise
image data is returned as a string. The optional &quot;format&quot; argument
specifies the image format to generate, and supports any format allowed
by QPixmap.save(). Common formats are PPM, JPEG, PNG and XPM.

May raise NotFoundError if the specified font can&apos;t be found.
May raise ValueError if an empty sample or filename is passed.
</source>
        <translation type="obsolete">renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Crea una previsualización de la tipografía &quot;name&quot; con el texto &quot;sample&quot; y 
de tamaño &quot;size&quot;. Si &quot;filename&quot; no es &quot;&quot;, la imagen se guarda en&quot;filename&quot;. 
De otra forma la imagen se devuelve como una cadena. El argumento 
opcional &quot;format&quot; especifica el formato de imagen a generar, y admite 
cualquier formato permitido por QPixmap.save(). Los formatos comunes 
son PPM, JPEG, PNG y XPM.

Puede lanzar la excepción NotFoundError si no se puede encontrar la 
tipografía indicada.
Puede lanzar la excepción ValueError si &quot;filename&quot; o &quot;sample&quot; son 
cadenas vacías.
</translation>
    </message>
    <message>
        <source>isLayerVisible(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is visible or not, a value of True means
that the layer &quot;layer&quot; is visible, a value of False means that the layer
&quot;layer&quot; is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="obsolete">isLayerVisible(&quot;layer&quot;) -&gt; bool

Devuelve si la capa &quot;layer&quot; es visible o no, un valor de True significa 
que la capa &quot;layer&quot; es visible, un valor de False significa que la capa
&quot;layer&quot; es invisible.

Puede lanzar la excepción NotFoundError si no se puede encontrar la capa. 
Puede lanzar la excepción ValueError si el nombre de la capa no es válido.
</translation>
    </message>
    <message>
        <source>isPDFBookmark([&quot;name&quot;]) -&gt; bool

Returns true if the text frame &quot;name&quot; is a PDF bookmark.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="obsolete">isPDFBookmark([&quot;name&quot;]) -&gt; bool

Devuelve si el marco de texto &quot;name&quot; es un marcador de PDF. 
Si no se pasa &quot;name&quot; se usa el objeto actualmente seleccionado.

Puede lanzar la excepción WrongFrameTypeError si el marco de destino 
no es un marco de texto.
</translation>
    </message>
    <message>
        <source>getPageMargins()

Returns the page margins as a (top, left, right, bottom) tuple in the current
units. See UNIT_&lt;type&gt; constants and getPageSize().
</source>
        <translation type="obsolete">getPageMargins()

Devuelve los márgenes de página como un vector (arriba, izquierda, derecha, abajo) 
en las unidades actuales. Ver las constantes UNIT_&lt;tipo&gt; y getPageSize().
</translation>
    </message>
</context>
<context>
    <name>AIPlug</name>
    <message>
        <location filename="../../../scribus/plugins/import/ai/importai.cpp" line="124"/>
        <source>Importing: %1</source>
        <translation>Importando: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ai/importai.cpp" line="127"/>
        <source>Analyzing File:</source>
        <translation>Analizando archivo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ai/importai.cpp" line="262"/>
        <source>Group%1</source>
        <translation>Grupo%1</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ai/importai.cpp" line="2495"/>
        <source>Generating Items</source>
        <translation>Generando Elementos</translation>
    </message>
</context>
<context>
    <name>About</name>
    <message>
        <location filename="../../../scribus/about.cpp" line="97"/>
        <source>About Scribus %1</source>
        <translation>Acerca de Scribus %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="188"/>
        <source>&amp;About</source>
        <translation>&amp;Acerca de</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="299"/>
        <source>Development Team:</source>
        <translation>Equipo de desarrollo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="307"/>
        <source>Contributions from:</source>
        <translation>Contribuciones de:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="309"/>
        <source>Official Documentation:</source>
        <translation>Documentación oficial:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="313"/>
        <source>Other Documentation:</source>
        <translation>Otra documentación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="201"/>
        <source>A&amp;uthors</source>
        <translation>A&amp;utores</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="331"/>
        <source>Official Translations and Translators:</source>
        <translation>Traducciones oficiales y traductores:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="333"/>
        <source>Previous Translation Contributors:</source>
        <translation>Anteriores colaboradores en la traducción:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="215"/>
        <source>&amp;Translations</source>
        <translation>&amp;Traducciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="347"/>
        <source>Homepage</source>
        <translation>Página inicial</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="349"/>
        <source>Online Reference</source>
        <translation>Referencia en línea</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="353"/>
        <source>Bugs and Feature Requests</source>
        <translation>Errores y peticiones de características</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="357"/>
        <source>Mailing List</source>
        <translation>Lista de correo</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="226"/>
        <source>&amp;Online</source>
        <translation>&amp;En línea</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="267"/>
        <source>&amp;Close</source>
        <translation>&amp;Cerrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="351"/>
        <source>Wiki</source>
        <translation>Wiki</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="125"/>
        <source>%1 %2 %3</source>
        <translation>%1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="133"/>
        <source>%3-%2-%1 %4 %5</source>
        <translation>%3-%2-%1 %4 %5</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="183"/>
        <source>Using Ghostscript version %1</source>
        <translation>Usando versión %1 de Ghostscript</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="185"/>
        <source>No Ghostscript version available</source>
        <translation>Ninguna versión de Ghostscript disponible</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="186"/>
        <source>Build ID:</source>
        <translation>ID de compilación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="301"/>
        <source>Mac OS&amp;#174; X Aqua Port:</source>
        <translation>Adaptación a Mac OS&amp;#174; X Aqua:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="305"/>
        <source>Windows&amp;#174; Port:</source>
        <translation>Adaptación a Windows&amp;#174;:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="319"/>
        <source>Tango Project Icons:</source>
        <translation>Iconos del proyecto Tango:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="229"/>
        <source>&amp;Updates</source>
        <translation>&amp;Actualizaciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="279"/>
        <source>Check for updates to Scribus. No data from your machine will be transferred off it.</source>
        <translation>Busca actualizaciones de Scribus. Ninguna información sobre tu ordenador será enviada.</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="303"/>
        <source>OS/2&amp;#174;/eComStation&amp;#8482; Port:</source>
        <translation>Adaptación a OS/2&amp;#174;/eComStation&amp;#8482;:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="317"/>
        <source>Splash Screen:</source>
        <translation>Pantalla de inicio:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="275"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus.</source>
        <translation type="unfinished">Este panel muestra la versión y fecha de compilación en el soporte de Scribus.</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="276"/>
        <source>The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support.Last Letter is the renderer C=cairo or Q=Qt</source>
        <translation>C-C-T-F significa C=littlecms C=CUPS T=soporte TIFF F=soporte Fontconfig. La última letra es el motor de renderizado C=Cairo o Q=Qt</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="277"/>
        <source>Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected.</source>
        <translation>La falta de una biblioteca de soporte es indicado por un *. Esto también indica la versión de Ghostscrit que Scribus ha detectado.</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="278"/>
        <source>The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation>La versión de Windows no usa las bibliotecas fontconfig o CUPS.</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="186"/>
        <source>&lt;p align=&quot;center&quot;&gt;&lt;b&gt;%1 %2&lt;/b&gt;&lt;/p&gt;&lt;p align=&quot;center&quot;&gt;%3&lt;br&gt;%4 %5&lt;br&gt;%6&lt;/p&gt;</source>
        <translation>&lt;p align=&quot;center&quot;&gt;&lt;b&gt;%1 %2&lt;/b&gt;&lt;/p&gt;&lt;p align=&quot;center&quot;&gt;%3&lt;br&gt;%4 %5&lt;br&gt;%6&lt;/p&gt;</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="186"/>
        <source>Scribus Version</source>
        <translation>Versión de Scribus</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="233"/>
        <location filename="../../../scribus/about.cpp" line="655"/>
        <source>Check for Updates</source>
        <translation>Buscar actualizaciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="653"/>
        <source>Abort Update Check</source>
        <translation>Abortar búsqueda de actualizaciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="240"/>
        <source>&amp;Licence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="249"/>
        <source>Unable to open licence file. Please check your install directory or the Scribus website for licencing information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="355"/>
        <source>Developer Blog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="311"/>
        <source>Doc Translators:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="315"/>
        <source>Webmasters:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="450"/>
        <location filename="../../../scribus/about.cpp" line="564"/>
        <location filename="../../../scribus/about.cpp" line="631"/>
        <source>Unable to open %1 file. Please check your install directory or the Scribus website for %1 information.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPlugins</name>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="68"/>
        <source>Filename:</source>
        <translation>Nombre de archivo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="69"/>
        <source>Version:</source>
        <translation>Versión:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="72"/>
        <source>Enabled:</source>
        <translation>Activado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="73"/>
        <source>Release Date:</source>
        <translation>Fecha de publicación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="80"/>
        <source>Description:</source>
        <translation>Descripción:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="81"/>
        <source>Author(s):</source>
        <translation>Autor/es:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="82"/>
        <source>Copyright:</source>
        <translation>Copyright:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="83"/>
        <source>License:</source>
        <translation>Licencia:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.ui" line="13"/>
        <source>Scribus: About Plug-ins</source>
        <translation>Scribus: Sobre las extensiones</translation>
    </message>
</context>
<context>
    <name>ActionManager</name>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1269"/>
        <source>&amp;New</source>
        <translation>&amp;Nuevo</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1271"/>
        <source>&amp;Open...</source>
        <translation>&amp;Abrir...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1272"/>
        <source>&amp;Close</source>
        <translation>&amp;Cerrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1273"/>
        <source>&amp;Save</source>
        <translation>&amp;Guardar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1274"/>
        <source>Save &amp;As...</source>
        <translation>Gu&amp;ardar como...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1275"/>
        <source>Re&amp;vert to Saved</source>
        <translation>Re&amp;vertir al guardado</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1276"/>
        <source>Collect for O&amp;utput...</source>
        <translation>Rec&amp;olectar para salida...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1277"/>
        <source>Get Text...</source>
        <translation>Cargar texto...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1278"/>
        <source>Append &amp;Text...</source>
        <translation>Añadir &amp;texto...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1279"/>
        <source>Get Image...</source>
        <translation>Obtener imagen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1282"/>
        <source>Save &amp;Text...</source>
        <translation>Guardar el &amp;texto...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1284"/>
        <source>Save as P&amp;DF...</source>
        <translation>Guardar como P&amp;DF...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1285"/>
        <source>Document &amp;Setup...</source>
        <translation>Co&amp;nfiguración del documento...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1287"/>
        <source>&amp;Print...</source>
        <translation>&amp;Imprimir...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1289"/>
        <source>&amp;Quit</source>
        <translation>&amp;Salir</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1291"/>
        <source>&amp;Undo</source>
        <translation>&amp;Deshacer</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1292"/>
        <source>&amp;Redo</source>
        <translation>Re&amp;hacer</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1293"/>
        <source>&amp;Item Action Mode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1294"/>
        <source>Cu&amp;t</source>
        <translation>Cor&amp;tar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1295"/>
        <location filename="../../../scribus/actionmanager.cpp" line="1297"/>
        <source>&amp;Copy</source>
        <translation>&amp;Copiar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1296"/>
        <location filename="../../../scribus/actionmanager.cpp" line="1298"/>
        <source>&amp;Paste</source>
        <translation>&amp;Pegar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1300"/>
        <source>Paste Image from Clipboard</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1302"/>
        <source>Select &amp;All</source>
        <translation>Seleccionar &amp;todo</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1304"/>
        <source>&amp;Deselect All</source>
        <translation>&amp;Deseleccionar todo</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1305"/>
        <source>&amp;Search/Replace...</source>
        <translation>&amp;Buscar/Reemplazar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1306"/>
        <source>Edit Image...</source>
        <translation>Editar imagen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1308"/>
        <source>C&amp;olors...</source>
        <translation>C&amp;olores...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1312"/>
        <source>&amp;Master Pages...</source>
        <translation>Páginas &amp;maestras...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1286"/>
        <source>P&amp;references...</source>
        <translation>P&amp;referencias...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1320"/>
        <source>%1 pt</source>
        <translation>%1 pt</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1322"/>
        <source>&amp;Other...</source>
        <translation>&amp;Otro...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1323"/>
        <source>&amp;Left</source>
        <translation>&amp;Izquierda</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1324"/>
        <source>&amp;Center</source>
        <translation>&amp;Centro</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1325"/>
        <source>&amp;Right</source>
        <translation>&amp;Derecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1326"/>
        <source>&amp;Block</source>
        <translation>&amp;Justificado</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1327"/>
        <source>&amp;Forced</source>
        <translation>&amp;Forzado</translation>
    </message>
    <message>
        <source>&amp;%1 %</source>
        <translation type="obsolete">&amp;%1 %</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1338"/>
        <source>&amp;Normal</source>
        <translation>&amp;Normal</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1339"/>
        <source>&amp;Underline</source>
        <translation>&amp;Subrayado</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1340"/>
        <source>Underline &amp;Words</source>
        <translation>Subra&amp;yar palabras</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1341"/>
        <source>&amp;Strike Through</source>
        <translation>Tac&amp;hado</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1342"/>
        <source>&amp;All Caps</source>
        <translation>&amp;Mayúsculas</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1343"/>
        <source>Small &amp;Caps</source>
        <translation>Mi&amp;núsculas</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1344"/>
        <source>Su&amp;perscript</source>
        <translation>Su&amp;períndice</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1345"/>
        <source>Su&amp;bscript</source>
        <translation>Su&amp;bíndice</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1347"/>
        <source>S&amp;hadow</source>
        <translation>Somb&amp;reado</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1349"/>
        <source>&amp;Image Effects</source>
        <translation>Efectos de &amp;imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1350"/>
        <source>&amp;Tabulators...</source>
        <translation>Ta&amp;buladores...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1353"/>
        <source>D&amp;uplicate</source>
        <translation>&amp;Duplicar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1354"/>
        <source>&amp;Multiple Duplicate</source>
        <translation>Duplicación &amp;múltiple</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1355"/>
        <source>&amp;Delete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1356"/>
        <source>&amp;Group</source>
        <translation>Agr&amp;upar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1357"/>
        <source>&amp;Ungroup</source>
        <translation>&amp;Desagrupar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1358"/>
        <source>Is &amp;Locked</source>
        <translation>B&amp;loqueado</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1359"/>
        <source>Si&amp;ze is Locked</source>
        <translation>Tamaño blo&amp;queado</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1363"/>
        <source>Lower to &amp;Bottom</source>
        <translation>In&amp;ferior y superior</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1364"/>
        <source>Raise to &amp;Top</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1365"/>
        <source>&amp;Lower</source>
        <translation type="unfinished">&amp;Bajar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1366"/>
        <source>&amp;Raise</source>
        <translation type="unfinished">&amp;Subir</translation>
    </message>
    <message>
        <source>Send to S&amp;crapbook</source>
        <translation type="obsolete">Enviar al Álbu&amp;m de Recortes</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1369"/>
        <source>&amp;Attributes...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1371"/>
        <source>I&amp;mage Visible</source>
        <translation type="unfinished">&amp;Imagen visible</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1372"/>
        <source>&amp;Update Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1373"/>
        <source>Adjust Frame to Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1375"/>
        <source>Extended Image Properties</source>
        <translation type="unfinished">Propiedades de imagen extendidas</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1376"/>
        <source>&amp;Low Resolution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1377"/>
        <source>&amp;Normal Resolution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1378"/>
        <source>&amp;Full Resolution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1379"/>
        <source>Is PDF &amp;Bookmark</source>
        <translation type="unfinished">&amp;Marcador PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1380"/>
        <source>Is PDF A&amp;nnotation</source>
        <translation type="unfinished">&amp;Anotación PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1381"/>
        <source>Annotation P&amp;roperties</source>
        <translation type="unfinished">&amp;Propiedades de las Anotaciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1382"/>
        <source>Field P&amp;roperties</source>
        <translation type="unfinished">&amp;Propiedades de Campo</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1383"/>
        <source>&amp;Edit Shape...</source>
        <translation type="unfinished">&amp;Editar forma...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1384"/>
        <source>&amp;Attach Text to Path</source>
        <translation type="unfinished">&amp;Adjuntar Texto al Trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1385"/>
        <source>&amp;Detach Text from Path</source>
        <translation type="unfinished">&amp;Desadjuntar Texto del Trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1386"/>
        <source>&amp;Combine Polygons</source>
        <translation type="unfinished">&amp;Combinar Polígonos</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1387"/>
        <source>Split &amp;Polygons</source>
        <translation type="unfinished">Dividir &amp;Polígonos</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1388"/>
        <source>&amp;Bezier Curve</source>
        <translation type="unfinished">Curva de &amp;Bézier</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1389"/>
        <source>&amp;Image Frame</source>
        <translation type="unfinished">Marco de &amp;imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1391"/>
        <source>&amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1392"/>
        <source>&amp;Text Frame</source>
        <translation type="unfinished">Marco de &amp;texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1395"/>
        <source>&amp;Frames...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1396"/>
        <source>&amp;Glyph...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1397"/>
        <source>Sample Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1401"/>
        <source>&amp;Insert...</source>
        <translation type="unfinished">&amp;Insertar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1402"/>
        <source>Im&amp;port...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1403"/>
        <source>&amp;Delete...</source>
        <translation type="unfinished">&amp;Borrar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1404"/>
        <source>&amp;Copy...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1405"/>
        <source>&amp;Move...</source>
        <translation type="unfinished">&amp;Mover...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1406"/>
        <source>&amp;Apply Master Page...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1408"/>
        <source>Manage &amp;Guides...</source>
        <translation type="unfinished">Administrar &amp;Guías...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1409"/>
        <source>Manage Page Properties...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1414"/>
        <source>&amp;50%</source>
        <translation type="unfinished">&amp;50%</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1415"/>
        <source>&amp;75%</source>
        <translation type="unfinished">&amp;75%</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1416"/>
        <source>&amp;100%</source>
        <translation type="unfinished">&amp;100%</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1417"/>
        <source>&amp;200%</source>
        <translation type="unfinished">&amp;200%</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1420"/>
        <source>Show &amp;Margins</source>
        <translation type="unfinished">Mostrar Má&amp;rgenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1422"/>
        <source>Show &amp;Frames</source>
        <translation type="unfinished">Mostrar &amp;Marcos</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1424"/>
        <source>Show &amp;Images</source>
        <translation type="unfinished">Mostrar &amp;Imágenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1425"/>
        <source>Show &amp;Grid</source>
        <translation type="unfinished">Mostrar &amp;Cuadrícula</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1426"/>
        <source>Show G&amp;uides</source>
        <translation type="unfinished">Mostrar &amp;Guías</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1428"/>
        <source>Show &amp;Baseline Grid</source>
        <translation type="unfinished">Mostrar Líneas de &amp;Base</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1429"/>
        <source>Show &amp;Text Chain</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1430"/>
        <source>Show Control Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1433"/>
        <source>Sn&amp;ap to Grid</source>
        <translation type="unfinished">&amp;Ajustar a la Cuadrícula</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1434"/>
        <source>Sna&amp;p to Guides</source>
        <translation type="unfinished">A&amp;justar a las Guías</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1439"/>
        <source>&amp;Properties</source>
        <translation type="unfinished">&amp;Propiedades</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1441"/>
        <source>&amp;Scrapbook</source>
        <translation type="unfinished">Álb&amp;um de recortes</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1442"/>
        <source>&amp;Layers</source>
        <translation type="unfinished">&amp;Capas</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1443"/>
        <source>&amp;Arrange Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1444"/>
        <source>&amp;Bookmarks</source>
        <translation type="unfinished">&amp;Marcadores</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1445"/>
        <source>&amp;Measurements</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1446"/>
        <source>Action &amp;History</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1447"/>
        <source>Preflight &amp;Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1448"/>
        <source>&amp;Align and Distribute</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1449"/>
        <source>&amp;Tools</source>
        <translation type="unfinished">&amp;Herramientas</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1450"/>
        <source>P&amp;DF Tools</source>
        <translation type="unfinished">Herramientas de P&amp;DF</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1453"/>
        <source>Select Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1454"/>
        <source>Rotate Item</source>
        <translation type="unfinished">Rotar objeto</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1455"/>
        <source>Zoom in or out</source>
        <translation type="unfinished">Acercar o alejar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1456"/>
        <source>Zoom in</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1457"/>
        <source>Zoom out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1458"/>
        <source>Edit Contents of Frame</source>
        <translation type="unfinished">Editar contenidos del marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1459"/>
        <source>Edit Text...</source>
        <translation type="unfinished">&amp;Editar texto...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1460"/>
        <source>Link Text Frames</source>
        <translation type="unfinished">Enlazar marcos de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1461"/>
        <source>Unlink Text Frames</source>
        <translation type="unfinished">Desenlazar marcos de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1462"/>
        <source>&amp;Eye Dropper</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1463"/>
        <source>Copy Item Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1486"/>
        <source>&amp;Hyphenate Text</source>
        <translation type="unfinished">&amp;Dividir en sílabas</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1487"/>
        <source>Dehyphenate Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1488"/>
        <source>&amp;Generate Table Of Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1495"/>
        <source>&amp;About Scribus</source>
        <translation type="unfinished">&amp;Acerca de Scribus</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1497"/>
        <source>About &amp;Qt</source>
        <translation type="unfinished">Acerca de &amp;Qt</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1498"/>
        <source>Toolti&amp;ps</source>
        <translation type="unfinished">Ayuda &amp;emergente</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1500"/>
        <source>Scribus &amp;Manual...</source>
        <translation type="unfinished">&amp;Manual de Scribus</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1519"/>
        <source>Non Breaking Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1520"/>
        <source>Non Breaking &amp;Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1521"/>
        <source>Page &amp;Number</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1523"/>
        <source>New Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1524"/>
        <source>Frame Break</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1525"/>
        <source>Column Break</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1528"/>
        <source>Copyright</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1529"/>
        <source>Registered Trademark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1530"/>
        <source>Trademark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1532"/>
        <source>Bullet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1534"/>
        <source>Em Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1535"/>
        <source>En Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1536"/>
        <source>Figure Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1537"/>
        <source>Quotation Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1508"/>
        <source>Toggle Palettes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1509"/>
        <source>Toggle Guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1288"/>
        <source>Print Previe&amp;w</source>
        <translation type="unfinished">Pre&amp;visualizar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1313"/>
        <source>&amp;JavaScripts...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1407"/>
        <source>Convert to Master Page...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1491"/>
        <source>&amp;Cascade</source>
        <translation type="unfinished">&amp;Cascada</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1492"/>
        <source>&amp;Tile</source>
        <translation type="unfinished">&amp;Mosaico</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1370"/>
        <source>More Info...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1360"/>
        <source>&amp;Printing Enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1361"/>
        <source>&amp;Flip Horizontally</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1362"/>
        <source>&amp;Flip Vertically</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1431"/>
        <source>Show Rulers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1440"/>
        <source>&amp;Outline</source>
        <comment>Document Outline Palette</comment>
        <translation type="unfinished">&amp;Esquema</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1531"/>
        <source>Solidus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1533"/>
        <source>Middle Dot</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1558"/>
        <source>En Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1559"/>
        <source>Em Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1560"/>
        <source>Thin Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1561"/>
        <source>Thick Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1562"/>
        <source>Mid Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1563"/>
        <source>Hair Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1575"/>
        <source>ff</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1576"/>
        <source>fi</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1577"/>
        <source>fl</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1578"/>
        <source>ffi</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1579"/>
        <source>ffl</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1580"/>
        <source>ft</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1581"/>
        <source>st</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1311"/>
        <source>S&amp;tyles...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1346"/>
        <source>&amp;Outline</source>
        <comment>type effect</comment>
        <translation type="unfinished">&amp;Esquema</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1390"/>
        <source>&amp;Outlines</source>
        <comment>Convert to oulines</comment>
        <translation type="unfinished">&amp;Contorno</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1299"/>
        <source>Paste (&amp;Absolute)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1301"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">B&amp;orrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1475"/>
        <source>Insert PDF Push Button</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1476"/>
        <source>Insert PDF Text Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1477"/>
        <source>Insert PDF Check Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1478"/>
        <source>Insert PDF Combo Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1479"/>
        <source>Insert PDF List Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1480"/>
        <source>Insert Text Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1481"/>
        <source>Insert Link Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1283"/>
        <source>Save as &amp;EPS...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1427"/>
        <source>Show Text Frame Columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1419"/>
        <source>Preview Mode</source>
        <translation type="unfinished">Modo de vista previa</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1423"/>
        <source>Show Layer Indicators</source>
        <translation type="unfinished">Mostrar indicadores de capa</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1310"/>
        <source>Patterns...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1368"/>
        <source>Send to Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1398"/>
        <source>Sticky Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1412"/>
        <source>&amp;Fit to Height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1413"/>
        <source>Fit to Width</source>
        <translation type="unfinished">Ajustar a ancho</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1421"/>
        <source>Show Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1518"/>
        <source>Soft &amp;Hyphen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1526"/>
        <source>&amp;Zero Width Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1527"/>
        <source>Zero Width NB Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1539"/>
        <source>Apostrophe</source>
        <comment>Unicode 0x0027</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1540"/>
        <source>Straight Double</source>
        <comment>Unicode 0x0022</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1541"/>
        <source>Single Left</source>
        <comment>Unicode 0x2018</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1542"/>
        <source>Single Right</source>
        <comment>Unicode 0x2019</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1543"/>
        <source>Double Left</source>
        <comment>Unicode 0x201C</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1544"/>
        <source>Double Right</source>
        <comment>Unicode 0x201D</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1545"/>
        <source>Single Reversed</source>
        <comment>Unicode 0x201B</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1546"/>
        <source>Double Reversed</source>
        <comment>Unicode 0x201F</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1547"/>
        <source>Single Left Guillemet</source>
        <comment>Unicode 0x2039</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1548"/>
        <source>Single Right Guillemet</source>
        <comment>Unicode 0x203A</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1549"/>
        <source>Double Left Guillemet</source>
        <comment>Unicode 0x00AB</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1550"/>
        <source>Double Right Guillemet</source>
        <comment>Unicode 0x00BB</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1551"/>
        <source>Low Single Comma</source>
        <comment>Unicode 0x201A</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1552"/>
        <source>Low Double Comma</source>
        <comment>Unicode 0x201E</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1553"/>
        <source>CJK Single Left</source>
        <comment>Unicode 0x300C</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1554"/>
        <source>CJK Single Right</source>
        <comment>Unicode 0x300D</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1555"/>
        <source>CJK Double Left</source>
        <comment>Unicode 0x300E</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1556"/>
        <source>CJK Double Right</source>
        <comment>Unicode 0x300F</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1418"/>
        <source>&amp;400%</source>
        <translation type="unfinished">&amp;100% {400%?}</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1465"/>
        <source>Insert &amp;Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1466"/>
        <source>Insert &amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1468"/>
        <source>Insert T&amp;able</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1469"/>
        <source>Insert &amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1470"/>
        <source>Insert &amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1471"/>
        <source>Insert &amp;Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1472"/>
        <source>Insert &amp;Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1473"/>
        <source>Insert &amp;Freehand Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1501"/>
        <source>Scribus Homepage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1502"/>
        <source>Scribus Online Documentation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1503"/>
        <source>Scribus Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1504"/>
        <source>Getting Started with Scribus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1435"/>
        <source>Show Context Menu</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1485"/>
        <source>&amp;Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1496"/>
        <source>&amp;About Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1510"/>
        <source>Insert Unicode Character Begin Sequence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1432"/>
        <source>Rulers Relative to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1522"/>
        <source>Number of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1505"/>
        <source>Check for Updates</source>
        <translation type="unfinished">Buscar actualizaciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1280"/>
        <source>Get Vector File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1303"/>
        <source>Advanced Select All...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1307"/>
        <source>Edit Source...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1309"/>
        <source>Replace Colors...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1467"/>
        <source>Insert &amp;Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1374"/>
        <source>Adjust Image to Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1704"/>
        <source>File</source>
        <translation type="unfinished">Archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1704"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1706"/>
        <source>Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1706"/>
        <source>&amp;Edit</source>
        <translation type="unfinished">&amp;Editar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1708"/>
        <source>Style</source>
        <translation type="unfinished">Estilo</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1708"/>
        <source>&amp;Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1710"/>
        <source>Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1710"/>
        <source>&amp;Item</source>
        <translation type="unfinished">&amp;Objeto</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1712"/>
        <source>Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1712"/>
        <source>I&amp;nsert</source>
        <translation type="unfinished">I&amp;nsertar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1714"/>
        <source>Page</source>
        <translation type="unfinished">Página</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1714"/>
        <source>&amp;Page</source>
        <translation type="unfinished">&amp;Página</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1716"/>
        <source>View</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1716"/>
        <source>&amp;View</source>
        <translation type="unfinished">&amp;Ver</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1718"/>
        <source>Extras</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1718"/>
        <source>E&amp;xtras</source>
        <translation type="unfinished">E&amp;xtras</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1720"/>
        <source>Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1720"/>
        <source>&amp;Windows</source>
        <translation type="unfinished">&amp;Ventanas</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1722"/>
        <source>Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1722"/>
        <source>&amp;Help</source>
        <translation type="unfinished">A&amp;yuda</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1890"/>
        <source>Plugin Menu Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1892"/>
        <source>Others</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1894"/>
        <source>Unicode Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1499"/>
        <source>Move/Resize Value Indicator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1270"/>
        <source>New &amp;from Template...</source>
        <translation type="unfinished">Nuevo &amp;desde Plantilla...</translation>
    </message>
</context>
<context>
    <name>AdjustCmsDialog</name>
    <message>
        <location filename="../../../scribus/adjustcmsdialog.cpp" line="16"/>
        <source>CMS Settings</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignDistribute</name>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="36"/>
        <source>Align</source>
        <translation>Alinear</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="65"/>
        <source>&amp;Selected Guide:</source>
        <translation>&amp;Seleccionar guías:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="78"/>
        <source>&amp;Relative To:</source>
        <translation type="unfinished">&amp;Relativo a:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="97"/>
        <source>&amp;Align Sides By:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="153"/>
        <location filename="../../../scribus/aligndistribute.ui" line="160"/>
        <location filename="../../../scribus/aligndistribute.ui" line="167"/>
        <location filename="../../../scribus/aligndistribute.ui" line="174"/>
        <location filename="../../../scribus/aligndistribute.ui" line="181"/>
        <location filename="../../../scribus/aligndistribute.ui" line="188"/>
        <location filename="../../../scribus/aligndistribute.ui" line="195"/>
        <location filename="../../../scribus/aligndistribute.ui" line="202"/>
        <location filename="../../../scribus/aligndistribute.ui" line="209"/>
        <location filename="../../../scribus/aligndistribute.ui" line="216"/>
        <location filename="../../../scribus/aligndistribute.ui" line="286"/>
        <location filename="../../../scribus/aligndistribute.ui" line="293"/>
        <location filename="../../../scribus/aligndistribute.ui" line="300"/>
        <location filename="../../../scribus/aligndistribute.ui" line="307"/>
        <location filename="../../../scribus/aligndistribute.ui" line="314"/>
        <location filename="../../../scribus/aligndistribute.ui" line="324"/>
        <location filename="../../../scribus/aligndistribute.ui" line="331"/>
        <location filename="../../../scribus/aligndistribute.ui" line="341"/>
        <location filename="../../../scribus/aligndistribute.ui" line="348"/>
        <location filename="../../../scribus/aligndistribute.ui" line="358"/>
        <location filename="../../../scribus/aligndistribute.ui" line="365"/>
        <location filename="../../../scribus/aligndistribute.ui" line="372"/>
        <location filename="../../../scribus/aligndistribute.ui" line="382"/>
        <location filename="../../../scribus/aligndistribute.ui" line="389"/>
        <location filename="../../../scribus/aligndistribute.ui" line="396"/>
        <location filename="../../../scribus/aligndistribute.ui" line="403"/>
        <source>...</source>
        <translation>...</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="260"/>
        <source>Distribute</source>
        <translation>Distribuir</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="450"/>
        <source>&amp;Distance:</source>
        <translation>&amp;Distancia:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="511"/>
        <source>Reverse Distribution</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignDistributePalette</name>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="90"/>
        <source>Align and Distribute</source>
        <translation>Alinear y distribuir</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="91"/>
        <source>Align</source>
        <translation>Alinear</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="93"/>
        <source>&amp;Relative to:</source>
        <translation>&amp;Relativo a:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="96"/>
        <source>First Selected</source>
        <translation>Primer seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="97"/>
        <source>Last Selected</source>
        <translation>Último seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="98"/>
        <source>Page</source>
        <translation>Página</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="99"/>
        <source>Margins</source>
        <translation>Márgenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="100"/>
        <source>Guide</source>
        <translation>Guías</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="101"/>
        <source>Selection</source>
        <translation>Selección</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="105"/>
        <source>&amp;Align Sides By:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="108"/>
        <source>Moving (Preserve Size)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="109"/>
        <source>Resizing (Preserve Opposite Side)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="110"/>
        <source>&lt;qt&gt;When aligning one side of an item:&lt;ul&gt;&lt;li&gt;Always move the other side too (preserve existing width and height), or &lt;/li&gt;&lt;li&gt;Keep the other side fixed (resize the item instead of moving it) whenever possible&lt;/li&gt;&lt;/ul&gt;&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="118"/>
        <source>Align bottoms</source>
        <translation>Alinear abajo</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="120"/>
        <source>Align right sides</source>
        <translation>Alinear a la derecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="124"/>
        <source>Center on vertical axis</source>
        <translation>Centrar con el eje vertical</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="126"/>
        <source>Align left sides</source>
        <translation>Alinear a la izquierda</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="128"/>
        <source>Center on horizontal axis</source>
        <translation>Centrar con el eje horizontal</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="132"/>
        <source>Align tops</source>
        <translation>Alinear arriba</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="134"/>
        <source>&amp;Selected Guide:</source>
        <translation>Guía &amp;seleccionada:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="142"/>
        <source>Distribute right sides equidistantly</source>
        <translation>Distribuir equidistantemente por la derecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="144"/>
        <source>Distribute bottoms equidistantly</source>
        <translation>Distribuir equidistantemente por abajo</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="146"/>
        <source>Distribute centers equidistantly horizontally</source>
        <translation>Distribuir equidistantemente por el centro horizontalmente</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="152"/>
        <source>Distribute left sides equidistantly</source>
        <translation>Distribuir equidistantemente por la izquierda</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="154"/>
        <source>Distribute centers equidistantly vertically</source>
        <translation>Distribuir equidistantemente por el centro verticalmente</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="156"/>
        <source>Distribute tops equidistantly</source>
        <translation>Distribuir equidistantemente por arriba</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="166"/>
        <source>&amp;Distance:</source>
        <translation>&amp;Distancia:</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="167"/>
        <source>Distribute the items with the distance specified</source>
        <translation>Distribuir los objetos con la distancia especificada</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="168"/>
        <source>When distributing by a set distance, reverse the direction of the distribution of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="169"/>
        <source>None Selected</source>
        <translation>Nada seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="454"/>
        <source>Y: %1%2</source>
        <translation>Y: %1%2</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="462"/>
        <source>X: %1%2</source>
        <translation>X: %1%2</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="114"/>
        <source>Align right sides of items to left side of anchor</source>
        <translation>Alinear por el lado derecho de los objetos al lado izquierdo del anclaje</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="116"/>
        <source>Align left sides of items to right side of anchor</source>
        <translation>Alinear por el lado izquierdo de los objetos al lado derecho del anclaje</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="122"/>
        <source>Align tops of items to bottom of anchor</source>
        <translation>Alinear por el lado superior de los objetos al lado inferior del anclaje</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="130"/>
        <source>Align bottoms of items to top of anchor</source>
        <translation>Alinear por el lado inferior de los objetos al lado superior del anclaje</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="137"/>
        <source>Make horizontal gaps between items equal</source>
        <translation>Igualar distancia horizontal entre objetos</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="139"/>
        <source>Make horizontal gaps between items equal to the value specified</source>
        <translation>Igualar distancia horizontal entre objetos al valor especificado</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="148"/>
        <source>Make vertical gaps between items equal</source>
        <translation>Igualar distancia vertical entre objetos</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="150"/>
        <source>Make vertical gaps between items equal to the value specified</source>
        <translation>Igualar distancia vertical entre objetos al valor especificado</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="158"/>
        <source>Make horizontal gaps between items and sides of page equal</source>
        <translation>Igualar distancia horizontal entre objetos y bordes de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="164"/>
        <source>Make vertical gaps between items and the top and bottom of page margins equal</source>
        <translation>Igualar distancia vertical entre objetos y márgenes superior e inferior de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="162"/>
        <source>Make horizontal gaps between items and sides of page margins equal</source>
        <translation>Igualar distancia horizontal entre objetos y márgenes de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="160"/>
        <source>Make vertical gaps between items and the top and bottom of page equal</source>
        <translation>Igualar distancia vertical entre objetos y parte superior e inferior de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="92"/>
        <source>Distribute</source>
        <translation>Distribuir</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="103"/>
        <source>&lt;qt&gt;Align relative to the:&lt;ul&gt;&lt;li&gt;First selected item&lt;/li&gt;&lt;li&gt;Second Selected Item&lt;/li&gt;&lt;li&gt;The current page&lt;/li&gt;&lt;li&gt;The margins of the current page&lt;/li&gt;&lt;li&gt;A Guide&lt;/li&gt;&lt;li&gt;The selection&lt;/ul&gt;&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="112"/>
        <source>The location of the selected guide to align to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignSelect</name>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="110"/>
        <source>Align Text Left</source>
        <translation>Alinear texto a la izquierda</translation>
    </message>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="111"/>
        <source>Align Text Right</source>
        <translation>Alinear texto a la derecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="112"/>
        <source>Align Text Center</source>
        <translation>Centrar texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="113"/>
        <source>Align Text Justified</source>
        <translation>Justificar texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="114"/>
        <source>Align Text Forced Justified</source>
        <translation>Justificación forzada del texto</translation>
    </message>
</context>
<context>
    <name>Annot</name>
    <message>
        <location filename="../../../scribus/annot.cpp" line="61"/>
        <source>Field Properties</source>
        <translation>Propiedades de campo</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="92"/>
        <location filename="../../../scribus/annot.cpp" line="533"/>
        <source>Type:</source>
        <translation>Tipo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>Button</source>
        <translation>Botón</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>Text Field</source>
        <translation>Campo de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>Check Box</source>
        <translation>Casilla de selección</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>Combo Box</source>
        <translation>Cuadro combinado</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>List Box</source>
        <translation>Lista</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="111"/>
        <source>Properties</source>
        <translation>Propiedades</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="121"/>
        <source>Name:</source>
        <translation>Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="146"/>
        <location filename="../../../scribus/annot.cpp" line="274"/>
        <source>Text</source>
        <translation>Texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="152"/>
        <source>Font for use with PDF 1.3:</source>
        <translation>Tipografía a usar para PDF-1.3:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="176"/>
        <source>Border</source>
        <translation>Borde</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="182"/>
        <source>Color:</source>
        <translation>Color:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="2109"/>
        <source>None</source>
        <translation>Ninguno</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="197"/>
        <source>Width:</source>
        <translation>Anchura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="201"/>
        <source>Thin</source>
        <translation>Delgado</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="201"/>
        <location filename="../../../scribus/annot.cpp" line="311"/>
        <source>Normal</source>
        <translation>Normal</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="201"/>
        <source>Wide</source>
        <translation>Ancho</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="209"/>
        <source>Style:</source>
        <translation>Estilo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="213"/>
        <source>Solid</source>
        <translation>Sólido</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="213"/>
        <source>Dashed</source>
        <translation>A trazos</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="213"/>
        <source>Underline</source>
        <translation>Subrayado</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="214"/>
        <source>Beveled</source>
        <translation>Biselado</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="214"/>
        <source>Inset</source>
        <translation>Recuadro</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="224"/>
        <source>Other</source>
        <translation>Otro</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="230"/>
        <source>Read Only</source>
        <translation>Sólo Lectura</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="236"/>
        <source>Required</source>
        <translation>Requerido</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="248"/>
        <source>Visibility:</source>
        <translation>Visibilidad:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="252"/>
        <source>Visible</source>
        <translation>Visible</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="252"/>
        <source>Hidden</source>
        <translation>Oculto</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="252"/>
        <source>No Print</source>
        <translation>No Imprimir</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="253"/>
        <source>No View</source>
        <translation>No Mostrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="262"/>
        <source>Appearance</source>
        <translation>Apariencia</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="280"/>
        <source>Text for Button Down</source>
        <translation>Texto al Presionar el Botón</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="283"/>
        <source>Text for Roll Over</source>
        <translation>Texto al Pasar por Encima</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="294"/>
        <source>Icons</source>
        <translation>Iconos</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="300"/>
        <source>Use Icons</source>
        <translation>Usar Iconos</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="321"/>
        <location filename="../../../scribus/annot.cpp" line="339"/>
        <location filename="../../../scribus/annot.cpp" line="357"/>
        <source>Remove</source>
        <translation>Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="329"/>
        <source>Pressed</source>
        <translation>Pulsado</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="347"/>
        <source>Roll Over</source>
        <translation>Cursor encima</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="366"/>
        <source>Icon Placement...</source>
        <translation>Disposición del icono...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="414"/>
        <source>Highlight</source>
        <translation>Realzar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="421"/>
        <source>Invert</source>
        <translation>Invertir</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="421"/>
        <source>Outlined</source>
        <translation>Contorneado</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="421"/>
        <source>Push</source>
        <translation>Pulsar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="438"/>
        <source>Multi-Line</source>
        <translation>Multilínea</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="442"/>
        <source>Password</source>
        <translation>Contraseña</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="449"/>
        <source>Limit of</source>
        <translation>Límite de</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="460"/>
        <source>Characters</source>
        <translation>caracteres</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="466"/>
        <source>Do Not Scroll</source>
        <translation>No desplazar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="470"/>
        <source>Do Not Spell Check</source>
        <translation>No revisar ortografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="485"/>
        <source>Check Style:</source>
        <translation>Estilo de marca:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Check</source>
        <translation>V</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Cross</source>
        <translation>Cruz</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Diamond</source>
        <translation>Diamante</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Circle</source>
        <translation>Círculo</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Star</source>
        <translation>Estrella</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Square</source>
        <translation>Cuadrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="502"/>
        <source>Default is Checked</source>
        <translation>Seleccionada por defecto</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="514"/>
        <source>Editable</source>
        <translation>Editable</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="521"/>
        <source>Options</source>
        <translation>Opciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="537"/>
        <location filename="../../../scribus/annot.cpp" line="2072"/>
        <source>Go To</source>
        <translation>Ir a</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="538"/>
        <location filename="../../../scribus/annot.cpp" line="2073"/>
        <source>Submit Form</source>
        <translation>Enviar formulario</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="538"/>
        <location filename="../../../scribus/annot.cpp" line="2073"/>
        <source>Reset Form</source>
        <translation>Reiniciar formulario</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="538"/>
        <location filename="../../../scribus/annot.cpp" line="2073"/>
        <source>Import Data</source>
        <translation>Importar datos</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="570"/>
        <source>Event:</source>
        <translation>Evento:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="573"/>
        <location filename="../../../scribus/annot.cpp" line="2052"/>
        <source>Mouse Up</source>
        <translation>Se suelta el ratón</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="573"/>
        <location filename="../../../scribus/annot.cpp" line="2052"/>
        <source>Mouse Down</source>
        <translation>Se presiona el ratón</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="573"/>
        <location filename="../../../scribus/annot.cpp" line="2052"/>
        <source>Mouse Enter</source>
        <translation>El cursor entra</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="574"/>
        <location filename="../../../scribus/annot.cpp" line="2053"/>
        <source>Mouse Exit</source>
        <translation>El cursor sale</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="574"/>
        <location filename="../../../scribus/annot.cpp" line="2053"/>
        <source>On Focus</source>
        <translation>Se obtiene el foco</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="574"/>
        <location filename="../../../scribus/annot.cpp" line="2053"/>
        <source>On Blur</source>
        <translation>Se pierde el foco</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="585"/>
        <source>Script:</source>
        <translation>Script:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="604"/>
        <location filename="../../../scribus/annot.cpp" line="933"/>
        <location filename="../../../scribus/annot.cpp" line="959"/>
        <location filename="../../../scribus/annot.cpp" line="1036"/>
        <location filename="../../../scribus/annot.cpp" line="1111"/>
        <source>Edit...</source>
        <translation>Editar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="670"/>
        <source>Submit to URL:</source>
        <translation>Enviar a URL:</translation>
    </message>
    <message>
        <source>Submit Data as HTML</source>
        <translation type="obsolete">Enviar dato como HTML</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="707"/>
        <source>Import Data from:</source>
        <translation>Importar datos desde:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="610"/>
        <source>Destination</source>
        <translation>Destino</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="616"/>
        <source>To File:</source>
        <translation>A archivo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="623"/>
        <source>Change...</source>
        <translation>Cambiar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="632"/>
        <source>Page:</source>
        <translation>Página:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="646"/>
        <source>X-Pos:</source>
        <translation>Posición X:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="649"/>
        <location filename="../../../scribus/annot.cpp" line="658"/>
        <source> pt</source>
        <translation> pt</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="654"/>
        <source>Y-Pos:</source>
        <translation>Posición Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="716"/>
        <source>Action</source>
        <translation>Acción</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="747"/>
        <source>Field is formatted as:</source>
        <translation>Campo formateado como:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Plain</source>
        <translation>Sin formato</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Number</source>
        <translation>Número</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Percentage</source>
        <translation>Porcentaje</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Date</source>
        <translation>Fecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Time</source>
        <translation>Hora</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Custom</source>
        <translation>Personalizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="768"/>
        <source>Number Format</source>
        <translation>Formato de Número</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="777"/>
        <location filename="../../../scribus/annot.cpp" line="836"/>
        <source>Decimals:</source>
        <translation>Decimales:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="791"/>
        <source>Use Currency Symbol</source>
        <translation>Usar Símbolo de Moneda</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="800"/>
        <source>Prepend Currency Symbol</source>
        <translation>Símbolo de Moneda Delante</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="804"/>
        <location filename="../../../scribus/annot.cpp" line="847"/>
        <source>Formatting</source>
        <translation>Formato</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="827"/>
        <source>Percent Format</source>
        <translation>Formato de Porcentaje</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="870"/>
        <source>Date Format</source>
        <translation>Formato de Fecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="896"/>
        <source>Time Format</source>
        <translation>Formato de Hora</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="918"/>
        <source>Custom Scripts</source>
        <translation>Scripts Propios</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="930"/>
        <source>Format:</source>
        <translation>Formato:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="956"/>
        <source>Keystroke:</source>
        <translation>Pulsación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="980"/>
        <source>Format</source>
        <translation>Formato</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="996"/>
        <source>Value is not validated</source>
        <translation>El valor no se valida</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1005"/>
        <source>Value must be greater than or equal to:</source>
        <translation>El valor debe ser mayor o igual que:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1009"/>
        <source>and less or equal to:</source>
        <translation>y menor o igual que:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1020"/>
        <source>Custom validate script:</source>
        <translation>Script propio de validación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1041"/>
        <source>Validate</source>
        <translation>Validar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1058"/>
        <source>Value is not calculated</source>
        <translation>El valor no se calcula</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1067"/>
        <source>Value is the</source>
        <translation>Valor es el</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1072"/>
        <source>sum</source>
        <translation>total</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1072"/>
        <source>product</source>
        <translation>producto</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1072"/>
        <source>average</source>
        <translation>promedio</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1072"/>
        <source>minimum</source>
        <translation>mínimo</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1073"/>
        <source>maximum</source>
        <translation>máximo</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1080"/>
        <source>of the following fields:</source>
        <translation>de los siguientes campos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1090"/>
        <source>Pick...</source>
        <translation>Elegir...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1095"/>
        <source>Custom calculation script:</source>
        <translation>Script de cálculo propio:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1115"/>
        <source>Calculate</source>
        <translation>Calcular</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1134"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1138"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1189"/>
        <location filename="../../../scribus/annot.cpp" line="1190"/>
        <source>Flag is ignored for PDF 1.3</source>
        <translation>Opción ignorada por PDF 1.3</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1191"/>
        <source>Enter a comma separated list of fields here</source>
        <translation>Introducir aquí una lista de campos separados por comas</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1192"/>
        <source>You need at least the Icon for Normal to use Icons for Buttons</source>
        <translation>Se necesita como mínimo el icono Normal para usar iconos en los botones</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1302"/>
        <location filename="../../../scribus/annot.cpp" line="1333"/>
        <location filename="../../../scribus/annot.cpp" line="1357"/>
        <location filename="../../../scribus/annot.cpp" line="2267"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1477"/>
        <source>Example:</source>
        <translation>Ejemplo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="2101"/>
        <source>Selection Change</source>
        <translation>Se cambia la selección</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="2267"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation>Archivos PDF (*.pdf);;Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="537"/>
        <location filename="../../../scribus/annot.cpp" line="2072"/>
        <location filename="../../../scribus/annot.cpp" line="2110"/>
        <source>JavaScript</source>
        <translation>Javascript</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="421"/>
        <source>None</source>
        <comment>highlight</comment>
        <translation>Ninguno</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="537"/>
        <location filename="../../../scribus/annot.cpp" line="2072"/>
        <source>None</source>
        <comment>action</comment>
        <translation>Ninguna</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="134"/>
        <source>Tooltip:</source>
        <translation>Sugerencia:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="242"/>
        <source>Do Not Export Value</source>
        <translation>No exportar valor</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1334"/>
        <location filename="../../../scribus/annot.cpp" line="1358"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;All Files (*)</source>
        <translation>Imágenes (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1303"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;%1;;All Files (*)</source>
        <translation>Imágenes (*.tif *.png *.jpg *.xpm);;%1;;Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="625"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="682"/>
        <source>Submit format:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="685"/>
        <source>FDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="685"/>
        <source>HTML</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="685"/>
        <source>XFDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="685"/>
        <source>PDF</source>
        <translation type="unfinished">PDF</translation>
    </message>
</context>
<context>
    <name>Annota</name>
    <message>
        <location filename="../../../scribus/annota.cpp" line="47"/>
        <source>Annotation Properties</source>
        <translation>Propiedades de anotación</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="77"/>
        <source>Text</source>
        <translation>Texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="78"/>
        <source>Link</source>
        <translation>Enlace</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="79"/>
        <source>External Link</source>
        <translation>Enlace externo</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="80"/>
        <source>External Web-Link</source>
        <translation>Enlace web externo</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="82"/>
        <source>&amp;Type:</source>
        <translation>&amp;Tipo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="118"/>
        <source>Destination</source>
        <translation>Destino</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="129"/>
        <source>C&amp;hange...</source>
        <translation>Cam&amp;biar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="147"/>
        <source>&amp;Page:</source>
        <translation>&amp;Página:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="168"/>
        <location filename="../../../scribus/annota.cpp" line="177"/>
        <source> pt</source>
        <translation> pt</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="171"/>
        <source>&amp;X-Pos</source>
        <translation>Posición &amp;X</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="179"/>
        <source>&amp;Y-Pos:</source>
        <translation>Posicón &amp;Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="409"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="409"/>
        <source>%1;;All Files (*)</source>
        <translation>%1;;Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="131"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ApplyMasterPageDialog</name>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="267"/>
        <source>Apply Master Page</source>
        <translation>Aplicar página maestra</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="268"/>
        <source>&amp;Master Page:</source>
        <translation>Página &amp;maestra:</translation>
    </message>
    <message>
        <source>Apply To</source>
        <translation type="obsolete">Aplicar a</translation>
    </message>
    <message>
        <source>Current &amp;page</source>
        <translation type="obsolete">&amp;Página actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="271"/>
        <source>Alt+P</source>
        <translation>Alt+P</translation>
    </message>
    <message>
        <source>&amp;Even pages</source>
        <translation type="obsolete">Páginas par&amp;es</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="273"/>
        <source>Alt+E</source>
        <translation>Alt+E</translation>
    </message>
    <message>
        <source>O&amp;dd pages</source>
        <translation type="obsolete">Páginas &amp;impares</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="275"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <source>&amp;All pages</source>
        <translation type="obsolete">Todas las &amp;Páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="277"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <source>&amp;Within range</source>
        <translation type="obsolete">D&amp;entro del rango</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="279"/>
        <source>Alt+W</source>
        <translation>Alt+W</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="281"/>
        <source>to</source>
        <translation>a</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="283"/>
        <source>Alt+O</source>
        <translation>Alt+O</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="285"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="280"/>
        <source>Apply the selected master page to even, odd or all pages within the following range</source>
        <translation>Aplicar la página maestra seleccionada a páginas pares, impares o a todas las páginas dentro del siguiente rango</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="52"/>
        <source>Possible Hyphenation</source>
        <translation>Posible división</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="269"/>
        <source>Apply to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="270"/>
        <source>Current &amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="272"/>
        <source>&amp;Even Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="274"/>
        <source>O&amp;dd Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="276"/>
        <source>&amp;All Pages</source>
        <translation type="unfinished">&amp;Todas las páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="278"/>
        <source>&amp;Within Range</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AspellPlugin</name>
    <message>
        <source>Spell-Checker</source>
        <translation type="obsolete">Corrector ortográfico</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="64"/>
        <source>Spell-checking support</source>
        <translation>Soporte para corrección ortográfica</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="66"/>
        <source>Adds support for spell-checking via aspell. Languages can be chosen from among the installed aspell dictionaries, and spell-checking can be done on the fly, or on selected text.</source>
        <translation>Añade soporte para corrección ortográfica mediante aspell. Los idiomas se pueden seleccionar entre los diccionarios de aspell instalados, y la corrección ortográfica se puede automáticamente o sobre un texto seleccionado.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="70"/>
        <source>0.1</source>
        <translation>0.1</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="32"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="97"/>
        <source>Aspell Plugin Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AspellPluginBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="13"/>
        <source>Spell Check</source>
        <translation>Corrección ortográfica</translation>
    </message>
    <message>
        <source>Mis-spelling:</source>
        <translation type="obsolete">Error ortográfico:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="118"/>
        <source>Replacement:</source>
        <translation>Cambiar por:</translation>
    </message>
    <message>
        <source>Active dictionary: </source>
        <translation type="obsolete">Diccionario activo: </translation>
    </message>
    <message>
        <source>Personal
Dictionary</source>
        <translation type="obsolete">Diccionario
personal</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="278"/>
        <source>&amp;Add Word</source>
        <translation>&amp;Añadir palabra</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="306"/>
        <source>&amp;Change</source>
        <translation>&amp;Cambiar</translation>
    </message>
    <message>
        <source>C&amp;hange All</source>
        <translation type="obsolete">Cam&amp;biar todas</translation>
    </message>
    <message>
        <source>&amp;Skip</source>
        <translation type="obsolete">&amp;Omitir</translation>
    </message>
    <message>
        <source>S&amp;kip All</source>
        <translation type="obsolete">O&amp;mitir todas</translation>
    </message>
    <message>
        <source>&amp;Exit</source>
        <translation type="obsolete">&amp;Salir</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="45"/>
        <source>Not in Dictionary:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="70"/>
        <source>Word that was not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="125"/>
        <source>Replacement text for the current word that was not found in the dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="181"/>
        <source>Active Dictionary: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="194"/>
        <source>The currently active dictionary. Scribus uses aspell for dictionary support.&lt;br /&gt;If you require updated or more dictionaries, you should install them via your system&apos;s installation system or package manager.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="225"/>
        <source>Ignore the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="228"/>
        <source>&amp;Ignore</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="247"/>
        <source>Ignore all occurrences of the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="250"/>
        <source>I&amp;gnore All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="275"/>
        <source>Add the current word to the your personal spelling dictionary for future use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="303"/>
        <source>Change the current word that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="331"/>
        <source>Change all occurrences of the current word in the text that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="334"/>
        <source>Change A&amp;ll</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="372"/>
        <source>Close</source>
        <translation type="unfinished">Cerrar</translation>
    </message>
</context>
<context>
    <name>AspellPluginImpl</name>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="39"/>
        <source>Loaded </source>
        <translation>Cargado </translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="39"/>
        <source>default </source>
        <translation>por defecto </translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="39"/>
        <source> aspell dictionary.</source>
        <translation> diccionario aspell.</translation>
    </message>
    <message>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in aspell speller configuration.</source>
        <translation type="obsolete">aspellplugin (AspellPluginImpl::AspellPluginImpl): Error en la configuración del corrector aspell.</translation>
    </message>
    <message>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in creating aspell speller.</source>
        <translation type="obsolete">aspellplugin (AspellPluginImpl::AspellPluginImpl): Error al crear el corrector aspell.</translation>
    </message>
    <message>
        <source>Spell-Checker</source>
        <translation type="obsolete">Corrector ortográfico</translation>
    </message>
    <message>
        <source>Spell-checking completed.</source>
        <translation type="obsolete">Corrección ortográfica completada.</translation>
    </message>
    <message>
        <source>Spell-checking done.</source>
        <translation type="obsolete">Corrección ortográfica realizada.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="382"/>
        <source>AspellPluginImpl::on_fskipAllBtn_clicked(): Unable to skip all instances of &quot;</source>
        <translation>AspellPluginImpl::on_fskipAllBtn_clicked(): Imposible omitir todas las instancias de &quot;</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="384"/>
        <source> by adding it to the session list.</source>
        <translation> añadiéndolo a la lista de sesión.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="405"/>
        <source>AspellPluginImpl::on_faddWordBtn_clicked(): Unable to add word to personal list.</source>
        <translation>AspellPluginImpl::on_faddWordBtn_clicked(): Imposible añadir palabra a la lista personal.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="258"/>
        <source>Spelling check complete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="97"/>
        <source>Spell Checker Plugin Failed to Initialise.
Configuration invalid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="104"/>
        <source>Spell Checker Plugin Failed to Initialise.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="106"/>
        <source>No Aspell dictionaries could be found.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="259"/>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="451"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="72"/>
        <source>No available Aspell dictionaries found. Install some, please.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="452"/>
        <source>Do you want start from the beginning of the selection with new language selected?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AutoformButtonGroup</name>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="36"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1281"/>
        <source>Arrows</source>
        <translation>Flechas</translation>
    </message>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="44"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1282"/>
        <source>Flow Chart</source>
        <translation>Diagramas de flujo</translation>
    </message>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="53"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1283"/>
        <source>Jigsaw</source>
        <translation>Puzzle</translation>
    </message>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="66"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1284"/>
        <source>Specials</source>
        <translation>Especiales</translation>
    </message>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="21"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1280"/>
        <source>Default Shapes</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Barcode</name>
    <message>
        <source>Scribus frontend for Pure Postscript Barcode Writer</source>
        <translation type="obsolete">Interfaz de Scribus para Pure Postscript Barcode Writer</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode...</source>
        <translation>Código de &amp;barras...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure PostScript Barcode Writer</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGenerator</name>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="320"/>
        <source>Error opening file: %1</source>
        <translation>Error al abrir archivo: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="41"/>
        <source>12 or 13 digits</source>
        <translation>12 ó 13 dígitos</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="43"/>
        <source>8 digits</source>
        <translation>8 dígitos</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="45"/>
        <source>11 or 12 digits</source>
        <translation>11 ó 12 dígitos</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="47"/>
        <source>7 or 8 digits</source>
        <translation>7 u 8 dígitos</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="49"/>
        <source>5 digits</source>
        <translation>5 dígitos</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="51"/>
        <source>2 digits</source>
        <translation>2 dígitos</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="58"/>
        <source>Variable number of characters, digits and any of the symbols -. *$/+%.</source>
        <translation>Número variable de caracteres, dígitos y alguno de estos símbolos -. *$/+%.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="63"/>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="67"/>
        <source>Variable number of ASCII characters and special function symbols, starting with the appropriate start character for the initial character set. UCC/EAN-128s must have a mandatory FNC 1 symbol immediately following the start character.</source>
        <translation>Número variable de caracteres ASCII y símbolos de función especiales, empezando con el apropiado carácter de comienzo para el set inicial de caracteres. UCC/EAN-128s debe tener un símbolo FNC 1 obligatoriamente justo después del carácter de comienzo.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="70"/>
        <source>Variable number of digits and any of the symbols -$:/.+ABCD.</source>
        <translation>Número variable de dígitos y cualquier de estos símbolos -$:/.+ABCD.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="78"/>
        <source>Variable number of digits. An ITF-14 is 14 characters and does not have a check digit</source>
        <translation>Número variable de dígitos. Un ITF-14 son 14 caracteres y sin dígito de control</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="74"/>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="82"/>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="85"/>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="93"/>
        <source>Variable number of digits</source>
        <translation>Número variable de dígitos</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="89"/>
        <source>Variable number of digits and capital letters</source>
        <translation>Número variable de dígitos y mayúsculas</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="98"/>
        <source>Variable number of hexadecimal characters</source>
        <translation>Número variable de caracteres hexadecimales</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="102"/>
        <source>Variable number of characters, digits and any symbols.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="353"/>
        <source>Barcode incomplete</source>
        <translation>Código de barras incompleto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="54"/>
        <source>12 or 13 digits with dashes. The legacy ISBN-10 format accepts 9 or 10 digits with dashes, but this standard was depreciated for public use after 1st January 2007. (Note: To convert an old ISBN-10 to a new ISBN-13, prefix 978- to the first 9 digits, e.g. 1-56592-479-7 -&gt; 978-1-56592-479. The final check-digit will be calculated automatically.)</source>
        <translation>12 ó 13 dígitos con guiones. El antiguo formato ISBN-10 acepta 9 ó 10 dígitos con guiones, pero este estándar fue retirado para uso público después del 1 de enero de 2007. (Nota: para convertir el antiguo ISBN-10 al nuevo ISBN-13, anteponga 978- a los primeros 9 dígitos. Ejemplo: 1-56592-479-7 -&gt; 978-1-56592-479. El último dígito de control se calculará automáticamente.)</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="109"/>
        <source>Select Type</source>
        <translation>Seleccionar tipo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="149"/>
        <source>Select Barcode Type</source>
        <translation>Seleccionar tipo de código de barras</translation>
    </message>
</context>
<context>
    <name>BarcodeGeneratorBase</name>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="140"/>
        <source>&amp;Type:</source>
        <translation>&amp;Tipo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="133"/>
        <source>Select one of the available barcode type here</source>
        <translation>Seleccione alguno de los tipos de codigos de barras disponibles aquí</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="113"/>
        <source>The numeric representation of the code itself. See the help message below</source>
        <translation>La representación numérica del código mismo. Vea el mensaje de ayuda siguiente</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="103"/>
        <source>Reset the barcode samples</source>
        <translation>Reinicia los códigos de barras de ejemplo</translation>
    </message>
    <message>
        <source>&amp;Include text in barcode</source>
        <translation type="obsolete">&amp;Incluir texto en los códigos de barra</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="81"/>
        <source>Alt+I</source>
        <translation>Alt+I</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="75"/>
        <source>If checked, there will be numbers in the barcode too</source>
        <translation>Si está marcado, el código de barras también tendrá números</translation>
    </message>
    <message>
        <source>&amp;Guard whitespace</source>
        <translation type="obsolete">&amp;Guardar espacio en blanco</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="68"/>
        <source>Alt+G</source>
        <translation>Alt+G</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="62"/>
        <source>Draw arrows to be sure of space next the code</source>
        <translation>Dibujar flechas para asegurarse del espacio próximo al código</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="156"/>
        <source>Colors</source>
        <translation>Colores</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="184"/>
        <source>&amp;Background</source>
        <translation>&amp;Fondo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="187"/>
        <source>Alt+B</source>
        <translation>Alt+B</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="181"/>
        <source>Background color - under the code lines</source>
        <translation>Color de fondo - bajo las líneas del código</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="216"/>
        <source>&amp;Lines</source>
        <translation>&amp;Líneas</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="219"/>
        <source>Alt+L</source>
        <translation>Alt+L</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="213"/>
        <source>Color of the lines in barcode</source>
        <translation>Color de las líneas en el código de barras</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="248"/>
        <source>&amp;Text</source>
        <translation>&amp;Texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="251"/>
        <source>Alt+T</source>
        <translation>Alt+T</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="245"/>
        <source>Color of the text and numbers</source>
        <translation>Color del texto y los números</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="280"/>
        <source>Hints and help is shown here</source>
        <translation>Aquí se muestran las sugerencias y la ayuda</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="290"/>
        <source>Preview of the result. 72dpi sample.</source>
        <translation>Vista previa del resultado. Muestra a 72dpi.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="120"/>
        <source>Co&amp;de:</source>
        <translation>Có&amp;digo:</translation>
    </message>
    <message>
        <source>I&amp;nclude checksum</source>
        <translation type="obsolete">I&amp;ncluir checksum</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="55"/>
        <source>Alt+N</source>
        <translation>Alt+N</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="49"/>
        <source>Generate and include a checksum in barcode</source>
        <translation type="unfinished">Generar e incluir un checksum en el código de barras</translation>
    </message>
    <message>
        <source>Incl&amp;ude checksum digit</source>
        <translation type="obsolete">Incl&amp;uir dígito del checksum</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="42"/>
        <source>Alt+U</source>
        <translation>Alt+U</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="36"/>
        <source>Include the checksum digit in the barcode text</source>
        <translation type="unfinished">Incluir el dígito checksum en el texto del código de barrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Insert Barcode</source>
        <translation>Insertar código de barras</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="24"/>
        <source>Format</source>
        <translation>Formato</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="39"/>
        <source>Incl&amp;ude Checksum Digit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="52"/>
        <source>I&amp;nclude Checksum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="65"/>
        <source>&amp;Guard Whitespace</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="78"/>
        <source>&amp;Include Text in Barcode</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Biblio</name>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1457"/>
        <source>Scrapbook</source>
        <translation>Álbum de recortes</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="840"/>
        <source>Rename</source>
        <translation>Renombrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="842"/>
        <source>Delete</source>
        <translation>Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1231"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1239"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1317"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1389"/>
        <source>Object</source>
        <translation>Objeto</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="915"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1102"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1243"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1392"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="915"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1243"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1392"/>
        <source>New Entry</source>
        <translation>Nueva entrada</translation>
    </message>
    <message>
        <source>Name &quot;%1&quot; is not unique.
Please choose another.</source>
        <translation type="obsolete">El nombre &quot;%1&quot; no es único.
Por favor, seleccione otro.</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="663"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="702"/>
        <source>Choose a Scrapbook Directory</source>
        <translation>Elige un directorio para el álbum de recortes</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="764"/>
        <source>Choose a Directory</source>
        <translation>Elige un directorio</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="742"/>
        <source>Choose a scrapbook file to import</source>
        <translation>Elige un archivo de álbum de recortes para importar</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1458"/>
        <source>Create a new scrapbook page</source>
        <translation>Crear una nueva página de álbum de recortes</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1459"/>
        <source>Load an existing scrapbook</source>
        <translation>Cargar un álbum de recortes existente</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1460"/>
        <source>Save the selected scrapbook</source>
        <translation>Guardar el álbum de recortes seleccionado</translation>
    </message>
    <message>
        <source>Import an scrapbook file from Scribus &lt;=1.3.2</source>
        <translation type="obsolete">Importar un archivo de álbum de recortes de Scribus &lt;=1.3.2</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1462"/>
        <source>Close the selected scrapbook</source>
        <translation>Cerrar el álbum de recortes seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="847"/>
        <source>Copy To:</source>
        <translation>Copiar a:</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="848"/>
        <source>Move To:</source>
        <translation>Mover a:</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="553"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="554"/>
        <source>Main</source>
        <translation>Principal</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="556"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="557"/>
        <source>Copied Items</source>
        <translation>Objetos copiados</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1102"/>
        <source>New Name</source>
        <translation>Nuevo nombre</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="744"/>
        <source>Scrapbook (*.scs *.SCS)</source>
        <translation>Álbum de recortes (*.scs *.SCS)</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="836"/>
        <source>Paste to Page</source>
        <translation>Pegar en página</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="891"/>
        <source>Save as...</source>
        <translation>Guardar como...</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="894"/>
        <source>Close</source>
        <translation>Cerrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="897"/>
        <source>Delete Contents</source>
        <translation>Eliminar contenido</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1057"/>
        <source>Do you really want to delete all entries?</source>
        <translation>¿Desea eliminar todos los registros?</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1461"/>
        <source>Import a scrapbook file from Scribus &lt;=1.3.2</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BookPalette</name>
    <message>
        <location filename="../../../scribus/bookmarkpalette.cpp" line="51"/>
        <source>Bookmarks</source>
        <translation>Marcadores</translation>
    </message>
</context>
<context>
    <name>ButtonIcon</name>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="29"/>
        <source>Icon Placement</source>
        <translation>Posición del icono</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="38"/>
        <source>Layout:</source>
        <translation>Disposición:</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption only</source>
        <translation>Sólo texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="41"/>
        <source>Icon only</source>
        <translation>Sólo icono</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption below Icon</source>
        <translation>Texto debajo del icono</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption above Icon</source>
        <translation>Texto encima del icono</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption right to Icon</source>
        <translation>Texto a la derecha del icono</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption left to Icon</source>
        <translation>Texto a la izquierda del icono</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption overlays Icon</source>
        <translation>Texto superpuesto al icono</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="50"/>
        <source>Scale:</source>
        <translation>Escalado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="55"/>
        <source>Always</source>
        <translation>Siempre</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="55"/>
        <source>When Icon is too small</source>
        <translation>Cuando el icono es demasiado pequeño</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="56"/>
        <source>When Icon is too big</source>
        <translation>Cuando el icono es demasiado grande</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="56"/>
        <source>Never</source>
        <translation>Nunca</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="63"/>
        <source>Scale How:</source>
        <translation>Modo de escalado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="66"/>
        <source>Proportional</source>
        <translation>Proporcional</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="67"/>
        <source>Non Proportional</source>
        <translation>No proporcional</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="90"/>
        <source>Icon</source>
        <translation>Icono</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="117"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="121"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="124"/>
        <source>Reset</source>
        <translation>Reiniciar</translation>
    </message>
</context>
<context>
    <name>CMSPrefs</name>
    <message>
        <source>&amp;Activate Color Management</source>
        <translation type="obsolete">Ac&amp;tivar ajustes de color</translation>
    </message>
    <message>
        <source>System Profiles</source>
        <translation type="obsolete">Perfiles del sistema</translation>
    </message>
    <message>
        <source>&amp;Monitor:</source>
        <translation type="obsolete">&amp;Monitor:</translation>
    </message>
    <message>
        <source>P&amp;rinter:</source>
        <translation type="obsolete">Im&amp;presora:</translation>
    </message>
    <message>
        <source>Rendering Intents</source>
        <translation type="obsolete">Modos de visualización</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefs.cpp" line="69"/>
        <source>Perceptual</source>
        <translation>Perceptivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefs.cpp" line="70"/>
        <source>Saturation</source>
        <translation>Saturación</translation>
    </message>
    <message>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="obsolete">Sim&amp;ular impresora en la pantalla</translation>
    </message>
    <message>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="obsolete">Indicar colores fuera de &amp;gama</translation>
    </message>
    <message>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="obsolete">Usar compensación de punto &amp;negro</translation>
    </message>
    <message>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">El perfil de color que hayas generado o que te haya dado el fabricante.
Debería ser específico para tu monitor y no uno genérico (como sRGB).</translation>
    </message>
    <message>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">El perfil de color del fabricante para tu modelo de impresora.
Debería ser específico para tu impresora y no uno genérico (como sRGB).</translation>
    </message>
    <message>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="obsolete">Activar comprobación software (soft proofing) de cómo se imprimirán 
los colores del documento, basada en el perfil de impresora seleccionado.</translation>
    </message>
    <message>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="obsolete">Una forma de mostrar en la pantalla los colores que no se imprimirán apropiadamente.
Esto requiere perfiles muy precisos y sólo sirve como un aviso.</translation>
    </message>
    <message>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="obsolete">Compensación de punto negro es un método de mejorar el contraste en las fotos.
Se recomienda que lo actives si tienes fotos en el documento.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefs.cpp" line="69"/>
        <source>Relative Colorimetric</source>
        <translation>Colorimetría relativa</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefs.cpp" line="70"/>
        <source>Absolute Colorimetric</source>
        <translation>Colorimetría absoluta</translation>
    </message>
    <message>
        <source>Default color profile for imported CMYK images</source>
        <translation type="obsolete">Perfil de color predeterminado para imágenes CMYK importadas</translation>
    </message>
    <message>
        <source>Default color profile for imported RGB images</source>
        <translation type="obsolete">Perfil de color predeterminado para imágenes RGB importadas</translation>
    </message>
    <message>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="obsolete">Colores sólidos &amp;RGB:</translation>
    </message>
    <message>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="obsolete">Colores solidos &amp;CMYK:</translation>
    </message>
    <message>
        <source>Sol&amp;id Colors:</source>
        <translation type="obsolete">Colores sól&amp;idos:</translation>
    </message>
    <message>
        <source>Convert all colors to printer space</source>
        <translation type="obsolete">Convertir todos los colores al espacio de la impresora</translation>
    </message>
    <message>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="obsolete">Perfil de color predeterminado para colores sólidos RGB en la página</translation>
    </message>
    <message>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="obsolete">Perfil de color predeterminado para colores sólidos CMYK en la página</translation>
    </message>
    <message>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Intento de renderizado predeterminado para colores sólidos. A no ser que sepas
por qué cambiarlo, Colorimetría relativa o perceptiva debería ser elegida.</translation>
    </message>
    <message>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Intento de renderizado predeterminado para imágenes. A no ser que sepas
por qué cambiarlo, Colorimetría relativa o perceptiva deberia ser elegida.</translation>
    </message>
    <message>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="obsolete">Simula un entorno de manejo de color completo:
todos los colores, rgb o cmyk, son convertidos al espacio de
color de la impresora.</translation>
    </message>
    <message>
        <source>&amp;RGB Images:</source>
        <translation type="obsolete">Imágenes &amp;RGB:</translation>
    </message>
    <message>
        <source>&amp;CMYK Images:</source>
        <translation type="obsolete">Imágenes &amp;CMYK:</translation>
    </message>
    <message>
        <source>Images:</source>
        <translation type="obsolete">Imágenes:</translation>
    </message>
</context>
<context>
    <name>CMSPrefsBase</name>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished">Formulario</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="40"/>
        <source>&amp;Activate Color Management</source>
        <translation type="unfinished">Ac&amp;tivar ajustes de color</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="50"/>
        <source>System Profiles</source>
        <translation type="unfinished">Perfiles del sistema</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="74"/>
        <source>&amp;RGB Images:</source>
        <translation type="unfinished">Imágenes &amp;RGB:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="90"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="unfinished">Perfil de color predeterminado para imágenes RGB importadas</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="97"/>
        <source>&amp;CMYK Images:</source>
        <translation type="unfinished">Imágenes &amp;CMYK:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="113"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="unfinished">Perfil de color predeterminado para imágenes CMYK importadas</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="120"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="unfinished">Colores sólidos &amp;RGB:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="136"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="unfinished">Perfil de color predeterminado para colores sólidos RGB en la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="143"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="unfinished">Colores solidos &amp;CMYK:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="159"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="unfinished">Perfil de color predeterminado para colores sólidos CMYK en la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="166"/>
        <source>&amp;Monitor:</source>
        <translation type="unfinished">&amp;Monitor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="182"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">El perfil de color que hayas generado o que te haya dado el fabricante.
Debería ser específico para tu monitor y no uno genérico (como sRGB).</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="190"/>
        <source>P&amp;rinter:</source>
        <translation type="unfinished">Im&amp;presora:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="206"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">El perfil de color del fabricante para tu modelo de impresora.
Debería ser específico para tu impresora y no uno genérico (como sRGB).</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="220"/>
        <source>Rendering Intents</source>
        <translation type="unfinished">Modos de visualización</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="244"/>
        <source>Images:</source>
        <translation type="unfinished">Imágenes:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="260"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished">Intento de renderizado predeterminado para imágenes. A no ser que sepas
por qué cambiarlo, Colorimetría relativa o perceptiva deberia ser elegida.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="268"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="unfinished">Colores sól&amp;idos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="284"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished">Intento de renderizado predeterminado para colores sólidos. A no ser que sepas
por qué cambiarlo, Colorimetría relativa o perceptiva debería ser elegida.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="298"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="unfinished">Activar comprobación software (soft proofing) de cómo se imprimirán 
los colores del documento, basada en el perfil de impresora seleccionado.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="302"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="unfinished">Sim&amp;ular impresora en la pantalla</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="329"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="unfinished">Simula un entorno de manejo de color completo:
todos los colores, rgb o cmyk, son convertidos al espacio de
color de la impresora.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="333"/>
        <source>Convert all colors to printer space</source>
        <translation type="unfinished">Convertir todos los colores al espacio de la impresora</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="340"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="unfinished">Una forma de mostrar en la pantalla los colores que no se imprimirán apropiadamente.
Esto requiere perfiles muy precisos y sólo sirve como un aviso.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="344"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="unfinished">Indicar colores fuera de &amp;gama</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="357"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="unfinished">Compensación de punto negro es un método de mejorar el contraste en las fotos.
Se recomienda que lo actives si tienes fotos en el documento.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="361"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="unfinished">Usar compensación de punto &amp;negro</translation>
    </message>
</context>
<context>
    <name>CMYKChoose</name>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="87"/>
        <source>Edit Color</source>
        <translation>Editar color</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="96"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="106"/>
        <source>Color &amp;Model</source>
        <translation>&amp;Modelo de color</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="111"/>
        <location filename="../../../scribus/cmykfw.cpp" line="654"/>
        <location filename="../../../scribus/cmykfw.cpp" line="673"/>
        <location filename="../../../scribus/cmykfw.cpp" line="892"/>
        <location filename="../../../scribus/cmykfw.cpp" line="899"/>
        <source>CMYK</source>
        <translation>CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="112"/>
        <location filename="../../../scribus/cmykfw.cpp" line="409"/>
        <location filename="../../../scribus/cmykfw.cpp" line="904"/>
        <source>RGB</source>
        <translation>RGB</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="113"/>
        <location filename="../../../scribus/cmykfw.cpp" line="757"/>
        <source>Web Safe RGB</source>
        <translation>RGB seguro para la red</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="136"/>
        <source>New</source>
        <translation>Nuevo</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="153"/>
        <source>Old</source>
        <translation>Antiguo</translation>
    </message>
    <message>
        <source>HSV-Colormap</source>
        <translation type="obsolete">Mapa de color HSV</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="261"/>
        <location filename="../../../scribus/cmykfw.cpp" line="698"/>
        <source>C:</source>
        <translation>C:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="283"/>
        <location filename="../../../scribus/cmykfw.cpp" line="310"/>
        <location filename="../../../scribus/cmykfw.cpp" line="337"/>
        <location filename="../../../scribus/cmykfw.cpp" line="364"/>
        <location filename="../../../scribus/cmykfw.cpp" line="695"/>
        <location filename="../../../scribus/cmykfw.cpp" line="696"/>
        <location filename="../../../scribus/cmykfw.cpp" line="697"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="288"/>
        <location filename="../../../scribus/cmykfw.cpp" line="699"/>
        <source>M:</source>
        <translation>M:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="315"/>
        <location filename="../../../scribus/cmykfw.cpp" line="700"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="342"/>
        <source>K:</source>
        <translation>K:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="438"/>
        <source>Dynamic Color Bars</source>
        <translation>Barras de color dinámicas</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="436"/>
        <source>Static Color Bars</source>
        <translation>Barras de color estáticas</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="742"/>
        <source>R:</source>
        <translation>R:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="743"/>
        <source>G:</source>
        <translation>G:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="744"/>
        <source>B:</source>
        <translation>B:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="120"/>
        <source>Is Spot Color</source>
        <translation>Es color de tinta plana</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="995"/>
        <source>You cannot create a color named &quot;%1&quot;.
It is a reserved name for transparent color</source>
        <translation>No puedes crear un color llamado &quot;%1&quot;.
Es un nombre reservado para color transparente</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="1004"/>
        <source>The name of the color already exists,
please choose another one.</source>
        <translation>El nombre del color ya existe,
por favor, elige otro.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="385"/>
        <source>Choosing this will make this color a spot color, thus creating another spot when creating plates or separations. This is used most often when a logo or other color needs exact representation or cannot be replicated with CMYK inks. Metallic and fluorescent inks are good examples which cannot be easily replicated with CMYK inks.</source>
        <translation>Al elegir esto, se convertirá este color en un color de tinta plana, creando con ello otra tinta al crear lánimas o separaciones. Eso se usa más a menudo cuando un logotipo u otro color necesita una representación exacta o no puede ser obtenido con tintas CMYK. Las tintas metálicas y fluorescentes son buenos ejemplos que no pueden ser fácilmente obtenidas con tintas CMYK.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="777"/>
        <location filename="../../../scribus/cmykfw.cpp" line="778"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation>Si el manejo de color está activado, un indicador de triángulo de emergencia es un aviso de que el color podría estar fuera de la gama de color del perfil de la impresora actual seleccionada. Lo que esto significa es que el color podría no imprimirse exactamente como indicado en la pantalla. En la ayuda online, en la sección Manejo de color, hay más sugerencias sobre los avisos de gama.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="988"/>
        <source>You cannot create a color without a name
Please give it a name</source>
        <translation>No puedes crear un color sin nombre
Por favor, nómbrelo</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="191"/>
        <source>HSV Color Map</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CWDialog</name>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="319"/>
        <source>Merging colors</source>
        <translation>Colores a mezclar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Error: </source>
        <translation>Error: </translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Color %1 exists already!</source>
        <translation>¡El color %1 ya existe!</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="330"/>
        <source>Color %1 appended.</source>
        <translation>Color %1 adicionado.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="334"/>
        <source>Now opening the color manager.</source>
        <translation>Abriendo ahora el gestor de color.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="337"/>
        <source>Color Merging</source>
        <translation>Mezcla de colores</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="486"/>
        <source>Unable to find the requested color. You have probably selected black, gray or white. There is no way to process this color.</source>
        <translation>Imposible encontrar el color requerido. Probablemente, has seleccionado negro, gris o blanco. No hay modo alguno de procesar este color.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="15"/>
        <source>Color Wheel</source>
        <translation>Rueda de color</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="45"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation>Pulsa en la rueda para obtener el color base. El modelo de color depende de la paleta elegida.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="52"/>
        <source>Result Colors</source>
        <translation>Colores resultantes</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="77"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="322"/>
        <source>CMYK</source>
        <translation>CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="82"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="543"/>
        <source>RGB</source>
        <translation>RGB</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="87"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="729"/>
        <source>HSV</source>
        <translation>HSV</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="106"/>
        <source>Colors of your chosen color scheme.</source>
        <translation>Colores del esquema de colores elegido.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="116"/>
        <source>Color Scheme Method</source>
        <translation>Método de esquema de colores</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="142"/>
        <source>Angle:</source>
        <translation>Ángulo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="152"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation>Diferencia entre el valor seleccionado y los contabilizados. Ver la documentación para más información.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="167"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation>Seleccione uno de los métodos para crear un esquema de color. Ver la documentación para más información.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="201"/>
        <source>Merge created colors into the document colors</source>
        <translation>Adicionar los colores generados a los colores del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="204"/>
        <source>&amp;Merge</source>
        <translation>&amp;Adicionar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="207"/>
        <source>Alt+M</source>
        <translation>Alt+M</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="214"/>
        <source>Replace created colors in the document colors</source>
        <translation>Reemplazar los colores creados en los colores del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="217"/>
        <source>&amp;Replace</source>
        <translation>&amp;Reemplazar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="220"/>
        <source>Alt+R</source>
        <translation>Alt+R</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="227"/>
        <source>Leave colors untouched</source>
        <translation>Dejar colores sin modificar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="230"/>
        <source>&amp;Cancel</source>
        <translation>&amp;Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="233"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="242"/>
        <source>Preview:</source>
        <translation>Vista previa:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="266"/>
        <source>Sample color scheme.</source>
        <translation>Ejemplo de esquema de color.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="285"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation>Simular defectos de visión comunes aquí. Selecciona el tipo de defecto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="292"/>
        <source>Vision Defect Type:</source>
        <translation>Tipo de defecto de visión:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="342"/>
        <source>C:</source>
        <translation>C:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="352"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="382"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="412"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="442"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="372"/>
        <source>M:</source>
        <translation>M:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="402"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="432"/>
        <source>K:</source>
        <translation>K:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="462"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="838"/>
        <source>RGB:</source>
        <translation>RGB:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="498"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="685"/>
        <source>HSV:</source>
        <translation>HSV:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="571"/>
        <source>R:</source>
        <translation>R:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="598"/>
        <source>G:</source>
        <translation>G:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="625"/>
        <source>B:</source>
        <translation>B:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="652"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="874"/>
        <source>CMYK:</source>
        <translation>CMYK:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="757"/>
        <source>H:</source>
        <translation>H:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="784"/>
        <source>S:</source>
        <translation>S:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="811"/>
        <source>V:</source>
        <translation>V:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="918"/>
        <source>Document</source>
        <translation>Documento</translation>
    </message>
</context>
<context>
    <name>Canvas</name>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2266"/>
        <location filename="../../../scribus/canvas.cpp" line="2294"/>
        <source>X: %1
Y: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2279"/>
        <source>X: %1</source>
        <translation type="unfinished">X: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2286"/>
        <source>Y: %1</source>
        <translation type="unfinished">Y: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2302"/>
        <source>Length: %1
Angle: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2304"/>
        <source>Width: %1
Height: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2316"/>
        <source>Angle: %1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CanvasMode_EyeDropper</name>
    <message>
        <location filename="../../../scribus/canvasmode_eyedropper.cpp" line="165"/>
        <source>The selected color does not exist in the document&apos;s color set. Please enter a name for this new color.</source>
        <translation type="unfinished">El color seleccionado no existe en el set de color del documento. Por favor, introduzca un nombre para este color nuevo.</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_eyedropper.cpp" line="168"/>
        <source>Color Not Found</source>
        <translation type="unfinished">Color no encontrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_eyedropper.cpp" line="172"/>
        <source>The name you have selected already exists. Please enter a different name for this new color.</source>
        <translation type="unfinished">El nombre que ha seleccionado ya existe. Por favor, introduzca uno diferente para este nuevo color.</translation>
    </message>
</context>
<context>
    <name>CanvasMode_FrameLinks</name>
    <message>
        <location filename="../../../scribus/canvasmode_framelinks.cpp" line="212"/>
        <location filename="../../../scribus/canvasmode_framelinks.cpp" line="219"/>
        <source>Linking Text Frames</source>
        <translation type="unfinished">Marcos de texto enlazados</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_framelinks.cpp" line="213"/>
        <source>You are trying to link a frame to itself.</source>
        <translation type="unfinished">Estás intentando enlazar un marco consigo mismo.</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_framelinks.cpp" line="220"/>
        <source>You are trying to link a frame which is already linked.</source>
        <translation type="unfinished">Estás intentando enlazar un marco ya enlazado.</translation>
    </message>
</context>
<context>
    <name>CanvasMode_Normal</name>
    <message>
        <location filename="../../../scribus/canvasmode_normal.cpp" line="1314"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Todos los formatos soportados</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_normal.cpp" line="1345"/>
        <source>Open</source>
        <translation type="unfinished">Abrir</translation>
    </message>
</context>
<context>
    <name>CharSelect</name>
    <message>
        <source>Font:</source>
        <translation type="obsolete">Tipografía:</translation>
    </message>
    <message>
        <source>Character Class:</source>
        <translation type="obsolete">Clase del carácter:</translation>
    </message>
    <message>
        <source>&amp;Insert</source>
        <translation type="obsolete">&amp;Insertar</translation>
    </message>
    <message>
        <source>C&amp;lear</source>
        <translation type="obsolete">B&amp;orrar</translation>
    </message>
    <message>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="obsolete">Inserta los caracteres en el texto en la posición del cursor</translation>
    </message>
    <message>
        <source>Delete the current selection(s).</source>
        <translation type="obsolete">Borra la/s selección/s actual/es.</translation>
    </message>
    <message>
        <source>Full Character Set</source>
        <translation type="obsolete">Set completo de caracteres</translation>
    </message>
    <message>
        <source>Basic Latin</source>
        <translation type="obsolete">Latín básico</translation>
    </message>
    <message>
        <source>Latin-1 Supplement</source>
        <translation type="obsolete">Latín-1 suplemento</translation>
    </message>
    <message>
        <source>Latin Extended-A</source>
        <translation type="obsolete">Latín Extendido-A</translation>
    </message>
    <message>
        <source>Latin Extended-B</source>
        <translation type="obsolete">Latín Extendido-B</translation>
    </message>
    <message>
        <source>General Punctuation</source>
        <translation type="obsolete">Puntuación general</translation>
    </message>
    <message>
        <source>Super- and Subscripts</source>
        <translation type="obsolete">Superíndices y subíndices</translation>
    </message>
    <message>
        <source>Currency Symbols</source>
        <translation type="obsolete">Símbolos monetarios</translation>
    </message>
    <message>
        <source>Arrows</source>
        <translation type="obsolete">Flechas</translation>
    </message>
    <message>
        <source>Mathematical Operators</source>
        <translation type="obsolete">Operadores matemáticos</translation>
    </message>
    <message>
        <source>Geometric Shapes</source>
        <translation type="obsolete">Formas geométricas</translation>
    </message>
    <message>
        <source>Miscellaneous Symbols</source>
        <translation type="obsolete">Símbolos variados</translation>
    </message>
    <message>
        <source>Ligatures</source>
        <translation type="obsolete">Ligaduras</translation>
    </message>
    <message>
        <source>Specials</source>
        <translation type="obsolete">Especiales</translation>
    </message>
    <message>
        <source>Greek</source>
        <translation type="obsolete">Griego</translation>
    </message>
    <message>
        <source>Greek Extended</source>
        <translation type="obsolete">Griego extendido</translation>
    </message>
    <message>
        <source>Cyrillic</source>
        <translation type="obsolete">Cirílico</translation>
    </message>
    <message>
        <source>Cyrillic Supplement</source>
        <translation type="obsolete">Cirílico suplemento</translation>
    </message>
    <message>
        <source>Arabic</source>
        <translation type="obsolete">Árabe</translation>
    </message>
    <message>
        <source>Arabic Extended A</source>
        <translation type="obsolete">Árabe Extendido-A</translation>
    </message>
    <message>
        <source>Arabic Extended B</source>
        <translation type="obsolete">Árabe Extendido-B</translation>
    </message>
    <message>
        <source>Hebrew</source>
        <translation type="obsolete">Hebreo</translation>
    </message>
    <message>
        <source>You can see a thumbnail if you press and hold down the right mouse button. The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="obsolete">Puedes ver una miniatura si presionas y mantienes el botón derecho del ratón. La tecla Insert inserta un carácter en la Selección inferior y la tecla Supr elimina el último insertado</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="32"/>
        <source>Scribus Char Palette (*.ucp);;All Files (*)</source>
        <translation>Paleta de caracteres de Scribus (*.ucp);;Todos los archivos (*)</translation>
    </message>
    <message>
        <source>Enhanced Palette</source>
        <translation type="obsolete">Paleta mejorada</translation>
    </message>
    <message>
        <source>Quick Palette</source>
        <translation type="obsolete">Paleta rápida</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="254"/>
        <source>Choose a filename to open</source>
        <translation>Elige un nombre de archivo para abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="291"/>
        <location filename="../../../scribus/charselect.cpp" line="336"/>
        <source>Error</source>
        <translation>Error</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="292"/>
        <source>Error reading file %1 - file is corrupted propably.</source>
        <translation>Error al leer el archivo %1 - el archivo esta probablemente dañado.</translation>
    </message>
    <message>
        <source>Choose a filename to save under</source>
        <translation type="obsolete">Elige un nombre de archivo para guardar</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="337"/>
        <source>Cannot write file %1</source>
        <translation>No se puede escribir archivo %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.ui" line="14"/>
        <source>Character Palette</source>
        <translation>Paleta de caracteres</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.ui" line="25"/>
        <source>Show/Hide Enhanced Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.ui" line="35"/>
        <source>Unicode Search</source>
        <translation type="unfinished">Búsqueda Unicode</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.ui" line="42"/>
        <source>Load a Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.ui" line="52"/>
        <source>Save the Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.ui" line="62"/>
        <source>Empty the Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="345"/>
        <source>Empty the Palette?</source>
        <translation>¿Vaciar la paleta?</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="346"/>
        <source>You will remove all characters from this palette. Are you sure?</source>
        <translation>Eliminarás todos los caracteres de esta paleta. ¿Estás seguro?</translation>
    </message>
    <message>
        <source>Hide/Show Enhanced Palette</source>
        <translation type="obsolete">Ocultar/Mostrar paleta mejorada</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="307"/>
        <source>Save Quick Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharSelectEnhanced</name>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="208"/>
        <source>Full Character Set</source>
        <translation type="unfinished">Set completo de caracteres</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="213"/>
        <source>Basic Latin</source>
        <translation type="unfinished">Latín básico</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="219"/>
        <source>Latin-1 Supplement</source>
        <translation type="unfinished">Latín-1 suplemento</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="225"/>
        <source>Latin Extended-A</source>
        <translation type="unfinished">Latín Extendido-A</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="231"/>
        <source>Latin Extended-B</source>
        <translation type="unfinished">Latín Extendido-B</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="237"/>
        <source>General Punctuation</source>
        <translation type="unfinished">Puntuación general</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="243"/>
        <source>Super- and Subscripts</source>
        <translation type="unfinished">Superíndices y subíndices</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="249"/>
        <source>Currency Symbols</source>
        <translation type="unfinished">Símbolos monetarios</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="255"/>
        <source>Letterlike Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="261"/>
        <source>Number Forms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="267"/>
        <source>Arrows</source>
        <translation type="unfinished">Flechas</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="273"/>
        <source>Mathematical Operators</source>
        <translation type="unfinished">Operadores matemáticos</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="279"/>
        <source>Box Drawing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="285"/>
        <source>Block Elements</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="291"/>
        <source>Geometric Shapes</source>
        <translation type="unfinished">Formas geométricas</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="297"/>
        <source>Miscellaneous Symbols</source>
        <translation type="unfinished">Símbolos variados</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="303"/>
        <source>Dingbats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="309"/>
        <source>Small Form Variants</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="315"/>
        <source>Ligatures</source>
        <translation type="unfinished">Ligaduras</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="321"/>
        <source>Specials</source>
        <translation type="unfinished">Especiales</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="327"/>
        <source>Greek</source>
        <translation type="unfinished">Griego</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="333"/>
        <source>Greek Extended</source>
        <translation type="unfinished">Griego extendido</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="339"/>
        <source>Cyrillic</source>
        <translation type="unfinished">Cirílico</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="345"/>
        <source>Cyrillic Supplement</source>
        <translation type="unfinished">Cirílico suplemento</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="351"/>
        <source>Arabic</source>
        <translation type="unfinished">Árabe</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="357"/>
        <source>Arabic Extended A</source>
        <translation type="unfinished">Árabe Extendido-A</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="363"/>
        <source>Arabic Extended B</source>
        <translation type="unfinished">Árabe Extendido-B</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="369"/>
        <source>Hebrew</source>
        <translation type="unfinished">Hebreo</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="13"/>
        <source>Enhanced Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="19"/>
        <source>&amp;Font:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="45"/>
        <source>C&amp;haracter Class:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="77"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button.
The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="96"/>
        <source>Insert &amp;Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="131"/>
        <source>Glyphs to Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="171"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="unfinished">Inserta los caracteres en el texto en la posición del cursor</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="174"/>
        <source>&amp;Insert</source>
        <translation type="unfinished">&amp;Insertar</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="184"/>
        <source>Delete the current selection(s).</source>
        <translation type="unfinished">Borra la/s selección/s actual/es.</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="187"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="106"/>
        <source>Type in a four digit Unicode value directly here</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharStyleComboBox</name>
    <message>
        <location filename="../../../scribus/spalette.cpp" line="94"/>
        <location filename="../../../scribus/spalette.cpp" line="107"/>
        <location filename="../../../scribus/spalette.cpp" line="118"/>
        <source>No Style</source>
        <translation>Sin estilo</translation>
    </message>
</context>
<context>
    <name>CharTableView</name>
    <message>
        <location filename="../../../scribus/chartableview.cpp" line="22"/>
        <source>Delete</source>
        <translation>Borrar</translation>
    </message>
</context>
<context>
    <name>CheckDocument</name>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="675"/>
        <source>Glyphs missing</source>
        <translation>Caracteres inexistentes</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="676"/>
        <source>Text overflow</source>
        <translation>Desbordamiento de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="677"/>
        <source>Object is not on a Page</source>
        <translation>El objeto no esta en ninguna página</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="678"/>
        <source>Missing Image</source>
        <translation>Imagen inexistente</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="682"/>
        <source>Object has transparency</source>
        <translation>El objeto tiene transparencia</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="683"/>
        <source>Object is a PDF Annotation or Field</source>
        <translation>El objeto es una Anotación o Campo PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="684"/>
        <source>Object is a placed PDF</source>
        <translation>El objeto es un PDF ubicado</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="399"/>
        <source>Document</source>
        <translation>Documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="401"/>
        <source>No Problems found</source>
        <translation>Ningún problema encontrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="569"/>
        <source>Page </source>
        <translation>Página </translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="627"/>
        <source>Free Objects</source>
        <translation type="unfinished">Liberar objetos</translation>
    </message>
    <message>
        <source>Problems found</source>
        <translation type="obsolete">Se han encontrado problemas</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="660"/>
        <source>Preflight Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="662"/>
        <source>Items</source>
        <translation>Elementos</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="662"/>
        <source>Problems</source>
        <translation>Problemas</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="667"/>
        <source>Current Profile:</source>
        <translation>Perfil actual:</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="637"/>
        <location filename="../../../scribus/checkDocument.cpp" line="668"/>
        <source>&amp;Ignore Errors</source>
        <translation>&amp;Ignorar errores</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="669"/>
        <source>Check again</source>
        <translation>Comprobar otra vez</translation>
    </message>
    <message>
        <source>Image resolution below %1 DPI, currently %2 x %3 DPI</source>
        <translation type="obsolete">Resolución de la imagen inferior a %1 DPI, actualmente %2 x %3 DPI</translation>
    </message>
    <message>
        <source>Image resolution above %1 DPI, currently %2 x %3 DPI</source>
        <translation type="obsolete">Resolución de la imagen superior a %1 DPI, actualmente %2 x %3 DPI</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="685"/>
        <source>Image is GIF</source>
        <translation>La imagen es un GIF</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="402"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="433"/>
        <source>Transparency used</source>
        <translation>La transparencia se ha utilizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="438"/>
        <source>Blendmode used</source>
        <translation>El modo de degradado se ha utilizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="451"/>
        <source>Layer &quot;%1&quot;</source>
        <translation>Capa &quot;%1&quot;</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="686"/>
        <source>Annotation uses a non TrueType font</source>
        <translation>Las anotaciones usan una tipografía no TrueType</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="671"/>
        <source>Preflight profile to base the report generation on. Options can be set in Document Setup or Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="672"/>
        <source>Ignore found errors and continue to export or print. Be sure to understand the errors you are ignoring before continuing.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="673"/>
        <source>Rerun the document scan to check corrections you may have made</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="679"/>
        <source>Empty Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="414"/>
        <source>Layers</source>
        <translation type="unfinished">Capas</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="443"/>
        <source>Print/Visible Mismatch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="457"/>
        <location filename="../../../scribus/checkDocument.cpp" line="520"/>
        <source>Issue(s): %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="468"/>
        <source>Master Pages</source>
        <translation type="unfinished">Páginas maestras</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="663"/>
        <source>Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="680"/>
        <source>Image resolution below %1 DPI,
currently %2 x %3 DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="681"/>
        <source>Image resolution above %1 DPI,
currently %2 x %3 DPI</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CollectForOutput</name>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="52"/>
        <source>Choose a Directory</source>
        <translation>Elige un directorio</translation>
    </message>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="65"/>
        <source>Cannot create directory:
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="80"/>
        <source>Collecting...</source>
        <translation>Recabando...</translation>
    </message>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="85"/>
        <source>Cannot collect all files for output for file:
%1</source>
        <translation>No se pueden recabar todos los archivos para la salida por el archivo:
%1</translation>
    </message>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="99"/>
        <source>Cannot collect the file: 
%1</source>
        <translation>No se puede recabar el archivo: 
%1</translation>
    </message>
</context>
<context>
    <name>ColorManager</name>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="54"/>
        <source>Colors</source>
        <translation>Colores</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="81"/>
        <source>&amp;Import</source>
        <translation>&amp;Importar</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="83"/>
        <source>&amp;New</source>
        <translation>&amp;Nuevo</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="85"/>
        <source>&amp;Edit</source>
        <translation>&amp;Editar</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="89"/>
        <source>D&amp;uplicate</source>
        <translation>&amp;Duplicar</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="92"/>
        <source>&amp;Delete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="97"/>
        <source>&amp;Remove Unused</source>
        <translation>Borrar no &amp;usados</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="104"/>
        <source>Color Sets</source>
        <translation>Sets de colores</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="110"/>
        <source>Current Color Set:</source>
        <translation>Set de colores actual:</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="141"/>
        <source>&amp;Save Color Set</source>
        <translation>&amp;Guardar set de colores</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="180"/>
        <source>Choose a color set to load</source>
        <translation>Elige el set de colores a cargar</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="181"/>
        <source>Save the current color set</source>
        <translation>Guarda el set de colores actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="186"/>
        <source>Remove unused colors from current document&apos;s color set</source>
        <translation>Eliminar colores no usados del set de colores del documento actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="188"/>
        <source>Import colors to the current set from an existing document</source>
        <translation>Importar colores al set actual desde un documento existente</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="189"/>
        <source>Create a new color within the current set</source>
        <translation>Crear un nuevo color en el set actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="190"/>
        <source>Edit the currently selected color</source>
        <translation>Editar el color seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="191"/>
        <source>Make a copy of the currently selected color</source>
        <translation>Hacer una copia del color seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="192"/>
        <source>Delete the currently selected color</source>
        <translation>Borrar el color seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="193"/>
        <source>Make the current colorset the default color set</source>
        <translation>Establecer el set actual como el set de colores por defecto</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="224"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="224"/>
        <source>Choose a Name</source>
        <translation>Elige un nombre</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="411"/>
        <source>Copy of %1</source>
        <translation>Copia de %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="424"/>
        <source>New Color</source>
        <translation>Nuevo color</translation>
    </message>
    <message>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected.What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. Registration colors will have a registration mark next to the color. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Si el manejo de color está activado, un indicador de triángulo de emergencia es un aviso de que el color podría estar fuera de la gama de color del perfil de la impresora actual seleccionada. Lo que esto significa es que el color podría no imprimirse exactamente como indicado en la pantalla. Los colores de tinta plana están indicados por un círculo rojo. Los colores de registro tendrán una marga de registro al lado del color. En la ayuda online, en la sección Manejo de color, hay más sugerencias sobre avisos de gama.</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="375"/>
        <source>Information</source>
        <translation>Información</translation>
    </message>
    <message>
        <source>Import</source>
        <translation type="obsolete">Importar</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="375"/>
        <source>The file %1 does not contain colors which can be imported.
If the file was a PostScript-based, try to import it with File -&amp;gt; Import. 
Not all files have DSC conformant comments where the color descriptions are located.
 This prevents importing colors from some files.
See the Edit Colors section of the documentation for more details.</source>
        <translation>El archivo %1 no contiene colores que se puedan importar.
Si el archivo estaba basado en PostScript, intenta importarlo con Archivo -&amp;gt; Importar. 
No todos los archivos tienen comentarios conformes a DSC donde las descripciones del
color se almacenan.
 Esto evita importar colores de algunos archivos.
Lee la sección Editar colores de la documentación para más detalles.</translation>
    </message>
    <message>
        <source>Documents (%1);;Other Files (%2);;All Files (*)</source>
        <translation type="obsolete">Documentos (%1);;Otros archivos (%2);;Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="194"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. More hints about gamut warnings are in the online help under Color Management. Registration colors will have a registration mark next to the color. Use Registration only for printers marks and crop marks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="365"/>
        <source>All Supported Formats (%1);;Documents (%2);;Other Files (%3);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="366"/>
        <source>Import Colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorWheel</name>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="139"/>
        <source>Monochromatic</source>
        <translation>Monocromática</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="140"/>
        <source>Analogous</source>
        <translation>Análoga</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="141"/>
        <source>Complementary</source>
        <translation>Complementaria</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="142"/>
        <source>Split Complementary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="143"/>
        <source>Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="144"/>
        <source>Tetradic (Double Complementary)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="44"/>
        <source>Base Color</source>
        <translation>Color base</translation>
    </message>
</context>
<context>
    <name>ColorWheelPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheel.cpp" line="47"/>
        <source>&amp;Color Wheel...</source>
        <translation>Rueda de &amp;color...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheel.cpp" line="64"/>
        <source>Color setting helper</source>
        <translation>Ayudante de configuración de color</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheel.cpp" line="65"/>
        <source>Color selector with color theory included.</source>
        <translation>Selector de color con teoría del color incluída.</translation>
    </message>
</context>
<context>
    <name>CommonStrings</name>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="245"/>
        <source>&amp;Apply</source>
        <translation>A&amp;plicar</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="248"/>
        <source>&amp;Cancel</source>
        <translation>&amp;Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="251"/>
        <source>None</source>
        <translation>Ninguno</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="255"/>
        <source>&amp;OK</source>
        <translation>&amp;Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="258"/>
        <source>&amp;Save</source>
        <translation>&amp;Guardar</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="261"/>
        <source>Warning</source>
        <translation>Atención</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="252"/>
        <source>None</source>
        <comment>color name</comment>
        <translation>Ninguno</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="286"/>
        <source>Custom</source>
        <comment>CommonStrings, custom page size</comment>
        <translation>Personalizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="292"/>
        <source>Single Page</source>
        <translation>Página simple</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="293"/>
        <source>Double Sided</source>
        <translation>Página doble</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="294"/>
        <source>3-Fold</source>
        <translation>Tríptico</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="295"/>
        <source>4-Fold</source>
        <translation>4 páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="331"/>
        <source>Monday</source>
        <translation>Lunes</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="332"/>
        <source>Tuesday</source>
        <translation>Martes</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="333"/>
        <source>Wednesday</source>
        <translation>Miércoles</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="334"/>
        <source>Thursday</source>
        <translation>Jueves</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="335"/>
        <source>Friday</source>
        <translation>Viernes</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="336"/>
        <source>Saturday</source>
        <translation>Sábado</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="337"/>
        <source>Sunday</source>
        <translation>Domingo</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="338"/>
        <source>January</source>
        <translation>Enero</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="339"/>
        <source>February</source>
        <translation>Febrero</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="340"/>
        <source>March</source>
        <translation>Marzo</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="341"/>
        <source>April</source>
        <translation>Abril</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="342"/>
        <source>May</source>
        <translation>Mayo</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="343"/>
        <source>June</source>
        <translation>Junio</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="344"/>
        <source>July</source>
        <translation>Julio</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="345"/>
        <source>August</source>
        <translation>Agosto</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="346"/>
        <source>September</source>
        <translation>Septiembre</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="347"/>
        <source>October</source>
        <translation>Octubre</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="348"/>
        <source>November</source>
        <translation>Noviembre</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="349"/>
        <source>December</source>
        <translation>Diciembre</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="263"/>
        <source>Yes</source>
        <translation>Sí</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="264"/>
        <source>No</source>
        <translation>No</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="265"/>
        <source>&amp;Yes</source>
        <translation>&amp;Sí</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="266"/>
        <source>&amp;No</source>
        <translation>&amp;No</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="302"/>
        <source>Left Page</source>
        <comment>Left page location</comment>
        <translation>Página izquierda</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="303"/>
        <source>Middle</source>
        <comment>Middle page location</comment>
        <translation>Central</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="304"/>
        <source>Middle Left</source>
        <comment>Middle Left page location</comment>
        <translation>Central izquierda</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="305"/>
        <source>Middle Right</source>
        <comment>Middle Right page location</comment>
        <translation>Central derecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="306"/>
        <source>Right Page</source>
        <comment>Right page location</comment>
        <translation>Página derecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="309"/>
        <source>Normal</source>
        <comment>Default single master page</comment>
        <translation>Normal</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="311"/>
        <source>Normal Left</source>
        <comment>Default left master page</comment>
        <translation>Normal izquierda</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="313"/>
        <source>Normal Middle</source>
        <comment>Default middle master page</comment>
        <translation>Normal central</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="315"/>
        <source>Normal Right</source>
        <comment>Default right master page</comment>
        <translation>Normal derecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="357"/>
        <source>Normal Vision</source>
        <comment>Color Blindness - Normal Vision</comment>
        <translation>Visión normal</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="358"/>
        <source>Protanopia (Red)</source>
        <comment>Color Blindness - Red Color Blind</comment>
        <translation>Protanopia (rojo)</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="359"/>
        <source>Deuteranopia (Green)</source>
        <comment>Color Blindness - Greed Color Blind</comment>
        <translation>Deuteranopia (verde)</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="360"/>
        <source>Tritanopia (Blue)</source>
        <comment>Color Blindness - Blue Color Blind</comment>
        <translation>Tritanopia (azul)</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="361"/>
        <source>Full Color Blindness</source>
        <comment>Color Blindness - Full Color Blindness</comment>
        <translation>Monocromático</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="363"/>
        <source>Custom: </source>
        <comment>Custom Tab Fill Option</comment>
        <translation>Personalizado: </translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="317"/>
        <source>Solid Line</source>
        <translation>Línea sólida</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="318"/>
        <source>Dashed Line</source>
        <translation>Línea a trazos</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="319"/>
        <source>Dotted Line</source>
        <translation>Línea a puntos</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="320"/>
        <source>Dash Dot Line</source>
        <translation>Línea raya punto</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="321"/>
        <source>Dash Dot Dot Line</source>
        <translation>Línea raya punto punto</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="365"/>
        <source>None</source>
        <comment>Optical Margin Setting</comment>
        <translation>Ninguno</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="366"/>
        <source>Left Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="367"/>
        <source>Right Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="368"/>
        <source>Left Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="369"/>
        <source>Right Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="370"/>
        <source>Default</source>
        <comment>Optical Margin Setting</comment>
        <translation>Por defecto</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="373"/>
        <source>Min. Word Tracking</source>
        <translation>Espaciado mínimo de palabra</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="374"/>
        <source>Max. Word Tracking</source>
        <translation>Espaciado máximo de palabra</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="377"/>
        <source>Min. Glyph Extension</source>
        <translation>Extensión mínima de carácter</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="378"/>
        <source>Max. Glyph Extension</source>
        <translation>Extensión máxima de carácter</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="351"/>
        <source>RGB</source>
        <comment>Colorspace</comment>
        <translation>RGB</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="352"/>
        <source>CMYK</source>
        <comment>Colorspace</comment>
        <translation>CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="353"/>
        <source>Grayscale</source>
        <comment>Colorspace</comment>
        <translation>Escala de grises</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="354"/>
        <source>Duotone</source>
        <comment>Colorspace</comment>
        <translation>Duotono</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="355"/>
        <source>Unknown</source>
        <comment>Colorspace (Unknown)</comment>
        <translation>Desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="382"/>
        <source>PostScript</source>
        <translation>PostScript</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="268"/>
        <source>Text Frame</source>
        <translation>Marco de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="269"/>
        <source>Image Frame</source>
        <translation>Marco de imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="270"/>
        <source>Line</source>
        <translation>Línea</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="271"/>
        <source>Polygon</source>
        <translation>Polígono</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="272"/>
        <source>Polyline</source>
        <translation>Polilínea</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="273"/>
        <source>Text on a Path</source>
        <translation>Texto sobre trazado</translation>
    </message>
    <message>
        <source>LaTeX Frame</source>
        <translation type="obsolete">Marco LaTeX</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="275"/>
        <source>Multiple</source>
        <comment>Multiple frame types</comment>
        <translation>Múltiple</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="276"/>
        <source>PDF Push Button</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="277"/>
        <source>PDF Text Field</source>
        <translation>Campo de texto PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="278"/>
        <source>PDF Check Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="279"/>
        <source>PDF Combo Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="280"/>
        <source>PDF List Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="281"/>
        <source>PDF Text Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="282"/>
        <source>PDF Link Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="390"/>
        <source>PostScript Level 1</source>
        <translation>PostScript Level 1</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="392"/>
        <source>PostScript Level 2</source>
        <translation>PostScript Level 2</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="394"/>
        <source>PostScript Level 3</source>
        <translation>PostScript Level 3</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="396"/>
        <source>Windows GDI</source>
        <translation>Windows GDI</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="274"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="326"/>
        <source>Default Paragraph Style</source>
        <translation type="unfinished">Estilo de párrafo por defecto</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="327"/>
        <source>Default Character Style</source>
        <translation type="unfinished">Estilo de carácter por defecto</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="328"/>
        <source>Default Line Style</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ContextMenu</name>
    <message>
        <location filename="../../../scribus/contextmenu.cpp" line="209"/>
        <source>Preview Settings</source>
        <translation>Configuraciones de vista previa</translation>
    </message>
    <message>
        <location filename="../../../scribus/contextmenu.cpp" line="422"/>
        <source>Paste File...</source>
        <translation>Pegar archivo...</translation>
    </message>
    <message>
        <location filename="../../../scribus/contextmenu.cpp" line="455"/>
        <source>Delete Page</source>
        <translation>Eliminar página</translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageBase</name>
    <message>
        <location filename="../../../scribus/ui/copypagetomasterpage.ui" line="16"/>
        <source>Convert Page to Master Page</source>
        <translation>Convertir página a página maestra</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/copypagetomasterpage.ui" line="24"/>
        <source>Name:</source>
        <translation>Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/copypagetomasterpage.ui" line="39"/>
        <source>Copy Applied Master Page Items</source>
        <translation>Copiar objetos de página mestra aplicada</translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageDialog</name>
    <message>
        <location filename="../../../scribus/ui/copypagetomasterpagedialog.cpp" line="29"/>
        <source>New Master Page %1</source>
        <translation>Nueva página maestra %1</translation>
    </message>
</context>
<context>
    <name>Cpalette</name>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1006"/>
        <source>Shade:</source>
        <translation>Saturación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="990"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1007"/>
        <source>Opacity:</source>
        <translation>Opacidad:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1012"/>
        <location filename="../../../scribus/cpalette.cpp" line="1025"/>
        <source>Normal</source>
        <translation>Normal</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1013"/>
        <source>Horizontal Gradient</source>
        <translation>Degradado horizontal</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1014"/>
        <source>Vertical Gradient</source>
        <translation>Degradado vertical</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1015"/>
        <source>Diagonal Gradient</source>
        <translation>Degradado diagonal</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1016"/>
        <source>Cross Diagonal Gradient</source>
        <translation>Degradado diagonal cruzado</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1017"/>
        <source>Radial Gradient</source>
        <translation>Degradado radial</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1018"/>
        <source>Free linear Gradient</source>
        <translation>Degradado lineal libre</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1019"/>
        <source>Free radial Gradient</source>
        <translation>Degradado radial libre</translation>
    </message>
    <message>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="989"/>
        <source> pt</source>
        <translation> pt</translation>
    </message>
    <message>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1043"/>
        <source>Edit Line Color Properties</source>
        <translation>Editar propiedades del color de línea</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1044"/>
        <source>Edit Fill Color Properties</source>
        <translation>Editar propiedades del color de relleno</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1045"/>
        <source>Saturation of color</source>
        <translation>Saturación del color</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1046"/>
        <source>Normal or gradient fill method</source>
        <translation>Método de relleno normal o gradiente</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1047"/>
        <source>Set the transparency for the color selected</source>
        <translation>Establece la transparencia del color seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1008"/>
        <source>Move Vector</source>
        <translation>Mover vector</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1048"/>
        <source>Move the start of the gradient vector with the left mouse button pressed and move the end of the gradient vector with the right mouse button pressed</source>
        <translation>Mueve el comienzo del vector de degradado con el botón izquierdo del ratón presionado y mueve el final del vector de degradado con el botón derecho del ratón presionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1022"/>
        <source>Transparency Settings</source>
        <translation>Configuracion de la transparencia</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1023"/>
        <source>Blend Mode:</source>
        <translation>Modo de degradado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1026"/>
        <source>Darken</source>
        <translation>Oscurecido</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1027"/>
        <source>Lighten</source>
        <translation>Aclarado</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1028"/>
        <source>Multiply</source>
        <translation>Multiplicar</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1029"/>
        <source>Screen</source>
        <translation>Trama</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1030"/>
        <source>Overlay</source>
        <translation>Superponer</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1031"/>
        <source>Hard Light</source>
        <translation>Luz dura</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1032"/>
        <source>Soft Light</source>
        <translation>Luz suave</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1033"/>
        <source>Difference</source>
        <translation>Diferencia</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1035"/>
        <source>Color Dodge</source>
        <translation>Sobreexponer color</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1036"/>
        <source>Color Burn</source>
        <translation>Subexponer color</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1037"/>
        <source>Hue</source>
        <translation>Tono</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1038"/>
        <source>Saturation</source>
        <translation>Saturación</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1039"/>
        <source>Color</source>
        <translation>Color</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1040"/>
        <source>Luminosity</source>
        <translation>Luminosidad</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="993"/>
        <source>Offsets</source>
        <translation>Desplazamientos</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="994"/>
        <source>X:</source>
        <translation>X:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="996"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="998"/>
        <source>Scaling</source>
        <translation>Escalado</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1003"/>
        <source>Rotation</source>
        <translation>Rotación</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1004"/>
        <source>Angle</source>
        <translation>Ángulo</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="405"/>
        <location filename="../../../scribus/cpalette.cpp" line="518"/>
        <location filename="../../../scribus/cpalette.cpp" line="1020"/>
        <source>Pattern</source>
        <translation>Patrón</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1034"/>
        <source>Exclusion</source>
        <translation>Exclusión</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="999"/>
        <source>X-Scale:</source>
        <translation>Escala-X:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1001"/>
        <source>Y-Scale:</source>
        <translation>Escala-Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="229"/>
        <location filename="../../../scribus/cpalette.cpp" line="1041"/>
        <source>Display only used Colors</source>
        <translation>Muestra sólo los colores usados</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1049"/>
        <source>Display all colors from the document color list, or only the already used colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CreateRange</name>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="13"/>
        <source>Create Range</source>
        <translation>Crear rango</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="54"/>
        <source>Number of Pages in Document:</source>
        <translation>Número de páginas en el documento:</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="64"/>
        <source>Doc Page Range</source>
        <translation>Rango de páginas del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="112"/>
        <source>Basic Range Selection</source>
        <translation>Selección del rango básico</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="136"/>
        <source>Range of Pages</source>
        <translation>Rango de páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="160"/>
        <source>De&amp;lete</source>
        <translation>B&amp;orrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="163"/>
        <source>Alt+L</source>
        <translation>Alt+L</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="186"/>
        <source>Move &amp;Down</source>
        <translation>Mover aba&amp;jo</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="189"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="196"/>
        <source>Move &amp;Up</source>
        <translation>Mover arri&amp;ba</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="199"/>
        <source>Alt+U</source>
        <translation>Alt+U</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="218"/>
        <source>Add a Range of Pages</source>
        <translation>Añadir un rango de páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="242"/>
        <source>Consecutive Pages</source>
        <translation>Páginas consecutivas</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="252"/>
        <source>Even Pages</source>
        <translation>Páginas pares</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="259"/>
        <source>From:</source>
        <translation>Desde:</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="291"/>
        <source>To:</source>
        <translation>Hasta:</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="334"/>
        <source>&amp;Add To Range</source>
        <translation>&amp;Añadir al rango</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="337"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="362"/>
        <source>Odd Pages</source>
        <translation>Páginas impares</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="372"/>
        <source>Comma Separated List</source>
        <translation>Lista separada por comas</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="383"/>
        <source>Advanced Reordering</source>
        <translation>Reordenación avanzada</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="439"/>
        <source>Page Order</source>
        <translation>Orden de páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="449"/>
        <source>Sample Page Order:</source>
        <translation>Orden de páginas de muestra:</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="478"/>
        <source>Page Group Size:</source>
        <translation>Tamaño del grupo de páginas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="525"/>
        <source>&amp;OK</source>
        <translation>&amp;Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="528"/>
        <source>Alt+O</source>
        <translation>Alt+O</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="535"/>
        <source>&amp;Cancel</source>
        <translation>&amp;Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="538"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
</context>
<context>
    <name>CsvDialog</name>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="27"/>
        <source>CSV Importer Options</source>
        <translation>Opciones de importación de CSV</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="37"/>
        <source>Field delimiter:</source>
        <translation>Delimitador de campo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="44"/>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="89"/>
        <source>(TAB)</source>
        <translation>(TAB)</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="53"/>
        <source>Value delimiter:</source>
        <translation>Delimitador de valor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="68"/>
        <source>First row is a header</source>
        <translation>La primera fila es una cabecera</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="76"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="79"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="59"/>
        <source>None</source>
        <comment>delimiter</comment>
        <translation>Ninguno</translation>
    </message>
</context>
<context>
    <name>CupsOptions</name>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="53"/>
        <source>Printer Options</source>
        <translation>Opciones de impresión</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="134"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="144"/>
        <source>Page Set</source>
        <translation>Selección de páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="141"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="148"/>
        <source>All Pages</source>
        <translation>Todas</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="142"/>
        <source>Even Pages only</source>
        <translation>Sólo pares</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="143"/>
        <source>Odd Pages only</source>
        <translation>Sólo impares</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="151"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="161"/>
        <source>Mirror</source>
        <translation>Voltear</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="168"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="178"/>
        <source>Orientation</source>
        <translation>Orientación</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="175"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="182"/>
        <source>Portrait</source>
        <translation>Vertical</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="176"/>
        <source>Landscape</source>
        <translation>Apaisado</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="185"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="198"/>
        <source>N-Up Printing</source>
        <translation>Páginas por hoja</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="192"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="202"/>
        <source>Page per Sheet</source>
        <translation>Página por hoja</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="193"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="194"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="195"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="196"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="197"/>
        <source>Pages per Sheet</source>
        <translation>Páginas por hoja</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="64"/>
        <source>Option</source>
        <translation>Opción</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="65"/>
        <source>Value</source>
        <translation>Valor</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="225"/>
        <source>This panel displays various CUPS options when printing. The exact parameters available will depend on your printer driver. You can confirm CUPS support by selecting Help &gt; About. Look for the listings: C-C-T These equate to C=CUPS C=littlecms T=TIFF support. Missing library support is indicated by a *</source>
        <translation>Este panel muestra varias opciones de CUPS a la hora de imprimir. Los parámetros disponibles exactos dependerán de tu controlador de impresora. Puedes confirmar el soporte de CUPS seleccionando Ayuda -&gt; Acerca de. Busca la secuencia: C-C-T Esto equivale a C=CUPS C=littlecms T=soporte TIFF. Las bibliotecas de soporte no disponibles se indican mediante un *</translation>
    </message>
</context>
<context>
    <name>CurveWidget</name>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="408"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <source>Curve Files (*.scu);;All Files (*)</source>
        <translation type="obsolete">Archivos Curva (*.scu);;Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="408"/>
        <location filename="../../../scribus/curvewidget.cpp" line="446"/>
        <source>Curve Files (*.scu *.SCU);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="446"/>
        <source>Save as</source>
        <translation>Guardar como</translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="480"/>
        <source>Cannot write the file: 
%1</source>
        <translation>No se puede escribir el archivo: 
%1</translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="506"/>
        <source>Inverts the curve</source>
        <translation>Invierte la curva</translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="507"/>
        <source>Resets the curve</source>
        <translation>Reinicia la curva</translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="508"/>
        <source>Switches between linear and cubic interpolation of the curve</source>
        <translation>Intercambia entre interpolación lineal y cúbica de la curva</translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="509"/>
        <source>Loads a curve</source>
        <translation>Carga una curva</translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="510"/>
        <source>Saves this curve</source>
        <translation>Guardar esta curva</translation>
    </message>
</context>
<context>
    <name>CustomFDialog</name>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="295"/>
        <location filename="../../../scribus/customfdialog.cpp" line="325"/>
        <source>&amp;Compress File</source>
        <translation>&amp;Comprimir el archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="304"/>
        <source>&amp;Include Fonts</source>
        <translation>&amp;Incluir tipografías</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="353"/>
        <source>Encoding:</source>
        <translation>Codificación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="272"/>
        <source>Show Preview</source>
        <translation>Mostrar vista previa</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="306"/>
        <source>&amp;Include Color Profiles</source>
        <translation>&amp;Incluir perfiles de color</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="273"/>
        <source>Show a preview and information for the selected file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="340"/>
        <source>Compress the Scribus document on save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="342"/>
        <source>Include fonts when collecting files for the document. Be sure to know and understand licensing information for any fonts you collect and possibly redistribute.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="344"/>
        <source>Include color profiles when collecting files for the document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CvgPlug</name>
    <message>
        <location filename="../../../scribus/plugins/import/cvg/importcvg.cpp" line="79"/>
        <source>Importing: %1</source>
        <translation type="unfinished">Importando: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/cvg/importcvg.cpp" line="82"/>
        <source>Analyzing File:</source>
        <translation type="unfinished">Analizando archivo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/cvg/importcvg.cpp" line="205"/>
        <source>Group%1</source>
        <translation type="unfinished">Grupo%1</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/cvg/importcvg.cpp" line="332"/>
        <source>Generating Items</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DashEditor</name>
    <message>
        <location filename="../../../scribus/dasheditor.cpp" line="367"/>
        <source>Value:</source>
        <translation>Valor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/dasheditor.cpp" line="368"/>
        <source>Offset:</source>
        <translation>Desplazamiento:</translation>
    </message>
</context>
<context>
    <name>DeferredTask</name>
    <message>
        <location filename="../../../scribus/deferredtask.cpp" line="82"/>
        <source>Cancelled by user</source>
        <translation>Cancelado por el usuario</translation>
    </message>
</context>
<context>
    <name>DelColor</name>
    <message>
        <location filename="../../../scribus/dcolor.cpp" line="29"/>
        <source>Delete Color</source>
        <translation>Borrar color</translation>
    </message>
    <message>
        <location filename="../../../scribus/dcolor.cpp" line="37"/>
        <source>Delete Color:</source>
        <translation>Borrar color:</translation>
    </message>
    <message>
        <location filename="../../../scribus/dcolor.cpp" line="46"/>
        <source>Replace With:</source>
        <translation>Reemplazar con:</translation>
    </message>
</context>
<context>
    <name>DelPages</name>
    <message>
        <location filename="../../../scribus/delpages.cpp" line="17"/>
        <source>Delete Pages</source>
        <translation>Borrar páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/delpages.cpp" line="34"/>
        <source>to:</source>
        <translation>hasta:</translation>
    </message>
    <message>
        <location filename="../../../scribus/delpages.cpp" line="26"/>
        <source>Delete From:</source>
        <translation>Borrar desde:</translation>
    </message>
</context>
<context>
    <name>DocIm</name>
    <message>
        <location filename="../../../scribus/plugins/gettext/docim/docim.cpp" line="180"/>
        <source>Importing failed</source>
        <translation>Falló la importación</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/docim/docim.cpp" line="181"/>
        <source>Importing Word document failed 
%1</source>
        <translation>Falló la importación del documento Word 
%1</translation>
    </message>
</context>
<context>
    <name>DocInfos</name>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="30"/>
        <source>Document Information</source>
        <translation>Información del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="39"/>
        <source>&amp;Title:</source>
        <translation>&amp;Título:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="46"/>
        <source>&amp;Author:</source>
        <translation>A&amp;utor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="53"/>
        <source>&amp;Subject:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="60"/>
        <source>&amp;Keywords:</source>
        <translation>&amp;Palabras clave</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="68"/>
        <source>Descri&amp;ption:</source>
        <translation>De&amp;scripción:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="81"/>
        <source>P&amp;ublisher:</source>
        <translation>&amp;Editor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="88"/>
        <source>&amp;Contributors:</source>
        <translation>Cola&amp;boradores:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="96"/>
        <source>Dat&amp;e:</source>
        <translation>&amp;Fecha:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="103"/>
        <source>T&amp;ype:</source>
        <translation>&amp;Tipo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="110"/>
        <source>F&amp;ormat:</source>
        <translation>&amp;Formato:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="117"/>
        <source>Identi&amp;fier:</source>
        <translation>&amp;Identificador:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="124"/>
        <source>&amp;Source:</source>
        <translation>&amp;Fuente:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="131"/>
        <source>&amp;Language:</source>
        <translation>&amp;Idioma:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="138"/>
        <source>&amp;Relation:</source>
        <translation>&amp;Relación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="145"/>
        <source>Co&amp;verage:</source>
        <translation>&amp;Portada:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="152"/>
        <source>Ri&amp;ghts:</source>
        <translation>De&amp;rechos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="160"/>
        <source>Further &amp;Information</source>
        <translation>&amp;Información adicional</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="170"/>
        <source>A person or organisation responsible for making the document available</source>
        <translation>Una persona u organización responsable de hacer disponible el documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="171"/>
        <source>A person or organisation responsible for making contributions to the content of the document</source>
        <translation>Una persona u organización responsable de hacer contribuciones al contenido del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="172"/>
        <source>A date associated with an event in the life cycle of the document, in YYYY-MM-DD format, as per ISO 8601</source>
        <translation>Una fecha asociada con un evento en el ciclo de vida del documento, en formato AAAA-MM-DD, de acuerdo a ISO 8601</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="173"/>
        <source>The nature or genre of the content of the document, eg. categories, functions, genres, etc</source>
        <translation>La naturaleza o género del contenido del documento, p.ej. categorías, funciones, géneros, etc</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="175"/>
        <source>An unambiguous reference to the document within a given context such as ISBN or URI</source>
        <translation>Una referencia ambigua al documento dentro de un contexto dado, como un ISBN o URI</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="176"/>
        <source>A reference to a document from which the present document is derived, eg. ISBN or URI</source>
        <translation>Una referencia a un documento del que deriva el documento actual, p.ej. un ISBN o URI</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="178"/>
        <source>A reference to a related document, possibly using a formal identifier such as a ISBN or URI</source>
        <translation>Una referencia a un documento relacionado, posiblemente usando un identificador formal como un ISBN o URI</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="179"/>
        <source>The extent or scope of the content of the document, possibly including location, time and jurisdiction ranges</source>
        <translation>La extensión o alcance del contenido del documento, posiblemente incluyendo localización, tiempo y rangos de jurisdicción</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="180"/>
        <source>Information about rights held in and over the document, eg. copyright, patent or trademark</source>
        <translation>Información sobre los derechos mantenidos sobre el documento, p.ej. derechos de autor, patentes o marcas registradas</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="159"/>
        <source>Documen&amp;t</source>
        <translation>Documen&amp;to</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="166"/>
        <source>The person or organisation primarily responsible for making the content of the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation>La persona u organización principal responsable de la creación del contenido del documento. Este campo puede ser empotrado en el documento de Scribus como referencia, al igual que en los metadatos del PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="167"/>
        <source>A name given to the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation>El nombre de un documento. Este campo puede ser empotrado en el documento de Scribus como referencia, al igual que en los metadatos del PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="168"/>
        <source>An account of the content of the document. This field is for a brief description or abstract of the document. It is embedded in the PDF on export</source>
        <translation>Una cuenta del contenido del documento. Este campo es para una breve descripción o resumen del documento. Se empotra en el PDF al exportar</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="169"/>
        <source>The topic of the content of the document. This field is for document keywords you wish to embed in a PDF, to assist searches and indexing of PDF files</source>
        <translation>El tópico del contenido del documento. Este campo es para las palabras claves del documento que quieras empotrar en un PDF, para ayudar en las busquedas e indizado de los archivos PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="174"/>
        <source>The physical or digital manifestation of the document. Media type and dimensions would be worth noting. RFC2045,RFC2046 for MIME types are also useful here</source>
        <translation>La manifestación física o digital del documento. Tipo de media y dimensiones no signifcan nada. Los tipos RFC2045,RFC2046 para tipos MIME son también útiles</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="177"/>
        <source>The language in which the content of the document is written, usually a ISO-639 language code optionally suffixed with a hypen and an ISO-3166 country code, eg. en-GB, fr-CH</source>
        <translation>El idioma en el que está escrito el contenido del libro, usualmente con código de idioma ISO-639 opcionalmente pospuesto con un guión y un código de país ISO-3166, p.ej. en-GB, fr-CH</translation>
    </message>
</context>
<context>
    <name>DocSections</name>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="72"/>
        <source>Add a page numbering section to the document. The new section will be added after the currently selected section.</source>
        <translation>Añadir una sección de numeracion de página al documento. La nueva sección será añadida tras la actual sección seleccionada.</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="73"/>
        <source>Delete the currently selected section.</source>
        <translation>Eliminar la actual sección seleccionada.</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>1, 2, 3, ...</source>
        <translation>1, 2, 3, ...</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>i, ii, iii, ...</source>
        <translation>i, ii, iii, ...</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>I, II, III, ...</source>
        <translation>I, II, III, ...</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>a, b, c, ...</source>
        <translation>a, b, c, ...</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>A, B, C, ...</source>
        <translation>A, B, C, ...</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="74"/>
        <source>&lt;b&gt;Name:&lt;/b&gt; Optional name for section eg. Index&lt;br/&gt;&lt;b&gt;Shown:&lt;/b&gt; Select to show the page numbers in this section if there is one or more text frames setup to do so.&lt;br/&gt;&lt;b&gt;From:&lt;/b&gt; The page index for this section to start at.&lt;br/&gt;&lt;b&gt;To:&lt;/b&gt; The page index for this section to stop at.&lt;br/&gt;&lt;b&gt;Style:&lt;/b&gt; Select the page number style to be used.&lt;br/&gt;&lt;b&gt;Start:&lt;/b&gt; The index within the Style&apos;s range to star at. Eg. If Start=2 and Style=a,b,c, ..., the numbers will begin at b. For the first section in the document this replaces the older First Page Number in the new file window.</source>
        <translation>&lt;b&gt;Nombre:&lt;/b&gt; Nombre opcional para la seccion, p.ej. Índice&lt;br/&gt;&lt;b&gt;Mostrar:&lt;/b&gt; Seleccionar para mostrar los números de páginas en esta sección si hay uno o más marcos de texto configurados para ello.&lt;br/&gt;&lt;b&gt;Desde:&lt;/b&gt; Marca el comienzo del índice de página para esta sección.&lt;br/&gt;&lt;b&gt;Hasta:&lt;/b&gt; Marca el final del índice de página para esta sección.&lt;br/&gt;&lt;b&gt;Estilo:&lt;/b&gt; Selecciona el estilo del número de página a usar.&lt;br/&gt;&lt;b&gt;Inicio:&lt;/b&gt; Marca el comienzo del índice dentro del rango del estilo, p.ej. Si Inicio=2 y Estilo=a,b,c, ..., los números comenzarán con b. Para la primera sección del documento, esto reemplaza la antigua Número de la  primera página en la nueva ventana de archivos.</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="201"/>
        <source>Page Number Out Of Bounds</source>
        <translation>Número de página fuera de límites</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="201"/>
        <source>The value you have entered is outside the range of page numbers in the current document (%1-%2).</source>
        <translation>El valor introducido está fuera del rango de los números de página en el documento actual (%1-%2).</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="13"/>
        <source>Document Sections</source>
        <translation>Secciones del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="83"/>
        <source>&amp;Add</source>
        <translation>A&amp;ñadir</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="86"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="93"/>
        <source>&amp;Delete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="96"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="32"/>
        <source>Name</source>
        <translation>Nombre</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="37"/>
        <source>Shown</source>
        <translation>Mostrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="42"/>
        <source>From</source>
        <translation>Desde</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="47"/>
        <source>To</source>
        <translation>Hasta</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="52"/>
        <source>Style</source>
        <translation>Estilo</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="57"/>
        <source>Start</source>
        <translation>Inicio</translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributes</name>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Relates To</source>
        <translation>Depende de</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Parent Of</source>
        <translation>Es padre de</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Child Of</source>
        <translation>Es hijo de</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Text Frames</source>
        <translation>Marcos de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Image Frames</source>
        <translation>Marcos de imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Boolean</source>
        <translation>Booleano</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Integer</source>
        <translation>Entero</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>String</source>
        <translation>Cadena</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="26"/>
        <source>Name</source>
        <translation>Nombre</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="31"/>
        <source>Type</source>
        <translation>Tipo</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="36"/>
        <source>Value</source>
        <translation>Valor</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="82"/>
        <source>&amp;Add</source>
        <translation>A&amp;ñadir</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="85"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="92"/>
        <source>&amp;Copy</source>
        <translation>&amp;Copiar</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="95"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="102"/>
        <source>&amp;Delete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="105"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="112"/>
        <source>C&amp;lear</source>
        <translation>B&amp;orrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="115"/>
        <source>Alt+L</source>
        <translation>Alt+L</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation>Ninguno</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>None</source>
        <comment>auto add</comment>
        <translation>Ninguno</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>None</source>
        <comment>types</comment>
        <translation>Ninguno</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Real Number</source>
        <translation>Número real</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="13"/>
        <source>Document Item Attributes</source>
        <translation>Atributos de objetos del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="41"/>
        <source>Parameter</source>
        <translation>Parámetro</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="46"/>
        <source>Relationship</source>
        <translation>Relación</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="51"/>
        <source>Relationship To</source>
        <translation>Relacionado con</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="56"/>
        <source>Auto Add To</source>
        <translation>Autoañadir a</translation>
    </message>
</context>
<context>
    <name>DownloadDictionaries</name>
    <message>
        <location filename="../../../scribus/ui/downloaddictionaries.ui" line="14"/>
        <location filename="../../../scribus/ui/downloaddictionaries.ui" line="56"/>
        <source>Download Dictionaries</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/downloaddictionaries.ui" line="20"/>
        <source>Available Dictionary Downloads</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/downloaddictionaries.ui" line="49"/>
        <source>Update Dictionary List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/downloaddictionaries.ui" line="63"/>
        <source>Close</source>
        <translation type="unfinished">Cerrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/downloaddictionaries.cpp" line="116"/>
        <source>Language</source>
        <translation type="unfinished">Idioma</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/downloaddictionaries.cpp" line="116"/>
        <source>Code</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/downloaddictionaries.cpp" line="116"/>
        <source>Location</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>EPSPlug</name>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importps.cpp" line="476"/>
        <source>Importing File:
%1
failed!</source>
        <translation>¡Importando el archivo:
%1
falló!</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importps.cpp" line="477"/>
        <source>Fatal Error</source>
        <translation>Error fatal</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importps.cpp" line="838"/>
        <source>Error</source>
        <translation>Error</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importps.cpp" line="83"/>
        <source>Analyzing PostScript:</source>
        <translation>Analizando PostScript:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importps.cpp" line="482"/>
        <source>Generating Items</source>
        <translation>Generando objetos</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importps.cpp" line="837"/>
        <source>Converting of %1 images failed!</source>
        <translation>¡La conversión de las imágenes %1 falló!</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importps.cpp" line="278"/>
        <location filename="../../../scribus/plugins/import/ps/importps.cpp" line="706"/>
        <source>Group%1</source>
        <translation>Grupo%1</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importps.cpp" line="80"/>
        <source>Importing: %1</source>
        <translation>Importando: %1</translation>
    </message>
</context>
<context>
    <name>EditToolBar</name>
    <message>
        <location filename="../../../scribus/ui/edittoolbar.cpp" line="29"/>
        <source>Edit</source>
        <translation>Editar</translation>
    </message>
</context>
<context>
    <name>Editor</name>
    <message>
        <location filename="../../../scribus/editor.cpp" line="34"/>
        <source>Editor</source>
        <translation>Editor</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="40"/>
        <source>&amp;New</source>
        <translation>&amp;Nuevo</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="43"/>
        <source>&amp;Open...</source>
        <translation>&amp;Abrir...</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="45"/>
        <source>Save &amp;As...</source>
        <translation>Gu&amp;ardar como...</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="47"/>
        <source>&amp;Save and Exit</source>
        <translation>&amp;Guardar y Salir</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="49"/>
        <source>&amp;Exit without Saving</source>
        <translation>&amp;Salir sin Guardar</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="51"/>
        <source>&amp;Undo</source>
        <translation>&amp;Deshacer</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="54"/>
        <source>&amp;Redo</source>
        <translation>Re&amp;hacer</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="56"/>
        <source>Cu&amp;t</source>
        <translation>Cor&amp;tar</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="59"/>
        <source>&amp;Copy</source>
        <translation>&amp;Copiar</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="62"/>
        <source>&amp;Paste</source>
        <translation>&amp;Pegar</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="65"/>
        <source>C&amp;lear</source>
        <translation>B&amp;orrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="67"/>
        <source>&amp;Get Field Names</source>
        <translation>&amp;Obtener nombres de los campos</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="69"/>
        <source>&amp;File</source>
        <translation>&amp;Archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="76"/>
        <source>&amp;Edit</source>
        <translation>&amp;Editar</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="100"/>
        <source>OK</source>
        <translation type="unfinished">Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="104"/>
        <source>Cancel</source>
        <translation type="unfinished">Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="132"/>
        <location filename="../../../scribus/editor.cpp" line="148"/>
        <source>JavaScripts (*.js);;All Files (*)</source>
        <translation>JavaScripts (*.js);;Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="41"/>
        <source>Ctrl+N</source>
        <translation>Ctrl+N</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="52"/>
        <source>Ctrl+Z</source>
        <translation>Ctrl+Z</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="57"/>
        <source>Ctrl+X</source>
        <translation>Ctrl+X</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="60"/>
        <source>Ctrl+C</source>
        <translation>Ctrl+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="63"/>
        <source>Ctrl-V</source>
        <translation>Ctrl-V</translation>
    </message>
</context>
<context>
    <name>EffectsDialog</name>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="45"/>
        <source>Image Effects</source>
        <translation>Efectos de imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="82"/>
        <source>Options:</source>
        <translation>Opciones:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="99"/>
        <source>Color:</source>
        <translation>Color:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="110"/>
        <source>Shade:</source>
        <translation>Saturación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="126"/>
        <source>Brightness:</source>
        <translation>Brillo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="148"/>
        <source>Contrast:</source>
        <translation>Contraste:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="170"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="199"/>
        <source>Radius:</source>
        <translation>Radio:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="181"/>
        <source>Value:</source>
        <translation>Valor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="217"/>
        <source>Posterize:</source>
        <translation>Posterizar:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="456"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="473"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="501"/>
        <source>Available Effects</source>
        <translation>Efectos disponibles</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="460"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="542"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="779"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="841"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1296"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1418"/>
        <source>Blur</source>
        <translation>Desenfocar</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="461"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="527"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="764"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="835"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1247"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1396"/>
        <source>Brightness</source>
        <translation>Brillo</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="462"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="518"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="759"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="845"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="900"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="987"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1387"/>
        <source>Colorize</source>
        <translation>Colorear</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="466"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="532"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="769"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="837"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1263"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1402"/>
        <source>Contrast</source>
        <translation>Contraste</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="467"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="513"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="754"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="833"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="983"/>
        <source>Grayscale</source>
        <translation>Escala de grises</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="469"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="508"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="749"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="831"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="985"/>
        <source>Invert</source>
        <translation>Invertir</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="470"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="552"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="787"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="843"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1308"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1431"/>
        <source>Posterize</source>
        <translation>Posterizar</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="471"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="537"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="774"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="839"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1279"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1408"/>
        <source>Sharpen</source>
        <translation>Enfocar</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="483"/>
        <source>&gt;&gt;</source>
        <translation>&gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="487"/>
        <source>&lt;&lt;</source>
        <translation>&lt;&lt;</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="498"/>
        <source>Effects in use</source>
        <translation>Efectos en uso</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="617"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="621"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="236"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="286"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="352"/>
        <source>Color 1:</source>
        <translation>Color 1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="257"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="306"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="372"/>
        <source>Color 2:</source>
        <translation>Color 2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="326"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="392"/>
        <source>Color 3:</source>
        <translation>Color 3:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="412"/>
        <source>Color 4:</source>
        <translation>Color 4:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="463"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="557"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="792"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="856"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="900"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1004"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1437"/>
        <source>Duotone</source>
        <translation>Duotono</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="464"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="566"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="797"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="867"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="900"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1062"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1473"/>
        <source>Tritone</source>
        <translation type="unfinished">Tritono</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="465"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="575"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="802"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="878"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="900"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1143"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1524"/>
        <source>Quadtone</source>
        <translation type="unfinished">Cuadritono</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="468"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="584"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="807"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="889"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1324"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1590"/>
        <source>Curves</source>
        <translation>Curvas</translation>
    </message>
</context>
<context>
    <name>ExportBitmap</name>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="203"/>
        <source>File exists. Overwrite?</source>
        <translation>El archivo existe. ¿Sobreescribir?</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="204"/>
        <source>exists already. Overwrite?</source>
        <translation>ya exste. ¿Sobreescribir?</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="190"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="217"/>
        <source>Save as Image</source>
        <translation>Guardar como imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="190"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="191"/>
        <source>Insufficient memory for this image size.</source>
        <translation>Memoria insuficiente para el tamaño de archivo.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="217"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="218"/>
        <source>Error writing the output file(s).</source>
        <translation>Se produjo un error escribiendo el/los archivo/s de salida.</translation>
    </message>
</context>
<context>
    <name>ExportForm</name>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="80"/>
        <source>Choose a Export Directory</source>
        <translation>Elige un directorio donde exportar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="13"/>
        <source>Export as Image(s)</source>
        <translation>Exportar como imagen/es</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="153"/>
        <source>&amp;Export to Directory:</source>
        <translation>&amp;Exportar al directorio:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="166"/>
        <source>C&amp;hange...</source>
        <translation>Cam&amp;biar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="25"/>
        <source>Options</source>
        <translation>Opciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="54"/>
        <source>Image &amp;Type:</source>
        <translation>&amp;Tipo de imagen:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="64"/>
        <source>&amp;Quality:</source>
        <translation>Cali&amp;dad:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="74"/>
        <source>&amp;Resolution:</source>
        <translation>Resol&amp;ución:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="84"/>
        <source>&amp;Size:</source>
        <translation>&amp;Tamaño:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="94"/>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="126"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="110"/>
        <source> dpi</source>
        <translation> dpi</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="175"/>
        <source>Range</source>
        <translation>Rango</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="197"/>
        <source>&amp;Current page</source>
        <translation>Página &amp;actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="224"/>
        <source>&amp;All pages</source>
        <translation>Todas las &amp;páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="217"/>
        <source>&amp;Range</source>
        <translation>&amp;Intervalo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="117"/>
        <source>Export a range of pages</source>
        <translation>Exportar un intervalo de páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="118"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation>Inserta una lista de elementos separados por comas,
donde un elemento puede ser * para todas las páginas,
1-5 para un intervalo de páginas o un único número.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="119"/>
        <source>Export all pages</source>
        <translation>Exportar todas las páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="120"/>
        <source>Export only the current page</source>
        <translation>Exportar sólo la página actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="121"/>
        <source>Resolution of the Images
Use 72 dpi for Images intended for the Screen</source>
        <translation>Resolución de las imágenes
Usa 72 dpi para imágenes dirigidas a verse en pantalla</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="122"/>
        <source>Size of the images. 100% for no changes, 200% for two times larger etc.</source>
        <translation>Tamaño de las imágenes. 100% para que no cambie, 200% para el doble de grande, etc.</translation>
    </message>
    <message>
        <source>The quality of your images - 100% is the best, 1% the lowest quality</source>
        <translation type="obsolete">La calidad de las imágenes - 100% es la  mejor calidad, 1% la peor</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="125"/>
        <source>Available export formats</source>
        <translation>Formatos de exportación disponibles</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="126"/>
        <source>The output directory - the place to store your images.
Name of the export file will be &apos;documentname-pagenumber.filetype&apos;</source>
        <translation>El directorio de salida - donde se almacenarán las imágenes.
El nombre del archivo será &apos;nombredocumento-númeropágina.tipoarchivo&apos;</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="127"/>
        <source>Change the output directory</source>
        <translation>Cambiar el directorio de salida</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="44"/>
        <source>Image size in Pixels</source>
        <translation>Tamaño de imagen en píxeles</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="37"/>
        <source>TextLabel</source>
        <translation>Etiqueta de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="123"/>
        <source>The compression ratio of your images - 100% is no compression, 0% highest compression. If in doubt, use &apos;Automatic&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="124"/>
        <source>Automatic</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ExtImageProps</name>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="40"/>
        <source>Extended Image Properties</source>
        <translation>Propiedades de imagen extendidas</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="58"/>
        <location filename="../../../scribus/extimageprops.cpp" line="76"/>
        <location filename="../../../scribus/extimageprops.cpp" line="110"/>
        <source>Normal</source>
        <translation>Normal</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="59"/>
        <location filename="../../../scribus/extimageprops.cpp" line="77"/>
        <location filename="../../../scribus/extimageprops.cpp" line="111"/>
        <source>Darken</source>
        <translation>Oscurecer</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="60"/>
        <location filename="../../../scribus/extimageprops.cpp" line="78"/>
        <location filename="../../../scribus/extimageprops.cpp" line="112"/>
        <source>Lighten</source>
        <translation>Aclarar</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="61"/>
        <location filename="../../../scribus/extimageprops.cpp" line="79"/>
        <location filename="../../../scribus/extimageprops.cpp" line="113"/>
        <source>Hue</source>
        <translation>Tono</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="62"/>
        <location filename="../../../scribus/extimageprops.cpp" line="80"/>
        <location filename="../../../scribus/extimageprops.cpp" line="114"/>
        <source>Saturation</source>
        <translation>Saturación</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="63"/>
        <location filename="../../../scribus/extimageprops.cpp" line="81"/>
        <location filename="../../../scribus/extimageprops.cpp" line="115"/>
        <source>Color</source>
        <translation>Color</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="64"/>
        <location filename="../../../scribus/extimageprops.cpp" line="82"/>
        <location filename="../../../scribus/extimageprops.cpp" line="116"/>
        <source>Luminosity</source>
        <translation>Luminosidad</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="65"/>
        <location filename="../../../scribus/extimageprops.cpp" line="83"/>
        <location filename="../../../scribus/extimageprops.cpp" line="117"/>
        <source>Multiply</source>
        <translation>Multiplicación</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="66"/>
        <location filename="../../../scribus/extimageprops.cpp" line="84"/>
        <location filename="../../../scribus/extimageprops.cpp" line="118"/>
        <source>Screen</source>
        <translation>Trama</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="67"/>
        <location filename="../../../scribus/extimageprops.cpp" line="85"/>
        <location filename="../../../scribus/extimageprops.cpp" line="119"/>
        <source>Dissolve</source>
        <translation>Disolver</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="68"/>
        <location filename="../../../scribus/extimageprops.cpp" line="86"/>
        <location filename="../../../scribus/extimageprops.cpp" line="120"/>
        <source>Overlay</source>
        <translation>Superposición</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="69"/>
        <location filename="../../../scribus/extimageprops.cpp" line="87"/>
        <location filename="../../../scribus/extimageprops.cpp" line="121"/>
        <source>Hard Light</source>
        <translation>Luz dura</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="70"/>
        <location filename="../../../scribus/extimageprops.cpp" line="88"/>
        <location filename="../../../scribus/extimageprops.cpp" line="122"/>
        <source>Soft Light</source>
        <translation>Luz suave</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="71"/>
        <location filename="../../../scribus/extimageprops.cpp" line="89"/>
        <location filename="../../../scribus/extimageprops.cpp" line="123"/>
        <source>Difference</source>
        <translation>Diferencia</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="72"/>
        <location filename="../../../scribus/extimageprops.cpp" line="90"/>
        <location filename="../../../scribus/extimageprops.cpp" line="124"/>
        <source>Exclusion</source>
        <translation>Exclusión</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="73"/>
        <location filename="../../../scribus/extimageprops.cpp" line="91"/>
        <location filename="../../../scribus/extimageprops.cpp" line="125"/>
        <source>Color Dodge</source>
        <translation>Sobreexponer color</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="74"/>
        <location filename="../../../scribus/extimageprops.cpp" line="92"/>
        <location filename="../../../scribus/extimageprops.cpp" line="126"/>
        <source>Color Burn</source>
        <translation>Subexponer color</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="106"/>
        <source>Blend Mode:</source>
        <translation>Modo de fusión:</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="129"/>
        <source>Opacity:</source>
        <translation>Opacidad:</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="136"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="142"/>
        <source>Name</source>
        <translation>Nombre</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="220"/>
        <source>Layers</source>
        <translation>Capas</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="273"/>
        <source>Don&apos;t use any Path</source>
        <translation>No usar ningún trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="275"/>
        <source>Paths</source>
        <translation>Trazados</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="282"/>
        <source>Live Preview</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FDialogPreview</name>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="196"/>
        <source>Size:</source>
        <translation>Tamaño:</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="214"/>
        <source>Title:</source>
        <translation>Título:</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="217"/>
        <source>No Title</source>
        <translation>Sin título</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="219"/>
        <source>Author:</source>
        <translation>Autor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="200"/>
        <location filename="../../../scribus/customfdialog.cpp" line="222"/>
        <location filename="../../../scribus/customfdialog.cpp" line="227"/>
        <source>Unknown</source>
        <translation>Desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="229"/>
        <source>Scribus Document</source>
        <translation>Documento de Scribus</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="197"/>
        <source>Resolution:</source>
        <translation>Resolución:</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="197"/>
        <source>DPI</source>
        <translation>DPI</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="203"/>
        <source>Colorspace:</source>
        <translation>Espacio de color:</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="224"/>
        <source>File Format:</source>
        <translation>Formato de archivo:</translation>
    </message>
</context>
<context>
    <name>FileLoader</name>
    <message>
        <location filename="../../../scribus/fileloader.cpp" line="413"/>
        <source>Some fonts used by this document have been substituted:</source>
        <translation>Algunas tipografías utilizadas en este documento han sido sustituidas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/fileloader.cpp" line="417"/>
        <source> was replaced by: </source>
        <translation> fue reemplazado por: </translation>
    </message>
</context>
<context>
    <name>FileToolBar</name>
    <message>
        <location filename="../../../scribus/ui/filetoolbar.cpp" line="31"/>
        <source>File</source>
        <translation>Archivo</translation>
    </message>
</context>
<context>
    <name>FontComboH</name>
    <message>
        <source>Face:</source>
        <translation type="obsolete">Familia:</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontcombo.cpp" line="148"/>
        <source>Family:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontcombo.cpp" line="149"/>
        <source>Style:</source>
        <translation>Estilo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontcombo.cpp" line="151"/>
        <source>Font Family of Selected Text or Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontcombo.cpp" line="152"/>
        <source>Font Style of Selected Text or Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontListModel</name>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="63"/>
        <source>Font Name</source>
        <translation>Nombre de la tipografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="65"/>
        <source>Use Font</source>
        <translation>Usar tipografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="67"/>
        <source>Family</source>
        <translation>Familia</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="69"/>
        <source>Style</source>
        <translation>Estilo</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="71"/>
        <source>Variant</source>
        <translation>Variante</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="73"/>
        <source>Type</source>
        <translation>Tipo</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="75"/>
        <source>Format</source>
        <translation>Formato</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="77"/>
        <source>Embed in PostScript</source>
        <translation>Empotrar en PostScript</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="79"/>
        <source>Subset</source>
        <translation>Subconjunto</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="81"/>
        <source>Access</source>
        <translation>Acceso</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="83"/>
        <source>Used in Doc</source>
        <translation>Usada en documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="85"/>
        <source>Path to Font File</source>
        <translation>Ruta a la tipografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="144"/>
        <source>Unknown</source>
        <comment>font type</comment>
        <translation>Desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="157"/>
        <source>Unknown</source>
        <comment>font format</comment>
        <translation>Desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="164"/>
        <source>User</source>
        <comment>font preview</comment>
        <translation>Usuario</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="165"/>
        <source>System</source>
        <comment>font preview</comment>
        <translation>Sistema</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="190"/>
        <source>Click to change the value</source>
        <translation>Clic para cambiar el valor</translation>
    </message>
</context>
<context>
    <name>FontPrefs</name>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="48"/>
        <source>Available Fonts</source>
        <translation>Tipografías disponibles</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="48"/>
        <source>Font Substitutions</source>
        <translation>Sustituciones de tipografías</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="48"/>
        <source>Additional Paths</source>
        <translation>Rutas adicionales</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="66"/>
        <source>Font Name</source>
        <translation>Nombre de la tipografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="58"/>
        <source>&amp;Available Fonts</source>
        <translation>Tipografías &amp;disponibles</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="67"/>
        <source>Replacement</source>
        <translation>Reemplazo</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="82"/>
        <source>&amp;Delete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="88"/>
        <source>Font &amp;Substitutions</source>
        <translation>&amp;Sustituciones de tipografías</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="107"/>
        <source>C&amp;hange...</source>
        <translation>Cam&amp;biar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="109"/>
        <source>A&amp;dd...</source>
        <translation>A&amp;ñadir...</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="111"/>
        <source>&amp;Remove</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="135"/>
        <source>Additional &amp;Paths</source>
        <translation>&amp;Rutas Adicionales</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="229"/>
        <location filename="../../../scribus/fontprefs.cpp" line="254"/>
        <source>Choose a Directory</source>
        <translation>Elige un directorio</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="128"/>
        <source>Font search paths can only be set in File &gt; Preferences, and only when there is no document currently open. Close any open documents, then use File &gt; Preferences &gt; Fonts to change the font search path.</source>
        <translation>La ruta de búsqueda de tipografías sólo se puede configurar en Archivo &gt; Preferencias, y sólo cuando no hay ningún documento abierto. Cierra cualquier documento abierto, después ejecuta Archivo &gt; Preferencias &gt; Tipografías para cambiar la ruta de búsqueda de tipografías.</translation>
    </message>
</context>
<context>
    <name>FontPreview</name>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="13"/>
        <source>Fonts Preview</source>
        <translation>Previsualizar tipografías</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="170"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Buscar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.cpp" line="111"/>
        <source>Leave preview</source>
        <comment>font preview</comment>
        <translation>Salir de la previsualización</translation>
    </message>
    <message>
        <source>Start searching</source>
        <translation type="obsolete">Comenzar búsqueda</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.cpp" line="113"/>
        <source>Size of the selected font</source>
        <translation>Tamaño de la tipografía seleccionada</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <comment>font preview</comment>
        <translation>El veloz murciélago hindú comía feliz cardillo y kiwi. La cigüeña tocaba el saxofón detrás del palenque de paja. 1234567890</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="19"/>
        <source>&amp;Quick Search:</source>
        <translation>Búsqueda rápi&amp;da:</translation>
    </message>
    <message>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="80"/>
        <source>&amp;Font Size:</source>
        <translation>Tamaño de tipogra&amp;fía:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="103"/>
        <source>Text</source>
        <translation>Texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="113"/>
        <source>Sample text to display</source>
        <translation>Texto de muestra para mostrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="123"/>
        <source>Se&amp;t</source>
        <translation>Ap&amp;licar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="126"/>
        <source>Alt+T</source>
        <translation>Alt+T</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="133"/>
        <source>Reset the text</source>
        <translation>Reiniciar el texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="167"/>
        <source>&amp;Close</source>
        <translation>&amp;Cerrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.cpp" line="112"/>
        <source>Typing the text here provides quick searching in the font names. Searching is case insensitive. The given text is taken as substring.</source>
        <translation>Escribiendo el texto aquí permite una búsqueda rápida por los nombres de las tipografías. La búsqueda es sensible a mayúsculas y minúsculas. El texto obtenido se trata como una subcadena.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="136"/>
        <source>&amp;Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="35"/>
        <source>Show Extended Font Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="120"/>
        <source>Set the preview text</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPreviewPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="49"/>
        <source>&amp;Font Preview...</source>
        <translation>Vista previa de la tipogra&amp;fía...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="66"/>
        <source>Font Preview dialog</source>
        <translation>Diálogo de vista previa de tipografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="67"/>
        <source>Sorting, searching and browsing available fonts.</source>
        <translation>Ordenar, búscar y navegar por las tipografías disponibles.</translation>
    </message>
</context>
<context>
    <name>FontReplaceDialog</name>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="30"/>
        <source>Font Substitution</source>
        <translation>Sustitución de tipografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="45"/>
        <source>Original Font</source>
        <translation>Tipografía original</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="46"/>
        <source>Substitution Font</source>
        <translation>Tipografía sustituida</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="72"/>
        <source>Make these substitutions permanent</source>
        <translation>Hacer estas sustituciones permanentes</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="84"/>
        <source>Enabling this tells Scribus to use these replacements for missing fonts permanently in all future layouts. This can be reverted or changed in File &gt; Preferences &gt; Fonts.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="40"/>
        <source>This document contains some fonts that are not installed on your system, please choose a suitable replacement for them. Cancel will stop the document from loading.</source>
        <translation>Este documento contiene algunas tipografías que no están instaladas en el sistema, por favor, elige un reemplazo adecuado para ellas. Cancelar detendrá la carga del documento.</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="83"/>
        <source>Cancels these font substitutions and stops loading the document.</source>
        <translation>Cancela la sustitución de tipografías y detiene la carga del documento.</translation>
    </message>
    <message>
        <source>Enabling this tells Scribus to use these replacements for missing fonts permanently in all future layouts. This can be reverted or changed in Edit &gt; Preferences &gt; Fonts.</source>
        <translation type="obsolete">Activando esto, permite a Scribus usar estos reemplazos para las tipografías no disponibles en cualquier futuro esquema. Esto se puede revertir o cambiar en Editar &gt; Preferencias &gt; Tipografías.</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="85"/>
        <source>If you select OK, then save, these substitutions are made permanent in the document.</source>
        <translation>Si seleccionas OK y después guardas, estas sustituciones serán permanentes en el documento.</translation>
    </message>
</context>
<context>
    <name>GradientEditor</name>
    <message>
        <location filename="../../../scribus/gradienteditor.cpp" line="332"/>
        <source>Position:</source>
        <translation>Posición:</translation>
    </message>
    <message>
        <location filename="../../../scribus/gradienteditor.cpp" line="333"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/gradienteditor.cpp" line="341"/>
        <source>Add, change or remove color stops here</source>
        <translation>Añade, cambia o elimina paradas de color aquí</translation>
    </message>
</context>
<context>
    <name>GradientVectorDialog</name>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="100"/>
        <source>Gradient Vector</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManager</name>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="53"/>
        <location filename="../../../scribus/guidemanager.cpp" line="229"/>
        <source>&amp;Add</source>
        <translation>A&amp;ñadir</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="63"/>
        <location filename="../../../scribus/guidemanager.cpp" line="230"/>
        <source>D&amp;elete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="92"/>
        <location filename="../../../scribus/guidemanager.cpp" line="231"/>
        <source>A&amp;dd</source>
        <translation>Aña&amp;dir</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="102"/>
        <location filename="../../../scribus/guidemanager.cpp" line="232"/>
        <source>De&amp;lete</source>
        <translation>B&amp;orrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="117"/>
        <location filename="../../../scribus/guidemanager.cpp" line="233"/>
        <source>&amp;Lock Guides</source>
        <translation>B&amp;loquear las guías</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="192"/>
        <location filename="../../../scribus/guidemanager.ui" line="279"/>
        <location filename="../../../scribus/guidemanager.cpp" line="243"/>
        <location filename="../../../scribus/guidemanager.cpp" line="246"/>
        <source>&amp;Page</source>
        <translation>&amp;Página</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="29"/>
        <location filename="../../../scribus/guidemanager.cpp" line="224"/>
        <source>&amp;Single</source>
        <translation>&amp;Simple</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="37"/>
        <location filename="../../../scribus/guidemanager.ui" line="144"/>
        <location filename="../../../scribus/guidemanager.cpp" line="227"/>
        <location filename="../../../scribus/guidemanager.cpp" line="235"/>
        <source>Horizontals</source>
        <translation>Horizontales</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="56"/>
        <location filename="../../../scribus/guidemanager.ui" line="208"/>
        <location filename="../../../scribus/guidemanager.ui" line="295"/>
        <location filename="../../../scribus/guidemanager.ui" line="354"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="66"/>
        <location filename="../../../scribus/guidemanager.ui" line="218"/>
        <location filename="../../../scribus/guidemanager.ui" line="305"/>
        <source>Alt+E</source>
        <translation>Alt+E</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="76"/>
        <location filename="../../../scribus/guidemanager.ui" line="231"/>
        <location filename="../../../scribus/guidemanager.cpp" line="228"/>
        <location filename="../../../scribus/guidemanager.cpp" line="236"/>
        <source>Verticals</source>
        <translation>Verticales</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="95"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="105"/>
        <location filename="../../../scribus/guidemanager.ui" line="120"/>
        <source>Alt+L</source>
        <translation>Alt+L</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="127"/>
        <location filename="../../../scribus/guidemanager.ui" line="318"/>
        <location filename="../../../scribus/guidemanager.cpp" line="234"/>
        <location filename="../../../scribus/guidemanager.cpp" line="249"/>
        <source>Appl&amp;y to All Pages</source>
        <translation>Apl&amp;icar a todas las páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="130"/>
        <location filename="../../../scribus/guidemanager.ui" line="321"/>
        <source>Alt+Y</source>
        <translation>Alt+Y</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="138"/>
        <location filename="../../../scribus/guidemanager.cpp" line="225"/>
        <source>&amp;Column/Row</source>
        <translation>&amp;Columna/Fila</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="150"/>
        <location filename="../../../scribus/guidemanager.cpp" line="237"/>
        <source>&amp;Number:</source>
        <translation>&amp;Número:</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="173"/>
        <location filename="../../../scribus/guidemanager.cpp" line="239"/>
        <source>U&amp;se Gap:</source>
        <translation>U&amp;sar espaciado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="176"/>
        <source>Alt+S</source>
        <translation>Alt+S</translation>
    </message>
    <message>
        <source>Refer To</source>
        <translation type="obsolete">Referido a</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="195"/>
        <location filename="../../../scribus/guidemanager.ui" line="282"/>
        <location filename="../../../scribus/guidemanager.ui" line="341"/>
        <source>Alt+P</source>
        <translation>Alt+P</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="205"/>
        <location filename="../../../scribus/guidemanager.ui" line="292"/>
        <location filename="../../../scribus/guidemanager.cpp" line="244"/>
        <location filename="../../../scribus/guidemanager.cpp" line="247"/>
        <source>M&amp;argins</source>
        <translation>&amp;Margenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="215"/>
        <location filename="../../../scribus/guidemanager.ui" line="302"/>
        <location filename="../../../scribus/guidemanager.cpp" line="245"/>
        <location filename="../../../scribus/guidemanager.cpp" line="248"/>
        <source>S&amp;election</source>
        <translation>S&amp;elección</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="237"/>
        <location filename="../../../scribus/guidemanager.cpp" line="238"/>
        <source>Nu&amp;mber:</source>
        <translation>Nú&amp;mero:</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="260"/>
        <location filename="../../../scribus/guidemanager.cpp" line="240"/>
        <source>Use &amp;Gap:</source>
        <translation>Usar espacia&amp;do:</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="263"/>
        <source>Alt+G</source>
        <translation>Alt+G</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="329"/>
        <location filename="../../../scribus/guidemanager.cpp" line="226"/>
        <source>&amp;Misc</source>
        <translation>&amp;Miscelánea</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="335"/>
        <source>Delete all guides from the current page</source>
        <translation>Elimina todas las guías de la página actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="338"/>
        <location filename="../../../scribus/guidemanager.cpp" line="250"/>
        <source>Delete Guides from Current &amp;Page</source>
        <translation>Elimina guías de la &amp;página actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="348"/>
        <source>Delete all guides from the current document</source>
        <translation>Elimina todas las guías del documento actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="351"/>
        <location filename="../../../scribus/guidemanager.cpp" line="251"/>
        <source>Delete Guides from &amp;All Pages</source>
        <translation>Elimina guías de tod&amp;as las páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="16"/>
        <location filename="../../../scribus/guidemanager.cpp" line="223"/>
        <source>Guide Manager</source>
        <translation>Gestor de guías</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="253"/>
        <source>Add a new horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="254"/>
        <source>Delete the selected horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="255"/>
        <source>Add a new vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="256"/>
        <source>Delete the selected vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="257"/>
        <source>Lock the guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="258"/>
        <source>Apply to all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="259"/>
        <source>Number of horizontal guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="260"/>
        <source>Number of vertical guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="261"/>
        <source>Create rows with guides, with an additional gap between the rows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="262"/>
        <source>Create columns with guides, with an additional gap between the columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="263"/>
        <source>Create the selected number of horizontal guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="264"/>
        <source>Create the selected number of horizontal guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="265"/>
        <source>Create the selected number of horizontal guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="266"/>
        <source>Create the selected number of vertical guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="267"/>
        <source>Create the selected number of vertical guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="268"/>
        <source>Create the selected number of vertical guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="269"/>
        <source>Apply the shown guides to all pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="270"/>
        <source>Delete all guides shown on the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="271"/>
        <source>Delete all guides from all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="186"/>
        <location filename="../../../scribus/guidemanager.ui" line="273"/>
        <location filename="../../../scribus/guidemanager.cpp" line="241"/>
        <location filename="../../../scribus/guidemanager.cpp" line="242"/>
        <source>Refer to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HelpBrowser</name>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="286"/>
        <source>Scribus Online Help</source>
        <translation>Ayuda de Scribus en línea</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="31"/>
        <source>&amp;Contents</source>
        <translation>&amp;Contenidos</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="60"/>
        <source>&amp;Search</source>
        <translation>&amp;Buscar</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="377"/>
        <source>Find</source>
        <translation>Buscar</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="377"/>
        <source>Search Term:</source>
        <translation>Término de búsqueda:</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="45"/>
        <source>Se&amp;arch</source>
        <translation>Busc&amp;ar</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="96"/>
        <source>&amp;New</source>
        <translation>&amp;Nuevo</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="103"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="178"/>
        <location filename="../../../scribus/helpbrowser.cpp" line="298"/>
        <source>&amp;Delete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="79"/>
        <source>Book&amp;marks</source>
        <translation>&amp;Marcadores</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="148"/>
        <location filename="../../../scribus/helpbrowser.cpp" line="292"/>
        <source>&amp;Print...</source>
        <translation>&amp;Imprimir...</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark</source>
        <translation>Nuevo marcador</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark&apos;s Title:</source>
        <translation>Título del nuevo marcador:</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="288"/>
        <source>&amp;File</source>
        <translation>&amp;Archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="158"/>
        <location filename="../../../scribus/helpbrowser.cpp" line="294"/>
        <source>&amp;Find...</source>
        <translation>&amp;Buscar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="295"/>
        <source>Find &amp;Next</source>
        <translation>Buscar siguie&amp;nte</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="296"/>
        <source>Find &amp;Previous</source>
        <translation>Buscar an&amp;terior</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="289"/>
        <source>&amp;Edit</source>
        <translation>&amp;Editar</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="297"/>
        <source>&amp;Add Bookmark</source>
        <translation>&amp;Añadir marcador</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="110"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="183"/>
        <location filename="../../../scribus/helpbrowser.cpp" line="299"/>
        <source>D&amp;elete All</source>
        <translation>&amp;Eliminar todo</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="290"/>
        <source>&amp;Bookmarks</source>
        <translation>&amp;Marcadores</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="13"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="137"/>
        <source>Scribus Help</source>
        <translation>Ayuda de Scribus</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="53"/>
        <source>Searching is case insensitive</source>
        <translation>La búsqueda distingue entre mayúsculas y minúsculas</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="70"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="86"/>
        <source>1</source>
        <translation>1</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="153"/>
        <source>&amp;Exit</source>
        <translation>Sali&amp;r</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="163"/>
        <source>Find &amp;Next...</source>
        <translation>Buscar siguie&amp;nte...</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="168"/>
        <source>Find &amp;Previous...</source>
        <translation>Buscar ante&amp;rior...</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="173"/>
        <source>&amp;Add</source>
        <translation>A&amp;ñadir</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="293"/>
        <source>&amp;Quit</source>
        <translation>&amp;Salir</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="718"/>
        <source>&lt;h2&gt;&lt;p&gt;Sorry, no manual is installed!&lt;/p&gt;&lt;p&gt;Please see:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;http://docs.scribus.net for updated documentation&lt;/li&gt;&lt;li&gt;http://www.scribus.net for downloads&lt;/li&gt;&lt;/ul&gt;&lt;/h2&gt;</source>
        <comment>HTML message for no documentation available to show</comment>
        <translation>&lt;h2&gt;&lt;p&gt;Lo siento, ¡no hay ningún manual instalado!&lt;/p&gt;&lt;p&gt;Por favor, visita:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;http://docs.scribus.net para la documentación acutalizada&lt;/li&gt;&lt;li&gt;http://www.scribus.net para descargas&lt;/li&gt;&lt;/ul&gt;&lt;/h2&gt;</translation>
    </message>
</context>
<context>
    <name>HunspellDialog</name>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspelldialog.cpp" line="80"/>
        <source>Spelling check complete</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HunspellDialogBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspelldialogbase.ui" line="14"/>
        <source>Check Spelling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspelldialogbase.ui" line="22"/>
        <source>Text Language:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspelldialogbase.ui" line="47"/>
        <source>Not in dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspelldialogbase.ui" line="61"/>
        <source>Ignore Once</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspelldialogbase.ui" line="68"/>
        <source>Ignore All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspelldialogbase.ui" line="92"/>
        <source>Suggestions</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspelldialogbase.ui" line="106"/>
        <source>Change</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspelldialogbase.ui" line="113"/>
        <source>Change All</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HunspellPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspellplugin.cpp" line="33"/>
        <source>Check Spelling...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspellplugin.cpp" line="64"/>
        <source>Hunspell-based spell checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/hunspellcheck/hunspellplugin.cpp" line="65"/>
        <source>Spell Checker based on the Hunspell libraries</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HyAsk</name>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="48"/>
        <source>Possible Hyphenation</source>
        <translation>Posible división</translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="68"/>
        <source>Accept</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="89"/>
        <source>Skip</source>
        <translation>Saltar</translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="107"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="77"/>
        <source>Add to the
Exception List</source>
        <translation>Añadir a la
lista de excepciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="97"/>
        <source>Add to the
Ignore List</source>
        <translation>Añadir a la
lista de ignorar</translation>
    </message>
</context>
<context>
    <name>HySettings</name>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="91"/>
        <location filename="../../../scribus/hysettings.cpp" line="103"/>
        <source>Ignore List</source>
        <translation>Lista de ignorar</translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="91"/>
        <location filename="../../../scribus/hysettings.cpp" line="132"/>
        <source>Add a new Entry</source>
        <translation>Añadir una nueva entrada</translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="103"/>
        <location filename="../../../scribus/hysettings.cpp" line="144"/>
        <source>Edit Entry</source>
        <translation>Editar entrada</translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="132"/>
        <location filename="../../../scribus/hysettings.cpp" line="144"/>
        <source>Exception List</source>
        <translation>Lista de excepciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="253"/>
        <location filename="../../../scribus/hysettings.cpp" line="413"/>
        <source>Language</source>
        <translation type="unfinished">Idioma</translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="253"/>
        <location filename="../../../scribus/hysettings.cpp" line="413"/>
        <source>Code</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="253"/>
        <source>Location</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="413"/>
        <source>Installed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="413"/>
        <source>Download</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImageInfoDialog</name>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="23"/>
        <source>Image Info</source>
        <translation>Información de imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="30"/>
        <source>General Info</source>
        <translation>Información general</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="34"/>
        <source>Date / Time:</source>
        <translation>Fecha / Hora:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="38"/>
        <source>Has Embedded Profile:</source>
        <translation>Tiene un perfil incrustado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="46"/>
        <source>Profile Name:</source>
        <translation>Nombre de perfil:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="50"/>
        <source>Has Embedded Paths:</source>
        <translation>Tiene rutas incrustadas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="58"/>
        <source>Has Layers:</source>
        <translation>Tiene capas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="69"/>
        <source>EXIF Info</source>
        <translation>Información EXIF</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="84"/>
        <source>Artist:</source>
        <translation>Artista:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="126"/>
        <source>Comment:</source>
        <translation>Comentario:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="127"/>
        <source>User Comment:</source>
        <translation>Comentario del usuario:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="128"/>
        <source>Camera Model:</source>
        <translation>Modo de cámara:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="129"/>
        <source>Camera Manufacturer:</source>
        <translation>Fabricante de cámara:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="135"/>
        <source>Description:</source>
        <translation>Descripción:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="136"/>
        <source>Copyright:</source>
        <translation>Copyright:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="137"/>
        <source>Scanner Model:</source>
        <translation>Modelo de escáner:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="138"/>
        <source>Scanner Manufacturer:</source>
        <translation>Fabricante de escáner:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="130"/>
        <source>Exposure time</source>
        <translation>Tiempo de exposición</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="131"/>
        <source>Aperture:</source>
        <translation>Apertura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="132"/>
        <source>ISO equiv.:</source>
        <translation>Equivalente ISO:</translation>
    </message>
</context>
<context>
    <name>ImportAIPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/import/ai/importaiplugin.cpp" line="58"/>
        <source>Import AI...</source>
        <translation>Importar AI...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ai/importaiplugin.cpp" line="79"/>
        <source>Imports Illustrator Files</source>
        <translation>Importa archivos Illustrator</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ai/importaiplugin.cpp" line="80"/>
        <source>Imports most Illustrator files into the current document,
converting their vector data into Scribus objects.</source>
        <translation>Importa la mayoría de archivos Illustrator en el documento
actual, convirtiendo los datos de vectores en objetos de Scribus.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ai/importaiplugin.cpp" line="162"/>
        <source>The file could not be imported</source>
        <translation type="unfinished">El archivo no puede ser importado</translation>
    </message>
</context>
<context>
    <name>ImportCvgPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/import/cvg/importcvgplugin.cpp" line="58"/>
        <source>Import Cvg...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/cvg/importcvgplugin.cpp" line="79"/>
        <source>Imports Cvg Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/cvg/importcvgplugin.cpp" line="80"/>
        <source>Imports most Cvg files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/cvg/importcvgplugin.cpp" line="126"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Todos los formatos soportados</translation>
    </message>
</context>
<context>
    <name>ImportPSPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importpsplugin.cpp" line="57"/>
        <source>Import PostScript...</source>
        <translation>Importar PostScript...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importpsplugin.cpp" line="78"/>
        <source>Imports PostScript Files</source>
        <translation>Importa archivos PostScript</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ps/importpsplugin.cpp" line="79"/>
        <source>Imports most PostScript files into the current document,
converting their vector data into Scribus objects.</source>
        <translation>Importa la mayoría de archivos PostScript en el documento
actual, conviritiendo los datos de vectores en objetos de Scribus.</translation>
    </message>
</context>
<context>
    <name>ImportPctPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/import/pct/importpctplugin.cpp" line="51"/>
        <source>Import Pict...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/pct/importpctplugin.cpp" line="72"/>
        <source>Imports Pict Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/pct/importpctplugin.cpp" line="73"/>
        <source>Imports most Mac Pict files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/pct/importpctplugin.cpp" line="119"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Todos los formatos soportados</translation>
    </message>
</context>
<context>
    <name>ImportXfigPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/import/xfig/importxfigplugin.cpp" line="58"/>
        <source>Import Xfig...</source>
        <translation>Importar Xfig...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/xfig/importxfigplugin.cpp" line="79"/>
        <source>Imports Xfig Files</source>
        <translation>Importa archivos Xfig</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/xfig/importxfigplugin.cpp" line="80"/>
        <source>Imports most Xfig files into the current document,
converting their vector data into Scribus objects.</source>
        <translation>Importa la mayoría de archivos Xfig en el documento
actual, conviritiendo los datos de vector en objetos Scribus.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/xfig/importxfigplugin.cpp" line="126"/>
        <source>All Supported Formats</source>
        <translation>Todos los formatos soportados</translation>
    </message>
</context>
<context>
    <name>Imposition</name>
    <message>
        <location filename="../../../scribus/plugins/imposition/imposition.cpp" line="72"/>
        <source>Portrait</source>
        <translation>Vertical</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/imposition.cpp" line="73"/>
        <source>Landscape</source>
        <translation>Apaisado</translation>
    </message>
</context>
<context>
    <name>ImpositionBase</name>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="19"/>
        <source>Imposition</source>
        <translation>Imposición</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="44"/>
        <source>Gri&amp;d</source>
        <translation>Rej&amp;illa</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="102"/>
        <source>Copies</source>
        <translation>Copias</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="157"/>
        <source>Do&amp;uble sided</source>
        <translation>Do&amp;ble cara</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="160"/>
        <source>Alt+U</source>
        <translation>Alt+U</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="186"/>
        <source>Front side</source>
        <translation>Cara frontal</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="218"/>
        <source>Back side</source>
        <translation>Cara trasera</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="253"/>
        <source>&amp;Booklet</source>
        <translation>&amp;Folleto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="285"/>
        <source>Pages per sheet</source>
        <translation>Páginas por hoja</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="296"/>
        <source>4</source>
        <translation>4</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="301"/>
        <source>8</source>
        <translation>8</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="306"/>
        <source>16</source>
        <translation>16</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="318"/>
        <source>Pages</source>
        <translation>Páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="325"/>
        <source>&lt;html&gt;&lt;head&gt;&lt;meta name=&quot;qrichtext&quot; content=&quot;1&quot; /&gt;&lt;style type=&quot;text/css&quot;&gt;
p, li { white-space: pre-wrap; }
&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot; font-family:&apos;Sans Serif&apos;; font-size:9pt; font-weight:400; font-style:normal;&quot;&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Separate pages with a comma, ranges with a hyphen, e.g. 1,4,9-11 to get pages 1,4,9,10,11.&lt;/p&gt;&lt;/body&gt;&lt;/html&gt;</source>
        <translation>&lt;html&gt;&lt;head&gt;&lt;meta name=&quot;qrichtext&quot; content=&quot;1&quot; /&gt;&lt;style type=&quot;text/css&quot;&gt;
p, li { white-space: pre-wrap; }
&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot; font-family:&apos;Sans Serif&apos;; font-size:9pt; font-weight:400; font-style:normal;&quot;&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Separar páginas con una coma, rangos con un guión, p.ej.  1,4,9-11 para obtener las páginas 1,4,9,10,11.&lt;/p&gt;&lt;/body&gt;&lt;/html&gt;</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="339"/>
        <source>Fold</source>
        <translation>Plegar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="349"/>
        <source>Front page from</source>
        <translation>Página principal desde</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="376"/>
        <source>Double sided</source>
        <translation>Doble cara</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="387"/>
        <source>Back page from</source>
        <translation>Página trasera desde</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="415"/>
        <source>Destination page</source>
        <translation>Página de destino</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="455"/>
        <source>Size</source>
        <translation>Tamaño</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="487"/>
        <source>Orientation</source>
        <translation>Orientación</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="519"/>
        <source>Width</source>
        <translation>Anchura</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="564"/>
        <source>Height</source>
        <translation>Altura</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="620"/>
        <source>Preview</source>
        <translation>Vista previa</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="627"/>
        <source>Refresh preview</source>
        <translation>Refrescar vista previa</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="671"/>
        <source>&amp;OK</source>
        <translation>&amp;Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="674"/>
        <source>Alt+G</source>
        <translation>Alt+G</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="681"/>
        <source>&amp;Cancel</source>
        <translation>&amp;Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="684"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
</context>
<context>
    <name>ImpositionPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionplugin.cpp" line="37"/>
        <source>&amp;Imposition...</source>
        <translation>&amp;Imposición...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionplugin.cpp" line="69"/>
        <source>Imposition dialog</source>
        <translation>Diálogo de imposición</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionplugin.cpp" line="70"/>
        <source>Imposition on grids, booklets and folds</source>
        <translation>Imposición en rejillas, folletos y plegados</translation>
    </message>
</context>
<context>
    <name>InsPage</name>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="30"/>
        <source>Insert Page</source>
        <translation>Insertar página</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="46"/>
        <source>Page(s)</source>
        <translation>Página/s</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="50"/>
        <source>before Page</source>
        <translation>antes de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="51"/>
        <source>after Page</source>
        <translation>después de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="52"/>
        <source>at End</source>
        <translation>al final</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="42"/>
        <location filename="../../../scribus/inspage.cpp" line="63"/>
        <source>&amp;Insert</source>
        <translation>&amp;Insertar</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="67"/>
        <source>Master Pages</source>
        <translation>Páginas maestras</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="79"/>
        <source>&amp;Master Page:</source>
        <translation>Página &amp;maestra:</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="219"/>
        <source>Page Size</source>
        <translation>Tamaño de página</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="223"/>
        <source>&amp;Size:</source>
        <translation>&amp;Tamaño:</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="238"/>
        <source>Orie&amp;ntation:</source>
        <translation>&amp;Orientación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="241"/>
        <source>Portrait</source>
        <translation>Vertical</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="242"/>
        <source>Landscape</source>
        <translation>Apaisado</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="247"/>
        <source>&amp;Width:</source>
        <translation>Anc&amp;hura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="254"/>
        <source>&amp;Height:</source>
        <translation>Al&amp;tura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="259"/>
        <source>Move Objects with their Page</source>
        <translation>Mover objetos con su página</translation>
    </message>
</context>
<context>
    <name>InsertAFrame</name>
    <message>
        <location filename="../../../scribus/insertaframe.cpp" line="237"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable format from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the simple Story Editor.</source>
        <translation type="obsolete">&lt;b&gt;Inserta un marco de texto&lt;/b&gt;&lt;br/&gt;Un marco de texto te permite introducir cualquier texto en una posición determinada con el formato que elijas. Puedes seleccionar un archivo de texto en la pestaña Opciones si quieres importar inmediatamente un documento en el marco. Scribus soporta una gran variedad de formatos desde texto plano a OpenOffice.org.&lt;br/&gt;Tu texto puede ser editado y formateado directamente en la página o usando el Story Editor.</translation>
    </message>
    <message>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="obsolete">&lt;b&gt;Inserta un marco de imagen&lt;/b&gt;&lt;br/&gt;Un marco de imagen te permite colocar una imagen en la página. Se pueden aplicar o combinar varios efectos de imagen incluyendo transparencias, brillo, posterizado que permiten retocar o crear interesantes resultados visuales. El escalado y la forma de imágenes se realiza en la Paleta de propiedades.</translation>
    </message>
    <message>
        <source>Insert A Frame</source>
        <translation type="obsolete">Insertar un marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="24"/>
        <source>T&amp;ype</source>
        <translation>T&amp;ipo</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="44"/>
        <source>&amp;Text Frame</source>
        <translation>Marco de &amp;texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="54"/>
        <source>&amp;Image Frame</source>
        <translation>Marco de &amp;imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="87"/>
        <source>&amp;Location</source>
        <translation>&amp;Posición</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="96"/>
        <source>Page Placement</source>
        <translation>Posición de página</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="105"/>
        <source>Current Page</source>
        <translation>Página actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="115"/>
        <source>All Pages</source>
        <translation>Todas las páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="144"/>
        <location filename="../../../scribus/insertaframe.ui" line="568"/>
        <location filename="../../../scribus/insertaframe.ui" line="610"/>
        <source>...</source>
        <translation>...</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="172"/>
        <source>Position of Frame</source>
        <translation>Posición del marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="181"/>
        <source>Top Left of Margins</source>
        <translation>Parte superior izquierda de los márgenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="191"/>
        <source>Top Left of Page</source>
        <translation>Parte superior izquierda de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="201"/>
        <source>Top Left of Bleed</source>
        <translation>Parte superior izquierda de la sangría</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="245"/>
        <source>X:</source>
        <translation>X:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="238"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="14"/>
        <source>Insert Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="300"/>
        <source>&amp;Size</source>
        <translation>&amp;Tamaño</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="318"/>
        <source>Same as the Page Margins</source>
        <translation>Igual que los márgenes de página</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="328"/>
        <source>Same as the Page</source>
        <translation>Igual que la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="338"/>
        <source>Same as the Bleed</source>
        <translation>Igual que la sangría</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="348"/>
        <source>Same as the Imported Image</source>
        <translation>Igual que la imagen importada</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="385"/>
        <source>Height:</source>
        <translation>Altura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="392"/>
        <source>Width:</source>
        <translation>Anchura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="447"/>
        <source>&amp;Options</source>
        <translation>&amp;Opciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="596"/>
        <source>Source Image:</source>
        <translation>Imagen fuente:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="636"/>
        <source>There are no options for this type of frame</source>
        <translation>No hay optiones para este tipo de marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="488"/>
        <source>Columns:</source>
        <translation>Columnas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="474"/>
        <source>Gap:</source>
        <translation>Espaciado:</translation>
    </message>
    <message>
        <source>Link Created Frames</source>
        <translation type="obsolete">Enlazar marcos creados</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="554"/>
        <source>Source Document:</source>
        <translation>Documento fuente:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="125"/>
        <source>Range of Pages</source>
        <translation>Rango de páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="211"/>
        <source>Custom Position</source>
        <translation>Posición personalizada</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="358"/>
        <source>Custom Size</source>
        <translation>Tamaño personalizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.cpp" line="133"/>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable formats from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the Story Editor.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.cpp" line="137"/>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, and posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="41"/>
        <source>Insert one or more text frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="51"/>
        <source>Insert one or more image frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="93"/>
        <source>Place the new frames on the current page, on all pages or on a selected range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="102"/>
        <source>Insert the frame on the current page only</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="112"/>
        <source>Insert one frame for each existing page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="122"/>
        <source>Insert frames on a range of pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="134"/>
        <source>Range of pages to insert frames on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="169"/>
        <source>Position the new frame in relation to the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="178"/>
        <source>Insert the frame at the top left of the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="188"/>
        <source>Insert the frame at the top left of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="198"/>
        <source>Insert the frame at the top left of the page bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="208"/>
        <source>Insert the frame at a custom position on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="252"/>
        <source>Top position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="259"/>
        <source>Left position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="315"/>
        <source>Insert the new frame with the same dimensions as the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="325"/>
        <source>Insert the new frame with the same dimensions as the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="335"/>
        <source>Insert the new frame with the same dimensions as the bleed area outside the boundary of the page itself</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="345"/>
        <source>Insert the new frame with the same dimensions as the image that will be imported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="355"/>
        <source>Insert the new frame with a custom size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="399"/>
        <source>Width of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="406"/>
        <source>Height of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="464"/>
        <source>Number of columns for the inserted text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="481"/>
        <source>Distance between the columns in the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="512"/>
        <source>Link the inserted text frames together to form a chain of frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="515"/>
        <source>Link Inserted Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="524"/>
        <source>Link the first inserted frame to a preexisting text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="527"/>
        <source>Link to Existing Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="543"/>
        <source>Name of existing text frame to link to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="561"/>
        <source>Source document to load into the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="603"/>
        <source>Source image to load into the inserted image frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsertTable</name>
    <message>
        <location filename="../../../scribus/insertTable.cpp" line="15"/>
        <source>Insert Table</source>
        <translation>Insertar tabla</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertTable.cpp" line="28"/>
        <source>Number of rows:</source>
        <translation>Número de filas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertTable.cpp" line="29"/>
        <source>Number of columns:</source>
        <translation>Número de columnas:</translation>
    </message>
</context>
<context>
    <name>JavaDocs</name>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="29"/>
        <source>Edit JavaScripts</source>
        <translation>Editar JavaScripts</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="48"/>
        <source>&amp;Edit...</source>
        <translation>&amp;Editar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="51"/>
        <source>&amp;Add...</source>
        <translation>&amp;Añadir...</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="54"/>
        <source>&amp;Delete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="59"/>
        <source>&amp;Close</source>
        <translation>&amp;Cerrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="80"/>
        <source>&amp;New Script:</source>
        <translation>&amp;Nuevo Script:</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="80"/>
        <location filename="../../../scribus/javadocs.cpp" line="81"/>
        <source>New Script</source>
        <translation>Nuevo Script</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="123"/>
        <source>Do you really want to delete this script?</source>
        <translation>¿Realmente quieres eliminar este script?</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="74"/>
        <source>Adds a new Script, predefines a function with the same name. If you want to use this script as an &quot;Open Action&quot; script be sure not to change the name of the function.</source>
        <translation type="unfinished">Añade un nuevo script, predefine una función con el mismo nombre. Si quieres usar este script como un script &quot;Acción abierta&quot; asegúrate de no cambiar el nombre de la función.</translation>
    </message>
</context>
<context>
    <name>LatexEditor</name>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="33"/>
        <source>Enter Code:</source>
        <translation>Introduzca código:</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="45"/>
        <source>Update</source>
        <translation>Actualizar</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="52"/>
        <source>Revert</source>
        <translation>Revertir</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="123"/>
        <source>Program Messages:</source>
        <translation>Mensajes del programa:</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="174"/>
        <source>Status: Unknown</source>
        <translation>Estado: Desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="158"/>
        <source>Kill Program</source>
        <translation>Matar programa</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="66"/>
        <source>Options</source>
        <translation>Opciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="74"/>
        <source>Resolution:</source>
        <translation>Resolución:</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="81"/>
        <source>Automatic</source>
        <translation>Automatica</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="84"/>
        <source> DPI</source>
        <translation> DPI</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="97"/>
        <source>Program:</source>
        <translation>Programa:</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="109"/>
        <source>Use Preamble</source>
        <translation>Usar preámbulo</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="338"/>
        <source>Status: </source>
        <translation>Estado: </translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="165"/>
        <location filename="../../../scribus/latexeditor.cpp" line="206"/>
        <location filename="../../../scribus/latexeditor.cpp" line="223"/>
        <location filename="../../../scribus/latexeditor.cpp" line="342"/>
        <source>Error</source>
        <translation>Error</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="344"/>
        <source>Finished</source>
        <translation>Terminado</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="347"/>
        <source>Running</source>
        <translation>Ejecutando</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="528"/>
        <source>No item selected!</source>
        <translation>¡Ningún elemento seleccionado!</translation>
    </message>
    <message>
        <source>Insert symbol</source>
        <translation type="obsolete">Insertar símbolo</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="14"/>
        <source>Editor</source>
        <translation>Editor</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="122"/>
        <location filename="../../../scribus/latexeditor.cpp" line="130"/>
        <source>Information</source>
        <translation type="unfinished">Información</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="123"/>
        <source>An editor for this frame is already running!</source>
        <translation type="unfinished">¡Ya se está ejecutando un editor para este marco!</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="150"/>
        <source>Editor running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="131"/>
        <source>Please specify an editor in the preferences!</source>
        <translation type="unfinished">¡Por favor, especifique un editor en las preferencias!</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="166"/>
        <source>Could not create a temporary file to run the external editor!</source>
        <translation type="unfinished">¡No se pudo crear un archivo temporal para ejecutar el editor externo!</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="148"/>
        <location filename="../../../scribus/latexeditor.cpp" line="202"/>
        <location filename="../../../scribus/latexeditor.cpp" line="222"/>
        <source>Run External Editor...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="207"/>
        <source>Running the editor failed with exitcode %d!</source>
        <translation type="unfinished">¡La ejecución del editor falló con el código de salida %d!</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="224"/>
        <source>Running the editor &quot;%1&quot; failed!</source>
        <translation type="unfinished">¡Fallo al ejecutar el editor &quot;%1&quot;!</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="529"/>
        <source>Insert Symbol</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LayerPalette</name>
    <message>
        <location filename="../../../scribus/layers.cpp" line="600"/>
        <source>Layers</source>
        <translation>Capas</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="296"/>
        <location filename="../../../scribus/layers.cpp" line="631"/>
        <source>Delete Layer</source>
        <translation>Borrar Capa</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="297"/>
        <source>Do you want to delete all objects on this layer too?</source>
        <translation>¿Quieres eliminar también todos los objetos de esta capa?</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="72"/>
        <location filename="../../../scribus/layers.cpp" line="621"/>
        <source>Name</source>
        <translation>Nombre</translation>
    </message>
    <message>
        <source>Add a new layer</source>
        <translation type="obsolete">Añadir capa nueva</translation>
    </message>
    <message>
        <source>Delete layer</source>
        <translation type="obsolete">Eliminar capa</translation>
    </message>
    <message>
        <source>Raise layer</source>
        <translation type="obsolete">Subir capa</translation>
    </message>
    <message>
        <source>Lower layer</source>
        <translation type="obsolete">Bajar capa</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="54"/>
        <location filename="../../../scribus/layers.cpp" line="619"/>
        <source>Opacity:</source>
        <translation>Opacidad:</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="60"/>
        <location filename="../../../scribus/layers.cpp" line="620"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="601"/>
        <source>Blend Mode:</source>
        <translation>Modo de fusión:</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="603"/>
        <source>Normal</source>
        <translation>Normal</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="604"/>
        <source>Darken</source>
        <translation>Oscurecer</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="605"/>
        <source>Lighten</source>
        <translation>Aclarar</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="606"/>
        <source>Multiply</source>
        <translation>Multiplicar</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="607"/>
        <source>Screen</source>
        <translation>Trama</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="608"/>
        <source>Overlay</source>
        <translation>Superponer</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="609"/>
        <source>Hard Light</source>
        <translation>Luz dura</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="610"/>
        <source>Soft Light</source>
        <translation>Luz suave</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="611"/>
        <source>Difference</source>
        <translation>Diferencia</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="613"/>
        <source>Color Dodge</source>
        <translation>Sobreexponer color</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="614"/>
        <source>Color Burn</source>
        <translation>Subexponer color</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="612"/>
        <source>Exclusion</source>
        <translation>Exclusión</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="615"/>
        <source>Hue</source>
        <translation>Tono</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="616"/>
        <source>Saturation</source>
        <translation>Saturación</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="617"/>
        <source>Color</source>
        <translation>Color</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="618"/>
        <source>Luminosity</source>
        <translation>Luminosidad</translation>
    </message>
    <message>
        <source>Duplicates the current layer</source>
        <translation type="obsolete">Duplica la capa actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="636"/>
        <source>Color of the Layer Indicator - Each layer has a color assigned to display on the canvas when layer indicators are enabled. You can double click to edit the color. </source>
        <translation>Color del indicador de capa - Cada capa tiene un color asignado para mostrar en el lienzo cuando los indicadores de capa están activados. Puedes hacer doble clic para editar el color. </translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="637"/>
        <source>Make Layer Visible - Uncheck to hide the layer from the display </source>
        <translation>Hacer capa visible - Desmarcar para ocultar la capa de la pantalla </translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="638"/>
        <source>Print Layer - Uncheck to disable printing. </source>
        <translation>Imprimir capa - Desmarcar para evitar impresión. </translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="639"/>
        <source>Lock or Unlock Layer - Unchecked is unlocked </source>
        <translation>Bloquear o Desbloquear capa - Desmarcado es desbloqueado </translation>
    </message>
    <message>
        <source>Text flows around objects in lower Layers - Enabling this forces text frames to flow around other objects, even in layers below</source>
        <translation type="obsolete">El texto fluye alrededor de los objetos en capas inferiores - Activando esto fuera a los marcos de texto a fluir alrededor de otros objetos, incluso en capas inferiores</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="641"/>
        <source>Outline Mode - Toggles the &apos;wireframe&apos; display of objects to speed the display of very complex objects.</source>
        <translation type="unfinished">Modo de contorno - Des/activa la &apos;malla&apos; de pantalla de los objetos para acelerar el visionado de objetos muy complejos.</translation>
    </message>
    <message>
        <source>Name of the Layer - Double clicking on the name of a layer enabled editing</source>
        <translation type="obsolete">Nombre de la capa - Hacer doble clic en el nombre de una capa activa la edición</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="634"/>
        <source>Selects the Blendmode, works only in PDF 1.4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="635"/>
        <source>Layer Transparency, works only in PDF 1.4 and SVG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="629"/>
        <source>Add a New Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="630"/>
        <source>Duplicate the Current Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="632"/>
        <source>Raise Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="633"/>
        <source>Lower Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="640"/>
        <source>Make text in lower layers flow around objects - Enabling this forces text in lower layers to flow around objects of the layer for which this option has been enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="642"/>
        <source>Name of the Layer - Double click on the name of a layer to edit the name</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LegacyMode</name>
    <message>
        <source>All Files (*)</source>
        <translation type="obsolete">Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_legacy.cpp" line="4997"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_legacy.cpp" line="4967"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Todos los formatos soportados</translation>
    </message>
</context>
<context>
    <name>LensDialogBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="13"/>
        <source>Optical Lens</source>
        <translation>Lentes ópticas</translation>
    </message>
    <message>
        <source>Add Lens</source>
        <translation type="obsolete">Añadir lentes</translation>
    </message>
    <message>
        <source>Remove Lens</source>
        <translation type="obsolete">Eliminar lentes</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="98"/>
        <source>+</source>
        <translation>+</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="108"/>
        <source>-</source>
        <translation>-</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="126"/>
        <source>Lens Parameters</source>
        <translation>Parametros de lentes</translation>
    </message>
    <message>
        <source>X Pos:</source>
        <translation type="obsolete">Pos X:</translation>
    </message>
    <message>
        <source>Y Pos:</source>
        <translation type="obsolete">Pos Y:</translation>
    </message>
    <message>
        <source>Radius:</source>
        <translation type="obsolete">Radio:</translation>
    </message>
    <message>
        <source>Strength:</source>
        <translation type="obsolete">Fuerza:</translation>
    </message>
    <message>
        <source>Magnification Lens</source>
        <translation type="obsolete">Lupa</translation>
    </message>
    <message>
        <source>Fish Eye Lens</source>
        <translation type="obsolete">Ojo de buey</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="55"/>
        <source>Add a new lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="58"/>
        <source>&amp;Add Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="65"/>
        <source>Remove selected lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="68"/>
        <source>&amp;Remove Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="95"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="105"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="138"/>
        <source>&amp;X Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="148"/>
        <source>Horizontal position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="161"/>
        <source>&amp;Y Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="171"/>
        <source>Vertical position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="184"/>
        <source>The selected lens acts like a magnification lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="187"/>
        <source>&amp;Magnification Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="197"/>
        <source>The selected lens acts like a fish eye lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="200"/>
        <source>&amp;Fish Eye Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="207"/>
        <source>Ra&amp;dius:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="217"/>
        <source>Radius of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="230"/>
        <source>&amp;Strength:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="240"/>
        <source>Strength of the lens</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LensEffectsPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="66"/>
        <source>Lens Effects...</source>
        <translation>Efectos de lente...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="70"/>
        <source>Path Tools</source>
        <translation>Herramientas de trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="90"/>
        <source>Lens Effects</source>
        <translation>Efectos de lentes</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="91"/>
        <source>Apply fancy lens effects</source>
        <translation type="unfinished">Aplicar efectos de lente de fantasía</translation>
    </message>
</context>
<context>
    <name>LoadSavePlugin</name>
    <message>
        <location filename="../../../scribus/loadsaveplugin.cpp" line="81"/>
        <source>All Files (*)</source>
        <translation>Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/loadsaveplugin.cpp" line="93"/>
        <source>An error occured while opening file or file is damaged</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loadsaveplugin.cpp" line="98"/>
        <source>An error occured while parsing file at line %1, column %2 :
%3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loadsaveplugin.cpp" line="80"/>
        <source>No File Loader Plugins Found</source>
        <translation type="unfinished">Ninguna extensión de cargadores de archivos encontrada</translation>
    </message>
</context>
<context>
    <name>LoremManager</name>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="152"/>
        <source>Select Lorem Ipsum</source>
        <translation>Seleccionar Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="220"/>
        <source>Author:</source>
        <translation>Autor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="222"/>
        <source>Get More:</source>
        <translation>Obtener más:</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="224"/>
        <source>XML File:</source>
        <translation>Archivo XML:</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="139"/>
        <location filename="../../../scribus/loremipsum.cpp" line="264"/>
        <source>Lorem Ipsum</source>
        <translation>Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="265"/>
        <source>Paragraphs:</source>
        <translation>Párrafos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="268"/>
        <source>Alt+O</source>
        <translation>Alt+O</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="270"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="271"/>
        <source>Standard Lorem Ipsum</source>
        <translation>Estándar Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="266"/>
        <source>Random Paragraphs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="272"/>
        <source>Number of paragraphs of selected sample text to insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="273"/>
        <source>List of languages available to insert sample text in</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginDialog</name>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="31"/>
        <source>Manage Page Properties</source>
        <translation>Manejar propiedades de página</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="39"/>
        <source>Page Size</source>
        <translation>Tamaño de página</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="44"/>
        <source>&amp;Size:</source>
        <translation>&amp;Tamaño:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="60"/>
        <source>Orie&amp;ntation:</source>
        <translation>&amp;Orientación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="63"/>
        <source>Portrait</source>
        <translation>Vertical</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="64"/>
        <source>Landscape</source>
        <translation>Apaisado</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="71"/>
        <source>&amp;Width:</source>
        <translation>Anc&amp;hura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="78"/>
        <source>&amp;Height:</source>
        <translation>Al&amp;tura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="83"/>
        <source>Move Objects with their Page</source>
        <translation>Mover objetos con su página</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="89"/>
        <source>Type:</source>
        <translation>Tipo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="109"/>
        <source>Margin Guides</source>
        <translation>Guías de los márgenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="116"/>
        <source>Other Settings</source>
        <translation>Otras configuraciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="121"/>
        <source>Master Page:</source>
        <translation>Página maestra:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="175"/>
        <source>Size of the inserted pages, either a standard or custom size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="176"/>
        <source>Orientation of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="177"/>
        <source>Width of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="178"/>
        <source>Height of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="179"/>
        <source>When inserting a new page between others, move objects with their current pages. This is the default action.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginWidget</name>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="42"/>
        <source>&amp;Bottom:</source>
        <translation>I&amp;nferior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="44"/>
        <source>&amp;Top:</source>
        <translation>&amp;Superior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="46"/>
        <location filename="../../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Right:</source>
        <translation>De&amp;recho:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="48"/>
        <location filename="../../../scribus/marginwidget.cpp" line="210"/>
        <source>&amp;Left:</source>
        <translation>I&amp;zquierdo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="155"/>
        <source>Distance between the top margin guide and the edge of the page</source>
        <translation>Distancia entre la guía del margen superior y el borde de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="156"/>
        <source>Distance between the bottom margin guide and the edge of the page</source>
        <translation>Distancia entre la guía del margen inferior y el borde de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="210"/>
        <source>&amp;Inside:</source>
        <translation>&amp;Interior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="211"/>
        <source>O&amp;utside:</source>
        <translation>&amp;Exterior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="32"/>
        <source>Preset Layouts:</source>
        <translation type="unfinished">Esquema prefijado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="89"/>
        <source>Apply the margin changes to all existing pages in the document</source>
        <translation>Aplicar los cambios de márgenes a todas las páginas existentes en el documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="101"/>
        <source>Printer Margins...</source>
        <translation>Márgenes de impresora...</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="103"/>
        <source>Import the margins for the selected page size from the available printers.</source>
        <translation>Importa los márgenes para el tamaño de página seleccionado desde las impresoras disponibles.</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="78"/>
        <source>Apply settings to:</source>
        <translation>Aplicar configuración a:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="81"/>
        <source>All Document Pages</source>
        <translation>Todas las páginas del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="85"/>
        <source>All Master Pages</source>
        <translation>Todas las páginas maestras</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="90"/>
        <source>Apply the margin changes to all existing master pages in the document</source>
        <translation>Aplicar los cambios de márgenes a todas las páginas maestras existentes en el documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="107"/>
        <source>Margin Guides</source>
        <translation>Guías de los márgenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="125"/>
        <source>Top:</source>
        <translation>Superior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="130"/>
        <source>Bottom:</source>
        <translation>Inferior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="142"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation>Distancia de la sangría desde el extremo superior de la página real</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="143"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation>Distancia de la sangría desde el extremo inferior de la página real</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="144"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation>Distancia de la sangría desde el extremo izquierdo de la página real</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="145"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation>Distancia de la sangría desde el extremo derecho de la página real</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="151"/>
        <source>Bleeds</source>
        <translation>Sangrías</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="216"/>
        <source>Inside:</source>
        <translation>Interior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="217"/>
        <source>Outside:</source>
        <translation>Exterior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="221"/>
        <source>Left:</source>
        <translation>Izquierda:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="222"/>
        <source>Right:</source>
        <translation>Derecha:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="157"/>
        <source>Distance between the left margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation>Distancia entre la guía del margen izquierdo y el borde de la página. Si se selecciona un esquema de página doble, tríptico, o 4 páginas, este espacio del margen puede ser usado para obtener los márgenes correctos para la encuadernación</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="158"/>
        <source>Distance between the right margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation>Distancia entre la guía del margen derecho y el borde de la página. Si se selecciona un esquema de página doble, tríptico, o 4 páginas, este espacio del margen puede ser usado para obtener los márgenes correctos para la encuadernación</translation>
    </message>
</context>
<context>
    <name>MasterPagesPalette</name>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="97"/>
        <source>Edit Master Pages</source>
        <translation>Editar páginas maestras</translation>
    </message>
    <message>
        <source>Do you really want to delete this master page?</source>
        <translation type="obsolete">¿Realmente quieres eliminar esta página maestra?</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="177"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="177"/>
        <source>New Master Page</source>
        <translation>Nueva página maestra</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="303"/>
        <source>Name:</source>
        <translation>Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="303"/>
        <source>New MasterPage</source>
        <translation>Nueva página maestra</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="369"/>
        <source>Copy #%1 of </source>
        <translation>Copia #%1 de </translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="98"/>
        <source>Duplicate the selected master page</source>
        <translation>Duplicar la página maestra seleccionada</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="99"/>
        <source>Delete the selected master page</source>
        <translation>Eliminar la página maestra seleccionada</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="100"/>
        <source>Add a new master page</source>
        <translation>Añadir una nueva página maestra</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="101"/>
        <source>Import master pages from another document</source>
        <translation>Importar páginas maestras de otro documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="303"/>
        <source>New Master Page %1</source>
        <translation>Nueva página maestra %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="449"/>
        <source>Unable to Rename Master Page</source>
        <translation>Imposible renombrar página maestra</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="449"/>
        <source>The Normal page is not allowed to be renamed.</source>
        <translation>No esta permitido renombrar la página Normal.</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="453"/>
        <source>Rename Master Page</source>
        <translation>Renombrar página maestra</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="453"/>
        <source>New Name:</source>
        <translation>Nuevo nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="175"/>
        <source>Copy #%1 of %2</source>
        <translation>Copia #%1 de %2</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="139"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="143"/>
        <source>Do you really want to delete master page &quot;%1&quot;?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Measurements</name>
    <message>
        <source>Distances</source>
        <translation type="obsolete">Distancias</translation>
    </message>
    <message>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <source>DX:</source>
        <translation type="obsolete">DX:</translation>
    </message>
    <message>
        <source>DY:</source>
        <translation type="obsolete">DY:</translation>
    </message>
    <message>
        <source>Angle:</source>
        <translation type="obsolete">Ángulo:</translation>
    </message>
    <message>
        <source>Length:</source>
        <translation type="obsolete">Longitud:</translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/measurements.cpp" line="50"/>
        <source> °</source>
        <translation> º</translation>
    </message>
</context>
<context>
    <name>MeasurementsBase</name>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="13"/>
        <source>Distances</source>
        <translation type="unfinished">Distancias</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="19"/>
        <source>X1:</source>
        <translation type="unfinished">X1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="26"/>
        <location filename="../../../scribus/measurementsbase.ui" line="43"/>
        <location filename="../../../scribus/measurementsbase.ui" line="60"/>
        <location filename="../../../scribus/measurementsbase.ui" line="77"/>
        <location filename="../../../scribus/measurementsbase.ui" line="94"/>
        <location filename="../../../scribus/measurementsbase.ui" line="111"/>
        <location filename="../../../scribus/measurementsbase.ui" line="128"/>
        <location filename="../../../scribus/measurementsbase.ui" line="145"/>
        <source>10000.0000</source>
        <translation type="unfinished">10000.0000</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="36"/>
        <source>Y1:</source>
        <translation type="unfinished">Y1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="53"/>
        <source>X2:</source>
        <translation type="unfinished">X2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="70"/>
        <source>Y2:</source>
        <translation type="unfinished">Y2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="87"/>
        <source>Length:</source>
        <translation type="unfinished">Longitud:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="104"/>
        <source>DX:</source>
        <translation type="unfinished">DX:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="121"/>
        <source>DY:</source>
        <translation type="unfinished">DY:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="138"/>
        <source>Angle:</source>
        <translation type="unfinished">Ángulo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="155"/>
        <source>Unit:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MergeDoc</name>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Page(s)</source>
        <translation>Importar página/s</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="75"/>
        <source> from 0</source>
        <translation> de 0</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="78"/>
        <source>Create Page(s)</source>
        <translation>Crear página/s</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="135"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="135"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation>Documentos (*.sla *.sla.gz *.scd *.scd.gz);; Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="171"/>
        <location filename="../../../scribus/mergedoc.cpp" line="190"/>
        <source> from %1</source>
        <translation> de %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Master Page</source>
        <translation>Importar página maestra</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="48"/>
        <source>&amp;From Document:</source>
        <translation>&amp;Desde documento:</translation>
    </message>
    <message>
        <source>Chan&amp;ge...</source>
        <translation type="obsolete">Cam&amp;biar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="55"/>
        <source>&amp;Import Page(s):</source>
        <translation>&amp;Importar página/s:</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="59"/>
        <source>&amp;Import Master Page</source>
        <translation>&amp;Importar página maestra</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="70"/>
        <source>Insert a comma separated list of tokens import where a token can be * for all the pages, 1-5 for a range of pages or a single page number.</source>
        <translation type="unfinished">Inserta una lista de elementos separadas por comas donde un elemento puede ser * para todas las páginas, 1-5 para un rango de páginas o sólo un número de página.</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="82"/>
        <source>Before Page</source>
        <translation>Antes de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="83"/>
        <source>After Page</source>
        <translation>Después de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="84"/>
        <source>At End</source>
        <translation>Al final</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="101"/>
        <source>&amp;Import</source>
        <translation>&amp;Importar</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="52"/>
        <source>&amp;Select...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeshDistortionDialog</name>
    <message>
        <source>Dialog</source>
        <translation type="obsolete">Diálogo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="44"/>
        <source>+</source>
        <translation type="unfinished">+</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="54"/>
        <source>-</source>
        <translation type="unfinished">-</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="13"/>
        <source>Mesh Distortion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="27"/>
        <source>Drag the red handles with the mouse to distort the mesh</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="41"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="51"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="82"/>
        <source>Resets the selected handles to their initial position.
If no handle is selected all handles will be reset.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="86"/>
        <source>&amp;Reset</source>
        <translation type="unfinished">&amp;Reiniciar</translation>
    </message>
</context>
<context>
    <name>MeshDistortionPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="69"/>
        <source>Mesh Distortion...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished">Herramientas de trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="94"/>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="95"/>
        <source>Mesh Distortion of Polygons</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MissingFont</name>
    <message>
        <location filename="../../../scribus/missing.cpp" line="309"/>
        <source>Missing Font</source>
        <translation>Tipografía ausente</translation>
    </message>
    <message>
        <location filename="../../../scribus/missing.cpp" line="317"/>
        <source>The Font %1 is not installed.</source>
        <translation>La tipografía %1 no está instalada.</translation>
    </message>
    <message>
        <location filename="../../../scribus/missing.cpp" line="322"/>
        <source>Use</source>
        <translation>Usar</translation>
    </message>
    <message>
        <location filename="../../../scribus/missing.cpp" line="331"/>
        <source>instead</source>
        <translation>en su lugar</translation>
    </message>
</context>
<context>
    <name>ModeToolBar</name>
    <message>
        <location filename="../../../scribus/ui/modetoolbar.cpp" line="39"/>
        <source>Tools</source>
        <translation>Herramientas</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/modetoolbar.cpp" line="124"/>
        <source>Properties...</source>
        <translation>Propiedades...</translation>
    </message>
</context>
<context>
    <name>MovePages</name>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="28"/>
        <source>Move Pages</source>
        <translation>Mover páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="28"/>
        <location filename="../../../scribus/movepage.cpp" line="37"/>
        <source>Copy Page</source>
        <translation>Copiar página</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="78"/>
        <source>Move Page(s):</source>
        <translation>Mover página(s):</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="37"/>
        <source>Move Page(s)</source>
        <translation>Mover página/s</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="68"/>
        <source>Before Page</source>
        <translation>Antes de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="69"/>
        <source>After Page</source>
        <translation>Después de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="70"/>
        <source>At End</source>
        <translation>Al final</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="48"/>
        <source>To:</source>
        <translation>Hasta:</translation>
    </message>
    <message>
        <source>Number of copies:</source>
        <translation type="obsolete">Número de copias:</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="58"/>
        <source>Number of Copies:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultiProgressDialog</name>
    <message>
        <location filename="../../../scribus/multiprogressdialog.ui" line="13"/>
        <source>Progress</source>
        <translation>Progreso</translation>
    </message>
    <message>
        <location filename="../../../scribus/multiprogressdialog.ui" line="24"/>
        <source>Overall Progress:</source>
        <translation>Progreso general:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multiprogressdialog.ui" line="67"/>
        <source>&amp;Cancel</source>
        <translation>&amp;Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/multiprogressdialog.cpp" line="74"/>
        <source>%v of %m</source>
        <translation>%v de %m</translation>
    </message>
</context>
<context>
    <name>MultipleDuplicate</name>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="112"/>
        <location filename="../../../scribus/multipleduplicate.cpp" line="63"/>
        <source>&amp;Horizontal Shift:</source>
        <translation>Desplazamiento &amp;horizontal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="165"/>
        <location filename="../../../scribus/multipleduplicate.cpp" line="64"/>
        <source>&amp;Vertical Shift:</source>
        <translation>Desplazamiento &amp;vertical:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.cpp" line="69"/>
        <source>&amp;Horizontal Gap:</source>
        <translation>Espaciado &amp;horizontal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.cpp" line="70"/>
        <source>&amp;Vertical Gap:</source>
        <translation>Espaciado &amp;vertical:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="13"/>
        <source>Multiple Duplicate</source>
        <translation>Duplicación múltiple</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="32"/>
        <source>&amp;By Number of Copies</source>
        <translation>Por número de co&amp;pias</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="50"/>
        <source>&amp;Number of Copies:</source>
        <translation>&amp;Número de copias:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="91"/>
        <source>&amp;Shift Created Items By</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="94"/>
        <source>Alt+S</source>
        <translation>Alt+S</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="81"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation>Crear es&amp;paciado entre objetos de</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="84"/>
        <source>Alt+G</source>
        <translation>Alt+G</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="145"/>
        <source>Rotation:</source>
        <translation>Rotación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="217"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation>Por &amp;filas y columnas</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="245"/>
        <source>Vertical Gap:</source>
        <translation>Espaciado vertical:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="272"/>
        <source>Horizontal Gap:</source>
        <translation>Espaciado horizontal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="289"/>
        <source>Number of Rows:</source>
        <translation>Número de filas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="309"/>
        <source>Number of Columns:</source>
        <translation>Número de columnas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="383"/>
        <source>&amp;OK</source>
        <translation>&amp;Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="399"/>
        <source>&amp;Cancel</source>
        <translation>&amp;Cancelar</translation>
    </message>
</context>
<context>
    <name>MyPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/myplugin/myplugin.cpp" line="31"/>
        <source>My &amp;Plugin</source>
        <translation>Mi &amp;extensión</translation>
    </message>
</context>
<context>
    <name>MyPluginImpl</name>
    <message>
        <location filename="../../../scribus/plugins/myplugin/mypluginimpl.cpp" line="23"/>
        <source>Scribus - My Plugin</source>
        <translation>Scribus - Mi extensión</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/myplugin/mypluginimpl.cpp" line="24"/>
        <source>The plugin worked!</source>
        <translation>¡La extensión funcionó!</translation>
    </message>
</context>
<context>
    <name>NewDoc</name>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="100"/>
        <source>New Document</source>
        <translation>Nuevo documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="224"/>
        <source>&amp;Size:</source>
        <translation>&amp;Tamaño:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="233"/>
        <source>Orie&amp;ntation:</source>
        <translation>&amp;Orientación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="236"/>
        <source>Portrait</source>
        <translation>Vertical</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="237"/>
        <source>Landscape</source>
        <translation>Apaisado</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="243"/>
        <source>&amp;Width:</source>
        <translation>Anc&amp;hura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="249"/>
        <source>&amp;Height:</source>
        <translation>Al&amp;tura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="265"/>
        <source>Margin Guides</source>
        <translation>Guías de los márgenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="284"/>
        <source>Options</source>
        <translation>Opciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="297"/>
        <source>&amp;Default Unit:</source>
        <translation>&amp;Unidad por defecto:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="307"/>
        <source>&amp;Automatic Text Frames</source>
        <translation>Marcos de te&amp;xto automáticos</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="317"/>
        <source>&amp;Gap:</source>
        <translation>Es&amp;paciado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="309"/>
        <source>Colu&amp;mns:</source>
        <translation>Colu&amp;mnas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="143"/>
        <source>Document page size, either a standard size or a custom size</source>
        <translation>Tamaño de página del documento, elige un tamaño estándar o uno personalizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="144"/>
        <source>Orientation of the document&apos;s pages</source>
        <translation>Orientación de las páginas del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="145"/>
        <source>Width of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Anchura de las páginas, editable si se elige un tamaño de página personalizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="146"/>
        <source>Height of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Altura de las páginas, editable si se elige un tamaño de página personalizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="148"/>
        <source>Default unit of measurement for document editing</source>
        <translation>Unidad de medida por defecto para edición de documentos</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="149"/>
        <source>Create text frames automatically when new pages are added</source>
        <translation>Crear marcos de texto automáticamente cuando se añaden nuevas páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="150"/>
        <source>Number of columns to create in automatically created text frames</source>
        <translation>Número de columnas de los marcos de texto creados automáticamente</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="151"/>
        <source>Distance between automatically created columns</source>
        <translation>Distancia entre columnas de los marcos de texto creados automáticamente</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="129"/>
        <source>Do not show this dialog again</source>
        <translation>No mostrar este diálogo otra vez</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="147"/>
        <source>Initial number of pages of the document</source>
        <translation>Número inicial de páginas del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="291"/>
        <source>N&amp;umber of Pages:</source>
        <translation>Nú&amp;mero de páginas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="365"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="110"/>
        <source>&amp;New Document</source>
        <translation>&amp;Nuevo documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="115"/>
        <source>Open &amp;Existing Document</source>
        <translation>Abrir documento &amp;existente</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="118"/>
        <source>Open Recent &amp;Document</source>
        <translation>Abrir &amp;documento reciente</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="256"/>
        <source>First Page is:</source>
        <translation>La primera página es:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="329"/>
        <source>Show Document Settings After Creation</source>
        <translation>Mostrar configuración del documento tras su creación</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="181"/>
        <source>Document Layout</source>
        <translation>Disposición del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="113"/>
        <source>New &amp;from Template</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewFromTemplatePlugin</name>
    <message>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="59"/>
        <source>New &amp;from Template...</source>
        <translation>Nuevo &amp;desde Plantilla...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="79"/>
        <source>Load documents with predefined layout</source>
        <translation>Cargar documentos con la disposición predefinida</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="80"/>
        <source>Start a document from a template made by other users or yourself (f.e. for documents you have a constant style).</source>
        <translation>Crear un documento desde una plantilla hecha por otro usuario o por ti mismo (p.ej. para documentos que tengan un estilo constante).</translation>
    </message>
</context>
<context>
    <name>NodePalette</name>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="903"/>
        <source>Nodes</source>
        <translation>Nodos</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="906"/>
        <source>&amp;Absolute Coordinates</source>
        <translation>Coordenadas &amp;absolutas</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="909"/>
        <source>&amp;X-Pos:</source>
        <translation>Posición &amp;X:</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="910"/>
        <source>&amp;Y-Pos:</source>
        <translation>Posicón &amp;Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="911"/>
        <source>Edit &amp;Contour Line</source>
        <translation>Editar &amp;contorno</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="912"/>
        <source>&amp;Reset Contour Line</source>
        <translation>&amp;Reiniciar línea de control</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="915"/>
        <source>&amp;End Editing</source>
        <translation>&amp;Fin de edición</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="916"/>
        <source>Move Nodes</source>
        <translation>Mover nodos</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="917"/>
        <source>Move Control Points</source>
        <translation>Mover puntos de control</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="918"/>
        <source>Add Nodes</source>
        <translation>Añadir nodos</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="919"/>
        <source>Delete Nodes</source>
        <translation>Borrar nodos</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="920"/>
        <source>Move Control Points Independently</source>
        <translation>Mover puntos de control independientemente</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="921"/>
        <source>Move Control Points Symmetrical</source>
        <translation>Mover puntos de control simétricamente</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="922"/>
        <source>Reset Control Points</source>
        <translation>Reiniciar puntos de control</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="923"/>
        <source>Reset this Control Point</source>
        <translation>Reinicia este punto de control</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="924"/>
        <source>Open a Polygon or Cuts a Bezier Curve</source>
        <translation>Abrir un polígono o cortar una curva Bézier</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="925"/>
        <source>Close this Bezier Curve</source>
        <translation>Cierra esta curva de Bézier</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="926"/>
        <source>Mirror the Path Horizontally</source>
        <translation>Voltear horizontalmente</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="927"/>
        <source>Mirror the Path Vertically</source>
        <translation>Voltear verticalmente</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="928"/>
        <source>Shear the Path Horizontally to the Right</source>
        <translation>Cizallar horizontalmente a la derecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="929"/>
        <source>Shear the Path Horizontally to the Left</source>
        <translation>Cizallar horizontalmente a la izquierda</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="930"/>
        <source>Shear the Path Vertically Up</source>
        <translation>Cizallar verticalmente hacia arriba</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="931"/>
        <source>Shear the Path Vertically Down</source>
        <translation>Cizallar verticalmente hacia abajo</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="932"/>
        <source>Rotate the Path Counter-Clockwise</source>
        <translation>Rotar en el sentido antihorario</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="933"/>
        <source>Rotate the Path Clockwise</source>
        <translation>Rotar en el sentido horario</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="935"/>
        <source>Enlarge the Size of the Path by shown %</source>
        <translation>Agrandar el tamaño en el porcentaje mostrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="938"/>
        <source>Angle of Rotation</source>
        <translation>Ángulo de rotación</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="941"/>
        <source>Activate Contour Line Editing Mode</source>
        <translation>Activar el modo de edición del contorno</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="942"/>
        <source>Reset the Contour Line to the Original Shape of the Frame</source>
        <translation>Reiniciar el contorno a la forma original del marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="904"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="945"/>
        <source>When checked use coordinates relative to the page, otherwise coordinates are relative to the Object.</source>
        <translation>Cuando está marcado, usa las coordenadas relativas a la página, en otro caso, las coordinadas son relativas al objeto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="934"/>
        <source>Shrink the Size of the Path by shown %</source>
        <translation>Reducir el tamaño del trazado por el % mostrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="936"/>
        <source>Reduce the Size of the Path by the shown value</source>
        <translation>Reduce el tamaño del trazado por el valor mostrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="937"/>
        <source>Enlarge the Size of the Path by the shown value</source>
        <translation>Aumenta el tamaño del trazado por el valor mostrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="939"/>
        <source>% to Enlarge or Shrink By</source>
        <translation>% a reducir o aumentar</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="940"/>
        <source>Value to Enlarge or Shrink By</source>
        <translation>Valor para reducir o ampliar</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="913"/>
        <source>Set Contour to Image Clip</source>
        <translation>Aplicar contorno a clip de imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="943"/>
        <source>Reset the Contour Line to the Clipping Path of the Image</source>
        <translation>Reiniciar la línea de contorno al trazado de recorte de la imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="241"/>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="907"/>
        <source>to Canvas</source>
        <translation>al lienzo</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="243"/>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="908"/>
        <source>to Page</source>
        <translation>a la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="914"/>
        <source>Set Shape to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="944"/>
        <source>Set the Shape to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OODPlug</name>
    <message>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="299"/>
        <source>This document does not seem to be an OpenOffice Draw file.</source>
        <translation>Este documento no parece ser un archivo OpenOffice Draw.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="467"/>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="617"/>
        <source>Group%1</source>
        <translation>Grupo%1</translation>
    </message>
</context>
<context>
    <name>OODrawImportPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="96"/>
        <source>Import &amp;OpenOffice.org Draw...</source>
        <translation>Importar &amp;OpenOffice.org Draw...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="111"/>
        <source>Imports OpenOffice.org Draw Files</source>
        <translation>Importa archivos OpenOffice.org Draw</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="112"/>
        <source>Imports most OpenOffice.org Draw files into the current document, converting their vector data into Scribus objects.</source>
        <translation>Importa la mayoría de archivos OpenOffice.org en el documento actual, convirtiendo los datos de vectores en objetos de Scribus.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="126"/>
        <source>OpenDocument 1.0 Draw</source>
        <comment>Import/export format name</comment>
        <translation>OpenDocument 1.0 Draw</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="138"/>
        <source>OpenOffice.org 1.x Draw</source>
        <comment>Import/export format name</comment>
        <translation>OpenOffice.org 1.x Draw</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="210"/>
        <source>This file contains some unsupported features</source>
        <translation>Este archivo contiene algunas características no soportadas</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="208"/>
        <source>The file could not be imported</source>
        <translation>El archivo no puede ser importado</translation>
    </message>
</context>
<context>
    <name>OdtDialog</name>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="70"/>
        <source>Use document name as a prefix for paragraph styles</source>
        <translation>Usa nombre del documento como un prefijo para los estilos de párrafo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="79"/>
        <source>Do not ask again</source>
        <translation>No preguntar de nuevo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="90"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="43"/>
        <source>OpenDocument Importer Options</source>
        <translation>Opciones de importación de OpenDocument</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="54"/>
        <source>Enabling this will overwrite existing styles in the current Scribus document</source>
        <translation>Activar esto sobreescribirá los estilos existentes en el documento actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="61"/>
        <source>Merge Paragraph Styles</source>
        <translation>Fusionar estilos de párrafo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="63"/>
        <source>Merge paragraph styles by attributes. This will result in fewer similar paragraph styles, will retain style attributes, even if the original document&apos;s styles are named differently.</source>
        <translation>Fusionar estilos de párrafo por atributos. Esto resultará en menos estilos de párrafo similares, retendrá los atributos de los estilos, incluso si los estilos del documento original se llamaban de forma diferente.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="72"/>
        <source>Prepend the document name to the paragraph style name in Scribus.</source>
        <translation>Anteponer el nombre del documento al estilo de párrafo de Scribus.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="81"/>
        <source>Make these settings the default and do not prompt again when importing an OASIS OpenDocument.</source>
        <translation>Establecer estas opciones por defecto y no preguntar de nuevo cuando se importe un OASIS OpenDocument.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="52"/>
        <source>Overwrite Paragraph Styles</source>
        <translation>Sobreescribir estilos de párrafo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="92"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
</context>
<context>
    <name>OldScribusFormat</name>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="59"/>
        <source>Scribus Document</source>
        <translation>Documento de Scribus</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="70"/>
        <source>Scribus 1.2.x Document</source>
        <translation>Documento de Scribus 1.2.x</translation>
    </message>
</context>
<context>
    <name>OneClick</name>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="37"/>
        <source>Origin</source>
        <translation>Origen</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="54"/>
        <source>Size</source>
        <translation>Tamaño</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="59"/>
        <source>Width:</source>
        <translation>Anchura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="61"/>
        <source>Length:</source>
        <translation>Longitud:</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="69"/>
        <source>Height:</source>
        <translation>Altura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="71"/>
        <source>Angle:</source>
        <translation>Ángulo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="101"/>
        <source>Remember Values</source>
        <translation>Recordar valores</translation>
    </message>
</context>
<context>
    <name>OutlinePalette</name>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="165"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="933"/>
        <source>Element</source>
        <translation>Elemento</translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="301"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation>El nombre &quot;%1&quot; no es único.&lt;br /&gt;Por favor, elige otro.</translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="711"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="761"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="816"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="901"/>
        <source>Group </source>
        <translation>Grupo </translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="776"/>
        <source>Page </source>
        <translation>Página </translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="831"/>
        <source>Free Objects</source>
        <translation type="unfinished">Liberar objetos</translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="932"/>
        <source>Outline</source>
        <translation>Contorno</translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="154"/>
        <source>Enter a keyword or regular expression to filter the outline.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="156"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="934"/>
        <source>Filter:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="155"/>
        <source>Ctrl+F</source>
        <comment>Filter the Outline using a keyword</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OutlineValues</name>
    <message>
        <location filename="../../../scribus/styleselect.cpp" line="97"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/styleselect.cpp" line="98"/>
        <source>Linewidth</source>
        <translation>Ancho de línea</translation>
    </message>
</context>
<context>
    <name>PDFExportDialog</name>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="60"/>
        <location filename="../../../scribus/pdfopts.cpp" line="158"/>
        <source>Save as PDF</source>
        <translation>Guardar como PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="66"/>
        <source>O&amp;utput to File:</source>
        <translation>&amp;Archivo de salida:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="100"/>
        <source>Cha&amp;nge...</source>
        <translation>Ca&amp;mbiar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="103"/>
        <source>Output one file for eac&amp;h page</source>
        <translation>Exportar un arc&amp;hivo por cada página</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="116"/>
        <source>&amp;Save</source>
        <translation>&amp;Guardar</translation>
    </message>
    <message>
        <source>Save as</source>
        <translation type="obsolete">Guardar como</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="210"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation>Archivos PDF (*.pdf);;Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="128"/>
        <source>This enables exporting one individually named PDF file for each page in the document. Page numbers are added automatically. This is most useful for imposing PDF for commercial printing.</source>
        <translation>Esto permite exportar un archivo PDF individual por cada página del documento. Los números de página se añaden automáticamente. Esto es principalmente útil para imposición de PDF para impresiones comerciales.</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="129"/>
        <source>The save button will be disabled if you are trying to export PDF/X and the info string is missing from the PDF/X tab.</source>
        <translation>El botón salvar será desactivado si intentas exportar PDF/X y la cadenada de información está vacía en la pestaña PDFX/X.</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="159"/>
        <source>%1 does not exists and will be created, continue?</source>
        <translation>%1 no existe y será creado, ¿continuar?</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="176"/>
        <source>Cannot create directory: 
%1</source>
        <translation>No se puede crear directorio: 
%1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="210"/>
        <source>Save As</source>
        <translation type="unfinished">Guardar como</translation>
    </message>
</context>
<context>
    <name>PDFLibCore</name>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="140"/>
        <source>Saving PDF</source>
        <translation>Guardando PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="144"/>
        <source>Exporting Master Page:</source>
        <translation>Exportando página maestra:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="144"/>
        <source>Exporting Page:</source>
        <translation>Exportando página:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="144"/>
        <source>Exporting Items on Current Page:</source>
        <translation>Exportando objetos de la página actual:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="2449"/>
        <source>Page:</source>
        <translation>Página:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="2462"/>
        <source>Date:</source>
        <translation>Fecha:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7718"/>
        <source>Failed to load an image : %1</source>
        <translation>Fallo al cargar una imagen: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7723"/>
        <source>Failed to write an image : %1</source>
        <translation>Fallo al escribir una imagen: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7728"/>
        <source>Failed to load an image mask : %1</source>
        <translation>Fallo al cargar una máscara de imagen: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7733"/>
        <source>Insufficient memory for processing an image</source>
        <translation>Memoria insuficiente para el procesado de una imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7713"/>
        <source>A write error occurred, please check available disk space</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PDFToolBar</name>
    <message>
        <location filename="../../../scribus/ui/pdftoolbar.cpp" line="29"/>
        <source>PDF Tools</source>
        <translation>Herramientas de PDF</translation>
    </message>
</context>
<context>
    <name>PPreview</name>
    <message>
        <location filename="../../../scribus/preview.cpp" line="84"/>
        <source>Print Preview</source>
        <translation>Vista previa de la impresión</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="136"/>
        <source>Display Trans&amp;parency</source>
        <translation>Mostrar trans&amp;parencia</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="280"/>
        <source>&amp;Under Color Removal</source>
        <translation>&amp;Eliminación de color subyacente</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="141"/>
        <source>&amp;Display CMYK</source>
        <translation>&amp;Mostrar CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="238"/>
        <source>&amp;C</source>
        <translation>&amp;C</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="243"/>
        <source>&amp;M</source>
        <translation>&amp;M</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="248"/>
        <source>&amp;Y</source>
        <translation>&amp;Y</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="253"/>
        <source>&amp;K</source>
        <translation>&amp;K</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="262"/>
        <source>Preview Settings</source>
        <translation type="unfinished">Configuraciones de vista previa</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="358"/>
        <source>Shows transparency and transparent items in your document. Requires Ghostscript 7.07 or later</source>
        <translation>Muestra transparencias y objetos transparentes. Requiere Ghostscript 7.07 ó superior</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="359"/>
        <source>Gives a print preview using simulations of generic CMYK inks, instead of RGB colors</source>
        <translation>Muestra una vista previa de la impresión simulando tintas CMYK genéricas, en vez de colores RGB</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="382"/>
        <source>Enable/disable the C (Cyan) ink plate</source>
        <translation>Activar/desactivar la tinta C (cian)</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="383"/>
        <source>Enable/disable the M (Magenta) ink plate</source>
        <translation>Activar/desactivar la tinta M (magenta)</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="384"/>
        <source>Enable/disable the Y (Yellow) ink plate</source>
        <translation>Activar/desactivar la tinta Y (amarillo)</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="385"/>
        <source>Enable/disable the K (Black) ink plate</source>
        <translation>Activar/desactivar la tinta K (negro)</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="590"/>
        <location filename="../../../scribus/preview.cpp" line="696"/>
        <source>All</source>
        <translation>Todos</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="154"/>
        <source>Separation Name</source>
        <translation>Nombre de separación</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="166"/>
        <source>Cyan</source>
        <translation>Cian</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="173"/>
        <source>Magenta</source>
        <translation>Magenta</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="180"/>
        <source>Yellow</source>
        <translation>Amarillo</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="187"/>
        <source>Black</source>
        <translation>Negro</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="301"/>
        <source>Scaling:</source>
        <translation>Escalado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="329"/>
        <source>Print...</source>
        <translation>Imprimir...</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="360"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation>Un modo de desactivar algunas de las escalas de grises compuesta de cian, amarillo y magenta y usar en su lugar el negro. UCR principalmente afecta a las partes de las imágenes de color neutral y/o tonos oscuros que están próximos al gris. Usar esta opción podria mejorar la impresión de ciertas imágenes pero se necesita experimentación y comprobación de caso por caso. UCR reduce la posibilidad de sobresaturación con tintas CMY.</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="361"/>
        <source>Resize the scale of the page.</source>
        <translation>Redimensionar la escala de la página.</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="326"/>
        <source>Close</source>
        <translation>Cerrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="1298"/>
        <source>File</source>
        <translation>Archivo</translation>
    </message>
    <message>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Forzar modo de sobreimpresión</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="131"/>
        <source>Enable &amp;Antialiasing</source>
        <translation>&amp;Activar suavizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="313"/>
        <source>Fit to Width</source>
        <translation>Ajustar a ancho</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="314"/>
        <source>Fit to Height</source>
        <translation>Ajustar a alto</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="315"/>
        <source>Fit to Page</source>
        <translation>Ajustar a página</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="357"/>
        <source>Provides a more pleasant view of Type 1 fonts, TrueType Fonts, OpenType Fonts, EPS, PDF and vector graphics in the preview, at the expense of a slight slowdown in previewing</source>
        <translation>Provee de una vista más agradable de las tipografías Type 1, TrueType y OpenType, y de EPS, PDF y gráficos vectoriales en la vista previa, a cambio de una menor velocidad en la vista previa</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="125"/>
        <source>Display Settings</source>
        <translation>Configuración de pantalla</translation>
    </message>
    <message>
        <source>Print Settings</source>
        <translation type="obsolete">Configuración de impresión</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="268"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation>Reflejar página/s horizontales</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="271"/>
        <source>Mirror Page(s) Vertical</source>
        <translation>Reflejar página/s verticales</translation>
    </message>
    <message>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Ajustarse a márgenes de página</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="277"/>
        <source>Print in Grayscale</source>
        <translation>Imprimir en escala de grises</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="283"/>
        <source>Convert Spot Colors</source>
        <translation>Convertir a tinta plana</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="362"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation>Activa la conversión de colores de tinta plana a colores de composición. A menos que estés planeando imprimir colores planos en una impresora comercial, probablemente es mejor dejarlo marcado.</translation>
    </message>
    <message>
        <source>Enables global Overprint Mode for this document, overrides object settings</source>
        <translation type="obsolete">Activa el modo global de sobreimpresión, sobreescribe las configuraciones de los objetos</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="286"/>
        <source>Apply Color Profiles</source>
        <translation>Aplicar perfiles de color</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="363"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation>Te permite incrustar perfiles de color en el flujo de impresión cuando el manejo de color está activado</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="274"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="208"/>
        <source>Display Ink Coverage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="216"/>
        <source>Threshold:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="219"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="223"/>
        <source>None</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PSLib</name>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1862"/>
        <source>Processing Master Page:</source>
        <translation>Procesando página maestra:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1862"/>
        <source>Exporting Page:</source>
        <translation>Exportando página:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1795"/>
        <source>Failed to write data for an image</source>
        <translation>Fallo al escribir datos para una imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1800"/>
        <source>Failed to load an image : %1</source>
        <translation>Fallo al cargar una imagen: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1805"/>
        <source>Failed to load an image mask : %1</source>
        <translation>Fallo al cargar una máscara de imagen: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1810"/>
        <source>Insufficient memory for processing an image</source>
        <translation>Memoria insuficiente para procesar una imagen</translation>
    </message>
</context>
<context>
    <name>PageItem</name>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="394"/>
        <source>Image</source>
        <translation>Imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="398"/>
        <source>Text</source>
        <translation>Texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="402"/>
        <source>Line</source>
        <translation>Línea</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="406"/>
        <source>Polygon</source>
        <translation>Polígono</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="410"/>
        <source>Polyline</source>
        <translation>Polilínea</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="414"/>
        <source>PathText</source>
        <translation>Trazao del texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="4256"/>
        <location filename="../../../scribus/pageitem.cpp" line="4257"/>
        <source>Copy of</source>
        <translation>Copia de </translation>
    </message>
</context>
<context>
    <name>PageItemAttributes</name>
    <message>
        <location filename="../../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Relates To</source>
        <translation>Depende de</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Parent Of</source>
        <translation>Es padre de</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Child Of</source>
        <translation>Es hijo de</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="23"/>
        <source>Name</source>
        <translation>Nombre</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="28"/>
        <source>Type</source>
        <translation>Tipo</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="33"/>
        <source>Value</source>
        <translation>Valor</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="58"/>
        <source>&amp;Add</source>
        <translation>A&amp;ñadir</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="61"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="68"/>
        <source>&amp;Copy</source>
        <translation>&amp;Copiar</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="71"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="78"/>
        <source>&amp;Delete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="81"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="88"/>
        <source>C&amp;lear</source>
        <translation>B&amp;orrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="91"/>
        <source>Alt+L</source>
        <translation>Alt+L</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="114"/>
        <source>&amp;OK</source>
        <translation>&amp;Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="130"/>
        <source>&amp;Cancel</source>
        <translation>&amp;Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.cpp" line="21"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation>Ninguno</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="38"/>
        <source>Parameter</source>
        <translation>Parámetro</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="43"/>
        <source>Relationship</source>
        <translation>Relación</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="48"/>
        <source>Relationship To</source>
        <translation>Relacionado con</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="13"/>
        <source>Attributes</source>
        <translation>Atributos</translation>
    </message>
</context>
<context>
    <name>PageItem_ImageFrame</name>
    <message>
        <source>Preview Settings</source>
        <translation type="obsolete">Configuraciones de vista previa</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="303"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="484"/>
        <source>Image</source>
        <translation>Imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="92"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="319"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="490"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="94"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="316"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="350"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="492"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="519"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="521"/>
        <source>File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="95"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="324"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="493"/>
        <source>Original PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="96"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="329"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="494"/>
        <source>Actual PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="97"/>
        <source>Size:</source>
        <translation type="unfinished">Tamaño:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="98"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="334"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="495"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Espacio de color:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="102"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="339"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="499"/>
        <source>Unknown</source>
        <translation type="unfinished">Desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="109"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="506"/>
        <source>Page:</source>
        <translation type="unfinished">Página:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="111"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="508"/>
        <source>Pages:</source>
        <translation type="unfinished">Páginas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="354"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="517"/>
        <source>Embedded Image missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="356"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="519"/>
        <source>missing or corrupt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="358"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="521"/>
        <source>missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="363"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="524"/>
        <source>No Image Loaded</source>
        <translation type="unfinished">Ninguna imagen cargada</translation>
    </message>
</context>
<context>
    <name>PageItem_LatexFrame</name>
    <message>
        <source>Latex</source>
        <translation type="obsolete">LaTeX</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="245"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="266"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="414"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="419"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="578"/>
        <source>Error</source>
        <translation>Error</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="163"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="181"/>
        <source>Running the external application failed!</source>
        <translation>¡La ejecución de la aplicación externa falló!</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="246"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="250"/>
        <source>Could not create a temporary file to run the application!</source>
        <translation>¡No se puede crear un archivo temporal para ejecutar la aplicación!</translation>
    </message>
    <message>
        <source>Information</source>
        <translation type="obsolete">Información</translation>
    </message>
    <message>
        <source>Please specify a latex executable in the preferences!</source>
        <translation type="obsolete">¡Por favor, especifique un ejecutable de LaTeX en las preferencias!</translation>
    </message>
    <message>
        <source>An editor for this frame is already running!</source>
        <translation type="obsolete">¡Ya se está ejecutando un editor para este marco!</translation>
    </message>
    <message>
        <source>Please specify an editor in the preferences!</source>
        <translation type="obsolete">¡Por favor, especifique un editor en las preferencias!</translation>
    </message>
    <message>
        <source>Could not create a temporary file to run the external editor!</source>
        <translation type="obsolete">¡No se pudo crear un archivo temporal para ejecutar el editor externo!</translation>
    </message>
    <message>
        <source>Running the editor failed with exitcode %d!</source>
        <translation type="obsolete">¡La ejecución del editor falló con el código de salida %d!</translation>
    </message>
    <message>
        <source>Running the editor &quot;%1&quot; failed!</source>
        <translation type="obsolete">¡Fallo al ejecutar el editor &quot;%1&quot;!</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="426"/>
        <source>Running the application &quot;%1&quot; failed!</source>
        <translation>¡Fallo al ejecutar la aplicación &quot;%1&quot;!</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="583"/>
        <source>Running</source>
        <translation>Ejecutando</translation>
    </message>
    <message>
        <source>The application &quot;%1&quot; failed to start!</source>
        <translation type="obsolete">¡La aplicacion &quot;%1&quot; falló al arrancar!</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="420"/>
        <source>The application &quot;%1&quot; crashed!</source>
        <translation>¡La aplicación &quot;%1&quot; falló!</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="572"/>
        <source>Application</source>
        <translation>Aplicación</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="573"/>
        <source>DPI</source>
        <translation>DPI</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="575"/>
        <source>State</source>
        <translation>Estado</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="580"/>
        <source>Finished</source>
        <translation>Terminado</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="44"/>
        <source>Render</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="164"/>
        <source>This is usually a problem with your input. Please check the program&apos;s output.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="166"/>
        <source>Do you want to open the editor to fix the problem?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="267"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="271"/>
        <source>The config file didn&apos;t specify a executable path!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="415"/>
        <source>The application &quot;%1&quot; failed to start! Please check the path: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="571"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="235"/>
        <source>No configuration defined to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="433"/>
        <source>No application defined</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="130"/>
        <source>Rendering...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="139"/>
        <source>Render Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_PathText</name>
    <message>
        <location filename="../../../scribus/pageitem_pathtext.cpp" line="315"/>
        <source>Paragraphs: </source>
        <translation>Párrafos: </translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_pathtext.cpp" line="323"/>
        <source>Lines: </source>
        <translation>Líneas: </translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_pathtext.cpp" line="329"/>
        <source>Words: </source>
        <translation>Palabras: </translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_pathtext.cpp" line="337"/>
        <source>Chars: </source>
        <translation>Caracteres: </translation>
    </message>
</context>
<context>
    <name>PageItem_TextFrame</name>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3864"/>
        <source>Linked Text</source>
        <translation>Texto enlazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3866"/>
        <source>Text Frame</source>
        <translation>Marco de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3870"/>
        <source>Paragraphs: </source>
        <translation>Párrafos: </translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3878"/>
        <source>Lines: </source>
        <translation>Líneas: </translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3884"/>
        <source>Words: </source>
        <translation>Palabras: </translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3892"/>
        <source>Chars: </source>
        <translation>Caracteres: </translation>
    </message>
</context>
<context>
    <name>PageLayouts</name>
    <message>
        <location filename="../../../scribus/pagelayout.cpp" line="266"/>
        <source>First Page is:</source>
        <translation>La primera página es:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagelayout.cpp" line="197"/>
        <source>Document Layout</source>
        <translation>Disposición del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagelayout.cpp" line="268"/>
        <source>Number of pages to show side-by-side on the canvas
Often used for allowing items to be placed across page spreads</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagelayout.cpp" line="273"/>
        <source>Location on the canvas where the first page of the document is placed</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PagePalette</name>
    <message>
        <source>Drag pages or master pages onto the trashbin to delete them</source>
        <translation type="obsolete">Enviar páginas o páginas maestra a la papelera para eliminarlas</translation>
    </message>
    <message>
        <source>Here are all your master pages. To create a new page, drag a master page to the page view below</source>
        <translation type="obsolete">Aquí están todas las páginas maestras. Para crear una nueva página, arrastre una página maestra a la vista inferior de la página</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="928"/>
        <source>Arrange Pages</source>
        <translation>Ordenar páginas</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="929"/>
        <source>Available Master Pages:</source>
        <translation>Páginas maestras disponibles:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="930"/>
        <source>Document Pages:</source>
        <translation>Páginas del documento:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="933"/>
        <source>List of normal pages in the document, shown with the document layout. Pages may be dragged to rearrange or delete them.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="934"/>
        <source>Drag pages or master pages onto the trash to delete them</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="932"/>
        <source>List of master pages in the document. Master page names may be dragged onto the page view below to apply master pages, or onto the empty space between pages to create new pages.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="636"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="640"/>
        <source>Do you really want to delete this master page?</source>
        <translation type="unfinished">¿Realmente quieres eliminar esta página maestra?</translation>
    </message>
</context>
<context>
    <name>PageSelector</name>
    <message>
        <source>%1 of %2</source>
        <translation type="obsolete">%1 de %2</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="268"/>
        <source>Go to the first page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="269"/>
        <source>Go to the previous page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="270"/>
        <source>Go to the next page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="271"/>
        <source>Go to the last page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="272"/>
        <source>Select the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="273"/>
        <source> of %1</source>
        <comment>number of pages in document</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ParaStyleComboBox</name>
    <message>
        <location filename="../../../scribus/spalette.cpp" line="38"/>
        <location filename="../../../scribus/spalette.cpp" line="51"/>
        <location filename="../../../scribus/spalette.cpp" line="62"/>
        <source>No Style</source>
        <translation>Sin estilo</translation>
    </message>
</context>
<context>
    <name>PathAlongPathPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="69"/>
        <source>Path Along Path...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished">Herramientas de trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="96"/>
        <source>Bends a Polygon along a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="97"/>
        <source>This plugin bends a Polygon with the help of a Polyline.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectDialogBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="13"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="27"/>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="48"/>
        <source>Starting Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="32"/>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="53"/>
        <source>End Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="69"/>
        <source>a straight Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="74"/>
        <source>Points moving</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="82"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="19"/>
        <source>Connect First Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="40"/>
        <source>with Second Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="61"/>
        <source>by using:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="65"/>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="90"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="69"/>
        <source>Path Tools</source>
        <translation type="unfinished">Herramientas de trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="91"/>
        <source>Connect 2 Polylines.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathCutPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="70"/>
        <source>Cut Polygon</source>
        <translation>Cortar polígono</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="76"/>
        <source>Path Tools</source>
        <translation>Herramientas de trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="99"/>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="100"/>
        <source>Cuts a Polygon by a Polyline</source>
        <translation>Corta un polígono por una polilínea</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>Qt Version too old</source>
        <translation>La versión de Qt es demasiado antigua</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation>Esta extensión requiere, al menos, la versión 4.3.3 de la biblioteca Qt</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>Error</source>
        <translation>Error</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>The cutting line must cross the polygon and
both end points must lie outside of the polygon</source>
        <translation>La línea de corte debe cruzar el polígono y ambos
puntos finales deben estar fuera del mismo</translation>
    </message>
</context>
<context>
    <name>PathDialogBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="13"/>
        <source>Path along Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="21"/>
        <source>Effect Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="29"/>
        <source>Single</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="34"/>
        <source>Single, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="39"/>
        <source>Repeated</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="44"/>
        <source>Repeated, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="52"/>
        <source>Horizontal Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="62"/>
        <source>Vertical Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="103"/>
        <source>Gap between Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="113"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="72"/>
        <source>Rotate Objects by:</source>
        <translation type="unfinished"></translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="80"/>
        <source>0°</source>
        <translation type="unfinished">0°</translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="85"/>
        <source>90°</source>
        <translation type="unfinished">90°</translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="90"/>
        <source>180°</source>
        <translation type="unfinished">180°</translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="95"/>
        <source>270°</source>
        <translation type="unfinished">270°</translation>
    </message>
</context>
<context>
    <name>PathFinderBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="14"/>
        <source>Boolean Path Operations</source>
        <translation>Operaciones booleanas del trazado</translation>
    </message>
    <message>
        <source>Keep a copy of the original Item after applying the operation</source>
        <translation type="obsolete">Mantener una copia del objeto original tras aplicar la operación</translation>
    </message>
    <message>
        <source>keep</source>
        <translation type="obsolete">mantener</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="111"/>
        <source>+</source>
        <translation>+</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="222"/>
        <source>=</source>
        <translation>=</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="304"/>
        <source>Operation</source>
        <translation>Operación</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="319"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="338"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="354"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="370"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="387"/>
        <source>...</source>
        <translation>...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="411"/>
        <source>Swap Shapes</source>
        <translation>Intercambiar formas</translation>
    </message>
    <message>
        <source>Options</source>
        <translation type="obsolete">Opciones</translation>
    </message>
    <message>
        <source>Result gets Color of:</source>
        <translation type="obsolete">El resultado tiene el color de:</translation>
    </message>
    <message>
        <source>first Shape</source>
        <translation type="obsolete">primera forma</translation>
    </message>
    <message>
        <source>second Shape</source>
        <translation type="obsolete">segunda forma</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="42"/>
        <source>First source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="153"/>
        <source>Second source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="261"/>
        <source>The resulting shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="316"/>
        <source>Unites the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="351"/>
        <source>Intersection of the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="367"/>
        <source>Result is the area where the two shapes do not intersect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="383"/>
        <source>Break apart,
The result is a combination of &quot;Intersection&quot; and &quot;Exclusion&quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="482"/>
        <source>Custom Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="494"/>
        <source>Stroke:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="520"/>
        <source>Fill:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="61"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="172"/>
        <source>Keep a copy of the original item after applying the operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="64"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="175"/>
        <source>Keep</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="335"/>
        <source>Subtracts the second shape from the first shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="408"/>
        <source>Exchange the Source Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="456"/>
        <source>The resulting shape uses the color of the first source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="459"/>
        <source>First Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="469"/>
        <source>The resulting shape uses the color of the second source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="472"/>
        <source>Second Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="479"/>
        <source>The resulting shape uses the colors listed below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="510"/>
        <source>Stroke Color</source>
        <translation type="unfinished">Color de trazo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="530"/>
        <source>Fill Color</source>
        <translation type="unfinished">Color de relleno</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="450"/>
        <source>Result Takes Color from:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderDialog</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="103"/>
        <source>Result gets Color of:</source>
        <translation>El resultado tiene el color de:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="127"/>
        <source>Intersection gets Color of:</source>
        <translation>La intersección tiene el color de:</translation>
    </message>
</context>
<context>
    <name>PathFinderPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="76"/>
        <source>Path Operations...</source>
        <translation>Operaciones de trazado...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="80"/>
        <source>Path Tools</source>
        <translation>Herramientas de trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="105"/>
        <source>Path Operations</source>
        <translation>Operaciones de trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="106"/>
        <source>Apply fancy boolean operations to paths.</source>
        <translation type="unfinished">Aplicar operaciones booleanas de fantasía a los trazados.</translation>
    </message>
    <message>
        <source>Qt Version too old</source>
        <translation type="obsolete">La versión de Qt es demasiado antigua</translation>
    </message>
    <message>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="obsolete">Esta extensión requiere, al menos, la versión 4.3.3 de la biblioteca Qt</translation>
    </message>
</context>
<context>
    <name>PathStrokerPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="71"/>
        <location filename="../../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="96"/>
        <source>Create Path from Stroke</source>
        <translation>Crear trazado desde contorno</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="75"/>
        <source>Path Tools</source>
        <translation>Herramientas de trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="97"/>
        <source>Converts the stroke of a Path to a filled Path.</source>
        <translation type="unfinished">Convierte el contorno de un trazado en un trazado relleno.</translation>
    </message>
</context>
<context>
    <name>PatternDialog</name>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="130"/>
        <source>Choose a Directory</source>
        <translation>Elige un directorio</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="158"/>
        <source>Loading Patterns</source>
        <translation>Cargando patrones</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="292"/>
        <source>All Files (*)</source>
        <translation>Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="306"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="15"/>
        <source>Patterns</source>
        <translation>Patrones</translation>
    </message>
    <message>
        <source>Load</source>
        <translation type="obsolete">Cargar</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="48"/>
        <source>Load File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="55"/>
        <source>Load Set</source>
        <translation>Cargar set</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="69"/>
        <source>Remove</source>
        <translation>Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="76"/>
        <source>Remove All</source>
        <translation>Borrar todos</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="99"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="106"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="85"/>
        <source>&amp;Name:</source>
        <translation type="unfinished">&amp;Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="85"/>
        <source>Rename Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="209"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Todos los formatos soportados</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="62"/>
        <source>Rename</source>
        <translation type="unfinished">Renombrar</translation>
    </message>
</context>
<context>
    <name>PctPlug</name>
    <message>
        <location filename="../../../scribus/plugins/import/pct/importpct.cpp" line="82"/>
        <source>Importing: %1</source>
        <translation type="unfinished">Importando: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/pct/importpct.cpp" line="85"/>
        <source>Analyzing File:</source>
        <translation type="unfinished">Analizando archivo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/pct/importpct.cpp" line="209"/>
        <source>Group%1</source>
        <translation type="unfinished">Grupo%1</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/pct/importpct.cpp" line="368"/>
        <source>Generating Items</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicSearch</name>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="14"/>
        <source>Result</source>
        <translation>Resultado</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="34"/>
        <source>Search Results for: </source>
        <translation>Resultados de la búsqueda para: </translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="128"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="108"/>
        <source>Size:</source>
        <translation>Tamaño:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="109"/>
        <source>Resolution:</source>
        <translation>Resolución:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="109"/>
        <source>DPI</source>
        <translation>DPI</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="112"/>
        <source>Unknown</source>
        <translation>Desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="115"/>
        <source>Colorspace:</source>
        <translation>Espacio de color:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="86"/>
        <source>&amp;Preview</source>
        <translation>&amp;Previsualizar</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="89"/>
        <source>Alt+P</source>
        <translation>Alt+P</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="115"/>
        <source>&amp;Select</source>
        <translation>&amp;Seleccionar</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="118"/>
        <source>Alt+S</source>
        <translation>Alt+S</translation>
    </message>
</context>
<context>
    <name>PicSearchOptions</name>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="52"/>
        <source>The filesystem will be searched for case insensitive file names when you check this on. Remember it is not default on most operating systems except MS Windows</source>
        <translation>Se buscará, en el sistema de archivos, nombres de archivos sin distinción de mayúsculas y minúsculas si esta opción está marcada. Recuerda que esto no es lo normal en la mayoría de sistemas operativos excepto en MS Windows</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="59"/>
        <source>Cancel Search</source>
        <translation>Cancelar búsqueda</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="124"/>
        <location filename="../../../scribus/picsearchoptions.cpp" line="68"/>
        <source>Start Search</source>
        <translation>Comenzar búsqueda</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="92"/>
        <source>Select a base directory for search</source>
        <translation>Seleccionar un directorio base para búsqueda</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="104"/>
        <location filename="../../../scribus/picsearchoptions.cpp" line="141"/>
        <source>Scribus - Image Search</source>
        <translation>Scribus - Buscar imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="141"/>
        <source>The search failed: %1</source>
        <translation>La búsqueda falló: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="13"/>
        <source>Search Images</source>
        <translation>Buscar imágenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="25"/>
        <source>Search for:</source>
        <translation>Buscar:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="38"/>
        <source>Start at:</source>
        <translation>Comenzar en:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="64"/>
        <source>Change...</source>
        <translation>Cambiar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="79"/>
        <source>Searching</source>
        <translation>Buscando</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="141"/>
        <source>Case insensitive search</source>
        <translation>Búsqueda sin distinción mayúsculas/minúsculas</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="148"/>
        <source>Search recursively</source>
        <translation>Buscar recursivamente</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="104"/>
        <source>Base directory for search does not exist.
Please choose another one.</source>
        <translation>El directorio base de la búsqueda no existe.
Por favor, elige otro directorio.</translation>
    </message>
</context>
<context>
    <name>PicStatus</name>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="439"/>
        <source>Scribus - Image Search</source>
        <translation>Scribus - Buscar imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="439"/>
        <source>No images named &quot;%1&quot; were found.</source>
        <translation>No se encontró ninguna imagen llamada &quot;%1&quot;.</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="684"/>
        <source>Close</source>
        <translation>Cerrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="259"/>
        <source>Not on a Page</source>
        <translation>No está en ninguna página</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="284"/>
        <source>JPG</source>
        <translation>JPG</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="287"/>
        <source>TIFF</source>
        <translation>TIFF</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="290"/>
        <source>PSD</source>
        <translation>PSD</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="293"/>
        <source>EPS/PS</source>
        <translation>EPS/PS</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="296"/>
        <source>PDF</source>
        <translation>PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="299"/>
        <source>JPG2000</source>
        <translation>JPG2000</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="305"/>
        <source>emb. PSD</source>
        <translation>PSD incrustado</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="311"/>
        <source>Unknown</source>
        <translation>Desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="328"/>
        <source>n/a</source>
        <translation>n/a</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="83"/>
        <source>Information</source>
        <translation>Información</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="155"/>
        <source>Path:</source>
        <translation>Ruta:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="198"/>
        <source>Search...</source>
        <translation>Buscar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="105"/>
        <source>Name:</source>
        <translation>Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="215"/>
        <source>Image</source>
        <translation>Imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="288"/>
        <source>DPI:</source>
        <translation>DPI:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="221"/>
        <source>Format:</source>
        <translation>Formato:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="256"/>
        <source>Colorspace:</source>
        <translation>Espacio de color:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="323"/>
        <source>Size</source>
        <translation>Tamaño</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="329"/>
        <source>Pixels:</source>
        <translation>Píxeles:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="358"/>
        <source>Scale:</source>
        <translation>Escalado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="387"/>
        <source>Printed:</source>
        <translation>Impreso:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="425"/>
        <source>Layout</source>
        <translation>Disposición</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="433"/>
        <source>On Page:</source>
        <translation>En página:</translation>
    </message>
    <message>
        <source>eff. DPI:</source>
        <translation type="obsolete">DPI eficaces:</translation>
    </message>
    <message>
        <source>Object:</source>
        <translation type="obsolete">Objeto:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="546"/>
        <source>Select</source>
        <translation>Seleccionar</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="575"/>
        <source>Image Tools</source>
        <translation>Herramientas de imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="623"/>
        <source>Image Visible</source>
        <translation>Imagen visible</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="633"/>
        <source>Image Effects...</source>
        <translation>Efectos de imagen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="613"/>
        <source>Edit Image...</source>
        <translation>Editar imagen...</translation>
    </message>
    <message>
        <source>Print Image</source>
        <translation type="obsolete">Imprimir imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="600"/>
        <source>Extended Image Properties...</source>
        <translation>Propiedades adicionales de imagen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="228"/>
        <source>Sort by Name</source>
        <translation>Ordenar por nombre</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="230"/>
        <source>Sort by Page</source>
        <translation>Ordenar por página</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="16"/>
        <source>Manage Images</source>
        <translation>Manejar imágenes</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="530"/>
        <source>Go to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="127"/>
        <source>Name of the image file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="177"/>
        <source>Location where the image file is stored</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="195"/>
        <source>Search for a missing image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="240"/>
        <source>Type of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="253"/>
        <source>The colorspace of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="275"/>
        <source>Colorspace used within the image, eg RGB or CMYK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="307"/>
        <source>Native resolution of the image, in dots per inch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="345"/>
        <source>Height and width of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="374"/>
        <source>Horizontal and vertical scaling applied to the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="409"/>
        <source>Size of the image when printed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="449"/>
        <source>Page that the image is displayed on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="462"/>
        <source>Page Item:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="478"/>
        <source>Name of the page item that contains the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="491"/>
        <source>Effective DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="510"/>
        <source>Effective resolution of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="527"/>
        <source>Move to the page that the image is on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="543"/>
        <source>Move to the page that the item is on and select it</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="587"/>
        <source>Enable or disable exporting of the item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="590"/>
        <source>Export/Print Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="597"/>
        <source>Set format specfic properties of certain image types, like clipping paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="610"/>
        <source>Edit the image in the default editor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="620"/>
        <source>Make the image visible or invisible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="630"/>
        <source>Apply non destructive effects to the image in its frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="128"/>
        <location filename="../../../scribus/picstatus.cpp" line="143"/>
        <location filename="../../../scribus/picstatus.cpp" line="270"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PixmapExportPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="62"/>
        <source>Save as &amp;Image...</source>
        <translation>Guardar como &amp;imagen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="73"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="81"/>
        <source>Export As Image</source>
        <translation>Exportar como imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="82"/>
        <source>Exports selected pages as bitmap images.</source>
        <translation>Exportar las páginas seleccionadas como imágenes de mapas de bits.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="147"/>
        <source>Export successful</source>
        <translation>Exportado correcto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="120"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="126"/>
        <source>Save as Image</source>
        <translation type="unfinished">Guardar como imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="121"/>
        <source>The target location %1 must be an existing directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="127"/>
        <source>The target location %1 must be writable</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PluginManager</name>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="61"/>
        <location filename="../../../scribus/pluginmanager.cpp" line="73"/>
        <source>Cannot find plugin</source>
        <comment>plugin manager</comment>
        <translation>No se encontró la extensión</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="62"/>
        <source>unknown error</source>
        <comment>plugin manager</comment>
        <translation>error desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="87"/>
        <location filename="../../../scribus/pluginmanager.cpp" line="93"/>
        <location filename="../../../scribus/pluginmanager.cpp" line="98"/>
        <source>Cannot find symbol (%1)</source>
        <comment>plugin manager</comment>
        <translation>No se puede encontrar el símbolo (%1)</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="158"/>
        <source>Plugin: loading %1</source>
        <comment>plugin manager</comment>
        <translation>Extensión: cargando %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="265"/>
        <source>init failed</source>
        <comment>plugin load error</comment>
        <translation>falló el inicio</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="271"/>
        <source>unknown plugin type</source>
        <comment>plugin load error</comment>
        <translation>tipo de extensión desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="274"/>
        <source>Plugin: %1 loaded</source>
        <comment>plugin manager</comment>
        <translation>Extensión: %1 cargada</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="278"/>
        <source>Plugin: %1 failed to load: %2</source>
        <comment>plugin manager</comment>
        <translation>Extensión: %1 falló al cargar: %2</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="345"/>
        <source>Plugin: %1 initialized ok </source>
        <comment>plugin manager</comment>
        <translation>Extensión: %1 incializada correctamente </translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="347"/>
        <source>Plugin: %1 failed post initialization</source>
        <comment>plugin manager</comment>
        <translation>Extensión: %1 falló post-inicialización</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="231"/>
        <source>There is a problem loading %1 of %2 plugins. %3 This is probably caused by some kind of dependency issue or old plugins existing in your install directory. If you clean out your install directory and reinstall and this still occurs, please report it on bugs.scribus.net.</source>
        <translation>Hubo un problema al cargar %1 de %2 extensiones. %3 Probablemente eso ocurra por algún motivo relacionado con dependencias o antiguas extensiones presentes en el directorio de instalación. Si limpias el directorio de instalación y reinstalar y aún ocurre esto, por favor, informa de ello en bugs.scribus.net.</translation>
    </message>
</context>
<context>
    <name>PluginManagerPrefsGui</name>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="20"/>
        <source>Plugin Manager</source>
        <translation>Gestor de extensiones</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="36"/>
        <source>Plugin</source>
        <translation>Extensión</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="41"/>
        <source>How to run</source>
        <translation>Cómo ejecutar</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="46"/>
        <source>Type</source>
        <translation>Tipo</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="51"/>
        <source>Load it?</source>
        <translation>¿Cargarla?</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="56"/>
        <source>Plugin ID</source>
        <translation>ID de extensión</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="61"/>
        <source>File</source>
        <translation>Archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="69"/>
        <source>You need to restart the application to apply the changes.</source>
        <translation>Necesitas reiniciar la aplicación para aplicar los cambios.</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="14"/>
        <source>Form</source>
        <translation>Formulario</translation>
    </message>
</context>
<context>
    <name>PolygonProps</name>
    <message>
        <location filename="../../../scribus/polyprops.cpp" line="20"/>
        <source>Polygon Properties</source>
        <translation>Propiedades del polígono</translation>
    </message>
</context>
<context>
    <name>PolygonWidget</name>
    <message>
        <source>Corn&amp;ers:</source>
        <translation type="obsolete">&amp;Vértices:</translation>
    </message>
    <message>
        <source>&amp;Rotation:</source>
        <translation type="obsolete">&amp;Rotación:</translation>
    </message>
    <message>
        <source>Apply &amp;Factor</source>
        <translation type="obsolete">Aplicar &amp;factor</translation>
    </message>
    <message>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <source>&amp;Factor:</source>
        <translation type="obsolete">Fac&amp;tor:</translation>
    </message>
    <message>
        <source>Number of corners for polygons</source>
        <translation type="obsolete">Número de vértices de los polígonos</translation>
    </message>
    <message>
        <source>Degrees of rotation for polygons</source>
        <translation type="obsolete">Grados de rotación de los polígonos</translation>
    </message>
    <message>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="obsolete">Aplicar el factor convexo/cóncavo para cambiar la forma de los polígonos</translation>
    </message>
    <message>
        <source>Sample Polygon</source>
        <translation type="obsolete">Polígono de ejemplo</translation>
    </message>
    <message>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="obsolete">Un valor negativo creará un polígono cóncavo (o con forma de estrella), un valor positivo los creará convexo</translation>
    </message>
</context>
<context>
    <name>PolygonWidgetBase</name>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished">Formulario</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="30"/>
        <source>Corn&amp;ers:</source>
        <translation type="unfinished">&amp;Vértices:</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="40"/>
        <source>Number of corners for polygons</source>
        <translation type="unfinished">Número de vértices de los polígonos</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="53"/>
        <source>&amp;Rotation:</source>
        <translation type="unfinished">&amp;Rotación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="63"/>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="76"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="unfinished">Grados de rotación de los polígonos</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="121"/>
        <source>Sample Polygon</source>
        <translation type="unfinished">Polígono de ejemplo</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="143"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="unfinished">Aplicar el factor convexo/cóncavo para cambiar la forma de los polígonos</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="146"/>
        <source>Apply &amp;Factor</source>
        <translation type="unfinished">Aplicar &amp;factor</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="161"/>
        <source>&amp;Factor:</source>
        <translation type="unfinished">Fac&amp;tor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="171"/>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="187"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="unfinished">Un valor negativo creará un polígono cóncavo (o con forma de estrella), un valor positivo los creará convexo</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="174"/>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="216"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="206"/>
        <source>C&amp;urvature:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Preferences</name>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="72"/>
        <source>Preferences</source>
        <translation>Preferencias</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="75"/>
        <source>General</source>
        <translation>General</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="78"/>
        <source>Document</source>
        <translation>Documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="81"/>
        <source>Guides</source>
        <translation>Guías</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="84"/>
        <source>Typography</source>
        <translation>Tipografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="87"/>
        <source>Tools</source>
        <translation>Herramientas</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="90"/>
        <source>Hyphenation and Spelling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="135"/>
        <source>Scrapbook</source>
        <translation>Álbum de recortes</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="138"/>
        <source>Display</source>
        <translation>Visualización</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="141"/>
        <source>External Tools</source>
        <translation>Herramientas externas</translation>
    </message>
    <message>
        <source>Hyphenator</source>
        <translation type="obsolete">División por sílabas</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="93"/>
        <source>Fonts</source>
        <translation>Tipografías</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="99"/>
        <source>Preflight Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="104"/>
        <source>Color Management</source>
        <translation>Manejo de color</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="119"/>
        <source>PDF Export</source>
        <translation>Exportar como PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="124"/>
        <source>Document Item Attributes</source>
        <translation>Atributos de objetos del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="129"/>
        <source>Table of Contents and Indexes</source>
        <translation>Tabla de contenido e índices</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="132"/>
        <source>Keyboard Shortcuts</source>
        <translation>Teclas rápidas</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="144"/>
        <source>Miscellaneous</source>
        <translation>Miscelánea</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="148"/>
        <source>Plugins</source>
        <translation>Extensiones</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="96"/>
        <source>Printer</source>
        <translation>Impresora</translation>
    </message>
</context>
<context>
    <name>PrefsDialogBase</name>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="202"/>
        <source>&amp;Defaults</source>
        <translation>Pre&amp;determinados</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="211"/>
        <source>Save Preferences</source>
        <translation>Guardar preferencias</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="201"/>
        <source>Export...</source>
        <translation>Exportar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="203"/>
        <source>&amp;Apply</source>
        <translation>A&amp;plicar</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="204"/>
        <source>All preferences can be reset here</source>
        <translation>Se pueden reiniciar todas las preferencias aquí</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="205"/>
        <source>Apply all changes without closing the dialog</source>
        <translation>Aplicar todos los cambios sin cerrar este diálogo</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="206"/>
        <source>Export current preferences into file</source>
        <translation>Exportar las preferencias actuales en un archivo</translation>
    </message>
</context>
<context>
    <name>PrefsManager</name>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2092"/>
        <location filename="../../../scribus/prefsmanager.cpp" line="2101"/>
        <source>Postscript</source>
        <translation>Postscript</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="829"/>
        <source>Migrate Old Scribus Settings?</source>
        <translation>¿Mirar configuración antigua de Scribus?</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="830"/>
        <source>Scribus has detected existing Scribus 1.2 preferences files.
Do you want to migrate them to the new Scribus version?</source>
        <translation>Scribus ha detectado la presencia de archivos de configuración de Scribus 1.2.
¿Quieres portarlos a la nueva versión de Scribus?</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2092"/>
        <location filename="../../../scribus/prefsmanager.cpp" line="2101"/>
        <source>PostScript</source>
        <translation>PostScript</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="1722"/>
        <source>Could not open preferences file &quot;%1&quot; for writing: %2</source>
        <translation>No se pudo abrir el archivo de preferencias &quot;%1&quot; como escritura: %2</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="1733"/>
        <source>Writing to preferences file &quot;%1&quot; failed: QIODevice status code %2</source>
        <translation>Error al escribir en el archivo de preferencias &quot;%1&quot;: QIODevice código de estado %2</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="1747"/>
        <source>Failed to open prefs file &quot;%1&quot;: %2</source>
        <translation>Error al abrir el archivo de preferencias &quot;%1&quot;: %2</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="1757"/>
        <source>Failed to read prefs XML from &quot;%1&quot;: %2 at line %3, col %4</source>
        <translation>Error al leer el XML de preferencias de &quot;%1&quot;: %2 en línea %3, columna %4</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2451"/>
        <source>Error Writing Preferences</source>
        <translation>Error al escribir las preferencias</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2453"/>
        <source>Scribus was not able to save its preferences:&lt;br&gt;%1&lt;br&gt;Please check file and directory permissions and available disk space.</source>
        <comment>scribus app error</comment>
        <translation>Scribus no fue capaz de guardar las preferencias:&lt;br&gt;%1&lt;br&gt;Por favor, comprueba los permisos del directorio y si hay espacio disponible en el disco.</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2470"/>
        <source>Error Loading Preferences</source>
        <translation>Error al cargar las preferencias</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2472"/>
        <source>Scribus was not able to load its preferences:&lt;br&gt;%1&lt;br&gt;Default settings will be loaded.</source>
        <translation>Scribus no fue capaz de cargar las preferencias:&lt;br&gt;%1&lt;br&gt;Las preferencias predeterminadas serán cargadas.</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2173"/>
        <source>No valid renderframe config found. Using defaults!</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PresetLayout</name>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="554"/>
        <source>Magazine</source>
        <translation>Magazine</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="555"/>
        <source>Fibonacci</source>
        <translation>Fibonacci</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="556"/>
        <source>Golden Mean</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="557"/>
        <source>Nine Parts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="553"/>
        <source>Gutenberg</source>
        <translation>Gutenberg</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="552"/>
        <source>None</source>
        <comment>layout type</comment>
        <translation>Ninguno</translation>
    </message>
    <message>
        <source>You can select a predefined page layout here. &apos;None&apos; leave margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins for same value. Leading is Left/Inside value.</source>
        <translation type="obsolete">Puedes seleccionar una disposición predeterminada de página aquí. &apos;Ninguna&apos; deja los márgenes tal cual, Gutenberg pone los márgenes de forma clásica. &apos;Magazine&apos; pone a todos los márgenes el mismo valor. El espaciado es el valor Derecha/Interior.</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="560"/>
        <source>When you have selected a Document Layout other than Single Page, you can select a predefined page layout here. &apos;None&apos; leaves margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins to the same value. Leading is Left/Inside value.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrintDialog</name>
    <message>
        <source>Setup Printer</source>
        <translation type="obsolete">Configuración de la impresora</translation>
    </message>
    <message>
        <source>Print Destination</source>
        <translation type="obsolete">Destino de la impresión</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="90"/>
        <location filename="../../../scribus/printdialog.cpp" line="112"/>
        <location filename="../../../scribus/printdialog.cpp" line="271"/>
        <location filename="../../../scribus/printdialog.cpp" line="303"/>
        <location filename="../../../scribus/printdialog.cpp" line="501"/>
        <location filename="../../../scribus/printdialog.cpp" line="583"/>
        <source>File</source>
        <translation>Archivo</translation>
    </message>
    <message>
        <source>&amp;Options...</source>
        <translation type="obsolete">&amp;Opciones</translation>
    </message>
    <message>
        <source>&amp;File:</source>
        <translation type="obsolete">&amp;Archivo</translation>
    </message>
    <message>
        <source>C&amp;hange...</source>
        <translation type="obsolete">Cam&amp;biar...</translation>
    </message>
    <message>
        <source>A&amp;lternative Printer Command</source>
        <translation type="obsolete">Comando de impresión a&amp;lternativo</translation>
    </message>
    <message>
        <source>Co&amp;mmand:</source>
        <translation type="obsolete">Co&amp;mando:</translation>
    </message>
    <message>
        <source>Range</source>
        <translation type="obsolete">Rango</translation>
    </message>
    <message>
        <source>Print &amp;All</source>
        <translation type="obsolete">Imprimir &amp;todo</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="391"/>
        <source>Print Current Pa&amp;ge</source>
        <translation>Imprimir &amp;página actual</translation>
    </message>
    <message>
        <source>Print &amp;Range</source>
        <translation type="obsolete">Imprimir el ran&amp;go</translation>
    </message>
    <message>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="obsolete">Inserta una lista de elementos separados por comas,
donde un elemento puede ser * para todas las páginas,
1-5 para un intervalo de páginas o un único número.</translation>
    </message>
    <message>
        <source>N&amp;umber of Copies:</source>
        <translation type="obsolete">N&amp;úmero de copias:</translation>
    </message>
    <message>
        <source>Options</source>
        <translation type="obsolete">Opciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="95"/>
        <location filename="../../../scribus/printdialog.cpp" line="293"/>
        <location filename="../../../scribus/printdialog.cpp" line="354"/>
        <location filename="../../../scribus/printdialog.cpp" line="465"/>
        <location filename="../../../scribus/printdialog.cpp" line="527"/>
        <source>All</source>
        <translation>Todos</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="95"/>
        <location filename="../../../scribus/printdialog.cpp" line="465"/>
        <location filename="../../../scribus/printdialog.cpp" line="526"/>
        <source>Cyan</source>
        <translation>Cian</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="95"/>
        <location filename="../../../scribus/printdialog.cpp" line="465"/>
        <location filename="../../../scribus/printdialog.cpp" line="525"/>
        <source>Magenta</source>
        <translation>Magenta</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="95"/>
        <location filename="../../../scribus/printdialog.cpp" line="465"/>
        <location filename="../../../scribus/printdialog.cpp" line="524"/>
        <source>Yellow</source>
        <translation>Amarillo</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="96"/>
        <location filename="../../../scribus/printdialog.cpp" line="465"/>
        <location filename="../../../scribus/printdialog.cpp" line="523"/>
        <source>Black</source>
        <translation>Negro</translation>
    </message>
    <message>
        <source>&amp;Print</source>
        <translation type="obsolete">&amp;Imprimir</translation>
    </message>
    <message>
        <source>Save as</source>
        <translation type="obsolete">Guardar como</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="291"/>
        <location filename="../../../scribus/printdialog.cpp" line="352"/>
        <source>Print Normal</source>
        <translation>Imprimir normal</translation>
    </message>
    <message>
        <source>Print Separations</source>
        <translation type="obsolete">Imprimir separadores</translation>
    </message>
    <message>
        <source>Print in Color if Available</source>
        <translation type="obsolete">Imprimir en color si disponible</translation>
    </message>
    <message>
        <source>Print in Grayscale</source>
        <translation type="obsolete">Imprimir en escala de grises</translation>
    </message>
    <message>
        <source>Page</source>
        <translation type="obsolete">Página</translation>
    </message>
    <message>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="obsolete">Reflejar página/s horizontales</translation>
    </message>
    <message>
        <source>Mirror Page(s) Vertical</source>
        <translation type="obsolete">Reflejar página/s verticales</translation>
    </message>
    <message>
        <source>Set Media Size</source>
        <translation type="obsolete">Establecer tamaño del medio</translation>
    </message>
    <message>
        <source>Color</source>
        <translation type="obsolete">Color</translation>
    </message>
    <message>
        <source>Apply Under Color Removal</source>
        <translation type="obsolete">Registrar eliminación de color</translation>
    </message>
    <message>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="obsolete">Convertir tintas planas para procesar el color</translation>
    </message>
    <message>
        <source>Advanced Options</source>
        <translation type="obsolete">Opciones avanzadas</translation>
    </message>
    <message>
        <source>Preview...</source>
        <translation type="obsolete">Vista previa...</translation>
    </message>
    <message>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="obsolete">Configura el nivel de PostScrit
 Configurando Level 1 ó 2 puede crear archivo enormes</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="377"/>
        <source>PostScript Files (*.ps);;All Files (*)</source>
        <translation>Archivos PostScript (*.ps);;Todos los archivos (*)</translation>
    </message>
    <message>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="obsolete">Usar un gestor de impresión alternativo, como kprinter o gtklp, para utilizar opciones de impresión adicionales</translation>
    </message>
    <message>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis.UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Un modo de desactivar algunas de las escalas de grises compuesta de cian, amarillo y magenta y usar en su lugar el negro. UCR principalmente afecta a las partes de las imágenes de color neutral y/o tonos oscuros que están próximos al gris. Usar esta opción podria mejorar la impresión de ciertas imágenes pero se necesita experimentación y comprobación de caso por caso. UCR reduce la posibilidad de sobresaturación con tintas CMY.</translation>
    </message>
    <message>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="obsolete">Activa la conversión de colores de tinta plana a colores de composición. A menos que estés planeando imprimir colores planos en una impresora comercial, probablemente es mejor dejarlo marcado.</translation>
    </message>
    <message>
        <source>This enables you to explicitely set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="obsolete">Te permite indicar el tamaño del medio del archivo PostScript explícitamente. No recomendado a menos que sea requerido por la imprenta.</translation>
    </message>
    <message>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Ajustarse a márgenes de página</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="312"/>
        <source>Failed to retrieve printer settings</source>
        <translation>Error al obtener la configuración de la impresora</translation>
    </message>
    <message>
        <source>Do not show objects outside the margins on the printed page</source>
        <translation type="obsolete">No mostrar objetos fuera de los márgenes de la página impresa</translation>
    </message>
    <message>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Forzar modo de sobreimpresión</translation>
    </message>
    <message>
        <source>Enables global Overprint Mode for this document, overrides object settings</source>
        <translation type="obsolete">Activa el modo global de sobreimpresión, sobreescribe las configuraciones de los objetos</translation>
    </message>
    <message>
        <source>Printer Marks</source>
        <translation type="obsolete">Marcas de impresión</translation>
    </message>
    <message>
        <source>Crop Marks</source>
        <translation type="obsolete">Marcas de recorte</translation>
    </message>
    <message>
        <source>Bleed Marks</source>
        <translation type="obsolete">Marcas de sangría</translation>
    </message>
    <message>
        <source>Registration Marks</source>
        <translation type="obsolete">Marcas de registro</translation>
    </message>
    <message>
        <source>Color Bars</source>
        <translation type="obsolete">Barras de color</translation>
    </message>
    <message>
        <source>Offset:</source>
        <translation type="obsolete">Desplazamiento:</translation>
    </message>
    <message>
        <source>Marks</source>
        <translation type="obsolete">Marcas</translation>
    </message>
    <message>
        <source>Bleed Settings</source>
        <translation type="obsolete">Configuración de sangría</translation>
    </message>
    <message>
        <source>Top:</source>
        <translation type="obsolete">Superior:</translation>
    </message>
    <message>
        <source>Bottom:</source>
        <translation type="obsolete">Inferior:</translation>
    </message>
    <message>
        <source>Left:</source>
        <translation type="obsolete">Izquierda:</translation>
    </message>
    <message>
        <source>Right:</source>
        <translation type="obsolete">Derecha:</translation>
    </message>
    <message>
        <source>Use Document Bleeds</source>
        <translation type="obsolete">Usar sangría del documento</translation>
    </message>
    <message>
        <source>Bleeds</source>
        <translation type="obsolete">Sangría</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="105"/>
        <source>Inside:</source>
        <translation>Interior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="106"/>
        <source>Outside:</source>
        <translation>Exterior:</translation>
    </message>
    <message>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="obsolete">Distancia del margen desde el extremo superior de la página real</translation>
    </message>
    <message>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="obsolete">Distancia del margen desde el extremo inferior de la página real</translation>
    </message>
    <message>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="obsolete">Distancia del margen desde el extremo izquierdo de la página real</translation>
    </message>
    <message>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="obsolete">Distancia del margen desde el extremo derecho de la página real</translation>
    </message>
    <message>
        <source>This creates crop marks in the PDF indicating where the paper should be cut or trimmed after printing</source>
        <translation type="obsolete">Esta opción crea marcas de recorte en el PDF indicando por dónde deberia ser recortado o guillotinado el papel después de la impresión</translation>
    </message>
    <message>
        <source>This creates bleed marks which are indicated by  _ . _ and show the bleed limit</source>
        <translation type="obsolete">Esto crea marcas de sangría indicadas por  _ . _ y muestra los límites de la sangría</translation>
    </message>
    <message>
        <source>Add registration marks which are added to each separation</source>
        <translation type="obsolete">Añadir marcas de registro a cada separación</translation>
    </message>
    <message>
        <source>Add color calibration bars</source>
        <translation type="obsolete">Añadir barra de calibración del color</translation>
    </message>
    <message>
        <source>Indicate the distance offset for the registration marks</source>
        <translation type="obsolete">Indicar la distancia de desplazamiento para las marcas de registro</translation>
    </message>
    <message>
        <source>Use the existing bleed settings from the document preferences</source>
        <translation type="obsolete">Usar la configuración existente de sangría de las preferencias del documento</translation>
    </message>
    <message>
        <source>Apply Color Profiles</source>
        <translation type="obsolete">Aplicar perfiles de color</translation>
    </message>
    <message>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="obsolete">Te permite incrustar perfiles de color en el flujo de impresión cuando la gestión de color está activada</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="377"/>
        <source>Save As</source>
        <translation type="unfinished">Guardar como</translation>
    </message>
</context>
<context>
    <name>PrintDialogBase</name>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="14"/>
        <source>Setup Printer</source>
        <translation type="unfinished">Configuración de la impresora</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="23"/>
        <source>Print Destination</source>
        <translation type="unfinished">Destino de la impresión</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="50"/>
        <source>&amp;Options...</source>
        <translation type="unfinished">&amp;Opciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="86"/>
        <source>&amp;File:</source>
        <translation type="unfinished">&amp;Archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="102"/>
        <source>C&amp;hange...</source>
        <translation type="unfinished">Cam&amp;biar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="117"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="unfinished">Usar un gestor de impresión alternativo, como kprinter o gtklp, para utilizar opciones de impresión adicionales</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="120"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="unfinished">Comando de impresión a&amp;lternativo</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="138"/>
        <source>Co&amp;mmand:</source>
        <translation type="unfinished">Co&amp;mando:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="160"/>
        <source>Range</source>
        <translation type="unfinished">Rango</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="172"/>
        <source>Print &amp;All</source>
        <translation type="unfinished">Imprimir &amp;todo</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="192"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="unfinished">N&amp;úmero de copias:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="212"/>
        <source>Print Current Pa&amp;ge</source>
        <translation type="unfinished">Imprimir &amp;página actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="219"/>
        <source>Print &amp;Range</source>
        <translation type="unfinished">Imprimir el ran&amp;go</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="229"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="unfinished">Inserta una lista de elementos separados por comas,
donde un elemento puede ser * para todas las páginas,
1-5 para un intervalo de páginas o un único número.</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="274"/>
        <source>Options</source>
        <translation type="unfinished">Opciones</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="281"/>
        <source>Print Normal</source>
        <translation type="unfinished">Imprimir normal</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="286"/>
        <source>Print Separations</source>
        <translation type="unfinished">Imprimir separadores</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="295"/>
        <source>Print in Color if Available</source>
        <translation type="unfinished">Imprimir en color si disponible</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="300"/>
        <source>Print in Grayscale</source>
        <translation type="unfinished">Imprimir en escala de grises</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="315"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="unfinished">Configura el nivel de PostScrit
 Configurando Level 1 ó 2 puede crear archivo enormes</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="335"/>
        <source>Advanced Options</source>
        <translation type="unfinished">Opciones avanzadas</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="341"/>
        <source>Page</source>
        <translation type="unfinished">Página</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="347"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="unfinished">Reflejar página/s horizontales</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="354"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="unfinished">Reflejar página/s verticales</translation>
    </message>
    <message>
        <source>This enables you to explicitely set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="obsolete">Te permite indicar el tamaño del medio del archivo PostScript explícitamente. No recomendado a menos que sea requerido por la imprenta.</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="364"/>
        <source>Set Media Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="381"/>
        <source>Color</source>
        <translation type="unfinished">Color</translation>
    </message>
    <message>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis.UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Un modo de desactivar algunas de las escalas de grises compuesta de cian, amarillo y magenta y usar en su lugar el negro. UCR principalmente afecta a las partes de las imágenes de color neutral y/o tonos oscuros que están próximos al gris. Usar esta opción podria mejorar la impresión de ciertas imágenes pero se necesita experimentación y comprobación de caso por caso. UCR reduce la posibilidad de sobresaturación con tintas CMY.</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="390"/>
        <source>Apply Under Color Removal</source>
        <translation type="unfinished">Registrar eliminación de color</translation>
    </message>
    <message>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="obsolete">Activa la conversión de colores de tinta plana a colores de composición. A menos que estés planeando imprimir colores planos en una impresora comercial, probablemente es mejor dejarlo marcado.</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="400"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="unfinished">Convertir tintas planas para procesar el color</translation>
    </message>
    <message>
        <source>Enables global Overprint Mode for this document, overrides object settings</source>
        <translation type="obsolete">Activa el modo global de sobreimpresión, sobreescribe las configuraciones de los objetos</translation>
    </message>
    <message>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Forzar modo de sobreimpresión</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="361"/>
        <source>&lt;qt&gt;This enables you to explicitly set the media size of the PostScript file. Not recommended unless requested by your printer.&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="387"/>
        <source>&lt;qt&gt;A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. Under Color Removal mostly affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. Under Color Removal reduces the possibility of over saturation with CMY inks.&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="397"/>
        <source>&lt;qt&gt;Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="407"/>
        <source>&lt;qt&gt;Allows you to embed color profiles in the print stream when color management is enabled&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="410"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished">Aplicar perfiles de color</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="437"/>
        <source>Marks</source>
        <translation type="unfinished">Marcas</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="443"/>
        <source>This creates crop marks in the PDF indicating where the paper should be cut or trimmed after printing</source>
        <translation type="unfinished">Esta opción crea marcas de recorte en el PDF indicando por dónde deberia ser recortado o guillotinado el papel después de la impresión</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="446"/>
        <source>Crop Marks</source>
        <translation type="unfinished">Marcas de recorte</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="453"/>
        <source>Add registration marks which are added to each separation</source>
        <translation type="unfinished">Añadir marcas de registro a cada separación</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="456"/>
        <source>Registration Marks</source>
        <translation type="unfinished">Marcas de registro</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="463"/>
        <source>This creates bleed marks which are indicated by  _ . _ and show the bleed limit</source>
        <translation type="unfinished">Esto crea marcas de sangría indicadas por  _ . _ y muestra los límites de la sangría</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="466"/>
        <source>Bleed Marks</source>
        <translation type="unfinished">Marcas de sangría</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="473"/>
        <source>Add color calibration bars</source>
        <translation type="unfinished">Añadir barra de calibración del color</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="476"/>
        <source>Color Bars</source>
        <translation type="unfinished">Barras de color</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="485"/>
        <source>Offset:</source>
        <translation type="unfinished">Desplazamiento:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="492"/>
        <source>Indicate the distance offset for the registration marks</source>
        <translation type="unfinished">Indicar la distancia de desplazamiento para las marcas de registro</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="515"/>
        <source>Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="521"/>
        <source>Top:</source>
        <translation type="unfinished">Superior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="528"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="535"/>
        <source>Left:</source>
        <translation type="unfinished">Izquierda:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="542"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="549"/>
        <source>Bottom:</source>
        <translation type="unfinished">Inferior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="556"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="563"/>
        <source>Right:</source>
        <translation type="unfinished">Derecha:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="570"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="577"/>
        <source>Use the existing bleed settings from the document preferences</source>
        <translation type="unfinished">Usar la configuración existente de sangría de las preferencias del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="580"/>
        <source>Use Document Bleeds</source>
        <translation type="unfinished">Usar sangría del documento</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="606"/>
        <source>Preview...</source>
        <translation type="unfinished">Vista previa...</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="616"/>
        <source>&amp;Print</source>
        <translation type="unfinished">&amp;Imprimir</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="626"/>
        <source>Cancel</source>
        <translation type="unfinished">Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="323"/>
        <source>Include PDF Annotations and Links into the output.
Note: PDF Forms will not be exported.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="327"/>
        <source>Include PDF Annotations and Links</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="371"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Un modo de desactivar algunas de las escalas de grises compuesta de cian, amarillo y magenta y usar en su lugar el negro. UCR principalmente afecta a las partes de las imágenes de color neutral y/o tonos oscuros que están próximos al gris. Usar esta opción podria mejorar la impresión de ciertas imágenes pero se necesita experimentación y comprobación de caso por caso. UCR reduce la posibilidad de sobresaturación con tintas CMY.</translation>
    </message>
</context>
<context>
    <name>PropertiesPalette</name>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5256"/>
        <source>Properties</source>
        <translation>Propiedades</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5258"/>
        <source>X, Y, &amp;Z</source>
        <translation>X, Y, &amp;Z</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5261"/>
        <source>&amp;Shape</source>
        <translation>&amp;Forma</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5259"/>
        <source>&amp;Text</source>
        <translation>&amp;Texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5260"/>
        <source>&amp;Image</source>
        <translation>&amp;Imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5262"/>
        <source>&amp;Line</source>
        <translation>&amp;Línea</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5263"/>
        <source>&amp;Colors</source>
        <translation>&amp;Colores</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5266"/>
        <source>Name</source>
        <translation>Nombre:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5267"/>
        <source>Geometry</source>
        <translation>Geometría</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5474"/>
        <source> pt</source>
        <translation> pt</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1959"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2336"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2457"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2552"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4136"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5268"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5383"/>
        <source>&amp;X-Pos:</source>
        <translation>Posición &amp;X:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1961"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2338"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2459"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2554"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4138"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5269"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5384"/>
        <source>&amp;Y-Pos:</source>
        <translation>Posicón &amp;Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1960"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2337"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2458"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2553"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4137"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5270"/>
        <source>&amp;Width:</source>
        <translation>Anc&amp;hura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1962"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2339"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2460"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2555"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4139"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5271"/>
        <source>&amp;Height:</source>
        <translation>Al&amp;tura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5272"/>
        <source>&amp;Rotation:</source>
        <translation>&amp;Rotación:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5273"/>
        <source>Basepoint:</source>
        <translation>Punto base:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5274"/>
        <source>Level</source>
        <translation>Nivel</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5275"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5280"/>
        <source>Shape:</source>
        <translation>Forma:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5302"/>
        <source>R&amp;ound
Corners:</source>
        <translation>Esquinas &amp;redondeadas:</translation>
    </message>
    <message>
        <source>Distance of Text</source>
        <translation type="obsolete">Distancia del texto:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5303"/>
        <source>Colu&amp;mns:</source>
        <translation>Colu&amp;mnas:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5310"/>
        <source>To&amp;p:</source>
        <translation>&amp;Superior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5311"/>
        <source>&amp;Bottom:</source>
        <translation>I&amp;nferior:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5312"/>
        <source>&amp;Left:</source>
        <translation>Iz&amp;quierda:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5313"/>
        <source>&amp;Right:</source>
        <translation>&amp;Derecha:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5314"/>
        <source>T&amp;abulators...</source>
        <translation>Ta&amp;buladores...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1058"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5378"/>
        <source>Path Text Properties</source>
        <translation>Propiedades del texto sobre trazado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5323"/>
        <source>Show Curve</source>
        <translation>Mostrar curva</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5325"/>
        <source>Start Offset:</source>
        <translation>Desplazamiento inicial:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5326"/>
        <source>Distance from Curve:</source>
        <translation>Distancia desde curva:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5333"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5339"/>
        <source>Use &amp;Bounding Box</source>
        <translation>Usar cuadro circ&amp;unscrito</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5334"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5340"/>
        <source>&amp;Use Contour Line</source>
        <translation>Usar línea de c&amp;ontorno</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5460"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5380"/>
        <source>&amp;Free Scaling</source>
        <translation>Escalado li&amp;bre</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5385"/>
        <source>X-Sc&amp;ale:</source>
        <translation>Esc&amp;ala en X:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5386"/>
        <source>Y-Scal&amp;e:</source>
        <translation>&amp;Escalar en Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5387"/>
        <source>Scale &amp;To Frame Size</source>
        <translation>Escalar al tamaño del &amp;marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5388"/>
        <source>P&amp;roportional</source>
        <translation>&amp;Proporcional</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5391"/>
        <source>Input Profile:</source>
        <translation>Perfil de entrada:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5392"/>
        <source>Rendering Intent:</source>
        <translation>Modo de visualización:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5405"/>
        <source>Perceptual</source>
        <translation>Perceptivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5299"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5407"/>
        <source>Saturation</source>
        <translation>Saturación</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5417"/>
        <source>Left Point</source>
        <translation>Punto izquierdo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5418"/>
        <source>End Points</source>
        <translation>Extremos</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5420"/>
        <source>&amp;Basepoint:</source>
        <translation>P&amp;unto base:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5421"/>
        <source>T&amp;ype of Line:</source>
        <translation>Ti&amp;po de línea:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5433"/>
        <source>Line &amp;Width:</source>
        <translation>&amp;Ancho de linea:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5437"/>
        <source>Miter Join</source>
        <translation>Unión de inglete</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5438"/>
        <source>Bevel Join</source>
        <translation>Unión biselada</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5439"/>
        <source>Round Join</source>
        <translation>Unión redondeada</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5434"/>
        <source>Ed&amp;ges:</source>
        <translation>&amp;Bordes:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5444"/>
        <source>Flat Cap</source>
        <translation>Plano</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5445"/>
        <source>Square Cap</source>
        <translation>Cuadrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5446"/>
        <source>Round Cap</source>
        <translation>Redondeado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5448"/>
        <source>&amp;Endings:</source>
        <translation>&amp;Extremos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="4765"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5501"/>
        <source>No Style</source>
        <translation>Sin estilo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5450"/>
        <source>Cell Lines</source>
        <translation>Bordes de celda</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5451"/>
        <source>Line at Top</source>
        <translation>Borde superior</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5452"/>
        <source>Line at the Left</source>
        <translation>Borde izquierdo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5453"/>
        <source>Line at the Right </source>
        <translation>Borde derecho</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5454"/>
        <source>Line at Bottom</source>
        <translation>Borde inferior</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5596"/>
        <source>Name of selected object</source>
        <translation>Nombre del objeto seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5597"/>
        <source>Horizontal position of current basepoint</source>
        <translation>Posición horizontal del punto base actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5598"/>
        <source>Vertical position of current basepoint</source>
        <translation>Posición vertical del punto base actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5599"/>
        <source>Width</source>
        <translation>Anchura</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5600"/>
        <source>Height</source>
        <translation>Altura</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5601"/>
        <source>Rotation of object at current basepoint</source>
        <translation>Rotación del objeto sobre el punto base actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5602"/>
        <source>Point from which measurements or rotation angles are referenced</source>
        <translation>Punto de referencia para las medidas o ángulos de rotación</translation>
    </message>
    <message>
        <source>Select top left for basepoint</source>
        <translation type="obsolete">Seleccionar la esquina superior izquierda como punto base</translation>
    </message>
    <message>
        <source>Select top right for basepoint</source>
        <translation type="obsolete">Seleccionar la esquina superior derecha como punto base</translation>
    </message>
    <message>
        <source>Select bottom left for basepoint</source>
        <translation type="obsolete">Seleccionar la esquina inferior izquierda como punto base</translation>
    </message>
    <message>
        <source>Select bottom right for basepoint</source>
        <translation type="obsolete">Seleccionar la esquina inferior derecha como punto base</translation>
    </message>
    <message>
        <source>Select center for basepoint</source>
        <translation type="obsolete">Seleccionar el centro como punto base</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5610"/>
        <source>Flip Horizontal</source>
        <translation>Voltear horizontalmente</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5611"/>
        <source>Flip Vertical</source>
        <translation>Voltear verticalmente</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5612"/>
        <source>Move one level up</source>
        <translation>Subir un nivel</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5613"/>
        <source>Move one level down</source>
        <translation>Bajar un nivel</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5614"/>
        <source>Move to front</source>
        <translation>Traer al frente</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5615"/>
        <source>Move to back</source>
        <translation>Enviar al fondo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5616"/>
        <source>Indicates the level the object is on, 0 means the object is at the bottom</source>
        <translation>Indica en qué nivel está el objeto, 0 significa que está debajo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5617"/>
        <source>Lock or unlock the object</source>
        <translation>Bloquear o desbloquear el objeto</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5618"/>
        <source>Lock or unlock the size of the object</source>
        <translation>Bloquear o desbloquear el tamaño del objeto</translation>
    </message>
    <message>
        <source>Font of selected text or object</source>
        <translation type="obsolete">Tipografía del texto u objeto seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5635"/>
        <source>Font Size</source>
        <translation>Tamaño de la tipografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5637"/>
        <source>Scaling width of characters</source>
        <translation>Escalar la anchura de los caracteres</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5641"/>
        <source>Saturation of color of text stroke</source>
        <translation>Saturación del color de trazo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5642"/>
        <source>Saturation of color of text fill</source>
        <translation>Saturación del color de relleno</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5643"/>
        <source>Right to Left Writing</source>
        <translation>Escritura de Izquierda a Derecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="838"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5376"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5645"/>
        <source>Line Spacing</source>
        <translation>Interlineado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5664"/>
        <source>Change settings for left or end points</source>
        <translation>Cambiar configuraciones para el punto izquierdo o los extremos</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5665"/>
        <source>Pattern of line</source>
        <translation>Patrón de línea</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5666"/>
        <source>Thickness of line</source>
        <translation>Grosor de línea</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5667"/>
        <source>Type of line joins</source>
        <translation>Tipo de uniones de las líneas</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5668"/>
        <source>Type of line end</source>
        <translation>Tipo de extremos</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5669"/>
        <source>Line style of current object</source>
        <translation>Estilo de línea del objeto</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5673"/>
        <source>Choose the shape of frame...</source>
        <translation>Elegir la forma del marco...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5674"/>
        <source>Edit shape of the frame...</source>
        <translation>Editar la forma del marco...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5675"/>
        <source>Set radius of corner rounding</source>
        <translation>Definir el radio de las esquinas redondeadas</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5676"/>
        <source>Number of columns in text frame</source>
        <translation>Número de columnas de texto del marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5677"/>
        <source>Switches between Gap or Column width</source>
        <translation>Cambia entre espacio o ancho de las columnas</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="3900"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5678"/>
        <source>Distance between columns</source>
        <translation>Distancia entre columnas</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5620"/>
        <source>This rule determines the &amp;quot;insideness&amp;quot; of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses. If this number is odd, the point is inside, if even, the point is outside.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5621"/>
        <source>This rule determines the &amp;quot;insideness&amp;quot; of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray. Starting with a count of zero, add one each time a path segment crosses the ray from left to right and subtract one each time a path segment crosses the ray from right to left. If the result is zero then the point is outside the path. Otherwise, it is inside.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5625"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5630"/>
        <source>Use the bounding box, which is always rectangular, instead of the frame&apos;s shape for text flow of text frames below the object.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5626"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5631"/>
        <source>When chosen, the contour line can be edited with the Edit Shape Tool on the palette further above. When edited via the shape palette, this becomes a second separate line originally based on the frame&apos;s shape for text flow of text frames below the object.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5627"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5632"/>
        <source>Use the clipping path of the image.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5679"/>
        <source>Distance of text from top of frame</source>
        <translation>Distancia del texto desde el extremo superior</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5680"/>
        <source>Distance of text from bottom of frame</source>
        <translation>Distancia del texto desde el extremo inferior</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5681"/>
        <source>Distance of text from left of frame</source>
        <translation>Distancia del texto desde el extremo izquierdo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5682"/>
        <source>Distance of text from right of frame</source>
        <translation>Distancia del texto desde el extremo derecho</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5683"/>
        <source>Edit tab settings of text frame...</source>
        <translation>Editar las configuraciones de los tabuladores...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5685"/>
        <source>Allow the image to be a different size to the frame</source>
        <translation>Permite que la imagen sea de un tamaño distinto al del marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5686"/>
        <source>Horizontal offset of image within frame</source>
        <translation>Desplazamiento horizontal de la imagen dentro del marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5687"/>
        <source>Vertical offset of image within frame</source>
        <translation>Desplazamiento vertical de la imagen dentro del marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5688"/>
        <source>Resize the image horizontally</source>
        <translation>Redimensionar la imagen horizontalmente</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5689"/>
        <source>Resize the image vertically</source>
        <translation>Redimensionar la imagen verticalmente</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5690"/>
        <source>Keep the X and Y scaling the same</source>
        <translation>Mantener la escala en X e Y igual</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5691"/>
        <source>Keep the aspect ratio</source>
        <translation>Mantener la proporción</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5692"/>
        <source>Make the image fit within the size of the frame</source>
        <translation>Hacer que la imagen encaje dentro del marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5695"/>
        <source>Use image proportions rather than those of the frame</source>
        <translation>Usar proporciones de la imagen en vez de las del marco</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5696"/>
        <source>Source profile of the image</source>
        <translation>Perfil de entrada de la imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5697"/>
        <source>Rendering intent for the image</source>
        <translation>Modo de representación de la imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="2328"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4146"/>
        <source>&amp;X1:</source>
        <translation>&amp;X1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="2329"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4147"/>
        <source>X&amp;2:</source>
        <translation>X&amp;2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="2330"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4148"/>
        <source>Y&amp;1:</source>
        <translation>Y&amp;1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="2331"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4149"/>
        <source>&amp;Y2:</source>
        <translation>&amp;Y2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="3902"/>
        <source>Column width</source>
        <translation>Anchura de las columnas</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5406"/>
        <source>Relative Colorimetric</source>
        <translation>Colorimetría relativa</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5408"/>
        <source>Absolute Colorimetric</source>
        <translation>Colorimetría absoluta</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5644"/>
        <source>Manual Tracking</source>
        <translation>Espacio entre caracteres manual</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5399"/>
        <source>Fixed Linespacing</source>
        <translation>Interlineado exacto</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5400"/>
        <source>Automatic Linespacing</source>
        <translation>Interlinado automático</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5401"/>
        <source>Align to Baseline Grid</source>
        <translation>Alinear a rejilla de línea base</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5381"/>
        <source>Actual X-DPI:</source>
        <translation>DPI-X actual:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5382"/>
        <source>Actual Y-DPI:</source>
        <translation>DPI-Y actual:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5422"/>
        <source>Start Arrow:</source>
        <translation>Flecha inicial:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5423"/>
        <source>End Arrow:</source>
        <translation>Flecha final:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5636"/>
        <source>Offset to baseline of characters</source>
        <translation>Desplazamiento de la línea de base de los caracteres</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5638"/>
        <source>Scaling height of characters</source>
        <translation>Altura de escalado de los caracteres</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5115"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation>El nombre &quot;%1&quot; no es único.&lt;br /&gt;Por favor, elige otro.</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5327"/>
        <source>Fill Rule</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5328"/>
        <source>Even-Odd</source>
        <translation>Pares-Impares</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5329"/>
        <source>Non Zero</source>
        <translation>No cero</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5456"/>
        <source>Overprinting</source>
        <translation>Sobreimpresión</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5457"/>
        <source>Knockout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5458"/>
        <source>Overprint</source>
        <translation>Sobreimprimir</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5639"/>
        <source>Color of text stroke and/or drop shadow, depending which is chosen.If both are chosen, then they share the same color.</source>
        <translation>Color del contorno del texto y/o de la sombra, depende de lo elegido. Si ambos son elegidos, entonces ambos comparten el mismo color.</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5640"/>
        <source>Color of selected text. If Outline text decoration is enabled, this color will be the fill color. If Drop Shadow Text is enabled, then this will be the top most color.</source>
        <translation type="unfinished">Color del texto seleccionado. Si la decoración del contorno de texto está activada, este color será el color de relleno. Si la sombra de texto está activada, entonces este será el color mayoritario.</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5306"/>
        <source>Gap:</source>
        <translation>Espaciado:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5307"/>
        <source>Width:</source>
        <translation>Anchura:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5330"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5336"/>
        <source>Text &amp;Flow Around Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5331"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5337"/>
        <source>Disabled</source>
        <translation>Desactivado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5332"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5338"/>
        <source>Use Frame &amp;Shape</source>
        <translation>Usar marco &amp;forma</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5389"/>
        <source>Image Effects</source>
        <translation>Efectos de imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5390"/>
        <source>Extended Image Properties</source>
        <translation>Propiedades de imagen extendidas</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5623"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5628"/>
        <source>Disable text flow from lower frames around object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5624"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5629"/>
        <source>Use the frame shape for text flow of text frames below the object.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="673"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5281"/>
        <source>Transparency Settings</source>
        <translation>Configuracion de la transparencia</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5264"/>
        <source>&amp;Group</source>
        <translation>Agr&amp;upar</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5282"/>
        <source>Opacity:</source>
        <translation>Opacidad:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5283"/>
        <source>Blend Mode:</source>
        <translation>Modo de fusión:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5286"/>
        <source>Normal</source>
        <translation>Normal</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5287"/>
        <source>Darken</source>
        <translation>Oscurecer</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5288"/>
        <source>Lighten</source>
        <translation>Aclarar</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5289"/>
        <source>Multiply</source>
        <translation>Multiplicar</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5290"/>
        <source>Screen</source>
        <translation>Trama</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5291"/>
        <source>Overlay</source>
        <translation>Superponer</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5292"/>
        <source>Hard Light</source>
        <translation>Luz dura</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5293"/>
        <source>Soft Light</source>
        <translation>Luz suave</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5294"/>
        <source>Difference</source>
        <translation>Diferencia</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5295"/>
        <source>Exclusion</source>
        <translation>Exclusión</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5296"/>
        <source>Color Dodge</source>
        <translation>Sobreexponer color</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5297"/>
        <source>Color Burn</source>
        <translation>Subexponer color</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5298"/>
        <source>Hue</source>
        <translation>Tono</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5300"/>
        <source>Color</source>
        <translation>Color</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5608"/>
        <source>Group the selected objects</source>
        <translation>Agrupar los objetos seleccionados</translation>
    </message>
    <message>
        <source>Destroys the selected group</source>
        <translation type="obsolete">Destruye el grupo seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1269"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="3211"/>
        <source>Auto</source>
        <translation>Auto</translation>
    </message>
    <message>
        <source>Click and hold down to select the line spacing mode.</source>
        <translation type="obsolete">Haz clic y mantén para seleccionar el modo de interlineado.</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5318"/>
        <source>Default</source>
        <translation>Por defecto</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5319"/>
        <source>Stair Step</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5320"/>
        <source>Skew</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5322"/>
        <source>Flip Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5324"/>
        <source>Type:</source>
        <translation>Tipo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5335"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5341"/>
        <source>Use Image Clip Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5342"/>
        <source>Paragraph St&amp;yle:</source>
        <translation>Est&amp;ilo de párrafo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5343"/>
        <source>Character St&amp;yle:</source>
        <translation>Est&amp;ilo de carácter:</translation>
    </message>
    <message>
        <source>Optical Margins:</source>
        <translation type="obsolete">Márgenes ópticos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5364"/>
        <source>Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5365"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5368"/>
        <source>Min:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5366"/>
        <source>Norm:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5367"/>
        <source>Glyph Extension</source>
        <translation>Caracteres extendidos</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5369"/>
        <source>Max:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5648"/>
        <source>Paragraph style of currently selected text or paragraph</source>
        <translation>Estilo de párrafo del texto o párrafo seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5649"/>
        <source>Character style of currently selected text or paragraph</source>
        <translation>Estilo de carácter del texto o párrafo seleccionado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5650"/>
        <source>Remove Direct Paragraph Formatting</source>
        <translation>Eliminar formateo de párrafo directo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5651"/>
        <source>Remove Direct Character Formatting</source>
        <translation>Eliminar formateo de carácter directo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5658"/>
        <source>Minimal width of spaces between words</source>
        <translation>Mínima anchura de espacios entre palabras</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5659"/>
        <source>Normal width of spaces between words</source>
        <translation>Anchura normal de espacios entre palabras</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5660"/>
        <source>Minimal shrinkage of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5661"/>
        <source>Maximal extension of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5619"/>
        <source>Enable or disable exporting of the object</source>
        <translation>Activar o desactivar exportación del objeto</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1397"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5413"/>
        <source>Custom</source>
        <translation>Personalizado</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5278"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5279"/>
        <source>&amp;Edit...</source>
        <translation>&amp;Editar...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="846"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5373"/>
        <source>First Line Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="836"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5374"/>
        <source>Maximum Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="837"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5375"/>
        <source>Font Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="798"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5370"/>
        <source>Color &amp; Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1022"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5371"/>
        <source>Advanced Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="829"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5372"/>
        <source>Style Settings</source>
        <translation type="unfinished">Configuración de estilo</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="3213"/>
        <source>Baseline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5609"/>
        <source>Ungroup the selected group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5647"/>
        <source>Select the line spacing mode.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5654"/>
        <source>Set the height of the first line of the text frame to use the tallest height of the included characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5655"/>
        <source>Set the height of the first line of text frame to use the full ascent of the font(s) in use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5656"/>
        <source>Set the height of the first line of the text frame to the specified line height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5379"/>
        <source>&amp;Page Number:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="902"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5377"/>
        <source>Columns &amp; Text Distances</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="940"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5362"/>
        <source>Reset</source>
        <translation type="unfinished">Reiniciar</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="949"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5363"/>
        <source>Optical Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5483"/>
        <source>Hairline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="936"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5358"/>
        <source>None</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="937"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5359"/>
        <source>Both Sides</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="938"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5360"/>
        <source>Left Only</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="939"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5361"/>
        <source>Right Only</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5670"/>
        <source>Arrow head style for start of line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5671"/>
        <source>Arrow head style for end of line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5693"/>
        <source>Effective horizontal DPI of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5694"/>
        <source>Effective vertical DPI of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PythonConsole</name>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="93"/>
        <source>&amp;Open...</source>
        <translation>&amp;Abrir...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="98"/>
        <source>&amp;Save</source>
        <translation>&amp;Guardar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="103"/>
        <source>Save &amp;As...</source>
        <translation>Gu&amp;ardar como...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="71"/>
        <source>&amp;File</source>
        <translation>&amp;Archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="113"/>
        <source>&amp;Run</source>
        <translation>&amp;Ejecutar</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="118"/>
        <source>Run As &amp;Console</source>
        <translation>Ejecutar en &amp;consola</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="123"/>
        <source>&amp;Save Output...</source>
        <translation>&amp;Guardar salida...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="81"/>
        <source>&amp;Script</source>
        <translation>&amp;Script</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="60"/>
        <source>Scribus Python Console</source>
        <translation>Consola de Python de Scribus</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="13"/>
        <source>Script Console</source>
        <translation>Consola de Script</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="122"/>
        <source>Write your commands here. A selection is processed as script</source>
        <translation>Escribe tus comandos aquí. Una selección se procesa como script</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="123"/>
        <source>Output of your script</source>
        <translation>Salida del script</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="133"/>
        <source>Another script is already running...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="134"/>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="149"/>
        <source>Please let it finish its task...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="148"/>
        <source>
&gt;&gt;&gt; Another script is already running...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="225"/>
        <source>Save the Python Commands in File</source>
        <translation>Guardar los comandos Python en archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="254"/>
        <source>Text Files (*.txt)</source>
        <translation>Archivos de texto (*.txt)</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="252"/>
        <source>Save Current Output</source>
        <translation>Guardar salida actual</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="183"/>
        <source>Open Python Script File</source>
        <translation>Abrir archivo script Python</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="185"/>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="227"/>
        <source>Python Scripts (*.py *.PY)</source>
        <translation>Scripts Python (*.py *.PY)</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="34"/>
        <source>Col: %1 Row: %2/%3</source>
        <translation>Columna: %1 Fila: %2/%3</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="45"/>
        <source>Ctrl+O</source>
        <translation>Ctrl+O</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="46"/>
        <source>Ctrl+S</source>
        <translation>Ctrl+S</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="108"/>
        <source>&amp;Quit</source>
        <translation>&amp;Salir</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="62"/>
        <source>This is a standard Python console with some 
known limitations. Please consult the Scribus 
Scripter documentation for futher information. </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QColorDialog</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="134"/>
        <source>Hu&amp;e:</source>
        <translation>T&amp;ono:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="135"/>
        <source>&amp;Sat:</source>
        <translation>&amp;Sat:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="136"/>
        <source>&amp;Val:</source>
        <translation>Va&amp;l:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="137"/>
        <source>&amp;Red:</source>
        <translation>&amp;Rojo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="138"/>
        <source>&amp;Green:</source>
        <translation>&amp;Verde:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="139"/>
        <source>Bl&amp;ue:</source>
        <translation>A&amp;zul:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="140"/>
        <source>A&amp;lpha channel:</source>
        <translation>Canal al&amp;fa:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="141"/>
        <source>&amp;Basic colors</source>
        <translation>Colores &amp;básicos</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="142"/>
        <source>&amp;Custom colors</source>
        <translation>Colores &amp;propios</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="143"/>
        <source>&amp;Define Custom Colors &gt;&gt;</source>
        <translation>&amp;Definir colores propios &gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="144"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="145"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="146"/>
        <source>&amp;Add to Custom Colors</source>
        <translation>&amp;Añadir a colores propios</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="147"/>
        <source>Select color</source>
        <translation>Seleccionar color</translation>
    </message>
</context>
<context>
    <name>QFileDialog</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="14"/>
        <source>Copy or Move a File</source>
        <translation>Copiar o mover un archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="17"/>
        <source>File &amp;name:</source>
        <translation>&amp;Nombre del fichero:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="18"/>
        <source>File &amp;type:</source>
        <translation>&amp;Tipo de fichero:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="19"/>
        <source>Files of type:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="20"/>
        <source>One directory up</source>
        <translation>Subir un directorio</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="21"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="22"/>
        <source>All Files (*)</source>
        <translation>Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="23"/>
        <source>Name</source>
        <translation>Nombre</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="24"/>
        <source>Size</source>
        <translation>Tamaño</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="25"/>
        <source>Type</source>
        <translation>Tipo</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="26"/>
        <source>Date</source>
        <translation>Fecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="27"/>
        <source>Attributes</source>
        <translation>Atributos</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="28"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="29"/>
        <source>Look &amp;in:</source>
        <translation>Mirar &amp;en:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="30"/>
        <source>Look in:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="31"/>
        <source>Back</source>
        <translation>Atrás</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="32"/>
        <source>Forward</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="33"/>
        <source>Parent Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="34"/>
        <source>Create New Folder</source>
        <translation>Crear nueva carpeta</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="35"/>
        <source>List View</source>
        <translation>Vista de lista</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="36"/>
        <source>Detail View</source>
        <translation>Vista detallada</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="37"/>
        <source>Preview File Info</source>
        <translation>Previsualizar información de archivos</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="38"/>
        <source>Preview File Contents</source>
        <translation>Previsualizar contenidos de archivos</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="39"/>
        <source>Read-write</source>
        <translation>Lectura-Escritura</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="40"/>
        <source>Read-only</source>
        <translation>Sólo lectura</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="41"/>
        <source>Write-only</source>
        <translation>Sólo escritura</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="42"/>
        <source>Inaccessible</source>
        <translation>Inaccesible</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="43"/>
        <source>Symlink to File</source>
        <translation>Enlace a archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="44"/>
        <source>Symlink to Directory</source>
        <translation>Enlace a directorio</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="45"/>
        <source>Symlink to Special</source>
        <translation>Enlace a especial</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="46"/>
        <source>File</source>
        <translation>Archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="47"/>
        <source>Dir</source>
        <translation>Dir</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="48"/>
        <source>Special</source>
        <translation>Especial</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="49"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="50"/>
        <source>Save As</source>
        <translation>Guardar como</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="51"/>
        <source>&amp;Open</source>
        <translation>&amp;Abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="52"/>
        <source>&amp;Save</source>
        <translation>&amp;Guardar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="53"/>
        <source>&amp;Rename</source>
        <translation>&amp;Renombrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="54"/>
        <source>&amp;Delete</source>
        <translation>&amp;Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="55"/>
        <source>R&amp;eload</source>
        <translation>&amp;Recargar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="56"/>
        <source>Sort by &amp;Name</source>
        <translation>Ordenar por &amp;nombre</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="57"/>
        <source>Sort by &amp;Size</source>
        <translation>Ordenar por &amp;tamaño</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="58"/>
        <source>Sort by &amp;Date</source>
        <translation>Ordenar por &amp;fecha</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="59"/>
        <source>&amp;Unsorted</source>
        <translation>&amp;Sin ordenar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="60"/>
        <source>Sort</source>
        <translation>Ordenar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="61"/>
        <source>Show &amp;hidden files</source>
        <translation>Mostrar archivos &amp;ocultos</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="62"/>
        <source>the file</source>
        <translation>el archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="63"/>
        <source>the directory</source>
        <translation>el directorio</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="64"/>
        <source>the symlink</source>
        <translation>el enlace simbólico</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="65"/>
        <source>Delete %1</source>
        <translation>Borrar %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="66"/>
        <source>&lt;qt&gt;Are you sure you wish to delete %1 &quot;%2&quot;?&lt;/qt&gt;</source>
        <translation>&lt;qt&gt;¿Está seguro de que desea borrar %1 &quot;%2&quot;?&lt;/qt&gt;</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="69"/>
        <source>New Folder 1</source>
        <translation>Nuevo carpeta 1</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="70"/>
        <source>New Folder</source>
        <translation>Nueva carpeta</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="71"/>
        <source>New Folder %1</source>
        <translation>Nueva carpeta %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="72"/>
        <source>Find Directory</source>
        <translation>Encontrar directorio</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="73"/>
        <source>Directories</source>
        <translation>Directorios</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="74"/>
        <source>Save</source>
        <translation>Guardar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="75"/>
        <source>Error</source>
        <translation>Error</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="76"/>
        <source>%1
File not found.
Check path and filename.</source>
        <translation>%1
Archivo no encontrado.
Comprueba la ruta y el nombre del archivo.</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="77"/>
        <source>All Files (*.*)</source>
        <translation>Todos los archivos (*.*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="78"/>
        <source>Select a Directory</source>
        <translation>Selecciona un directorio</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="79"/>
        <source>Directory:</source>
        <translation>Directorio:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="15"/>
        <source>Read: %1</source>
        <translation>Leer: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="16"/>
        <source>Write: %1</source>
        <translation>Escribir: %1</translation>
    </message>
</context>
<context>
    <name>QFontDialog</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="151"/>
        <source>&amp;Font</source>
        <translation>Ti&amp;pografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="152"/>
        <source>Font st&amp;yle</source>
        <translation>&amp;Estilo de tipografía</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="153"/>
        <source>&amp;Size</source>
        <translation>&amp;Tamaño</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="154"/>
        <source>Effects</source>
        <translation>Efectos</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="155"/>
        <source>Stri&amp;keout</source>
        <translation>Tac&amp;hado</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="156"/>
        <source>&amp;Underline</source>
        <translation>&amp;Subrayado</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="157"/>
        <source>&amp;Color</source>
        <translation>&amp;Color</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="158"/>
        <source>Sample</source>
        <translation>Ejemplo</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="159"/>
        <source>Scr&amp;ipt</source>
        <translation>Scr&amp;ipt</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="160"/>
        <source>OK</source>
        <translation>Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="161"/>
        <source>Apply</source>
        <translation>Aplicar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="162"/>
        <source>Cancel</source>
        <translation>Cancelar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="163"/>
        <source>Close</source>
        <translation>Cerrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="164"/>
        <source>Select Font</source>
        <translation>Seleccionar tipografía</translation>
    </message>
</context>
<context>
    <name>QLineEdit</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="83"/>
        <source>Clear</source>
        <translation>Borrar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="84"/>
        <source>Select All</source>
        <translation>Seleccionar todo</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="85"/>
        <source>&amp;Undo</source>
        <translation>&amp;Deshacer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="86"/>
        <source>&amp;Redo</source>
        <translation>Re&amp;hacer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="87"/>
        <source>Cu&amp;t</source>
        <translation>Cor&amp;tar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="88"/>
        <source>&amp;Copy</source>
        <translation>&amp;Copiar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="89"/>
        <source>&amp;Paste</source>
        <translation>&amp;Pegar</translation>
    </message>
</context>
<context>
    <name>QMainWindow</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="103"/>
        <source>Line up</source>
        <translation>Preparar</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="104"/>
        <source>Customize...</source>
        <translation>Personalizar...</translation>
    </message>
</context>
<context>
    <name>QMessageBox</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="9"/>
        <source>&lt;h3&gt;About Qt&lt;/h3&gt;&lt;p&gt;This program uses Qt version %1.&lt;/p&gt;&lt;p&gt;Qt is a C++ toolkit for multiplatform GUI &amp;amp; application development.&lt;/p&gt;&lt;p&gt;Qt provides single-source portability across MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, and all major commercial Unix variants.&lt;br&gt;Qt is also available for embedded devices.&lt;/p&gt;&lt;p&gt;Qt is a Trolltech product. See &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; for more information.&lt;/p&gt;</source>
        <translation>&lt;h3&gt;Acerca de Qt&lt;/h3&gt;&lt;p&gt;Este programa usa la versión de Qt %1.&lt;/p&gt;&lt;p&gt;Qt es un conjunto de herramientas para el desarrollo de aplicaciones e interfaces gráficas multiplataforma.&lt;/p&gt;&lt;p&gt;Qt proporciona portabilidad entre MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux y la mayoría de las variantes de Unix.&lt;br&gt;Qt también está disponible para dispositivos empotrados.&lt;/p&gt;&lt;p&gt;Qt es un producto de Trolltech. Ver &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; para más información.&lt;/p&gt;</translation>
    </message>
</context>
<context>
    <name>QObject</name>
    <message>
        <location filename="../../../scribus/gtaction.cpp" line="77"/>
        <source>Importing text</source>
        <translation>Importando texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/gtgettext.cpp" line="161"/>
        <location filename="../../../scribus/scgtplugin.cpp" line="68"/>
        <location filename="../../../scribus/util_formats.cpp" line="203"/>
        <source>All Supported Formats</source>
        <translation>Todos los formatos soportados</translation>
    </message>
    <message>
        <location filename="../../../scribus/gtgettext.cpp" line="189"/>
        <location filename="../../../scribus/scgtplugin.cpp" line="87"/>
        <location filename="../../../scribus/util_formats.cpp" line="250"/>
        <source>All Files (*)</source>
        <translation>Todos los archivos (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="139"/>
        <source>Albanian</source>
        <translation>Albanés</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="95"/>
        <source>Basque</source>
        <translation>Vasco</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="63"/>
        <location filename="../../../scribus/langmgr.cpp" line="64"/>
        <source>Bulgarian</source>
        <translation>Búlgaro</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="68"/>
        <source>Catalan</source>
        <translation>Catalán</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="149"/>
        <source>Chinese</source>
        <translation>Chino</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="69"/>
        <location filename="../../../scribus/langmgr.cpp" line="70"/>
        <source>Czech</source>
        <translation>Checo</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="72"/>
        <location filename="../../../scribus/langmgr.cpp" line="73"/>
        <source>Danish</source>
        <translation>Danés</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="121"/>
        <location filename="../../../scribus/langmgr.cpp" line="122"/>
        <source>Dutch</source>
        <translation>Holandés</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="81"/>
        <location filename="../../../scribus/langmgr.cpp" line="192"/>
        <location filename="../../../scribus/langmgr.cpp" line="265"/>
        <location filename="../../../scribus/langmgr.cpp" line="320"/>
        <source>English</source>
        <translation>Inglés</translation>
    </message>
    <message>
        <source>English (British)</source>
        <translation type="obsolete">Inglés (Británico)</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="88"/>
        <source>Esperanto</source>
        <translation>Esperanto</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="74"/>
        <location filename="../../../scribus/langmgr.cpp" line="78"/>
        <source>German</source>
        <translation>Alemán</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="96"/>
        <source>Finnish</source>
        <translation>Finlandés</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="97"/>
        <location filename="../../../scribus/langmgr.cpp" line="98"/>
        <source>French</source>
        <translation>Francés</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="99"/>
        <source>Galician</source>
        <translation>Gallego</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="80"/>
        <source>Greek</source>
        <translation>Griego</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="60"/>
        <source>Aragonese</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="62"/>
        <source>Belarusian</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="65"/>
        <source>Anii</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="76"/>
        <source>German (Austria)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="83"/>
        <source>English (Canadian)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="84"/>
        <source>English (UK)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="85"/>
        <source>English (New Zealand)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="86"/>
        <source>English (USA)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="87"/>
        <source>English (South African)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="90"/>
        <source>Spanish (Argentina)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="102"/>
        <location filename="../../../scribus/langmgr.cpp" line="103"/>
        <source>Hungarian</source>
        <translation>Húngaro</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="105"/>
        <source>Indonesian</source>
        <translation>Indonesio</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="107"/>
        <location filename="../../../scribus/langmgr.cpp" line="108"/>
        <source>Italian</source>
        <translation>Italiano</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="111"/>
        <source>Korean</source>
        <translation>Coreano</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="112"/>
        <source>Kurdish</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="116"/>
        <location filename="../../../scribus/langmgr.cpp" line="117"/>
        <source>Lithuanian</source>
        <translation>Lituano</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="118"/>
        <source>Nepali</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="123"/>
        <location filename="../../../scribus/langmgr.cpp" line="124"/>
        <source>Norwegian (Nnyorsk)</source>
        <translation>Noruego (Nynorsk)</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="125"/>
        <location filename="../../../scribus/langmgr.cpp" line="126"/>
        <source>Norwegian</source>
        <translation>Noruego</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="127"/>
        <location filename="../../../scribus/langmgr.cpp" line="128"/>
        <source>Polish</source>
        <translation>Polaco</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="132"/>
        <location filename="../../../scribus/langmgr.cpp" line="133"/>
        <source>Russian</source>
        <translation>Ruso</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="141"/>
        <source>Swedish</source>
        <translation>Sueco</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="89"/>
        <location filename="../../../scribus/langmgr.cpp" line="91"/>
        <source>Spanish</source>
        <translation>Español</translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/langmgr.cpp" line="119"/>
        <location filename="../../../scribus/langmgr.cpp" line="120"/>
        <source>Norwegian (Bokmål)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="92"/>
        <source>Spanish (Latin)</source>
        <translation>Español (Latinoamérica)</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="135"/>
        <location filename="../../../scribus/langmgr.cpp" line="136"/>
        <source>Slovak</source>
        <translation>Eslovaco</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="137"/>
        <location filename="../../../scribus/langmgr.cpp" line="138"/>
        <source>Slovenian</source>
        <translation>Esloveno</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="140"/>
        <source>Serbian</source>
        <translation>Serbio</translation>
    </message>
    <message>
        <location filename="../../../scribus/scfonts.cpp" line="334"/>
        <source>Font %1 is broken, discarding it</source>
        <translation>La tipografía %1 está rota, descartándola</translation>
    </message>
    <message>
        <location filename="../../../scribus/scribuscore.cpp" line="222"/>
        <source>Initializing...</source>
        <translation>Inicializando...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/scribus12format/scribus12format.cpp" line="730"/>
        <location filename="../../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="1550"/>
        <location filename="../../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="1118"/>
        <source>Background</source>
        <translation>Fondo</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="226"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="199"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="152"/>
        <source>Newsletters</source>
        <translation>Boletines</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="212"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="200"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="153"/>
        <source>Brochures</source>
        <translation>Folletos</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="216"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="201"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="154"/>
        <source>Catalogs</source>
        <translation>Catálogos</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="218"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="202"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="155"/>
        <source>Flyers</source>
        <translation>Cuartillas</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="220"/>
        <source>Grids</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="232"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="203"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="156"/>
        <source>Signs</source>
        <translation>Letreros</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="215"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="204"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="157"/>
        <source>Cards</source>
        <translation>Tarjetas</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="222"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="205"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="158"/>
        <source>Letterheads</source>
        <translation>Membretes</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="217"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="206"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="159"/>
        <source>Envelopes</source>
        <translation>Sobres</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="213"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="207"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="160"/>
        <source>Business Cards</source>
        <translation>Tarjetas profesionales</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="214"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="208"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="161"/>
        <source>Calendars</source>
        <translation>Calendarios</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="210"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="209"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="162"/>
        <source>Advertisements</source>
        <translation>Anuncios</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="221"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="210"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="163"/>
        <source>Labels</source>
        <translation>Etiquetas</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="225"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="211"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="164"/>
        <source>Menus</source>
        <translation>Menús</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="231"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="212"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="165"/>
        <source>Programs</source>
        <translation>Programas</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="228"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="213"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="166"/>
        <source>PDF Forms</source>
        <translation>Formularios PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="229"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="214"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="167"/>
        <source>PDF Presentations</source>
        <translation>Presentaciones PDF</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="223"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="215"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="168"/>
        <source>Magazines</source>
        <translation>Revistas</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="230"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="216"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="169"/>
        <source>Posters</source>
        <translation>Posters</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="211"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="217"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="170"/>
        <source>Announcements</source>
        <translation>Anuncios</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="233"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="218"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="171"/>
        <source>Text Documents</source>
        <translation>Documentos de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="219"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="219"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="172"/>
        <source>Folds</source>
        <translation>Dípticos</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="224"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="220"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="173"/>
        <source>Media Cases</source>
        <translation>Cajas de discos</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="227"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="221"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="174"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="261"/>
        <source>Own Templates</source>
        <translation>Plantillas propias</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/import/ai/importaiplugin.cpp" line="127"/>
        <location filename="../../../scribus/plugins/import/cvg/importcvgplugin.cpp" line="126"/>
        <location filename="../../../scribus/plugins/import/oodraw/oodrawimp.cpp" line="172"/>
        <location filename="../../../scribus/plugins/import/pct/importpctplugin.cpp" line="119"/>
        <location filename="../../../scribus/plugins/import/ps/importpsplugin.cpp" line="137"/>
        <location filename="../../../scribus/plugins/import/svg/svgplugin.cpp" line="159"/>
        <location filename="../../../scribus/plugins/import/wmf/wmfimportplugin.cpp" line="146"/>
        <location filename="../../../scribus/plugins/import/xfig/importxfigplugin.cpp" line="126"/>
        <source>Open</source>
        <translation>Abrir</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="39"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="64"/>
        <source>Cannot get a color with an empty name.</source>
        <comment>python error</comment>
        <translation>No se puede obtener un color sin nombre.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="87"/>
        <source>Cannot change a color with an empty name.</source>
        <comment>python error</comment>
        <translation>No se puede cambiar un color sin nombre.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="123"/>
        <source>Cannot create a color with an empty name.</source>
        <comment>python error</comment>
        <translation>No se puede crear un color sin nombre.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="159"/>
        <source>Cannot delete a color with an empty name.</source>
        <comment>python error</comment>
        <translation>No se puede borrar un color sin nombre.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="204"/>
        <source>Cannot replace a color with an empty name.</source>
        <comment>python error</comment>
        <translation>No se puede reemplazar un color sin nombre.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.cpp" line="152"/>
        <source>Failed to open document: %1</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.cpp" line="230"/>
        <source>Unit out of range. Use one of the scribus.UNIT_* constants.</source>
        <comment>python error</comment>
        <translation>Unidad fuera de rango. Usa una de las constantes scribus.UNIT_*.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.cpp" line="381"/>
        <source>Master page does not exist: &apos;%1&apos;</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.cpp" line="386"/>
        <source>Page number out of range: %1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.cpp" line="392"/>
        <source>Failed to apply masterpage &apos;%1&apos; on page: %2</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.cpp" line="27"/>
        <source>Target is not an image frame.</source>
        <comment>python error</comment>
        <translation>El destino no es un marco de imagen.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="350"/>
        <source>Corner radius must be a positive number.</source>
        <comment>python error</comment>
        <translation>El radio de las esquinas debe ser un número positivo.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="28"/>
        <source>Cannot get font size of non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede obtener el tamaño de la tipografía de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="54"/>
        <source>Cannot get font of non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede obtener la tipografía de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="80"/>
        <source>Cannot get text size of non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede obtener el tamaño del texto de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="116"/>
        <source>Cannot get column count of non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede obtener el número de columnas de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="134"/>
        <source>Cannot get line space of non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede obtener el interlineado de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="174"/>
        <source>Cannot get column gap of non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede obtener la distancia entre columnas de un marco que no es de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="193"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="224"/>
        <source>Cannot get text of non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede obtener el texto de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="257"/>
        <source>Cannot set text of non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer el texto de un marco que no es de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="291"/>
        <source>Cannot insert text into non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede insertar texto en un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="328"/>
        <source>Alignment out of range. Use one of the scribus.ALIGN* constants.</source>
        <comment>python error</comment>
        <translation>Alineamiento fuera de rango. Usa una de las constantes scribus.ALIGN*.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="563"/>
        <source>Selection index out of bounds</source>
        <comment>python error</comment>
        <translation>Índice de selección fuera de rango</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="128"/>
        <source>Save as</source>
        <translation>Guardar como</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvim.cpp" line="13"/>
        <source>Comma Separated Value Files</source>
        <translation>Archivos de valores separados por coma</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvim.cpp" line="59"/>
        <source>CSV_data</source>
        <translation>datos_CSV</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvim.cpp" line="63"/>
        <source>CSV_header</source>
        <translation>cabecera_CSV</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="43"/>
        <source>HTML Files</source>
        <translation>Archivos HTML</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="48"/>
        <source>html</source>
        <translation>html</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/htmlim/htmlreader.cpp" line="667"/>
        <source>
External Links
</source>
        <translation>
Enlaces externos</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/sxwim/sxwim.cpp" line="45"/>
        <source>OpenOffice.org Writer Documents</source>
        <translation>Documentos de OpenOffice.org Writer</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/textfilter/textfilter.cpp" line="26"/>
        <source>Text Filters</source>
        <translation>Filtros de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/txtim/txtim.cpp" line="21"/>
        <source>Text Files</source>
        <translation>Archivos de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.cpp" line="103"/>
        <source>Color not found - python error</source>
        <comment>python error</comment>
        <translation>Color no encontrado - error de python</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/short-words/configuration.cpp" line="153"/>
        <source>Custom (optional) configuration: </source>
        <comment>short words plugin</comment>
        <translation>Configuración personalizada (opcional): </translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/short-words/configuration.cpp" line="149"/>
        <source>Standard configuration: </source>
        <comment>short words plugin</comment>
        <translation>Configuración estándar:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/short-words/shortwords.cpp" line="129"/>
        <source>Short Words processing. Wait please...</source>
        <comment>short words plugin</comment>
        <translation>Palabras cortas está procesando. Espere por favor...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/short-words/shortwords.cpp" line="148"/>
        <source>Short Words processing. Done.</source>
        <comment>short words plugin</comment>
        <translation>Procesamiento de Palabras Cortas realizado.</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="58"/>
        <location filename="../../../scribus/langmgr.cpp" line="59"/>
        <source>Afrikaans</source>
        <translation>Afrikáans</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="144"/>
        <location filename="../../../scribus/langmgr.cpp" line="145"/>
        <source>Turkish</source>
        <translation>Turco</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="146"/>
        <location filename="../../../scribus/langmgr.cpp" line="147"/>
        <source>Ukranian</source>
        <translation>Ucraniano</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="71"/>
        <source>Welsh</source>
        <translation>Galés</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/objimageexport.cpp" line="75"/>
        <source>The filename must be a string.</source>
        <comment>python error</comment>
        <translation>El nombre de archivo debe ser una cadena.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/objimageexport.cpp" line="98"/>
        <source>Cannot delete image type settings.</source>
        <comment>python error</comment>
        <translation>No se pueden borrar las configuraciones de tipo de imagen.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/objimageexport.cpp" line="102"/>
        <source>The image type must be a string.</source>
        <comment>python error</comment>
        <translation>El tipo de imagen debe ser una cadena.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/objimageexport.cpp" line="127"/>
        <source>&apos;allTypes&apos; attribute is READ-ONLY</source>
        <comment>python error</comment>
        <translation>El atributo &apos;allTypes&apos; es de sólo lectura</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/objimageexport.cpp" line="157"/>
        <location filename="../../../scribus/plugins/scriptplugin/objimageexport.cpp" line="188"/>
        <source>Failed to export image</source>
        <comment>python error</comment>
        <translation>Falló exportando una imagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="47"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="72"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="213"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="241"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="268"/>
        <source>Color not found.</source>
        <comment>python error</comment>
        <translation>Color no encontrado.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="95"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="173"/>
        <source>Color not found in document.</source>
        <comment>python error</comment>
        <translation>Color no encontrado en el documento.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="105"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="184"/>
        <source>Color not found in default colors.</source>
        <comment>python error</comment>
        <translation>Color no encontrado en los colores por defecto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.cpp" line="338"/>
        <source>Cannot scale by 0%.</source>
        <comment>python error</comment>
        <translation>No puedo escalar a 0%.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.cpp" line="49"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.cpp" line="72"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.cpp" line="97"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.cpp" line="453"/>
        <source>Specified item not an image frame.</source>
        <comment>python error</comment>
        <translation>El objeto especificado no es un marco de imagen.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="100"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="416"/>
        <source>Font not found.</source>
        <comment>python error</comment>
        <translation>Tipografía no encontrada.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="106"/>
        <source>Cannot render an empty sample.</source>
        <comment>python error</comment>
        <translation>No se puedo visualizar un ejemplo vacío.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="171"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="204"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="281"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="314"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="347"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="380"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="478"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="509"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="540"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="571"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="602"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="633"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="664"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="696"/>
        <source>Cannot have an empty layer name.</source>
        <comment>python error</comment>
        <translation>No se puede tener una capa sin nombre.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="179"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="263"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="296"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="329"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="362"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="395"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="428"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="461"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="494"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="525"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="556"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="587"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="618"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="649"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="680"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="727"/>
        <source>Layer not found.</source>
        <comment>python error</comment>
        <translation>Capa no encontrada.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="701"/>
        <source>Cannot remove the last layer.</source>
        <comment>python error</comment>
        <translation>No se puede eliminar la última capa.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="744"/>
        <source>Cannot create layer without a name.</source>
        <comment>python error</comment>
        <translation>No se puede crear una capa sin nombre.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="300"/>
        <source>Insert index out of bounds.</source>
        <comment>python error</comment>
        <translation>Índice de inserción fuera de rango.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="336"/>
        <source>Cannot set text alignment on a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer la alineación del texto de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="362"/>
        <source>Font size out of bounds - must be 1 &lt;= size &lt;= 512.</source>
        <comment>python error</comment>
        <translation>Tamaño de la tipografía fuera de rango - debe ser 1 &lt;= tamaño &lt;= 512.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="371"/>
        <source>Cannot set font size on a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer el tamaño de la tipografía de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="400"/>
        <source>Cannot set font on a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer la tipografía de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="434"/>
        <source>Line space out of bounds, must be &gt;= 0.1.</source>
        <comment>python error</comment>
        <translation>Interlineado fuera de rango, debe ser &gt;= 0.1.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="442"/>
        <source>Cannot set line spacing on a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer el interlineado de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="497"/>
        <source>Column gap out of bounds, must be positive.</source>
        <comment>python error</comment>
        <translation>Distancia entre columnas fuera de rango, debe ser positiva.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="505"/>
        <source>Cannot set column gap on a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer la distancia entre columnas de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="524"/>
        <source>Column count out of bounds, must be &gt; 1.</source>
        <comment>python error</comment>
        <translation>Número de columnas fuera de rango, debe ser &gt;= 1.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="532"/>
        <source>Cannot set number of columns on a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer el número de columnas de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="568"/>
        <source>Cannot select text in a non-text frame</source>
        <comment>python error</comment>
        <translation>No se puede seleccionar texto en un marco que no es de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="605"/>
        <source>Cannot delete text from a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede borrar texto de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="636"/>
        <source>Cannot set text fill on a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer el color de relleno del texto de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="672"/>
        <source>Cannot set text stroke on a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer el color de trazo del texto de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="785"/>
        <source>Cannot set text shade on a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede establecer la saturación del texto de un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="825"/>
        <source>Can only link text frames.</source>
        <comment>python error</comment>
        <translation>Sólo se pueden enlazar marcos de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="835"/>
        <source>Target frame links to another frame.</source>
        <comment>python error</comment>
        <translation>El marco de destino enlaza con otro marco.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="840"/>
        <source>Target frame is linked to by another frame.</source>
        <comment>python error</comment>
        <translation>El marco de destino está enlazado por otro marco.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="845"/>
        <source>Source and target are the same object.</source>
        <comment>python error</comment>
        <translation>El origen y el destino son el mismo objeto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="870"/>
        <source>Cannot unlink a non-text frame.</source>
        <comment>python error</comment>
        <translation>No se puede desenlazar un marco que no es de texto.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="925"/>
        <source>Cannot convert a non-text frame to outlines.</source>
        <comment>python error</comment>
        <translation>No se puede convertir un marco que no es de texto a contornos.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="1044"/>
        <source>Can&apos;t set bookmark on a non-text frame</source>
        <comment>python error</comment>
        <translation>No se puede poner un marcador en marco que no es de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="1078"/>
        <source>Can&apos;t get info from a non-text frame</source>
        <comment>python error</comment>
        <translation>No se puede obtener información de un marco que no es de texto</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtim.cpp" line="47"/>
        <source>OpenDocument Text Documents</source>
        <translation>Documentos de Texto OpenDocument</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="101"/>
        <source>Croatian</source>
        <translation>Croata</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="129"/>
        <source>Portuguese</source>
        <translation>Portugués</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="130"/>
        <source>Portuguese (BR)</source>
        <translation>Portugués (Brasil)</translation>
    </message>
    <message>
        <location filename="../../../scribus/main_nix.cpp" line="126"/>
        <location filename="../../../scribus/main_win32.cpp" line="234"/>
        <location filename="../../../scribus/main_win32.cpp" line="259"/>
        <source>Scribus Crash</source>
        <translation type="unfinished">Scribus se ha cerrado</translation>
    </message>
    <message>
        <location filename="../../../scribus/main_nix.cpp" line="128"/>
        <source>Scribus crashes due to Signal #%1</source>
        <translation type="unfinished">Scribus se ha cerrado debido a la señal #%1</translation>
    </message>
    <message>
        <location filename="../../../scribus/main_nix.cpp" line="135"/>
        <location filename="../../../scribus/main_win32.cpp" line="243"/>
        <location filename="../../../scribus/main_win32.cpp" line="261"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;Aceptar</translation>
    </message>
    <message>
        <location filename="../../../scribus/page.cpp" line="37"/>
        <location filename="../../../scribus/page.cpp" line="82"/>
        <source>Page</source>
        <translation>Página</translation>
    </message>
    <message>
        <location filename="../../../scribus/page.cpp" line="91"/>
        <source>Master Page </source>
        <translation>Página maestra </translation>
    </message>
    <message>
        <location filename="../../../scribus/pagesize.cpp" line="124"/>
        <source>4A0</source>
        <translation>4A0</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagesize.cpp" line="130"/>
        <source>2A0</source>
        <translation>2A0</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagesize.cpp" line="220"/>
        <source>Comm10E</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagesize.cpp" line="226"/>
        <source>DLE</source>
        <translation>DLE</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="40"/>
        <source>Could not open output file %1</source>
        <translation>No se puede abrir el archivo de salida %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="57"/>
        <source>Output stream not writeable</source>
        <translation>Flujo de salida no es de escritura</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="80"/>
        <source>Verification of settings failed: %1</source>
        <translation>La verificación de la configuración falló: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="284"/>
        <source>Could not open input file %1</source>
        <translation>No se pudo abrir el archivo de entrada %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="299"/>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="449"/>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="461"/>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="476"/>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="484"/>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="493"/>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="504"/>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="533"/>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="671"/>
        <source>Unable to read settings XML:</source>
        <translation>Imposible leer las configuraciones XML:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="300"/>
        <source>%1 (line %2 col %3)</source>
        <comment>Load PDF settings</comment>
        <translation>%1 (línea %2 columna %3)</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="319"/>
        <source>Unable to read settings XML: %1</source>
        <translation>Imposible leer las configuraciones XML: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="320"/>
        <source>null root node</source>
        <comment>Load PDF settings</comment>
        <translation>Nodo inicial vacío</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="450"/>
        <source>&lt;pdfVersion&gt; invalid</source>
        <comment>Load PDF settings</comment>
        <translation>&lt;pdfVersion&gt; inválido</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="462"/>
        <source>found %1 &lt;%2&gt; nodes, need 1.</source>
        <comment>Load PDF settings</comment>
        <translation>encontrados %1 &lt;%2&gt; nodos, se necesita 1.</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="477"/>
        <source>unexpected null &lt;%2&gt; node</source>
        <comment>Load PDF settings</comment>
        <translation>nodo &lt;%2&gt; vacío inesperado</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="485"/>
        <source>node &lt;%1&gt; not an element</source>
        <comment>Load PDF settings</comment>
        <translation>nodo &lt;%1&gt; no es un elemento</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="505"/>
        <source>element &lt;%1&gt; lacks `value&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation>el elemento &lt;%1&gt; no tiene el atributo &apos;value&apos;</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="534"/>
        <source>element &lt;%1&gt; value must be `true&apos; or `false&apos;</source>
        <comment>Load PDF settings</comment>
        <translation>el valor del elemento &lt;%1&gt; debe ser &apos;true&apos; o &apos;false&apos;</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfoptionsio.cpp" line="672"/>
        <source>element &lt;lpiSettingsEntry&gt; lacks `name&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation>el elemento &lt;lpiSettingsEntry&gt; no tiene el atributo &apos;name&apos;</translation>
    </message>
    <message>
        <location filename="../../../scribus/fonts/ftface.cpp" line="54"/>
        <source>Freetype2 library not available</source>
        <translation>Biblioteca Freetype2 no está disponible</translation>
    </message>
    <message>
        <location filename="../../../scribus/fonts/ftface.cpp" line="322"/>
        <location filename="../../../scribus/fonts/scface_ttf.cpp" line="649"/>
        <source>Font %1 is broken (read stream), no embedding</source>
        <translation>La tipografía %1 está dañada (cadena roja), no se incrustará</translation>
    </message>
    <message>
        <location filename="../../../scribus/fonts/ftface.cpp" line="138"/>
        <location filename="../../../scribus/scfonts.cpp" line="360"/>
        <location filename="../../../scribus/scfonts.cpp" line="397"/>
        <source>Font %1 has broken glyph %2 (charcode %3)</source>
        <translation>La tipografía %1 tiene dañado el carácter %2 (código del carácter %3)</translation>
    </message>
    <message>
        <location filename="../../../scribus/fonts/scface_ps.h" line="186"/>
        <location filename="../../../scribus/fonts/scface_ps.h" line="216"/>
        <source>Font %1 cannot be read, no embedding</source>
        <translation>La tipografía %1 no se puede leer, no se incrustará</translation>
    </message>
    <message>
        <location filename="../../../scribus/scfonts.cpp" line="341"/>
        <source>Failed to load font %1 - font type unknown</source>
        <translation>Error al cargar tipografía %1 - tipo de tipografía desconocido</translation>
    </message>
    <message>
        <location filename="../../../scribus/scfonts.cpp" line="545"/>
        <source>Font %1 loaded from %2(%3)</source>
        <translation>Tipografía %1 cargada desde %2(%3)</translation>
    </message>
    <message>
        <location filename="../../../scribus/scfonts.cpp" line="561"/>
        <source>Font %1(%2) is duplicate of %3</source>
        <translation>Tripografía %1(%2) es la misma que %3</translation>
    </message>
    <message>
        <location filename="../../../scribus/scfonts.cpp" line="674"/>
        <source>Loading font %1 (found using fontconfig)</source>
        <translation>Cargando tipografía %1 (encontrada usando fontconfig)</translation>
    </message>
    <message>
        <location filename="../../../scribus/scfonts.cpp" line="679"/>
        <source>Failed to load a font - freetype2 couldn&apos;t find the font file</source>
        <translation>Error al cargar una tipografía - freetype2 no pudo encontrar el archivo</translation>
    </message>
    <message>
        <location filename="../../../scribus/fonts/scface_ttf.cpp" line="535"/>
        <source>extracting face %1 from font %2 (offset=%3, nTables=%4)</source>
        <translation type="unfinished">extrayendo familia %1 de la tipografía %2 (desplazamiento=%3,nTable=%4)</translation>
    </message>
    <message>
        <location filename="../../../scribus/fonts/scface_ttf.cpp" line="548"/>
        <source>memcpy header: %1 %2 %3</source>
        <translation type="unfinished">cabecera memcpy: %1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../../scribus/fonts/scface_ttf.cpp" line="557"/>
        <source>table &apos;%1&apos;</source>
        <translation>tabla &apos;%1&apos;</translation>
    </message>
    <message>
        <locati