/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#include <cstdio>
#include <cstdlib>
#include <iostream>

#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qspinbox.h>

#include <kglobal.h>
#include <kconfig.h>
#include <klineedit.h>
#include <krestrictedline.h>
#include <kcolorbutton.h>

#include "srkprefdialog.h"

SRKPrefDialog::SRKPrefDialog(QWidget* parent, const char* name, bool modal, WFlags fl)
    : SRKPrefDialogBase(parent,name, modal,fl)
{
    KConfig* config = KGlobal::config();
    
    config->setGroup("Network");
    networkWebserviceText->setText(config->readEntry("WebserviceUrl", DEFAULT_WEBSERVICE_URL));
    networkLoginUsernameText->setText(config->readEntry("WebserviceUsername", DEFAULT_WEBSERVICE_USERNAME));
    networkLoginPasswordText->setText(config->readEntry("WebservicePassword", DEFAULT_WEBSERVICE_PASSWORD));

    config->setGroup("VNC");
    vncServerLocText->setText(config->readEntry("ServerLocation", DEFAULT_SERVER_LOCATION));
    int serverOption = config->readEntry("ServerMode", QString::number(DEFAULT_SERVER_MODE)).toInt();
    switch (serverOption) {
    case LAUNCH_NEW:
	vncServerOpt1->setChecked(true);
	vncServerOpt2->setChecked(false);
	break;
    case USE_EXISTING:
	vncServerOpt1->setChecked(false);
	vncServerOpt2->setChecked(true);
	break;
    }
    vncServerDispText1->setText(config->readEntry("LaunchServerDisplay", QString::number(DEFAULT_LAUNCH_SERVER_DISPLAY)));
    vncServerXResText->setText(config->readEntry("LaunchServerXRes", QString::number(DEFAULT_SERVER_X_RESOLUTION)));
    vncServerYResText->setText(config->readEntry("LaunchServerYRes", QString::number(DEFAULT_SERVER_Y_RESOLUTION)));
    vncServerHostText->setText(config->readEntry("ExistingServerHost", DEFAULT_EXISTING_SERVER_HOST));
    vncServerDispText2->setText(config->readEntry("ExistingServerDisplay", QString::number(DEFAULT_EXISTING_SERVER_DISPLAY)));

    config->setGroup("Paths");
    pathIsdViewerText->setText(config->readEntry("IsdViewerLocation", DEFAULT_ISD_VIEWER_LOCATION));
    pathIsdExportText->setText(config->readEntry("IsdExportLocation", DEFAULT_ISD_EXPORT_LOCATION));

    config->setGroup("Defaults");
    defaultCommentDuration->setValue(config->readEntry("DefaultCommentDuration", QString::number(DEFAULT_DEFAULT_COMMENT_DURATION)).toInt());
    defaultCommentOpacity->setValue(config->readEntry("DefaultCommentOpacity", QString::number(DEFAULT_DEFAULT_COMMENT_OPACITY)).toInt());
    defaultCommentWidth->setValue(config->readEntry("DefaultCommentWidth", QString::number(DEFAULT_DEFAULT_COMMENT_WIDTH)).toInt());
    defaultCommentHeight->setValue(config->readEntry("DefaultCommentHeight", QString::number(DEFAULT_DEFAULT_COMMENT_HEIGHT)).toInt());
    float red = config->readEntry("DefaultCommentFillColorRed", QString::number(DEFAULT_DEFAULT_COMMENT_FILL_COLOR_RED)).toFloat();
    float green = config->readEntry("DefaultCommentFillColorGreen", QString::number(DEFAULT_DEFAULT_COMMENT_FILL_COLOR_GREEN)).toFloat();
    float blue = config->readEntry("DefaultCommentFillColorBlue", QString::number(DEFAULT_DEFAULT_COMMENT_FILL_COLOR_BLUE)).toFloat();

    defaultCommentFillColor->setColor(QColor((int)(red*255.0), (int)(green*255.0), (int)(blue*255.0)));

    red = config->readEntry("DefaultCommentTextColorRed", QString::number(DEFAULT_DEFAULT_COMMENT_TEXT_COLOR_RED)).toFloat();
    green = config->readEntry("DefaultCommentTextColorGreen", QString::number(DEFAULT_DEFAULT_COMMENT_TEXT_COLOR_GREEN)).toFloat();
    blue = config->readEntry("DefaultCommentTextColorBlue", QString::number(DEFAULT_DEFAULT_COMMENT_TEXT_COLOR_BLUE)).toFloat();

    defaultCommentTextColor->setColor(QColor((int)(red*255.0), (int)(green*255.0), (int)(blue*255.0)));
}

SRKPrefDialog::~SRKPrefDialog()
{
}

/*$SPECIALIZATION$*/
void SRKPrefDialog::reject()
{
    QDialog::reject();
}

void SRKPrefDialog::accept()
{
    KConfig* config = KGlobal::config();

    config->setGroup("Network");
    config->writeEntry("WebserviceUrl", networkWebserviceText->text());
    config->writeEntry("WebserviceUsername", networkLoginUsernameText->text());
    config->writeEntry("WebservicePassword", networkLoginPasswordText->text());

    config->setGroup("VNC");
    config->writeEntry("ServerLocation",  vncServerLocText->text());
    if (vncServerOpt1->isChecked()) {
	config->writeEntry("ServerMode", LAUNCH_NEW);
    }
    else {
	config->writeEntry("ServerMode", USE_EXISTING);
    }
    config->writeEntry("LaunchServerDisplay",  vncServerDispText1->text());
    config->writeEntry("LaunchServerXRes",  vncServerXResText->text());
    config->writeEntry("LaunchServerYRes",  vncServerYResText->text());
    config->writeEntry("ExistingServerHost",  vncServerHostText->text());
    config->writeEntry("ExistingServerDisplay",  vncServerDispText2->text());

    config->setGroup("Paths");
    config->writeEntry("IsdViewerLocation", pathIsdViewerText->text());
    config->writeEntry("IsdExportLocation", pathIsdExportText->text());

    config->setGroup("Defaults");
    config->writeEntry("DefaultCommentDuration", defaultCommentDuration->value());
    config->writeEntry("DefaultCommentOpacity", defaultCommentOpacity->value());
    config->writeEntry("DefaultCommentWidth", defaultCommentWidth->value());
    config->writeEntry("DefaultCommentHeight", defaultCommentHeight->value());

    config->writeEntry("DefaultCommentFillColorRed", defaultCommentFillColor->color().red()/255.0);
    config->writeEntry("DefaultCommentFillColorGreen", defaultCommentFillColor->color().green()/255.0);
    config->writeEntry("DefaultCommentFillColorBlue", defaultCommentFillColor->color().blue()/255.0);

    config->writeEntry("DefaultCommentTextColorRed", defaultCommentTextColor->color().red()/255.0);
    config->writeEntry("DefaultCommentTextColorGreen", defaultCommentTextColor->color().green()/255.0);
    config->writeEntry("DefaultCommentTextColorBlue", defaultCommentTextColor->color().blue()/255.0);

    config->sync();
    
    QDialog::accept();
}

#include "srkprefdialog.moc"
