/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef SRKERROR_H
#define SRKERROR_H

/**
 * The errorcodes.
 * WARNING: Make sure this is included AFTER an include from the Instrudeo-
 *          library, since RETURN_ERROR and RETURN_SUCCESS are declared there too.
 *
 * @author Bram Biesbrouck <b@beligum.org>
 */

#undef RETURN_ERROR
#define RETURN_ERROR(s) \
     return s;

#undef RETURN_SUCCESS
#define RETURN_SUCCESS \
     return SRKError::SRK_SUCCESS

class SRKError
{
 public:
    enum SRKErrorCode {
	/**
	 * everything OK
	 */
	SRK_SUCCESS,
	/**
	 * general error
	 */
	SRK_FAILURE,
	/**
	 * error during accessing a file
	 */
	SRK_FILE_ERROR,
	/**
	 * error because of version mismatch
	 */
	SRK_VERSION_ERROR,
	/**
	 * error while initialising data
	 */
	SRK_INIT_ERROR,
	/*
	 * error because of provided arguments
	 */
	SRK_ARGS_ERROR,
	/*
	 * error while exporting recording
	 */
	SRK_EXPORT_ERROR,
	/**
	 * error while cleaning up
	 */
	SRK_CLEANUP_ERROR,
	/**
	 * error involving the VNC server
	 */
	SRK_VNC_SERVER_ERROR,
	/**
	 * error involving the VNC viewer
	 */
	SRK_VNC_VIEWER_ERROR,
	/**
	 * error involving VNC authentication or vncpasswd
	 */
	SRK_VNC_PASSWD_ERROR,
	/**
	 * error while importing a file
	 */
	SRK_IMPORT_ERROR
    };
};

#endif
