/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "srkmainwindow.h"

static const char description[] =
    I18N_NOOP("A KDE Application to make screen recordings, using the Instrudeo library.");

static const char version[] = "0.1.3";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Instrudeo-document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("screenkast", I18N_NOOP("ScreenKast"), version, description,
                     KAboutData::License_GPL, "(C) 2006 Bram Biesbrouck", 0, 0, "b@beligum.org");
    about.addAuthor( "Bram Biesbrouck", I18N_NOOP("Original Developer/Maintainer"), "b@beligum.org", "http://www.beligum.org");
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;

    // see if we are starting with session management
    if (app.isRestored()) {
        RESTORE(SRKMainWindow);
    }
    else{
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0){
            SRKMainWindow *widget = new SRKMainWindow();
            widget->show();
        }
        else{
            int i = 0;
            for (; i < args->count(); i++){
                SRKMainWindow *widget = new SRKMainWindow();
                widget->show();
                widget->loadFile(args->url(i).path());
            }
        }
        args->clear();
    }
    
    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

