/*******************************************************************************
 * Score Reading Trainer                                                       *
 * Copyright (C) 2004 by Jos Pablo Ezequiel Fernndez <pupeno@pupeno.com>     *
 *                                                                             *
 * This program is free software; you can redistribute it and/or               *
 * modify it under the terms of the GNU General Public License                 *
 * version 2 as published by the Free Software Foundation.                     *
 *                                                                             *
 * This program is distributed in the hope that it will be useful,             *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 * GNU General Public License for more details.                                *
 *                                                                             *
 * You should have received a copy of the GNU General Public License           *
 * along with this program; if not, write to the Free Software                 *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *******************************************************************************/

#include <qframe.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qslider.h>

#include <klocale.h>
#include <kdebug.h>
#include <kconfig.h>


#include "Program.h"

#include "Preferences.h"

Preferences::Preferences() : KDialogBase(Plain, i18n("Preferences"), Help|Default|Ok|Apply|Cancel, Ok){
	//kdDebug() << "Running Preferences::Preferences()" << endl;
	connect(this, SIGNAL(okClicked()), this, SLOT(saveSettings()));
	connect(this, SIGNAL(applyClicked()), this, SLOT(saveSettings()));
	connect(this, SIGNAL(defaultClicked()), this, SLOT(defaultSettings()));

	QFrame *page = plainPage();
	QVBoxLayout *pageLayout = new QVBoxLayout(page);
	pageLayout->setAutoAdd(true);
	program = new Program(page);

	loadSettings();
}

void Preferences::loadSettings(){
	//kdDebug() << "Running Preferences::loadSettings()" << endl;
	KConfig *config = KGlobal::config();
	config->setGroup("Program");

	if(config->readEntry("trainingType", "manual") == "manual"){
		program->manual->setChecked(true);
		program->automatic->setChecked(false);
	} else {
		program->manual->setChecked(false);
		program->automatic->setChecked(true);
	}

	QString clef = config->readEntry("clef", "G2");
	if(clef == "G2"){
		program->g2->setChecked(true);
	} else if(clef == "F4"){
		program->f4->setChecked(true);
	} else if(clef == "C3"){
		program->c3->setChecked(true);
	} else if(clef == "C4"){
		program->c4->setChecked(true);
	}

	QString keySignature = config->readEntry("keySignature", "C");
	if(keySignature == "C"){
		program->keySignatureC->setChecked(true);
	} else if(keySignature == "G"){
		program->keySignatureG->setChecked(true);
	} else if(keySignature == "D"){
		program->keySignatureD->setChecked(true);
	} else if(keySignature == "A"){
		program->keySignatureA->setChecked(true);
	} else if(keySignature == "E"){
		program->keySignatureE->setChecked(true);
	} else if(keySignature == "B"){
		program->keySignatureB->setChecked(true);
	} else if(keySignature == "F#"){
		program->keySignatureFSharp->setChecked(true);
	} else if(keySignature == "C#"){
		program->keySignatureCSharp->setChecked(true);
	} else if(keySignature == "F"){
		program->keySignatureF->setChecked(true);
	} else if(keySignature == "Bb"){
		program->keySignatureBFlat->setChecked(true);
	} else if(keySignature == "Eb"){
		program->keySignatureEFlat->setChecked(true);
	} else if(keySignature == "Ab"){
		program->keySignatureAFlat->setChecked(true);
	} else if(keySignature == "Db"){
		program->keySignatureDFlat->setChecked(true);
	} else if(keySignature == "Gb"){
		program->keySignatureGFlat->setChecked(true);
	} else if(keySignature == "Cb"){
		program->keySignatureCFlat->setChecked(true);
	}


	program->bottomLimit->setValue(config->readNumEntry("bottomLimit", 7));
	program->topLimit->setValue(config->readNumEntry("topLimit", 10));

	program->accidentals->setChecked(config->readBoolEntry("accidentals", false));
}

void Preferences::saveSettings(){
	// kdDebug() << "Running Preferences::saveSettings()" << endl;
	KConfig *config = KGlobal::config();
	config->setGroup("Program");

	if(program->manual->isChecked() == true){
		config->writeEntry("trainingType", "manual");
	} else if(program->automatic->isChecked() == true){
		config->writeEntry("trainingType", "automatic");
	}

	if(program->g2->isChecked() == true){
		config->writeEntry("clef", "G2");
	} else if(program->f4->isChecked() == true){
		config->writeEntry("clef", "F4");
	} else if(program->c3->isChecked() == true){
		config->writeEntry("clef", "C3");
	} else if(program->c4->isChecked() == true){
		config->writeEntry("clef", "C4");
	}

	if(program->keySignatureC->isChecked() == true){
		config->writeEntry("keySignature", "C");
	} else if(program->keySignatureG->isChecked() == true){
		config->writeEntry("keySignature", "G");
	} else if(program->keySignatureD->isChecked() == true){
		config->writeEntry("keySignature", "D");
	} else if(program->keySignatureA->isChecked() == true){
		config->writeEntry("keySignature", "A");
	} else if(program->keySignatureE->isChecked() == true){
		config->writeEntry("keySignature", "E");
	} else if(program->keySignatureB->isChecked() == true){
		config->writeEntry("keySignature", "B");
	} else if(program->keySignatureFSharp->isChecked() == true){
		config->writeEntry("keySignature", "F#");
	} else if(program->keySignatureCSharp->isChecked() == true){
		config->writeEntry("keySignature", "C#");
	} else if(program->keySignatureF->isChecked() == true){
		config->writeEntry("keySignature", "F");
	} else if(program->keySignatureBFlat->isChecked() == true){
		config->writeEntry("keySignature", "Bb");
	} else if(program->keySignatureEFlat->isChecked() == true){
		config->writeEntry("keySignature", "Eb");
	} else if(program->keySignatureAFlat->isChecked() == true){
		config->writeEntry("keySignature", "Ab");
	} else if(program->keySignatureDFlat->isChecked() == true){
		config->writeEntry("keySignature", "Db");
	} else if(program->keySignatureGFlat->isChecked() == true){
		config->writeEntry("keySignature", "Gb");
	} else if(program->keySignatureCFlat->isChecked() == true){
		config->writeEntry("keySignature", "Cb");
	}

	config->writeEntry("bottomLimit", program->bottomLimit->value());
	config->writeEntry("topLimit", program->topLimit->value());

	config->writeEntry("accidentals", program->accidentals->isChecked());
}

void Preferences::defaultSettings(){
	//kdDebug() << "Running Preferences::loadSettings()" << endl;
	program->manual->setChecked(true);
	program->automatic->setChecked(false);

	program->g2->setChecked(true);

	program->keySignatureC->setChecked(true);

	program->bottomLimit->setValue(7);
	program->topLimit->setValue(10);

	program->accidentals->setChecked(false);
}
#include "Preferences.moc"
