/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "helper.h"
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

unsigned int numlen (long num) {
  int retval = 1;
  
  while (num >= 10) {
    ++retval;
    num /= 10;
  }
  return retval;
}

uint8_t numtype (const char* number) {
  //see ETSI 23.040, Ch. 9.1.2.5
  if (str_len(number) == 0 ||
      *number != '+') {
    return 0x81;
  } else {
    return 0x91;
  }
}

unsigned int hexstr2int (char *hexstring, unsigned int length) {
  unsigned int i = 0;
  unsigned int intvalue = 0;
  unsigned int shift;

  if (str_len(hexstring) < length) length = str_len(hexstring);
  shift = 4*(length-1);
  for (;i < length; ++i) {
    switch (hexstring[i]) {
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      intvalue += ((hexstring[i] - '0') << shift);
    default:
      break;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
      intvalue += ((hexstring[i] - 'A' + 10) << shift);
      break;
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
      intvalue += ((hexstring[i] - 'a' + 10) << shift);
      break;
    }
    shift -= 4; //multiplicator: <<4*  = *16^
  }
  return intvalue;
}

int is_number(const char* s) {
  unsigned int i = 0;
  if (str_len(s) == 0) return 0;
  for (; i < strlen(s); ++i) if (isdigit((int)s[i]) == 0) return 0;
  return 1;
}

int is_telephone_number (const char* s) {
  if (str_len(s) == 0) return 0;
  if (s[0] == '+') ++s;
  return is_number(s);
}
