/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own headers
#include <charsets.h>
#include <gtincl.h>

//standard headers
#include <stdio.h>
#include <iconv.h>

#include <config.h>
#ifdef WORDS_BIGENDIAN
#  define UCS2_WITH_ENDIANESS "UCS-2BE"
#else
#  define UCS2_WITH_ENDIANESS "UCS-2LE"
#endif

const char* ucs2_get_iconv_charset() {
  static char* ucs2_charset = NULL;
  iconv_t cd;

  if (ucs2_charset == NULL) {
    cd = iconv_open(UCS2_WITH_ENDIANESS,UCS2_WITH_ENDIANESS);
    if (cd == (iconv_t)-1) {
      fprintf(stderr,_("%s: the iconv implementation of this system does not support %s"),_("Error"),UCS2_WITH_ENDIANESS);
      exit(EXIT_FAILURE);
    } else {
      ucs2_charset = UCS2_WITH_ENDIANESS;
    }
    iconv_close(cd);
  }
  return ucs2_charset;
}

size_t ucs2len (ucs2char_t* input) {
  size_t retval = 0;
  if (input != NULL) while (input[retval] != 0) ++retval;
  return retval;
}
