/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own headers
#include <charsets.h>
#include <helper.h>
#include <gtincl.h>
#include "gsm.h"

//standard headers
#include <string.h>
#include <stdio.h>

ucs4char_t* convert_from_gsm (gsmchar_t* input)  {
  ucs4char_t* retval;
  unsigned int i;
  unsigned int k=0;
  unsigned int g;
    
  retval = mem_alloc((strlen(input)+1)*sizeof(ucs4char_t),1);
  for (i = 0; i < strlen(input); ++i) {
    for (g = 0; gsm_chars[g].gsize != 0; ++g) {
      if (input[i] == gsm_chars[g].gval[0] &&
	  (gsm_chars[g].gsize < 2 ||
	   input[i+1] == gsm_chars[g].gval[1])) {
	break;
      }
    }
    if (gsm_chars[g].gsize == 0) {
      fprintf(stderr,_("Ups, value 0x%02x not found in list of valid GSM characters.\n"),
	      input[i]);
      continue;
    }
    retval[k++] = gsm_chars[g].uval;
    i += (gsm_chars[g].gsize-1);
/*
    switch (input[i] & 0x7f) {
    default:
      retval[k] = input[i];
      break;
    case 0x00: // commercial at
      retval[k] =  0x0040;
      break;
    case 0x01: // pound sign
      retval[k] =  0x00a3;
      break;
    case 0x02: // dollar sign
      retval[k] =  0x0024;
      break;
    case 0x03: // yen sign
      retval[k] =  0x00a5;
      break;
    case 0x04: // small 'e' with grave
      retval[k] =  0x00e8;
      break;
    case 0x05: // small 'e' with acute
      retval[k] =  0x00e9;
      break;
    case 0x06: // small 'u' with grave
      retval[k] =  0x00f9;
      break;
    case 0x07: // small 'i' with grave
      retval[k] =  0x00ec;
      break;
    case 0x08: // small 'o' with grave
      retval[k] =  0x00f2;
      break;
    case 0x09: // small/capital 'c' with cedilla (we map to small)
      retval[k] =  0x00e7; // or 0x00c7 ?
      break;
    case 0x0b: // capital 'O' with stroke
      retval[k] =  0x00d8;
      break;
    case 0x0c: // small 'o' with stroke
      retval[k] =  0x00f8;
      break;
    case 0x0e: // capital 'A' with ring above
      retval[k] =  0x00c5;
      break;
    case 0x0f: // small 'a' with ring above
      retval[k] =  0x00e5;
      break;
    case 0x10: // capital delta
      retval[k] =  0x0394;
      break;
    case 0x11: // underscore / low line
      retval[k] =  0x005f;
      break;
    case 0x12: // capital phi
      retval[k] =  0x03a6;
      break;
    case 0x13: // capital gamma
      retval[k] =  0x0393;
      break;
    case 0x14: // capital lambda
      retval[k] =  0x039b;
      break;
    case 0x15: // capital omega
      retval[k] =  0x03a9;
      break;
    case 0x16: // capital pi
      retval[k] =  0x03a0;
      break;
    case 0x17: // capital psi
      retval[k] =  0x03a8;
      break;
    case 0x18: // capital sigma
      retval[k] =  0x03a3;
      break;
    case 0x19: // capital theta
      retval[k] =  0x0398;
      break;
    case 0x1a: // capital xi
      retval[k] =  0x039e;
      break;
    case 0x1b:
      if (++i < strlen(input)) {
	switch (input[i]) {
	default: // non-breaking space
	  --i;
	  retval[k] =  0x00a0;
	  break;
	case 0x1a: // form feed
	  retval[k] =  0x000c;
	  break;
	case 0x14: // circumflex accent
	  retval[k] =  0x005e;
	  break;
	case 0x28: // left curly bracket
	  retval[k] =  0x007b;
	  break;
	case 0x29: // right curly bracket
	  retval[k] = 0x007d;
	  break;
	case 0x2f: // reverse solidus
	  retval[k] = 0x005c;
	  break;
	case 0x3c: // left square bracket
	  retval[k] = 0x005b;
	  break;
	case 0x3d: // tilde
	  retval[k] = 0x007e;
	  break;
	case 0x3e: // right square bracket
	  retval[k] = 0x005d;
	  break;
	case 0x40: // vertical line
	  retval[k] = 0x007c;
	  break;
	case 0x65: // Euro sign
	  retval[k] = 0x20ac;
	  break;
	}
      } else {
	--i;
	retval[k] =  0x00a0;
      }
      break;
    case 0x1c: // capital 'AE'
      retval[k] =  0x00c6;
      break;
    case 0x1d: // small 'ae'
      retval[k] =  0x00e6;
      break;
    case 0x1e: // small sharp s (german)
      retval[k] =  0x00df;
      break;
    case 0x1f: // capital 'E' with acute
      retval[k] =  0x00c9;
      break;
    case 0x24: // currency sign
      retval[k] =  0x00a4;
      break;
    case 0x40: // inverted exclamation mark
      retval[k] =  0x00a1;
      break;
    case 0x5b: // capital 'A' with diaeresis
      retval[k] =  0x00c4;
      break;
    case 0x5c: // capital 'O' with diaeresis
      retval[k] =  0x00d6;
      break;
    case 0x5d: // capital 'N' with tilde
      retval[k] =  0x00d1;
      break;
    case 0x5e: // capital 'U' with diaeresis
      retval[k] =  0x00dc;
      break;
    case 0x5f: // section sign
      retval[k] =  0x00a7;
      break;
    case 0x60: // inverted question mark
      retval[k] =  0x00bf;
      break;
    case 0x7b: // small 'a' with diaeresis
      retval[k] =  0x00e4;
      break;
    case 0x7c: // small 'o' with diaeresis
      retval[k] =  0x00f6;
      break;
    case 0x7d: // small 'n' with tilde
      retval[k] =  0x00f1;
      break;
    case 0x7e: // small 'u' with diaeresis
      retval[k] =  0x00fc;
      break;
    case 0x7f: // small 'a' with grave
      retval[k] =  0x00e0;
      break;
    }
    ++k;
*/
  }
  retval[k]=0;

  return mem_realloc(retval,(k+1)*sizeof(ucs4char_t));
}
