/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include "helper.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


void* mem_alloc (size_t size, short zero_it) {
  void* retval;

  retval=mem_realloc(NULL,size);
  if (zero_it) {
    memset(retval,0,size);
  }
  return retval;
}

void* mem_realloc (void* oldpointer, size_t size) {
  void* retval;
    
  if ((retval=realloc(oldpointer,size))==NULL && size>0) {
    errexit("%s","Memory allocation failure");
  }
  return retval;
}

char* str_dup (const char* input) {
  return strn_dup(input,str_len(input));
}

char* strn_dup (const char* input, size_t insize) {
  void* retval;

  if (input != NULL) {
    retval=mem_alloc(insize+1,1);
    strncpy(retval,input,insize);
    return retval;
  } else {
    return NULL;
  }
}

size_t str_len (const char* s) {
  if (s != NULL) {
    return strlen(s);
  } else {
    return 0;
  }
}

int strn_reverse_compare (const char* s1, const char* s2, size_t n)
{
  size_t s1len = str_len(s1);
  size_t s2len = str_len(s2);

  if (s1 == NULL && s2 == NULL) return 1;
  if (s1 == NULL || s2 == NULL) return 0;
  if (s1len < n) {
    if(s2len >= n) {
      return 0;
    } else { //both are smaller than n
      if (s1len != s2len) return 0;
      else n = s1len;
    }
  } else {
    if (s2len < n) return 0;
    /* else both are longer than n */
  }
  
  if (strcmp(s1+s1len-n,s2+s2len-n) != 0) return 0;
  else return 1;
}
