/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own headers
#include <charsets.h>
#include <helper.h>

//standard headers
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <iconv.h>

#include <config.h>
#ifndef ICONV_CAST
#  define ICONV_CAST char**
#endif

#ifdef WORDS_BIGENDIAN
#  define INTERNAL_CHARSET "UCS-4BE"
#else
#  define INTERNAL_CHARSET "UCS-4LE"
#endif
ucs4char_t* convert_to_internal (char* from_code,
				 char* input,
				 size_t insize)
{
  iconv_t cd;

  ucs4char_t* outbuf;
  char* outptr;
  size_t outsize;

  if (from_code == NULL || input == NULL || insize == 0) return NULL;

  cd = iconv_open(INTERNAL_CHARSET,from_code);
  if (cd == (iconv_t)-1) {
    fprintf(stderr,"Error on text conversion: %s\n", strerror(errno));
    exit(EXIT_FAILURE);
  }

  outsize = insize*sizeof(ucs4char_t);
  outbuf  = mem_alloc(outsize+sizeof(ucs4char_t),1);
  outptr  = (char*)outbuf;

  if (iconv(cd,(ICONV_CAST)&input,&insize,&outptr,&outsize) == (size_t)-1) {
    fprintf(stderr,"Error on text conversion to internal charset: %s\n", strerror(errno));
    exit(EXIT_FAILURE);
  }
  iconv_close(cd);

  return mem_realloc(outbuf,(ucs4len(outbuf)+1)*sizeof(ucs4char_t));
}
