/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own headers
#include <charsets.h>
#include <helper.h>

//standard headers
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <iconv.h>
#include <ctype.h>

ucs4char_t* convert_from_system (char* input) {
  ucs4char_t* retval;
  size_t i = 0;
  size_t k = 0;
  int counter;
  char buffer[5]; //buffer for \XXXX
  size_t offset = 0;
  int status;

  if (str_len(input) == 0) return NULL;
  retval = convert_to_internal(get_system_charset(),input,strlen(input));

  /* Now we have to handle all direct \XXXX character inputs
   */
  while (retval[i] != 0) {
    switch (retval[i]) {
    case 0x5c: // '\'
      switch (retval[i+1]) {
      case 0x6e: // 'n'
	retval[k]=0x0a;
	offset = 1;
	break;
      case 0x5c: // '\'
	retval[k]=0x5c;
	offset = 1;
	break;		    
      default:
	status = 1; //assume successful loop
	for (counter=0;counter<4;counter++) {
	  if (retval[i+1+counter] > 0x00 &&
	      retval[i+1+counter] <= 0x7f) {
	    if (isxdigit((int)(retval[i+1+counter]&0x7f))) {
	      /* We can do this because Unicode is based on ASCII
	       * and we just tested for ASCII
	       */
	      buffer[counter] = (char)(retval[i+1+counter]&0x7f);
	    } else {
	      fprintf(stderr,"%s: character %ld is not a hexdigit.\n",
		      "Error on text conversion to internal charset",
		      (unsigned long)i+1+counter);
	      status = 0;
	      break;
	    }
	  } else {
	    fprintf(stderr,"%s: character %ld is not ACSII.\n",
		    "Error on text conversion to internal charset",
		    (unsigned long)i+1+counter);
	    status = 0;
	    break;
	  }
	}
	if (status == 1) {
	  buffer[4] = 0;
	  retval[k] = (ucs4char_t)hexstr2int(buffer,4);
	  offset = 4;
	} else {
	  offset = 0;
	}
	break;
      }
      i += offset;
      memmove(&retval[i+1-offset],&retval[i+1],(ucs4len(retval+i+1)+1)*sizeof(ucs4char_t));
      //no break
    default:
      ++k;
      ++i;
      break;
    }
  }
  retval[k] = 0;

  return mem_realloc(retval,(ucs4len(retval)+1)*sizeof(ucs4char_t));
}
