/** @file scim_panel.h
 */

/* 
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_panel.h,v 1.11 2004/06/19 12:58:00 suzhe Exp $
 */

#ifndef __SCIM_PANEL_H__
#define __SCIM_PANEL_H__

namespace scim {

const int
    //Privately used by panel.
    SCIM_TRANS_CMD_PANEL_EXIT                  = 500,

    //FrontEnd Client to Panel
    SCIM_TRANS_CMD_PANEL_TURN_ON               = 501,
    SCIM_TRANS_CMD_PANEL_TURN_OFF              = 502,
    SCIM_TRANS_CMD_PANEL_UPDATE_DISPLAY        = 503,
    SCIM_TRANS_CMD_PANEL_UPDATE_SCREEN         = 504,
    SCIM_TRANS_CMD_PANEL_UPDATE_SPOT_LOCATION  = 505,
    SCIM_TRANS_CMD_PANEL_UPDATE_FACTORY_INFO   = 506,
    SCIM_TRANS_CMD_PANEL_SHOW_HELP             = 507,
    SCIM_TRANS_CMD_PANEL_SHOW_FACTORY_MENU     = 508,

    //Panel to FrontEnd Client
    SCIM_TRANS_CMD_PANEL_REQUEST_HELP          = 520,
    SCIM_TRANS_CMD_PANEL_REQUEST_FACTORY_MENU  = 521,
    SCIM_TRANS_CMD_PANEL_CHANGE_FACTORY        = 522;

} // namespace scim

#endif

/*
vi:ts=4:nowrap:expandtab
*/
