#include <sys/time.h>

#include "scim-bridge-utility.h"

sec_t scim_bridge_get_seconds_since_the_epoch ()
{
    return scim_bridge_get_microseconds_since_the_epoch () / (1000 * 1000);
}


millisec_t scim_bridge_get_milliseconds_since_the_epoch ()
{
    return scim_bridge_get_microseconds_since_the_epoch () / 1000;
}


microsec_t scim_bridge_get_microseconds_since_the_epoch ()
{
    struct timeval tv;
    struct timezone tz;                           /* is not used since ages */
    gettimeofday (&tv, &tz);
    return (microsec_t)tv.tv_sec * 1000 * 1000 + tv.tv_usec;
}
