#ifndef SCIMBRIDGESTRING_H_
#define SCIMBRIDGESTRING_H_

#include <stdint.h>

#include "scim-bridge.h"
#include "scim-bridge-exception.h"

#ifndef __STDC_ISO_10646__
typedef uint32 wchar_t;
#endif

typedef wchar_t ucs4_t;

#ifdef __cplusplus
extern "C"
{
#endif

    int scim_bridge_string_mbstowcs (ScimBridgeException *except, ucs4_t *wstr, const char *str, const size_t max_wstr_len, size_t *wstr_len);
    int scim_bridge_string_wcstombs (ScimBridgeException *except, char *str, const ucs4_t *wstr, const size_t max_str_len, size_t *str_len);
    size_t scim_bridge_string_wstrlen (const ucs4_t *wstr);
    size_t scim_bridge_string_strbuflen (const ucs4_t *wstr);
    size_t scim_bridge_string_wstrbuflen (const char *str);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGESTRING_H_*/
