#ifndef SCIMBRIDGEMESSAGENGER_H_
#define SCIMBRIDGEMESSAGENGER_H_

#include "scim-bridge.h"
#include "scim-bridge-exception.h"
#include "scim-bridge-message.h"

#ifdef __cplusplus
extern "C"
{
#endif

    /* Functions */
    int scim_bridge_initialize_messenger (ScimBridgeException *except, ScimBridgeMessengerID *messenger_id, int input_fd, int output_fd);
    int scim_bridge_finalize_messenger (ScimBridgeException *except, ScimBridgeMessengerID messenger_id);

    int scim_bridge_messenger_open_input (ScimBridgeException *except, ScimBridgeMessengerID messenger_id);
    int scim_bridge_messenger_open_output (ScimBridgeException *except, ScimBridgeMessengerID messenger_id);
    int scim_bridge_messenger_close_input (ScimBridgeException *except, ScimBridgeMessengerID messenger_id);
    int scim_bridge_messenger_close_output (ScimBridgeException *except, ScimBridgeMessengerID messenger_id);

    int scim_bridge_messenger_write_output (ScimBridgeException *except, ScimBridgeMessengerID messenger_id, const void *buf, size_t size);
    int scim_bridge_messenger_read_output (ScimBridgeException *except, ScimBridgeMessengerID messenger_id, void *buf, size_t size);

    int scim_bridge_messenger_write_input (ScimBridgeException *except, ScimBridgeMessengerID messenger_id, const void *buf, size_t size);
    int scim_bridge_messenger_read_input (ScimBridgeException *except, ScimBridgeMessengerID messenger_id, void *buf, size_t size);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGEMESSAGENGER_H_*/
