#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gtk/gtkimmodule.h>

#include "scim-bridge.h"
#include "scim-bridge-client-imcontext-gtk.h"

static const GtkIMContextInfo scim_bridge_info =
{
    /* ID */
    "scim-bridge",
    /* Human readable name */
    "SCIM Bridge Input Method",
    /* Translation domain */
    "",
    /* Dir for bindtextdomain (not strictly needed for "gtk+") */
    "",
    /* Languages for which this module is the default */
    ""
};

static const GtkIMContextInfo *info_list[] =
{
    &scim_bridge_info
};

/* Public functions */
void im_module_init (GTypeModule *type_module);
void im_module_exit (void);
void im_module_list (const GtkIMContextInfo ***contexts, int *context_count);
GtkIMContext *im_module_create (const gchar *context_id);

/* Implementations */
void im_module_init (GTypeModule *type_module)
{
    scim_bridge_client_imcontext_register_type (type_module);
}


void im_module_exit (void)
{
    scim_bridge_client_imcontext_shutdown ();
}


void im_module_list (const GtkIMContextInfo ***contexts, int *context_count)
{
    *contexts = info_list;
    *context_count = G_N_ELEMENTS (info_list);
}


GtkIMContext *im_module_create (const gchar *context_id)
{
    if (strcmp (context_id, "scim-bridge") == 0) {
        return scim_bridge_client_imcontext_new ();
    } else {
        return NULL;
    }
}
