#ifndef SCIMBRIDGEAGENTCLIENTPEER_H_
#define SCIMBRIDGEAGENTCLIENTPEER_H_

#define Uses_SCIM_ATTRIBUTE
#define Uses_SCIM_HOTKEY

#include <scim.h>

#include "scim-bridge.h"
#include "scim-bridge-agent-exception.h"

class ScimBridgeAgentClientListener;
class ScimBridgeAgentIMContext;
class ScimBridgeAgentMessenger;

class ScimBridgeAgentClientPeer
{

    public:

        static ScimBridgeAgentClientPeer *create (int input_fd, int output_fd, ScimBridgeAgentClientListener *kernel);

        virtual ~ScimBridgeAgentClientPeer () {};

        virtual  void commit (const ScimBridgeAgentIMContext &ic) throw (ScimBridgeAgentException) = 0;
        virtual void set_preedit_string (const ScimBridgeAgentIMContext &ic, const scim::WideString &string) throw (ScimBridgeAgentException) = 0;
        virtual void set_preedit_attributes (const ScimBridgeAgentIMContext &ic, const scim::AttributeList &attributes) throw (ScimBridgeAgentException) = 0;
        virtual void set_preedit_cursor_position (const ScimBridgeAgentIMContext &ic, int cursor_position) throw (ScimBridgeAgentException) = 0;
        virtual void set_preedit_shown (const ScimBridgeAgentIMContext &ic, bool shown) throw (ScimBridgeAgentException) = 0;
        virtual void update_preedit (const ScimBridgeAgentIMContext &ic) throw (ScimBridgeAgentException) = 0;
        virtual void forward_keyevent (const ScimBridgeAgentIMContext &ic, const scim::KeyEvent &keyevent) throw (ScimBridgeAgentException) = 0;
        virtual void beep (const ScimBridgeAgentIMContext &ic) throw (ScimBridgeAgentException) = 0;
        virtual bool get_surrounding_string (const ScimBridgeAgentIMContext &ic, scim::WideString &surrounding, size_t max_length, int &cursor_pos) throw (ScimBridgeAgentException) = 0;
        virtual  bool delete_surrounding_string (const ScimBridgeAgentIMContext &ic, size_t offset, size_t len) throw (ScimBridgeAgentException) = 0;

    protected:

        ScimBridgeAgentClientPeer () {};

};
#endif                                            /*SCIMBRIDGEAGENTCLIENTPEER_H_*/
