//
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Pierre-Aime Agnel
//
// This file is distributed under the same license as the Scilab package.
//

function fig_handle = createMainWindow(axes_size, fig_name, tag_name)
    fig_handle = figure( ...
        "dockable", "off", ...
        "infobar_visible", "off", ...
        "toolbar_visible", "off", ...
        "toolbar", "none", ...
        "menubar_visible", "off", ...
        "menubar", "none", ...
        "default_axes", "on", ...
        "layout", "none", ...
        "visible", "off", ...
        "immediate_drawing", "off", ...
        "background", -2, ...
        "figure_position", [0 0], ...
        "axes_size", axes_size, ...
        "figure_name", fig_name, ...
        "tag", tag_name);

    //The plot will be in the top 3/4 of the figure
    a = gca();
    a.axes_bounds = [0 0 1 2/3];
    a.tight_limits = "on";
endfunction

//Gui Creation: Plot zone and Param zone createion
//Plot zone is twice the height of Param zone
function [plot_frame, param_frame, button_frame] = create_gui(fig_handle)
    //Set the layout for the figure
    set(fig_handle, "layout", "gridbag");
    plot_frame = [];

    c = createConstraints("gridbag", [1 1 1 1], [1 1], "vertical", "left");
    //create false panel on the left to occupy the 3/4 of the screen (figure plot)
   empty_frame = uicontrol(fig_handle, "style", "frame", "constraints", c);

    c = createConstraints("gridbag", [1 2 1 1], [1 0.25], "both", "lower", [0 0], [0 150]);
    u = uicontrol(fig_handle, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "layout", "border", ...
        "constraints", c);

    c = createConstraints("border", "right", [20 0]);
    left = uicontrol(u, "style", "frame", "backgroundcolor", [1 1 1], "constraints", c);
    c = createConstraints("border", "left", [20 0]);
    right = uicontrol(u, "style", "frame", "backgroundcolor", [1 1 1], "constraints", c);

    //Border for the simulation Params
    b_f_simuParams = createBorderFont("", 18);
    b_l_simuParams = createBorder("line", "navy", 2);
    b_simuParams   = createBorder("titled", b_l_simuParams, _("Simulation Parameters"), "center", "top", b_f_simuParams, "navy");

    param_frame = uicontrol(u, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "border", b_simuParams, ...
        "tag", "param_frame");

    c = createConstraints("border", "bottom", [0 50]);
    button_frame = uicontrol(u, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", c, ...
        "tag", "button_frame");

endfunction

//Creates the parameter zone for all sim_param objects in the param_list
function create_param_zone(param_frame, param_list)
    //Set the layout for the param frame to a grid of the correct size 2 columns
    param_frame.layout = "gridbag";
    depth = ceil(size(param_list) / 2);

    //Creates the text and slider for each parameter
    for i = [1:depth]
        for j = [1 5]
            //Text on the left: name of the param
            if i == depth & j == 5 & (depth - size(param_list) / 2) > %eps
                c = createConstraints("gridbag", [6 i 4 1], [1 1], "both", "left", [0 5], [100 0])
                empty_frame = uicontrol(f, "style", "frame", "constraints", c, "horizontalalignment", "left");
            else
                if j == 1
                    param = param_list(i)
                else
                    param = param_list(depth + i)
                end

                c = createConstraints("gridbag", [j + 1 i 1 1], [1 1], "both", "left", [0 5], [75 0])
                name_p = uicontrol(param_frame, ...
                    "Style", "text", ...
                    "String", param.name + " ", ...
                    "BackgroundColor", [1 1 1], ...
                    "horizontalalignment", "right", ...
                    "constraints", c, ...
                    "tag", "text_" + param.tag);

                c = createConstraints("gridbag", [j + 2 i 1 1], [1 0], "both", "center", [0 5], [100 60])
                slider_p = uicontrol(param_frame, ...
                    "Style", "slider", ...
                    "Value", param.default, ...
                    "Min", param.range(1), ...
                    "Max", param.range(2), ...
                    "callback", "change_" + param.tag + "()", ...
                    "constraints", c, ...
                    "horizontalalignment", "center", ...
                    "backgroundcolor", [1 1 1], ...
                    "tag", "slider_" + param.tag);

                c = createConstraints("gridbag", [j + 3 i 1 1], [1 1], "both", "center", [0 5], [25 0])
                value_p = uicontrol(param_frame, ...
                    "Style", "text", ...
                    "String", string(param.default), ...
                    "BackgroundColor", [1 1 1], ...
                    "constraints", c, ...
                    "foregroundcolor", [0 0 1], ...
                    "horizontalalignment", "center", ...
                    "tag", "value_" + param.tag);

                c = createConstraints("gridbag", [j + 4 i 1 1], [1 1], "both", "right", [0 5], [25 0])
                unite_p = uicontrol(param_frame, ...
                    "Style", "text", ...
                    "String", param.unit, ...
                    "BackgroundColor", [1 1 1], ...
                    "constraints", c, ...
                    "horizontalalignment", "left", ...
                    "tag", "unite_" + param.tag);
            end
        end
    end
endfunction

function create_buttons(button_frame)
    //Adds buttons in the middle of the frame
    set(button_frame, "layout", "gridbag");
    set(button_frame, "layout_options", createLayoutOptions("gridbag"));
    c = createConstraints("gridbag", [1 1 1 1], [1 0], "horizontal", "center");

    esthetic = uicontrol(button_frame, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", c);

    //Place each button inside buttons
    c_buttons = createConstraints("gridbag", [2 1 1 1], [1 0], "both", "center");
    start_button = uicontrol(button_frame, ...
        "Style", "pushbutton", ...
        "String", "Start", ...
        "Fontsize", 14, ...
        "callback", "start_simu()", ...
        "constraints", c_buttons, ...
        "tag", "start_button");

    c_buttons = createConstraints("gridbag", [3 1 1 1], [1 0], "both", "center");
    esthetic = uicontrol(button_frame, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", c_buttons);

    c_buttons = createConstraints("gridbag", [4 1 1 1], [1 0], "both", "center");

    stop_button = uicontrol(button_frame, ...
        "Style", "pushbutton", ...
        "String", "Stop", ...
        "Fontsize", 14, ...
        "callback", "stop_simu", ...
        "callback_type", 10, ...
        "constraints", c_buttons, ...
        "tag", "stop_button");

    c_buttons = createConstraints("gridbag", [5 1 1 1], [1 0], "both", "center");
    esthetic = uicontrol(button_frame, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", c_buttons);

    c_buttons = createConstraints("gridbag", [6 1 1 1], [1 0], "both", "center");
    clear_button = uicontrol(button_frame, ...
        "Style", "pushbutton", ...
        "String", "Clear", ...
        "Fontsize", 14, ...
        "callback", "clear_simu", ...
        "callback_type", 10, ...
        "constraints", c_buttons, ...
        "tag", "clear_button");

    //esthetic panel on the right
    c = createConstraints("gridbag", [7 1 1 1], [1 0], "both", "right");
    esthetic = uicontrol(button_frame, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", c);
endfunction
