// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2010 - DIGITEO - Allan CORNET
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- Non-regression test for bug 7603 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=7603
//
// <-- Short Description -->
// Fortran code generated by intersci did not build with a fortran or F2C compiler on Windows.
//

if getos() == 'Windows' then

  copyfile(SCI+"/modules/intersci/tests/nonreg_tests/bug7603.desc", TMPDIR+"/bug7603.desc");
  copyfile(SCI+"/modules/intersci/tests/nonreg_tests/bug7603function.c", TMPDIR+"/bug7603function.c");
  cd(TMPDIR);
  
  // check intersci generation
  s1 = dos(SCI + '/modules/intersci/bin/intersci.exe bug7603');
  if s1 <> %t then pause, end
  
  // check f2c conversion works
  s2 = dos(SCI + "/bin/f2c.exe -I" + SCI + "/modules/core/includes " + "bug7603.f");
  if s2 <> %t then pause, end
  if isfile("bug7603.c") then
    mdelete("bug7603.c");
  end
  
  // check build
  ilib_verbose(0);
  ierr = execstr("ilib_build(""gw_bug7603"", [""bug7603"", ""bug7603_""], [""bug7603.f"", ""bug7603function.c""], []);", "errcatch");
  if ierr <> 0 then pause,end

end
