#include "CallScilabBridge.hxx"
/* Generated by GIWS (version 2.0.1) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/CallScilabBridge.giws.xml 
*/
/*

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_gui_bridge {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * CallScilabBridge::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

CallScilabBridge::~CallScilabBridge() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
CallScilabBridge::CallScilabBridge(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidsetMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID=NULL;
voidsetSubMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjintintjbooleanbooleanID=NULL;
voidremoveMenujstringjava_lang_Stringjstringjava_lang_StringID=NULL;
jstringdisplayAndWaitContextMenujstringjava_lang_StringID=NULL;
jintnewMessageBoxID=NULL;
voidsetMessageBoxTitlejintintjstringjava_lang_StringID=NULL;
voidsetMessageBoxMessagejintintjstringjava_lang_StringID=NULL;
voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidmessageBoxDisplayAndWaitjintintID=NULL;
jintgetMessageBoxSelectedButtonjintintID=NULL;
voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID=NULL;
jintArray_getMessageBoxUserSelectedButtonsjintintID=NULL;
voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jobjectArray_getMessageBoxValuejintintID=NULL;
jintgetMessageBoxValueSizejintintID=NULL;
voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintgetMessageBoxSelectedItemjintintID=NULL;
voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxModaljintintjbooleanbooleanID=NULL;
voidsetMessageBoxIconjintintjstringjava_lang_StringID=NULL;
jbooleanisToolbarVisiblejstringjava_lang_StringID=NULL;
voidsetToolbarVisiblejstringjava_lang_StringjbooleanbooleanID=NULL;
voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID=NULL;
jintnewExportFileChooserjstringjava_lang_StringID=NULL;
jintnewFontChooserID=NULL;
voidfontChooserDisplayAndWaitjintintID=NULL;
voidsetFontChooserFontNamejintintjstringjava_lang_StringID=NULL;
voidsetFontChooserFontSizejintintjintintID=NULL;
voidsetFontChooserBoldjintintjbooleanbooleanID=NULL;
voidsetFontChooserItalicjintintjbooleanbooleanID=NULL;
jstringgetFontChooserFontNamejintintID=NULL;
jintgetFontChooserFontSizejintintID=NULL;
jbooleangetFontChooserBoldjintintID=NULL;
jbooleangetFontChooserItalicjintintID=NULL;
jintnewColorChooserID=NULL;
voidcolorChooserDisplayAndWaitjintintID=NULL;
voidsetColorChooserDefaultColorjintintjintArray_intintID=NULL;
jintArray_getColorChooserSelectedColorjintintID=NULL;
voidsetColorChooserTitlejintintjstringjava_lang_StringID=NULL;
jstringgetClipboardContentsID=NULL;
voidpasteClipboardIntoConsoleID=NULL;
voidcopyConsoleSelectionID=NULL;
voidemptyClipboardID=NULL;
voidsetClipboardContentsjstringjava_lang_StringID=NULL;
voidcopyFigureToClipBoardjintintID=NULL;
jintgetScreenResolutionID=NULL;
jdoublegetScreenWidthID=NULL;
jdoublegetScreenHeightID=NULL;
jintgetScreenDepthID=NULL;
jbooleanprintFigurejstringjava_lang_StringjbooleanbooleanjbooleanbooleanID=NULL;
jbooleanprintFilejstringjava_lang_StringID=NULL;
jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
jbooleanpageSetupID=NULL;
voidrequestFocusjstringjava_lang_StringID=NULL;
voidraiseWindowjintintID=NULL;
voiduseCanvasForDisplayjbooleanbooleanID=NULL;
jbooleanuseCanvasForDisplayID=NULL;
voidscilabAboutBoxID=NULL;
voidfireClosingFinishedjstringjava_lang_StringID=NULL;


}

CallScilabBridge::CallScilabBridge(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidsetMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID=NULL;
voidsetSubMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjintintjbooleanbooleanID=NULL;
voidremoveMenujstringjava_lang_Stringjstringjava_lang_StringID=NULL;
jstringdisplayAndWaitContextMenujstringjava_lang_StringID=NULL;
jintnewMessageBoxID=NULL;
voidsetMessageBoxTitlejintintjstringjava_lang_StringID=NULL;
voidsetMessageBoxMessagejintintjstringjava_lang_StringID=NULL;
voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidmessageBoxDisplayAndWaitjintintID=NULL;
jintgetMessageBoxSelectedButtonjintintID=NULL;
voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID=NULL;
jintArray_getMessageBoxUserSelectedButtonsjintintID=NULL;
voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jobjectArray_getMessageBoxValuejintintID=NULL;
jintgetMessageBoxValueSizejintintID=NULL;
voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintgetMessageBoxSelectedItemjintintID=NULL;
voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidsetMessageBoxModaljintintjbooleanbooleanID=NULL;
voidsetMessageBoxIconjintintjstringjava_lang_StringID=NULL;
jbooleanisToolbarVisiblejstringjava_lang_StringID=NULL;
voidsetToolbarVisiblejstringjava_lang_StringjbooleanbooleanID=NULL;
voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID=NULL;
jintnewExportFileChooserjstringjava_lang_StringID=NULL;
jintnewFontChooserID=NULL;
voidfontChooserDisplayAndWaitjintintID=NULL;
voidsetFontChooserFontNamejintintjstringjava_lang_StringID=NULL;
voidsetFontChooserFontSizejintintjintintID=NULL;
voidsetFontChooserBoldjintintjbooleanbooleanID=NULL;
voidsetFontChooserItalicjintintjbooleanbooleanID=NULL;
jstringgetFontChooserFontNamejintintID=NULL;
jintgetFontChooserFontSizejintintID=NULL;
jbooleangetFontChooserBoldjintintID=NULL;
jbooleangetFontChooserItalicjintintID=NULL;
jintnewColorChooserID=NULL;
voidcolorChooserDisplayAndWaitjintintID=NULL;
voidsetColorChooserDefaultColorjintintjintArray_intintID=NULL;
jintArray_getColorChooserSelectedColorjintintID=NULL;
voidsetColorChooserTitlejintintjstringjava_lang_StringID=NULL;
jstringgetClipboardContentsID=NULL;
voidpasteClipboardIntoConsoleID=NULL;
voidcopyConsoleSelectionID=NULL;
voidemptyClipboardID=NULL;
voidsetClipboardContentsjstringjava_lang_StringID=NULL;
voidcopyFigureToClipBoardjintintID=NULL;
jintgetScreenResolutionID=NULL;
jdoublegetScreenWidthID=NULL;
jdoublegetScreenHeightID=NULL;
jintgetScreenDepthID=NULL;
jbooleanprintFigurejstringjava_lang_StringjbooleanbooleanjbooleanbooleanID=NULL;
jbooleanprintFilejstringjava_lang_StringID=NULL;
jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
jbooleanpageSetupID=NULL;
voidrequestFocusjstringjava_lang_StringID=NULL;
voidraiseWindowjintintID=NULL;
voiduseCanvasForDisplayjbooleanbooleanID=NULL;
jbooleanuseCanvasForDisplayID=NULL;
voidscilabAboutBoxID=NULL;
voidfireClosingFinishedjstringjava_lang_StringID=NULL;


}

// Generic methods

void CallScilabBridge::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CallScilabBridge");
}
}

void CallScilabBridge::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CallScilabBridge");
}
}
// Method(s)

void CallScilabBridge::setMenuEnabled (JavaVM * jvm_, char const* parentUID, char const* menuName, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setMenuEnabled", "(Ljava/lang/String;Ljava/lang/String;Z)V" ) ;
if (voidsetMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMenuEnabled");
}

jstring parentUID_ = curEnv->NewStringUTF( parentUID );
if (parentUID != NULL && parentUID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring menuName_ = curEnv->NewStringUTF( menuName );
if (menuName != NULL && menuName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID ,parentUID_, menuName_, status_);
                        curEnv->DeleteLocalRef(parentUID_);
curEnv->DeleteLocalRef(menuName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setSubMenuEnabled (JavaVM * jvm_, char const* parentUID, char const* menuName, int position, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSubMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setSubMenuEnabled", "(Ljava/lang/String;Ljava/lang/String;IZ)V" ) ;
if (voidsetSubMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setSubMenuEnabled");
}

jstring parentUID_ = curEnv->NewStringUTF( parentUID );
if (parentUID != NULL && parentUID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring menuName_ = curEnv->NewStringUTF( menuName );
if (menuName != NULL && menuName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetSubMenuEnabledjstringjava_lang_Stringjstringjava_lang_StringjintintjbooleanbooleanID ,parentUID_, menuName_, position, status_);
                        curEnv->DeleteLocalRef(parentUID_);
curEnv->DeleteLocalRef(menuName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::removeMenu (JavaVM * jvm_, char const* parentUID, char const* menuName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveMenujstringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "removeMenu", "(Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidremoveMenujstringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeMenu");
}

jstring parentUID_ = curEnv->NewStringUTF( parentUID );
if (parentUID != NULL && parentUID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring menuName_ = curEnv->NewStringUTF( menuName );
if (menuName != NULL && menuName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidremoveMenujstringjava_lang_Stringjstringjava_lang_StringID ,parentUID_, menuName_);
                        curEnv->DeleteLocalRef(parentUID_);
curEnv->DeleteLocalRef(menuName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallScilabBridge::displayAndWaitContextMenu (JavaVM * jvm_, char const* UID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringdisplayAndWaitContextMenujstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "displayAndWaitContextMenu", "(Ljava/lang/String;)Ljava/lang/String;" ) ;
if (jstringdisplayAndWaitContextMenujstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "displayAndWaitContextMenu");
}

jstring UID_ = curEnv->NewStringUTF( UID );
if (UID != NULL && UID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringdisplayAndWaitContextMenujstringjava_lang_StringID ,UID_));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(UID_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

int CallScilabBridge::newMessageBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewMessageBoxID = curEnv->GetStaticMethodID(cls, "newMessageBox", "()I" ) ;
if (jintnewMessageBoxID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newMessageBox");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewMessageBoxID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setMessageBoxTitle (JavaVM * jvm_, int id, char const* title){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxTitlejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxTitle", "(ILjava/lang/String;)V" ) ;
if (voidsetMessageBoxTitlejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxTitle");
}

jstring title_ = curEnv->NewStringUTF( title );
if (title != NULL && title_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxTitlejintintjstringjava_lang_StringID ,id, title_);
                        curEnv->DeleteLocalRef(title_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxMessage (JavaVM * jvm_, int id, char const* message){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxMessagejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxMessage", "(ILjava/lang/String;)V" ) ;
if (voidsetMessageBoxMessagejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxMessage");
}

jstring message_ = curEnv->NewStringUTF( message );
if (message != NULL && message_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxMessagejintintjstringjava_lang_StringID ,id, message_);
                        curEnv->DeleteLocalRef(message_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxMessage (JavaVM * jvm_, int id, char const* const* message, int messageSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxMessage", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxMessage");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray message_ = curEnv->NewObjectArray( messageSize, stringArrayClass, NULL);
if (message_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < messageSize; i++)
{
jstring TempString = curEnv->NewStringUTF( message[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( message_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxMessagejintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, message_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(message_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::messageBoxDisplayAndWait (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidmessageBoxDisplayAndWaitjintintID = curEnv->GetStaticMethodID(cls, "messageBoxDisplayAndWait", "(I)V" ) ;
if (voidmessageBoxDisplayAndWaitjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "messageBoxDisplayAndWait");
}

                         curEnv->CallStaticVoidMethod(cls, voidmessageBoxDisplayAndWaitjintintID ,id);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getMessageBoxSelectedButton (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMessageBoxSelectedButtonjintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxSelectedButton", "(I)I" ) ;
if (jintgetMessageBoxSelectedButtonjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxSelectedButton");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetMessageBoxSelectedButtonjintintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setMessageBoxDefaultSelectedButtons (JavaVM * jvm_, int id, int const* index, int indexSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "setMessageBoxDefaultSelectedButtons", "(I[I)V" ) ;
if (voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxDefaultSelectedButtons");
}

jintArray index_ = curEnv->NewIntArray( indexSize ) ;

if (index_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( index_, 0, indexSize, (jint*)(index) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxDefaultSelectedButtonsjintintjintArray_intintID ,id, index_);
                        curEnv->DeleteLocalRef(index_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getMessageBoxUserSelectedButtons (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getMessageBoxUserSelectedButtonsjintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxUserSelectedButtons", "(I)[I" ) ;
if (jintArray_getMessageBoxUserSelectedButtonsjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxUserSelectedButtons");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getMessageBoxUserSelectedButtonsjintintID ,id));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setMessageBoxButtonsLabels (JavaVM * jvm_, int id, char const* const* labels, int labelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxButtonsLabels", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxButtonsLabels");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray labels_ = curEnv->NewObjectArray( labelsSize, stringArrayClass, NULL);
if (labels_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < labelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( labels[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( labels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxButtonsLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, labels_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(labels_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxInitialValue (JavaVM * jvm_, int id, char const* const* value, int valueSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxInitialValue", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxInitialValue");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray value_ = curEnv->NewObjectArray( valueSize, stringArrayClass, NULL);
if (value_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < valueSize; i++)
{
jstring TempString = curEnv->NewStringUTF( value[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( value_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxInitialValuejintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, value_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(value_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char** CallScilabBridge::getMessageBoxValue (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArray_getMessageBoxValuejintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxValue", "(I)[Ljava/lang/String;" ) ;
if (jobjectArray_getMessageBoxValuejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxValue");
}

                        jobjectArray res =  static_cast<jobjectArray>( curEnv->CallStaticObjectMethod(cls, jobjectArray_getMessageBoxValuejintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { int lenRow;
 lenRow = curEnv->GetArrayLength(res);

char **arrayOfString;
arrayOfString = new char *[lenRow];
for (jsize i = 0; i < lenRow; i++){
jstring resString = reinterpret_cast<jstring>(curEnv->GetObjectArrayElement(res, i));
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] arrayOfString;
                                throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

int CallScilabBridge::getMessageBoxValueSize (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMessageBoxValueSizejintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxValueSize", "(I)I" ) ;
if (jintgetMessageBoxValueSizejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxValueSize");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetMessageBoxValueSizejintintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setMessageBoxListBoxItems (JavaVM * jvm_, int id, char const* const* items, int itemsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxListBoxItems", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxListBoxItems");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray items_ = curEnv->NewObjectArray( itemsSize, stringArrayClass, NULL);
if (items_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < itemsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( items[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( items_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxListBoxItemsjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, items_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(items_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getMessageBoxSelectedItem (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMessageBoxSelectedItemjintintID = curEnv->GetStaticMethodID(cls, "getMessageBoxSelectedItem", "(I)I" ) ;
if (jintgetMessageBoxSelectedItemjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getMessageBoxSelectedItem");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetMessageBoxSelectedItemjintintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::setMessageBoxLineLabels (JavaVM * jvm_, int id, char const* const* labels, int labelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxLineLabels", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxLineLabels");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray labels_ = curEnv->NewObjectArray( labelsSize, stringArrayClass, NULL);
if (labels_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < labelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( labels[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( labels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxLineLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, labels_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(labels_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxColumnLabels (JavaVM * jvm_, int id, char const* const* labels, int labelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxColumnLabels", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxColumnLabels");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray labels_ = curEnv->NewObjectArray( labelsSize, stringArrayClass, NULL);
if (labels_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < labelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( labels[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( labels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxColumnLabelsjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, labels_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(labels_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxDefaultInput (JavaVM * jvm_, int id, char const* const* values, int valuesSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxDefaultInput", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxDefaultInput");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray values_ = curEnv->NewObjectArray( valuesSize, stringArrayClass, NULL);
if (values_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < valuesSize; i++)
{
jstring TempString = curEnv->NewStringUTF( values[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( values_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxDefaultInputjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, values_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(values_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxModal (JavaVM * jvm_, int id, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxModaljintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setMessageBoxModal", "(IZ)V" ) ;
if (voidsetMessageBoxModaljintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxModal");
}

jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxModaljintintjbooleanbooleanID ,id, status_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setMessageBoxIcon (JavaVM * jvm_, int id, char const* name){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxIconjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setMessageBoxIcon", "(ILjava/lang/String;)V" ) ;
if (voidsetMessageBoxIconjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setMessageBoxIcon");
}

jstring name_ = curEnv->NewStringUTF( name );
if (name != NULL && name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxIconjintintjstringjava_lang_StringID ,id, name_);
                        curEnv->DeleteLocalRef(name_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

bool CallScilabBridge::isToolbarVisible (JavaVM * jvm_, char const* parentUID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisToolbarVisiblejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "isToolbarVisible", "(Ljava/lang/String;)Z" ) ;
if (jbooleanisToolbarVisiblejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isToolbarVisible");
}

jstring parentUID_ = curEnv->NewStringUTF( parentUID );
if (parentUID != NULL && parentUID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisToolbarVisiblejstringjava_lang_StringID ,parentUID_));
                        curEnv->DeleteLocalRef(parentUID_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::setToolbarVisible (JavaVM * jvm_, char const* parentUID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetToolbarVisiblejstringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setToolbarVisible", "(Ljava/lang/String;Z)V" ) ;
if (voidsetToolbarVisiblejstringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setToolbarVisible");
}

jstring parentUID_ = curEnv->NewStringUTF( parentUID );
if (parentUID != NULL && parentUID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetToolbarVisiblejstringjava_lang_StringjbooleanbooleanID ,parentUID_, status_);
                        curEnv->DeleteLocalRef(parentUID_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::launchHelpBrowser (JavaVM * jvm_, char const* const* helps, int helpsSize, char const* language){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "launchHelpBrowser", "([Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "launchHelpBrowser");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray helps_ = curEnv->NewObjectArray( helpsSize, stringArrayClass, NULL);
if (helps_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < helpsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( helps[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( helps_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring language_ = curEnv->NewStringUTF( language );
if (language != NULL && language_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidlaunchHelpBrowserjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID ,helps_, language_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(helps_);
curEnv->DeleteLocalRef(language_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::searchKeyword (JavaVM * jvm_, char const* const* helps, int helpsSize, char const* keyword, char const* language, bool fullText){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "searchKeyword", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V" ) ;
if (voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "searchKeyword");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray helps_ = curEnv->NewObjectArray( helpsSize, stringArrayClass, NULL);
if (helps_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < helpsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( helps[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( helps_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring keyword_ = curEnv->NewStringUTF( keyword );
if (keyword != NULL && keyword_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring language_ = curEnv->NewStringUTF( language );
if (language != NULL && language_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean fullText_ = (static_cast<bool>(fullText) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsearchKeywordjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringjbooleanbooleanID ,helps_, keyword_, language_, fullText_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(helps_);
curEnv->DeleteLocalRef(keyword_);
curEnv->DeleteLocalRef(language_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::newExportFileChooser (JavaVM * jvm_, char const* figureUID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewExportFileChooserjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "newExportFileChooser", "(Ljava/lang/String;)I" ) ;
if (jintnewExportFileChooserjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newExportFileChooser");
}

jstring figureUID_ = curEnv->NewStringUTF( figureUID );
if (figureUID != NULL && figureUID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewExportFileChooserjstringjava_lang_StringID ,figureUID_));
                        curEnv->DeleteLocalRef(figureUID_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::newFontChooser (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewFontChooserID = curEnv->GetStaticMethodID(cls, "newFontChooser", "()I" ) ;
if (jintnewFontChooserID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newFontChooser");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewFontChooserID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::fontChooserDisplayAndWait (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidfontChooserDisplayAndWaitjintintID = curEnv->GetStaticMethodID(cls, "fontChooserDisplayAndWait", "(I)V" ) ;
if (voidfontChooserDisplayAndWaitjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "fontChooserDisplayAndWait");
}

                         curEnv->CallStaticVoidMethod(cls, voidfontChooserDisplayAndWaitjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFontChooserFontName (JavaVM * jvm_, int objID, char const* fontName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserFontNamejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setFontChooserFontName", "(ILjava/lang/String;)V" ) ;
if (voidsetFontChooserFontNamejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFontChooserFontName");
}

jstring fontName_ = curEnv->NewStringUTF( fontName );
if (fontName != NULL && fontName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserFontNamejintintjstringjava_lang_StringID ,objID, fontName_);
                        curEnv->DeleteLocalRef(fontName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFontChooserFontSize (JavaVM * jvm_, int objID, int fontSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserFontSizejintintjintintID = curEnv->GetStaticMethodID(cls, "setFontChooserFontSize", "(II)V" ) ;
if (voidsetFontChooserFontSizejintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFontChooserFontSize");
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserFontSizejintintjintintID ,objID, fontSize);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFontChooserBold (JavaVM * jvm_, int objID, bool bold){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserBoldjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setFontChooserBold", "(IZ)V" ) ;
if (voidsetFontChooserBoldjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFontChooserBold");
}

jboolean bold_ = (static_cast<bool>(bold) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserBoldjintintjbooleanbooleanID ,objID, bold_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setFontChooserItalic (JavaVM * jvm_, int objID, bool italic){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserItalicjintintjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "setFontChooserItalic", "(IZ)V" ) ;
if (voidsetFontChooserItalicjintintjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setFontChooserItalic");
}

jboolean italic_ = (static_cast<bool>(italic) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserItalicjintintjbooleanbooleanID ,objID, italic_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallScilabBridge::getFontChooserFontName (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetFontChooserFontNamejintintID = curEnv->GetStaticMethodID(cls, "getFontChooserFontName", "(I)Ljava/lang/String;" ) ;
if (jstringgetFontChooserFontNamejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFontChooserFontName");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetFontChooserFontNamejintintID ,objID));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

int CallScilabBridge::getFontChooserFontSize (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFontChooserFontSizejintintID = curEnv->GetStaticMethodID(cls, "getFontChooserFontSize", "(I)I" ) ;
if (jintgetFontChooserFontSizejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFontChooserFontSize");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetFontChooserFontSizejintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

bool CallScilabBridge::getFontChooserBold (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleangetFontChooserBoldjintintID = curEnv->GetStaticMethodID(cls, "getFontChooserBold", "(I)Z" ) ;
if (jbooleangetFontChooserBoldjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFontChooserBold");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleangetFontChooserBoldjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::getFontChooserItalic (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleangetFontChooserItalicjintintID = curEnv->GetStaticMethodID(cls, "getFontChooserItalic", "(I)Z" ) ;
if (jbooleangetFontChooserItalicjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFontChooserItalic");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleangetFontChooserItalicjintintID ,objID));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

int CallScilabBridge::newColorChooser (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewColorChooserID = curEnv->GetStaticMethodID(cls, "newColorChooser", "()I" ) ;
if (jintnewColorChooserID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "newColorChooser");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintnewColorChooserID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void CallScilabBridge::colorChooserDisplayAndWait (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcolorChooserDisplayAndWaitjintintID = curEnv->GetStaticMethodID(cls, "colorChooserDisplayAndWait", "(I)V" ) ;
if (voidcolorChooserDisplayAndWaitjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "colorChooserDisplayAndWait");
}

                         curEnv->CallStaticVoidMethod(cls, voidcolorChooserDisplayAndWaitjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setColorChooserDefaultColor (JavaVM * jvm_, int objID, int const* rgb, int rgbSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetColorChooserDefaultColorjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "setColorChooserDefaultColor", "(I[I)V" ) ;
if (voidsetColorChooserDefaultColorjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setColorChooserDefaultColor");
}

jintArray rgb_ = curEnv->NewIntArray( rgbSize ) ;

if (rgb_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( rgb_, 0, rgbSize, (jint*)(rgb) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetColorChooserDefaultColorjintintjintArray_intintID ,objID, rgb_);
                        curEnv->DeleteLocalRef(rgb_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int* CallScilabBridge::getColorChooserSelectedColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArray_getColorChooserSelectedColorjintintID = curEnv->GetStaticMethodID(cls, "getColorChooserSelectedColor", "(I)[I" ) ;
if (jintArray_getColorChooserSelectedColorjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getColorChooserSelectedColor");
}

                        jintArray res =  static_cast<jintArray>( curEnv->CallStaticObjectMethod(cls, jintArray_getColorChooserSelectedColorjintintID ,objID));
                        if (res == NULL) { return NULL; }
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}int lenRow;
 lenRow = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* GetPrimitiveArrayCritical is faster than getXXXArrayElements */
jint *resultsArray = static_cast<jint *>(curEnv->GetPrimitiveArrayCritical(res, &isCopy));
int* myArray= new int[ lenRow];

for (jsize i = 0; i <  lenRow; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myArray;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myArray;

}

void CallScilabBridge::setColorChooserTitle (JavaVM * jvm_, int objID, char const* title){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetColorChooserTitlejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setColorChooserTitle", "(ILjava/lang/String;)V" ) ;
if (voidsetColorChooserTitlejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setColorChooserTitle");
}

jstring title_ = curEnv->NewStringUTF( title );
if (title != NULL && title_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetColorChooserTitlejintintjstringjava_lang_StringID ,objID, title_);
                        curEnv->DeleteLocalRef(title_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* CallScilabBridge::getClipboardContents (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetClipboardContentsID = curEnv->GetStaticMethodID(cls, "getClipboardContents", "()Ljava/lang/String;" ) ;
if (jstringgetClipboardContentsID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getClipboardContents");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetClipboardContentsID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

void CallScilabBridge::pasteClipboardIntoConsole (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidpasteClipboardIntoConsoleID = curEnv->GetStaticMethodID(cls, "pasteClipboardIntoConsole", "()V" ) ;
if (voidpasteClipboardIntoConsoleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "pasteClipboardIntoConsole");
}

                         curEnv->CallStaticVoidMethod(cls, voidpasteClipboardIntoConsoleID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::copyConsoleSelection (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcopyConsoleSelectionID = curEnv->GetStaticMethodID(cls, "copyConsoleSelection", "()V" ) ;
if (voidcopyConsoleSelectionID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "copyConsoleSelection");
}

                         curEnv->CallStaticVoidMethod(cls, voidcopyConsoleSelectionID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::emptyClipboard (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidemptyClipboardID = curEnv->GetStaticMethodID(cls, "emptyClipboard", "()V" ) ;
if (voidemptyClipboardID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "emptyClipboard");
}

                         curEnv->CallStaticVoidMethod(cls, voidemptyClipboardID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::setClipboardContents (JavaVM * jvm_, char const* text){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetClipboardContentsjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "setClipboardContents", "(Ljava/lang/String;)V" ) ;
if (voidsetClipboardContentsjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setClipboardContents");
}

jstring text_ = curEnv->NewStringUTF( text );
if (text != NULL && text_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetClipboardContentsjstringjava_lang_StringID ,text_);
                        curEnv->DeleteLocalRef(text_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::copyFigureToClipBoard (JavaVM * jvm_, int figID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcopyFigureToClipBoardjintintID = curEnv->GetStaticMethodID(cls, "copyFigureToClipBoard", "(I)V" ) ;
if (voidcopyFigureToClipBoardjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "copyFigureToClipBoard");
}

                         curEnv->CallStaticVoidMethod(cls, voidcopyFigureToClipBoardjintintID ,figID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int CallScilabBridge::getScreenResolution (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetScreenResolutionID = curEnv->GetStaticMethodID(cls, "getScreenResolution", "()I" ) ;
if (jintgetScreenResolutionID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getScreenResolution");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetScreenResolutionID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

double CallScilabBridge::getScreenWidth (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublegetScreenWidthID = curEnv->GetStaticMethodID(cls, "getScreenWidth", "()D" ) ;
if (jdoublegetScreenWidthID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getScreenWidth");
}

                        jdouble res =  static_cast<jdouble>( curEnv->CallStaticDoubleMethod(cls, jdoublegetScreenWidthID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

double CallScilabBridge::getScreenHeight (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublegetScreenHeightID = curEnv->GetStaticMethodID(cls, "getScreenHeight", "()D" ) ;
if (jdoublegetScreenHeightID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getScreenHeight");
}

                        jdouble res =  static_cast<jdouble>( curEnv->CallStaticDoubleMethod(cls, jdoublegetScreenHeightID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int CallScilabBridge::getScreenDepth (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetScreenDepthID = curEnv->GetStaticMethodID(cls, "getScreenDepth", "()I" ) ;
if (jintgetScreenDepthID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getScreenDepth");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetScreenDepthID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

bool CallScilabBridge::printFigure (JavaVM * jvm_, char const* figID, bool postScript, bool displayDialog){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanprintFigurejstringjava_lang_StringjbooleanbooleanjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "printFigure", "(Ljava/lang/String;ZZ)Z" ) ;
if (jbooleanprintFigurejstringjava_lang_StringjbooleanbooleanjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "printFigure");
}

jstring figID_ = curEnv->NewStringUTF( figID );
if (figID != NULL && figID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean postScript_ = (static_cast<bool>(postScript) ? JNI_TRUE : JNI_FALSE);

jboolean displayDialog_ = (static_cast<bool>(displayDialog) ? JNI_TRUE : JNI_FALSE);

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanprintFigurejstringjava_lang_StringjbooleanbooleanjbooleanbooleanID ,figID_, postScript_, displayDialog_));
                        curEnv->DeleteLocalRef(figID_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::printFile (JavaVM * jvm_, char const* fileName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanprintFilejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "printFile", "(Ljava/lang/String;)Z" ) ;
if (jbooleanprintFilejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "printFile");
}

jstring fileName_ = curEnv->NewStringUTF( fileName );
if (fileName != NULL && fileName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanprintFilejstringjava_lang_StringID ,fileName_));
                        curEnv->DeleteLocalRef(fileName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::printString (JavaVM * jvm_, char const* theString, char const* pageHeader){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "printString", "(Ljava/lang/String;Ljava/lang/String;)Z" ) ;
if (jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "printString");
}

jstring theString_ = curEnv->NewStringUTF( theString );
if (theString != NULL && theString_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring pageHeader_ = curEnv->NewStringUTF( pageHeader );
if (pageHeader != NULL && pageHeader_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanprintStringjstringjava_lang_Stringjstringjava_lang_StringID ,theString_, pageHeader_));
                        curEnv->DeleteLocalRef(theString_);
curEnv->DeleteLocalRef(pageHeader_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

bool CallScilabBridge::pageSetup (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanpageSetupID = curEnv->GetStaticMethodID(cls, "pageSetup", "()Z" ) ;
if (jbooleanpageSetupID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "pageSetup");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanpageSetupID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::requestFocus (JavaVM * jvm_, char const* objUID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrequestFocusjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "requestFocus", "(Ljava/lang/String;)V" ) ;
if (voidrequestFocusjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "requestFocus");
}

jstring objUID_ = curEnv->NewStringUTF( objUID );
if (objUID != NULL && objUID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidrequestFocusjstringjava_lang_StringID ,objUID_);
                        curEnv->DeleteLocalRef(objUID_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::raiseWindow (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidraiseWindowjintintID = curEnv->GetStaticMethodID(cls, "raiseWindow", "(I)V" ) ;
if (voidraiseWindowjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "raiseWindow");
}

                         curEnv->CallStaticVoidMethod(cls, voidraiseWindowjintintID ,objID);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::useCanvasForDisplay (JavaVM * jvm_, bool onOrOff){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduseCanvasForDisplayjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "useCanvasForDisplay", "(Z)V" ) ;
if (voiduseCanvasForDisplayjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "useCanvasForDisplay");
}

jboolean onOrOff_ = (static_cast<bool>(onOrOff) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voiduseCanvasForDisplayjbooleanbooleanID ,onOrOff_);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

bool CallScilabBridge::useCanvasForDisplay (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanuseCanvasForDisplayID = curEnv->GetStaticMethodID(cls, "useCanvasForDisplay", "()Z" ) ;
if (jbooleanuseCanvasForDisplayID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "useCanvasForDisplay");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanuseCanvasForDisplayID ));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void CallScilabBridge::scilabAboutBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidscilabAboutBoxID = curEnv->GetStaticMethodID(cls, "scilabAboutBox", "()V" ) ;
if (voidscilabAboutBoxID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "scilabAboutBox");
}

                         curEnv->CallStaticVoidMethod(cls, voidscilabAboutBoxID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void CallScilabBridge::fireClosingFinished (JavaVM * jvm_, char const* figUID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidfireClosingFinishedjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "fireClosingFinished", "(Ljava/lang/String;)V" ) ;
if (voidfireClosingFinishedjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "fireClosingFinished");
}

jstring figUID_ = curEnv->NewStringUTF( figUID );
if (figUID != NULL && figUID_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidfireClosingFinishedjstringjava_lang_StringID ,figUID_);
                        curEnv->DeleteLocalRef(figUID_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
