mode(-1);
// 
// -------------------------------------------------------------------------
// SWT - Scilab wavelet toolbox
// Copyright (C) 2005-2007  Scilab Wavelet Toolbox Team
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// -------------------------------------------------------------------------
//


// specific part
libname='libswt';
libtitle='SWT - Scilab Wavelet Toolbox 0.1.0-rc4';

// get the absolute path 
SWTDIR=get_absolute_file_path('loader.sce') + '/'; 
SWTDEMO=SWTDIR+'demos/swt.dem';


// add the help chapter
if getversion()=="scilab-2.7" then
   %helps = [%helps; SWTDIR+'man', libtitle]
else
   add_help_chapter(libtitle,SWTDIR+'man');
end

// load the demo
global demolist;
have_swt = 0;
for num=1:size(demolist, 1),
	if demolist(num,1)=='SWT' then
		have_swt = 1;
	end
end
if have_swt==0 then
	demolist = [demolist; 'SWT', SWTDIR+'/demos/swt.dem'];
end
clear have_swt num;

// ADD C routines
exec (SWTDIR+'loader_include.sce');

mess=[libtitle+' loaded';
    'Enter ""exec(SWTDEMO);"" for demonstrations.']

write(%io(2),'--------------------------------------------');
write(%io(2),mess);

clear libtitle mess
