// ==========================================================
// Definition of leap seconds (TAI - UTC) 
//
// Syntax :  
// data = [ tb te nbsec 
//          ...            ]
//
// tb: beginning of interval (julian days from 1950.0 0h UTC)
// te: end of interval (julian days from 1950.0 0h UTC)
// nbsec: number of leap seconds between UTC and TAI (s) 
//      = time of an event in the TAI time scale minus
//        time of the same event in the UTC time scale
//
// (scilab syntax)
//
// Note: 
// 
//       day D, 23h, 59mn       day D+1, 0h, 0mn        
//           60 sec utc            00 sec utc               
//           60+N sec tai          00+(N+1) sec tai               
//  ------------|---------------------|---------------> utc
//  <-------------------- N ----------[                 tai-utc
//                                    [------ N+1 ---->              
//
//                                    ^ 
//                                   tb
//
// ==========================================================


data = [ -%inf,   8035,   00.0 
          8035,   8217,   10.0 
          8217,   8401,   11.0 
          8401,   8766,   12.0 
          8766,   9131,   13.0 
          9131,   9496,   14.0 
          9496,   9862,   15.0 
          9862,  10227,   16.0 
         10227,  10592,   17.0 
         10592,  10957,   18.0 
         10957,  11504,   19.0 
         11504,  11869,   20.0 
         11869,  12234,   21.0 
         12234,  12965,   22.0 
         12965,  13879,   23.0 
         13879,  14610,   24.0 
         14610,  14975,   25.0 
         14975,  15522,   26.0 
         15522,  15887,   27.0 
         15887,  16252,   28.0 
         16252,  16801,   29.0 
         16801,  17348,   30.0 
         17348,  17897,   31.0    // from 1997/7/1 0h UTC
         17897,  20454,   32.0    // from 1999/1/1 0h UTC 
         20454,  21550,   33.0    // from 2006/1/1 0h UTC 
         21550,  22827,   34.0    // from 2009/1/1 0h UTC
         22827,  +%inf,   35.0    // from 2012/7/1 0h UTC
]

